package CorrectASSPcfg;
use strict qw(vars subs);

=head
# requires assp V2.8.1 build 23131 (at least !)
#
# If this Package is available, it will be loaded by assp and the sub set will be called, 
# after the configuration is parsed.
# You are free to modify any config parameter here - see the examples in 'sub set'.

# *********************************************************************************************************************************************
# hidden config variables that could be changed using this module CorrectASSPcfg.pm
# or that could be changed using a commandline switch like --enableCrashAnalyzer:=1
# the values shown are the default values
# *********************************************************************************************************************************************

# CrashAnalyzer related
$main::enableCrashAnalyzer = 0;            # (0/1) enable the automatic crash analyzer (CA)
$main::CrashAnalyzerTopCount = 10;         # (number > 0) number of records used for the CA top count
$main::CrashAnalyzerWouldBlock = 1;        # (0/1) block the mail if CA detects that the mail would crash ASSP

#IP related
$main::IPv6TestPort = '51965';             # (port number) the port number that is used at startup to bind IPv6 to - to check if IPv6 is available
$main::forceDNSv4:shared = 1;              # (0/1) force DNS queries to use IPv4 instead to try IPv6 first
$main::DNSresolverLifeTime = 3600;         # the max lifetime of a DNS-Resolver object and it's sockets in seconds
$main::ignorePrivilegedPorts:shared = 1;   # (0/1) ignore the check of privileged ports on nix systems
                                           # if assp runs as no root user and this is set to 0
                                           # a required renew of a listener at port 1-1023 will require a
                                           # assp restart
                                           
# Bayesian and HMM related
$main::HMMSequenceLength = 4;              # (number > 0) count of words used for a sequence
$main::HMMDBWords = 600;                   # (number > 0) number of words used per mail in rebuildspamdb
$main::BayesDomainPrior = 2;               # (number > 0) Bayesian/HMM domain entry priority (1 = lowest)
$main::BayesPrivatPrior = 3;               # (number > 0) Bayesian/HMM private/user entry priority (1 = lowest)
$main::debugWordEncoding = 0;              # (0/1) write/debug suspect word encodings to debug/_enc_susp.txt
$main::reportBadDetectedSpam = 1;          # (0/1) report mails to spamaddresses that are not detected as SPAM, to the rebuild process
$main::DoRBRed = 0;                        # (0/1) check relisted mails on rebuildspamdb (default 0 - 1 = skip rebuild for spam and notspam if red)
$main::DoRBWhite = 0;                      # (0/1) check whitelisted mails on rebuildspamdb (default 0 - 1 = skip rebuild for spam if white)
$main::DoRBBlack = 0;                      # (0/1) check blacklisted mails on rebuildspamdb (default 0 - 1 = skip rebuild for notspam if black)

# logging related
$main::AUTHLogUser = 0;                    # (0/1) write the username for AUTH (PLAIN/LOGIN) to maillog.txt
$main::AUTHLogPWD = 0;                     # (0/1) write the userpassword for AUTH (PLAIN) to maillog.txt
$main::Unidecode2Console = 0;              # (0/1) use Text::Unidecode to decode NONASCII characters to ASCII - if available  - if set - 'ConsoleCharset' is ignored
$main::AnalyzeLogRegex = 0;                # (0/1) enables enhanced regex analyzing (in console mode only)
$main::SysLogFormat = '';                  # possible values are '' , 'rfc3164' and 'rfc5424' - '' is default
$main::SysLogProto = 'udp';                # possible values are 'udp' , 'tcp' - 'udp' is default

# database related
$main::forceTrunc4ClearDB = 0;             # (0/1) try/force a 'TRUNCATE TABLE' instead of a 'DELETE FROM' - 'DELETE FROM' is used as fall back if the truncate fails
$main::DoSQL_LIKE = 1;                     # (0/1) do a 'DELETE FROM table WHERE pkey LIKE ?' to remove generic keys
$main::lockBDB = 0;                        # (0/1) use the CDB locking for BerkeleyDB (default = 0)
$main::BDBerrLog = 0;                      # (0/1) log BerkeleyDB errors in the related BDB-ENV -errfile .../BDB-error.txt (default = 0)
$main::lockDatabases = 0;                  # (0/1) locks all databases on access in every worker to prevent access violation
$main::DBCacheSize = 12;                   # (number > 0) database cache record count , if less it will be set to NumComWorkers * 2 + 8
$main::importDBShowProgress = 1;           # (0/1) show the progress in the maillog.txt while a DB-import is running - default is 1

# BlockReport security related
$main::BlockReportRequireSMIME = 0;        # (0/1/2/3) 1 = users, 2 = admins, 3 = users & admins
$main::emailIntSMIMEpubKeyPath = '';       # full path to EmailInterface cert-chain folder (file=emailaddress.pem)

$main::BlockReportRequirePass = 0;         # (0/1/2/3) 1 = users, 2 = admins, 3 = users & admins
$main::BlockReportUserPassword = '';       # the password must be anywhere starting in a line in the mail , one single password for all users
$main::BlockReportAdminPassword = {};      # the password must be anywhere starting in a line in the mail , every admin a password
                                           # definition as HASH: {'admin1emailaddress' => 'password1',
                                           #                      'admin2emailaddress' => 'password2'}
                                           # emailaddresses in lower case only !!
                                           #
                                           # passwords are NOT checked if SMIME is configured and is valid
                                           # passwords are ignored if SMIME failed
$main::enableBRtoggleButton = 1;           # (0/1) show the "toggle view" button in HTML BlockReports
$main::TargetBlank = {                     # where to include 'target="_blank"' in to HTML links - set the value to '' if 'target="_blank"' makes problems
    'BlockReport' => ' target="_blank"'    # BlockReports in WebMail-Clients like thunderbird, Roundcube Webmail and possibly others will need to set this to '' to make the resendlinks working
};
$main::toptencount = 10;                   # number > 0 - count of top x blocking statistic

# some more
$main::enablePermanentSSLContext = 1;      # (0/1) enable usage of permanent SSL Context - maxunused ($SSLContextMaxUnused) = 8 hours, max lifetime ($SSLContextMaxAge) = 1 day (default = 1)
$main::SPF_max_dns_interactive_terms = 15; # (number > 0) max_dns_interactive_terms max number of SPF-mechanism per domain (defaults to 10)
$main::SPF_max_allowed_IP = 0;             # maximum allowed IP (v4 and v6) adrresses in a SPF-record - default is 0 (disabled) - 2**17 seems to be OK
$main::disableEarlyTalker = 0;             # (0/1) disable the EarlyTalker check
$main::disableRFC2047 = 0;                 # (0/1) disable the RFC2047 check - undecoded subject contains non printable characters
$main::ignoreEarlySSLClientHelo = 0;       # (0/1) 1 - unexpected early SSLv23/TLS handshake Client-Helo-Frames are ignored , 0 - unexpected early SSLv23/TLS handshake Client-Helo-Frames are NOT ignored and the connection will be closed
$main::SpamCountNormCorrection = 0;        # (+/- number in percent) correct the required by X% higher
$main::FileScanCMDbuild_API;               # called if defined in FileScanOK with - $FileScanCMDbuild_API->(\$cmd,$this) - $cmd in place modification
$main::WebTrafficTimeout = 60;             # Transmission timeout in seconds for WebGUI and STATS connections
$main::DisableSyslogKeepAlive = 0;         # disable sending the keep alive '***assp&is%alive$$$' to the Syslog-Server
$main::noRelayNotSpamTag = 1;              # (0/1) do per default the NOTSPAMTAG for outgoing mails
$main::DKIMpassAction = 0;                 # (0..7) if DKIM pass: bit-0 = set rwlok to 1 (medium trust status), bit-1 = skip penaltybox-check, bit-2 = set IP-score to zero - default is 0 (no bits set)
$main::SPFpassAction = 0;                  # (0..7) if SPF  pass: bit-0 = set rwlok to 1 (medium trust status), bit-1 = skip penaltybox-check, bit-2 = set IP-score to zero - default is 0 (no bits set)
$main::removePersBlackOnAutoWhite = 1;     # (0/1) remove the PersBlack entry for autowhite addresses in outgoing mails
$main::resetIntCacheAtStartup = 1;         # (0/1) reset internal Caches at startup - default is 1 (YES)
$main::BackDNSTTL = 72;                    # (number > 0) time in hours after downloaded BackDNS entries will expire - default is 72 (3 days)

$main::checkCRLF = 1;                      # (0/1) check line terminator mistakes (single [CR] or [LF]) in SMTP-commands of incoming mails (correction is done every time) - default = 1
$main::CCignore8BitMIME = 0;               # (0/1) CCham, ForwardSpam and resend will ignore a missing 8BITMIME extension

$main::CCchangeMSGDate = 0;                ## (0..31) change the 'Date:' MIME-header on CCmail (sendHamInbound), ForwardSpam (sendAllSpam) and resend mail
                                           ## MS-Exchange may require this, because duplicate mails will be removed silently, if they contain an equal 'Date:...' MIME-header
                                           ## only the value for the seconds will be changed
                                           # bit 0 = 1 ( +1) -> set all bits (1 - 4) to 1 for backward compatibility ( same as 30 -> 2+4+8+16 )
                                           # bit 1 = 1 ( +2) -> force change at CCmail
                                           # bit 2 = 1 ( +4) -> force change at ForwardSpam
                                           # bit 3 = 1 ( +8) -> force change at resend mail
                                           # bit 4 = 1 (+16) -> general disable the automatic detection of a local MS-Exchange MTA by checking the SMTP banner / greeting
                                           ## The default is zero (0), which means: the 'Date:...' MIME-header is not forced to be changed in either case,
                                           ## but it will be changed, if a MS-Exchange MTA is detected using $ExchangeBannerRe against the SMTP banner / greeting.
                                           ## To disable this feature completely - set this value to 16.

$main::CCskipEmptyBody = 0;                # (0/1) do not forward mails with an empty body - default is 0 - forward anyway

$main::WriteRetryWaitTime = 1;             # seconds to wait before a SMTPwrite retry is done after an write error - default = 1

$main::resetMessageScore = 3;              #(0/1/2/3) reduce the MessageScore from SMTP handshake + header in header/body checks if whitelisting and/or noprocessing is detected in header/body (e.g. after the handshare)
                                           # 0 - disabled
                                           # 1 - outgoing/local mails
                                           # 2 - incoming mails
                                           # 3 - all mails

$main::reduceMS4NP = 100;                  # if resetMessageScore is enabled - the number of percent of the mails noprocessing score history used to reduce the message score
$main::reduceMS4WL = 100;                  # if resetMessageScore is enabled - the number of percent of the mails whitelisted score history used to reduce the message score

$main::WorkerScanConLimit = 1;             # (number >= 0) connection count limit in SMTP threads, before the thread moves the corpus filescan to high threads

$main::fakeAUTHsuccess = 0;                # (0/1/2) fake a 235 reply for AUTH success - move the connection to NULL - collect the mail in spam - used for honeypots - 2=with damping
$main::fakeAUTHsuccessSendFake = 0;        # (0/1) send the faked mails from the honeypot - make the spammers believe of success - attention: moves assp in to something like an open relay for these mails
$main::AUTHrequireTLSDelay = 5;            # (number) seconds to damp connections that used AUTH without using SSL (to prevent DoS)

$main::AUTHrelayTable = {};                # HASH to lookup authentication credentials for different relayHost(s)
                                           # if this HASH is empty or no host matches relayAuthUser and relayAuthPass are used
                                           # if any of relayAuthUser and relayAuthPass is not defined, no authentication will be done to the relayHost
                                           # example:
                                           # $AUTHrelayTable = {relayHost1:relayPort1 => [relayuser1,relaypass1],
                                           #                    relayHost2:relayPort2 => [relayuser2,relaypass2],
                                           #                    relayHost3:relayPort3 => [relayuser3,relaypass3]}

$main::delayGripLow = 0.4;                 # 0 <= value <= 1 IP's with a GripList value lower or equal to the defined value will be not delayed/greylisted - default is 0.4

$main::DelayUsesSPF = 1;                   # (0/1) use SPF-record IP's for delaying - default is 1

$main::protectASSP = 1;                    # (0/1) the internal 'rmtree' function will only remove files and folders in base/t[e]mp...  - other folders are ignored

$main::noSupportSummay = 0;                # (0/1) skips the output of a support summary in the configuration export function

$main::AllowCodeInRegex = 0;               # (0/1) allow the usage of executable perl code (?{code_to_run}) in regular expression - change this ONLY, if you really know what you do

$main::maxSameFileIncludes = 100;          # number of times the same include file can occure in a configuration file

$main::ignoreInvalidAddressNPWL = 3;       # (0/1/2/3) ignore invalid envelope recipients for whitelisted (2) or noprocessing (1) or both (3) senders and IP's (no score, no connection drop, no error count)

$main::DKIMCacheStrict = 1;                # (0/1) if a DKIM signature is found for a domain - all other mails from this domain will require a DKIM signature to pass the Pre-DKIM-Check

$main::checkLinuxENV = 0;                  # (0/1/2) check ulimit: (1) on nix and selinux , (2) on linux systems

$main::winSetMaxIO_DLL = 'msvcrt';         # the name of the microsoft C-runtime-library used by perl and/or perl-modules (Win32 only !!!) - default is msvcrt
                                           # If your perl uses (is compiled against) any other msvcrtXXX (for example: msvcrt160 or msvcrt100) - change this value, if
                                           # you want to set the maximum open files limit in the msvcrtXXX.
                                           # This value is ONLY used for the below purpose ($winSetMaxIO), it has no other effect !

$main::winSetMaxIO = 0;                    # (0/1/ 512 * 2**N) set the maximum open files limit (Win32 only !!!) in ($winSetMaxIO_DLL) msvcrt.dll (_getmaxstdio , _setmaxstdio)
                                           # 0 - use the default setting in msvcrt.dll (normaly set to 512)
                                           # 1 - find the maximum allowed value between 512 and 8192 and set it
                                           # 512 * 2**N - try to set the value as high as possible up to the given maximum (min 512 , max 8192, in 512 * 2**N [N=0..4])
                                           #          if the defined value is less than the current maximum, the setting will not be changed
                                           # Notice: PERLIO (perl compiled with -DUSE_PERLIO - check with :>perl -V) may define a different max open file limit for its
                                           #         IO's (defaults to 2048 because PERLIO_MAX_REFCOUNTABLE_FD=2048)
                                           #         - this limit is not affected by this value

$main::DoAVCache = 1800;                   # (number) store AntiVirus results in a Cache for this amount of seconds to avoid rescanning already scanned content - default = 1800

$main::genXOrigAuthResHeader = 1;          # (0/1) generate the X-Original-Authentication-Results header instead of Original-Authentication-Results - default = 1 (backward compatible)

%main::DoNoFromReplDomain = (              # replacement domains for the DoNoFrom check
    'google.com' => 'gmail.com',
    'googlemail.com' => 'gmail.com'
);
# *********************************************************************************************************************************************

$main::missingTLSError =                   # the SMTP-reply sent, if STARTTLS is not used but was forced by forceTLSIP
"502 <MYNAME> connected by 'IPCONNECTED' - 'RECEIVEDHELO'. The used command 'LASTCOMMAND: <MAILFROM>' is still not supported, because the connection is NOT secured by an encryption layer (TLS) - please use STARTTLS first FORCEEXPLAIN";

# some not RFC conform DMARC record subjects - like Amazon SES
@main::DMARCReportAddSubjectRe = ('(?:Report\s*domain:\s*\{$EmailDomainRe\}\s+Submitter:\s*\{Amazon\s+SES\}\s+Date:\s*\S+\s+Report-ID:.{2,})' ,
                                  '(?:^\s*\[BETA\] DMARC Report for)');

# comma separed list of host1,helo1,host2,helo2,.... for an exact host match in the first line of an X-Spam-Report: spamassassin header!
$main::trustedFWSF = 'mx.sourceforge.net,lists.sourceforge.net';

$main::consolidateWhitelList = 1;          # (0/1) consolidate the whitelistdb - removes unneeded entries

%main::workerSpeedUp = ( 10000 => 0,       # speed up some time critical task in these workers by temporary increasing the thread priority to the defined value
                         10001 => 0);      # should not be set below 0 (high prio) and not higher than 2 (low prio)

#######################################################
# see setServiceProperties                            #
#######################################################
$main::ServiceName;                        # to separate multiple instances on one host (windows only)
$main::ServiceDisplayName;                 # the windows SC service name                (windows only)
$main::ServiceTag;                         # a short version of the install folder      (windows and nix)
#######################################################

#######################################################
######################  HMM4ISP #######################
#######################################################
#                                                     #
# special setting to run assp in an ISP environment   #
#                                                     #
# spamDB and HMMdb are hold in each thread in a       #
# separate unshared memory area for very fast access  #
#                                                     #
# DNSBL(RBL), DNSWL(RWL), URIBL and SenderBase        #
# have to be provided using local DNS instances       #
#                                                     #
# the setting may be done here - but recommended is   #
# to use the module lib/CorrectASSPcfg.pm             #
#                                                     #
#######################################################
#######################################################
#######################################################

#######################################################
#                                                     #
# changing $HMM4ISP to 1 requires a very performant   #
# server, 64Bit hardware and at least 16GB RAM        #
# and SSD drives for the assp folder                  #
#                                                     #
# a 64Bit Perl 5.20 or higher is required             #
# Perl 5.32 or higher is recommended                  #
#                                                     #
# spamdb has to be set to use a plain file ,          #
# HMMusesBDB must be disabled ,                       #
# DoHMM must be enabled before $HMM4ISP is set to 1   #
#                                                     #
#######################################################
#                                                     #

$main::HMM4ISP = 0;                   # (0/1) if enabled and spamdb is not set to 'DB:' and HMMusesBDB is not set - the spamdbGroup (spamDB,HMMdb)
                                      # is hold in unshared private memory in each thread

#                                                     #
#######################################################
# advanced listen and rebuild setting to run assp     #
# (spamDB / HMMdb) in an ISP environment              #
#######################################################
#                                                     #

$main::Listen = 10;                   # concurrent pending connections without an socket->accept (default is 10) - seen up to 100
$main::RebuildStartScript;            # OS script to run before the rebuild starts - eg. to rsync the changed corpus from slave or cluster instances
$main::RebuildFinishScript;           # OS script to run after the rebuild finished - eg. to provide the DB's to slave or cluster instances
$main::threadReloadConfigDelay = 15;  # seconds to wait for each thread after the reload sign received, before reloading the config
                                      # and also the hashes - eg. the spamdbGroup
                                      # NOTICE: loading the DB's in to memory forces a high CPU load in each thread for some seconds!

#                                                     #
#######################################################
# ASN-provider special settings for local instances   #
#######################################################
#                                                     #
#                                                     #

$main::ASNProviderIPv4 = '.asn.routeviews.org |
                        .origin.asn.cymru.com';  # asn.routeviews.org equivalent provider for IPv4 ASN, if local (or others) DNS provides the ASN list
                                                 # combine multiple providers (for failover) by pipe '|' or comma ','
$main::ASNProviderIPv6 = '.origin6.asn.cymru.com'; # asn.routeviews.org equivalent provider for IPv6, if local (or others) DNS provides the ASN list
                                                 # combine multiple providers (for failover) by pipe '|' or comma ','

#######################################################
# DNSWL.ORG special settings for local instances      #
#######################################################
#                                                     #

$main::dnswlorg;                      # list.dnswl.org equivalent provider(s), if local DNS provides the dnswl.org list without having 'lists.dnswl.org'
                                      # in the zone name - separate by space or comma
$main::dnswlForceRWLOK = 4;           # if the list.dnswl.org trust is equal or higher than this value, RWLminhits is ignored
                                      # and the mail is processed with the highest trust 3 - default is 4, which can't be reached

#                                                     #
#######################################################
################## end HMM4ISP ########################
#######################################################

$main::threadCheckConfig = 0;         # set to 1 - all threads will check the assp.cfg file

$main::PBscoreNoDelay = 1;            # score noDelay messages

$main::dbBackupVersions = 10;         # (3- ...) min=3, default=10 - number of database backup and export version that are keeped

$main::reReadSpamFolderInterval = 300;# reread interval of the spamfolder content for MaxAllowedDups to prevent possible DoS attacks

                                      # RFC8689 SMTP Require TLS Option
$main::enableREQUIRETLS = 0;          # (0/1) enable testing of the REQUIRETLS implementation
$main::provideREQUIRETLS = 0;         # (0/1) include REQUIRETLS in to the EHLO reply if not already provided
$main::forceREQUIRETLS = 0;           # (0/1) include REQUIRETLS in to the MAIL FROM: command if not provided by the MTA

%main::NotifyFreqTF:shared = (        # one notification per timeframe in seconds per tag per worker
    'info'    => 60,                  # to prevent log flooding with equal loglines - default to 60 seconds for each tag
    'warning' => 60,
    'error'   => 60
);

$main::sortWeightedConfig = {};       # 'configParameter' => 1, '' => 1, ... - reverse sort regular expressions in this weighted config parameters

# ASSP_AFC - Plugin related
$ASSP_AFC::skipLockyCheck = 0;             # (0/1) skip the locky ransomeware virus detection in ASSP_AFC Plugin - default is zero - NOT RECOMMENDED to be set to 1
$ASSP_AFC::maxArcNameLength = 255;         # (number) max length of a file name part in a compressed file - 0 = disable check 

$ASSP_AFC::SkipExeTags = [];               # customized skip tags (like :MSOM) for external executable checks defined in lib/CorrectASSPcfg.pm
$ASSP_AFC::checkExeExternal;               # custom subroutine to check executables external (eg. lib/CorrectASSPcfg.pm) - $ASSP_AFC::checkExeExternal->($self,\$sk,\$buff,$raf,\$pdf) if the internal check has not found an executable
                                           # self - the ASSP_AFC object for this mail
                                           # the following paramters are refences to scalars
                                             # sk - active skip tags at runtime
                                             # buff - up to first 64 binary bytes of the attachment
                                             # raf - complete binary content of the attachment
                                             # pdf - decoded binary PDF content, if the attachment is a PDF , otherwise undef

$ASSP_AFC::checkExeExternalForce;          # same as $checkExeExternal - but called weather the internal check has found an executable or not - $ASSP_AFC::checkExeExternalForce->($self,\$sk,\$buff,$raf,\$pdf,\$type)
                                           # ....
                                           # type - contains the previous detected executable type description or undef

$ASSP_AFC::VBAcheck = 0;                   # enable(1)/disable(0) the executable VBA script check

%ASSP_AFC::libarchiveFatal = (             # if these FATAL values are returned by libachive, try to use the next decompression engine instead detecting a wrong attachment
-30 => 'Unrecognized archive format',       # first the error number
-25 => 'Unsupported.+?method'               # second a regex for the error text
);

%ASSP_AFC::libarchiveWarn = (              # if these WARN values are returned by libachive, try to use the next decompression engine instead detecting a wrong attachment
-20 => 'cannot be converted from|to current locale'       # first the error number
);                                                        # second a regex for the error text 

# *********************************************************************************************************************************************
=cut

sub set {
    mlog(0,"info: sub 'set' in module CorrectASSPcfg.pm is called");

#    $main::enableBRtoggleButton = 0;
#    mlog(0,"info: the 'toggle view' button in BlockReports is not shown");

#    $main::enableCrashAnalyzer = 1;
#    mlog(0,"info: enableCrashAnalyzer set to 1");

}

# use this sub to change the FilsScanCMD to your needs - modify ${$cmd} in place # uncommend the lines
#sub setFSCMD {
#    my ($cmd, $this) = @_;
#    my @rcpt = split(/ /o,$this->{rcpt});
#    my $sender = $this->{mailfrom};
#    my $ip = $this->{ip};
#    my $cip = $this->{cip};
#    
#    ${$cmd} = '';
#}

# use this sub to translate REPLY codes - $$reply has to be changed in place
# $this is the pointer to the $Con{$fh} Hash
#sub translateReply {
#    my ($this, $reply) = @_;
#    mlog(0,"info: see reply $$reply in translateReply");
#    $$reply =~ s/501 authentication failed/535 authentication failed/oi;
#} 

# use this sub to expand the executable detection of the ASSP_AFC Plugin V 4.39 and higher
# INPUT:
# $self - the ASSP_AFC OO object for the mail
# $skip - the possible setting to skip some executable detections (:WIN,:MSOM,MAC)
# $buff64 - the reference to a sring, that contains the first 64 byte of the attachment
# $full - the reference to a string, that contains the full attachment
#
# OUTPUT:
# $type - contains an executable description if detected, otherwise it must be undef
#sub AFC_Executable_Detection {
#    my ($self, $skip, $buf64 , $full) = @_;
#    my $type;
#    ...
#    do your stuff here, and set $type to a value, if an executabel is detected - otherwise leave $type at undef
#    for example:
#    $type = 'RTF file' if $skip !~ /:RTF/ && $$buff64 =~ /^\{\\rtf1\\/i;
#    ...
#    return $type;
#}

sub mlog {
    &main::mlog(@_);
} 

=head1 example

# example for client certificate GUI-logins - remove the 'head1' (above) and the 'cut' (below) lines 
# to enable the code
#
# read the SSL/TLS section in the GUI


# for example define the known good certificates
our %validCerts = (
    '/description=.../C=../ST=.../L=.../CN=.../emailAddress=.....' => {valid => 1, login => 'the_assp_admin_user'},
    '/serialNumber=..../CN=....'  => {valid => 1, login => 'root'},

    '/C=IL/O=StartCom Ltd./OU=Secure Digital Certificate Signing/CN=StartCom Class 1 Primary Intermediate Client CA' => {valid => 1},
    '/C=IL/O=StartCom Ltd./OU=Secure Digital Certificate Signing/CN=StartCom Class 2 Primary Intermediate Client CA' => {valid => 1},
    '/C=DE/O=Elster/OU=CA/CN=ElsterIdNrSoftCA' => {valid => 1},
);




sub checkWebSSLCert {
    my ($OpenSSLSays,$CertStackPtr,$DN,$OpenSSLError, $Cert)=@_;
#    mlog(0,"info: checkWebSSLCert called");
    my $subject = my $s = Net::SSLeay::X509_NAME_oneline(Net::SSLeay::X509_get_subject_name($Cert));
    $s =~ s/^\///o;
    my %cert = split(/\/|=/o,$s);
#    mlog(0,"cert: '$subject'")
    if ($validCerts{$subject}{valid}) {
        mlog(0,"info: ($OpenSSLSays) person '$cert{CN}' located in '$cert{C}/$cert{ST}/$cert{L}', email address '$cert{emailAddress}', logged in as 'root'")  if $validCerts{$subject}{login};
        mlog(0,"info: ($OpenSSLSays) person '$cert{CN}' located in '$cert{C}/$cert{ST}/$cert{L}', email address '$cert{emailAddress}'") if $cert{emailAddress} && ! $validCerts{$subject}{login};
        @main::ExtWebAuth = ($validCerts{$subject}{login}) if $validCerts{$subject}{login};
        return 1;
    } elsif ($OpenSSLSays) {
        mlog(0,"warning: unknown valid certificate: $subject");
    } else {
        mlog(0,"error: unknown invalid certificate: openssl-error: '$OpenSSLError' - '$subject'");
    }
    return $OpenSSLSays;
}


# example to implement SNI support for the Web-Listener - the same code with a different sub names can be used for the STATS-Listener, SSL-Listener and TLS connections
# for the complete list of possible parameters supported by IO::Socket::SSL read the module documentation
  
sub configWebSSL {
    my $parms = shift;
    $parms->{SSL_cert_file} = {
        "foo.example.org" => "/full_path_ to_file/foo-cert.pem",
        "bar.example.org" => "/full_path_to_file/bar-cert.pem",
        # used when nothing matches or client does not support SNI
        "" => "/full_path_to_file/server-cert.pem",
    }
    $parms->{SSL_key_file} = {
        "foo.example.org" => "/full_path_to_file/foo-key.pem",
        "bar.example.org" => "/full_path_to_file/bar-key.pem",
        # used when nothing matches or client does not support SNI
        "" => "/full_path_to_file/server-key.pem",
    }
}

# Now, if you set this parameter to 'CorrectASSPcfg::configWebSSL' - assp will call CorrectASSPcfg::configWebSSL->(\%sslparms);

# To support SNI at the SMTP listeners, you may do the following for example:

sub configWebSMTP {
    my $parms = shift;
    my $listenerName = &main::getSMTPListenerConfigName($parms->{LocalAddr},$parms->{LocalPort}); # returns listenPort , listenPort2 , listenPortSSL , relayPort or undef - may be used to implement different parameter settings for some or each SMTP listener
    if ($listenerName eq 'listenPortSSL') { # enable SNI at the listenPortSSL 
        $parms->{SSL_cert_file} = {
            "foo.example.org" => "/full_path_ to_file/foo-cert.pem",
            "bar.example.org" => "/full_path_to_file/bar-cert.pem",
            # used when nothing matches or the SMTP peer does not support SNI
            "" => "/full_path_to_file/server-cert.pem",
        }
        $parms->{SSL_key_file} = {
            "foo.example.org" => "/full_path_to_file/foo-key.pem",
            "bar.example.org" => "/full_path_to_file/bar-key.pem",
        # used when nothing matches or the SMTP peer does not support SNI
            "" => "/full_path_to_file/server-key.pem",
        }
    } # the next "elsif" and "else" code parts may be used or not, this depends on the requirements for the other listeners.
    elsif ($listenerName eq 'listenPort2') {... set parms here for listenPort2 ...}
    elsif ($listenerName eq 'relayPort') {... set parms here for relayPort ...}
    else {... set parms here for listenPort (not recommended!) ...}
}

# If you need to set different SNI parameters for different IP-addresses insite a listener, the "if" checks may depend on $parms->{LocalAddr} and $parms->{LocalPort} as well.

=cut
 
1;

