#!/usr/bin/perl --

=head

           ************************************************
           *                A   S   S   P                 *
           ************************************************
           *   perl AntiSpam SMTP Proxy professional V2   *
           ************************************************
           * Auxiliary Support and Service Proxy for SMTP *
           ************************************************

          (c) Thomas Eckardt since 2008 under the terms of the GPL

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation;

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License (http://www.gnu.org/licenses/) for more details.

 ASSP founded and developed to Version 1.0.12 by John Hanna
 ASSP development since 1.0.12 to 1.2.0 by John Calvi
 ASSP development since 1.2.0 to 1.9.9 by Fritz Borgstedt (passed away in 2014 - we will remember you for a long time!)
 ASSP development since 1.4.5 to 1.10.0 by Thomas Eckardt (version 1.x is outdated and is no longer supported)

 ASSP V2 pro development since 2.0.0 by Thomas Eckardt

  DB Support, Conversions, Transparent SMTP Proxy, SSL/TLS support,
  multilevel Bayesian and Hidden Markov Model engine, mail analyzer,
  language detection, multi language word stemming,
  LDAP-List, recipient replacement, Plugins, multithreading,
  global-penalty-box, backscatter-checks(BATV,FBMTV,DNS), VRFY-check,
  MailLog- and Resend-Function, multipart SpamReport, RebuildSpamDB,
  move2num, https for GUI, many GUI improvements, Block Reports,
  encryption, DB-encryption, DKIM/Domainkey, AdminUsers Interface and functions,
  connection damping, code autoupdate, GUI multi language support,
  local charset support, UTF8 and Unicode support,
  delay queuing, LDAPS, regex tree building, regex optimization, CODE Selfloader,
  POP3 collector, config sync, SNMP, group management, IPv6 support,
  Crash Analyzer, Perl module autoupdate, Unicode support for Windows, DMARC,
  private Whitelist, WHOIS, SMIME signing and checking, code signature,
  ISP mode setup, assp perl module installer, license engine, UUID,
  external virus scanner API, user based attachment handling,
  enhanced ClamAV API, Authenticated Received Chain (ARC)

 Misc. contributions:
 AJ, Robert Orso, Nigel Barling, Mark Pizzolato, Przemek Czerkas, Craig Schmitt,
 Wim Borghs, Micheal Espinola, Doug Traylor, Lars Troen, Marco Tomasi,
 Andrew Macpherson, Marco Michelino, Matti Haack, Dave Emory, Kevin,
 Grayhat (Andrea), Victor Miasnikov

 Thank you to the following sponsors:
 several features sponsored by "ITprime Services GmbH (Marco Rauchenstein)"
 AUTHrequireTLS sponsored by "AllWorldIT.com (Nigel Kukard)"
 ISP mode setup sponsored by DuoCircle LLC (Masood Rahim)
 compressed attachment handling in ASSP_AFC.pm is sponsored by the International Bridge, Inc. and the Devonshire Networking Group (Peter Hinman)

 Thank you to all, who donated to the assp project!

 The latest released version is available at:
 https://downloads.sourceforge.net/projects/assp/files/ASSP%20V2%20multithreading/autoupdate/assp.pl.gz

 The latest development version is available at:
 https://sourceforge.net/p/assp/svn/HEAD/tree/assp2/trunk/assp.pl.gz?format=raw

=cut

## no critic qw(BuiltinFunctions::ProhibitStringyEval Modules::ProhibitMultiplePackages Subroutines::RequireFinalReturn Subroutines::RequireArgUnpacking TestingAndDebugging::ProhibitNoWarnings Variables::RequireLocalizedPunctuationVars InputOutput::RequireBriefOpen ValuesAndExpressions::ProhibitConstantPragma TestingAndDebugging::RequireUseWarnings Subroutines::ProhibitNestedSubs TestingAndDebugging::ProhibitProlongedStrictureOverride TestingAndDebugging::ProhibitNoStrict)

# uncommend the next two lines for production testing on new perl versions
#use warnings;
#use warnings FATAL => qw(deprecated);

# outcommend the next line for production testing on new perl versions
no warnings qw(uninitialized);  # possibly add   'recursion' and/or 'utf8'

use strict qw(vars subs);

our %signo;
our $dftIOEngine = 0;
our $crypt;
sub check_iThreads {
    use Config qw(myconfig);

    my $iThreads = myconfig();
    $iThreads = lc($1) if $iThreads =~ /useithreads\s*=\s*(\S+)/gio;
    {
        my $i = 0;
        foreach (split(/\s+/o, $Config::Config{sig_name})) {
            $signo{$_} = $i;
            $i++;
        }
    }

    die <<EOT  if ($iThreads !~ /define/i);

***** ATTENTION *****

******************************************************************************
This version of Perl ( $] ) does not support iThreads (multithreading)!
iThreads are needed to run ASSP version 2.0.0 or higher!
To get more information about your Perl installation
start the following commands in commandline or shell:

perl -v
perl -V

Upgrade your Perl installation to a multithreading version.
To run this version of ASSP, a Perl version 5.032000 (5.32.0) or higher
is recommended.
Perl 5.03800x (5.38.x) is highly recommended.
Perl 5.04000x (5.40.x) can be used.
An perl version 5.012000 is at least required.
Perl version 6.x is not supported.
******************************************************************************

EOT
    $dftIOEngine = 1 if $Config::Config{'uname'} =~ /strawberry-perl/o || $Config::Config{'myuname'} =~ /strawberry-perl/o;
    no Config;
    undef $iThreads;

    local $@;
    $crypt = sub { return crypt(shift,shift); };
    my $crypt_ok = eval{$crypt->('nospam4me',"45")};
    if ($@ || $crypt_ok !~ /^45.{11}$/o) {
        if (! eval('use Crypt::UnixCrypt; 1;')) {
            die <<EOT;

***** ATTENTION *****

******************************************************************************
Your system, but at least the used perl installation, does not support the
CORE::crypt (3) function.
This function was removed by the OS vendor or the perl distributor.
How ever, assp requires this function or an equivalent function!
To workaround this issue, install the perl module Crypt::UnixCrypt
(e.g. from cpan), which provides the required function - and start assp again.
******************************************************************************
EOT
        }
        $crypt = sub { return Crypt::UnixCrypt::crypt(shift,shift); }
    }
}

our $VSTR;
BEGIN {
    $VSTR = $];
    $VSTR =~ s/^(5\.)0(\d\d).+$/$1$2/o;
}

use 5.012;
no strict qw(refs);         # refs are strict per default since 'use 5.012'
use feature ":$::VSTR";     # <- turn on the available version features
no utf8;                    # assp does not need it and don't like it - here is all latin - this is witten because of the announcement that perl 5.36 or 5.38 will use utf8 in CORE
use threads 1.69 ('yield');
use threads::shared 1.18;
use Thread::Queue 2.06;
use IO::Poll 0.07 qw(POLLIN POLLOUT POLLERR POLLHUP POLLNVAL);
use IO::Select;
use Errno qw( EWOULDBLOCK EAGAIN ETIMEDOUT EINTR EPIPE EBADF );

use Encode 2.71;
# because Encode::HanExtra is no longer defined in Encode::Config (commend only),
# the encodings and module relation for Encode is defined here
BEGIN {
    unless ( ord("A") == 193 ) {  # EBCDIC does not support these encodings
        $Encode::ExtModule{'big5plus'} ||= 'Encode::HanExtra';
        $Encode::ExtModule{'euc-tw'}   ||= 'Encode::HanExtra';
        $Encode::ExtModule{'gb18030'}  ||= 'Encode::HanExtra';
    }
    eval { require Encode::Guess; };
    eval { require Encode::Detect; };
    eval { Encode::define_alias( qr/\biso[-_]8859[-_]8[-_]I$/i => '"iso-8859-8"' ) unless Encode::resolve_alias('iso-8859-8-i'); };  # added in Encode version 3.19 (perl 5.38)
    # define a fallback to ISO-8859-1 (a full single byte charset) for all not found encodings unless a fallback is found
    # aliases are lookedup top down in @Encode::Alias::Alias by Encode - so push the *all matching fallback to the end of the alias list
    # empty or undefined charsets have no fallback
#    push @Encode::Alias::Alias, qr/.+/ => '"iso-8859-1"' unless Encode::resolve_alias('could never be found');
    
    if ($VSTR gt '5.36') {
        print "preloading Lingua::Stem::Snowball for perl $VSTR\n" if $^C;
        eval { require Lingua::Stem::Snowball; }; # perl 5.38 require to preload this module - a later load may/will fail
    }
}

use constant FB_SPACE => sub { '' };
use File::Copy;
use IO::Socket;
use Sys::Hostname;
use Net::DNS 0.71 ();  # RR->char_str_list is backward compatible - now only use RR->txtdata
use Time::Local;
use Time::HiRes;
use HTML::Entities ();
use Cwd;
use MIME::Base64();
use MIME::QuotedPrint();
use Storable();

STDOUT->autoflush(1);
STDERR->autoflush(1);
$SIG{ALRM} = sub {};

our $MAINVERSION;
our $MajorVersion;
our $version;
our $subversion;
our $modversion;
our $build = 0;
BEGIN {$build = 0;}
our $versionAge;
our $maxAge;
our $availversion:shared;
our $versionURL:shared;
our $NewAsspURL:shared;
our $ChangeLogURL:shared;
our $requiredSelfLoaderVersion;
our %requiredDBVersion:shared;
our $minCSSbuild;
our $codename;
our $perl = $^X;
our $assp = $0;
our $asspSHA1;
our $isWIN;
our $isNoWIN;
$isWIN = $^O eq 'MSWin32'; $isNoWIN = ! $isWIN;
BEGIN {$isWIN = $^O eq 'MSWin32'; $isNoWIN = ! $isWIN;}
$assp =~ s/\\/\//og;
$assp =~ s/\/+/\//og;
our $allIdle:shared = 0;
our $islendian = (unpack("h*", pack("s", 1)) =~ /^1/) ;
our ($SAVEOUT, $SAVEERR);
our $lockOUT:shared;
our $shamod;
our %Con; keys %Con = 64;
our %StatConH;
our %WebConH;
our $maxPerlVersion;

#
sub setVersion {
$version = '2.8.1';
$build   = '24261';        # 17.09.2024 TE
$modversion="($build)";    # appended in version display (YYDDD[.subver]).
$maxPerlVersion = '5.040999';
$MAINVERSION = $version . $modversion;
$MajorVersion = substr($version,0,index($version,'.'));
$requiredSelfLoaderVersion = '2.03';
($subversion) = $version =~ /\d+\.\d+\.(\d+)/o;

#$codename = 'Fritz&nbsp;&dagger;&nbsp;';
$codename = '<b>*SPAM-Eliminator*</b>';

# the database versions build and required by this release
$requiredDBVersion{'Spamdb'} = $MajorVersion.'_23331';
$requiredDBVersion{'HMMdb'}  = $MajorVersion.'_23331';

# the minimum required version of assp.css style file
$minCSSbuild = 17015;
}
#
&setVersion();

our $open;
our $unicodeFH;
our $unicodeDH;
our $move;
our $copy;
our $unlink;
our $rename;
our $chmod;
our $chown;
our $stat;
our $mkdir;
our $rmdir;
our $rmtree;
our $eF;
our $dF;
our $unicodeName;

sub disableUnicode {
    $open = sub { open(shift,shift,shift); };    ## no critic
    $unicodeFH = sub {};
    $unicodeDH = sub { opendir(my $d,shift);my @l = readdir($d);closedir($d) if $d;return @l; };
    $unlink = sub { unlink(shift) };
    $move = sub { File::Copy::move(shift,shift) };
    $copy = sub { File::Copy::copy(shift,shift) };
    $rename = sub { rename(shift,shift) };
    $chmod = sub { chmod(shift,shift) };
    $chown = sub { chown(shift,shift,@_) };
    $stat = sub { stat(shift) };
    $mkdir = sub { mkdir(shift,shift) };
    $rmdir = sub { rmdir(shift) };
    $rmtree = sub { rmTree(shift) };
    $eF = sub { -e shift; };
    $dF = sub { -d shift; };
    $unicodeName = sub { $_[0];};
}
BEGIN { disableUnicode(); }

our $utf8on =  sub { Encode::_utf8_on( ${$_[0]} );};
# alternative  our $utf8on =  sub { utf8::upgrade(${$_[0]});return;};
our $utf8off = sub { Encode::_utf8_off( ${$_[0]} );};
# alternative  our $utf8off =  sub { utf8::downgrade(${$_[0]},1);return;};

if ($subversion % 2) {
# stable published version download
    $versionURL = 'https://downloads.sourceforge.net/project/assp/ASSP%20V2%20multithreading/autoupdate/version.txt';
    $NewAsspURL = 'https://downloads.sourceforge.net/project/assp/ASSP%20V2%20multithreading/autoupdate/assp.pl.gz';
    $ChangeLogURL = 'https://downloads.sourceforge.net/project/assp/ASSP%20V2%20multithreading/changelog.txt';
    $maxAge = 365 * 24 * 3600;
} else {
# stable development version download
    $versionURL = 'https://sourceforge.net/p/assp/svn/HEAD/tree/assp2/trunk/version.txt?format=raw';
    $NewAsspURL = 'https://sourceforge.net/p/assp/svn/HEAD/tree/assp2/trunk/assp.pl.gz?format=raw';
    $ChangeLogURL = 'https://sourceforge.net/p/assp/svn/HEAD/tree/assp2/trunk/changelog.txt?format=raw';
    $maxAge = 90 * 24 * 3600;
}
our $gripListDownUrl:shared = 'https://*HOST*/cgi-bin/assp_griplist?binary';
our $gripListUpUrl:shared = 'https://*HOST*/cgi-bin/assp_griplist?binary';
our $gripListUpHost:shared = 'assp.sourceforge.net';
$gripListDownUrl =~ s/\*HOST\*/$gripListUpHost/o;
$gripListUpUrl  =~ s/\*HOST\*/$gripListUpHost/o;
our $GroupsFileURL:shared = 'https://sourceforge.net/p/assp/svn/HEAD/tree/assp2/trunk/groups.txt?format=raw';
our $uploadStatsProt:shared = 'https';
our $uploadStatsHost:shared = 'assp.sourceforge.net';
#-----------

our %neverLockTable;
our %skipDeclare;
our @ConfigArray;
our %Modules;
our %ModulesUsed;
our @prelog;
our $mydb:shared;
our %DBvars;
our %tempDBvars;
our %Config:shared;
our %ConfigSync;
our %newConfig;
our %ConfigAdd;
our %RunTaskNow:shared;
our $RemoteSupportEnabled:shared;
our $Charsets;
our %CurrentMEM:shared;
our $base:shared;
our %Plugins:shared;
our %PluginFiles:shared;
our $runlvl0PL:shared;
our $runlvl1PL:shared;
our $runlvl2PL:shared;
our $pltest;
our $pldo;
our $plLogTo;
our $plVal;
our $wikiinfo;
our $mtObj = threads->self();
our $DBdrivers;
our $DBdriversJ;
our $DBautocommit = 1;
our $dftrestartcmd;
our $dftCaFile;
our $dftCertFile;
our $dftPrivKeyFile;
our $AsAService;
our $ServiceStopping = 0;
our $LogDateFormat:shared;
our $LogDateLang:shared;
our $defaultLogCharset;
our $WorkerNumber = 0;
our $WorkerName = 'startup';
our %lngmsg;
our %lngmsghint;
our $PIDH;
our $NODHO = 1;
our $CreateMIB = 0;
our $GPBinstallLib;
our $GPBmodTestList;
our $GPBCompLibVer;
our $crashHMM;
our $optReModule;
our %MemTable;
our %MemTableHist;
our $RBLobj;
our $UUID;
our %ModuleWatch;
our $nointchk;
our $codeSignature;
our $BDBMaxCacheSize:shared = 0;   # BDB downward cachesize check starting point in MB
our $moveDB;   # do not change !!! instead start assp one time with the --movedb:=1  option
our $newDB;    # do never change - for internal use only !!
our $Uid;
our $Gid;
our $Sgids;
our $DNSCheckInterval:shared = 60;
our $DNSErrorCheckInterval:shared = 5;
our %SSLServerContext;
our %SSLServerContextList;
our $MIBFile;
our $MRTGFile;
#our %startupMem:shared;


${'Storable::Deparse'} = 1;
${'Storable::Eval'} = 1;
${'Storable::forgive_me'} = 1;

# max age in days of some longer existing files
our %maxStatsAndDwnlAge = (
    'language' => 100,
    'download' => 183,
    'backup.config' => 183,
    'GraphStats' => 366,
);

# skip the reply explanation (addErrorReplyExplanation) for the following reply codes
# there are much more things you can do with a reply - have a look into sub replaceLiterals
our %noReplyExplain;
BEGIN {            # noReplyExplain is referenced in the GUI - so we have to set the values at begin
%noReplyExplain = (
    '500' => 1,    # syntax error / command not implemented / bad sequence
    '501' => 1,
    '502' => 1,
    '503' => 1,
    '504' => 1,

    '521' => 1,    # finaly closing transmission

    '534' => 1,    # AUTH required / error
    '535' => 1,
    '538' => 1
);
}
# *********************************************************************************************************************************************
# hidden configuration variables:
#    that can be changed using the module lib/CorrectASSPcfg.pm sub set
# or that can be set using a commandline switch like: --enableCrashAnalyzer:=1
# or that can be changed safely here, without violating the codeintegrity
# *********************************************************************************************************************************************

# CrashAnalyzer related
our $enableCrashAnalyzer = 0;            # (0/1) enable the automatic crash analyzer (CA)
our $CrashAnalyzerTopCount = 10;         # (number > 0) number of records used for the CA top count
our $CrashAnalyzerWouldBlock = 1;        # (0/1) block the mail if CA detects that the mail would crash ASSP

#IP related
our $IPv6TestPort = '51965';             # (port number) the port number that is used at startup to bind IPv6 to - to check if IPv6 is available
our $forceDNSv4:shared = 1;              # (0/1) force DNS queries to use IPv4 instead to try IPv6 first
our $DNSresolverLifeTime = 3600;         # the max lifetime of a DNS-Resolver object and it's sockets in seconds
our $ignorePrivilegedPorts:shared = 1;   # (0/1) ignore the check of privileged ports on nix systems
                                         # if assp runs as no root user and this is set to 0
                                         # a required renew of a listener at port 1-1023 will require a
                                         # assp restart
our $disable_SO_REUSEPORT = 1;           # (0/1/2) disable the SO_REUSEPORT socket option - there is no assp version which ever used this option
                                         # notice: windows never has this socket option - so leave this value at 1
                                         #  0 - do not disable - try it, but if not supported by the OS it is not used and a load warning is produced for the module 'Socket'
                                         #  1 - disable this socket option and do not try to use it
                                         #  2 - do not disable - try it, but if not supported by the OS it is not used and silently ignored

# Bayesian and HMM related
our $HMMSequenceLength = 4;              # (number > 0) count of words used for a sequence
our $HMMDBWords = 600;                   # (number > 0) number of words used per mail in rebuildspamdb
our $BayesDomainPrior = 2;               # (number > 0) Bayesian/HMM domain entry priority (1 = lowest)
our $BayesPrivatPrior = 3;               # (number > 0) Bayesian/HMM private/user entry priority (1 = lowest)
our $debugWordEncoding = 0;              # (0/1) write/debug suspect word encodings to debug/_enc_susp.txt
our $reportBadDetectedSpam = 1;          # (0/1) report mails to spamaddresses that are not detected as SPAM, to the rebuild process
our $DoRBRed = 0;                        # (0/1) check relisted mails on rebuildspamdb (default 0 - 1 = skip rebuild for spam and notspam if red)
our $DoRBWhite = 0;                      # (0/1) check whitelisted mails on rebuildspamdb (default 0 - 1 = skip rebuild for spam if white)
our $DoRBBlack = 0;                      # (0/1) check blacklisted mails on rebuildspamdb (default 0 - 1 = skip rebuild for notspam if black)
our $RBExportCSV = 0;                    # (0/1) rebuild exports the spamDB and HMMdb to utf-8 encoded csv-files in the tmpDB/rebuildDB folder in RebuildTestMode

# logging related
our $AUTHLogUser = 0;                    # (0/1) write the username for AUTH (PLAIN/LOGIN) to maillog.txt
our $AUTHLogPWD = 0;                     # (0/1) write the userpassword for AUTH (PLAIN) to maillog.txt
our $Unidecode2Console = 0;              # (0/1) use Text::Unidecode to decode NONASCII characters to ASCII - if available  - if set - 'ConsoleCharset' is ignored
our $AnalyzeLogRegex = 0;                # (0/1) enables enhanced regex analyzing (in console mode only)
our $SysLogFormat = '';                  # possible values are '' , 'rfc3164' and 'rfc5424' - '' is default
our $SysLogProto = 'udp';                # possible values are 'udp' , 'tcp' - 'udp' is default

# database related
our $forceTrunc4ClearDB = 0;             # (0/1) try/force a 'TRUNCATE TABLE' instead of a 'DELETE FROM' - 'DELETE FROM' is used as fall back if the truncate fails
our $DoSQL_LIKE = 1;                     # (0/1) do a 'DELETE FROM table WHERE pkey LIKE ?' to remove generic keys
our $lockBDB = 0;                        # (0/1) use the CDB locking for BerkeleyDB (default = 0)
our $BDBerrLog = 0;                      # (0/1) log BerkeleyDB errors in the related BDB-ENV -errfile .../BDB-error.txt (default = 0)
our $lockDatabases = 0;                  # (0/1) locks all databases on access in every worker to prevent access violation
our $DBCacheSize = 12;                   # (number > 0) database cache record count , if less it will be set to NumComWorkers * 2 + 8
our $importDBShowProgress = 1;           # (0/1) show the progress in the maillog.txt while a DB-import is running - default is 1

# BlockReport security related
our $BlockReportRequireSMIME = 0;        # (0/1/2/3) 1 = users, 2 = admins, 3 = users & admins
our $emailIntSMIMEpubKeyPath = '';       # full path to EmailInterface cert-chain folder (file=emailaddress.pem)

our $BlockReportRequirePass = 0;         # (0/1/2/3) 1 = users, 2 = admins, 3 = users & admins
our $BlockReportUserPassword = '';       # the password must be anywhere starting in a line in the mail , one single password for all users
our $BlockReportAdminPassword = {};      # the password must be anywhere starting in a line in the mail , every admin a password
                                         # definition as HASH: {'admin1emailaddress' => 'password1',
                                         #                      'admin2emailaddress' => 'password2'}
                                         # emailaddresses in lower case only !!
                                         #
                                         # passwords are NOT checked if SMIME is configured and is valid
                                         # passwords are ignored if SMIME failed
our $enableBRtoggleButton = 1;           # (0/1) show the "toggle view" button in HTML BlockReports
our $TargetBlank = {                     # where to include 'target="_blank"' into HTML links - set the value to '' if 'target="_blank"' makes problems
    'BlockReport' => ' target="_blank"'  # BlockReports in WebMail-Clients like thunderbird, Roundcube Webmail and possibly others will need to set this to '' to make the resendlinks working
};
our $toptencount = 10;                   # number > 0 - count of top x blocking statistic

# some more
our $enablePermanentSSLContext = 1;      # (0/1) enable usage of permanent SSL Context - maxunused ($SSLContextMaxUnused) = 8 hours, max lifetime ($SSLContextMaxAge) = 1 day (default = 1)
our $SPF_max_dns_interactive_terms = 15; # (number > 0) max_dns_interactive_terms max number of SPF-mechanism per domain (defaults to 10)
our $SPF_max_allowed_IP = 0;             # maximum allowed IP (v4 and v6) adrresses in a SPF-record - default is 0 (disabled) - 2**17 seems to be OK
our $disableEarlyTalker = 0;             # (0/1) disable the EarlyTalker check
our $disableRFC2047 = 0;                 # (0/1) disable the RFC2047 check - undecoded subject contains non printable characters
our $ignoreEarlySSLClientHelo = 0;       # (0/1) 1 - unexpected early SSLv23/TLS handshake Client-Helo-Frames are ignored , 0 - unexpected early SSLv23/TLS handshake Client-Helo-Frames are NOT ignored and the connection will be closed
our $SpamCountNormCorrection = 0;        # (+/- number in percent) correct the required by X% higher
our $FileScanCMDbuild_API;               # called if defined in FileScanOK with - $FileScanCMDbuild_API->(\$cmd,$this) - $cmd in place modification
our $WebTrafficTimeout = 60;             # Transmission timeout in seconds for WebGUI and STATS connections
our $DisableSyslogKeepAlive = 0;         # disable sending the keep alive '***assp&is%alive$$$' to the Syslog-Server
our $noRelayNotSpamTag = 1;              # (0/1) do per default the NOTSPAMTAG for outgoing mails
our $DKIMpassAction = 0;                 # (0..7) if DKIM pass: bit-0 = set rwlok to 1 (medium trust status), bit-1 = skip penaltybox-check, bit-2 = set IP-score to zero - default is 0 (no bits set)
our $SPFpassAction = 0;                  # (0..7) if SPF  pass: bit-0 = set rwlok to 1 (medium trust status), bit-1 = skip penaltybox-check, bit-2 = set IP-score to zero - default is 0 (no bits set)
our $removePersBlackOnAutoWhite = 1;     # (0/1) remove the PersBlack entry for autowhite addresses in outgoing mails
our $resetIntCacheAtStartup = 1;         # (0/1) reset internal Caches at startup - default is 1 (YES)
our $BackDNSTTL = 72;                    # (number > 0) time in hours after downloaded BackDNS entries will expire - default is 72 (3 days)

our $checkCRLF = 1;                      # (0/1) check line terminator mistakes (single [CR] or [LF]) in SMTP-commands of incoming mails (correction is done every time) - default = 1
our $CCignore8BitMIME = 0;               # (0/1) CCham, ForwardSpam and resend will ignore a missing 8BITMIME extension

our $CCchangeMSGDate = 0;                ## (0..31) change the 'Date:' MIME-header on CCmail (sendHamInbound), ForwardSpam (sendAllSpam) and resend mail
                                         ## MS-Exchange may require this, because duplicate mails will be removed silently, if they contain an equal 'Date:...' MIME-header
                                         ## only the value for the seconds will be changed
                                         # bit 0 = 1 ( +1) -> set all bits (1 - 4) to 1 for backward compatibility ( same as 30 -> 2+4+8+16 )
                                         # bit 1 = 1 ( +2) -> force change at CCmail
                                         # bit 2 = 1 ( +4) -> force change at ForwardSpam
                                         # bit 3 = 1 ( +8) -> force change at resend mail
                                         # bit 4 = 1 (+16) -> general disable the automatic detection of a local MS-Exchange MTA by checking the SMTP banner / greeting
                                         ## The default is zero (0), which means: the 'Date:...' MIME-header is not forced to be changed in either case,
                                         ## but it will be changed, if a MS-Exchange MTA is detected using $ExchangeBannerRe against the SMTP banner / greeting.
                                         ## To disable this feature completely - set this value to 16.

our $CCskipEmptyBody = 0;                # (0/1) do not forward mails with an empty body - default is 0 - forward anyway

our $WriteRetryWaitTime = 1;             # seconds to wait before a SMTPwrite retry is done after an write error - default = 1

our $resetMessageScore = 3;              #(0/1/2/3) reduce the MessageScore from SMTP handshake + header in header/body checks if whitelisting and/or noprocessing is detected in header/body (e.g. after the handshare)
                                         # 0 - disabled
                                         # 1 - outgoing/local mails
                                         # 2 - incoming mails
                                         # 3 - all mails

our $reduceMS4NP = 100;                  # if resetMessageScore is enabled - the number of percent of the mails noprocessing score history used to reduce the message score
our $reduceMS4WL = 100;                  # if resetMessageScore is enabled - the number of percent of the mails whitelisted score history used to reduce the message score

our $WorkerScanConLimit = 1;             # (number >= 0) connection count limit in SMTP threads, before the thread moves the corpus filescan to high threads

our $fakeAUTHsuccess = 0;                # (0/1/2) fake a 235 reply for AUTH success - move the connection to NULL - collect the mail in spam - used for honeypots - 2=with damping
our $fakeAUTHsuccessSendFake = 0;        # (0/1) send the faked mails from the honeypot - make the spammers believe of success - attention: moves assp into something like an open relay for these mails
our $AUTHrequireTLSDelay = 5;            # (number) seconds to damp connections that used AUTH without using SSL (to prevent DoS)

our $AUTHrelayTable = {};                # HASH to lookup authentication credentials for different relayHost(s)
                                         # if this HASH is empty or no host matches relayAuthUser and relayAuthPass are used
                                         # if any of relayAuthUser and relayAuthPass is not defined, no authentication will be done to the relayHost
                                         # example:
                                         # $AUTHrelayTable = {relayHost1:relayPort1 => [relayuser1,relaypass1],
                                         #                    relayHost2:relayPort2 => [relayuser2,relaypass2],
                                         #                    relayHost3:relayPort3 => [relayuser3,relaypass3]}

our $delayGripLow = 0.4;                 # 0 <= value <= 1 IP's with a GripList value lower or equal to the defined value will be not delayed/greylisted - default is 0.4

our $DelayUsesSPF = 1;                   # (0/1) use SPF-record IP's for delaying - default is 1

our $protectASSP = 1;                    # (0/1) the internal 'rmtree' function will only remove files and folders in base/t[e]mp...  - other folders are ignored

our $noSupportSummay = 0;                # (0/1) skips the output of a support summary in the configuration export function

our $AllowCodeInRegex = 0;               # (0/1) allow the usage of executable perl code (?{code_to_run}) in regular expression - change this ONLY, if you really know what you do

our $maxSameFileIncludes = 100;          # number of times the same include file can occure in a configuration file

our $ignoreInvalidAddressNPWL = 3;       # (0/1/2/3) ignore invalid envelope recipients for whitelisted (2) or noprocessing (1) or both (3) senders and IP's (no score, no connection drop, no error count)

our $DKIMCacheStrict = 1;                # (0/1) if a DKIM signature is found for a domain - all other mails from this domain will require a DKIM signature to pass the Pre-DKIM-Check

our $checkLinuxENV = 0;                  # (0/1/2) check ulimit: (1) on nix and selinux , (2) on linux systems

our $winSetMaxIO_DLL = 'msvcrt';         # the name of the microsoft C-runtime-library used by perl and/or perl-modules (Win32 only !!!) - default is msvcrt
                                         # If your perl uses (is compiled against) any other msvcrtXXX (for example: msvcrt160 or msvcrt100) - change this value, if
                                         # you want to set the maximum open files limit in the msvcrtXXX.
                                         # This value is ONLY used for the below purpose ($winSetMaxIO), it has no other effect !

our $winSetMaxIO = 0;                    # (0/1/ 512 * 2**N) set the maximum open files limit (Win32 only !!!) in ($winSetMaxIO_DLL) msvcrt.dll (_getmaxstdio , _setmaxstdio)
                                         # 0 - use the default setting in msvcrt.dll (normaly set to 512)
                                         # 1 - find the maximum allowed value between 512 and 8192 and set it
                                         # 512 * 2**N - try to set the value as high as possible up to the given maximum (min 512 , max 8192, in 512 * 2**N [N=0..4])
                                         #          if the defined value is less than the current maximum, the setting will not be changed
                                         # Notice: PERLIO (perl compiled with -DUSE_PERLIO - check with :>perl -V) may define a different max open file limit for its
                                         #         IO's (defaults to 2048 because PERLIO_MAX_REFCOUNTABLE_FD=2048)
                                         #         - this limit is not affected by this value

our $DoAVCache = 1800;                   # (number) store AntiVirus results in a Cache for this amount of seconds to avoid rescanning already scanned content - default = 1800

our $genXOrigAuthResHeader = 1;          # (0/1) generate the X-Original-Authentication-Results header instead of Original-Authentication-Results - default = 1 (backward compatible)

our $workersStartReloadRegex = 1;        # (0/1) (1) should the workers recompile all regular expressions at start, or (0) should they use the precompiled regexs provided by the MainThread
                                         # setting this value to 0 may cause an unexpected SEGV in workers, if a regex is changed - how ever, the startup will be significant faster
                                         # if large regexes (e.g. IP-Lists) are in use

our %DoNoFromReplDomain = (              # replacement domains for the DoNoFrom check - e.g. mixed gmail and google domains
    'google.com' => 'gmail.com',         # use lower case only !
    'calendar-server.bounces.google.com' => 'gmail.com',
    'googlemail.com' => 'gmail.com'
);

our %DMARCReplDomain = (                 # replacement envelope domains for the DMARC check - e.g. gmail/google calendar invitations
    'google.com' => 'gmail.com',         # use lower case only
    'calendar-server.bounces.google.com' => 'gmail.com',
    'googlemail.com' => 'gmail.com'
);
# *********************************************************************************************************************************************

our $missingTLSError =                   # the SMTP-reply sent, if STARTTLS is not used but was forced by forceTLSIP
"502 <MYNAME> connected by 'IPCONNECTED' - 'RECEIVEDHELO'. The used command 'LASTCOMMAND: <MAILFROM>' is still not supported, because the connection is NOT secured by an encryption layer (TLS) - please use STARTTLS first FORCEEXPLAIN";

# some not RFC conform DMARC record subjects - like Amazon SES
our @DMARCReportAddSubjectRe = ('(?:Report\s*domain:\s*\{$EmailDomainRe\}\s+Submitter:\s*\{Amazon\s+SES\}\s+Date:\s*\S+\s+Report-ID:.{2,})' ,
                                '(?:^\s*\[BETA\] DMARC Report for)');

# comma separed list of host1,helo1,host2,helo2,.... for an exact host match in the first line of an X-Spam-Report: spamassassin header!
our $trustedFWSF = 'mx.sourceforge.net,lists.sourceforge.net';

our $consolidateWhitelList = 1;          # (0/1) consolidate the whitelistdb - removes unneeded entries

#used in SMTPWrite - TODO
our $searchCRLFmistake = 0;

$BayesDomainPrior ||= 1;
$BayesPrivatPrior ||= 1;

our %workerSpeedUp = ( 10000 => 0,       # speed up some time critical task in these workers by temporary increasing the thread priority to the defined value
                       10001 => 0);      # should not be set below 0 (high prio) and not higher than 2 (low prio)

#######################################################
# see setServiceProperties                            #
#######################################################
our $ServiceName;                        # to separate multiple instances on one host (windows only)
our $ServiceDisplayName;                 # the windows SC service name                (windows only)
our $ServiceTag;                         # a short version of the install folder      (windows and nix)
#######################################################

#######################################################
######################  HMM4ISP #######################
#######################################################
#                                                     #
# special setting to run assp in an ISP environment   #
#                                                     #
# spamDB and HMMdb are hold in each thread in a       #
# separate unshared memory area for very fast access  #
#                                                     #
# DNSBL(RBL), DNSWL(RWL), URIBL and SenderBase        #
# have to be provided using local DNS instances       #
#                                                     #
# the setting may be done here - but recommended is   #
# to use the module lib/CorrectASSPcfg.pm             #
#                                                     #
#######################################################
#######################################################
#######################################################

#######################################################
#                                                     #
# changing $HMM4ISP to 1 requires a very performant   #
# server, 64Bit hardware and at least 16GB RAM        #
# and SSD drives for the assp folder                  #
#                                                     #
# a 64Bit Perl 5.20 or higher is required             #
# Perl 5.32 or higher is recommended                  #
#                                                     #
# spamdb has to be set to use a plain file ,          #
# HMMusesBDB must be disabled ,                       #
# DoHMM must be enabled before $HMM4ISP is set to 1   #
#                                                     #
#######################################################
#                                                     #

our $HMM4ISP = 0;                   # (0/1) if enabled and spamdb is not set to 'DB:' and HMMusesBDB is not set - the spamdbGroup (spamDB,HMMdb)
                                    # is hold in unshared private memory in each thread

#                                                     #
#######################################################
# advanced listen and rebuild setting to run assp     #
# (spamDB / HMMdb) in an ISP environment              #
#######################################################
#                                                     #

our $Listen = 10;                   # concurrent pending connections without an socket->accept (default is 10) - seen up to 100
our $RebuildStartScript;            # OS script to run before the rebuild starts - eg. to rsync the changed corpus from slave or cluster instances
our $RebuildFinishScript;           # OS script to run after the rebuild finished - eg. to provide the DB's to slave or cluster instances
our $threadReloadConfigDelay = 15;  # seconds to wait for each thread after the reload sign received, before reloading the config
                                    # and also the hashes - eg. the spamdbGroup
                                    # NOTICE: loading the DB's into memory forces a high CPU load in each thread for some seconds!

#                                                     #
#######################################################
# ASN-provider special settings for local instances   #
#######################################################
#                                                     #
#                                                     #

our $ASNProviderIPv4 = '.asn.routeviews.org |
                        .origin.asn.cymru.com';  # asn.routeviews.org equivalent provider for IPv4 ASN, if local (or others) DNS provides the ASN list
                                                 # combine multiple providers (for failover) by pipe '|' or comma ','
our $ASNProviderIPv6 = '.origin6.asn.cymru.com'; # asn.routeviews.org equivalent provider for IPv6, if local (or others) DNS provides the ASN list
                                                 # combine multiple providers (for failover) by pipe '|' or comma ','

#######################################################
# DNSWL.ORG special settings for local instances      #
#######################################################
#                                                     #

our $dnswlorg;                      # list.dnswl.org equivalent provider(s), if local DNS provides the dnswl.org list without having 'lists.dnswl.org'
                                    # in the zone name - separate by space or comma
our $dnswlForceRWLOK = 4;           # if the list.dnswl.org trust is equal or higher than this value, RWLminhits is ignored
                                    # and the mail is processed with the highest trust 3 - default is 4, which can't be reached

#                                                     #
#######################################################
################## end HMM4ISP ########################
#######################################################

our $threadCheckConfig = 0;         # set to 1 - all threads will check the assp.cfg file

our $PBscoreNoDelay = 1;            # score noDelay messages

our $dbBackupVersions = 10;         # (3- ...) min=3, default=10 - number of database backup and export version that are keeped

our $reReadSpamFolderInterval = 300;# reread interval of the spamfolder content for MaxAllowedDups to prevent possible DoS attacks

                                    # RFC8689 SMTP Require TLS Option
our $enableREQUIRETLS = 0;          # (0/1) enable testing of the REQUIRETLS implementation
our $provideREQUIRETLS = 0;         # (0/1) include REQUIRETLS into the EHLO reply if not already provided
our $forceREQUIRETLS = 0;           # (0/1) include REQUIRETLS into the MAIL FROM: command if not provided by the MTA

our %NotifyFreqTF:shared = (        # one notification per timeframe in seconds per tag per worker
    'info'    => 60,                # to prevent log flooding with equal loglines - default to 60 seconds for each tag
    'warning' => 60,
    'error'   => 60
);

our $sortWeightedConfig = {};       # 'configParameter' => 1, '' => 1, ... - reverse sort regular expressions in this weighted config parameters

sub __cs { $codeSignature = 'D4D23A37D9991E4E8303E057DC4A770FFB03C7B3'; }

#######################################################
# any custom code changes should end here !!!!        #
#######################################################

our $showMEM = 0;                   # (0/1) show the current memory usage in every worker  !!! DO NOT use - this causes SEGV in Devel::Size !!!

# these four values are configured using 'TCPBufferSize'
# there is no longer a need to change them here
our $maxTCPRCVbuf;
our $maxTCPSNDbuf;
our $maxTCPRCVbufSSL = 16384;
our $maxTCPSNDbufSSL = 16384;
# fall back to these values in case the system reports nothing for SOL_SOCKET:SO_RCVBUF or SOL_SOCKET:SO_SNDBUF
our $fallBackTcpBuf = 8192;         # fall back to this TCP (receive/send) buffersize, if the system reports less or nothing
our $fallBackSSLBuf = 16384;        # fall back to this SSL (receive/send) buffersize, if the system reports less or nothing

# the OpenSSL and OpenSSL-Library minimum version requirement
our $minOpenSSLVersion = '1.0.0t';
our $minOpenSSLLibVersion = '1.0.2s';

# SSL/TLS assp will try to do a fast read ahead using the following values
# be carefull changing any of these values !
our $SSL_read_ahead = 1;            # try the SSL readahead
our $SSL_read_ahead_wait = 2;       # poll/select socket wait time in milliseconds for the read ahead
our $SSL_read_ahead_max_time = 50;  # time in milliseconds used for read ahead
our $checkSSLState = 0;             # (0/1) to be enabled to check the poll/select state of SSL/TLS-SMTP-connection (after SSL_WANT_...) in every thread loop

# SSL/TLS assp will try to do a fast bulk (boost) write using the following values
# the max framesize of SSL is 16384 byte - for the time given in SSL_write_boost_max_time, assp will try to send as much SSL frames as possible
# be carefull changing any of these values !
our $SSL_write_boost = 0;           # (0/1/2) 0 - disabled - possibly auto enabled   (default)
                                    #         1 - enabled  - possibly auto disabled
                                    #         2 - permanently enabled (never automatically changed)
                                    # try the SSL boost - automatically set to 1 in ConfigChangeTCPBuf if $maxTCPSNDbufSSL > 16384
                                    #                     automatically set to 0 in ConfigChangeTCPBuf if $maxTCPSNDbufSSL <= 16384
our $SSL_write_boost_max_time = 100;# time in milliseconds used for SSL write boost (default 100)

# the SSL/TLS renegotiation counter will be reset after this number of seconds without a renegotiation request and any regular data are sent or received
our $maxSSLRenegDuration = 10;
BEGIN {$maxSSLRenegDuration = 10;}  # maxSSLRenegDuration is referenced in the GUI - so we have to set the value at begin
our $SSLContextMaxAge = 24 * 3600;
our $SSLContextMaxUnused = 8 * 3600;

# the length of the autogenerated CA/cert SSL private keys  (1024 ????, 2048, 4096) - notice 1024 seems to be too short
our $SSLCAKeyLength = 2048;
our $SSLServerKeyLength = 2048;

# the openssl security level - https://www.openssl.org/docs/manmaster/man3/SSL_CTX_get_security_level.html|https://www.openssl.org/docs/manmaster/man3/SSL_CTX_get_security_level.html
#                              https://www.openssl.org/docs/manmaster/man3/SSL_CTX_set_security_level.html|https://www.openssl.org/docs/manmaster/man3/SSL_CTX_set_security_level.html
our $openssl_security_level;        # ( /1/2/3/4/5) used openssl security level - empty uses the libssl built-in value (default = 1)

#***************************************************
# URL's may be overwritten by the version.txt file *
#***************************************************
our $tlds_alpha_URL:shared = 'http://data.iana.org/TLD/tlds-alpha-by-domain.txt';
our $tlds2_URL:shared = 'https://www.surbl.org/static/two-level-tlds';
#    'http://www.surbl.org/tld/two-level-tlds';
#    'http://george.surbl.org/two-level-tlds';
#    'https://sourceforge.net/p/assp/svn/HEAD/tree/assp2/trunk/URIBLCCTLDS-L2.txt?format=raw';

our $tlds3_URL:shared = 'https://www.surbl.org/static/three-level-tlds';
#    'http://www.surbl.org/tld/three-level-tlds';
#    'http://george.surbl.org/three-level-tlds';
#    'https://sourceforge.net/p/assp/svn/HEAD/tree/assp2/trunk/URIBLCCTLDS-L3.txt?format=raw';

our $BackDNSFileURL:shared = 'http://wget-mirrors.uceprotect.net/rbldnsd-all/ips.backscatterer.org.gz';

our $DroplistURL:shared = "https://www.spamhaus.org/drop/drop.txt";
#our $DroplistEURL:shared = "https://www.spamhaus.org/drop/edrop.txt";    # now included in drop.txt
our $DroplistEURL:shared = 'skip';
our $Droplist6URL:shared = "https://www.spamhaus.org/drop/dropv6.txt";

# set the blocking mode for HTTP (0/1 default is 0) and HTTPS (0/1 default is 0) on the GUI
our $HTTPblocking = 0;
our $HTTPSblocking = 0;
our $HTTPS_OCSP_NO_STAPLE = 1;      # disable OCSP staple
our $HTTPS_NO_VERIFY = 1;           # disable certificate verification and CRL

# set the blocking mode for STATS connection (0/1) - default is 0
our $STATSblocking = 0;

#set BerkeleyDB sync to off (0) or on (1)
our $DoSyncBDB = 1;
our $DoCompactBDB = 1;

# change regexes in ConfigCompileRe to allow grouping only (...) -> (?:...) to spend memory
our $RegexGroupingOnly = 1;

# enables fast import of GPB in case RDBM is used
our $GPBFastImport = 1;

# (number) limit the connection count per IP for relay - 0 and noMaxSMTPSessions disables the check
our $maxSMTPipRelaySessions = 0;

# whois servers
our %whois_servers = (
    'RIPE'=>'whois.ripe.net',
    'APNIC'=>'whois.apnic.net',
    'KRNIC'=>'whois.krnic.net',
    'LACNIC'=>'whois.lacnic.net',
    'ARIN'=>'whois.arin.net',
    'AFRINIC'=>'whois.afrinic.net',
);


#################################################################
# BUT at least from here - custom code changes are not required #
#################################################################

## end ccc ##

sub sockclose {
    my $socket = shift;
    my %closeparms;
    $@ = $! = undef;

    return 1 unless ref($socket);

    # destroy the SMTP SSL context on close if requested or required
    # otherwise we keep the existing permanent SSL context
    if ("$socket" =~ /SSL/io) {
        if ($enablePermanentSSLContext) {   # permanent SSL context is enabled
            %closeparms = ('SSL_ctx_free' => 1) if (${*$socket}{_SSL_arguments}->{SSL_ctx_free});  # SSL_ctx_free was defined at context or connection creation
        } else {
            %closeparms = ('SSL_ctx_free' => 1) if (${*$socket}{_SSL_arguments}->{SSL_ctx_free});  # SSL_ctx_free was defined at context or connection creation
            %closeparms = ('SSL_ctx_free' => 1) if (exists $Con{$socket} && $Con{$socket}->{type} eq 'S'); # we are the SSL client and used temp context
            %closeparms = ('SSL_ctx_free' => 1) if (! exists $Con{$socket} && ! exists $WebConH{$socket} && ! exists $StatConH{$socket}); # not a SMTP, WEB or stat socket
        }
    }

    if ($closeparms{'SSL_ctx_free'} && (my $ctx = ${*$socket}{'_SSL_ctx'})) {
        delete $SSLServerContext{$SSLServerContextList{$ctx}};   # remove the SSL-Context from the context list
        delete $SSLServerContextList{$ctx};                      # remove the SSL-Context object itself
    }

    # try to close the socket anyway
    return 1 if eval {("$socket" =~ /SSL/io) ? $socket->close(\%closeparms) : $socket->close ;};
    return 1 if eval {close($socket);};
    if ("$socket" =~ /SSL/io) {
        return 1 if eval{IO::Socket::SSL::kill_socket($socket);};
    }
    return 0;
}

# build proper version strings from versions and build numbers
# and compare versions/builds
# $mod can be any of 'cmp','gt','lt','<=>','>','<'
sub compareVersions {
    # @V         0      1      2      3     4
    # @V is ( $verA, $buildA, $mod, $verB, $buildB)
    my (@V) = @_;
    eval{require version} or return;

    # if mod is not or wrong given, 'cmp' is used
    $V[2] = 'cmp' if ! defined($V[2]) || $V[2] !~ /^ *(?:cmp|gt|lt|<=>|>|<) *$/o;

    for (1,4) {  # builds
        $V[$_] = $1 if (! defined($V[$_]) && $V[$_-1] =~ s/\s*\((\d{5}(?:\.\d+)*)\)\s*$//o);    # all is given in verA - split it
    }

    for (0,3) {  # versions
        $V[$_] =~ s/RC|_/./go;                          # replace release candidate sign and underscore with dot
        $V[$_] =~ s/[^\d.]//go;                         # remove non digit/dot from version
        $V[$_] .= '.' if $V[$_] && $V[$_] !~ /\.$/o;    # add a dot to the version string if there is not one
    }
    for (1,4) {  # builds
        $V[$_] =~ s/[^\d.]//go;                         # remove non digit/dot from build
    }

    for (0,3) {  # versions
        $V[$_] .= $V[$_+1];                             # append the build to the version
        $V[$_] =~ s/\.\.+/./go;                         # replace multiple dots with a single one
        $V[$_] =~ s/\.$//o;                             # remove a trailing dot
    }

    # build the perl statement to make version objects and to compare the versions
    my $run = 'version->parse('."'".$V[0]."') $V[2] ".'version->parse('."'".$V[3]."')";
    # run the statement and return the result
    return eval($run);
}

# static config sharing vars
our $syncToDo:shared;
our $syncUser;
our $syncIP;
our %neverShareCFG = (
    'DisableSMTPNetworking' => 1,
    'defaultLocalHost' => 1,
    'myServerRe' => 1,
    'pbdb' => 1,
    'DelayShowDB' => 1,
    'DelayShowDBwhite' => 1,
    'base' => 1,
    'spamdb' => 1,
    'whitelistdb' => 1,
    'redlistdb' => 1,
    'persblackdb' => 1,
    'griplist' => 1,
    'droplist' => 1,
    'delaydb' => 1,
    'ldaplistdb' => 1,
    'adminusersdb' => 1,
    'mysqlSlaveMode' => 1,
    'fillUpImportDBDir' => 1,
    'ImportMysqlDB' => 1,
    'ExportMysqlDB' => 1,
    'LDAPShowDB' => 1,
    'forceLDAPcrossCheck' => 1,
    'myName' => 1,
    'myNameAlso' => 1,
    'asspCfg' => 1,
    'asspCfgVersion' => 1,
    'NumComWorkers' => 1,
    'ReservedOutboundWorkers' => 1,
    'RebuildSchedule' => 1,
    'ReplaceOldSpamdb' => 1,
    'RunRebuildNow' => 1,
    'globalClientName' => 1,
    'globalClientPass' => 1,
    'globalClientLicDate' => 1,
    'DoGlobalBlack' => 1,
    'globalValencePB' => 1,
    'globalBlackExpiration' => 1,
    'DoGlobalWhite' => 1,
    'globalWhiteExpiration' => 1,
    'GPBDownloadLists' => 1,
    'GPBautoLibUpdate' => 1,
    'BlockRepForwHost' => 1,
    'BlockReportNow' => 1,
    'POP3ConfigFile' => 1,
    'POP3Interval' => 1,
    'POP3fork' => 1,
    'POP3KeepRejected' => 1,
    'POP3debug' => 1,
    'BerkeleyDB_DBEngine' => 1,
    'TLDS' => 1,
    'URIBLCCTLDS' => 1,
    'localBackDNSFile' => 1,
    'asspCpuAffinity' => 1,
    'MemoryUsageLimit' => 1,
    'UUID' => 1,

# never share the sync vars
    'enableCFGShare' => 1,
    'isShareMaster' => 1,
    'isShareSlave' => 1,
    'syncServer' => 1,
    'syncUsesSSL' => 1,
    'syncTestMode' => 1,
    'syncConfigFile' => 1,
    'syncCFGPass' => 1,
    'syncShowGUIDetails' => 1
);
### end sharing vars

BEGIN {$nointchk = 'int';}
our $TimeZoneDiff:shared;
sub TimeZoneDiff {
    my $t = time;
    $TimeZoneDiff = Time::Local::timelocal(localtime($t))-Time::Local::timelocal(gmtime($t));
    d("TimeZoneDiff: $t seconds to GMT",1);
    return $TimeZoneDiff;
}
BEGIN {__cs}
*{'Time::HiRes::gmtime'} = sub {Time::HiRes::time - TimeZoneDiff();};

sub getCodePart {
    my ($fn,$re) = @_;
    return unless $fn;
    return unless $eF->( $fn );
    return if $dF->( $fn );
    my $msg;
    $open->(my $F,'<', $fn ) or return;
    $F->binmode;
    $F->read($msg,fsize($fn));
    $F->close;
    if ($re) {
        return $1 if $msg =~ /$re/;
        return;
    }
    return uc $1 if $msg =~ /sub\s+__cs\s*\{[^\']+\'([^\']+)\'/o;
    return;
}

sub getSHAFile {
    my ($fn,$re) = @_;
    return unless $fn;
    return unless $eF->( $fn );
    return if $dF->( $fn );
    return unless eval('use Digest::SHA1 qw(sha1_hex); 1;')
               || eval('use Digest::SHA qw(sha1_hex); $shamod = \'Digest::SHA\'; 1;')
               || eval('use Crypt::Digest::SHA1 qw(sha1_hex); $shamod = \'Crypt::Digest::SHA1\'; 1;');
    my $msg;
    $open->(my $F,'<', $fn ) or return;
    $F->binmode;
    $F->read($msg,fsize($fn));
    $F->close;
    if ($re && $msg =~ /$re/) {
        return sha1_hex($1.$2.$3);
    } else {
        return sha1_hex($msg);
    }
}

# some special regular expressions
our $NOCRLF;
our $ScheduleRe;
our $ScheduleGUIRe;
our $neverMatch;
our $neverMatchRE;
our $punyRE;
our $EmailAdrRe;
our $EmailDomainRe;
our $HeaderNameRe;
our $HeaderValueRe;
our $HeaderRe;
our $UUENCODEDRe;
our $UTFBOMRE;
our $UTF8BOMRE;
our $UTF8BOM;
our $complexREStart;
our $complexREEnd;
our $dot;
our $UriDot;
our $UriCollon;
our $UriAt;
our $NONPRINT;
our $NONASCII;
our $HamTagRE;
our $SpamTagRE;
our $ValencePBRE;
our $ValencePB2RE;
our $NonSymLangRE;
our $SymLangRE;
our $enclosedCharsRE;
our $uniSpecialsRE;
our $notAllowedSMTP;
our $BIT8:shared = 'XNONOXNONOX';
our $skipAddrListRE;
our $vrfyOKRE = qr/^25[01]$/;
our $DMARCReportSubjectRe;
our $ExchangeBannerRe;

# IP Address representations
our $IPprivate;
our $IPloopback;
our $IPQuadSectRE;
our $IPQuadSectDotRE;
our $IPQuadRE;
our $IPStrictQuadRE;
our $RFC822RE;

# Host
our $IPSectRe;
our $IPSectHexRe;
our $IPSectDotRe;
our $IPSectHexDotRe;
our $IPRe;
our $IPv4Re;
our $IPv6Re;
our $IPv6LikeRe;
our $PortRe;
our $HostRe;
our $HostPortRe;

# regex to detect html content in plain text mail bodys
our $htmlDetectRe;

# for GUI check
our $GUIHostPort;

# the global Plugin config ARRAY
our @PlCfg;

# some special variables to DEBUG IO and Poll Errors and to reduce memory usage
our $CloseHandleOnPollError = 1;
our $undefMEM = 1;
our $printVars;
our $countRefs;
our %Vars2Print;
our %Refs2Count;
our $process_external_cmdqueue:shared = unlink("$base/cmdqueue");
print "\nexternal CMD-queue '$base/cmdqueue' registered " if $process_external_cmdqueue;
# end of DEBUG special vars

#DKIM html to base64 conversion (0/1) - default is 0 - set it to 1 to workaround an issue in older Mail::DKIM or mail servers/clients
our $DKIMconvHTML2base64 = 0;
#DKIM any text containing mail part to base64 conversion (0/1) for bounced mails - default is 1
our $DKIMconvBounces2base64 = 1;

# runtime variable
our $runHMMusesBDB:shared;

our $dftcSSLVersion;
our $dftcSSLCipherList;
our $dftsSSLVersion;
our $dftsSSLCipherList;
our $dftExpSec;

srand();

our %cryptConfigVars:shared = (
    'myuser' => 1,
    'mypassword' => 1,
    'exportDBDir' => 1,
    'ExportMysqlDB' => 1,
    'LDAPLogin' => 1,
    'LDAPPassword' => 1,
    'adminusersdb' => 1,
    'adminusersdbpass' => 1,
    'adminusersdbNoBIN' => 1,
    'Notify' => 1,
    'NotifyRe' => 1,
    'NoNotifyRe' => 1,
    'proxyuser' => 1,
    'proxypass' => 1,
    'globalRegisterURL' => 1,
    'globalUploadURL' => 1,
    'globalClientPass' => 1,
    'globalClientName' => 1,
    'SSLCaFile' => 1,
    'SSLCertFile' => 1,
    'SSLKeyFile' => 1,
    'SSLPKPassword' => 1,
    'SSL_version' => 1,
    'SSL_cipher_list' => 1,
    'SSLAdvancedServerConfigFile' => 1,
    'SSLWEBCertVerifyCB' => 1,
    'SSLWEBConfigure' => 1,
    'SSLSTATCertVerifyCB' => 1,
    'SSLSTATConfigure' => 1,
    'SSLSMTPCertVerifyCB' => 1,
    'SSLSMTPConfigure' => 1,
    'SRSSecretKey' => 1,
    'relayAuthUser' => 1,
    'relayAuthPass' => 1,
    'syncCFGPass' => 1,
    'Groups' => 1,
    'SNMPUser' => 1,
    'MSGIDpreTag' => 1,
    'MSGIDSec' => 1,
    'BATVSec' => 1,
    'AutoRestartCmd' => 1,
    'FileScanCMD' => 1,
    'ASSP_OCRExec' => 1,
    'ASSP_AFCWebScript' => 1,
    'ASSP_AFCSMIME' => 1,
    'ASSP_ARCSelectCode' => 1,
    'ASSP_RSSSelectCode' => 1,
    'runAsUser' => 1,
    'runAsGroup' => 1,
    'runAsGroupSupplementary' => 1,
    'ConfigChangeSchedule' => 1,
    'UUID' => 1,
    'debugCode' => 1,
    'VirusTotalAPIKey' => 1
);

#####################################################################
# assp license mapping
#####################################################################
our $licmap = {
    '00' => 'main',
    '01' => 'name',
    '02' => 'type',
    '03' => 'terms',
    '04' => 'terms-url',
    '05' => 'copyright',
    '06' => 'vendor contact',
    '07' => 'assigned to',
    '08' => 'expiration date',
    '09' => 'hostname',
    '10' => 'license number',
    '11' => 'usage limit',
    '12' => 'usage limit description',
    '13' => 'current usage',
};
# Plugin and feature license registering HASH
our $reglic = {};

#####################################################################
# global Unicode definitions
# assp will die at startup immediately if unicode is not installed OK
#####################################################################

our @NonSymLangs;
our @SymLangs;
our @EnclosedUNI;
our @UnicodeBlocks;
our @UnicodeScripts;
our $UnicodeVersion;
our %uniSpecials;

BEGIN {
my $charscripts = sub {
    my %s;
    my $list = do "unicore/To/Sc.pl";
    die "assp.pl: failed to find unicore/To/Sc.pl in @INC\n" unless $list;
    for (split /^/m, $list) {
        my ($start, $end, $value) = / ^ (.+?) \t (.*?) \t (.+?)
                                        \s* ( \# .* )?  # Optional comment
                                        $ /x;
        $s{$value} = 1;
    }

    return keys(%s);
};

my $openunicode = sub {
    my ($rfh, @path) = @_;
    my $f;
    unless (defined $$rfh) {
    	for my $d (@INC) {
    	    use File::Spec;
    	    $f = File::Spec->catfile($d, "unicore", @path);
    	    last if open($$rfh,'<',$f);
    	    undef $f;
    	}
    	die "assp.pl: failed to find ",
                  File::Spec->catfile(@path), " in @INC"
    	    unless defined $f;
    }
    return $f;
};

# get the UnicodeBlocks
my $BLOCKSFH;
if ($openunicode->(\$BLOCKSFH, "Blocks.txt")) {
    local $_;
    local $/ = "\n";
    while (<$BLOCKSFH>) {
        if (/^(?:[0-9A-F]+)\.\.(?:[0-9A-F]+);\s+(.+)/) {
            push(@UnicodeBlocks,$1);
        }
    }
    $BLOCKSFH->close;
}
#get the unicode version
$BLOCKSFH = undef;
if ($openunicode->(\$BLOCKSFH, "version")) {
    $UnicodeVersion = <$BLOCKSFH>;
    $UnicodeVersion =~ s/\r|\n//og;
    $BLOCKSFH->close;
}
# set non symbolic chars
@NonSymLangs =  (
    'Alphabetic Presentation Forms',
    'Arabic',
    'Arabic Presentation Forms-A',
    'Arabic Presentation Forms-B',
    'Armenian',
    'Basic Latin',
    'Cyrillic',
    'Georgian',
    'Gothic',
    'Greek Extended',
    'Greek and Coptic',
    'Hebrew',
    'Latin-1 Supplement',
    'Latin Extended-A',
    'Latin Extended Additional',
    'Latin Extended-B',
    'Mathematical Alphanumeric Symbols',
    'Mathematical Operators',
    'Old Italic',
    'Optical Character Recognition'
);

# set Enclosed Chars
@EnclosedUNI = (
    'Enclosed Alphanumerics',
    'Enclosed Alphanumeric Supplement',
    'Enclosed CJK Letters And Months'
);

# set SymLangs
for my $bl (@UnicodeBlocks) {
    push(@SymLangs,$bl) unless(grep {/^$bl$/} @NonSymLangs);
}

# set Unicode Scripts
@UnicodeScripts = $charscripts->();

# first we specify, what Unicode::Normalize is not doing like we want it
%uniSpecials = (chr(0x24FF) => 0);

for (0x24F5...0x24FE) {$uniSpecials{chr($_)} = $_ - 0x24F4;}   # 1 - 10
for (0x2776...0x277F) {$uniSpecials{chr($_)} = $_ - 0x2775;}   # 1 - 10
for (0x2780...0x2789) {$uniSpecials{chr($_)} = $_ - 0x2779;}   # 1 - 10
for (0x278A...0x2793) {$uniSpecials{chr($_)} = $_ - 0x2789;}   # 1 - 10
for (0x3220...0x3229) {$uniSpecials{chr($_)} = '('.($_ - 0x321F).')';}   # (1 - 10)

for (0x24EB...0x24F4) {$uniSpecials{chr($_)} = 10 + $_ - 0x24EA;} # 11 - 20
for (0x3248...0x324F) {$uniSpecials{chr($_)} = 10 * ($_ - 0x3247);} # 10 20 30 ... 80

for (0x1F150...0x1F169) {$uniSpecials{chr($_)} = chr(0x40 + $_ - 0x1F14F);} # 10 20 30 ... 80

} # end BEGIN

sub setSpecialRegex {
my $w = 'a-zA-Z0-9_';
my $d = '0-9';
$NOCRLF = '\x00-\x09\x0b-\x0c\x0e-\xff';
$ScheduleRe = '(?:\S+\s+){4}\S+';
$ScheduleGUIRe = '^('.$ScheduleRe.'(?:\|'.$ScheduleRe.")*|[$d]+|)\$";
$neverMatch = '^(?!)';
$neverMatchRE = quotemeta($neverMatch).'\)?\$?\)*$';
$ExchangeBannerRe = qr/M(?:icro)?S(?:oft)?\s*(?:E?SMTPS? MAIL|Exchange)/i; # check if we connected to MS exchange
$punyRE = 'xn--[a-zA-Z0-9\-]{1,59}';
# ignore the first possible single quote in the user part of an address  (x27)

$EmailAdrRe=qr/[\x21\x23-\x26\x2a-\x2b\x2d-\x39\x3d\x3f\x41-\x5a\x5c\x5e-\x7e][\x21\x23-\x27\x2a-\x2b\x2d-\x39\x3d\x3f\x41-\x5a\x5c\x5e-\x7e]*/o;
#$EmailAdrRe=qr/[^()<>@,;:'"\[\]\000-\040\x7F-\xFF][^()<>@,;:"\[\]\000-\040\x7F-\xFF]*/o;  # 30% slower than the above

#$EmailDomainRe=qr/(?:[$w][$w\-]*(?:\.[$w][$w\-]*)*\.(?:$punyRE|[$w][$w]+)|\[[$d][$d\.]*\.[$d]+\])/o; # old variant
$EmailDomainRe=qr/(?:[$w][$w\-]{0,62}(?:\.[$w][$w\-]{0,62})*\.(?:$punyRE|[$w][$w]{1,62})|\[[$d][$d\.]*\.[$d]+\])/o;  # with length restriction
#$EmailDomainRe=qr/(?:(?:(?=[a-zA-Z0-9-]{1,63}\.)(?:xn--)?[a-zA-Z0-9]+(?:-[a-zA-Z0-9]+)*\.)+(?=[a-zA-Z0-9-]{2,63}(?:[^a-zA-Z0-9-]|$))(?:xn--)?[a-zA-Z0-9]+(?:-[a-zA-Z0-9]+?)*[a-zA-Z0-9])/o;

$DMARCReportSubjectRe = '(?:^\s*Report\s*domain:\s*'.$EmailDomainRe.'\s+Submitter:\s*'.$EmailDomainRe.'\s+Report-?ID:.{2,})' .  # the RFC conform format of a DMARC report subject
                        (@DMARCReportAddSubjectRe ? '|' : '') .
                        join('|', map {my $t = $_; $t =~ s/\$EmailDomainRe/$EmailDomainRe/go; $t; } @DMARCReportAddSubjectRe);  # add nonconform subjects regex
$DMARCReportSubjectRe = qr/$DMARCReportSubjectRe/i;
$HeaderNameRe=qr/[\x21-\x39\x3B-\x7E]+/o; # printable ASCII except SPACE(\x20) and colon(: \x3A)
$HeaderValueRe=qr/[ \t]*[$NOCRLF]*(?:\r?\n[ \t]+\S[$NOCRLF]*)*(?:\r?\n)?/o;
$HeaderRe=qr/(?:$HeaderNameRe:$HeaderValueRe)/o;
$UUENCODEDRe=qr/\bbegin\b [$d]{3} \b\S{0,72}.*?\S{61}.{0,61}\bend\b/o;
$UTF8BOM = "\xEF\xBB\xBF";
# BOM - Byte-OrderMark - https://de.wikipedia.org/wiki/Byte_Order_Mark
#                   UTF-32BE           UTF-32LE    UTF-16BE UTF-16LE         UTF-7                        UTF-1      UTF-EBCDIC      SCSU        BOCU-1            GB18030          UTF-8
$UTFBOMRE = qr/(?:\x00\x00\xFE\xFF|\xFF\xFE\x00\x00|\xFE\xFF|\xFF\xFE|\x2B\x2F\x76[\x38\x39\x2B\x2F]|\xF7\x64\x4C|\xDD\x73\x66\x73|\x0E\xFE\xFF|\xFB\xEE\x28\xFF?|\x84\x31\x95\x33|$UTF8BOM)/o;
$UTF8BOMRE = qr/(?:$UTF8BOM)/o;
$NONPRINT = qr/[\x00-\x1F\x7F-\xFF]/o;
$NONASCII = qr/[\x00-\x08\x0B\x0C\x0E-\x1F\x80-\xFF]/o;
$complexREStart = '^(?=.*?(((?!)';
$complexREEnd = '(?!)).*?(?!\g{-1})){';
$notAllowedSMTP = qr/CHUNKING|PIPELINING|XEXCH50|CHECKPOINT|TRANSID|
                     PIPE_?CONNECT|
                     SMTPUTF8|UTF8REPLY|
                     UTF8SMTP|UTF8SMTPA|UTF8SMTPS|UTF8SMTPAS|
                     UTF8LMTP|UTF8LMTPA|UTF8LMTPS|UTF8LMTPAS|
                     XCLIENT|XFORWARD|
                     TURN|ATRN|ETRN|TURNME|X-TURNME|XTRN|
                     SEND|SOML|SAML|EMAL|ESAM|ESND|ESOM|
                     XAUTH|XQUE|XREMOTEQUEUE|XQDISCARD|
                     X-EXPS|X-ADAT|X-DRCP|X-ERCP|EVFY|
                     BINARYMIME|BDAT|
                     AUTH\x20GSSAPI|AUTH\x20NTLM|X-LINK2STATE|
                     NTLM|GSSAPI|XSHADOW|XRDST|X-ANONYMOUSTLS|XSAVETOSENT|
                     X-STARTTLS
                  /oix;

# skip these addresses from personal black processing
$skipAddrListRE = qr(/\w+\.[a-z0-9]{2,4}\@[0-9a-f]{8}\.[0-9a-f]{8}$/i);
$dftExpSec = '$dftExpSec';

# IP Address representations
my $sep;
my $v6Re = '[0-9A-Fa-f]{1,4}';
$IPSectRe = "(?:25[0-5]|2[0-4][$d]|1[$d]{2}|0?[$d]?[$d])";
$IPSectHexRe = '(?:(?:0x)?(?:[A-Fa-f][A-Fa-f0-9]?|[A-Fa-f0-9]?[A-Fa-f]))';

# private IP addresses
$IPprivate  = '((?:0{1,3}|127|2(?:2[4-9]|[34][0-9]|5[0-5]))(?:\.'.$IPSectRe.'){3}|169\.254(?:\.'.$IPSectRe.'){2}|0?10(?:\.'.$IPSectRe.'){3}|192\.168(?:\.'.$IPSectRe.'){2}|172\.0?1[6-9](?:\.'.$IPSectRe.'){2}|172\.0?2[0-9](?:\.'.$IPSectRe.'){2}|172\.0?3[01](?:\.'.$IPSectRe.'){2})';   #RFC 1918 decimal
$IPprivate .= '|(?:(?:0x)?(?:00?|7[Ff]|[eEfF][0-9a-fA-F])(?:\.'.$IPSectHexRe.'){3}|(?:0x)?[aA]9\.(?:0x)?[Ff][Ee](?:\.'.$IPSectHexRe.'){2}|(?:0x)?0[aA](?:\.'.$IPSectHexRe.'){3}|(?:0x)?[Cc]0\.(?:0x)?[Aa]8(?:\.'.$IPSectHexRe.'){2}|(?:0x)?[Aa][Cc]\.(?:0x)?1[0-9a-fA-F](?:\.'.$IPSectHexRe.'){2})';   #RFC 1918 Hex
$IPprivate .= '|(?:0{0,4}:){2,6}'.$IPprivate;  # private IPv4 in IPv6
$IPprivate .= '|(?:0{0,4}::|(?:0{1,4}:){7}|(?:0{1,4}:){1,6}:)1';  # IPv6 loopback
$IPprivate .= '|::';  # IPv6 universal local

$IPloopback = '^(?:127(?:\.'.$IPSectRe.'){3}|(?:0{0,4}::|(?:0{1,4}:){7}|(?:0{1,4}:){1,6}:)1)$'; # IPv4 and IPv6 loopback interfaces

$IPQuadSectRE="(?:0([0-7]+)|0x([0-9a-fA-F]+)|([$d]+))";
$IPQuadSectDotRE='(?:'.$IPQuadSectRE.'\.)';
$IPQuadRE=qr/$IPQuadSectDotRE?$IPQuadSectDotRE?$IPQuadSectDotRE?$IPQuadSectRE/o;

#$dot = '[^a-zA-Z0-9\.]?d[^a-zA-Z0-9\.]?o[^a-zA-Z0-9\.]?t[^a-zA-Z0-9\.]?|[\=\%]2[eE]|\&\#0?46\;?';      # the DOT
$dot = '[\x00-\x2d\x2f\x3a-\x40\x5b-\x60\x7b-\xff]?d[\x00-\x2d\x2f\x3a-\x40\x5b-\x60\x7b-\xff]?o[\x00-\x2d\x2f\x3a-\x40\x5b-\x60\x7b-\xff]?t[\x00-\x2d\x2f\x3a-\x40\x5b-\x60\x7b-\xff]?|[\=\%]2[eE]|\&\#0?46\;?';      # the DOT
$UriDot =    '(?:(?i:(?:[\=\%]|\&\#x)2e|\&\#0?46)\;?|\.)';
$UriCollon = '(?:(?i:(?:[\=\%]|\&\#x)3a|\&\#0?58)\;?|\:)';
$UriAt =     '(?:(?i:(?:[\=\%]|\&\#x)40|\&\#0?64)\;?|\@)';

$IPSectDotRe = '(?:'.$IPSectRe.'\.)';
$IPSectHexDotRe = '(?:'.$IPSectHexRe.'\.)';
$IPv4Re = qr/(?:
(?:$IPSectDotRe){3}$IPSectRe
|
(?:$IPSectHexDotRe){3}$IPSectHexRe
)/xo;

# private IPv6 addresses
# https://www.iana.org/assignments/iana-ipv6-special-registry/iana-ipv6-special-registry.xhtml
$IPprivate .= <<EOT;
# 0000::/16 2002::/16 FE80::/10       FC00::/7
|(?i:0{1,4}|2002|FE[89A-F][0-9A-F]|F[CDF][0-9A-F][0-9A-F]):
(?:
(?:(?:$v6Re:){6}(?:                                $v6Re      |:))|
(?:(?:$v6Re:){5}(?:                   $IPv4Re |   :$v6Re      |:))|
(?:(?:$v6Re:){4}(?:                  :$IPv4Re |(?::$v6Re){1,2}|:))|
(?:(?:$v6Re:){3}(?:(?:(?::$v6Re)?    :$IPv4Re)|(?::$v6Re){1,3}|:))|
(?:(?:$v6Re:){2}(?:(?:(?::$v6Re){0,2}:$IPv4Re)|(?::$v6Re){1,4}|:))|
(?:(?:$v6Re:)   (?:(?:(?::$v6Re){0,3}:$IPv4Re)|(?::$v6Re){1,5}|:))|
                (?:(?:(?::$v6Re){0,4}:$IPv4Re)|(?::$v6Re){1,6}|:)
)

# 2001:0db8::/32       2001:0003::/32   2001:0010::/28 2001:0020::/28
|(?i:2001:0?[dD][bB]8)|2001:0{0,3}3|2001:0{0,2}[12][0-9A-Fa-f]:
(?:
(?:(?:$v6Re:){5}(?:                                $v6Re      |:))|
(?:(?:$v6Re:){4}(?:                   $IPv4Re |   :$v6Re      |:))|
(?:(?:$v6Re:){3}(?:                  :$IPv4Re |(?::$v6Re){1,2}|:))|
(?:(?:$v6Re:){2}(?:(?:(?::$v6Re)?    :$IPv4Re)|(?::$v6Re){1,3}|:))|
(?:(?:$v6Re:)   (?:(?:(?::$v6Re){0,2}:$IPv4Re)|(?::$v6Re){1,4}|:))|
                (?:(?:(?::$v6Re){0,3}:$IPv4Re)|(?::$v6Re){1,5}|:)
)

# 2001::/23
|2001:
(?:
(?:(?:0{1,4}:(?:(?::$v6Re){1,5}|$v6Re(?::$v6Re){1,5}))|(?::$v6Re){1,6}|:)
|0?[01]?[0-9a-fA-F]?[0-9a-fA-F]:(?:(?::$v6Re){1,5}|$v6Re(?::$v6Re){1,5}|:)
)

# 0064:FF9B:0000:0000:0000:0000::/96
|(?i:0?0?64:FF9B):(?:(?:0{1,4}:){4}(?::$v6Re|$v6Re:$v6Re|:)|(?:(?::$v6Re){1,2}|:))

# 2620::004F:8000::/48  0064:FF9B:0001::/48 2001:0004:0112::/48 2001:0002:0000::/48  # the last one is odd (0000)
|(?i:2620:0?0?4F:8000|0?0?64:FF9B:0?0?0?1|2001:0{0,3}4:0?112|2001:0{0,3}2:0{1,4}):
(?:
(?:(?:$v6Re:){4}(?:                                $v6Re      |:))|
(?:(?:$v6Re:){3}(?:                   $IPv4Re |   :$v6Re      |:))|
(?:(?:$v6Re:){2}(?:                  :$IPv4Re |(?::$v6Re){1,2}|:))|
(?:(?:$v6Re:)   (?:(?:(?::$v6Re)?    :$IPv4Re)|(?::$v6Re){1,3}|:))|
                (?:(?:(?::$v6Re){0,2}:$IPv4Re)|(?::$v6Re){1,4}|:)
)

# 0100:0000:0000:0000::/64
|0?100:(?:(?:0{1,4}:){3}(?::$v6Re(:$v6Re){0,2}|:)|(?:(?::$v6Re){1,4}|:))
EOT
$IPprivate = qr/^(?:$IPprivate)$/xo;

# RFC4291, section 2.2, "Text Representation of Addresses"
$sep = '[:-]';
$IPv6Re = $IPv6LikeRe = <<EOT;
(?:
(?:(?:$v6Re$sep){7}(?:                                         $v6Re      |$sep))|
(?:(?:$v6Re$sep){6}(?:                         $IPv4Re |   $sep$v6Re      |$sep))|
(?:(?:$v6Re$sep){5}(?:                     $sep$IPv4Re |(?:$sep$v6Re){1,2}|$sep))|
(?:(?:$v6Re$sep){4}(?:(?:(?:$sep$v6Re)?    $sep$IPv4Re)|(?:$sep$v6Re){1,3}|$sep))|
(?:(?:$v6Re$sep){3}(?:(?:(?:$sep$v6Re){0,2}$sep$IPv4Re)|(?:$sep$v6Re){1,4}|$sep))|
(?:(?:$v6Re$sep){2}(?:(?:(?:$sep$v6Re){0,3}$sep$IPv4Re)|(?:$sep$v6Re){1,5}|$sep))|
(?:(?:$v6Re$sep)   (?:(?:(?:$sep$v6Re){0,4}$sep$IPv4Re)|(?:$sep$v6Re){1,6}|$sep))|
(?:        $sep    (?:(?:(?:$sep$v6Re){0,5}$sep$IPv4Re)|(?:$sep$v6Re){1,7}|$sep))
)
EOT

$IPv6Re =~ s/\Q$sep\E/:/go;
$IPv6Re = qr/$IPv6Re/xo;
$IPv6LikeRe = qr/$IPv6LikeRe/xo;

$IPRe = qr/(?:
$IPv4Re
|
$IPv6Re
)/xo;

# re for a single port - could be number 1 to 65535
$PortRe = qr/(?:(?:6553[0-5])|(?:655[0-2][$d])|(?:65[0-4][$d]{2})|(?:6[0-4][$d]{3})|(?:[1-5][$d]{4})|(?:[1-9][$d]{0,3}))/o;
# re for a single host - could be an IP a name or a fqdn
$HostRe = qr/(?:(?:$IPv4Re|\[?$IPv6Re\]?)|$EmailDomainRe|[$w][$w]+)/o;
$HostPortRe = qr/$HostRe:$PortRe/o;

$GUIHostPort = qr/^((?:(?:(?i:SSL:)?(?:$PortRe|$HostPortRe)|_*(?i:INBOUND)_*(?::$PortRe)?)(?:\|(?i:SSL:)?(?:$PortRe|$HostPortRe))*)|)$/o;

$RFC822RE = <<'EOF';
[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\
xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xf
f\n\015()]*)*\)[\040\t]*)*(?:(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\x
ff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|"[^\\\x80-\xff\n\015
"]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015"]*)*")[\040\t]*(?:\([^\\\x80-\
xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80
-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*
)*(?:\.[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\
\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\
x80-\xff\n\015()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x8
0-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|"[^\\\x80-\xff\n
\015"]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015"]*)*")[\040\t]*(?:\([^\\\x
80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^
\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040
\t]*)*)*@[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([
^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\
\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\
x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-
\xff\n\015\[\]]|\\[^\x80-\xff])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()
]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\
x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:\.[\04
0\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\
n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\
015()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?!
[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\
]]|\\[^\x80-\xff])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\
x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\01
5()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*)*|(?:[^(\040)<>@,;:".
\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]
)|"[^\\\x80-\xff\n\015"]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015"]*)*")[^
()<>@,;:".\\\[\]\x80-\xff\000-\010\012-\037]*(?:(?:\([^\\\x80-\xff\n\0
15()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][
^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)|"[^\\\x80-\xff\
n\015"]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015"]*)*")[^()<>@,;:".\\\[\]\
x80-\xff\000-\010\012-\037]*)*<[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?
:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-
\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:@[\040\t]*
(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015
()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()
]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\0
40)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\
[^\x80-\xff])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\
xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*
)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:\.[\040\t]*(?:\([^\\\x80
-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x
80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t
]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\
\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])
*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x
80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80
-\xff\n\015()]*)*\)[\040\t]*)*)*(?:,[\040\t]*(?:\([^\\\x80-\xff\n\015(
)]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\
\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*@[\040\t
]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\0
15()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015
()]*)*\)[\040\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(
\040)<>@,;:".\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|
\\[^\x80-\xff])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80
-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()
]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:\.[\040\t]*(?:\([^\\\x
80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^
\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040
\t]*)*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".
\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff
])*\])[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\
\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x
80-\xff\n\015()]*)*\)[\040\t]*)*)*)*:[\040\t]*(?:\([^\\\x80-\xff\n\015
()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\
\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*)?(?:[^
(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-
\037\x80-\xff])|"[^\\\x80-\xff\n\015"]*(?:\\[^\x80-\xff][^\\\x80-\xff\
n\015"]*)*")[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|
\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))
[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:\.[\040\t]*(?:\([^\\\x80-\xff
\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\x
ff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(
?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\
000-\037\x80-\xff])|"[^\\\x80-\xff\n\015"]*(?:\\[^\x80-\xff][^\\\x80-\
xff\n\015"]*)*")[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\x
ff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)
*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*)*@[\040\t]*(?:\([^\\\x80-\x
ff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-
\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)
*(?:[^(\040)<>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\
]\000-\037\x80-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\]
)[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-
\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\x
ff\n\015()]*)*\)[\040\t]*)*(?:\.[\040\t]*(?:\([^\\\x80-\xff\n\015()]*(
?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]*(?:\\[^\x80-\xff][^\\\x80
-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)*\)[\040\t]*)*(?:[^(\040)<
>@,;:".\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\[\]\000-\037\x8
0-\xff])|\[(?:[^\\\x80-\xff\n\015\[\]]|\\[^\x80-\xff])*\])[\040\t]*(?:
\([^\\\x80-\xff\n\015()]*(?:(?:\\[^\x80-\xff]|\([^\\\x80-\xff\n\015()]
*(?:\\[^\x80-\xff][^\\\x80-\xff\n\015()]*)*\))[^\\\x80-\xff\n\015()]*)
*\)[\040\t]*)*)*>)
EOF

$RFC822RE =~ s/\r?\n//go;
$RFC822RE = qr/^$RFC822RE$/;

$SpamTagRE = qr/(?:
                  \[
                  (?:
                   Attachment | AUTHError | AUTHUserIP

                   Backscatter | BATV | Bayesian |
                   BlackDomain | BlackHELO | BombBlack |
                   BombData | BombHeader | BombRe |
                   BombScript | BombSender |
#                   BounceAddress |

                   Collect | Connection | CountryCode |

                   DCC | DNSBL | Delayed | DenyIP |
                   DenyStrict | DomainKey | DKIM | DMARC

                   Extreme | ForgedHELO |
                   ForgedLocalSender | FromMissing |

                   History | HMM |

                   IPfrequency | IPperDomain |
                   InternalAddress | InvalidAddress | InvalidHELO |

                   MailLoop | MalformedAddress | Max-Equal-X-Header |
                   MaxAUTHErrors | MaxErrors | MessageScore |
                   messageSize | MaxRealMessageSize | MaxMessageSize |
                   MissingMXA? | MsgID | MSGID-sig | missingSignature |

                   Organization | OversizedHeader |

                   PTRinvalid | PTRmissing | PenaltyBox | Penalty |

                   razor | RelayAttempt |

                   SameSubject | SPF | SRS | SpoofedSender |
                   SuspiciousHelo |

                   Trap |
                   UnknownLocalSender | unsupported[a-zA-Z0-9_]+ | URIBL |
                   VIRUS | ValidHELO |

                   WhitelistOnly
                  )
                  \] |
                   spam\sfound
               )/iox;

$HamTagRE = qr/(?:\[(?:Local|MessageOK|RWL|Whitelisted|NoProcessing)\])/io;
$ValencePBRE = qr/(\s*[$d]+\s*(?:[\|,]\s*[$d]+\s*){0,1})/o;
$ValencePB2RE = qr/(\s*-?[$d]+\s*(?:[\|,]\s*-?[$d]+\s*){0,1})/o;

$htmlDetectRe = qr
/^\s*<\s*(?:br|basefont|hr|input|source|frame|param|area|meta|!--|col|link|option|base|img|wbr|!DOCTYPE).*?>
|
<\s*(a|abbr|acronym|address|applet|article|aside|audio|b|bdi|bdo|big|blockquote|body|button|
     canvas|caption|center|cite|code|colgroup|command|datalist|dd|del|details|dfn|dialog|dir|div|dl|dt|
     em|embed|fieldset|figcaption|figure|font|footer|form|frameset|head|header|hgroup|h1|h2|h3|h4|h5|h6|html|
     i|iframe|ins|kbd|keygen|label|legend|li|map|mark|menu|meter|nav|noframes|noscript|object|ol|optgroup|output|
     p|pre|progress|q|rp|rt|ruby|s|samp|script|section|select|small|span|strike|strong|style|sub|summary|sup|
     table|tbody|td|textarea|tfoot|th|thead|time|title|tr|track|tt|u|ul|var|video|xml)
.*?
<\s*\/\s*\1\s*>
/xsio
;

# setting up unicode detection regular expressions
$NonSymLangRE = '';
for (@NonSymLangs) { $NonSymLangRE .= '\p{'.$_.'}'; }
$NonSymLangRE = qr/[$NonSymLangRE]/;

$SymLangRE = '';
for (@SymLangs) { $SymLangRE .= '\p{'.$_.'}'; }
$SymLangRE = qr/[$SymLangRE]/;

$enclosedCharsRE = '';
for (@EnclosedUNI) { $enclosedCharsRE .= '\p{'.$_.'}'; }
$enclosedCharsRE = qr/[$enclosedCharsRE]/;

foreach (keys %uniSpecials) {
    $uniSpecialsRE .= quotemeta($_).'|';
}
chop($uniSpecialsRE);
$uniSpecialsRE = qr/$uniSpecialsRE/;

# some declaration corrections
%skipDeclare = (
    'LogDateLang' => 1,
    'LogDateFormat' => 1,
    'mydb' => 1,
    'base' => 1,
    'delaySameIP' => 1,
    'UUID' => 1,
);

%neverLockTable = (
    'hmmdb' => 1,
    'spamdb' => 1,
    'spamdbhelo' => 1,
    'adminusers' => 1,
    'adminusersright' => 1,
    'backdns' => 1
);

}

##### 0 and 1 and some important primes for VT
our $YY = 1;
our $YYY = $YY;
our @char4vt = (
0,
1,
2,
3,
5,
7,
17,
23,
83,
557,
85734079,
7121494319,
221238203047,
714341211238997,
69521313294089627
);


##### base32 initializing
our %bits2char;
our @char2bits;
our @syms = ( 'a'..'z', '2'..'7' );
for (0..$#syms) {
    my $sym = $syms[$_];
    my $bin = sprintf('%05b', $_);

    $char2bits[ ord lc $sym ] = $bin;
    $char2bits[ ord uc $sym ] = $bin;

    do {
	       $bits2char{$bin} = $sym;
    } while $bin =~ s/(.+)0\z/$1/s;
}
BEGIN {
${"no$nointchk".'chk'}
=#*{assign}
(#push
$build#in $version
%#x
0xFF#and(1)
)#http://
**#11
(#$a
1#rand(x);
^#$9t+5
1#tan(1);
)#oct+
-#||ftp://
1#f&e
;}
#####
sub printVarsOn {
    %Vars2Print = ();
    %Refs2Count = ();
    return unless (open my $va,'<', "$base/debug/vardebug.txt");
    $printVars = 1;
    binmode $va;
    while (my $line = (<$va>)) {
        $line =~ s/\r|\n|\s//go;
        $line =~ s/^([^#;]*)([#;])/$1/go;
        next unless $line;
        next if $line =~ /^#|;/o;
        $Vars2Print{$line} = 1;
    }
    $va->close;
    if (open $va ,'<',"$base/debug/refcount.txt") {
        binmode $va;
        $countRefs = 1;
        while (my $line = (<$va>)) {
            $line =~ s/\r|\n|\s//go;
            $line =~ s/^([^#;]*)([#;])/$1/go;
            next unless $line;
            next if $line =~ /^#|;/o;
            $Refs2Count{$line} = 1;
        }
        $va->close;
    }
    return;
}

sub setLocalCharsets {
    $Charsets = '0:System Default|';
    $defaultLogCharset = 0;
    foreach (Encode->encodings(':all')) {
        $Charsets .= $_ . ':' . $_ . '|' if $_ !~ /mime|symbol|null|nextstep/io;
        $defaultLogCharset = $_ if ($isNoWIN &&
                                    $defaultLogCharset !~ /^utf-?8/io &&
                                    $_ =~ /^utf-?8/io);
    }
    chop $Charsets;
}

sub loadModuleVars {
    %Modules = (
      'IO::Socket::IP' => 1,
      'Thread::State' => 1,
      'File::Scan::ClamAV' => 1,
      'Net::LDAP' => 1,
      'Net::DNS' => 1,
      'Mail::SPF' => 1,
      'Mail::SRS' => 0,
      'Compress::Zlib' => 1,
      'Digest::MD5' => 1,
      'Digest::SHA1' => 1,
      'File::ReadBackwards' => 1,
      'PerlIO::scalar' => 1,
      'Sys::Syslog' => 1,
      'Win32::Daemon' => 1,
      'Win32::API::OutputDebugString' => 0,
      'Tie::RDBM' => 1,
      'Net::CIDR::Lite' => 1,
      'NetAddr::IP::Lite' => 1,
      'Net::IP' => 1,
      'LWP::Simple' => 1,
      'Email::MIME' => 1,
      'MIME::Types' => 1,
      'Email::Address::XS' => 1,
      'Convert::TNEF' => 0,
      'Mail::DKIM::Verifier' => 1,
      'Net::SMTP' => 1,
      'Net::SMTP::SSL' => 1,
      'Sys::MemInfo' => 1,
      'IO::Socket::SSL' => 1,
      'BerkeleyDB' => 1,
      'DB_File' => 0,
      'Authen::SASL' => 1,
      'Regexp::Optimizer' => 1,
      'NetSNMP::agent' => 0,
      'Time::Hi::Res' => 1,
      'AsspSelfLoader' => 1,
      'ASSP_WordStem' => 1,
      'ASSP_FC' => 1,
      'ASSP_SVG' => 1,
      'Win32::Unicode' => 1,
      'Unicode::GCString' => 1,
      'Text::Unidecode' => 1,
      'Sys::CpuAffinity' => 1,
      'ASSP_VirusTotal_API' => 1
    );
    my @cfglines;
    my $i = 3000;
    foreach (sort keys %Modules) {
        my $mod = $_;
        my $default = $Modules{$_};
        my $link;
        for my $idx (0...$#ConfigArray) {
            my $c = $ConfigArray[$idx];
            if ($c->[7] && $c->[7] =~ /$mod/i) {
                $link .= " $c->[0]";
            }
        }

        next if $mod eq 'Time::Hi::Res';
        $mod =~ s/:://go;
        my $varname = 'use'.$mod;
        $ModulesUsed{$varname} = 1;
        $link = $link ? "<br />This module is possibly used for$link and maybe some other features." : '';
        $i++;
        push (@cfglines,[$varname,"Use Module $_",0,\&checkbox,$default,'(.*)',undef,"If selected, the perl module $_ will be loaded if it is installed. If not selected, ASSP will not load the perl module $_ even it is installed and several features of ASSP will not be available! It is recommended to disable installed but unused modules to reduce the required memory.<span class=\"negative\"> Requires ASSP restart!</span>$link",undef,undef,'msg0'.$i.'0','msg0'.$i.'1'])
    }
    push (@ConfigArray,[0,0,0,'heading','Perl Module Setup <a href="javascript:popFileEditor(\'moduleLoadErrors.txt\',8);"><img height=12 width=12 src="' . $wikiinfo . '" alt="show module load errors" /></a>']);
    while (@cfglines) {
        push(@ConfigArray,shift @cfglines);
    }
}

# imported from IO :: Socket version 1.30_01 to handle MSWIN32 blocking mode
# modified by Thomas Eckardt to use a real long pointer
sub assp_socket_blocking {
    my $sock = shift;

    return $sock->SUPER::blocking(@_)
        if $isNoWIN;

    # Windows handles blocking differently
    #
    # http://groups.google.co.uk/group/perl.perl5.porters/browse_thread/thread/b4e2b1d88280ddff/630b667a66e3509f?#630b667a66e3509f
    # http://msdn.microsoft.com/library/default.asp?url=/library/en-us/winsock/winsock/ioctlsocket_2.asp
    #
    # http://www.perlmonks.org/?node_id=780083   /TE
    #
    # 0x8004667e is FIONBIO
    #
    # which is used to set blocking behavior.

    # NOTE:
    # This is a little confusing, the perl keyword for this is
    # 'blocking' but the OS level behavior is 'non-blocking', probably
    # because sockets are blocking by default.
    # Therefore internally we have to reverse the semantics.

    my $orig= !${*$sock}{io_sock_nonblocking};

    return $orig unless @_;

    my $block = shift;

    my $nonblocking = "\x00\x00\x00\x01"; # pack("L",1) works too
    my $blocking = "\x00\x00\x00\x00"; # pack("L",0) works too
    my $FIONBIO = 0x8004667e;

    if ( !$block != !$orig ) {
        ${*$sock}{io_sock_nonblocking} = $block ? $blocking : $nonblocking;
        ioctl($sock, $FIONBIO, unpack('I',pack('P',${*$sock}{io_sock_nonblocking})))
            or return;
    }

    return $orig;
}

sub defConfigArray {
 # last used msg number 010801

 # still unused msg numbers
 #
 #

    @ConfigArray = (

 # except for the heading lines, all config lines have the following:
 # $name,$nicename,$size,$func,$default,$valid,$onchange,$description,CssAddition,note,MSG-nicename,MSG-description
 # name is the variable name that holds the data
 # nicename is a human readable pretty display name (oh how nice!)
 # size is the appropriate input box size
 # func is a function called to render the config item
 # default is the default value
 # valid is a regular expression used to clean and validate the input -- no match is an error and $1 is the desired result
 # onchange is a function to be called when this value is changed -- usually undef; just updating the value is enough
 # description is text displayed to help the user figure what to put in the entry
 # CssAdition (optional) adds the string to the CSS-name for nicename Style
 # note for Edit java script
 # message number for the nicename - for multilingual support - SNMP OID extension
 # message number for the description - for multilingual support


[0,0,0,'heading','Configuration Synchronization and Sharing'],
['enableCFGShare','Enable Configuration Sharing',0,\&checkbox,'','(.*)','ConfigChangeEnableCFGSync', '<hr><b>Read all positions in this section carefully (multiple times is recommended!!!)!&nbsp;A wrong configuration sequence or wrong configuration values can lead into a destroyed ASSP configuration!</b><hr>
  If set, the configuration value and option files synchronization will be enabled. This synchronization belongs to the configuration values, to the file that is possibly defined in a value and to the include files that are possibly defined in the configured file. If you don\'t want a specific configuration file or include file to be synchronized (send and receive), write<br />
  # assp-no-sync<br />
  as a comment anywhere in the file. A possible reason can be for example \'localDomains\' - if ASSP1 is hosting DOMAIN1 and DOMAIN2 but ASSP2 is hosting only DOMAIN2 - so the entry for DOMAIN2 could be put in a not synchronized include file on ASSP1 and the synchronized main config file contains the entry for DOMAIN1.<br />
  If the configuration of all values in this section is valid, the synchronization status will be shown in the GUI for each config value that is, or <b>can be shared</b>. There are several configuration values, that can not be shared. The list of all shareable values can be found in the distributed file assp_sync.cfg<br />
  <br />
  For an initial synchronization setup set the following config values in this order: setup syncServer, syncConfigFile, syncTestMode and as last syncCFGPass (leave isShareSlave and isShareMaster off). Use the default (distributed syncConfigFile assp_sync.cfg) file and configure all values to your needs - do this on all peers by removing lines or setting the general sync flag to 0 or 1 (see the description of syncConfigFile ).<br />
  If you have finished this initial setup, enable isShareMaster or isShareSlave - now assp will setup all entries in the configuration file for all sync peers to the configured default values (to 1 if isShareMaster or to 3 if isShareSlave is selected). Do this on all peers. Now you can configure the synchronization behavior for each single configuration value for each peer, if it should differ from the default setup.<br />
  For the initial synchronization, configure only one ASSP installation as master (all others as slave). If the initial synchronization has finished, which will take up to one hour, you can configure all or some assp as master and slave. On the initial master simply switch on isShareSlave. On the inital slaves, switch on isShareMaster and change all values in the sync config file that should be bidirectional shared from 3 to 1. As last action enable enableCFGShare on the SyncSlaves first and then on the SyncMaster.<br />
  After such an initial setup, any changes of the peers (syncServer) will have no effect to the configuration file (syncConfigFile)! To add or remove a sync peer after an initial setup, you have to configure syncServer and you have to edit the sync config file manually.<br /><br />
  This option can only be enabled, if isShareMaster and/or isShareSlave and syncServer and syncConfigFile and syncCFGPass are configured!<br />
  <b>Because the synchronization is done using a special SMTP protocol (without "mail from" and "rcpt to"), this option requires an installed <a href="http://metacpan.org/search?q=Net::SMTP" rel="external">Net::SMTP</a> module in PERL. If you want the sync feature to use a secured connection (using STARTTLS) , DoTLS has to be set to "do TLS". This special SMTP protocol is not usable to for any MTA for security reasons, so the "sync mails" could not be forwarded using any MTA.<br />
  For this reason all sync peers must have a direct or routed TCP connection to each other peer.</b><br /><br />
  If you build a sync topology with more than two ASSP, please notice, that it is not allowed to build any ring-synchronization. Only a chain-, tree- or star- topology is supported. It is also not allowed to build a sync ring inside any of the three allowed topologies!<br />
  <input type="button" value="show sync status" onclick="javascript:popFileEditor(\'files/sync_failed.txt\',8);" />',undef,undef,'msg009170','msg009171'],
['isShareMaster','This is a Share Master',0,\&checkbox,'','(.*)','ConfigChangeSync', 'If selected, ASSP will send configured configuration changes to sync peers.',undef,undef,'msg009180','msg009181'],
['isShareSlave','This is a Share Slave',0,\&checkbox,'','(.*)','ConfigChangeSync', 'If selected, ASSP will receive configured configuration changes from sync peers. To accept a sync request, every sending peer has to be defined in syncServer - even if there are manually made entries in the sync config file for a peer.',undef,undef,'msg009190','msg009191'],
['syncServer','Default Sync Peers',100,\&textinput,'','^((?:' . $HostPortRe . '(?:\|' . $HostPortRe . ')*)|)$','ConfigChangeSyncServer','Define all configuration sync peers here (to send changes to or to receive changes from). Separate multiple values by "|". Any value must be a pair of hostname or ip-address and :port, like 10.10.10.10:25 or mypeerhost:125 or mypeerhost.mydomain.com:225 or [2202::00FF]:25. The :port must be defined!<br />
  The target port can be the listenPort , listenPort2 , relayPort or if syncUsesSSL is enabled, it has to be the listenPortSSL of the peer.',undef,undef,'msg009200','msg009201'],
['syncUsesSSL','SSL is used for the Sync SMTP Transport',0,\&checkbox,'','(.*)',undef, 'If selected, SSL will be used for the transport of the synchronization requests. In this case the target ip:port of all peers must be its listenPortSSL ! The Perl modules Net::SMTP::SSL and IO::Socket::SSL must be installed and enabled if this option is selected, otherwise all synchronization requests will fail!',undef,undef,'msg010140','msg010141'],
['syncTestMode','Test Mode for Config Sync',0,\&checkbox,'','(.*)',undef, 'If selected, a master (isShareMaster) will process all steps to send configuration changes, but will not realy send the request to the peers. A slave (isShareSlave) will receive all sync requests, but it will not change the configuration values and possibly sent configuration files will be stored at the original location and will get an extension of ".synctest".',undef,undef,'msg009210','msg009211'],
['syncConfigFile','Configuration File for Config Sync*',40,\&textinput,'file:assp_sync.cfg','(file:\S+|)','ConfigChangeSyncFile','Define the synchronization configuration file here (default is file:assp_sync.cfg).<br />
 This file holds the configuration and the current status of all synchronized assp configuration values.<br />
 The format of an initial value is:  "varname:=syncflag" - where syncflag could be 0 -not shared and 1 -is shared - for example: HeaderMaxLength:=1 . The syncflag is a general sign, which means, a value of 0 disables the synchronization of the config value for all peers. A value of 1, enables the peer configuration that possibly follows.<br />
 The format after an initial setup is: "varname:=syncflag,syncServer1=status,syncServer2=status,......". The "status" can be one of the following:<br /><br />
 0 - no sync - changes of this value will not be sent to this syncServer - I will ignore all change requests for this value from there<br />
 1 - I am a SyncMaster, the value is still out of sync to this peer and should be synchronized as soon as possible<br />
 2 - I am a SyncMaster, the value is still in sync to this peer - I am also a SyncSlave to this peer (bidirectional sync) if isShareSlave is enabled<br />
 3 - I am not a SyncMaster but a SyncSlave - only this SyncMaster (peer) knows the current sync status to me<br />
 4 - I am a SyncMaster and a SyncSlave (bidirectional sync) - a change of this value was still received from this syncServer (peer) and should not be sent back to this syncServer - this flag will be automatically set back to 2 at the next synchronization check<br /><br />
 ',undef,undef,'msg009220','msg009221'],
['syncCFGPass','Config Sync Password',20,\&passinput,'','(.{6,}|)','ConfigChangeSync','The password that is used and required (additionally to the sending IP address) to identify a valid sync request. This password has to be set equal in all ASSP installations, from where and/or to where the configuration should be synchronized.<br />
  The password must be at least six characters long.<br />
  If you want or need to change this password, first disable enableCFGShare here and on all peers, change the password on all peers, enable enableCFGShare on SyncSlaves then enable enableCFGShare on SyncMasters.',undef,undef,'msg009230','msg009231'],
['syncShowGUIDetails','Show Detail Sync Information in GUI',0,\&checkbox,'','(.*)',undef, 'If selected, the detail synchronization status is shown at the top of each configuration parameter like:<br /><br />
  nothing shown - there is no entry defined for this parameter in the syncConfigFile or it is an unsharable parameter<br />
  "(shareable)" - the parameter is shareable but the general sync sign in the syncConfigFile is zero<br />
  "(shared: ...)" - the detail sync status for each sync peer<br /><br />
  If not selected, only different colored bulls are shown at the top of each configuration parameter like:<br /><br />
  nothing shown - no entry in the syncConfigFile or it is an unsharable parameter<br />
  "black bull <b><font color=\'black\'>&bull;</font></b>" - the parameter is shareable but the general sync sign in the syncConfigFile is zero<br />
  "green bull <b><font color=\'green\'>&bull;</font></b>" - the parameter is shared and in sync to each peer<br />
  "red bull <b><font color=\'red\'>&bull;</font></b>" - the parameter is shared but it is currently out of sync to at least one peer<br /><br />
  If you move the mouse over the bull, a hint box will show the detail synchronization status. A click on the bull or link will open a sync config dialog box for the single configuration parameter.
  <hr /><div class="cfgnotes">Notes Config Sync</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/configsync.txt\',3);" />',undef,undef,'msg009250','msg009251'],

[ 0, 0, 0, 'heading', 'Network Setup for Incoming Mail and Authentication <a href="https://sourceforge.net/p/assp/wiki/ASSP_Advanced_Workflow/" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Network Flow" /></a>' ],
['DisableSMTPNetworking',"Disable all new SMTP and Proxy Network Connections",0,\&checkbox,0,'(.*)','configUpdateSMTPNet',
  'If selected, ASSP will not answer to new SMTP and Proxy connections on \'listenPort , listenPort2 , listenPortSSL , relayPort and ProxyConf\'. Currently existing SMTP and Proxy connections are not affected! Web and Stat connection are also not affected.',undef,undef,'msg000010','msg000011'],

['enableINET6','Enable IPv6 support',0,\&checkbox,'','(.*)','ConfigChangeIPv6','For IPv6 network support to be enabled, check this box. Default is disabled. IO::Socket::IP is able to handle both IPv4 and IPv6. NOTE: This option requires an installed <a href="http://metacpan.org/search?q=IO::Socket::IP" rel="external">IO::Socket::IP</a> module in PERL and your system should support IPv6 sockets to give enabling this option a sense!<br />
  It is recommended to leave this option OFF as long as you don\'t want to use IPv6 addresses for a listener or a destination (SMTP,DNS-server,LDAP-server etc.).<br />
  Before you enable or disable IPv6, please check every IP listener and destination definition in assp and correct the settings. <b>After changing this option a restart of assp is recommended.</b> IPv4 addresses are defined for example 192.168.0.1 or 192.168.0.1:25 - IPv6 addresses are defined like [FE80:1:0:0:0:0:0:1]:25 or [FE80:1::1]:25 ! If an IPv4 address is defined for a listener, assp will listen only on the IPv4 socket. If an IPv6 address is defined for a listener, assp will listen only on the IPv6 socket. If only a port is defined for a listener, assp will listen on both IPv4 and IPv6 sockets.<br />
  For the definition of destination IP\'s applies the same. You are free to define hostnames instead of IP addresses like myhost.mydomain.com:25 - how ever, because of the needed IP address resolving, this will possibly slow down assp.',undef,undef,'msg009480','msg009481'],
['listenPort','SMTP Listen Port',80,\&textinput,'25',$GUIHostPort,'ConfigChangeMailPort',
  'The port number on which ASSP will listen for incoming SMTP connections (normally 25). You can specify both an IP address and port number to limit connections to a specific interface. Separate multiple entries by "|".<br />
  To define a SSL listener, write \'SSL:\' in front of the host:port - e.g. SSL:host:port.<br />
  <p><small><i>Examples:</i> 25, 127.0.0.1:25, 127.0.0.1:25|127.0.0.2:25|SSL:[FE80:1::1]:25 </small></p>','Basic',undef,'msg000020','msg000021'],
['smtpDestination','SMTP Destination',80,\&textinput,'125',$GUIHostPort,undef,
  'The IP <b>number!</b> and port number of your primary SMTP <a href=http://en.wikipedia.org/wiki/Mail_transfer_agent>mail transfer agent</a> (MTA). If multiple servers are listed and the first listed MTA does not respond, each additional MTA will be tried. If only a port number is entered, or the dynamic keyword <b>INBOUND</b> is used with a port number, then the connection will be established to the local IP address on which the connection was received. This is useful when you have several IP addresses with different domains or profiles in your MTA. If INBOUND:PORT is used, ReportingReplies (Analyze,Help,etc and CopyMail will go to 127.0.0.1:PORT or [::1]:PORT. If your needs are different, use smtpReportServer (SMTP Reporting Destination) and sendAllDestination (Copy Spam SMTP Destination). Separate multiple entries by "|".<br />
  If you need to connect to the SMTP destination host using native SSL, write \'SSL:\' in front of the IP/host definition. In this case the Perl module <a href="http://metacpan.org/search?q=IO::Socket::SSL" rel="external">IO::Socket::SSL</a> must be installed and enabled ( useIOSocketSSL ).<br />
  <small><i>Examples:</i> 125, 127.0.0.1:125, 127.0.0.1:125|127.0.0.5:125|SSL:127.0.0.1:465, INBOUND:125</small>','Basic',undef,'msg000030','msg000031'],
['smtpDestinationRT','SMTP Destination Routing Table*',80,\&textinput,'','^((?:(?:\s*'.$HostRe.'\s*=>\s*'.$HostPortRe.'\s*)(?:\|\s*'.$HostRe.'\s*=>\s*'.$HostPortRe.'\s*)*)|\s*file\s*:\s*.+|)$','configChangeRT',
  'If INBOUND is used in a SMTP Destination field, the rules specified here are used to route the inbound IP address to a different outbound IP address or host. You must specify a port number with the outbound IP address or host. <p><small><i>Example:</i>141.120.110.1=>141.120.110.129:25|141.120.110.2=>141.120.110.130:125|141.120.110.3=>SSL:141.120.110.130:125</small></p>',undef,undef,'msg000040','msg000041'],
['smtpLocalIPAddress','SMTP and Proxy - Destination to Local IP-address Mapping*',40,\&textinput,'','^(\s*file\s*:\s*.+|)$','configChangeLocalIPMap',
  'You need to use the "file: ..." option for this parameter!<br />
  On windows systems at least Vista/2008 is required!<br />
  On multihomed systems with multiple default gateways, it could be required to define the local IP address (source) used for outgoing SMTP and Transparent Proxy ( ProxyConf ) connections.<br />
  This parameter allows to define local IP addresses used for specific targets (IP\'s or hosts) - based on the local address, the system will use the right gateway/interface.<br />
  Define one entry per line, comments (#) are allowed. The syntax for an entry is \'target=>local-IP\'.<br />
  target could be any of: IP(4/6) network, IP(4/6) address, hostname, domain-name with wildcard (*).<br /><br />
  for example:<br />
  22.* => 192.168.1.1            # IP4 Network<br />
  2222:333:* => FE81::1          # IP6 Network<br />
  22.23.24.25 => 10.1.1.1,       # host IP4<br />
  1:2:3:4:5:6:7:8 => FE94::5     # host IP6<br />
  *.domain.com => 10.1.1.1       # domain<br />
  host.domain.com => 192.168.1.1 # host<br />
  * => 172.16.1.1                # default - if not defined, the system default is used<br /><br />
  NOTICE: assp will NOT check, that the local IP address is available and bound to a local interface! It will also NOT check the system routing table! YOU SHOULD KNOW WHAT YOU DO!',undef,undef,'msg010430','msg010431'],
['listenPortSSL','SMTP Secure Listen Port',80,\&textinput,'',$GUIHostPort,'ConfigChangeMailPortSSL',
  'The port number on which ASSP will listen for incoming secure (SSL only) SMTP connections (normally 465). You can specify both an IP address and port number to limit connections to a specific interface. Separate multiple entries by "|" and do NOT write SSL: in front of definition.<p><small><i>Examples:</i> 465, 127.0.0.1:465, 127.0.0.1:465|127.0.0.2:465 </small></p>. More configuration options are smtpSSLRequireClientCert, SSLSMTPCertVerifyCB and SSLSMTPConfigure .',undef,undef,'msg000050','msg000051'],
['smtpDestinationSSL','SSL Destination',80,\&textinput,'',$GUIHostPort,undef,
  'The IP <b>address!</b> and port number to connect to when mail is received on the SSL listen port. If the field is blank, the primary SMTP destination will be used.<br />
  If you need to connect to the SSL destination host using native SSL, write \'SSL:\' in front of the IP/host definition. In this case the Perl module <a href="http://metacpan.org/search?q=IO::Socket::SSL" rel="external">IO::Socket::SSL</a> must be installed and enabled ( useIOSocketSSL ).<br />
  <p><small><i>Examples:</i>127.0.0.1:565, 565</small></p>',undef,undef,'msg000060','msg000061'],
['listenPort2','Second SMTP Listen Port',80,\&textinput,'',$GUIHostPort,'ConfigChangeMailPort2',
  'A secondary port number on which ASSP can accept SMTP connections. This is useful as a dedicated port for VPN clients or for those who cannot directly send mail to a mail server outside of their ISP\'s network because the ISP is blocking port 25. You may also specify an IP address to limit connections to a specific interface. Separate multiple entries by "|".<br />
  To define a SSL listener, write \'SSL:\' in front of the host:port - e.g. SSL:host:port.<br />
  <p><small><i>Examples:</i> 2525, 127.0.0.1:2525, SSL:192.168.0.100:25000</small></p>',undef,undef,'msg000070','msg000071'],
['smtpAuthServer','Second SMTP Destination',80,\&textinput,'',$GUIHostPort,undef,
  'The IP address and port number to connect to when mail is received on the second SMTP listen port. If the field is blank, the primary SMTP destination will be used. The purpose of this setting is to allow remote users to make authenticated connections and transmit their email without encountering SPF failures.
  If you need to connect to the second SMTP destination host using native SSL, write \'SSL:\' in front of the IP/host definition. In this case the Perl module <a href="http://metacpan.org/search?q=IO::Socket::SSL" rel="external">IO::Socket::SSL</a> must be installed and enabled ( useIOSocketSSL ).<br />
  <p><small><i>Examples:</i> 587, 127.0.0.1:587, SSL:127.0.0.1:465</small></p>',undef,undef,'msg000080','msg000081'],
['ProxyConf','Transparent TCP Proxy Table*',80,\&textinput,'','(\S*)','configChangeProxy',
 'Define any transparent TCP Port Proxy here. ASSP will proxy/forward (NOT route !) incoming TCP packets to a specific destination.<br />
  For example: if you want incoming TCP connections on port 465 (SMTP-SSL) to be forwarded to your email server.<br /><br />
  <p><small><i>Example:</i>10.1.1.1:22=&gt;172.16.22.33:22|0.0.0.0:465=&gt;192.168.1.25:465&lt;=12.1.1.3,34.5.6.0/16,67.23.2.1-67.23.2.5|10.1.1.1:1477=&gt;192.168.1.23:1234&lt;=120.5.1.3,134.5.19.7,[allow_proxy_1234]</small></p><br /><br />
  Those connection are not especially SMTP related and they are not inspected by assp. Any application that uses the TCP layer, can use such a proxy (eg. SSH, RDP, VNC, POP3, HTTP, LDAP, Notes ...).<br />
  Proxy connections can be defined in any direction: private&lt;-&gt;private , private&lt;-&gt;public , public&lt;-&gt;private and public&lt;-&gt;public<br /><br />
  The syntax is: localIP:localPORT=&gt;forwardIP:forwardPORT[&lt;=AllowfromIP1,AllowfromIP2,...]|next Proxy configuration|....<br /><br />
  The file-option (eg. file:files/proxy_conf.txt) is supported - if used, define one proxy configuration per line.<br />
  You have to configure the IP-address and IP-port for both - local and forward values! The optional AllowfromIP extension are comma separated values of IP-addresses (eg. 192.168.1.1), IP-networks (eg. 10.1.1.0/24) and IP-address ranges (172.16.1.3-172.16.1.10) from where connections are allowed. Groups definitions (eg. [allow_ssh_proxy]) may be used in AllowfromIP. If there is no allow value defined, all source IP addresses will be accepted!',undef,undef,'msg008300','msg008301'],
['NoAUTHlistenPorts','Disable AUTH support on listenPorts',80,\&textinput,'','(.*)','ConfigChangeNoAUTHPorts',
  'This disables the SMTP AUTH command on the defined listenPorts independent from any other setting. This option works for listenPort , listenPort2 and listenPortSSL . The listener definition here has to be the same like in the port definitions. Separate multiple entries by "|".<p><small><i>Examples:</i> 25, 127.0.0.1:25, 127.0.0.1:25|127.0.0.2:25 </small></p>',undef,undef,'msg008060','msg008061'],
['DisableExtAUTH','Disable SMTP AUTH for External Clients',0,\&checkbox,'','(.*)',undef,'If you do not want external clients (IP not in acceptAllMail or relayPort is not used) to use SMTP AUTH - for example to prevent address and password harvesting - check this option.<br />
  The "AUTH" offer in the EHLO and HELP reply will be stripped out, if set to on.<br />
  If this option is enabled and the AUTH command is used by an external client or server, autValencePB will be used to score the message and IP.<br />
  Notice: setting this option to ON could prevent roaming users (dynamic IP) from being able to authenticate!',undef,undef,'msg010250','msg010251'],
['noAUTHHeloRe','Disable AUTH for these HELO\'s*',80,\&textinput,'','(.*)','ConfigCompileRe',
'If configured and a helo matches this regular expression, the AUTH offer will be removed from the EHLO reply and the AUTH command will be disallowed.
 For example:  ^\w+\.noauthdomain\.com$,',undef,undef,'msg010550','msg010551'],
['onlyAUTHHeloRe','Allow AUTH Only for these HELO\'s*',80,\&textinput,'','(.*)','ConfigCompileRe',
'If configured and a helo does not match this regular expression, the AUTH offer will be removed from the EHLO reply and the AUTH command will be disallowed.
 For example:  ^\w+\.onlyauthdomain\.com$,',undef,undef,'msg010560','msg010561'],
['AUTHrequireTLS','SMTP AUTH requires SSL/TLS','0:NO|1:PLAIN|2:LOGIN|3:PLAIN and LOGIN|4:ALL',\&listbox,4,'(\d)',undef,
  'An SSL listener or STARTTLS is required before the SMTP AUTH command can be used.<br />
  This setting is ignored for all private IP addresses (localhost, RFC 1918, RFC 4193)!<br />
  In case of a mistake \'538 5.7.11 transport layer encryption (SSL/TLS) required for requested authentication mechanism\' is replied to the client.<br />
  \'ALL\' is recommended and default setting! The authentication mechanism XOAUTH2 requires transport layer encryption independend from this setting!',undef,undef,'msg010470','msg010471'],
['EnforceAuth',"Force SMTP AUTH on Second SMTP Listen Port",0,\&checkbox,0,'(.*)',undef,
  'Force clients connecting to the second listen port to authenticate before transferring mail. To use this setting, both listenPort2 (Second SMTP Listen Port) and smtpAuthServer (Second SMTP Destination) must be configured.<hr /><div class="cfgnotes">Notes On Network Setup</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/network.txt\',3);" />',undef,undef,'msg000090','msg000091'],

[0,0,0,'heading','Network Setup, Limits and DKIM signing for Relaying, Outgoing and Local Mail <a href="https://sourceforge.net/p/assp/wiki/Relaying" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="relaying not allowed" /></a>'],
['acceptAllMail','Accept All Mail*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','Relaying is allowed for these IPs. They contribute also to the whitelist. Before setting this option, please read the complete section - it is recommended to configure relayPort to send mails from your LAN to the Internet. This can take either a directly entered list of IP\'s separated by pipes or a file \'file:files/acceptall.txt\'.<br />
  For example: 145.145.145.145|146.145.','Basic','7','msg001040','msg001041'],
['DoLocalSenderDomain','Do Local Domain Check for Local Sender',0,\&checkbox,'','(.*)',undef,
  'If activated, each local sender address must have a valid Local Domain. acceptAllMail and redlisted mails breaks this rule.',undef,undef,'msg001050','msg001051'],
['DoLocalSenderAddress','Do Local Address Check for Local Sender',0,\&checkbox,'','(.*)',undef,
  'If activated, each local sender address must have a valid Local Address. acceptAllMail and redlisted mails breaks this rule.',undef,undef,'msg001060','msg001061'],
['nolocalDomains','Skip Local Domain Check',0,\&checkbox,'','(.*)',undef,'Do not check relaying based on localDomains. Let the mailserver do it. <b>NOT RECOMMENDED</b>.',undef,undef,'msg001070','msg001071'],
['ldLDAP','Do LDAP lookup for local domains',0,\&checkbox,'','(.*)',undef,'Check local domains against an LDAP database.<br />
 Note: Checking this requires filling in LDAP DomainFilter ( ldLDAPFilter ) in the LDAP section.<br />
 This requires an installed <a href="http://metacpan.org/search?q=Net::LDAP" rel="external">NET::LDAP</a> module in Perl.',undef,undef,'msg001080','msg001081'],
['ispip','ISP/Secondary MX Servers*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','Enter any addresses that are your ISP or backup MX servers, separated by pipes (|). <br />
 These addresses will (necessarily) bypass Griplist, IP Limiting, Delaying, Penalty Box, SPF, DNSBL &amp; SRS checks unless the IP can be determined by (ispHostnames) ISP/Secondary Hostnames. For example: 127.0.0.1|172.16..','Basic','7','msg001090','msg001091'],
['contentOnlyRe', 'Regular Expression to Identify Forwarded Messages*',80,\&textinput,'','(.*)','ConfigCompileRe',
 'Put anything here to identify messages which should bypass the PenaltyBox, Sender Validation, Griplist, IP Limiting, Delaying, SPF, DNSBL &amp; SRS checks. For example:  email addresses of people who are forwarding from other accounts to their mailbox on your server.',undef,undef,'msg001100','msg001101'],
['ispHostnames','Regular Expression to Identify ISP/Secondary Hostnames*',80,\&textinput, '','(.*)', 'ConfigCompileRe', 'Hostnames (regular expression) to lookup the IP that connected to the ISP/Secondary server.<br />
 If found, this address is used to perform IP-based checks on forwarded messages. <br />
 For example: mx1\.yourisp\.com or mx1\.yourisp\.net|mx2\.yoursecondary\.com . <i>This hostnames are found in the \'Received:\' header, like  \'Received: from ...123.123.123.123... by <b>mx1.yourisp.com</b>\'</i>. Leave this blank to disable the feature. ',undef,undef,'msg001110','msg001111'],
['send250OKISP','Send 250 OK To ISP/Secondary MX Servers',0,\&checkbox,'1','(.*)',undef,
 'Set this checkbox if you want ASSP to reply to IP\'s in ISPIP with \'250 OK\' instead of SMTP error code \'554 5.7.1\'.',undef,undef,'msg001120','msg001121'],
['ispgripvalue','ISP/Secondary MX Grip Value',5,\&textinput,'0.5','^(0\.?\d*|)$',undef,'It is recommended to set it to 0.5 (Completely GReyIP) for ISP and Secondary MX servers. If left blank the Griplist X value is used (percentage of spam messages in relation to total). <br />
 Note: value has to be greater than 0 and less than 1, where 0 = never spam and 1 = always spam',undef,undef,'msg001130','msg001131'],

['BounceSenders','Bounce Senders*',80,\&textinput,'postmaster|mailer-daemon','(.*)','ConfigMakeRe',
'Envelope sender addresses treated as bounce origins. Null sender (&lt;&gt;) is always included.<br />
 Accepts specific addresses (postmaster@domain.com), usernames (mailer-daemon), or entire domains (@bounces.domain.com)<br />
 Automatic whitelist addition is skipped for mails from all bounce senders, the same way like redlisted mails are skipped from automatic whitelist addition.<br />
 If the list of bounce sender addresses is changed, a repair operation for the whitelistdb will be started. This task removes all whitelist entries, which are related to any local bounce sender.<br />
 Separate entries with pipes: |. For example: postmaster|mailer-daemon',undef,undef,'msg001140','msg001141'],
['PopB4SMTPFile','Pop Before SMTP DB File',40,\&textinput,'','(.*)',undef,'Enter the DB database filename of your POP before SMTP implementation with records stored for dotted-quad IP addresses.<br />
 For example: /etc/mail/popip.db',undef,undef,'msg001150','msg001151'],
['PopB4SMTPMerak','Pop Before SMTP Merak Style',0,\&checkbox,'','(.*)',undef,'If set Merak 7.5.2 is supported.',undef,undef,'msg001160','msg001161'],
['relayHost','Relay Host',80,\&textinput,'',$GUIHostPort,undef,
 'Your isp\'s mail relayhost (smarthost). For example: mail.isp.com:25<br />
 If you run Exchange/Notes and you want assp to update the nonspam database and the whitelist, then enter your isp\'s smtp relay host here. Blank means no relayhost and the smtpDestination will be used. Separate multiple entries by "|".<br />
 If you need to connect to the relay host using native SSL, write \'SSL:\' in front of the IP/host definition. In this case the Perl module <a href="http://metacpan.org/search?q=IO::Socket::SSL" rel="external">IO::Socket::SSL</a> must be installed and enabled ( useIOSocketSSL ).<br />
 The IP based routing defined in smtpDestinationRT will be used, if the dynamic keyword <b>INBOUND</b> is defined here.<br />
 Examples: your_ISP_Server:25, 149.1.1.1:25, SSL:149.1.1.2:465|any_other_host:25, INBOUND !','Basic',undef,'msg001170','msg001171'],
['relayAuthUser','User to Authenticate to Relay Host',80,\&passinput,'','(.*)',undef,'The username used for SMTP AUTH authentication to the relayhost  - for example, if your ISP need authentication on the SMTP port! Supported authentication methods are PLAIN, LOGIN, CRAM-MD5, DIGEST-MD5 and XOAUTH2. If the relayhost offers multiple methods, the one with highest security option will be used. The Perl module <a href="http://metacpan.org/search?q=Authen::SASL" rel="external">Authen::SASL</a> must be installed to use this feature! The usage of this feature will be skipped, if the sending MTA uses the AUTH command. Leave this blank, if you do not want use this feature.','Basic',undef,'msg009040','msg009041'],
['relayAuthPass','Password to Authenticate to Relay Host',80,\&passinput,'','(.*)',undef,'The password used for SMTP AUTH authentication to the relayhost ! Leave this blank, if you do not want use this feature. In case the XOAUTH2 authentication mechanism is used (eg.msoffice 365), write the accessToken into here.','Basic',undef,'msg009050','msg009051'],
['relayPort','Relay Port',80,\&textinput,'',$GUIHostPort,'ConfigChangeRelayPort','Tell your mail server to connect to this IP/port as its smarthost / relayhost. For example: 225<br />
 Note that you\'ll want to keep the relayPort protected from external access by your firewall. To restrict access to the relayPort per IP address or network, use allowRelayCon .<br />
 You can supply an interface:port to limit connections.<br />
 To define a SSL listener, write \'SSL:\' in front of the host:port - e.g. SSL:host:port.<br />
 Separate multiple entries by "|".<p><small><i>Examples:</i> 225, 225|SSL:325, 127.0.0.1:225, 192.168.1.1:225|192.168.2.1:225|SSL:192.168.1:325 !</small></p>',undef,undef,'msg001180','msg001181'],
['allowRelayCon','Allow Relay Connection from these IP\'s*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','Enter any addresses that are allowed to use the relayPort , separated by pipes (|). If empty, any ip address is allowed to connect to the relayPort. If this option is defined, keep in mind : Addresses defined in acceptAllMail are <b>NOT</b> automatically included and have to be also defined here, if them should allow to use the relayPort. For example: 127.0.0.1|172.16..<br />
 If you use MS Office 365, you should define the <a href="http://technet.microsoft.com/en-us/library/dn163583(v=exchg.150).aspx" rel="external">EOP IP addresses</a> here and you should configure your firewall to redirect connection from the hosted Exchange server to the relayPort .','Basic','7','msg008830','msg008831'],
['RelayOnlyLocalSender','Allow Relaying Only for Local Sender',0,\&checkbox,'','(.*)',undef,'If set, the envelope sender (MAIL FROM:) is immediately checked after the DATA command is received (to be valid). If the sender address could not be validated, the connection is dropped.<br />
  This setting is ignored for BounceSenders, which can relay at any time. <br />
  The connection will be dropped regardless any other assp setting ( except EmailSenderOK ).<br />
  It is recommended to switch this to ON, if you use for example MS Office 365. At least, it is wise, to switch this ( or RelayOnlyLocalDomains ) to ON in every case',undef,undef,'msg010380','msg010381'],
['RelayOnlyLocalDomains','Allow Relaying Only for Local Domains',0,\&checkbox,'','(.*)',undef,'If set, the envelope sender domain (MAIL FROM:) is immediately checked after the DATA command is received (to be a local domain). If the sender domain could not be validated, the connection is dropped.<br />
  This setting is ignored for BounceSenders, which can relay at any time. <br />
  The connection will be dropped regardless any other assp setting ( except EmailSenderOK ).<br />
  It is recommended to switch this to ON, if you use for example MS Office 365. At least, it is wise, to switch this ( or RelayOnlyLocalSender ) to ON in every case',undef,undef,'msg010390','msg010391'],
['NoRelaying','No Relaying Error <a href="https://sourceforge.net/p/assp/wiki/Relaying" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a>',80,\&textinput,'530 Relaying not allowed','([25]\d\d .*)',undef,'SMTP error message to deny relaying.',undef,undef,'msg001190','msg001191'],
['defaultLocalHost','Default Local Host',40,\&textinput,'assp.local','('.$EmailDomainRe.')?',undef,'If you want to be able to send mail to local users without a domain name then put the default local domain here.<br />
 Blank disables this feature. For example: mydomain.com .',undef,undef,'msg001200','msg001201'],

['LocalFrequencyInt','Local Frequency Interval',40,\&textinput,'0','(\d*)',undef,'The time interval in seconds in which the number of envelope recipients per sending address has not to exceed a specific number ( LocalFrequencyNumRcpt ).<br />
  Use this in combination with LocalFrequencyNumRcpt to limit the number of recipients in a given interval, to prevent local abuse - for example from hijacked local accounts. A value of 0 (default) will disable this feature and clean the cache within five minutes. It is recommended to enable DoLocalSenderAddress and/or DoLocalSenderDomain, if you want to use this feature. To give users the chance to inform an admin about such blocked mails, local mails to EmailAdmins are never blocked because of that feature.<br />
  <input type="button" value="edit local Frequency Cache" onclick="javascript:popFileEditor(\'DB-localFrequencyCache\',\'1h\');" />',undef,undef,'msg008720','msg008721'],
['LocalFrequencyNumRcpt','Local Frequency Recipient Number',40,\&textinput,'0','(\d*)',undef,'The number of envelope recipients per sending address that has not to exceed in a specific time interval ( LocalFrequencyInt ).<br />
  Use this in combination with LocalFrequencyInt to limit the number of recipients in a given interval, to prevent local abuse - for example from hijacked local accounts. A value of 0 (default) will disable this feature and clean the cache within five minutes. It is recommended to enable DoLocalSenderAddress and/or DoLocalSenderDomain, if you want to use this feature. To give users the chance to inform an admin about such blocked mails, local mails to EmailAdmins are never blocked because of that feature. <br />
  <input type="button" value="edit local Frequency Cache" onclick="javascript:popFileEditor(\'DB-localFrequencyCache\',\'1h\');" />',undef,undef,'msg008730','msg008731'],
['LocalFrequencyOnly','Check local Frequency for this Users only*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'A list of local addresses, for which the \'local frequency check\' should be done. Leave this field blank (default), to do the check for every address.<br />
  Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).<br />
  For example: fribo*@thisdomain.com|jhanna|@sillyguys.org ',undef,undef,'msg008740','msg008741'],
['NoLocalFrequency','Check local Frequency NOT for this Users*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'A list of local addresses, for which the \'local frequency check\' should not be done. Noprocessing messages will skip this check.<br />
  Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).<br />
  For example: fribo*@thisdomain.com|jhanna|@sillyguys.org ',undef,undef,'msg008750','msg008751'],
['NoLocalFrequencyIP','Check local Frequency NOT for this IP\'s*',60,\&textinput,'','(.*)','ConfigMakeIPRe',
 'A list of local IP-addresses, for which the \'local frequency check\' should not be done.<br />
  For example: 145.145.145.145|145.146. ',undef,undef,'msg010110','msg010111'],

['genDKIM','Generate and Add DKIM or DomainKey <a href="http://en.wikipedia.org/wiki/DomainKeys_Identified_Mail" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Network Flow" /></a> signatures to relayed messages',0,\&checkbox,'','(.*)',undef,'If selected, ASSP will add DKIM signatures to relayed messages, if it finds a valid DKIM configuration in DKIMgenConfig for the sending domain. This will also be done for noprocessing mails. This requires an installed <a href="http://metacpan.org/search?q=Mail::DKIM" rel="external">Mail::DKIM</a> module in PERL.',undef,undef,'msg001210','msg001211'],
['genARC','Generate and Add Authenticated Received Chain (ARC) signatures to all messages',0,\&checkbox,'','(.*)',undef,
'If selected, ASSP will add <a href="http://arc-spec.org" rel="external">Authenticated Received Chain (ARC)</a> signatures to all messages provided it finds a valid DKIM configuration in DKIMgenConfig for the domain of ARCSigningHost (or myName if ARCsSigningHost is blank). This will also be done for noprocessing mails. If available, the check results for SPF, DKIM and DMARC will be provided in the generated ARC-signature. This requires an installed <a href="http://metacpan.org/search?q=Mail::DKIM" rel="external">Mail::DKIM</a> module in PERL.',undef,undef,'msg010680','msg010681'],
['ARCSigningHost','Host (FQHN) Name to be used for ARC Signing',40,\&textinput,'','(.*)',undef,'The full qualified host name to be used for <a href="http://arc-spec.org" rel="external">Authenticated Received Chain (ARC)</a> signing. If not defined, myName is used. The signing domain is parsed from the senders address (header From: or Sender:) in outgoing mails - and this value (or myName) in incoming mails.',undef,undef,'msg010690','msg010691'],
['DKIMgenConfig','The File with the DKIM and ARC configurations*',40,\&textinput,'file:dkim/dkimconfig.txt','(file:\S*)','configUpdateDKIMConf','The file that contains the DKIM and ARC configuration. A description how to configure DKIM, DomainKey and ARC could be found in the default file dkim/dkimconfig.txt.<br />
<hr /><div class="cfgnotes">Notes On Relaying</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/relaying.txt\',3);" />',undef,undef,'msg001220','msg001221'],

[0,0,0,'heading','SMTP Session Limits '],
['MaxErrors','Maximum Errors Per Session',5,\&textinput,'5','(\d+)',undef,
  'The maximum number of SMTP session errors encountered before the connection is dropped. A value of zero disables this feature. PB: meValencePB',undef,undef,'msg000100','msg000101'],

['maxSMTPSessions','Maximum Sessions',5,\&textinput,'64','(\d?\d?\d?)',undef,
  'The maximum number of simultaneous SMTP sessions. This can prevent server overloading and DoS attacks. 64 simultaneous sessions are typically enough. Zero means no limit. Connections on relayPort will be counted, but connections on relayPort will never be limited because of this value. If the value is reached, assp will wait until the number of simultaneous SMTP sessions is lower than (value - 20) or (value * 0.75).',undef,undef,'msg000110','msg000111'],
['noMaxSMTPSessions','No Maximum Sessions IP numbers*',60,\&textinput,'','(\S*)','ConfigMakeIPRe','Mail from any of these IP numbers will pass through without checking maximum number of simultaneous SMTP sessions. For example: 145.145.145.145',undef,undef,'msg009160','msg009161'],
['maxSMTPipSessions','Maximum Sessions Per IP Address',3,\&textinput,'5','(\d?\d?\d?)',undef,
  'The maximum number of SMTP sessions allowed per IP address. Use this setting to prevent server overloading and DoS attacks. 5 sessions are typically enough. If set to 0 there is no limit imposed by ASSP. ispip (ISP/Secondary MX Servers) and acceptAllMail (Accept All Mail) matches are excluded from SMTP session limiting. PB: iplValencePB',undef,undef,'msg000120','msg000121'],

['HeaderMaxLength','Maximum Header Size',10,\&textinput,50000,'(\d*)',undef,
  'The maximum allowed header length, in bytes. At each mail hop header information is added by the mail server. A large mail header can indicate a mail loop. If the value is blank or 0 the header size will not be checked.',undef,undef,'msg000130','msg000131'],
['detectMailLoop','Detect Possible Mailloop',10,\&textinput,'3','(\d*)',undef,
 'If set to a value higher than 0, ASSP count it\'s own Received-header in the header of the mail. If this count exceeds the defined value, the transmission of the message will be canceled.',undef,undef,'msg008860','msg008861'],
['MaxEqualXHeader','Maximum Equal X-Header Lines*',40,\&textinput,'*=>20','^((?:.+?\s*=>\s*\d+(?:\s*\|.+?\s*=>\s*\d+)*)|\s*file\s*:\s*.+|)$','configUpdateStringToNum',
 'The maximum allowed equal X-header lines - eg. "X-SubscriberID". If the value is set to empty the header will not be checked for equal X-header lines. This check will be skipped for noprocessing, whitelisted and outgoing mails.<br />
  The default is "*=&gt;20", which means any X-header can occur 20 time maximum. You can define different values for different X-headers - wildcards like "*" and "?" are allowed to be used.<br />
  For example:<br />
  *=&gt;20|X-Notes-Item=&gt;100|X-Subscriber*=&gt;10|X-AnyTag=&gt;0<br />
  A value of zero disables the check for the defined X-header. The check is also skipped if no default like "*=&gt;20" is defined and the X-header definition is not found.',undef,undef,'msg009060','msg009061'],

['maxRealSize','Max Real Size of Local Message',10,\&textinput,'','(\d*)',undef,
 'If the value of (number of [rcpt to] * [message size]) exceeds maxRealSize in bytes the transmission of the local message will be canceled. No limit is imposed by ASSP if the field is left blank or set to 0. This option allows admins to limit useless bandwidth wasting based on the total transmit size.',undef,undef,'msg000140','msg000141'],
['MaxRealSizeAdr','Max Real Size of Local Message Addresses*',40,\&textinput,'file:files/MaxRealSize.txt','(\s*file\s*:\s*.+|)','configUpdateMaxSize',
'Use this parameter to set individual maxRealSize values for email addresses, domains, user names and IP addresses. A file must be specified if used.<br />
Accepts specific addresses (user@domain.com), user parts (user), entire domains (@domain.com) and IP addresses (IP-ranges and CIDR notation like 123.1.101/32 and IPv6 shortening like FE80::1 is here <b>NOT</b> supported!) - group definitions could be used. Use one entry per line. Wildcards are supported (fribo*@domain.co?) except for IP addresses. A second parameter separated by "=>" specifies the size limit in byte. <br />
For example:<br />
fribo*@thisdomain.co?=&gt;1000000<br />
jhanna=&gt;0<br />
@sillyguys.org=&gt;500000<br />
101.1.2.16=&gt;0<br />
[admins]=&gt;0 <br />
If multiple matches (values) are found in a mail for any IP address in the transport mail chain, any envelope recipient and the envelope sender, the highest value or 0 (no limit) will be used! If no match (value) is found in a mail, the definition in maxRealSize will take place. NoProcessing (except npsize) will skip this check.'
,undef,undef,'msg009490','msg009491'],
['maxRealSizeExternal','Max Real Size of External Message',10,\&textinput,'','(\d*)',undef,
 'If the value of (number of [rcpt to] * [message size]) exceeds maxRealSizeExternal in bytes the transmission of the external message will be canceled. No limit is imposed by ASSP if the field is left blank or set to 0. This option allows admins to limit useless bandwidth wasting based on the total transmit size.',undef,undef,'msg000150','msg000151'],
['MaxRealSizeExternalAdr','Max Real Size of External Message Addresses*',40,\&textinput,'file:files/MaxRealSizeExt.txt','(\s*file\s*:\s*.+|)','configUpdateMaxSize',
'Use this parameter to set individual maxRealSizeExternal values for email addresses, domains, user names and IP addresses. A file must be specified if used.<br />
Accepts specific addresses (user@domain.com), user parts (user), entire domains (@domain.com) and IP addresses (IP-ranges and CIDR notation like 123.1.101/32 and IPv6 shortening like FE80::1 is here <b>NOT</b> supported!) - group definitions could be used. Use one entry per line. Wildcards are supported (fribo*@domain.co?) except for IP addresses. A second parameter separated by "=>" specifies the size limit in byte. <br />
For example:<br />
fribo*@thisdomain.co?=&gt;1000000<br />
jhanna=&gt;0<br />
@sillyguys.org=&gt;500000<br />
101.1.2.16=&gt;0<br />
[admins]=&gt;0 <br />
If multiple matches (values) are found in a mail for any IP address in the transport mail chain, any envelope recipient and the envelope sender, the highest value or 0 (no limit) will be used! If no match (value) is found in a mail, the definition in maxRealSizeExternal will take place. NoProcessing (except npsize) will skip this check.'
,undef,undef,'msg009500','msg009501'],
['maxRealSizeError','max real message size Error',80,\&textinput,'552 message exceeds MAXREALSIZE byte (size * rcpt)','(552 .*)',undef,'SMTP error message to reject maxRealSize / maxRealSizeExternal exceeding mails. For example:552 message exceeds MAXREALSIZE byte (size * rcpt)! MAXREALSIZE will be replaced by the value of maxRealSize / maxRealSizeExternal.',undef,undef,'msg000160','msg000161'],

['maxSize','Max Size of Local Message',10,\&textinput,'','(\d*)',undef,
 'If the value of ([message size]) exceeds maxSize in bytes the transmission of the local and outgoing message will be canceled. No limit is imposed by ASSP if the field is left blank or set to 0. This option allows admins to limit useless bandwidth wasting based on the transmit size.',undef,undef,'msg008620','msg008621'],
['MaxSizeAdr','Max Size of Local Message Addresses*',40,\&textinput,'file:files/MaxSize.txt','(\s*file\s*:\s*.+|)','configUpdateMaxSize',
'Use this parameter to set individual maxSize values for email addresses, domains, user names and IP addresses. A file must be specified if used.<br />
Accepts specific addresses (user@domain.com), user parts (user), entire domains (@domain.com) and IP addresses (IP-ranges and CIDR notation like 123.1.101/32 and IPv6 shortening like FE80::1 is here <b>NOT</b> supported!) - group definitions could be used. Use one entry per line. Wildcards are supported (fribo*@domain.co?) except for IP addresses. A second parameter separated by "=>" specifies the size limit in byte. <br />
For example:<br />
fribo*@thisdomain.co?=&gt;1000000<br />
jhanna=&gt;0<br />
@sillyguys.org=&gt;500000<br />
101.1.2.16=&gt;0<br />
[admins]=&gt;0 <br />
If multiple matches (values) are found in a mail for any IP address in the transport mail chain, any envelope recipient and the envelope sender, the highest value or 0 (no limit) will be used! If no match (value) is found in a mail, the definition in maxSize will take place. NoProcessing (except npsize) will skip this check.'
,undef,undef,'msg009510','msg009511'],
['maxSizeExternal','Max Size of External Message',10,\&textinput,'','(\d*)',undef,
 'If the value of ([message size]) exceeds maxSizeExternal in bytes the transmission of the external message will be canceled. No limit is imposed by ASSP if the field is left blank or set to 0. This option allows admins to limit useless bandwidth wasting based on the transmit size.',undef,undef,'msg008630','msg008631'],
['MaxSizeExternalAdr','Max Size of External Message Addresses*',40,\&textinput,'file:files/MaxSizeExt.txt','(\s*file\s*:\s*.+|)','configUpdateMaxSize',
'Use this parameter to set individual maxSizeExternal values for email addresses, domains, user names and IP addresses. A file must be specified if used.<br />
Accepts specific addresses (user@domain.com), user parts (user), entire domains (@domain.com) and IP addresses (IP-ranges and CIDR notation like 123.1.101/32 and IPv6 shortening like FE80::1 is here <b>NOT</b> supported!) - group definitions could be used. Use one entry per line. Wildcards are supported (fribo*@domain.co?) except for IP addresses. A second parameter separated by "=>" specifies the size limit in byte. <br />
For example:<br />
fribo*@thisdomain.co?=&gt;1000000<br />
jhanna=&gt;0<br />
@sillyguys.org=&gt;500000<br />
101.1.2.16=&gt;0<br />
[admins]=&gt;0 <br />
If multiple matches (values) are found in a mail for any IP address in the transport mail chain, any envelope recipient and the envelope sender, the highest value or 0 (no limit) will be used! If no match (value) is found in a mail, the definition in maxSizeExternal will take place. NoProcessing (except npsize) will skip this check.',undef,undef,'msg009520','msg009521'],
['maxSizeError','max message size Error',80,\&textinput,'552 message exceeds MAXSIZE byte (size)','(552 .*)',undef,'SMTP error message to reject maxSize / maxSizeExternal exceeding mails. For example:552 message exceeds MAXSIZE byte (size)! MAXSIZE will be replaced by the value of maxSize / maxSizeExternal.',undef,undef,'msg008640','msg008641'],

['MaxAUTHErrors','Max Number of AUTHentication Errors',10,\&textinput,'','(-\d+|\d*)','ConfigChangeMaxAUTH',
 'If an IP (/24 network is used for incoming mails) exceeds this number of authentication errors (535 or 530) the transmission of the current message will be canceled and any new connection from that IP will be blocked for 5-10 minutes.<br />
  Every 5 Minutes the \'AUTHError\' -counter of the IP will be decreased by one. autValencePB is used for the penalty box.<br />
  No limit is imposed by ASSP, if the field is left blank or set to zero (zero cleans the related cache \'AUTHError\'). If your MTA offers AUTH without supporting it (has no user accounts) define a negative value here (e.g. -1). In this case assp and the MTA will function as an AUTH-honeypot, the peer will get an penalty at the first AUTH request.<br />
  This option allows admins to prevent external bruteforce or dictionary attacks by AUTH command. Whitelisted, noBlockingIPs , noMaxAUTHErrorIPs and NoProcessing IP\'s are ignored like any relayed connection.',undef,undef,'msg009310','msg009311'],
['ResetMaxAUTHErrorIPs','Reset the MaxAUTHErrors Counter for these IP\'s*',40,\&textinput,'','(\S*)','ConfigMakeIPRe',
 'List of IP\'s for which MaxAUTHErrors counter should be cleared immediatly after a successful login.  For example: 145.145.145.145|145.146.<br />
 It is not recommended to use this option for security reasons, but it may required for client networks behind a NAT.',undef,undef,'msg010540','msg010541'],
['noMaxAUTHErrorIPs','Do not check MaxAUTHErrors for these IP\'s*',40,\&textinput,'','(\S*)','ConfigMakeIPRe',
 'List of IP\'s which should not be checked for MaxAUTHErrors .  For example: 145.145.145.145|145.146.',undef,undef,'msg009580','msg009581'],
['AUTHUserIPfrequency','Max IP Changes for AUTHentication per User',20,\&textinput,'','((?:[2-9]|\d{2,})\s+(?:[6-9]\d{2}|\d{4,})|)','ConfigChangeMaxAUTHIP',
 'If the authentication methodes PLAIN, LOGIN or CRAM-MD5 are used by clients, two space separated values specify the number of different IP\'s and a timeframe in seconds, which should not be exeeded by a user.<br />
 For example "2 600" - notice these are the minimum values for IP-number and seconds.<br />
 The example disallows a user to authenticate (using PLAIN or LOGIN) from two or more different IP-addresses within 600 seconds. In other words - an user is allowed to authenticate from another IP-address, 601 seconds after the last authentication.<br />
 Each attempt to authenticate is counted by this feature.<br />
 MaxAUTHErrors is counted, if a user breaks this rule.<br />
 Leave this blank to disable this feature.<br />
 <input type="button" value="AUTHIP Cache" onclick="javascript:popFileEditor(\'DB-AUTHIP\',\'1h\');" /><br />',undef,undef,'msg010570','msg010571'],

['DoSameSubject','Check Same Subjects','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,0,'(.*)',undef,
 'If activated, assp will check the mail subjects for equality or similarity using the config parameters below. Scoring is done with \'isValencePB\'.',undef,undef,'msg010040','msg010041'],

['subjectFrequencyInt','Subject Frequency Interval',40,\&textinput,'300','(\d*)',undef,'The time interval in seconds in which the number of equal subjects has not to exceed a specific number ( subjectFrequencyNumSubj ).<br />
  Use this in combination with subjectFrequencyNumSubj to limit the number of equal or similar subjects in a given interval. A value of 0 (default) will disable this feature and clean the cache within five minutes.<br />
  <input type="button" value="edit Subject Frequency Cache" onclick="javascript:popFileEditor(\'DB-subjectFrequencyCache\',\'1h\');" />',undef,undef,'msg010050','msg010051'],

['subjectFrequencyNumSubj','Subject Frequency Number of Subjects',40,\&textinput,'5','(\d*)',undef,'The number of equal subjects that has not to exceed in a specific time interval ( subjectFrequencyInt ).<br />
  Use this in combination with subjectFrequencyInt to limit the number of equal or similar subjects in a given interval. A value of 0 (default) will disable this feature and clean the cache within five minutes.<br />
  <input type="button" value="edit Subject Frequency Cache" onclick="javascript:popFileEditor(\'DB-subjectFrequencyCache\',\'1h\');" />',undef,undef,'msg010060','msg010061'],

['subjectFrequencyOnly','Check Equal Subject Frequency for this Users only*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'A list of local addresses, for which the \'subject frequency check\' should be done. Leave this field blank (default), to do the check for every address.<br />
  Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).<br />
  For example: fribo*@thisdomain.com|jhanna|@sillyguys.org ',undef,undef,'msg010070','msg010071'],

['NoSubjectFrequency','Check Equal Subject Frequency NOT for this Users*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'A list of local addresses, for which the \'subject frequency check\' should not be done.<br />
  Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).<br />
  For example: fribo*@thisdomain.com|jhanna|@sillyguys.org ',undef,undef,'msg010080','msg010081'],

['NoSubjectFrequencyIP','Check Equal Subject Frequency NOT for this IP\'s*',60,\&textinput,'','(\S*)','ConfigMakeIPRe','Mail from any of these IP numbers will pass through without checking the equality or similarity of subjects. For example: 145.145.145.145',undef,undef,'msg010090','msg010091'],

['smtpIdleTimeout','SMTP Idle Timeout',5,\&textinput,'180','(\d?\d?\d?\d?)',undef,
 'The number of seconds a session is allowed to be idle before being forcibly disconnected. The default is 180 seconds. No limit is imposed by ASSP if the field is left blank or set to 0. If you have not defined an IdleTimeout on your MTA, this value should not be set to 0, because then a connection will never be timed out!',undef,undef,'msg000170','msg000171'],
['NpWlTimeOut','SMTP Idle Timeout for Whitelisted and Noprocessing',5,\&textinput,'1200','(\d?\d?\d?\d?)',undef,
 'The number of seconds a whitelisted or noprocessing session is allowed to be idle before being forcibly disconnected. The default is 1200 seconds. No limit is imposed by ASSP if the field is left blank or set to 0. If you have not defined an IdleTimeout on your MTA, this value should not be set to 0, because then a connection will never be timed out!',undef,undef,'msg009860','msg009861'],
['smtpNOOPIdleTimeout','SMTP Idle Timeout after NOOP',5,\&textinput,'0','(\d?\d?\d?\d?)',undef,
 'The number of seconds a session is allowed to be idle after a "NOOP" command is received, before being forcibly disconnected. The default is 0 seconds. No limit is imposed by ASSP if the field is left blank or set to 0.<br />
  This should prevent hackers to hold and block connections by sending "NOOP" commands short before the "smtpIdleTimeout" is reached.',undef,undef,'msg000180','msg000181'],
['smtpNOOPIdleTimeoutCount','SMTP Idle Timeout after NOOP Count',5,\&textinput,'0','(\d?\d?)',undef,
 'The number of counts a session is allowed send "NOOP" commands following on each other, before being forcibly disconnected. The default is 0. No limit is imposed by ASSP if the field is left blank or set to 0.<br />
  This in cooperation with "smtpNOOPIdleTimeout" should prevent hackers to hold and block connections by sending repeatedly "NOOP" commands short before the "smtpNOOPIdleTimeout" is reached. If "smtpNOOPIdleTimeout" is not defined or 0, this value will be ignored!<hr /><div class="cfgnotes">Notes On SMTP Session Limits</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/sessionlimits.txt\',3);" />',undef,undef,'msg000190','msg000191'],

[0,0,0,'heading','Group Definition for IP\'s , Users and Domains'],
['Groups','Address and Domain Groups*',80,\&textinput,'file:files/groups.txt','(\s*file\s*:\s*.+|)','ConfigMakeGroupRe','
 If you don\'t want to use group definitions, leave this field blank otherwise a file definition like \'file:files/groups.txt\' is required.<br/>
 Group definitions could be used in any other configuration value where multiple user names, email addresses or domain names or IP addresses could be defined.<br />
 Groups are defined and used using the same syntax [group-name] (including the brackets) in a single line. In the configuration parameters, the term [group-name] will be replaced by the content of the group definition, that is done here.<br />
 So, all entries made (or generated) for a group here, have to fulfill the syntax rules for the configuration parameter where the group is used!<br />
 All group definitions are case sensitive. Group names can only contain the following characters: A-Z, a-z, 0-9, - , _ and @ ( the @ only for groups used in BlockReportFile )!<br />
 The structure of this file has to be as follows:<br />
 <br />
 [super_spamlovers]<br />
 myBoss<br />
 ldap:{host=&gt;my_LDAP_server:389,base=&gt;(sep)DC=domain,DC=tld(sep),user=&gt;(sep)CN=admin,DC=domain(sep),password=&gt;(sep)pass(sep),timeout=&gt;2,scheme=&gt;ldap,starttls=&gt;1,version=&gt;3},{(CN=management)}{member},{(CN=%USERID%)}{mailaddress}<br />
 entry<br />
 exec:/usr/bin/list_postfix_users --domain mydomain --group postoffice<br />
 entry<br />
 ...<br />
 <br />
 [admins]<br />
 ldap:{host=&gt;domino1.mydomain.com:389,base=&gt;(sep)DC=domain,DC=tld(sep),user=&gt;(sep)Administrator(sep),password=&gt;(sep)pass(sep),timeout=&gt;2,scheme=&gt;ldap,starttls=&gt;1,version=&gt;3},{(CN=LocalDomainAdmins)}{member},{(%USERID%)}{mailaddress}<br />
 entry<br />
 # include files/other.file.txt
 entry<br />
 ...<br />
 <br />
 [specialIPList]<br />
 1.2.3.4<br />
 123.234.0.0/16<br />
 SPF:domain.org<br />
 SPF:otherdomain.org -_spf1.domain.org, -1.2.3.4/32, -123.2.3.0/24, -...<br />
 SPF:amazon.com -amazonses.com<br />
 ::1<br />
 <br />
 Lines starting with a # OR ; are consider a comment and only those comments are allowed to be used! <b>Never ever comment anything anyhow in a definition line here in Groups!</b> Empty lines will be ignored. A group definition stops, if a new group definition starts or at the end of the file.
 <br />
 <br />
 <font color="orange">For IP-address-lists (only!)</font>, the enhanced SFP: notation can be used. The SPF: definition can follow a comma separated list of hosts, include-definition, redirect-definition and resulting IP-addresses/networks, which should be ignored. The leading hyphen for each excluded entry is mandatory - see the example above!
 <br />
 SPF:amazon.com -amazonses.com  amazon.com without SES : in this example assp will follow include:spf1.amazon.com and include:spf2.amazon.com - but not include:amazonses.com .
 <br />
 Exclusions of SPF-records are active from the point of their definition until the end of the group. If -example.com is defined in the second line of a group definition, but it was used (not excluded, but redirected to or included from) in the first line, the IP\'s of example.com will be not removed from the group!
 <br />
 So, you\'ll come to the right conclusion, that it is the best choice to define all SPF excludes in the first line of a group. To make it easy to define and to read, assp accepts an "eXclude" entry like:
 <br />
 SPF:eXclude -example1.com , -example2.com , -.... , .....
 <br />
 The case sensitive definition "eXclude" is ignored, but the excluded entries are read for the group. You can define more than one SPF:eXclude entries in a group.
 <br />
 <br />
 There are two more possible methods to import entries from an external source into a group - the execution of a system command or an LDAP query.<br />
 To import entries using a system command like (eg. cat, grep, perl -ne or find or your self made shell script), write a single line that begins with exec: followed by the command to be executed - like:<br />
 exec:grep \'@\' /etc/anydir/*.txt<br />
 The executed system command has to write a comma(,) or pipe(|) or linefeed(LF,CRLF) separated list of entries to STDOUT, that should become part of that group, where this line is used. There could be multiple and any combination of entry types in one group definition.<br />
 Be carefull! The external script should never BLOCK, DIE or RUN longer than some seconds. It is may be better, to schedule the script by a system cron job, write the output of the script to a file and to include this file here.<br />
 <br />
 If you are familar with the usage of LDAP, you can define LDAP queries to import entries from one or more LDAP server. This is done, defining one query per line. The syntax of such a line is:<br />
 <br />
 ldap:{host_and_protocol},{LDAP_group_query_filter}{LDAP_group_query_attribut_to_return},{LDAP_entry_query_filter}{LDAP_entry_query_attribut_to_return}<br />
 <br />
 If the \'host_and_protocol\' part is empty {}, the default LDAP configuration will be used. A \'host_and_protocol\' part should contain the following entries in the following structure:<br />
 {host=&gt;127.0.0.1:389,base=&gt;(sep)DC=domain,DC=tld(sep),user=&gt;(sep)...(sep),password=&gt;(sep)pass(sep),timeout=&gt;..,scheme=&gt;ldap/ldaps,starttls=&gt;0/1,version=&gt;2/3}<br />
 The \'host\' has to be set, if you want to define any other LDAP parameter. If any other parameter is not defined, the default LDAP configuration value will be used, except user and password. The port definition (:xxx) in the host setting is optional - if not defined, the default LDAP ports 389(LDAP) and 636(LDAPS) will be used. It is possible to define a comma(,) separated list of hosts for failover functionality like \'host=>"localhost:389,192.168.1.1:389,...."\' - notice the quotes as terminator which are required in this case!<br />
 The value of the base, password and user parameter has to start and end with the same single character (sep) as terminator, that is not part of the value and is not used inside the value.<br >
 examples:<br />
 {host=&gt;127.0.0.1:389,base=&gt;"DC=domain,DC=tld",user=&gt;\'admin\',password=&gt;!p\'as"sW0rD!,timeout=&gt;..,scheme=&gt;ldap,starttls=&gt;1,version=&gt;3}<br /><br />
 {host=&gt;127.0.0.1:389,base=&gt;"CN=group,DC=domain,DC=tld",user=&gt;\'admin\',password=&gt;!p\'as"sW0rD!,timeout=&gt;..,scheme=&gt;ldap,starttls=&gt;1,version=&gt;3}<br /><br />
 The parameter "base" defines the LDAP search root like LDAPRoot .<br />
 <br />
 The \'LDAP_group_query_filter\' and \'LDAP_group_query_attribut_to_return\' are used to query an LDAP group for it\'s members (users). The resulting list will contain the requested attributes of all group members. The definition of these two parameters could look as follows:<br />
 {(&amp;(objectclass=dominoGroup)(CN=LocalDomainAdmins))}{member}<br />
 <br />
 or - if the base DN is already set to the group DN<br />
 {}{member}<br />
  <br />
 It is possible to modify each returned value with a callback-code. This is for example useful for MS-AD queries on the attribute \'proxyaddresses\' (older MS-Exchange), which returns a list of all available mail addresses (SMTP,smtp,X400...).
 <br />
 example: ldap:{},{(&amp;(CN=firstname lastname)(proxyaddresses=smtp:*))<=s/^\s*smtp:\s*(.+)\s*$/$1/i}{proxyaddresses},{}{}
 <br />
 <= is the required separator, s/^\s*smtp:\s*(.+)\s*$/$1/i is the callback code.<br />
 The callback code has to return a value of not zero or undef on success. The code gets the LDAP result in the variable $_ and has to modify this variable in place on success.<br />
 It is not allowed to use any of the following characters in the callback definition of an ldap line: {}| <br />
 <br />
 The \'LDAP_entry_query_filter\' and \'LDAP_entry_query_attribut_to_return\' are used to query each member from the first query, for it\'s email address. The literal \'%USERID%\' in the \'LDAP_entry_query_filter\' will be replaced by each LDAP-attribute result of the first query. The definition of these two parameters could look as follows:<br />
 {(&amp;(objecttype=person)(%USERID%))}{mailaddress} - %USERID% is here replaced by the full returned LDAP result for the user<br />
 or<br />
 {(&amp;(objectClass=user)(objectcategory=person)(CN=%USERID%)(! msExchHideFromAddressLists=TRUE))}{mail} - only the CN= part of the returned LDAP result will be used<br />
 <br />
 to use a different base DN for the \'LDAP_entry_query_filter\' define it as follows as first parameter<br />
 {base=&gt;"DC=domain,DC=tld",(&amp;(objecttype=person)(%USERID%))}{mailaddress}<br />
 <br />
 A callback code could be used the same way like for \'LDAP_group_query_filter\' - {(&amp;(objecttype=person)(CN=%USERID%))<=callback-code}{mailaddress}.
 <br />
 To break long lines into multiple, terminate a continued line with a slash "/"<br /><br />
 If you are able to get all results (eg. email addresses or domain names) with the \'LDAP_group_query\' query, leave the definition of \'LDAP_entry_query_filter\' and \'LDAP_entry_query_attribut_to_return\' empty {}{}.<br />
 <br />
 The result of each group definition will be stored in a file in files/group_export/GROUPNAME.txt.<br />
 The groups are build at every start of assp and if the defined file or an include file is stored (changed file creation or modification time). To force a reload of all groups, open the file and click \'Save changes\' or change the file time with an external shell script. It is also possible to use GroupsReloadEvery, to reload the Groups definition in time intervals, if any of the exec: , ldap: or SPF: option is used. If the TTL of a SPF-record is less, the TTL will be used.<br />
 <br />
 some simple examples:<br />
 <br />
 You use MS-AD with MS-Exchange, you have an AD-group <font color="orange">mailAdmins</font> and you want to import the <font color="green">email addresses</font> of the <font color="orange">members (persons only)</font> of this group into the <font color="blue">same assp group</font> - <font color="green">hidden users should be skipped</font>.<br />
 The AD-controllers (LDAP-servers) are dc1.your-domain.local and dc2.your-domain.local, your mail domain is your-domain.com, LDAP logon user is ldapadmin with the password LdapAdmin0PW=<br />
 <br />
 <font color="blue">[mailAdmins]</font>
 <br />
 ldap:{host=&gt;"dc1.your-domain.local:389,dc2.your-domain.local:389",base=&gt;\'DC=your-domain,DC=local\',user=&gt;\'ldapadmin\',password=&gt;\'LdapAdmin0PW=\',timeout=&gt;10,scheme=&gt;ldap,starttls=&gt;1,version=&gt;3},<font color="orange">{(&amp;(objectclass=group)(CN=mailAdmins))}<b>{member}</b></font>,<font color="green">{(&amp;(objectClass=user)(objectcategory=person)(CN=%USERID%)(! msExchHideFromAddressLists=TRUE))}<b>{mail}</b></font><br />
 <br />
 the same for a IBM Domino cluster<br />
 <br />
 <font color="blue">[mailAdmins]</font><br />
 ldap:{host=&gt;"node1.your-domain.local:389,node2.your-domain.local:389",base=&gt;\'CN=your-domain,O=com\',user=&gt;\'ldapadmin\',password=&gt;\'LdapAdmin0PW=\',timeout=&gt;10,scheme=&gt;ldap,starttls=&gt;1,version=&gt;3},<font color="orange">{(&amp;(objectclass=dominoGroup)(CN=mailAdmins))}<b>{member}</b></font>,<font color="green">{(&amp;(objectclass=person)(CN=%USERID%))}<b>{mail}</b></font><br />
 <br />
 the same for an OpenLDAP cluster<br />
 <br />
 <font color="blue">[mailAdmins]</font><br />
 ldap:{host=&gt;"ldap1.your-domain.local:389,ldap2.your-domain.local:389",base=&gt;\'CN=your-domain,O=com\',user=&gt;\'ldapadmin\',password=&gt;\'LdapAdmin0PW=\',timeout=&gt;10,scheme=&gt;ldap,starttls=&gt;1,version=&gt;3},<font color="orange">{(&amp;(objectclass=group)(CN=mailAdmins))}<b>{member}</b></font>,<font color="green">{(&amp;(objectclass=inetOrgPerson)(CN=%USERID%))}<b>{mail}</b></font><br />
 <br />
 the same for a eDirectory cluster - <font color="red">the callback code is here used to remove ,O=.... after the CN=....</font><br />
 <br />
 <font color="blue">[mailAdmins]</font><br />
 ldap:{host=&gt;"edir.your-domain.local:389,edir2.your-domain.local:389",base=&gt;\'ou=your-domain,o=com\',user=&gt;\'ldapadmin\',password=&gt;\'LdapAdmin0PW=\',timeout=&gt;10,scheme=&gt;ldap,starttls=&gt;1,version=&gt;3},<font color="orange">{(&amp;(objectclass=group)(cn=mailAdmins))<font color="red">&lt;=s/,o=.+//io</font>}<b>{member}</b></font>,<font color="green">{(&amp;(objectclass=inetOrgPerson)(<font color="red">%USERID%</font>))}<b>{mail}</b></font><br />
 <br />
 ASSP will do a small syntax check for your LDAP line definition. How ever - it is recommended to validate your LDAP queries with a ldap tool before you put them into assp and to set LDAPLog to diagnostic while you play around with this configuration!<br /><br />
 NOTICE: Do NOT try to "#include ..." any configuration file used by any other configuration parameter - those includes will be ignored. Instead define the group here and use it in the other configuration parameter(s).<br />
 ','Basic',undef,'msg009470','msg009471'],
['GroupsReloadEvery','Reload the Groups definitions every this minutes <sup>s</sup>',40,\&textinput,60,$ScheduleGUIRe,'configChangeSched',
 'ASSP will reload the Groups definition every this minutes, if any of the exec: , ldap: or SPF: option is used in Groups .<br />
 If the TTL of a SPF-record used in Groups is less, the TTL will be used.<br />
 A value of zero disables the scheduled reload. Defaults to 60 minutes.<br />
 <hr /><div class="cfgnotes">Notes On Group Definitions</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/groupsdef.txt\',3);" />','Basic',undef,'msg007910','msg007911'],

[0,0,0,'heading','SPAM Control <a href="https://sourceforge.net/p/assp/wiki/Getting_Started" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Getting Started" /></a>'],
['redRe','Regular Expression to Identify Redlisted Mail*',80,\&textinput,'file:files/redre.txt','(.*)','ConfigCompileRe',
 'If an email matches this Perl regular expression it will be considered redlisted.<br />
 redRe detects tags to process a mail like the recipient were redlisted - nothing else (no redlist addition/removal).<br />
 The Redlist serves two purposes:<br />
1) the Redlist is a list of addresses that cannot contribute to the
whitelist and which are not considered local even if their mail is
from a local computer. For example, if someone goes on a vacation and
turns on their autoresponder, put them on the redlist until
they return. Then as they reply to every spam they receive they won\'t
corrupt your non-spam collection or whitelist: \[autoreply\]<br />
2) Redlisted addresses will not be added to the Whitelist when your
local user sends mail to that address, thereby preventing accidental
pollution of the Whitelist by, say, inadvertent replies by your
users to mails from the spammer.<br />
Redlisted messages will not be stored in the SPAM/NOTSPAM-collection. As all fields marked by * this field accepts
a list separated by | or a specified file \'file:files/redre.txt\'. ',undef,undef,'msg000200','msg000201'],
['EmailWhiteRemovalToRed','Add  Whitelist Removals To Redlist ',0,\&checkbox,'','(.*)',undef,
  'If set addresses which are removed from Whitelist by email-interface will automatically be added to the Redlist. The address can only be added again to the Whitelist after it is removed from the Redlist.',undef,undef,'msg000210','msg000211'],
['SpamError','Spam Error',80,\&textinput,'554 5.7.1 Mail appears to be unsolicited -- send error reports to postmaster@LOCALDOMAIN','([245]\d\d .*)',undef,'SMTP error message to reject spam. The literal LOCALDOMAIN will be replaced by the recipient domain. The literal LOCALUSER will be replaced by the recipient user part. For example:554 5.7.1 Mail appears to be unsolicited -- send error reports to postmaster@LOCALDOMAIN. ',undef,undef,'msg000220','msg000221'],

['NotSpamTag','Ham Password SALT',80,\&textinput,'','(.{12,}|)',undef,
'If an incoming email subject contains the TAG generated based on this value, it will be considered as defined in NotSpamTagProc . The literal \'NOTSPAMTAG\' (will be replaced by a 10 digit not-spam-tag) can be used in any 5xx error Reply of:<br /><br />
 SpamError <br />
 SenderInvalidError <br />
 PenaltyError <br />
 SPFError <br />
 RBLError <br />
 URIBLError <br />
 UuencodedError <br />
 bombError <br />
 scriptError <br /><br />
 to ask the sender for resending the mail with the TAG in the subject.<br />
 For example: SpamError may be set to:<br />
 554 5.7.1 ERROR mail appears to be unsolicited - send the mail again and append \'NOTSPAMTAG\' to the mail subject - or send error reports to postmaster@LOCALDOMAIN<br /><br />
 Randomly picked up bit sequences of the text defined here, are used as "SALT" to calculate a 10 digit not-spam-tag. This value must be at least 12 characters long. Leave this value empty to disable this feature.<br />
 Every generated TAG can be used by the sender exactly one time. Every additional usage of a TAG will be ignored, and the sender may get a new generated TAG.<br />
 To define your own static TAGs, use whiteRe and/or npRe and change the error reply definitions accordingly.<br />
 To generate a random 80 character string, run \'perl -e "print chr(int(rand(94))+33)for(0...79);"\' from command line and copy and paste the result to here.<br />
 All assp (eg. backup MX), that are processing mails for the same domains, have to used the same value for this parameter!<br /><br />
 If a mail fails on some specific checks (for example SPF, all HELO checks, local sender, spoofing, ForceRBLCache), NOTSPAMTAG is not provided (empty).<br />
 An sender who makes these mistakes, should never get the chance to bypass using the NOTSPAMTAG.',undef,undef,'msg010310','msg010311'],
['NotSpamTagProc','Not-Spam-Tag will consider the mail as','0:only monitor|1:whitelisted|2:noprocessing|3:both',\&listbox,1,'(.*)',undef,'If a sender uses the Not-Spam-Tag , how should the mail be processed. Regardless of this setting, the IP address of the sender will not be penalized, if a NotSpamTag is found.',undef,undef,'msg010320','msg010321'],

['noGriplistUpload','Don\'t Upload Griplist Stats',0,\&checkbox,'','(.*)',undef,
 'Check this to disable the Griplist upload. The Griplist contains IPs and their value between 0 and 1, &lt;0.3 = ham, &gt;0.7 = spam. This value is called the grip value.<br />
 The griplist holds IP scores based on notspam / spam logline reasons stored in the ASSP maillog.txt.<br />
 An IP\'s griplist score is used in a formula to either positively or negatively impact the message/ip score for incoming mail. See the gripValencePB for more explanation.<br />
 If enabled (default), ASSP shares localy calculated values to Sourceforge. This uploaded data are analyzed by a process running at Sourceforge and then used to populate a new griplist (based on the submitted data from all participating ASSP instances).<br />
 Griplist data are uploaded once a day (after the rebuildspamdb task or scheduled).',undef,undef,'msg000230','msg000231'],
['noGriplistDownload','Don\'t auto-download the Griplist file',0,\&checkbox,'','(.*)',undef,
 'Set this checkbox, if you don\'t use the Griplist. You have to disable also noGriplistUpload to download the Griplist. The download is done three times a day.',undef,undef,'msg000240','msg000241'],
['StoreASSPHeader','Store Assp-Header into Spam Collection',0,\&checkbox,'1','(.*)',undef,
 'Add "X-Assp-" to the collected spam-mails.',undef,undef,'msg008770','msg008771'],
['AddIntendedForHeader','Add Envelope-Recipient Header','0:disabled|1:outgoing|2:incoming and local|3:all',\&listbox,2,'(.*)',undef,
 'Adds (according to the setting) a line "X-Assp-Envelope-From: user@domain" for the envelope sender and a line "X-Assp-Intended-For: user@domain" for each envelope recipient to the email header of the mail stream.<br />
 The "X-Assp-Intended-For:" header will not be added for Blind Carbon Copy (BCC:) addresses in outgoing mails, to keep them hidden from external readers. BCC addresses are those listed in the BCC: header and - those that are envelope recipients, but not listed in the TO: and CC: header.<br />
 \'incoming and local\' is the default and recommended.<br />
 Setting this option to any other value than \'disabled\' may be required for reporting, analyzing, resend and some other features to work like expected.<br />
 If not set to \'disabled\', both header lines will be added for all emails (all addresses - incl. BCC) to all collected .eml files.',undef,undef,'msg000250','msg000251'],
['NoExternalSpamProb','Block Outgoing Spam-Prob header',0,\&checkbox,1,'(.*)',undef,
'Check this box if you don\'t want your X-Assp-Spam-Prob header on external mail<br />
 Note this means mail from local users to local users will also be missing the header.',undef,undef,'msg000260','msg000261'],
['AddSpamHeader','Add Spam Header',0,\&checkbox,1,'(.*)',undef,
 'Adds a line to the email header "X-Assp-Spam: YES" if the message is spam, or "X-Assp-Spam: YES (Probably)" if it is possibly spam.',undef,undef,'msg000270','msg000271'],
['AddCustomHeader','Add Custom Header',80,\&textinput,'X-Spam-Status:yes','^(|X\-[A-Za-z0-9_.-]+?:.*)$',undef,
 'Adds a line to the email header if the message is spam. For example: <a href="http://exchangepedia.com/blog/2008/01/assigning-scl-to-messages-scanned-by.html">X-Spam-Status:yes<img src="' . $wikiinfo . '" alt="Assigning SCL to messages scanned by 3rd-party antispam filters" /></a>',undef,undef,'msg000280','msg000281'],
['AddLevelHeader','Add Graphical Level Header',0,\&checkbox,1,'(.*)',undef,
 'Adds a line to the email header "X-Assp-Spam-Level: **** " showing the total message score represented by stars (1 - 20), every star represents five scoring points.',undef,undef,'msg000290','msg000291'],
['AddSubjectHeader','Add X-ASSP-Original-Subject Header',1,\&checkbox,'','(.*)',undef,
 'Adds a line to the email header of incoming mails - "X-ASSP-Original-Subject: the subject".',undef,undef,'msg000300','msg000301'],
['AddSpamReasonHeader','Add Spam Reason Header',0,\&checkbox,1,'(.*)',undef,
 'Adds a line to the email header "X-Assp-Spam-Reason: " explaining why the message is spam.<br />
 <hr /><div class="cfgnotes">Notes On Spam Control</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/spamcontrol.txt\',3);" />',undef,undef,'msg000310','msg000311'],

[0,0,0,'heading','Copy Spam &amp; Ham'],
['sendAllSpam','Copy Spam and Send to this Address',80,\&textinput,'','(.*)',undef,
 'If this is set, ASSP will deliver a copy of spam mails to this address. For example: spammaster@mydomain.com. The literal USERNAME is replaced by the user part of the recipient, the literal DOMAIN is replaced by the domain part of the recipient.
 For example: USERNAME@Spam.DOMAIN, USERNAME+Spam@DOMAIN, catchallspamthis@DOMAIN. Separate multiple entries by comma or space. To deliver copy of spams based on the domain name (only some special hosted domains), use ccSpamInDomain .','Basic',undef,'msg000320','msg000321'],
['ccSpamInDomain','Copy Spam and Send to this Address per Domain*',60,\&textinput,'','(.*)','configUpdateCCD',
 'If the domain of the recipient-address matches one in this list, ASSP will deliver an additional copy of spam emails of a domain to this address (even if sendAllSpam is not set). For example: monitorspam@example1.com|monitor@example2.com .<br />
  The literal USERNAME is replaced by the user part of the recipient.<br />
  An wildcard \'*\' is supported as fallback (no other match is found) for the domain name, like: monitorspam3@*','Basic',undef,'msg008880','msg008881'],
['sendAllDestination','Copy Spam SMTP Destination',20,\&textinput,'','^((?:SSL:)?(?:'.$PortRe.'|'.$HostPortRe.')|)$',undef,
 'IP address and port to connect to when Spam messages are copied. If blank they go to the main SMTP Destination. eg "10.0.1.3:1025", "SSL:10.0.1.3:465", "1025", etc.',undef,undef,'msg000330','msg000331'],
['ccSpamFilter','Copy Spam to these Recipients Only*',40,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Restricts Copy Spam to these recipients. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). Wildcards are supported (fribo*@domain.com).',undef,undef,'msg000340','msg000341'],
['ccSpamAlways','Copy Spam to these Recipients always*',40,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Copy Spam to these recipients regardless of collection mode. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).',undef,undef,'msg000350','msg000351'],
['ccSpamNeverRe','Do Not Copy Spam Regex*',40,\&textinput,'','(.*)','ConfigCompileRe',
 'Never Copy Spam regardless of collection mode. Put anything here to identify messages in their MIME header, any headerline added by assp and any scoring reason - which should not be copied.',undef,undef,'msg000360','msg000361'],
['ccMaxScore','Do Not Copy Messages Above This MessageTotal score',3,\&textinput,'','(\d*)',undef,
 'Messages whose score exceeds this threshold will not be copied.  For example: 75',undef,undef,'msg000370','msg000371'],
['ccMaxBytes','Restrict Copy Spam to MaxBytes',0,\&checkbox,'','(.*)',undef,
 'CCMail will cut off Spam mails, thereby reducing the load considerably.',undef,undef,'msg000380','msg000381'],
['spamSubjectCC','Prepend Spam Subject to Copied Spam',0,\&checkbox,'','(.*)',undef,
 'If set, spamSubject gets prepended to the subject of the copied message.',undef,undef,'msg000390','msg000391'],
['spamTagCC','Prepend Spam Tag to Copied Spam',0,\&checkbox,1,'(.*)',undef,'The check which caused the spam detection will be prepended to the subject of the message. For example: [DNSBL]',undef,undef,'msg000400','msg000401'],
['sendAllHamDestination','Copy Not-Spam SMTP Destination',20,\&textinput,'','^((?:SSL:)?(?:'.$PortRe.'|'.$HostPortRe.')|)$',undef,
 'IP address and port to connect to when  Ham messages are copied. If blank they go to the Spam SMTP Destination. eg "10.0.1.3:1025", "SSL:10.0.1.3:465",, "1025", etc.',undef,undef,'msg000410','msg000411'],
['sendHamInbound','Copy Incoming Not-Spam and Send to this Address',20,\&textinput,'','(.*)',undef, 'If you put an address in this box  ASSP will forward a copy of notspam messages from outside to this address. The literal USERNAME is replaced by the user part of the recipient, the literal DOMAIN is replaced by the domain part of the recipient. For example: archiv@mydomain.com, USERNAME@mybackup.domain, catchallforthis@DOMAIN',undef,undef,'msg000420','msg000421'],
['sendHamOutbound','Copy Outgoing Not-Spam and Send to this Address',20,\&textinput,'','(.*)',undef, 'If you put an address in this box ASSP will forward a copy of outgoing notspam messages to this address.',undef,undef,'msg000430','msg000431'],
['ccHamFilter','Copy Ham Filter*',40,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Copy Not-Spam to these addresses only. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). Wildcards are supported (fribo*@domain.com).',undef,undef,'msg000440','msg000441'],
['ccnHamFilter','Do Not Copy Ham Filter*',40,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Do Not Copy Ham to these addresses. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). Wildcards are supported (fribo*@domain.com).',undef,undef,'msg000450','msg000451'],
['ccMailReplaceRecpt','ccMail Recipient Replacement',0,\&checkbox,'','(.*)',undef,'The recipient replacement (ReplaceRecpt) rules from the "Recipients/Local Domains" section, will be used to replace ccMail recipients. For example: sendHamInbound = USERNAME@yourspamdomain.lan - in this case you are able to detect the target domain "yourspamdomain.lan" in a rule and you can replace the recipient/domain depending on its values and/or on the senders address.<br />
<hr /><div class="cfgnotes">Notes On CC Messages</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/copymail.txt\',3);" />',undef,undef,'msg000460','msg000461'],

[0,0,0,'heading','SPAM Lover and SPAM Hater'],
['spamSubjectSL','Suppress SpamSubject to Spam-Lover-Messages',0,\&checkbox,'','(.*)',undef,
 'If set, spamSubject and spamTag does NOT get prepended to the subject of the Spam-Lover-Message.',undef,undef,'msg000470','msg000471'],
['spamTagSL','Suppress SpamTags to Spam-Lover-Messages',0,\&checkbox,1,'(.*)',undef,
 'If set, spamTags (the method used to catch spam) does NOT get prepended to the subject of the Spam-Lover-Message.',undef,undef,'msg000480','msg000481'],
['groupSpamLovers',"Group SpamLovers and Not SpamLovers per mail",0,\&checkbox,'','(.*)',undef,
 'If set, the first envelope recipient consider a mail to be for spamlovers or not. If the first envelope recipient is any SpamLover, all other (following) envelope recipients must be also any SpamLover (or reverse) - if not, their address will be not accepted by ASSP for this single mail and \'452 too many recipients\' will be sent.',undef,undef,'msg008800','msg008801'],
['spamLovers','All Spam-Lover*',60,\&textinput,'postmaster|abuse','(.*)','ConfigMakeSLReSL',
 'Messages to Spam-Lovers are processed and filtered by ASSP, but (optionally) get tagged with spamSubject (if would be blocked) and are not blocked. When a
 Spam-Lover is not the sole recipient of a message, the message is processed
 normally, and if it is found to be spam, it will not be delivered to the Spam-Lover.<br />
 delaySpamLovers are not included here and must be set additionally.<br />
 Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). Wildcards are supported (fribo*@domain.com). Default: postmaster|abuse.<br />
 For example: fribo*@thisdomain.com|jhanna|@sillyguys.org
 <hr>
 This option and all SpamLover-Options (...SpamLovers) below accept a second score parameter like "user@your-domain.com=>70"<br />
 If such a parameter is defined in any option for an entry and the recipient address matches this entry and the message score exceeds the parameter value, the message will be considered spam.<br />
 If there are multiple possible matches for a recipient address found, the generic longest match (and assigned value) will be used.<br />
 ASSP will use the highest found value for all envelope recipients of an email.<br />
 Notice: the settings for [Local]PenaltyMessageLimit and [Local]PenaltyMessageLow will be overwritten for the mail, if a match is found.<br />
 The according ...Low limit is calculated as:<br />
 for incoming mails: value - ( PenaltyMessageLimit - PenaltyMessageLow )<br />
 or<br />
 for outgoing and local mails: value - ( LocalPenaltyMessageLimit - LocalPenaltyMessageLow )',undef,undef,'msg000490','msg000491'],
['SpamLoversRe','Regular Expression to Identify Spam-Lover*',60,\&textinput,'','(.*)','ConfigCompileRe',
'If a message matches this regular expression it will be considered a Spam-Lover message.',undef,undef,'msg000500','msg000501'],
['baysSpamLovers','Bayesian Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000510','msg000511'],
['baysSpamLoversRe','Regular Expression to Identify Bayesian Spam-Lover*',60,\&textinput,'','(.*)','ConfigCompileRe',
 'If a message matches this regular expression it will be considered a Bayesian Spam-Lover message. For example: password|news',undef,undef,'msg000520','msg000521'],
['baysSpamLoversRed','Do not store Bayesian Spam-Lover in SpamDB',0,\&checkbox,'1','(.*)',undef,
 'If set (recommended), mail to Bayesian Spam-Lover will be stored in the discarded folder (not in the Spam/Notspam folder).',undef,undef,'msg000530','msg000531'],
['blSpamLovers','Blacklisted Domains Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000540','msg000541'],
['bombSpamLovers','Bomb Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000550','msg000551'],
['hlSpamLovers','HELO Blacklisted Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000560','msg000561'],
['hiSpamLovers','Valid/Invalid Helo*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000570','msg000571'],
['atSpamLovers','Bad Attachment Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000580','msg000581'],
['spfSpamLovers','SPF Failures Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000590','msg000591'],
['rblSpamLovers','DNSBL Failures Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000600','msg000601'],
['uriblSpamLovers','URIBL Failures Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000610','msg000611'],
['srsSpamLovers','Unsigned SRS Bounces Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000620','msg000621'],
['delaySpamLovers','No Delaying Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000630','msg000631'],
['isSpamLovers','Invalid Sender Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000640','msg000641'],
['mxaSpamLovers','Missing MX Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000650','msg000651'],
['ptrSpamLovers','Invalid/Missing PTR Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000660','msg000661'],
['pbSpamLovers','Penalty Box Blocking Spam-Lover *',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000670','msg000671'],
['sbSpamLovers','Country Blocking Spam-Lover *',60,\&textinput,'','(.*)','ConfigMakeSLReSL','',undef,undef,'msg000680','msg000681'],
['spamHaters','All Spam-Haters*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Spam-Haters are used to override Spam-Lovers.
 Example: If you have set your entire domain as a Spam-Lover(s), but there are still some addresses you still wish to block spam for. If you add those addresses to the Spam-Haters field allows messages to only those addresses to be blocked while still allowing the messages to the other Spam-Lovers pass through. The message will only be blocked if all recipients are Spam-Haters. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).<br />
 For example: *fribo@thisdomain.com|jhanna|@sillyguys.org ',undef,undef,'msg000690','msg000691'],
['baysSpamHaters','Bayesian Spam-Hater*',60,\&textinput,'','(.*)','ConfigMakeSLRe','',undef,undef,'msg000700','msg000701'],
['rblSpamHaters','DNSBL Failures Spam-Hater*',60,\&textinput,'','(.*)','ConfigMakeSLRe','',undef,undef,'msg000710','msg000711'],
['hlSpamHaters','HELO Blacklisted Spam-Hater*',60,\&textinput,'','(.*)','ConfigMakeSLRe','',undef,undef,'msg000720','msg000721'],
['switchSpamLoverToScoring',"Switch Spam-Lover to Message Scoring",0,\&checkbox,'','(.*)',undef,
 'Put the filter automatically in "Message Scoring Mode" when DoPenaltyMessage is set (instead of stopping spam processing altogether).<br />
 <hr /> <div class="cfgnotes">Notes On Spam-Lover</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/spamlover.txt\',3);" />',,undef,undef,'msg000730','msg000731'],

[0,0,0,'heading','No Processing - IP\'s, Domains, Addresses and Limits'],
['noProcessingIPs','No Processing IPs*',60,\&textinput,'file:files/ipnp.txt','(\S*)','ConfigMakeIPRe',
 'Mail from any of these IP\'s will pass through without processing. (some attachments may be processed)<br />
 For example: 145.145.145.145|146.145.<br />
  To define IP\'s only for specific email addresses or domains (recipients) you must use the file:... option<br />
  An entry (line) may look as follows:<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br /><br />
  It is possible to define a predefined group on any or both sides of the \'=>\' separator, like:<br />
  [ipgroup]=>[usergroup]|user@mydomain<br /><br />
  NOTICE: the following combination of two entries, will lead into a user/domain based matching - the global entry will be ignored!<br />
  145.146.0.0/16 # comment<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br /><br />
 Several features of assp have configuration options to switch on its processing, even any of the \'No Processing\' options matched.<br />
 <span class="positive"> All fields marked by \'*\' accept  a filepath/filename : \'file:files/ipnp.txt\'.</span>',undef,'7','msg000740','msg000741'],
['noProcessing','No Processing Addresses*',60,\&textinput,'Thomas.Eckardt@thockar.com','(.*)','ConfigMakeSLRe',
 'Mail solely to or from any of these addresses are proxied without processing. The envelope sender and recipients are checked. Like a more efficient version of Spam-Lovers &amp; redlist combined. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com). If you register TO addresses here, all recipients for a single mail must be marked as noprocessing to flag the mail as "noprocessing".<br />
  You should have also a look at DKIMNPAddresses , which can be a better, more secure option.',undef,undef,'msg000750','msg000751'],
['noProcessingFrom','No Processing Addresses From*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Mail solely from any of these addresses are proxied without processing. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com).  Wildcards are supported (fribo*@example.com).',undef,undef,'msg000760','msg000761'],
['noProcessingDomains','No Processing Domains*',60,\&textinput,'sourceforge.net|thockar.com','(.*)','ConfigMakeRe',
 'Domains from which you want to receive all mail and  proxy without processing. Your ISP, domain registration, mail list servers, stock broker, or other key business partners might be good candidates. Note this matches the end of the address, so if you don\'t want to match subdomains then include the @. Note that buy.com would also match spambuy.com but .buy.com won\'t match buy.com. For example: sourceforge.net|@google.com|.buy.com<br />
  You should have also a look at DKIMNPAddresses , which can be a better, more secure option to use.',undef,undef,'msg000770','msg000771'],
['npRe','Regular Expression to Identify No Processing Mail*',60,\&textinput,'','(.*)','ConfigCompileRe',
 'If a message matches this Perl regular expression ASSP will treat the message as a \'No Processing\' mail. For example: 169\.254\.122\.|172\.16\.|\\[autoreply\\].',undef,undef,'msg000780','msg000781'],
['npSize','Message Size Limit',10,\&textinput,'500000','(.*)',undef,'ASSP will treat incoming messages larger than this SIZE (in bytes) as \'No Processing\' mail, after the header part of the mail and MaxBytes of the mail body are received. IP-, handshake- and header- checks will be done regardless the noprocessing flag (which is in this case ignored for these checks), all actions that require the full mail are skipped. Empty or 0 disables the feature.<br />
  Please see also neverQueueSize .',undef,undef,'msg000790','msg000791'],
['npSizeOut','Message Size Limit Outgoing',10,\&textinput,'500000','(.*)',undef,'ASSP will treat outgoing messages larger than this SIZE (in bytes) as \'No Processing\' mail, after the header part of the mail and MaxBytes of the mail body are received without any error. Empty or 0 disables the feature.<br />
 Please see also neverQueueSize .',undef,undef,'msg000800','msg000801'],
['processOnlyAddresses','Process Only These Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe','If the Enable Process Only Addresses ( poTestMode ) check box is checked, mail solely to or from any of the addresses in this list (envelope only) will be processed by ASSP. All others will be proxied without processing. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).<br />
  Note that if an address matches both the NoProcessing and the OnlyTheseProcessing lists, the NoProcessing rules take precedence.',undef,undef,'msg000810','msg000811'],
['poTestMode','Enable Process Only Addresses',0,\&checkbox,'','(.*)',undef,'<br />
 <hr /><div class="cfgnotes">Notes On No Processing</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/noprocessing.txt\',3);" />',,undef,undef,'msg000820','msg000821'],

[0,0,0,'heading','Whitelisting and RWL(DNSWL)'],
['whiteListedIPs','Whitelisted IPs*',80,\&textinput,'file:files/ipwl.txt','(\S*)','ConfigMakeIPRe',
 'They contribute to the Whitelist and to Notspam. For example: 145.145.145.145|146.145.|146.145.0.0/16. It is recommended to use the CIDR notation.<br />
  To define IP\'s only for specific email addresses or domains (recipients) you must use the file:... option<br />
  An entry (line) may look as follows:<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br /><br />
  It is possible to define a predefined group on any or both sides of the \'=>\' separator, like:<br />
  [ipgroup]=>[usergroup]|user@mydomain<br /><br />
  NOTICE: the following combination of two entries, will lead into a user/domain based matching - the global entry will be ignored!<br />
  145.146.0.0/16 # comment<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br /><br />
  <span class="positive"> All fields marked by \'*\' accept  a filepath/filename : \'file:files/ipwl.txt\'.</span>',undef,'7','msg000830','msg000831'],
['whiteRe','Regular Expression to Identify Non-Spam*',80,\&textinput,'','(.*)','ConfigCompileRe','If an incoming email matches this Perl regular expression, it will be considered whitelisted.<br />
 For example: Secret Ham Password|307\D{0,3}730\D{0,3}4[12]\d\d<br />
 For help writing regular expressions click <a href="http://www.perlmonks.org/index.pl?node=perlre" rel="external">here</a>.<br />
 IMPORTANT: The body is scanned in a later stage  AFTER all sender related checks are performed. So a white regular expression here might not prevent the message to be blocked by eg. invalid PTR. Set the sender related checks to score only if you want to make sure that the white regular expression will be seen. Some things you might include here are your office phone number or street address, spam rarely includes these details.  .',undef,undef,'msg000840','msg000841'],
['whiteListedDomains','Whitelisted Domains and Addresses*',80,\&textinput,'file:files/whitedomains.txt','(.*)','ConfigMakePrivatRe','Domains and addresses from which you want to receive all mail. Your ISP, domain registration, mail list servers, stock broker, or other key business partners might be good candidates. Be careful not to put widely used or local domains here like google.com or hotmail.com or mydomain.com. Note this matches the end of the address, so if you don\'t want to match subdomains then include the @. Note that example.com would also match spamexample.com but .example.com won\'t match example.com. Wildcards are supported. For example: sourceforge.net|group*@google.com|.example.com<br /><br />
  It is possible to make email addresses whitelisted only for a set of local domains and/or local users. Use wildcards (* and ?) to define domains.<br />
  Use the following syntax to do this:<br />
  *@anydomain=>*@any_local_domain - for domain to domain<br />
  *@*.anydomain=>*@any_local_domain - for any sub-domain to domain<br />
  user@anydomain=>*@*.any_local_domain - for user to any sub-domain<br /><br />
  It is possible to define more than one entry at the left and the right side of the definition (=&gt;), like:<br />
  *@anydomain|*@other_domain=>*@any_local_domain|*@other_local_domain - always separate multiple entries by pipes<br />
  It is also possible to use a GroupDefinition in any or both sides, like:<br />
  [sendergroup]=>[recipientgroup]<br />
  [sendergroup1]|[sendergroup2]|*@domain=>[recipientgroup1]|[recipientgroup2]|user@local_domain<br /><br />
  NOTICE - that the local email addresses and domains are not checked to be local once.<br />
  To define special characters like \'* and ?\' - use their hexadecimal regex representation like \'\\x2A and \\x3F\'.<br />
  You should have also a look at DKIMWLAddresses , which is a better, more secure option.',undef,undef,'msg000850','msg000851'],
['ValidateRWL','Enable Realtime Whitelist Validation',0,\&checkbox,'','(.*)','configUpdateRWL','RWL: Real-time white list. These are lists of IP addresses that have
 somehow been verified to be from a known good host. Senders that pass RWL validation will pass IP-based filters. This requires an installed <a href="http://metacpan.org/search?q=Net::DNS" rel="external">Net::DNS</a> module in PERL. ',undef,undef,'msg000870','msg000871'],
['RWLwhitelisting','Whitelist all RWL Validated Addresses',0,\&checkbox,'','(.*)',undef,'If set, the message will also pass Bayesian Filter and URIBL.',undef,undef,'msg000880','msg000881'],
['RWLServiceProvider','RWL Service Providers*',80,\&textinput,'file:files/dnsrws.txt','(.*)','configUpdateRWLSP','Host Names of RWLs to use separated by "|".<br />
 Examples are:<br />
 <p>list.dnswl.org|query.bondedsender.org|cml.anti-spam.org.cn|iadb.isipp.com|hul.habeas.com </p><br /><br />
 If you use a local provider of the list.dnswl.org zone, your local provider zone name has to contain \'list.dnswl.org\' - for example:<br />
 <p>list.dnswl.org.yourdns.local</p><br />
 because list.dnswl.org provides special return codes (127.0.X.Y)<br />
 where X defines the category and Y the trust value!<br /><br />
 For list.dnswl.org or any equivalent local provider, it is possible to override the reported trust value based on the reported category. To do this, use the following syntax in the service provider definition:<br />
 serviceprovider:category=>trust_value[,category_from-category_to=>-trust_value][,*=>+trust_value]<br />
 * is used, if no other match is found. Any or all categories may be defined for the override. If no override is found for a category, the reported trust value is used.<br />
 + and - are math operations to the reported trust value.<br /><br />
 The currently by dnswl.org provided categories are:<br /><br />
 2 = Financial services<br />
 3 = Email Service Providers<br />
 4 = Organisations<br />
 5 = Service/network providers<br />
 6 = Personal/private servers<br />
 7 = Travel/leisure industry<br />
 8 = Public sector/governments<br />
 9 = Media and Tech companies<br />
 10 = some special cases<br />
 11 = Education, academic<br />
 12 = Healthcare<br />
 13 = Manufacturing/Industrial<br />
 14 = Retail/Wholesale/Services<br />
 15 = Email Marketing Providers<br /><br />
 The returned trust values by list.dnswl.org are:<br /><br />
 0 = none<br />
 1 = low<br />
 2 = medium<br />
 3 = high<br /><br />
 override example: list.dnswl.org:15=>0,2=>+1,5=>-2<br />
 For list.dnswl.org set the trust for category 15 to zero regardless the reported trust value, increase the trust value by one for category 2 and decrease the trust value for the category 5 by 2.',undef,undef,'msg000890','msg000891'],
['RWLmaxreplies','Maximum Replies',5,\&textinput,4,'(\d*)','configUpdateRWLMR','A reply is affirmative or negative reply from a RWL. The RWL module will wait for this number of replies (negative or positive) from the RWLs listed under Service Provider for up to the Maximum Time below. This number should be equal to or less than the number of RWL Service Providers listed to allow for randomly unavailable RWLs. ',undef,undef,'msg000900','msg000901'],
['RWLminhits','Minimum Hits',5,\&textinput,1,'(\d*)','configUpdateRWLMH','A hit is an affirmative response from a RWL. The RWL module will check all of the RWLs listed under Service Provider, and flag the email with a RWL pass flag if equal to or more than this number of RWLs return a positive whitelisted response. This number should be less than or equal to Maximum Replies above and greater than 0',undef,undef,'msg000910','msg000911'],
['RWLmaxtime','Maximum Time',5,\&textinput,10,'(\d*)',undef,'This sets the maximum time to spend on each message performing RWL checks',undef,undef,'msg000920','msg000921'],
['noRWL','Don\'t Validate RWL for these IPs*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','Enter IP addresses that you don\'t want to be RWL validated, separated by pipes (|). For example: 145.145.145.145|146.145.',undef,'7','msg000930','msg000931'],
['AddRWLHeader','Add X-Assp-Received-RWL Header',0,\&checkbox,1,'(.*)',undef,'Add X-Assp-Received-RWL header to header of all mails processed by RWL.',undef,undef,'msg000940','msg000941'],
['RWLCacheInterval','RWL Cache Refresh Interval',4,\&textinput,7,'(\d+\.?\d*|)','configUpdateRWLCR','IP\'s in cache will be removed after this interval in days. 0 will disable the cache. <input type="button" value=" Show RWL Cache" onclick="javascript:popFileEditor(\''.$newDB.'pb/pbdb.rwl.db\',5);" />',undef,undef,'msg000950','msg000951'],
['WhitelistPrivacyLevel','PrivacyLevel of the Whitelist','0:global &amp; private(legacy)|1:domain &amp; private|2:private only',\&listbox,0,'(.*)',undef,
 'Sets the privacy level of the whitelistdb . Default setting is zero, which is the legacy setting.<br />
 If a (local) user adds an email address to the whitelist or an automatic whitelist addition is done:<br /><br />
  (0) global &amp; private - the email address is automatically whitelisted for all local domains and all local users<br />
  (1) domain &amp; private - the email address is automatically whitelisted for all local users in the same local domain<br />
  (2) private only - the email address is only whitelisted for this single local user<br /><br />
 Global and domain based entries are not added to the whitelist by a private addition, if these records are marked as "removed from whitelist".<br />
 If a user removes an email address from his personal whitelist, global and domain based entries are not changed!<br />
 NOTICE: independent from this setting, the whitelistdb manages all three entries (global,domain,private), to make it possible to switch this value at any time.<br />
 This setting is only observed in queries to the whitelist!',undef,undef,'msg009740','msg009741'],
['MaxWhitelistDays','Max Whitelist/Personal Black Days',5,\&textinput,'365','(\d+)',undef,'This is the number of days an address will be kept on the whitelist and personal blacklist without any email to/from this address. Set it to 0 to keep the entries infinity.',undef,undef,'msg000960','msg000961'],
['WhitelistOnly','Reject All But Whitelisted Mail',0,\&checkbox,'','(.*)',undef,'Check this if you don\'t want Bayesian filtering and want to reject all mail from anyone not whitelisted. To do this related to local user addresses, use InternalAndWhiteAddresses and switch this option off.',undef,undef,'msg000970','msg000971'],
['NoAutoWhite','Only Email-Interface Addition to Whitelist.',0,\&checkbox,'','(.*)',undef,'Check this box to  allow additions to the whitelist by email interface only.',undef,undef,'msg000980','msg000981'],
['NoAutoWhiteAdresses','No AutoWhite Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Mail solely to or from any of these addresses are excluded from automatic whitelist additions. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).',undef,undef,'msg009970','msg009971'],
['NotGreedyWhitelist','Senders are compared/added to the whitelist','0:check all addresses - one white match - add all|1:consider whitelisted, if the envelop sender is white|2:check all addresses - all must matches for white - update all',\&listbox,'0','(.*)',undef,'Normal operation includes addresses in the FROM, SENDER, REPLY-TO, ERRORS-TO, or LIST-* header fields.<br />
  This allows nearly all list email to be whitelisted.<br />
  If set to \'check all addresses - one white match - add all\', one match in any of this fields is enough to get white and all addresses will be added to whitelist.<br />
  If set to \'consider whitelisted, if the envelop sender is white\', only the envelope sender address is compared and possibly updated.<br />
  If set to \'check all addresses - all must matches for white - update all\', all found sender addresses in all fields must be already whitelisted for a message to get a whitelisted state and all addresses will updated in whitelist. Notice: this setting will overwrite a match in whiteListedDomains , if a not whitelisted sender is found.<br />
  If any address is found in redlist, no whitelist addition will be done and the message gets not white. <br />
  If the penalty score of a message has reached PenaltyMessageLow, no whitelist addition will be done.<br />
  This setting is ignored, for mails to add/remove whitelist entries by email-interface.',undef,undef,'msg000990','msg000991'],
['GreedyWhitelistAdditions','How add Greedy Senders to Whitelist','0:none|1:envelope only|2:all senders',\&listbox,1,'(.*)',undef,
  'Defines what sender addresses are added to the whitelist if a message is considered to be from a whitelisted sender. NotGreedyWhitelist is considered in determining if a message is from a whitelisted sender.',undef,undef,'msg008780','msg008781'],
['WhitelistLocalOnly','Only local or authenticated users contribute to the whitelist.',0,\&checkbox,'','(.*)',undef,'Normal operation allows all local, authenticated, or whitelisted users to contribute to the whitelist.<br />
  Check this box to not allow whitelisted users to add to the whitelist.',undef,undef,'msg001000','msg001001'],
['WhitelistLocalFromOnly','Only users with a local domain in mailfrom contribute to the whitelist.',0,\&checkbox,'1','(.*)',undef,'Check this box to prevent sender with non-local domains from contributing to the whitelist. (for example: redirected messages).',undef,undef,'msg001010','msg001011'],
['WhitelistAuth','Whitelist mails from authenticated users.',0,\&checkbox,'','(.*)',undef,'Mails from authenticated users will be processed as whitelisted.',undef,undef,'msg001020','msg001021'],
['UpdateWhitelist','Save Whitelist <sup>s</sup>',40,\&textinput,3600,$ScheduleGUIRe,'configChangeSched','Save a copy of the white list every this many seconds. Empty or Zero will prevent any saving and the cleanup of old records.<br />
  <hr /><div class="cfgnotes">Notes On Whitelist</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/whitelist.txt\',3);" />',undef,undef,'msg001030','msg001031'],

[0,0,0,'heading','Local Recipients and Domains &amp; Transparent Recipients and Domains'],
['transparentRecipients','Mails to these Recipients are Handled in Transparent-PROXY Mode*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
'Mails to any of these envelope recipients or domains are handled transparent <b>right after</b> a possible SRS check, BATV processing, Recipient-Replacement, RFC822 checks, ORCPT check and the SMTP DATA command is received.<br />
 Notice: all envelope recipients of an email have to match this feature to move the connection into Transparent-Proxy mode!<br />
 What means "transparent handled" ? ASSP acts like a transparent Proxy. No filter actions are taken for the mail. Nothing is analyzed. Nothing is verfied. Nothing is stored. No X-ASSP-... headers are added. Nothing is logged (except reply codes if configured) - only debugging will work.<br />
 NOTICE: If a connection is moved into the transparent proxy mode, this connection will stay in this mode until "MAIL FROM:" or "RSET" is used or the connection is closed by any peer.<br />
 You can list specific addresses (user@mydomain.com), addresses at any local domain (user), or entire domains (@mydomain.com).  Wildcards are supported (fribo*@domain.com). (|).<br />
 For example: fribo@thisdomain.com|jhanna|@sillyguys.org or place them in a plain ASCII file one address per line - file:files/transparentuser.txt.','Basic',undef,'msg010580','msg010581'],

['removeForeignBCC','remove Foreign BCC',0,\&checkbox,'','(.*)',undef,'Remove foreign BCC: header lines from the mail header. The remove is done before the DoHeaderAddrCheck is done!',undef,undef,'msg009780','msg009781'],

['DoHeaderAddrCheck','Check TO,CC and BCC headers',0,\&checkbox,'','(.*)',undef,'If enabled TO: , CC: and BCC: header lines are checked the following way:<br /><br />
 1. a possible recipient replacement is done<br />
 2. local email address validation is done -  if OK, the next address or headerline is processed<br />
 3. spamtrapaddresses will be detected - scored with stValencePB - <b>mail is blocked</b> (noPenaltyMakeTraps is honored)<br />
 4. a local but not valid TO/CC/BCC: address will be detected - scored with irValencePB <br />
 5. a RelayAttempt will be detected if a BCC address is not local - scored with rlValencePB - <b>mail is blocked</b><br />
 The check 3 and 4 honors whitelisting , noprocessing and noBlockingIPs<br />
 Enable this check only, if assp is configured to validate local domains and email addresses!<br />
 NOTICE: that removeForeignBCC take place before this check is done - step 5 will be never reached if removeForeignBCC is enabled!<br />
 Using this feature can lead into alot of address lookups. LDAP or VRFY address verifications may take a very long (possibly too long) time!',undef,undef,'msg010010','msg010011'],

['sendAllPostmaster','Catchall Address for Messages to Postmaster',20,\&textinput,'','(.*)',undef,'ASSP will deliver messages addressed to all postmasters of your local domains to this address. For example: postmaster@mydomain.com',undef,undef,'msg001250','msg001251'],
['sendAllPostmasterNP','Skip Spam Checks for Postmaster Catchall',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg001260','msg001261'],
['sendAllAbuse','Catchall Address for Messages to Abuse',20,\&textinput,'','(.*)',undef,'ASSP will deliver messages to all abuse addresses of your local domains to this address. For example: abuse@mydomain.com',undef,undef,'msg001270','msg001271'],
['sendAllAbuseNP','Skip Spam Checks for Abuse Catchall',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg001280','msg001281'],
['DoRFC822','Validate addresses to conform with RFC 822','0:disabled|1:recipients|2:sender|3:both',\&listbox,2,'(.*)',undef,'If activated, the envelope sender and/or each envelope recipient is checked to conform with the email format defined in RFC 822. For an invalid sender address \'nofromValencePB\' is used for scoring - for invalid recipient addresses, each is scored with irValencePB .<br />
  For the sender address in addition a top level domain existence and DNS name server registration check is done.<br />
  The default setting is \'sender\' - recommended settings are \'sender\' or \'both\'!',undef,undef,'msg001290','msg001291'],
['LocalAddresses_Flat','Lookup valid Local Addresses from here*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
 'These email addresses are the list of your local addresses. You can list specific addresses (user@mydomain.com), addresses at any local domain (user), or entire domains (@mydomain.com).  Wildcards are supported (fribo*@domain.com). (|).<br />
 For example: fribo@thisdomain.com|jhanna|@sillyguys.org or place them in a plain ASCII file one address per line - file:files/localuser.txt.<br />
 <b>NOTICE: The VRFY definition described below is deprecated in this configuration parameter - use localDomains instead!</b><br />
 You can use entries like @mydomain.com=>[SSL:]vrfyhost:port to VRFY users on your MTA, for more information read localDomains. You can use an entry like ALL=>vrfyhost:port to define a VRFY host for all domain entries ( better use Groups ).<br />
 If the port :465 is defined for VRFY-MTA, or "SSL:" is prepended to the VRFY-MTA, a SSL connection will be used ( read DoVRFY ).<br />
 Notice: If an equal domain entry is defined in localDomains , the entry in localDomains will be used!<br />
 If you define <b>only one domain definition line - using ALL</b><br />
 <b>ALL=>[SSL:]vrfyhost:port</b><br />
 here and ldaplistdb is configured and DoVRFY is enabled and LDAPFail is set to ON, local domains will be additionaly collected into ldaplistdb from verfied addresses, domains and URL\'s (eg. DoLocalSenderAddress , local recipient checks ). The postmaster account must exists for every local domain and subdomain at the MTA!<br />
 <b>Using such a configuration, you must know what you are doing and have a properly configured MTA! Be carefull, the URIBL check ( ValidateURIBL ) can lead into alot of domain lookups and verifications (possibly several hundred per mail). The same applies to the header recipient address validation ( DoHeaderAddrCheck )!</b>','Basic',undef,'msg001300','msg001301'],
['LocalAddresses_Flat_Domains','Use Addresses without \'@\' as Domains',0,\&checkbox,0,'([01]?)',undef,'Will handle entries without \'@\' as full domains',undef,undef,'msg001310','msg001311'],
['RejectTheseLocalAddresses','Reject These Local Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
'If ANY recipient is on reject list, message will not be delivered. Used for disabled legitimate accounts, where a user may have left the company. This stops wildcard mailboxes from getting these messages.',undef,undef,'msg001320','msg001321'],
['localDomains','Local Domains*',80,\&textinput,'putYourDomains.com|here.org','(.*)','ConfigMakeLocalDomainsRe',
 'Check local domains against these addresses. Add a fake domain like \'assp-nospam.org\' for the email interface if you run MS Exchange. When mailing to eg. \'spam@assp-nospam.org\' MS Exchange forwards it outbound to ASSP who handles the different options. As in every field marked by \'*\' separate addresses with | or use file \'file:files/localdomains.txt\'. Wildcards are supported.<br />
 For example: *mydomain.com|*.mydomain.com|here.org <br />
 Use the syntax: *mydomain.com=>smtp.mydomain.com|other.com=>SSL:mx.other.com:port|other2.com=>mx.other.com:port,mx2.other.com:port to verify the recipient addresses with the SMTP-VRFY (if VRFY is not supported \'MAIL FROM:\' and \'RCPT TO:\' will be used) command on other SMTP servers.<br />
 The entry behind => must be the hostname:port or ip-address:port of the MTA which is used to verify \'RCPT TO\' addresses with a VRFY command! If :port is not defined, port :25 or :465 (in case SSL: is defined) will be used.<br />
 You can use an entry like ALL=>vrfyhost:port to define a VRFY host for all local domain entries that don\'t have a MTA defined ( better use Groups ). Separate multiple VRFY hosts for failover by comma ",". You have to enable the SMTP \'VRFY\' command on your MTA - the \'EXPN\' command should be enabled! This requires an installed <a href="http://metacpan.org/search?q=Net::SMTP" rel="external">Net::SMTP</a> module in PERL. <br />
 If the port :465 is defined for VRFY-MTA, or "SSL:" is prepended to the VRFY-MTA, a SSL connection will be used ( read DoVRFY ).<br />
 If you have configured LDAP and enabled DoLDAP and ASSP finds a VRFY entry for a domain, LDAP search will be done first and if this fails, the VRFY will be used. So VRFY could be used for LDAP backup/fallback/failover!<br />
 It is recommended to configure \'ldaplistdb\' in the \'File Paths and Database\' section when using this verify extension - so ASSP will store all verified recipients addresses there to minimize the queries on MTA\'s. There is no need to configure LDAP, but both VRFY and LDAP are using ldaplistdb. Please go to the \'LDAP setup\' section to configure MaxLDAPlistDays and LDAPcrossCheckInterval or start a crosscheck now with forceLDAPcrossCheck. This three parameters belong also to VRFY.<br />
 <b>If \'ldaplistdb\' is configured and an entry is <span class="negative">removed from localdomains</span>, force a LDAPcrosscheck ( forceLDAPcrossCheck ) to <span class="negative">remove outdated no longer local addresses</span> from ldaplistdb!</b><br />
 Notice: if an equal domain entry is defined in LocalAddresses_Flat (deprecated !!!), the entry in localDomains will be used!','Basic',undef,'msg001330','msg001331'],
['DoVRFY','Verify Recipients with SMTP-VRFY',0,\&checkbox,1,'(.*)',undef,
 'If activated and the format \'Domain=>MTA:Port\' is encountered in localDomains and/or LocalAddresses_Flat, recipient addresses will be verified with SMTP-VRFY (if VRFY is not supported \'MAIL FROM:\' and \'RCPT TO:\' will be used).
 If you know that VRFY is not supported with a MTA, you may put the MTA into VRFYforceRCPTTO. Don\'t forget to configure LDAPFail (belongs also to VRFY) to your needs!<br />
 If the SMTP-SSL port :465 is defined with a MTA, or "SSL:" is prepended to the MTA definition and the module IO::Socket::SSL is available, a SSL connection will be used for the SMTP-VRFY-session.', undef,undef,'msg008850','msg008851'],
['enableTLS4VRFY','Enable STARTTLS for VRFY',0,\&checkbox,0,'([01]?)',undef,'If enabled and the module IO::Socket::SSL is available and STARTTLS is supported by the VRFY-MTA and the SMTP-VRFY-session is not in SSL-mode, assp will try to use the STARTTLS command to secure the SMTP-VRFY-session.',undef,undef,'msg010590','msg010591'],
['VRFYQueryTimeOut','SMTP VRFY-Query Timeout',5,\&textinput,'5','(\d\d?)',undef,
 'The number of seconds ASSP will wait for an answer of the MTA that is queried with the VRFY command to verify a recipient address.',undef,undef,'msg001340','msg001341'],
['VRFYforceRCPTTO','Force the usage of RCPT TO*',80,\&textinput,'','(.*)','ConfigMakeRe','Define MTA\'s here for which you want ASSP to force the usage of MAIL FROM:,RCPT TO: instead of the VRFY command. The definition of each MTA has to be the same as defined in LocalAddresses_Flat and/or localDomains (after the \'=>\') for example: smtp.mydomain.com|SSL:mx.other.com:port|10.1.1.1|10.1.1.2:125 .',undef,undef,'msg001350','msg001351'],
['DisableVRFY','Disable VRFY and EXPN for External Clients',0,\&checkbox,'','(.*)',undef,'If you have enabled VRFY and/or EXPN on your MTA to make assp able to verify addresses and you do not want external clients to use VRFY and EXPN - select this option.',undef,undef,'msg008600','msg008601'],
['DoLDAP','Do LDAP lookup for valid local addresses',0,\&checkbox,'','(.*)',undef,'Check local addresses against an LDAP database before accepting the message.<br />
 Note: Checking this requires filling in the other LDAP parameters below.<br />
 This requires an installed <a href="http://metacpan.org/search?q=Net::LDAP" rel="external">Net::LDAP</a> module in PERL.',undef,undef,'msg001360','msg001361'],
['LocalAddressesNP','Do Not  Validate Local Addresses if in NoProcessing List',0,\&checkbox,'','(.*)',undef,'If a recipient is found in NoProcessing, the user validation is skipped. ',undef,undef,'msg001370','msg001371'],
['CatchAll','Catchall per Domain*',40,\&textinput,'','(.*)','configUpdateCA','ASSP will send to this addresses/domain if no valid user is found in LocalAddresses_Flat/LDAP. <br />
 For example: catchall@domain1.com|catchall@domain2.com',undef,undef,'msg001390','msg001391'],
['CatchAllAll','Catchall for All Domains',40,\&textinput,'','(.*)',undef,'ASSP will send to this address if no valid user is found  in LocalAddresses_Flat/LDAP and no match is found in Catchall per Domain. <br />
 For example: catchall@domain.com',undef,undef,'msg001400','msg001401'],
['CatchallallISP2NULL','Move ISP Connection with wrong Recipient Address to NULL',0,\&checkbox,'','(.*)',undef,
  'If set, ASSP will move all ISP connections with wrong recipient addresses to a NULL-connection. The ISP will receive "250 OK" until the mail has passed, but the mail will not be sent to your MTA. This is done after CatchAll but before CatchAllAll is checked.',undef,undef,'msg001410','msg001411'],
['NullAddresses','NULL Connection Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe','ASSP will dump a message silently when encountering such an address in "MAIL FROM:" or "RCPT TO:". Accepts specific addresses (null@example.com), user parts (nobody) or entire domains (@example.com).',undef,undef,'msg001420','msg001421'],
['InternalAddresses','Accept Mail from Local Domains only*',80,\&textinput,'','(.*)','ConfigMakeSLRe','These local addresses accept mail only from local domains. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). Wildcards are supported (fribo*@domain.com).',undef,undef,'msg001430','msg001431'],
['InternalAndWhiteAddresses','Accept Mail from Local Domains and Whitelisted Senders only*',80,\&textinput,'','(.*)','ConfigMakeSLRe','These local addresses accept mail only from local domains and whitelisted external senders. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). Wildcards are supported (fribo*@domain.com).',undef,undef,'msg009890','msg009891'],
['SepChar','Separation Character for Subaddressing',2,\&textinput,'','([^*\s]*)',undef,'RFC 3598 describes subaddressing with a Separation Character. A star or asterix (\'*\') is not allowed as Separation Character. Everything between Separation Character and @ is ignored (including Separation Character). It is possible to define more than one character, like: +-_ . In this case, each single one of them is used as Separation Character. Example = \'+\' will allow user+subaddress@domain.com , \'+-\' will allow user+subaddress@domain.com and user-subaddress@domain.com.<br />
 The subaddressing removes the SepChar and :detail-part from every envelope recipient. For the header addresses (to,cc,bcc) the subadressing is only done, if DoHeaderAddrCheck is enabled and only to verfy the header addresses - the header will not be changed by this feature!<br />
 If you enabled the recipient replacement ( ReplaceRecpt ) and/or uses BATV Tagging and Validation( DoBATV ), keep in mind that subaddressing is done after these features were processed!',undef,undef,'msg001440','msg001441'],
['EnableBangPath','Support Bang Path',0,\&checkbox,'','(.*)',undef,
 'If set, ASSP will support addresses like domainx!user and will convert them to user@domainx .',undef,undef,'msg001450','msg001451'],
['MaxVRFYErrors','Maximum recipient verification Errors',5,\&textinput,'0','(\d+)',undef,
  'The maximum number of failed \'RCPT TO\' or \'VRFY\' commands encountered before the connection is dropped. You can leave this field at 0, if you are using \'DoLDAP\', \'LocalAddresses_Flat\'! If configured, ASSP will drop the connection, if the count of \'550 unknown user\' errors, received from your \'smtpDestination\'(MTA), reached this value!',undef,undef,'msg001460','msg001461'],
['DoMaxDupRcpt','Block Max Duplicate Recipients','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(\d*)',undef,
  'Block remote servers that uses the same recipient address more times, than the number defined in MaxDupRcpt in the RCPT TO: command. Scoring is done with mdrValencePB . This check is skipped for outgoing, noprocessing, whitelisted and spamlovers mails. If a message has to be delayed, this check will score before the delay if set to block or score - and score and/or block on the next server request.',undef,undef,'msg008950','msg008951'],
['MaxDupRcpt','Maximum Allowed Duplicate Recipient Addresses',5,\&textinput,'0','(\d+)',undef,
  'The maximum number of duplicate recipient addresses that are allowed in the sequence of the RCPT TO: commands!<br />
  The number per mail is calculated by \'number of RCPT TO: commands  -  number of unique recipient addresses\'.<br />
  For example: if one address is used three times or two addresses are used each two times, will result in the same count - 2. Or if both is the case in one mail, the count will be 4.',undef,undef,'msg008960','msg008961'],
['ReplaceRecpt','Enable recipient replacement*',80,\&textinput,'file:files/rcptreplrules.txt','(.*)','configChangeRcptRepl','recommended if used: file:files/rcptreplrules.txt - default empty ! This enables recipient replacement. If you do not use file:, separate the rules with |. The replacement will be done before any ASSP check. Use this option carefully - for example: if you have enabled DKIM check, the DKIM check will fail, if the recipient of the mail was modified. For a more detailed description of the rules and options, read the file: files/rcptreplrules.txt!',undef,undef,'msg001470','msg001471'],
['NoValidRecipient','No-Valid-Local-User Reply',80,\&textinput,'550 5.1.1 User unknown: EMAILADDRESS','([5|4|2]\d\d .*)',undef,'SMTP reply for invalid Users. Default: \'550 5.1.1 User unknown: EMAILADDRESS\' <br />
 The literal EMAILADDRESS (case sensitive) is replaced by the fully qualified SMTP recipient (e.g., thisuser@yourcompany.com).<br /><hr /><div class="cfgnotes">Notes On Local Addresses</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/localaddresses.txt\',3);" />',undef,undef,'msg001480','msg001481'],

[0,0,0,'heading','Validate HELO and EHLO'],
['invalidHeloRe','Regular Expression to Immediatly Blocked Invalid HELO*',80,\&textinput,'ylmf-pc','(.*)','ConfigCompileRe',
 'Regular expression to check and block immediatly incoming HELOs.<br />
 This option blocks and drops a connection immediatly by sending a reply "554 5.7.1 the connection is rejected - bad host identity detected", if the sent HELO matches this regular expression.
 The check is done immediatly after the HELO is sent by a peer. It can be used to block BOT\'s, that are using different IP\'s but the same or similar HELO every time.<br />
 <b>Notice: this option ignores all other settings in assp!</b><br />
 The penalty box score for the connected IP is increased by ihValencePB .<br />
 For example:  ylmf-pc',undef,undef,'msg010600','msg010601'],
['useHeloBlacklist','Use the Helo Blacklist','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'Use the list of blacklisted-helo hosts built by rebuildspamdb.',undef,undef,'msg001490','msg001491'],
['useHeloGoodlist','Use the Helo Goodlist','0:disabled|1:bonus|2:whitelisted|3:bonus &amp; whitelisted',\&listbox,1,'(.*)',undef,
  'Use the list of known good helo hosts built by rebuildspamdb.<br />
  bonus - the message/IP get a bonus of a calculated negative weighted value using hlValencePB - score = -10 * hlValencePB * good-helo-weigth - example: -10 * 20 * 0.2 = -40<br />
  whitelisted - the message is processed as whitelisted<br /><br />
  The good helos and weights are stored together with the helo blacklist.',undef,undef,'msg009920','msg009921'],
['DoIPinHelo','Do Score Suspicious Helos','0:disabled|2:monitor|3:score',\&listbox,3,'(\d*)',undef,
  'Score servers with IP number in Helo and check for mismatch with sending IP.',undef,undef,'msg001500','msg001501'],
['ForceFakedLocalHelo','Enforce Check of Forged Helos Before Delaying',0,\&checkbox,1,'(.*)',undef,
  'If set, ASSP will  check Forged Helos before DELAYING. Collecting, Testmode, CopySpam, Spam-Lover and private/domain whitelist ( WhitelistPrivacyLevel ) is ignored.',undef,undef,'msg001510','msg001511'],
['DoFakedLocalHelo','Block Forged Helos','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(\d*)',undef,
  'Block remote servers that claim to come from our Local Domains/Local IP\'s/Local Host.',undef,undef,'msg001520','msg001521'],
['DoFakedUseLocalDomain','Use Local Domain List for Blocking Forged Helos',0,\&checkbox,1,'(.*)',undef,
  'If set, DoFakedLocalHelo will use localDomains .',undef,undef,'msg001530','msg001531'],
['DoFakedWL','Do Not Block Whitelisted',0,\&checkbox,'','(.*)',undef,
  'Disable "Block Forged Helo\'s" for whitelisted addresses (not recommended).',undef,undef,'msg001540','msg001541'],
['DoFakedNP','Do Not Block Noprocessing',0,\&checkbox,'','(.*)',undef,
  'Disable "Block Forged Helo\'s" for addresses identified as noprocessing (not recommended).',undef,undef,'msg001550','msg001551'],
['myServerRe','Local Domains,IP\'s and Hostnames*',80,\&textinput,'','(.*)','ConfigMakeRe',
  'Local Domains, IP\'s and Hostnames are often used to fake (forge) the Helo. Include all IP addresses and hostnames for your server here, \'localhost\' and the values of myName and myNameAlso are already included. Include Local Domains of your choice here, if you deactivated the automatic use of the local domain list.  For example: 11.22.33.44|mx.YourDomains.com|here.org','Basic',undef,'msg001560','msg001561'],
['noHelo','Don\'t Validate HELO for these IP\'s*',60,\&textinput,'127.0.0.0/8|::1','(\S*)','ConfigMakeIPRe',
  'Enter IP addresses that will be excluded from all HELO checks. Default setting is 127.0.0.0/8|::1.<br />
   For example: 127.0.0.1|::1|192.168.',undef,'7','msg001570','msg001571'],
['heloBlacklistIgnore','Don\'t process these HELO\'s*',80,\&textinput,'','(.*)','ConfigMakeRe',
  'HELO / EHLO greetings on this list will be excluded from all HELO checks. For example: host123.isp.com|host456.*.com',undef,undef,'msg001580','msg001581'],
['ForceValidateHelo','Enforce Early Helo Checks',0,\&checkbox,1,'(.*)',undef,
  'If set, ASSP will  Validate/Invalidate the format of HELO before DELAYING. Collecting, Testmode, CopySpam, Spam-Lover and private whitelist ( WhitelistPrivacyLevel ) is ignored.',undef,undef,'msg001590','msg001591'],
['DoValidFormatHelo','Validate Format of HELO','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(\d*)',undef,
  'If activated, the HELO is checked against the expression below. If the Regular Expression matches, the HELO is validated as being ok. ',undef,undef,'msg001600','msg001601'],
['validFormatHeloRe','Regular Expression to Validate Format of HELO*',80,\&textinput,'file:files/validhelo.txt','(.*)','ConfigCompileRe',
  'Validate Format HELO will check incoming HELOs according to <a href="https://tools.ietf.org/html/rfc1123" rel="external">RFC1123</a>.<br />
  For example: ^(?:\w[\w\.\-]*\.\w{2,6})$ or ^(?:(?:[a-z\d][a-z\d\-]*)?[a-z\d]\.)+[a-z]{2,6}$',undef,undef,'msg001610','msg001611'],
['DoInvalidFormatHelo','Invalidate Format of HELO','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(\d*)',undef,
  'If activated, the HELO is checked against the expression below. If the Regular Expression matches, the HELO is invalidated as being not ok.',undef,undef,'msg001620','msg001621'],
['invalidFormatHeloRe','Regular Expression to Invalidate Format of HELO**',80,\&textinput,'file:files/invalidhelo.txt','(.*)','ConfigCompileRe','Invalidate Format HELO will check incoming HELOs for this. <br />
 For example:  ^\d+\.\d+\.\d+\.\d+$|^[^\.]+\.?$,',undef,undef,'msg001630','msg001631'],
['DoHeloWL','Do Valid/Invalid/Black Helo for Whitelisted',0,\&checkbox,'1','(.*)',undef,
  'Do valid/invalid Helo for whitelisted addresses.',undef,undef,'msg001640','msg001641'],
['DoHeloNP','Do Valid/Invalid/Black Helo for Noprocessing',0,\&checkbox,'1','(.*)',undef,
  'Do valid/invalid Helo for noprocessing addresses.<br /><hr />
  <div class="cfgnotes">Notes On Validate Helo</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/validatehelo.txt\',3);" />',undef,undef,'msg001650','msg001651'],

[0,0,0,'heading','Validate Sender - Addresses, Domains, Msg-ID, PTR, MX and DKIM'],

['DoBlackDomain','Do Blacklisted Addresses and Domains','0:disabled|1:block|2:monitor|3:score', \&listbox,1,'(\d*)',undef, '',undef,undef,'msg001660','msg001661'],
['DoBlackDomainWL','Do Blacklisting Addresses and Domains for White',0,\&checkbox,'1','(.*)',undef,
  'Do blacklisting addresses &amp; domains in messages which are marked whitelisted by whiteRe, whiteListedDomains, whiteListedIPs, whitelistdb, DoOrgWhiting or ValidateRWL .',undef,undef,'msg001670','msg001671'],
['DoBlackDomainNP','Do Blacklisting Addresses and Domains for NoProcessing',0,\&checkbox,'1','(.*)',undef,
  'Do blacklisting addresses &amp; domains in messages which are marked noprocessing by npRe, noProcessingDomains, noProcessingIPs or noProcessing.',undef,undef,'msg001680','msg001681'],
['blackListedDomains','Blacklisted Addresses and Domains*',60,\&textinput,'file:files/blackdomains.txt','(.*)','ConfigMakePrivatRe','Addresses  &amp; Domains from which you always want to reject mail, they only send you spam. Note this matches the end of the address, so if you don\'t want to match subdomains then include the @. Note that buy.com would also match spambuy.com but .buy.com won\'t match buy.com. abc@def.com will match abc@def.com but won\'t match bbc@def.com. Wildcards are supported. For example: cc|info|biz|seller@bayer.com|sell*@basf.com<br /><br />
  It is possible to make email addresses blacklisted only for a set of local domains and/or local users. Use wildcards (* and ?) to define domains.<br />
  Use the following syntax to do this:<br />
  *@anydomain=>*@any_local_domain - for domain to domain<br />
  *@*.anydomain=>*@any_local_domain - for any sub-domain to domain<br />
  user@anydomain=>*@*.any_local_domain - for user to any sub-domain<br /><br />
  It is possible to define more than one entry at the left and the right side of the definition (=&gt;), like:<br />
  *@anydomain|*@other_domain=>*@any_local_domain|*@other_local_domain - always separate multiple entries by pipes<br />
  It is also possible to use a GroupDefinition in any or both sides, like:<br />
  [sendergroup]=>[recipientgroup]<br />
  [sendergroup1]|[sendergroup2]|*@domain=>[recipientgroup1]|[recipientgroup2]|user@local_domain<br /><br />
  NOTICE - that the local email addresses and domains are not checked to be local once.<br />
  To define special characters like \'* and ?\' - use their hexadecimal regex representation like \'\\x2A and \\x3F\'.',undef,undef,'msg001690','msg001691'],

['DoMsgID','Check Message IDs','0:disabled|2:monitor|3:score',\&listbox,3,'(\d*)',undef,
  'Score messages with missing/suspicious/invalid Message-ID. Scoring is done by midmValencePB / midsValencePB / midiValencePB .',undef,undef,'msg001700','msg001701'],
['noMsgID','Don\'t Validate Message-IDs for these IPs*',80,\&textinput,'127.0.0.|192.168.|10.','(\S*)','ConfigMakeIPRe','Enter IP addresses that you don\'t want to be Message-ID validated, separated by pipes (|). For example: 127.0.0.1|192.168.',undef,'7','msg001710','msg001711'],
['validMsgIDRe','Regular Expression to Validate Format of Message-ID*',80,\&textinput,'^.+\@.+\..+$','(.*)','ConfigCompileRe',
  'Check Message IDs will check incoming messages for valid Message-IDs. <br />
  For example: ^.+\@.+\..+$  <br />
  or less strict: ^.+\@.+$  ',undef,undef,'msg001720','msg001721'],
['invalidMsgIDRe','Regular Expression to Invalidate Format of Message-ID**',80,\&textinput,'','(.*)','ConfigCompileRe',
  'Check Message IDs will check incoming messages for invalid Message-IDs.<br />
  For example: \@localhost$ ',undef,undef,'msg001730','msg001731'],

['DoNoValidLocalSender','Validate Remote Sender with Local Domain Address','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,1,'(\d*)',undef,
  'If activated, each remote sender  with a local domain is checked against the <i>Local Addresses File</i> and/or LDAP. ',undef,undef,'msg001740','msg001741'],
['ForceNoValidLocalSender','Early "Remote Sender with Local Domain Address" Check',0,\&checkbox,'1','(.*)',undef,
  'If set, ASSP will check Remote Sender with Local Domain Address before Delaying a message.<br />
  Collecting, Testmode, CopySpam, and Spam-Lover settings are ignored.',undef,undef,'msg001750','msg001751'],
['DoNoSpoofing','Block Local Address from External Sender ','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'If activated, each external sender address built with a domain in localDomains is regarded a spoofed address. An external sender is a sender from an IP not in acceptAllMail and not authenticated. Scoring is done with slValencePB.',undef,undef,'msg001760','msg001761'],
['onlySpoofingCheckIP','Do Spoofing Check ONLY for these IP\'s*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
 'Enter IP\'s that you want to be checked for spoofing. If this is set, ONLY these IP\'s will be checked. For example:145.145.145.145|145.146.',undef,'7','msg009900','msg009901'],
['onlySpoofingCheckDomain','Do Spoofing Check ONLY for these Addresses/Domains*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). Wildcards are supported (fribo*@example.com). If set, ONLY these addresses/domains will be checked for spoofing.',undef,undef,'msg009910','msg009911'],
['noSpoofingCheckIP','Don\'t do Spoofing Check for these IP\'s*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
 'Enter IP\'s that you don\'t want to be checked for spoofing. For example:145.145.145.145|145.146.',undef,'7','msg001770','msg001771'],
['noSpoofingCheckDomain','Don\'t do Spoofing Check for these Addresses/Domains*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). Wildcards are supported (fribo*@example.com).',undef,undef,'msg001780','msg001781'],
['DoNoSpoofing4From','Do NoSpoofing for from:',0,\&checkbox,'','(.*)',undef,
  'Do the NoSpoofing check also for header \'from:\', \'sender:\' addresses.',undef,undef,'msg009850','msg009851'],
['DoNoSpoofing4ReplyTo','Do NoSpoofing for Reply-To:',0,\&checkbox,'','(.*)',undef,
  'Do the NoSpoofing check also for header \'Reply-To:\', \'Errors-To:\', \'Return-Path:\' and \'Disposition-Notification-To:\' addresses.',undef,undef,'msg010730','msg010731'],
['DoReversed','Reversed Lookup','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'If activated, each sender IP is checked for the existence of a PTR record. Having no PTR record is a fault. Scoring is done using ptmValencePB . This requires an installed <a href="http://metacpan.org/search?q=Net::DNS" rel="external">Net::DNS</a> module in PERL.',undef,undef,'msg001800','msg001801'],
['DoReversedWL','Do Reversed Lookup for Whitelisted',0,\&checkbox,'1','(.*)',undef,
  'Do reversed lookup for whitelisted addresses.',undef,undef,'msg001810','msg001811'],
['DoReversedNP','Do Reversed Lookup for Noprocessing',0,\&checkbox,'1','(.*)',undef,
  'Do reversed lookup for noprocessing addresses.',undef,undef,'msg001820','msg001821'],
['DoReversedSPFOK','Do Reversed Lookup for SPF passed Mails',0,\&checkbox,'','(.*)',undef,
  'Do reversed lookup also for mails that have passed the SPF check. Default is unchecked. Which means, that the PTR check will be skipped, if the mail has passed the SPF check',undef,undef,'msg007150','msg007151'],
['DoInvalidPTR','Reversed Lookup FQDN','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'If activated - and Reversed Lookup is activated -, the PTR-FQDN record is checked against the Regex in invalidPTRRe and validPTRRe ( scoring uses ptiValencePB ). This requires an installed <a href="http://metacpan.org/search?q=Net::DNS" rel="external">Net::DNS</a> module in PERL.',undef,undef,'msg001830','msg001831'],
['invalidPTRRe','Regular Expression to Invalidate Format of PTR**',80,\&textinput,'file:files/invalidptr.txt','(.*)','ConfigCompileRe',
  'Validate Format PTR will check PTR records for this ( scoring uses ptiValencePB ).<br />
  For example:  ^\d+\.\d+\.\d+\.\d+$|^[^\.]+\.?$ or file:files/invalidptr.txt',undef,undef,'msg001840','msg001841'],
['validPTRRe','Regular Expression to Validate Format of PTR*',80,\&textinput,'file:files/validptr.txt','(.*)','ConfigCompileRe',
  'Validate Format PTR will check PTR records for this ( scoring uses ptiValencePB ). <br />
  For example: static or more complex (?=^.{4,253}$)(?:^(?:(?!-)[a-zA-Z0-9\-]{0,62}[a-zA-Z0-9]\.)+[a-zA-Z]{2,63}\.?$) or file:files/validptr.txt',undef,undef,'msg001850','msg001851'],
['PTRCacheInterval','Reversed Lookup Cache Refresh Interval',4,\&textinput,7,'(\d+\.?\d*|)','configUpdatePTRCR',
  'IP\'s in cache will be removed after this interval in days. 0 will disable the cache. <input type="button" value=" Show PTR Cache" onclick="javascript:popFileEditor(\''.$newDB.'pb/pbdb.ptr.db\',5);" />',undef,undef,'msg001860','msg001861'],
['DoDomainCheck','Validate MX and A Record','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'If activated, the envelope sender address and each address found in the following header lines (From:, ReturnReceipt:, Return-Receipt-To:, Disposition-Notification-To:, Return-Path:, Reply-To:, Sender:, Errors-To:, List-...:) is checked for a valid MX record and an A record for the MX. Scoring is done for non existing MX ( mxValencePB ) record and non existing A record for MX ( mxaValencePB ) - a messages fails (block), if both records are not found. If only an IP-address is found for a MX and this IP has no valid PTR and DoInvalidPTR is enabled, the A record check fails.',undef,undef,'msg001870','msg001871'],
['MXACacheInterval','Validate Domain MX Cache Refresh Interval',4,\&textinput,7,'(\d+\.?\d*|)','configUpdateMXACR',
  'IP\'s in cache will be removed after this interval in days. 0 will disable the cache.<input type="button" value=" Show MX Cache" onclick="javascript:popFileEditor(\''.$newDB.'pb/pbdb.mxa.db\',5);" />',undef,undef,'msg001880','msg001881'],
['DoNoFrom','Check for Existing and Valid From: and Sender: Header Tag and Address','0:disabled|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'If enabled, the MIME header is checked for valid From: and Sender: header tags.<br />
  This header check fails and faults are counted if :<br /><br />
  - from: and sender: header tag are both missing<br />
  - different domains found in from: and sender: email addresses<br />
  - multiple from: addresses or from: header tags found <br />
  - multiple sender: addresses or sender: header tags found <br />
  - no or an invalid email address found in from: header tag<br />
  - no or an invalid email address found in sender: header tag<br /><br />
  The scoring value nofromValencePB is added for each detected fault.<br />
  Use DoNoFromSelect to select which faults should be detected by assp.',undef,undef,'msg001890','msg001891'],
['DoNoFromSelect','Select Checks for From: and Sender: Header',4,\&textinput,59,'^([0-9]|[1-5][0-9]|6[0-3]|)$',undef,
 'Select which check should be done in DoNoFrom .<br /><br />
 1 - from: and sender: header tag are both missing<br />
 2 - different domains found in from: and sender: email addresses - or multiple addresses in a single header (FROM: or SENDER:) of different domains are found<br />
 4 - multiple from: addresses or from: header tags found (potential 2x score if option 2 is also enabled)<br />
 8 - multiple sender: addresses or sender: header tags found (potential 2x score if option 2 is also enabled)<br />
 16 - no or an invalid email address found in from: header tag<br />
 32 - no or an invalid email address found in sender: header tag<br /><br />
 Simply form the sum of the numbers in front of the checks you want to select (0...63). Default value is 59 (1+2+8+16+32).',undef,undef,'msg010750','msg010751'],
['DoNoFromWL','Do DoNoFrom for Whitelisted',0,\&checkbox,'1','(.*)',undef,
  'Check for existing and valid From: or Sender: header and address for whitelisted emails.',undef,undef,'msg001900','msg001901'],
['DoNoFromNP','Do DoNoFrom for NoProcessing',0,\&checkbox,'1','(.*)',undef,
  'Check for existing and valid From: or Sender: header and address for noprocessing emails.',undef,undef,'msg001910','msg001911'],
['DoNoFromRemovesNPWL','DoNoFrom Removes NP, WL Flag','0:disabled|1:whitelisted|2:noprocessing|3:both',\&listbox,3,'(.*)',undef,
 'If the combination of DoNoFrom , DoNoFromSelect , DoNoFromWL and DoNoFromNP gives more than one hit, the whitelisted and/or the noprocessing flag will be removed from the message.<br />
 For example: if the FROM: and /or SENDER: address fakes a whitelisted and/or noprocessing address or domain.<br />
 Default setting is both.<br />
 The noprocessing by size flag ( npSize ) will be keeped.',undef,undef,'msg010760','msg010761'],
['removeDispositionNotification','Remove Disposition Notification Headers',80,\&textinput,'','((?:Disposition-Notification-To|Return-Receipt-To|ReturnReceipt)(?:\|[\x21-\x39\x3B-\x7E]+)*|)',undef,
  'To remove any headers : "ReturnReceipt: , Return-Receipt-To: and Disposition-Notification-To:" from not whitelisted and not noprocessing incoming mails, define the unwanted headers as regular expression.<br />
  for example: Disposition-Notification-To<br />
  or: Disposition-Notification-To|Return-Receipt-To<br />
  or: Disposition-Notification-To|Return-Receipt-To|ReturnReceipt<br />
  or any other possible combination. Notice: do NOT define the trailing ":"!<br />
  Define this to prevent unwanted whitelisting of spammers that request a Disposition Notification. Another way to prevent autowhitelisting because of an autoresponder is to use redRe .<br />
  Any other additionally defined header tag will be also removed - you should KNOW what you do!',undef,undef,'msg008970','msg008971'],
['DoDKIM','Validate DomainKeys Identified Mail <a href="http://en.wikipedia.org/wiki/DomainKeys" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="DKIM" /></a>','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'If activated, DomainKeys Identified Mails are checked for the right signature and contents. All DKIM parameters belongs also to the old DomainKey specification. This requires an installed <a href="http://metacpan.org/search?q=Mail::DKIM::Verifier" rel="external">Mail::DKIM::Verifier</a> module in PERL. In addition DKIM is used to process Domain-based Message Authentication, Reporting &amp; Conformance - described in <a href="http://www.dmarc.org/" rel="external">DMARC</a> (DMARC requires also ValidateSPF to be enabled).',undef,undef,'msg001920','msg001921'],
['DoStrictDKIM','Validate DomainKeys Identified Mail strictly',0,\&checkbox,0,'(.*)',undef,
  'The DKIM test will fail, if the mail was modified by a mailhop. In this case the from address, the from domain, the to domain, the DKIM-signature by itself and the prefix of the digest-verification are valid, only the lower digest value differs! This may happen, if a mailhop has modified any other headerfield like X-...! If unchecked a mail will only pass, if the author policy results and sender policy results are accept or neutral!',undef,undef,'msg001930','msg001931'],
['noDKIMAddresses','Do not any DKIM Check for these Addresses *',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Mail from or to any of these envelope addresses will not be tagged and checked for DKIM. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).',undef,undef,'msg001940','msg001941'],
['noDKIMIP','Exclude these IP\'s from any DKIM Check*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','Enter IP\'s that you want to exclude from DKIM check, separated by pipes (|).',undef,undef,'msg001950','msg001951'],
['DKIMWLAddresses','Whitelist these Addresses for valid DKIM Signature *',80,\&textinput,'','(.*)','ConfigMakePrivatRe',
 'If a valid DKIM or DomainKey signature is found and the signature identity (mostly the signature tag i=user@domain.tld) matches any of these addresses, the mail will be passed and saved as if it were in whiteListedDomains . The message will pass filters as Whitelisted and will be added to the corpus just like mail from a whitelisted sender would be. Unlike a true whitelisted sender, no whitelist address additions will be made.<br />
  Note this matches the end of the identity address, so if you don\'t want to match subdomains then include the @. Note that example.com would also match spamexample.com but .example.com won\'t match example.com. Wildcards are supported. For example: sourceforge.net|group*@google.com|.example.com<br /><br />
  It is possible to make this check recipient dependend (eg: on a set of local domains and/or local users). Use wildcards (* and ?) to define receipient domains.<br />
  Use the following syntax to do this:<br />
  *@anydomain=>*@any_local_domain - for domain to domain<br />
  *@*.anydomain=>*@any_local_domain - for any sub-domain to domain<br />
  user@anydomain=>*@*.any_local_domain - for user to any sub-domain<br /><br />
  It is possible to define more than one entry at the left and the right side of the definition (=&gt;), like:<br />
  *@anydomain|*@other_domain=>*@any_local_domain|*@other_local_domain - always separate multiple entries by pipes<br />
  It is also possible to use a GroupDefinition in any or both sides, like:<br />
  [identitygroup]=>[recipientgroup]<br />
  [identitygroup1]|[identitygroup2]|*@domain=>[recipientgroup1]|[recipientgroup2]|user@local_domain<br /><br />
  NOTICE - that the local email addresses and domains are not checked to be local once.<br />
  It is NOT recommended to disable \'DKIMCacheInterval\' if this feature is configured, otherwise only the Plugin Level 2 (complete mail) checks will be affected by this settings!<br />
  To define special characters like \'* and ?\' - use their hexadecimal regex representation like \'\\x2A and \\x3F\'.',undef,undef,'msg010650','msg010651'],
['DKIMNPAddresses','Noprocessing these Addresses for valid DKIM Signature *',80,\&textinput,'','(.*)','ConfigMakePrivatRe',
 'If a valid DKIM or DomainKey signature is found and the signature identity (mostly the signature tag i=user@domain.tld) matches any of these addresses, the mail will be passed and saved as if it were in noProcessingDomains or noProcessing .<br />
  Note this matches the end of the identity address, so if you don\'t want to match subdomains then include the @. Note that example.com would also match spamexample.com but .example.com won\'t match example.com. Wildcards are supported. For example: sourceforge.net|group*@google.com|.example.com<br /><br />
  It is possible to make this check recipient dependend (eg: on a set of local domains and/or local users). Use wildcards (* and ?) to define recipient domains.<br />
  Use the following syntax to do this:<br />
  *@anydomain=>*@any_local_domain - for domain to domain<br />
  *@*.anydomain=>*@any_local_domain - for any sub-domain to domain<br />
  user@anydomain=>*@*.any_local_domain - for user to any sub-domain<br /><br />
  It is possible to define more than one entry at the left and the right side of the definition (=&gt;), like:<br />
  *@anydomain|*@other_domain=>*@any_local_domain|*@other_local_domain - always separate multiple entries by pipes<br />
  It is also possible to use a GroupDefinition in any or both sides, like:<br />
  [identitygroup]=>[recipientgroup]<br />
  [identitygroup1]|[identitygroup2]|*@domain=>[recipientgroup1]|[recipientgroup2]|user@local_domain<br /><br />
  NOTICE - that the local email addresses and domains are not checked to be local once.<br />
  It is NOT recommended to disable \'DKIMCacheInterval\' if this feature is configured, otherwise only the Plugin Level 2 (complete mail) checks will be affected by this settings!<br />
  To define special characters like \'* and ?\' - use their hexadecimal regex representation like \'\\x2A and \\x3F\'.',undef,undef,'msg010660','msg010661'],
['DKIMCacheInterval','Validate DKIM-Pre-Check-Cache Refresh Interval',4,\&textinput,7,'(\d+\.?\d*|)','configUpdateDKIMCR',
  'Domains\'s in cache will be removed after this interval in days. 0 will disable the cache.<br />
  If activated a DKIM-pre-check will be done. If ASSP finds a DKIM-Signature in the mail header, it checks the DNS records of the sending domain for valid DKIM configurations and writes a record into the DKIM-pre-check-cache, if it finds such configuration. If a mail is DKIM signed, the DKIM-pre-check will check the DKIM or DomainKey identity and consistency of the received header.<br />
  The DKIM-pre-check will also set all states and flags for the mail, as they would be set by the full DKIM/DomainKey check.<br />
  If ASSP does not find a DKIM-Signature in the mail header, it also checks the DNS records of the sending domain for valid DKIM configurations. If it find such a configuration, the mail is considered spam, because it should have a DKIM-Signature.<br />
  The next mail from a domain that is found in this cache, must have a DKIM-Signature to pass the DKIM-pre-check. How ever, some DNS records are wrong or inaccurate and will cause ASSP to block mails because of this - register such domains and/or IP\'s in noDKIMAddresses and/or noDKIMIP .<br />
  <input type="button" value=" Show DKIM Cache" onclick="javascript:popFileEditor(\''.$newDB.'pb/pbdb.dkim.db\',5);" />',undef,undef,'msg001960','msg001961'],
['AddDKIMHeader','Add X-Assp-DKIM Header',0,\&checkbox,1,'(.*)',undef,
  'Add a X-Assp-DKIM: , X-ASSP-DKIMidentity: and X-ASSP-DKIM-FlagState: result header.',undef,undef,'msg001970','msg001971'],

['DoARC','Validate Authenticated Received Chain (ARC) Signatures','0:disabled|1:enabled',\&listbox,0,'(.*)',undef,
  'If enabled, <a href="http://arc-spec.org" rel="external">Authenticated Received Chain (ARC)</a> signed Mails are checked for the right signature sequence and contents. ASSP will show the ARC results and will trust the provided Authenticated Results for DKIM, SPF and DMARC if the signing host/domain matches \'trustedAuthForwarders\'. This requires an installed <a href="http://metacpan.org/search?q=Mail::DKIM::Verifier" rel="external">Mail::DKIM::Verifier</a> module in PERL.',undef,undef,'msg010700','msg010701'],

['signedSenders','Senders need to SMIME or PGP Sign All Mail *',80,\&textinput,'file:files/signedSenders.txt','(.*)','ConfigMakePrivatRe',
  'Domains and addresses which have to SMIME or PGP sign or encrypt all mail. If a match is found for a sender and the email is not signed or encryped, the mail will be rejected!<br />
  If configured, this check is done regardless any other assp setting - it will affect all incoming mails!<br />
  If a match is found and the mails is signed or encrypted, the mail will be processed as whitelisted mail!<br />
  Note this matches the end of the address, so if you don\'t want to match subdomains then include the @. Note that example.com would also match spamexample.com but .example.com won\'t match example.com. Wildcards are supported. For example: sourceforge.net|group*@google.com|.example.com<br /><br />
  It is possible to make the senders signing requirement recipient dependend (eg: on a set of local domains and/or local users). Use wildcards (* and ?) to define domains.<br />
  Use the following syntax to do this:<br />
  *@anydomain=>*@any_local_domain - for domain to domain<br />
  *@*.anydomain=>*@any_local_domain - for any sub-domain to domain<br />
  user@anydomain=>*@*.any_local_domain - for user to any sub-domain<br /><br />
  It is possible to define more than one entry at the left and the right side of the definition (=&gt;), like:<br />
  *@anydomain|*@other_domain=>*@any_local_domain|*@other_local_domain - always separate multiple entries by pipes<br />
  It is also possible to use a GroupDefinition in any or both sides, like:<br />
  [sendergroup]=>[recipientgroup]<br />
  [sendergroup1]|[sendergroup2]|*@domain=>[recipientgroup1]|[recipientgroup2]|user@local_domain<br /><br />
  NOTICE - that the local email addresses and domains are not checked to be local once.<br />
  To define special characters like \'* and ?\' - use their hexadecimal regex representation like \'\\x2A and \\x3F\'.',undef,undef,'msg010520','msg010521'],

['SenderInvalidError','Sender Validation Error',80,\&textinput,'554 5.7.1 REASON .','^([245]\d\d .*)$',undef,
  'SMTP error message to reject invalid senders. The literal REASON is replaced by (missing MX, missing PTR, invalid Helo, invalid user, missing signature) depending on the check.<br /><hr />
  <div class="cfgnotes">Notes On Validate Sender</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/validatesender.txt\',3);" />',undef,undef,'msg001980','msg001981'],

[0,0,0,'heading','IP Blocking '],
['DelayIP','Simple IP Greylisting',10,\&textinput,'','(\d*)',undef,
  'Enable simple delaying for IP\'s in black penaltybox with totalscore above this value. A value of zero or empty disables this feature.',undef,undef,'msg009320','msg009321'],
['DelayIPTime','Simple IP Greylisting Embargo Time',5,\&textinput,5,'(\d*)',undef,
  'Enter the number of minutes for which delivery, related with IP address of the sending host, is refused with a temporary failure. Default is 5 minutes.',undef,undef,'msg009330','msg009331'],
['DoDenySMTP','Do Deny Connections from these IP\'s','0:disabled|1:block|2:monitor',\&listbox,1,'(\d*)',undef,
 'If activated, the IP is checked against (denySMTPConnectionsFrom) Deny Connections from these IP\'s.<br />',undef,undef,'msg001990','msg001991'],
['denySMTPConnectionsFrom','Deny Connections from these IP\'s*',40,\&textinput,'','(\S*)','ConfigMakeIPRe','Manually maintained list of IP\'s which should be blocked. IP\'s in noPB, noDelay, acceptAllMail, ispip, whiteListedIPs, noProcessingIPs, whitebox (PBWhite) will pass. For example: file:files/blockip.txt.<br />
  To define IP\'s only for specific email addresses or domains (recipients) you must use the file:... option<br />
  An entry (line) may look as follows:<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br /><br />
  It is possible to define a predefined group on any or both sides of the \'=>\' separator, like:<br />
  [ipgroup]=>[usergroup]|user@mydomain<br /><br />
  NOTICE: the following combination of two entries, will lead into a user/domain based matching - the global entry will be ignored!<br />
  145.146.0.0/16 # comment<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment',undef,'7','msg002000','msg002001'],
['noBlockingIPs','Do not block Connections from these IP\'s*',40,\&textinput,'','(\S*)','ConfigMakeIPRe','Manually maintained list of IP\'s which should not be blocked.  For example: 145.145.145.145|145.146.<br />
  To define IP\'s only for specific email addresses or domains (recipients) you must use the file:... option<br />
  An entry (line) may look as follows:<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br /><br />
  It is possible to define a predefined group on any or both sides of the \'=>\' separator, like:<br />
  [ipgroup]=>[usergroup]|user@mydomain<br /><br />
  NOTICE: the following combination of two entries, will lead into a user/domain based matching - the global entry will be ignored!<br />
  145.146.0.0/16 # comment<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment',undef,'7','msg002010','msg002011'],
['DoDenySMTPstrict','Do Deny Connections from these IP\'s Strictly','0:disabled|1:block|2:monitor',\&listbox,1,'(\d*)',undef,
 'If activated, the IP is checked against (\'denySMTPConnectionsFromAlways\') Deny Connections from these IP\'s Strictly.',undef,undef,'msg002020','msg002021'],
['denySMTPConnectionsFromAlways','Deny Connections from these IP\'s Strictly*',40,\&textinput,'file:files/denyalways.txt','(\S*)','ConfigMakeIPRe',
 'Manually maintained list of IP\'s which should <b>strictly</b> be blocked after address verification and before body and header is downloaded. Contrary to <i>denySMTPConnectionsFrom</i> IP\'s in noDelay, acceptAllMail, ispip, whiteListedIPs, noProcessingIPs, whitebox (PBWhite) will <b>not</b> pass if listed here.',undef,'7','msg002030','msg002031'],
['DoDropList','Do also Deny Connections from these IP\'s','0:disabled|1:add to deny|2:add to denyAlways|3:add to both',\&listbox,0,'(\d*)',undef,
 'If activated, the IP is checked against the Droplist in addition to \'denySMTPConnectionsFromAlways\' and/or \'denySMTPConnectionsFrom\'. The droplist is downloaded if a new one is available and contains the Spamhaus DROP List. See "http://www.spamhaus.org/drop http://www.spamhaus.org/drop/drop.txt http://www.spamhaus.org/drop/edrop.txt http://www.spamhaus.org/drop/dropv6.txt".',undef,undef,'msg002040','msg002041'],
['droplist','Drop also Connections from these IP\'s*',40,\&textinput,'file:files/droplist.txt','(\s*file\s*:\s*.+|)','ConfigMakeIPRe','Automatically downloaded (http://www.spamhaus.org/drop/drop.txt http://www.spamhaus.org/drop/edrop.txt http://www.spamhaus.org/drop/dropv6.txt) list of IP\'s which should be blocked right away. This list could be used in addition to denySMTPConnectionsFrom and/or denySMTPConnectionsFromAlways!',undef,'7','msg005750','msg005751'],
['denySMTPstrictEarly','Do Strictly Deny Connections Early',0,\&checkbox,'','(.*)',undef,
  'IP\'s in <b>denySMTPConnectionsFromAlways</b> will be denied right away.',undef,undef,'msg002050','msg002051'],
['enhancedOriginIPDetect','Do an Enhanced Origin IP Address Detection in the Mail Header','0:disabled|1:all|2:all but most origin',\&listbox,2,'(.*)',undef,
  'If selected, ASSP will analyze the mail headers "RECEIVED:" lines for IP\'s on the mail routing way to detect spam bots, that uses open relay or hijacked mail servers for mail delivery.<br />
  Local and private IP\'s, IP\'s assigned by IANA to the Shared Address Space (100.64.0.0/10 RFC6598) and IP\'s listed in ispip, acceptAllMail, whiteListedIPs, noProcessingIPs, noDelay and noPB will be ignored.<br />
  The detected IP\'s will be additionally checked for IP-Blocking, DNSBL and IP-Frequency - the same way like the connected IP. These IP\'s are also additionally used for the maximum mail size calculation in MaxRealSizeAdr and MaxRealSizeExternalAdr.<br />
  Default setting is \'all but most origin\', which ignores the first of multiple detected public IP address, that was involved in the mail transport (possibly a user device).',undef,undef,'msg009590','msg009591'],
['DoFrequencyIP','Check Frequency - Maximum Connections Per IP','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,0,'(\d*)',undef,
 'Select the action, if maxSMTPipConnects is reached.',undef,undef,'msg002060','msg002061'],
['maxSMTPipConnects','Maximum Frequency of Connections Per IP ',3,\&textinput,'10','(\d?\d?\d?)',undef,
 'The maximum number of SMTP connections an IP Address can make during the <a href="./#maxSMTPipDuration">IP Address Frequency Duration</a>. If a server makes more than this many connections to ASSP within the (maxSMTPipDuration) IP Address Frequency Duration it will be banned from future connections until the (maxSMTPipExpiration) IP Address Frequency Expiration is reached. This can be used to prevent server overloading and DoS attacks. 10 connections are typically enough. If left blank or 0, there is no limit imposed by ASSP. IP\'s in noPB, noDelay, acceptAllMail, ispip, whiteListedIPs, noProcessingIPs, whitebox (PBWhite) are excluded from SMTP session limiting, whitelisted and noprocessing addresses are honored',undef,undef,'msg002070','msg002071'],
['maxSMTPipDuration','Maximum Frequency of Connections Per IP Duration',5,\&textinput,'90','(\d?\d?\d?\d?)',undef,
 'The window (in seconds) during which the (maxSMTPipConnects) IP Frequency (see above for more details) will be scrutinized for each IP. The default is 90 seconds.',undef,undef,'msg002080','msg002081'],
['maxSMTPipExpiration','Expiration of Maximum Frequency',5,\&textinput,'7200','(\d?\d?\d?\d?)',undef,
 'The number of seconds that must pass before an IP address blocked by the (maxSMTPipConnects) IP Address Frequency setting is allowed to connect again. The default is 7200 (seconds) .',undef,undef,'msg002090','msg002091'],
['DoDomainIP','Check Number of IP\'s Per Domain','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,0,'(\d*)',undef,
 'This check is skipped if the IP and domain have passed the SPF-check. If ValidateSPF is enabled and an IP/Domain reaches the maxSMTPdomainIP limit, the MaintThread starts a background SPF check to prevent blocking good mails in future.',undef,undef,'msg002100','msg002101'],
['maxSMTPdomainIP','Limit Number of IP\'s  Per Domain',3,\&textinput,'10','(\d?\d?\d?)',undef,
 'The number of IP(subnet) switches a domain may have during the (maxSMTPdomainIPExpiration) Limit Different IP\'s Per Domain Expiration. If a domain switches more often than this it will be banned from future connections until the Expiration is reached. This can be used to prevent server overloading and DoS attacks. 10 connections are typically enough. If left blank or 0, there is no limit imposed by ASSP. IP\'s in noPB, noDelay, acceptAllMail, ispip, whiteListedIPs, noProcessingIPs, whitebox (PBWhite) are excluded, whitelisted and noprocessing addresses are honored.',undef,undef,'msg002110','msg002111'],
['maxSMTPdomainIPExpiration','Expiration of Limit Number',5,\&textinput,'7200','(\d?\d?\d?\d?\d?)',undef,
  'The number of seconds that must pass before a domain blocked by the (maxSMTPdomainIP) Limit Subnet IP\'s Per Domain setting (see above for more details) is allowed to connect again. The default is 7200 (seconds).',undef,undef,'msg002120','msg002121'],
['maxSMTPdomainIPWL','Do Not Limit Different IP\'s For These Domains*',60,\&textinput,'gmx.de|t-online.de|yahoo.com|hotmail.com|gmail.com','(.*)','ConfigMakeRe',
  'This prevents specific domains from limiting. For example: yahoo.com|hotmail.*.com|gmail.com<br /><hr />
  <div class="cfgnotes">Notes On IP Blocking</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/ipblocking.txt\',3);" />',undef,undef,'msg002130','msg002131'],

[0,0,0,'heading','SenderBase and WhoisIP <a href="http://www.TalosIntelligence.com/" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="SenderBase" /></a>'],
['sbTestMode','SenderBase Testmode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg002140','msg002141'],
['enableWhois','Use Whois Queries instead or after or before of SenderBase Queries','0:disabled|1:WHOIS only|2:SenderBase first|3:WHOIS first',\&listbox,0,'(.*)',undef,'
  If enabled, WHOIS queries to IP-Whois-Servers<br /><br />
	"ARIN" => "whois.arin.net" - (which will possible redirect to)<br /><br />
	"RIPE" => "whois.ripe.net"<br />
	"APNIC" => "whois.apnic.net"<br />
	"KRNIC" => "whois.krnic.net"<br />
	"LACNIC" => "whois.lacnic.net"<br />
	"AFRINIC" => "whois.afrinic.net"<br /><br />
  will be done instead/after/before (WHOIS only/SenderBase first/WHOIS first) the Senderbase queries to CISCO\'s Ironport servers to get informations about an IP address. ARIN will be the first queried WHOIS server.<br />
  For the two \'...first\' options, the alternative second check is done, if the first check fails or assp has got no result for the county code.<br />
  This is useful, if your DNS-servers don\'t get answers for senderbase queries or senderbase queries are too slow.<br />
  In most cases WHOIS queries are much more faster than senderbase queries!<br />
  NOTICE: you must open the WHOIS-port (43) for TCP on your firewall for outgoing traffic from assp (if not already done)!',undef,undef,'msg010270','msg010271'],
['DoOrgWhiting','Do Organization Whiting','0:disabled|1:whiting|2:monitor|3:score',\&listbox,1,'(.*)',undef,
  'If activated, each sending IP address has its assigned organization looked up. Scoring is set with sworgValencePB.',undef,undef,'msg002150','msg002151'],
['whiteSenderBase','Whitelisted Organizations, Domains and Hosts in SenderBase**',80,\&textinput,'file:files/whiteorg.txt','(.*)','ConfigCompileRe',
 'If the organization, domain or hostname in the <a href="http://www.TalosIntelligence.com/" rel="external">SenderBase</a> IP description matches this Perl regular expression, the message will be considered non-spam. For example file:files/whiteorg.txt<br />
  NOTICE: If only the hostname matches an entry and DoOrgWhiting is set to "whiting", the domain+organization pair will not be added to the white organizations!<br />
  <input type="button" value=" edit White-Org-List" onclick="javascript:popFileEditor(\'DB-WhiteOrgList\',\'1h\');" />',undef,undef,'msg002160','msg002161'],
['DoOrgBlocking','Do Organization Blocking','0:disabled|1:block|2:monitor|3:score',\&listbox,2,'(.*)',undef,
 'If activated, each sending IP address has its assigned organization looked up. Scoring is set with sborgValencePB, Testmode is set with sbTestMode.',undef,undef,'msg002170','msg002171'],
['blackSenderBase','Blacklisted Organizations, Domains and Hosts in SenderBase**',80,\&textinput,'','(.*)','ConfigCompileRe',
 'If the organization, domain or hostname in the <a href="http://www.TalosIntelligence.com/" rel="external">SenderBase</a> IP description matches this Perl regular expression, the message will be considered spam.',undef,undef,'msg002180','msg002181'],
['DoCountryBlocking','Do Country Blocking','0:disabled|1:block|2:monitor|3:score',\&listbox,2,'(.*)',undef,
 'If activated, each sending IP address has its assigned country looked up.',undef,undef,'msg002190','msg002191'],

['CountryCodeBlockedRe','Blocked Country Codes**',80,\&textinput,'CN|KR|RU|JP|TR|TH|PL|LT|CL|RO|UA|GR|HU|SA|IN|GB|IE|PT|MD|PE|CZ|TW|BR|CL','(.*)','ConfigCompileRe',
  'Messages from IP\'s based in these countries will be blocked. For example: CN|KR|RU|JP|TR|TH|PL|LT|CL|RO|UA|GR|HU|SA|IN|IE|PT|MD|PE|CZ|TW|BR|CL. "all" will block all foreign countrycodes which are not in \'Suspicious Country Codes\' or \'Ignore Country Codes\'. See: <a href="http://www.iso.org/iso/country_codes/iso_3166_code_lists/english_country_names_and_code_elements.htm" rel="external">English country names and code elements</a>. ',undef,undef,'msg002200','msg002201'],
['DoSenderBase','Do Country Code Scoring','0:disabled|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'If activated, each sending IP address has its assigned country looked up.',undef,undef,'msg002210','msg002211'],

['NoCountryCodeRe','Ignore Countries*',80,\&textinput,'US|CA|DE','(.*)','ConfigCompileRe',
  'Messages from IP\'s based in these countries will be ignored. For example: US|CA|DE',undef,undef,'msg002220','msg002221'],
['CountryCodeRe','Suspicious Country Codes**',80,\&textinput,'CN|KR|RU|JP|TR|TH|PL|LT|CL|RO|UA|GR|HU|SA|IN|IE|PT|MD|PE|CZ|TW|BR|CL|ID|PH','(.*)','ConfigCompileRe',
  'Messages from IP\'s based in these countries will increase the MessageScore by sbsccValencePB . For example: CN|KR|RU|JP|TR|TH|PL|LT|CL|RO|UA|GR|HU|SA|IN|IE|PT|MD|PE|CZ|TW|BR|CL|ID|PH',undef,undef,'msg002230','msg002231'],
['MyCountryCodeRe','Home Country Codes**',80,\&textinput,'','(.*)','ConfigCompileRe',
  'Put here your own country code(s) (for example: US). Messages from IP\'s based in these countries will decrease by sbhccValencePB , messages from other countries will increase the MessageScore by sbfccValencePB (if ScoreForeignCountries is enabled).',undef,undef,'msg002240','msg002241'],
['ScoreForeignCountries','Score Foreign Countries',0,\&checkbox,'1','(.*)',undef,
  'Messages from foreign countries will increase the total messageScore using sbfccValencePB.',undef,undef,'msg002250','msg002251'],
['SBCacheExp','Country Cache Refresh Interval',4,\&textinput,3,'(\d+\.?\d*|)','configUpdateSBCR',
  'IP\'s in cache will be removed after this interval in days. 0 will disable the cache.  <input type="button" value=" show cache" onclick="javascript:popFileEditor(\''.$newDB.'pb/pbdb.sb.db\',5);" />',undef,undef,'msg002260','msg002261'],

[0,0,0,'heading','PenaltyBox - Message and IP Scoring <a href="https://sourceforge.net/p/assp/wiki/Penalty_Box" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="PenaltyBox" /></a>'],
['DoPenalty','Do PenaltyBox - IP History<a href="https://sourceforge.net/p/assp/wiki/Penalty_Box" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a>','0:disabled|1:block|2:monitor/messageScoring',\&listbox,2,'(\d*)',undef,'The PenaltyBox is a  temporary position of low esteem awarded for a perceived misdeed. It scores IP\'s based on some events ( baValencePB see  penalty scores )and writes them into a BlackBox (PBBlack). If the score per specified time interval surpasses the threshold the message is rejected (and the IP is marked for blocking). They continue to get scored  up to the Extreme Threshold.<br />
 These top performers can get a special treatment PenaltyExtreme when DoPenaltyExtreme is enabled. The WhiteBox (PBWhite) stores IP\'s which should not be put into the BlackBox (PBBlack). The WhiteBox is always enabled. If an address is in the whitelist or whitedomain, the IP goes into the WhiteBox. The WhiteBox is one of the sources  Delaying/Greylisting uses to determine when delaying should not be done. <br />
 Entries in <i>Don\'t do penalties for these IP\'s</i> or <i>ISP/Secondary MX Servers</i> will prevent from penalties (also: whitelisted and noprocessing). Select \'monitor/messageScoring\' to fill WhiteBox (PBWhite) and BlackBox (PBBlack). \'monitor/messageScoring\' is also the right choice if you do not want to block IP\'s but rather score a message in \'Message Scoring Mode\'.<br />
 <input type="button" value=" Show BlackBox" onclick="javascript:popFileEditor(\''.$newDB.'pb/pbdb.black.db\',4);" /><input type="button" value="Show White Box" onclick="javascript:popFileEditor(\''.$newDB.'pb/pbdb.white.db\',4);" />',undef,undef,'msg002270','msg002271'],
['DoPenaltyMessage','Message Scoring Mode ','0:disabled|1:block|2:monitor|4:tagging',\&listbox,1,'(\d*)',undef,'If this feature is selected, the total score for all processed checks during an incoming message is used to determine if the email is Spam. If the combined score is greater than the <b>Low MessageLimit</b> (PenaltyMessageLow) and less than or equal the <b>High MessageLimit</b> (PenaltyMessageLimit) the message will not be blocked but tagged. If the combined score is greater than the <b>High MessageLimit</b> (PenaltyMessageLimit), the message will be blocked.<br />
 Notice: The message score is checked (and the configured action takes place) regardless of any flag which was or was not set for a mail (like noprocessing, whitelisted ...).',undef,undef,'msg002280','msg002281'],
['DoLocalPenaltyMessage','Message Scoring Mode for Local and Outgoing Mails','0:disabled|1:block|2:monitor|4:tagging',\&listbox,0,'(\d*)',undef,'If this feature is selected, the total score for all checks during a local or outgoing message is used to determine if the email is Spam. If the combined score is greater than the <b>Local Low MessageLimit</b> (LocalPenaltyMessageLow) and less than or equal the <b>Local High MessageLimit</b> (LocalPenaltyMessageLimit) the message will not be blocked but tagged. If the combined score is greater than the <b>Local High MessageLimit</b> (LocalPenaltyMessageLimit), the message will be blocked.<br />
 Notice: The message score for local and outgoing mails is checked (and the configured action takes place) regardless of any flag which was or was not set for a mail (like noprocessing, whitelisted ...).',undef,undef,'msg010330','msg010331'],
['MsgScoreOnEnd','Message Scoring on End',0,\&checkbox,1,'(.*)',undef,'ASSP will wait using the \'DoPenaltyMessage\' action, until all configured possible checks are finished. Use this, to force calculating a complete message score over all values, including all bonus values.',undef,undef,'msg002290','msg002291'],
['PenaltyMessageLow','Low MessageLimit',3,\&textinput,40,'(\d*)',undef,'MessageMode will not block messages whose score exceeds this threshold during the message but will tag them.  For example: 40',undef,undef,'msg002300','msg002301'],
['LocalPenaltyMessageLow','Low MessageLimit for Local and Outgoing Mails',3,\&textinput,40,'(\d*)',undef,'MessageMode will not block local and outgoing messages whose score exceeds this threshold during the message but will tag them.  For example: 40',undef,undef,'msg010340','msg010341'],
['PenaltyMessageLimit','High MessageLimit',3,\&textinput,50,'(\d*)',undef,'MessageMode will block messages whose score exceeds this threshold during the message.  For example: 50',undef,undef,'msg002310','msg002311'],
['LocalPenaltyMessageLimit','High MessageLimit for Local and Outgoing Mails',3,\&textinput,50,'(\d*)',undef,'MessageMode will block local and outgoing messages whose score exceeds this threshold during the message.  For example: 50',undef,undef,'msg010350','msg010351'],
['AddScoringHeader','Add IP/Message Scoring Header',0,\&checkbox,1,'(.*)',undef,'Adds a line to the email header "X-Assp-XXX-Score: ", where XXX may be IP, Message or both.',undef,undef,'msg002320','msg002321'],
['noPB','Don\'t do Profiling for these IP\'s*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
 'Enter IP\'s that you don\'t want to be penalized. These IP\'s will also be automatically removed from BlackBox (PBBlack). For example: 127.0.0.1|172.16.',undef,'7','msg002340','msg002341'],
['noPBwhite','Don\'t do WhiteBox for these IP\'s*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
 'Enter IP\'s that you want to be penalized. These IP\'s will also be automatically removed from WhiteBox (PBWhite).',undef,'7','msg002350','msg002351'],
['WhiteExpiration','Expiration Time for WhiteBox Entries',4,\&textinput,30,'(\d?\d?\d?\d?)',undef,
  "The WhiteBox (PBWhite) is always activated. The WhiteBox (PBWhite) is similar to the  Whitelist  - but it is not a whitelist: content-related checks like Bayesian, URIBL, Bomb  will be done, IP-related checks will be skipped. WhiteBox (PBWhite) entries will expire after this specified number of days. For example: 30",undef,undef,'msg002360','msg002361'],
['DoDamping','Do Damping on Messagescore [0...99]',4,\&textinput,'5','(\d{1,2})',undef,'If DoPenalty and DoPenaltyMessage are set not to disabled and DoDamping is not set to 0, ASSP will slowdown the spammers traffic speed proportional to the current message score - because slowing down their speed will reduce spam everywhere.<br />
  The delay in seconds per receive/read cycle is calculated by the division [messagescore / DoDamping] . A recommended value is 5 (default is 0). In this case the delay for a message score of 50 would be 10 seconds.<br />
  Do not use this option, if you have a highly frequented system, because the spammers connections will stay possibly a long time on your system, and you system could possibly reach the sessions limit ( maxSMTPSessions ).<br />
  Damping is never done for: noprocessing, whitelisted, nodelay, ISP, redlisted, noPB, outgoing/releayed and contentonly addresses, IP\'s, messages.<br />
  Damping may not be done for forced checks, relay attemps, messages reaching maxerrors, spamtrapaddresses and if any block condition is found - because ASSP will no more read from those connections and closes such connections immediately - but ASSP will try to keep the connection open for the calculated time, before it closes the connection.<br />
  Using this option or using a too low value (long delay) could possibly prevent ASSP from receiving spam messages, for example for spamlovers or sendAllSpam . Some Servers could give up sending data, because of too long delays.',undef,undef,'msg002370','msg002371'],
['maxDampingTime','Max time Used for Damping',4,\&textinput,30,'(\d?\d?\d?)',undef,
  'The maximum time in second, that is used for one damping cycle if DoDamping is not set to 0, even if the calculated value caused by DoDamping is higher. For example: 30',undef,undef,'msg002380','msg002381'],
['spamtrapaddresses','PenaltyBox Trap Addresses *',80,\&textinput,'put|your@penaltytrap.com|addresses|@here.org','(.*)','ConfigMakeSLRe',
  'Mail to any of these addresses will be blocked and the scoring value is added. Whitelist and noPenaltyMakeTraps will be ignored. Nothing will be stored in the Spam Collection, if these addresses are not checked for validity. TO: and CC: addresses will be also checked - BCC: addresses only, if \'removeForeignBCC\' is not set. If you want to use these addresses as permanent honeypot addresses (with collection), it is better to define them in spamaddresses and to enable DoNotBlockCollect . Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).',undef,undef,'msg002390','msg002391'],
['PenaltyTrapPolite','PenaltyTrap Reply',80,\&textinput,'550 5.1.1 User unknown: EMAILADDRESS','^([542]\d\d .+)',undef,'SMTP reply for invalid Users. Default: \'550 5.1.1 User unknown: EMAILADDRESS\' <br />
 The literal EMAILADDRESS (case sensitive) is replaced by the fully qualified SMTP recipient (e.g., thisuser@example.com).',undef,undef,'msg002400','msg002401'],
['DoPenaltyMakeTraps','Do Heavy Used Invalid Addresses as PenaltyBox Trap Addresses','0:disabled|1:make traps and block them|2:make traps, only collect them|3:do not make them but block',\&listbox,2,'(.*)',undef,
  'If set to \'make traps, only collect them\', the frequency of Invalid Addresses is stored, no other action taken. If set to \'do not make them but block\' or \'make traps and block them\', addresses in heavy use will act like spamtrapaddresses (PenaltyBox Trap Addresses). If UseTrapToCollect is also set they will work like spamaddresses and collect the mails.',undef,undef,'msg002410','msg002411'],
['PenaltyMakeTraps','Invalid Addresses Limit',3,\&textinput,'10','(\d*)',undef,
  'Minimum number of times an address must appear before it will be used as Trap. For example 10.',undef,undef,'msg002420','msg002421'],

['noPenaltyMakeTraps','Exceptionlist for Traps*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Addresses which should not be used for traps. This list is also opponent to spamtrapaddresses . Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).',undef,undef,'msg002430','msg002431'],
['PBTrapInterval','Invalid Addresses Refresh Interval',4,\&textinput,3,'(\d+\.?\d*|)',undef,
  'Addresses will be removed after this interval in days. For example 3. <input type="button" value=" Show Invalid Addresses" onclick="javascript:popFileEditor(\''.$newDB.'pb/pbdb.trap.db\',5);" />',undef,undef,'msg002440','msg002441'],
['PenaltyUseNetblocks','Use IP Netblocks',0,\&checkbox,'1','(.*)',undef,
  'Perform the IP address checks of the sending host based on the /24 (IPv4) - /64 (IPv6) subnet rather than on the specific IP.',undef,undef,'msg002450','msg002451'],
['PenaltyError','Penalty Reply',80,\&textinput,'554 5.7.1 Error for IP IPCONNECTED, send your mail to postmaster@LOCALDOMAIN to ensure delivery','^([245]\d\d .*|)$',undef,
  'If set SMTP reply for Penalty Deny. eg: \'554 5.7.1 Error for IPCONNECTED, send your mail to postmaster@LOCALDOMAIN to ensure delivery\'. The literal LOCALDOMAIN will be replaced by the recipient domain. The literal LOCALUSER will be replaced by the recipient user part. For example:554 5.7.1 Mail appears to be unsolicited -- send error reports to postmaster@LOCALDOMAIN.',undef,undef,'msg002460','msg002461'],
['PenaltyDuration','Penalty Interval',4,\&textinput,60,'(\d?\d?\d?\d?)','updatePenaltyDuration',
  'IP\'s will be kept in the BlackBox (PBBlack) if their score exceeds the Penalty Limit during this interval (minutes).',undef,undef,'msg002470','msg002471'],
['PenaltyLimit','Penalty Limit',4,\&textinput,50,'(\d*)',undef,
  'PB will block IP\'s whose score exceeds this threshold during the Penalty Interval. <br />
  Successful ASSP checks will increase the internal score per IP. For example: 50',undef,undef,'msg002480','msg002481'],
['PenaltyExpiration','Expiration Time',4,\&textinput,360,'(\d?\d?\d?\d?)','updatePenaltyExpiration',
  'Penalties will expire after this number of minutes after the first creation of the PenaltyBox record. If set to zero the Penalty BlackBox (PBBlack) will be deleted and started from scratch.',undef,undef,'msg002490','msg002491'],
['CleanPBInterval','Clean Up PB Databases <sup>s</sup>',40,\&textinput,3,$ScheduleGUIRe,'configChangeSched',
  'Delete outdated entries from blackbox (PBBlack) and whitebox (PBWhite) databases every this many hours.<br />
  Defaults to 3 hours.',undef,undef,'msg002500','msg002501'],
['DoPenaltyExtreme','PenaltyBox Extreme IP Profiling','0:disabled|1:block|2:monitor',\&listbox,0,'(\d*)',undef,'If set PBextreme will block IP\'s whose score meet or exceed Extreme Scoring Threshold. DoPenaltyExtreme blocks after the header is done, based on the IP\'s score from previous and current SMTP session',undef,undef,'msg002510','msg002511'],
['DoPenaltyExtremeSMTP','Enforce Early PenaltyBox Extreme IP Profiling','0:disabled|1:block|2:monitor',\&listbox,0,'(.*)',undef,
  'If set PBextreme will block IP\'s whose score meet or exceed Extreme Scoring Threshold before DELAYING, based on the IP\'s score from previous SMTP sessions. This can be set independently from DoPenaltyExtreme above. Whitelist, Collecting, Testmode, CopySpam, Spam-Lover is ignored.',undef,undef,'msg002520','msg002521'],

['noExtremePB','Don\'t do Extreme Profiling for these IP\'s*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
 'Enter IP\'s that you don\'t want to be extreme penalized. IP\'s in noPB are already included. For example: 127.0.0.1|172.16.',undef,'7','msg009280','msg009281'],
['noExtremePBAddresses','Don\'t do Extreme Profiling for Mails from any of these Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Mails from any of these addresses will not be extreme profiled if DoPenaltyExtremeSMTP is not set. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).  Wildcards are supported (fribo*@domain.com).',undef,undef,'msg009290','msg009291'],
['PenaltyExtreme','Extreme Scoring Threshold',4,\&textinput,150,'(\d*)',undef,
  'PBextreme will use this to determine candidates for special treatment. For example: 150.',undef,undef,'msg002530','msg002531'],
['ExtremeWL','Penalize Whitelisted',0,\&checkbox,'','(.*)',undef,
  'Enable extreme penalties for whitelisted addresses.',undef,undef,'msg002540','msg002541'],
['ExtremeNP','Penalize NonProcessing',0,\&checkbox,'','(.*)',undef,
  'Enable extreme penalties for addresses on the noProcessing list.',undef,undef,'msg002550','msg002551'],
['ExtremeExpiration','Expiration Time for Extreme Penalties',4,\&textinput,7,'(\d?\d?\d?\d?)',undef,,
  "Extreme penalties will expire after this number of days. For example: 7",undef,undef,'msg002560','msg002561'],
['DoExtremeExport','Do Export Penalty BlackBox Extreme',0,\&checkbox,'','(.*)',undef,  '',undef,undef,'msg002570','msg002571'],
['DoExtremeExportAppend','Append Export File',0,\&checkbox,'','(.*)',undef,'Do not overwrite the export file but append to it.',undef,undef,'msg002580','msg002581'],
['exportInterval','Export BlackBox Extreme File Interval <sup>s</sup>',40,\&textinput,6,$ScheduleGUIRe,'configChangeSched',
  ' Exported Penalty Black Box Extreme File every this hours.<br />
  Defaults to 6 hours.',undef,undef,'msg002590','msg002591'],
['exportExtremeBlack','Exported BlackBox Extreme File ',40,\&textinput,'file:files/exportedextreme.txt','(file:\S+|)',undef, 'IP\'s in Penalty BlackBox (PBBlack) which surpassed the extreme level will be regularly stored into this file. This file may be used for setting the firewall or similar applications. The file can be downloaded using the STATS-interface " webStatPort "! The download URL, used by your firewall, should look like: http://assp.domain.local:55553/extremeblack .'  ,undef,undef,'msg002600','msg002601'],
['DoNotPenalizeRed','Do Not Score IP\'s in Redlisted Messages',0,\&checkbox,'','(.*)',undef,
  'IP\'s matching Red Regex or Redlist will not collect scoring values from PenaltyBox.',undef,undef,'msg002610','msg002611'],
['DoNotPenalizeNull','Do Not Score IP\'s From Bounce/Null-Senders',0,\&checkbox,'','(.*)',undef,
  'IP\'s matching BounceSenders will not be IP-penalized.<hr>',undef,undef,'msg002620','msg002621'],

['autValencePB','Bad SMTP Authentication, default=60 +',10,\&textinput,60,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring<br />
 <hr>This option and all other *ValencePB options with a "+" at the end of the description, accepts a second comma or pipe separated value like: "20,10" .<br />
  In this case the first value is used for message scoring and the second value is used for IP scoring.<br />
  If only the first value is defined, this value is used for both scoring mechanism.<br />
  If a *ValencePB option is related to any feature which allowes the usage of weighted penalties, the message scoring value is used to calculate the weighted penalty and the result is used calculating (result * ipscorevalence / messagescorevalence ) for IP scoring.','Basic',undef,'msg009300','msg009301'],
['baValencePB','Bad Attachment, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002630','msg002631'],
['backsctrValencePB','Backscatter detection, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message scoring',undef,undef,'msg002640','msg002641'],
['baysValencePB','Bayesian, default=49 +',10,\&textinput,49,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002650','msg002651'],
['bayslocalValencePB','Bayesian for Local Messages, default=55 +',10,\&textinput,55,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg009550','msg009551'],
['bayshamValencePB','Bayesian HAM Bonus, default=0 +',10,\&textinput,0,$ValencePB2RE,'ConfigChangeValencePB', '<span class="positive">Message/IP scoring bonus (zero or negative value only)</span>',undef,undef,'msg010290','msg010291'],
['HMMValencePB','Hidden-Makov-Model, default=49 +',10,\&textinput,49,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg009640','msg009641'],
['HMMlocalValencePB','Hidden-Makov-Model for Local Messages, default=55 +',10,\&textinput,55,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg009650','msg009651'],
['HMMhamValencePB','Hidden-Makov-Model HAM Bonus, default=0 +',10,\&textinput,0,$ValencePB2RE,'ConfigChangeValencePB', '<span class="positive">Message/IP scoring bonus (zero or negative value only)</span>',undef,undef,'msg010300','msg010301'],
['blValencePB','Blacklisted Domain, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002660','msg002661'],
['bombSuspiciousValencePB','Bomb Suspicious - scoring only, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message scoring',undef,undef,'msg002670','msg002671'],
['bombValencePB','Bomb Expression, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002680','msg002681'],
['blackValencePB','Bomb Black Expression, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002690','msg002691'],
['dmarcValencePB','DMARC Failed, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg010740','msg010741'],
['dkimValencePB','Domain Key Verification failed, default=15 +',10,\&textinput,15,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002700','msg002701'],
['dkimOkValencePB','Domain Key Verification OK, default=0',3,\&textinput,0,'(-{0,1}\d*)','ConfigChangeValencePB', '<span class="positive">Message Scoring Bonus</span>',undef,undef,'msg002710','msg002711'],
['erValencePB','Empty Recipients, default=5 +',10,\&textinput,5,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002720','msg002721'],
['etValencePB','Early Talker Scoring, default=25 +',10,\&textinput,25,$ValencePBRE,'ConfigChangeValencePB', "Message/IP scoring for clients who talk before server's greeting is sent. A value of zero will disable this check - otherwise assp scores the IP and droppes the connection.",undef,undef,'msg002730','msg002731'],
['fhValencePB','Forged HELO, default=150 +',10,\&textinput,150,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002740','msg002741'],
['fiphValencePB','Suspicious HELO: IP in HELO, default=39 +',10,\&textinput,39,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002750','msg002751'],
['fiphmValencePB','Suspicious HELO: IP in HELO mismatch, default=60 +',10,\&textinput,60,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002760','msg002761'],
['flValencePB','Invalid Local Sender, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002770','msg002771'],
['slValencePB','Spoofed Local Sender, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg010500','msg010501'],
['hlValencePB','Blacklisted/Good HELO, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002780','msg002781'],
['iaValencePB','Internal Only Address, default=25 +',10,\&textinput,25,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002790','msg002791'],
['idValencePB','Domain Changing IP Frequency, default=150 +',10,\&textinput,150,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002800','msg002801'],
['ifValencePB','IP Frequency, default=150 +',10,\&textinput,150,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002810','msg002811'],
['idleValencePB','Timeout Score',3,\&textinput,0,'(\d+)','ConfigChangeValencePB', 'For IP scoring with smtpIdleTimeout.',undef,undef,'msg008870','msg008871'],
['iplValencePB','IP Parallel Sessions, default=5 +',10,\&textinput,5,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002820','msg002821'],
['ihValencePB','Invalid HELO, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002830','msg002831'],
['irValencePB','Invalid Recipient, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg008940','msg008941'],
['isValencePB','Subject Frequency, default=150 +',10,\&textinput,150,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg010030','msg010031'],
['mdrValencePB','Duplicate Recipient, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002840','msg002841'],
['midmValencePB','Missing Message-ID, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002850','msg002851'],
['midsValencePB','Suspicious Message-ID, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002860','msg002861'],
['midiValencePB','Invalid Message-ID, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002870','msg002871'],
['fbmtvValencePB','Invalid FBMTV check, default=25 +',10,\&textinput,25,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002880','msg002881'],
['batvValencePB','Invalid BATV check, default=25 +',10,\&textinput,25,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002890','msg002891'],
['meValencePB','Max Errors Exceeded, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002900','msg002901'],
['msValencePB','Message Scoring Limit Exceeded, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'IP scoring',undef,undef,'msg002910','msg002911'],
['mxValencePB','Missing MX, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002920','msg002921'],
['mxaValencePB','Missing A Record for MX, default=15 +',10,\&textinput,15,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg002930','msg002931'],
['nofromValencePB','No From Score, default=50 +',10,\&textinput,50,$ValencePBRE,'ConfigChangeValencePB','For Message/IP scoring in DoNoFrom and malformed sender and Reply addresses in the header.',undef,undef,'msg002940','msg002941'],
['pbeValencePB','Extreme Bad IP History, TotalScore larger than PenaltyExtreme, default=25',3,\&textinput,25,'(\d+)','ConfigChangeValencePB', 'Message Scoring',undef,undef,'msg002950','msg002951'],
['pbValencePB','Bad IP History, TotalScore larger than PenaltyLimit, default=15',3,\&textinput,15,'(\d+)','ConfigChangeValencePB', 'Message Scoring',undef,undef,'msg002960','msg002961'],
['pbwValencePB','Good IP History (IP in PB WhiteBox), default=-15',3,\&textinput,-15,'(-{0,1}\d*)','ConfigChangeValencePB', '<span class="positive">Message Scoring Bonus</span>',undef,undef,'msg002970','msg002971'],
['gripValencePB','GRIP value (+ if &gt; 0.7,- if &lt; 0.3), default=5',3,\&textinput,5,'(\d+)','ConfigChangeValencePB', 'Message scoring<br /><br />
 The resulting message/ip - score is calculated as follows:<br /><br />
 if the grip value is &lt; 0.3 : -int(((0.3 - grip value) / 0.3) * gripValencePB)<br />
 if the grip value is &gt; 0.7 : &nbsp;int(((grip value - 0.7) / 0.3) * gripValencePB)<br />
 griplist values between 0.3 and 0.7 are ignored.',undef,undef,'msg002980','msg002981'],
['okValencePB','Message OK, default=-25',3,\&textinput,-25,'(-?\d*)','ConfigChangeValencePB', '<span class="positive">IP Bonus</span>',undef,undef,'msg002990','msg002991'],
['ptmValencePB','Missing PTR Record, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg003000','msg003001'],
['ptiValencePB','Invalid PTR Record, default=15 +',10,\&textinput,15,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg003010','msg003011'],
['rblnValencePB','DNSBL Neutral, default=35 +',10,\&textinput,35,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003020','msg003021'],
['rblValencePB','DNSBL Failed, default=100 +',10,\&textinput,100,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003030','msg003031'],
['rlValencePB','Failed Relay Attempt, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg003040','msg003041'],
['saValencePB','Spam Collect Address, default=25',3,\&textinput,25,'(\d+)','ConfigChangeValencePB', 'IP scoring',undef,undef,'msg003050','msg003051'],
['scriptValencePB','Script Expression, default=25 +',10,\&textinput,25,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg003060','msg003061'],
['sbnValencePB','No Organization and No CountryCode, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'For Message/IP scoring in DoOrgBlocking/DoCountryBlocking',undef,undef,'msg003070','msg003071'],
['sworgValencePB','White Organizations Score, default=-25',3,\&textinput,-25,'(-\d*)','ConfigChangeValencePB', '<span class="positive"> Bonus for Message/IP scoring in DoOrgWhiting</span>',undef,undef,'msg003080','msg003081'],
['sbsccValencePB','Suspicious Country Code, default=10',3,\&textinput,10,'(\d+)','ConfigChangeValencePB', 'Message scoring',undef,undef,'msg003090','msg003091'],
['bccValencePB','Blocked Country Code Score, default=25 +',10,\&textinput,25,$ValencePBRE,'ConfigChangeValencePB', 'For Message/IP scoring  in PenaltyBox ( DoPenalty )',undef,undef,'msg003100','msg003101'],
['sbfccValencePB','Foreign Country Code Score, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB', 'message scoring  in PenaltyBox ( DoPenaltyMessage )',undef,undef,'msg003110','msg003111'],
['sbhccValencePB','<span class="positive">Home Country Code Score, default=-10</span> +',10,\&textinput,-10,$ValencePB2RE,'ConfigChangeValencePB', '<span class="positive"> Bonus for Message/IP Scoring  in PenaltyBox ( DoPenalty )</span>',undef,undef,'msg003120','msg003121'],
['sborgValencePB','Blocked Organizations Score, default=25 +',10,\&textinput,25,$ValencePBRE,'ConfigChangeValencePB', 'For Message/IP scoring  in PenaltyBox ( DoPenalty )',undef,undef,'msg003130','msg003131'],
['spfpValencePB','SPF Pass Score, default=-10',3,\&textinput,-10,'(-{0,1}\d*)','ConfigChangeValencePB','<span class="positive"> Bonus for Message/IP scoring with SPF</span>',undef,undef,'msg003140','msg003141'],
['spfnValencePB','SPF Neutral, default=5 +',10,\&textinput,5,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003150','msg003151'],
['spfsValencePB','SPF Softfailed, default=5 +',10,\&textinput,5,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003160','msg003161'],
['spfnonValencePB','SPF None, default=0 +',10,\&textinput,0,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003170','msg003171'],
['spfuValencePB','SPF Unknown, default=0 +',10,\&textinput,0,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003180','msg003181'],
['spfeValencePB','SPF Error, default=5 +',10,\&textinput,5,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003190','msg003191'],
['spfValencePB','SPF Failed, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003200','msg003201'],
['srsValencePB','SRS Validate Bounce Failed Score, default=10 +',10,\&textinput,10,$ValencePBRE,'ConfigChangeValencePB','For Message/IP scoring in SRSValidateBounce',undef,undef,'msg003210','msg003211'],
['stValencePB','Penalty Trap Address, default=50 +',10,\&textinput,50,$ValencePBRE,'ConfigChangeValencePB', 'For Message/IP scoring',undef,undef,'msg003220','msg003221'],
['tlsValencePB','OK, Is a SSL/TLS connection, default=0 +',10,\&textinput,0,$ValencePB2RE,'ConfigChangeValencePB', '<span class="positive">Message Scoring/IP scoring Bonus for SSL/TLS connections</span>',undef,undef,'msg003230','msg003231'],
['uriblnValencePB','URIBL Neutral, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003240','msg003241'],
['uriblValencePB','URIBL Failed, default=25 +',10,\&textinput,25,$ValencePBRE,'ConfigChangeValencePB','Message/IP scoring',undef,undef,'msg003250','msg003251'],
['vsValencePB','Virus suspicious, default=25',3,\&textinput,25,'(\d+)','ConfigChangeValencePB','Message scoring',undef,undef,'msg003260','msg003261'],
['vdValencePB','Virus detected, default=50 +',10,\&textinput,50,$ValencePBRE,'ConfigChangeValencePB', 'Message/IP scoring',undef,undef,'msg003270','msg003271'],
['teValencePB','TestRe Valence, default=20 +',10,\&textinput,20,$ValencePBRE,'ConfigChangeValencePB', 'Valence for testing testRe<br /><hr />
  <div class="cfgnotes">Notes On Penalty Box</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/penaltybox.txt\',3);" />',undef,undef,'msg008710','msg008711'],

[0,0,0,'heading','Delaying - Greylisting <a href="https://sourceforge.net/p/assp/wiki/Delaying/Greylisting" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Delaying" /></a>'],
['EnableDelaying','Enable Delaying/Greylisting',0,\&checkbox,1,'(.*)',undef,
  'Enable Greylisting (also called Delaying) as described at <a href="http://projects.puremagic.com/greylisting/whitepaper.html?view=markup" rel="external">Greylisting-whitepaper</a>.<br />
  It\'s a new method of blocking significant amounts of spam at the mailserver level, but without resorting to heavyweight statistical analysis or other heuristical approaches.',undef,undef,'msg003280','msg003281'],
['DelayWL','Whitelisted Greylisting',0,\&checkbox,'','(.*)',undef,
  'Enable Greylisting for whitelisted mails. This also enables Geylisting for SPF-Cache-OK listed IP\'s and mails from white organizations, which are normally not greylisted.',undef,undef,'msg003290','msg003291'],
['DelayNP','NoProcessing Greylisting',0,\&checkbox,'','(.*)',undef,
  'Enable Greylisting for noprocessing mails.',undef,undef,'msg003300','msg003301'],
['DelaySL','Spam-Lovers Greylisting',0,\&checkbox,'','(.*)',undef,
  'Enable Greylisting for Spam-Lovers.',undef,undef,'msg003310','msg003311'],
['DelayAddHeader','Add X-Assp-Delayed Header',0,\&checkbox,1,'(.*)',undef,
  'Add X-Assp-Delayed header to header of all delayed or whitelisted mails.',undef,undef,'msg003320','msg003321'],
['DelayEmbargoTime','Embargo Time',5,\&textinput,5,'(\d+)',undef,
  'Enter the number of minutes for which delivery, related with new \'triplet\' (IP address of the sending<br />
  host + mail from + rcpt to), is refused with a temporary failure. Default is 5 minutes.',undef,undef,'msg003330','msg003331'],
['DelayWaitTime','Wait Time',5,\&textinput,28,'(\d+)',undef,
  'Enter the number of hours to wait for delivery attempts related with recognized \'triplet\'; delivery is accepted <br />
  immediately and the \'tuplet\' (IP address of the sending host + sender\'s domain) is safelisted. Default is 28 hours.',undef,undef,'msg003340','msg003341'],
['DelayExpiryTime','Expiry Time',5,\&textinput,36,'(\d+)',undef,
  'Enter the number of days for which whitelisted \'tuplet\' is considered valid. Default is 36 days.',undef,undef,'msg003350','msg003351'],
['DelayUseNetblocks','Use IP Netblocks',0,\&checkbox,1,'(.*)',undef,
  'Perform the IP address checks of the sending host based on the /24 (IPv4) - /64 (IPv6) subnet it is rather than the specific IP. <br />
  In case the sending domain provides a SPF-record and the connected IP-address matches this SPF-record, the "SPF:" tagged sender domain is used for delaying (tuplets,triplets) instead of the connected IP-address or network. So, each other server from the domains SPF-range will be processed equal ways for the next connection.<br />
  This feature may be useful for legitimate mail systems that shuffle messages among SMTP clients between retransmissions.',undef,undef,'msg003360','msg003361'],
['DelayNormalizeVERPs','Normalize VERP Addresses',0,\&checkbox,1,'(.*)',undef,
  'Some mailing lists (such as Ezmlm) try to track bounces to individual mails, rather than just individual recipients, which creates a variation on the VERP method where each email has its own unique envelope sender. Since the automatic whitelisting (called savelisting to make a difference to the standard whitelisting) that is built into Greylisting depends on the envelope addresses for subsequent mails being the same, the greylisting filter will attempt to normalize the unique sender addresses, when this option is checked.',undef,undef,'msg003370','msg003371'],
['DelayWithMyName','Add myName to Triplets',0,\&checkbox,0,'(.*)',undef,
  'If set, myName is added to every delay triplet (not to tuplets). This is useful and recommended, if you are using more than one ASSP host with shared databases for delaydb. This option makes the triplets unique to every ASSP host, because it is allowed for SMTP-hosts, to request a backup MX immediately after the primary MX, without waiting 5 minutes (DelayEmbargoTime) between the two requests.',undef,undef,'msg003380','msg003381'],
['DelayMD5','Use MD5 for DelayDB',0,\&checkbox,'1','(.*)',undef,
  'Message-Digest algorithm 5 is a cryptographic hash function and adds some level of security to the delay database. Must be set to off if you want to list the database with DelayShowDB/DelayShowDBwhite. This requires an installed <a href="http://metacpan.org/search?q=Digest::MD5" rel="external">Digest::MD5</a> module in PERL.',undef,undef,'msg003390','msg003391'],
['DelayShowDB','Show Delay/Greylisting Database',40,\&textinput,'file:delaydb','(\S*)',undef,'The directory/file with the delay database file. If you change the filename in section Filepath ( delaydb ) you must change it here too.',undef,'8','msg003400','msg003401'],
['DelayShowDBwhite','Show Delay/Greylisting Save Database',40,\&textinput,'file:delaydb.white','(\S*)',undef,'The directory/file with the save delay database file. If you change the filename in section Filepath ( delaydb )  you must change it here too.',undef,'8','msg003410','msg003411'],
['DelayExpireOnSpam','Expire Spamming Safelisted Tuplets',0,\&checkbox,1,'(.*)',undef,
  'If a safelisted \'tuplet\' is ever associated with spam, viruses, failed rbl, spf etc, it is deleted from the safelist. <br />
  This renews the temporary embargo for subsequent mail involving the tuplet.',undef,undef,'msg003420','msg003421'],
['CleanDelayDBInterval','Clean Up Delaying Database <sup>s</sup>',40,\&textinput,10800,$ScheduleGUIRe,'configChangeSched',
  'Delete outdated entries from triplets and safelisted tuplets databases every this many seconds.<br />
  Defaults to 3 hour.',undef,undef,'msg003430','msg003431'],
['noDelay','Don\'t Delay these IPs*',80,\&textinput,'file:files/nodelay.txt','(\S*)','ConfigMakeIPRe',
  'Enter IP addresses that you don\'t want to be delayed, separated by pipes (|). There are misbehaving MTAs that will not be able to get a legitimate email through a Greylisting server because they do not try again later. An INCOMPLETE list of such mailers is available at <a href="http://cvs.puremagic.com/viewcvs/greylisting/schema/whitelist_ip.txt" rel="external">cvs.puremagic.com/viewcvs/Greylisting/schema/whitelist_ip.txt</a>. <br />
  When using mentioned list remember to add trailing dots in IP addresses which specify subnets (eg. 192.168 -> 192.168. ).<br />
  For example:  127.0.0.1|172.16..<br />
  To define IP\'s only for specific email addresses or domains (recipients) you must use the file:... option<br />
  An entry (line) may look as follows:<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment<br /><br />
  It is possible to define a predefined group on any or both sides of the \'=>\' separator, like:<br />
  [ipgroup]=>[usergroup]|user@mydomain<br /><br />
  NOTICE: the following combination of two entries, will lead into a user/domain based matching - the global entry will be ignored!<br />
  145.146.0.0/16 # comment<br />
  145.146.0.0/16=>*@local.domain|user@mydomain|user2@*.mydomain # comment',undef,'7','msg003440','msg003441'],
['noDelayAddresses','Do not Delay these Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe','Enter senders and/or recipient email addresses that you don\'t want to be delayed, separated by pipes (|). You can list specific addresses (user@anydomain.com), addresses at any domain (user), or entire domains (@anydomain.com).  Wildcards are supported (fribo*@domain.com). (|).<br />
  For example: fribo@anydomain.com|jhanna|@sillyguys.org or place them in a plain ASCII file one address per line:file:files/nodelayuser.txt. Groups definitions are also allowed to be used.',undef,undef,'msg008610','msg008611'],
['DelayError','Reply Code to Refuse Delayed Messages',80,\&textinput,'451 4.7.1 Please try again later','(45\d .*)',undef,
  'SMTP reply code to refuse delayed messages. Default: 451 4.7.1 Please try again later
  <br /><hr />
  <div class="cfgnotes">Notes On Delaying</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/delaying.txt\',3);" />',undef,undef,'msg003450','msg003451'],

[0,0,0,'heading','Validate SPF, DMARC and SRS <a href="https://sourceforge.net/p/assp/wiki/SPF" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="SPF" /></a>'],
['ValidateSPF','Enable SPF Validation','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'Enable Sender Policy Framework Validation as described at <a href="http://www.openspf.org/" rel="external">openspf</a> and Domain-based Message Authentication, Reporting &amp; Conformance - described in <a href="http://www.dmarc.org/" rel="external">DMARC</a> (DMARC requires also DoDKIM to be enabled).<br />
  This requires an installed <a href="http://www.openspf.org/Implementations" rel="external">Mail::SPF</a> module in PERL. Testmode is set with spfTestMode, scoring is set with spfValencePB. If you need more information about the syntax of SPF records, visit <a href="http://www.openspf.org/SPF_Record_Syntax" rel="external">SPF_Record_Syntax</a>.',undef,undef,'msg003460','msg003461'],
['SPFWL','Whitelisted SPF Validation',0,\&checkbox,'','(.*)',undef,
  'Enable Sender Policy Framework Validation for whitelisted users also.',undef,undef,'msg003480','msg003481'],
['SPFNP','noProcessing SPF Validation',0,\&checkbox,'','(.*)',undef,
  'Enable Sender Policy Framework Validation for nonprocessed messages also.',undef,undef,'msg009560','msg009561'],
['SPFLocal','Local and outgoing mail SPF Validation',0,\&checkbox,'','(.*)',undef,
  'Enable Sender Policy Framework Validation for local and outgoing messages also. Don\'t forget to configure your DNS-server for SPF and/or to configure SPFoverride / SPFfallback / SPFlocalRecord, if you enable this option.',undef,undef,'msg003490','msg003491'],
['enableSPFbackground','Enable SPF Background Check',0,\&checkbox,'1','(.*)',undef,
 'SPF background checks are initiated by some features (for example DoDomainIP) to fillup the SPFCache. The collected results are later used to prevent blocking good mails.',undef,undef,'msg003500','msg003501'],
['AddSPFHeader','Add Received-SPF Header',0,\&checkbox,1,'(.*)',undef,
  'Add Received-SPF header to header of all mails processed by SPF.',undef,undef,'msg003510','msg003511'],
['SPFError','SPF Failed Reply',80,\&textinput,'554 5.7.1 failed SPF: SPFRESULT','([245]\d\d .*)',undef,
  'SMTP reply for SPF failed messages. Default: \'554 5.7.1 failed SPF: SPFRESULT\'<br />
  The literal SPFRESULT (case sensitive) is replaced by the actual result.',undef,undef,'msg003520','msg003521'],
['noSPFRe','Skip SPF Processing*',80,\&textinput,'','(.*)','ConfigCompileRe',
 'Put anything here to identify these messages in mailfrom or header',undef,undef,'msg003530','msg003531'],
['SPFoverride','Override Domains*',80,\&textinput,'','(.*)','configUpdateSPFOF',
 'Set override to define SPF records for domains that do publish (or not) but which you want to override anyway. If you specify only domains the Local SPF Record ( SPFlocalRecord ) below will be used as default. Wildcards are supported. For example: abc.com=>v=spf1 a/24 mx/24 ptr -all|cello.ch=>v=spf1 ip4:213.46.243.0/26  ~all|abc.com|*.def.com . <br />
 To generate a SPF record for a domain:<br />
 - go to <a href="http://www.TalosIntelligence.com/" rel="external">http://www.TalosIntelligence.com</a><br />
 - lookup the domain information in "Look up your network"<br />
 - right beside "Addresses in domain used to send email" click on export, and export the list into plain text<br />
 - copy and past the list into an editor and generate a comma separated IP list<br />
 - go to an online SPF record generator and generate the SPF record<br />
 - put "domain=>SPF-record" in any of SPFoverride or SPFfallback<br />
 - define the policy as strict as possible',undef,undef,'msg003540','msg003541'],
['SPFfallback','Fallback Domains*',80,\&textinput,'','(.*)','configUpdateSPFOF',
 'Set fallback to define "pretend" SPF records for domains that don\'t publish them yet. If you specify only domains the Local SPF Record ( SPFlocalRecord ) below will be used as default. Wildcards are supported. For example: abc.com=>v=spf1 a/24 mx/24 ptr -all|cello.ch=>v=spf1 ip4:213.46.243.0/26  ~all|abc.com|*.def.com',undef,undef,'msg003550','msg003551'],
['SPFlocalRecord','Fallback/Override SPF Record',80,\&textinput,'v=spf1 a/24 mx/24 ptr -all','(.*)','configUpdateSPFLR','Used in Fallback/Override Domains<br />
 The default is v=spf1 a/24 mx/24 ptr -all',undef,undef,'msg003570','msg003571'],
['strictSPFRe','Strict SPF Processing Regex*',80,\&textinput,'file:files/strictspf.txt','(.*)','ConfigCompileRe',
 'Softfail/Neutral will be failed for these sending addresses. Put anything here to identify the addresses',undef,undef,'msg003580','msg003581'],
['blockstrictSPFRe','Block SPF Processing Regex*',80,\&textinput,'@ebay.com|@paypal.com','(.*)','ConfigCompileRe',
 'All failed messages will be blocked for these sending addresses. Put anything here to identify the addresses.',undef,undef,'msg003590','msg003591'],
['DoSPFinHeader','Additional SPF Check on the Header from',0,\&checkbox,'','(.*)',undef,
  'Do an additional SPF check on the header from: address if it is in blockstrictSPFRe *** this check breaks RFC rules ***.',undef,undef,'msg009820','msg009821'],
['SPFsoftfail','Fail SPF Softfail Validations',0,\&checkbox,'','(.*)',undef,
  'Intentionally fail SPF softfail status responses. The possible results of a query are:
<br />pass:The client IP address is an authorized mailer for the sender. The mail should be accepted subject to local policy regarding the sender.
<br />fail:The client IP address is not an authorized mailer, and the sender wants you to reject the transaction for fear of forgery.
<br />softfail:The client IP address is not an authorized mailer, but the sender prefers that you accept the transaction because it isn\'t absolutely sure all its users are mailing through approved servers. The softfail status is often used during initial deployment of SPF records by a domain.
<br />neutral:The sender makes no assertion about the status of the client IP.
<br />none:There is no SPF record for this domain.
<br />permerror &amp; temperror:The DNS lookup encountered an error during processing.
<br />unknown:The domain has a configuration error in the published data or defines a mechanism that this library does not understand.',undef,undef,'msg003600','msg003601'],
['SPFneutral','Fail SPF Neutral Validations',0,\&checkbox,'','(.*)',undef,
  'Intentionally fail SPF neutral status responses',undef,undef,'msg003610','msg003611'],
['SPFqueryerror','Fail SPF Error Responses',0,\&checkbox,'','(.*)',undef,
  'Intentionally fail SPF \'error\' status responses',undef,undef,'msg003620','msg003621'],
['SPFnone','Fail SPF None and Unknown Responses',0,\&checkbox,'','(.*)',undef,
  'Intentionally fail SPF \'none\' status responses',undef,undef,'msg003630','msg003631'],
['SPFunknown','Fail SPF Unknown  Responses',0,\&checkbox,'','(.*)',undef,
  'Intentionally fail SPF \'unknown\'  status responses',undef,undef,'msg003640','msg003641'],
['SPFCacheInterval','SPF Cache Refresh Interval',4,\&textinput,7,'(\d+\.?\d*|)','configUpdateSPFCR',
  'SPF records in cache will be removed after this interval in days. 0 will disable the cache.<input type="button" value=" Show SPF Cache" onclick="javascript:popFileEditor(\''.$newDB.'pb/pbdb.spf.db\',6);" />',undef,undef,'msg003650','msg003651'],
['DebugSPF','Enable SPF/DNS/Whois/Senderbase Debug output to ASSP Logfile',0,\&checkbox,'','(.*)',undef,
 'Enables verbose debugging of SPF/DNS/Whois/Senderbase queries within the related modules.
 <br /><hr />
 <div class="cfgnotes">Notes On SPF</div>
 <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/spf.txt\',3);" /> ',undef,undef,'msg003660','msg003661'],
['DoDMARC','Enable DMARC Check',0,\&checkbox,'1','(.*)',undef,
  'If enabled and ValidateSPF and DoDKIM are enabled and the sending domain has published a DMARC-record/policy, assp will act on the mail according to the senders DMARC-policy using the results of the SPF and DKIM check and validating the SPF/DKIM address/domain Identifier Alignment rules (<a href="https://tools.ietf.org/html/rfc7489#section-3" rel="external">RFC7489 section 3</a>). It is safe to leave this feature ON, it will not produce false positives! The blocking mode (block, monitor, score, testmode) is adapted from the most less aggressive setting of ValidateSPF and DoDKIM - and the published DMARC record ([p][sp]=[reject][quarantine]). Scoring is done using dmarcValencePB.<br />
  If you have published a DMARC-record and you want to collect statisical data, look at <a href="https://dmarcian.com" rel="external">dmarcian.com</a>',undef,undef,'msg010410','msg010411'],
['noDMARCDomain','Don\'t Check DMARC for these Addresses/Domains*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Put any sender domain (or address) into this list, for which you want to disable the DMARC check - for example if an invalid DMARC record is published.<br />
 Use \'noDMARCReportDomain\' if you only want to disable DMARC reports.<br />
 Accepts entire domains (@example.com) (specific addresses (user@example.com) and user parts (user) are accepted, but not usefull!). Wildcards are supported (@*example.com or @*.example.com).',undef,undef,'msg010530','msg010531'],
['trustedAuthForwarders','Original-Authentication-Results and Authenticated Received Chain(ARC) Trusted Forwarder*',80,\&textinput,'','(.*)','ConfigCompileRe','
 If an email contains a valid DKIM signature and the signature protects the "[X-]Original-Authentication-Results" header line in its h= tag (<a href="https://tools.ietf.org/html/rfc7601" rel="external">RFC7601</a>) and the host in this header line matches this regular expression, DMARC will fully trust the provided original authentication results for SPF, DKIM and DMARC.<br />
 If DoARC is enabled and a host match is found for the most recent <a href="http://arc-spec.org" rel="external">Authenticated-Received-Chain(ARC)-Signature</a> instance (highest instance number), the SPF-check, the DKIM-check and the DMARC-check will fully trust the provided ARC results.<br />
 For example: ^mx\d*\.domain\.com$ or ^2\.2\.2\.2$<br /><br />
 An regular expression for the values of myName and myNameAlso are already added!.',undef,undef,'msg010670','msg010671'],
['DMARCReportFrom','From Address for DMARC Reports',40,\&textinput,'','('.$EmailAdrRe.'(?:\@'.$EmailDomainRe.')?|)',undef,
  'The email address to be used as FROM: address to send <a href="http://www.dmarc.org/" rel="external">DMARC</a> reports. If blank, no DMARC reports will be sent! If only the user name is defined, assp will add the domain name that belongs to the report.',undef,undef,'msg009730','msg009731'],
['noDMARCReportDomain','Don\'t send DMARC reports to these Addresses/Domains*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Put any DMARC report recipient domain or address (ruf/rua) into this list - for example if DMARC reports could be never delivered for any reason.<br />
 If assp receives a NDR (No Delivery Report) for a sent DMARC-Report and the file:... option is configured here, assp will automatically add the dmarc report domain and the dmarc report recipient to this file.<br />
 Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). Wildcards are supported (fribo*@example.com).',undef,undef,'msg010240','msg010241'],
['EnableSRS','Enable Sender Rewriting Scheme',0,\&checkbox,'','(.*)','updateSRS',
  'Enable Sender Rewriting Scheme as described at <a href="http://www.openspf.org/SRS" rel="external">www.openspf.org/SRS</a>.<br />
  This requires an installed <a href="http://www.openspf.org/Implementations" rel="external">Mail::SRS</a> module in PERL. This module is disabled in the configuration per default - first enable it using useMailSRS .<br />
  You should use SRS if your message handling system forwards email for domains with published spf records and their SPF record not includes your MX.<br />
  NOTICE: In case your local users are forwarding mails (e.g. from external domains) to external domains (external mail accounts) and these foreign domains bounces back (e.g. out_of_office / vacation), your MTA (smtpDestination) will possibly get mails from external domains to be delivered to external domains!<br />
  Note that you have to setup the outgoing path (Relay Host and Port) to let ASSP see and rewrite your outgoing traffic.<br />
  Testmode is set with srsTestMode.',undef,undef,'msg003670','msg003671'],
['SRSAliasDomain','Alias Domain',40,\&textinput,'thisdomain.com','(.*)','updateSRSAD',
  'SPF requires the SMTP client IP to match the envelope sender (return-path). When a message is forwarded through<br />
  an intermediate server, that intermediate server may need to rewrite the return-path to remain SPF compliant.<br />
  For example: thisdomain.com',undef,undef,'msg003680','msg003681'],
['SRSSecretKey','Secret Key',20,\&textinput,'','(.*)','updateSRSSK',
  'A key for the cryptographic algorithms -- Must be at least 5 characters long.',undef,undef,'msg003690','msg003691'],
['SRSTimestampMaxAge','Maximum Timestamp Age',5,\&textinput,2,'(\d+)',undef,
  'Enter the maximum number of days for which a timestamp is considered valid. Default is 2 days. After this number of days a SRS bounce is no longer valid!',undef,undef,'msg003700','msg003701'],
['SRSHashLength','Hash Length',5,\&textinput,6,'(\d+)',undef,
  'The number of bytes of base64 encoded data to use for the cryptographic hash.<br />
  More is better, but makes for longer addresses which might exceed the 64 character length suggested by <a href="https://tools.ietf.org/html/rfc2821" rel="external">RFC2821</a>.<br />
  This defaults to 6, which gives 6 x 6 = 36 bits of cryptographic information, which means that a spammer will have <br />
  to make 2^36 attempts to guarantee forging a SRS address.',undef,undef,'msg003710','msg003711'],
['SRSValidateBounce','Enable Bounce Recipient Validation','0:disabled|1:block|2:monitor|3:score',\&listbox,0,'(.*)',undef,
  'Bounce messages that fail reverse SRS validation (but not a valid SMTP probe)<br />
  will receive a 554 5.7.5 [Bounce address not SRS signed] SMTP error code.<br />
  Testmode is set with srsTestMode, scoring is set with srsValencePB.',undef,undef,'msg003720','msg003721'],
['SRSno','Don\'t Rewrite These Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Don\'t rewrite addresses when messages come from these addresses. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). <br />
  For example: fribo@thisdomain.com|jhanna|@sillyguys.org',undef,undef,'msg003730','msg003731'],
['noSRS','Don\'t Validate Bounces From these IPs*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
  'Enter IP addresses that you don\'t want to validate bounces from, separated by pipes (|).
  For example:  127.0.0.1|172.16..<br /><hr />
  <div class="cfgnotes">Notes On SRS</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/srs.txt\',3);" />',undef,'7','msg003740','msg003741'],

[0,0,0,'heading','DNSBL - RBL Validation <a href="https://sourceforge.net/p/assp/wiki/DNSBL" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="DNSBL" /></a>'],
['ValidateRBL','Enable DNS Blacklist Validation For Connected IP Addresses','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(.*)','configUpdateRBL',
  'The connected IP address will be checked for DNSBL hits. If enhancedOriginIPDetect is enabled, additionally DNSBL checks will be done for IP\'s on the mail routing way.<br />
  This requires an installed <a href="http://metacpan.org/search?q=Net::DNS" rel="external">Net::DNS</a> module in PERL.',undef,undef,'msg003750','msg003751'],
['ForceRBLCache','Early DNSBL Cache Blocking',0,\&checkbox,'','(.*)',undef,
  'If set, ASSP will use cached DNSBL hits to block messages before other tests. <b>testmode</b> will override this. <b>spamlover settings</b> will be ignored.',undef,undef,'msg003760','msg003761'],
['noRBL','Don\'t do DNSBL for these IPs*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
 'Enter IP addresses that you don\'t want to be DNSBL validated, separated by pipes (|). For example:  127.0.0.1|172.16..',undef,'7','msg003770','msg003771'],
['RBLWL','Whitelisted DNSBL Validation For Connected IP Addresses',0,\&checkbox,0,'(.*)',undef,
  'Enable DNSBL for whitelisted IP\'s, domains and users. If enabled, RWL-hits and the PBWhite are ignored and the DNSBL check is done.',undef,undef,'msg003780','msg003781'],
['AddRBLHeader','Add X-Assp-DNSBL Header',0,\&checkbox,1,'(.*)',undef,
  'Add X-Assp-DNSBL header to messages with positive reply from DNSBL.',undef,undef,'msg003790','msg003791'],
['RBLError','DNSBL Failed Reply',80,\&textinput,'554 5.7.1 DNS Blacklisted by RBLLISTED','(.*)',undef,
  'SMTP reply for DNSBL failed messages. Default: \'554 5.7.1 DNS Blacklisted by RBLLISTED\'<br />
  The literal RBLLISTED (case sensitive) is replaced by the actual service providers(s).',undef,undef,'msg003800','msg003801'],
['RBLServiceProvider','RBL Service Providers*',80,\&textinput,'file:files/dnsbls.txt','(\S*)','configUpdateRBLSP',
 'Names of DNSBLs to use separated by "|". You may set for every provider a weight like zen.spamhaus.org=>50|bl.spamcop.net=>25.<br />
 Defaults are:<br />
 zen.spamhaus.org=>1|bl.spamcop.net=>1|psbl.surriel.com=>2|ix.dnsbl.manitu.net=>2|<br />
 l2.apews.org=>3|safe.dnsbl.sorbs.net=>1|dnsbl-1.uceprotect.net=>2|<br />
 dnsbl-2.uceprotect.net=>2|dnsbl-3.uceprotect.net=>2|blackholes.five-ten-sg.com=>3".<br />
 DNSBL providers can get a "weight" like bl.spamcop.net=>1.<br />
 The value of the weight can be set directly like=>45 or as a divisor of RBLmaxweight. Low numbers &lt; 6 are divisors . So if RBLmaxweight = 50 (default) bl.spamcop.net=>50  would be the same as bl.spamcop.net=>1, bl.spamcop.net=>2 would be the same as bl.spamcop.net=>25.<br />
 If the sum of weights surpasses RBLmaxweight, the DNSBL check fails.  If not, the DNSBL check is scored as "neutral" even with RBLmaxhits reached. Setting Showmaxreplies will allow ALL replies to contribute to the total weight regardless of RBLmaxhits.<br />
 Some RBL Service Providers, like blackholes.five-ten-sg.com, provides different return codes in a single DNS-zone: like 127.a.b.c - where a,b,c are used to identify a weight or type (or what ever) of the returned entry. If you want to care about special return codes, or if you want to use different weights for different return codes, you should use the following enhanced entry syntax:<br /><br />
 RBL-Service-Provider=>result-to-watch=>weight (like:)<br />
 blackholes.five-ten-sg.com=>127.0.0.2=>3<br />
 blackholes.five-ten-sg.com=>127.0.0.5=>4<br />
 blackholes.five-ten-sg.com=>127.0.?.*=>5<br /><br />
 You can see, the wildcards * (multiple character) and ? (single character) are possible to use in the second parameter. Never mix the three possible syntax types for the same RBL Service Provider. A search for a match inside such a definition is done in reverse ASCII order, so the wildcards are used as last.<br />
 Some RBL Service Providers, provides different return codes using a bitmask in any part of the reply. To define weights for bitmasks, place a single \'M\' in front of the mask number, like<br /><br />
 sp.com=>127.0.0.M2=>25<br />
 sp.com=>127.0.0.M4=>41<br />
 sp.com=>127.0.M1.5=>56<br />
 sp.com=>127.0.M64.*=>11<br />
 sp.com=>127.0.0.2=>22<br />
 sp.com=>127.0.*.*=>1<br /><br />
 Valid bitmasks are 1,2,4,8,16,32,64 and 128. The resulting weight will be the weight sum of all matching bitmasks (if no full qualified definition is found). For example: a return code of 127.0.0.6 for sp.com will result in a weight of 66 (25+41), a reply of 127.0.0.2 will result in 22<br />
 Because each single bitmask indicates a set of 128 numbers you should prevent the usage of something like 127.0.M16.M1 - this will lead into a set of (128*128) 16384 addresses, which is really too much!<br />
 For the same service provider, first define all bitmask definitions, after that all full qualified definitions and than all definitions with wildcards, like in the example above! If your definition order is wrong, the resulting weights will be unexpected!<br /><br />
 It can be possible, that you need to provide a privat key or ID in the query string for a RBL Service Provider - like: your-key.query-data.rbl-provider.org<br />
 In this case, define the RBL Service Provider like: your-key.$DATA$.rbl-provider.org or {your-key}.$DATA$.rbl-provider.org<br />
 In case your key needs to be placed anywhere in between it is mandatory, to put curly brakets around the key like: $DATA$.{your-key}.rbl-provider.org .<br />
 If the curly brakets are left out, your key will become part of the service provider hostname and may be included in SMTP error replies!<br />
 The literal $DATA$ will be replaced by the queried data in each request.
  ',undef,undef,'msg003810','msg003811'],
['RBLmaxreplies','Maximum Replies',3,\&textinput,7,'(\d*)','configUpdateRBLMR','A reply is affirmative or negative reply from a DNSBL.<br />
  The DNSBL module will wait for this number of replies (negative or positive) from the DNSBLs listed under Service Provider for up to the Maximum Time( RBLmaxtime ).<br />
  This number should be equal to or less than the number of DNSBL Service Providers listed to allow for randomly unavailable DNSBLs.',undef,undef,'msg003820','msg003821'],
['RBLmaxhits','Maximum Hits',3,\&textinput,2,'(\d*)','configUpdateRBLMH','A hit is an affirmative response from a DNSBL.<br />
  The DNSBL module will check all of the DNSBLs listed under Service Provider. If the number of hits is greater or equal Maximum Hits, the email is flagged <b>Failed</b>.<br />
  If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>Neutral</b>',undef,undef,'msg003830','msg003831'],
['RBLmaxweight','RBL Maximum Weight',3,\&textinput,50,'(\d*)',undef,'A weight is a number representing the trust we put into a DNSBL.<br />
  The DNSBL module will check all of the DNSBLs listed under Service Provider. If the total of weights is greater or equal Maximum Weight, the email is flagged <b>Failed</b>.<br />
  If the total of weights is greater 0 and less Maximum Weight, the email is flagged <b>Neutral</b>',undef,undef,'msg003840','msg003841'],
['RBLmaxtime','Maximum Time',5,\&textinput,15,'(\d*)',undef,'This sets the maximum time in seconds to spend on each message performing DNSBL checks. Default is 15.',undef,undef,'msg003850','msg003851'],
['RBLsocktime','Socket Timeout',5,\&textinput,1,'(\d*)',undef,'This sets the DNSBL socket read timeout in seconds.',undef,undef,'msg003860','msg003861'],
['RBLCacheExp','DNSBL Expiration Time',4,\&textinput,24,'(\d+\.?\d*|)','configUpdateRBLCR',
  'IP\'s in cache will be removed after this interval in hours. 0 will disable the cache. <input type="button" value=" Show DNSBL Cache" onclick="javascript:popFileEditor(\''.$newDB.'pb/pbdb.rbl.db\',5);" />
  <hr /><div class="cfgnotes">Notes On DNSBL</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/rbl.txt\',3);" />',undef,undef,'msg003870','msg003871'],

[0,0,0,'heading','URIBL and URI-IP Obfuscation Detection'],
 ['ValidateURIBL','Enable URI Blocklist Validation <a href="http://www.uribl.com/about.shtml" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="about" /></a>','0:disabled|1:block|2:monitor|3:score',\&listbox,'1','(.*)','configUpdateURIBL',
  'Enable URI Blocklist. Messages that fail URIBL validation will receive URIBLError SMTP error code. This requires an installed <a href="http://metacpan.org/search?q=Net::DNS" rel="external">Net::DNS</a> module and an installed <a href="http://metacpan.org/search?q=Email::MIME" rel="external">Email::MIME</a> module in PERL. <a href="https://sourceforge.net/p/assp/wiki/" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a><br />
  <span class="negative"> 0 = disabled, 1 = block, 2 = monitor, 3 =  messagescore .</span>',undef,undef,'msg003880','msg003881'],
 ['URIBLWL','Do URI Blocklist Validation for Whitelisted',0,\&checkbox,'','(.*)',undef,'URIBL check is done ignoring all spamlovers and testmodes!',undef,undef,'msg003890','msg003891'],
 ['URIBLNP','Do URI Blocklist Validation for NoProcessing',0,\&checkbox,'','(.*)',undef,'URIBL check is done ignoring all spamlovers and testmodes!',undef,undef,'msg003900','msg003901'],
 ['URIBLLocal','Do URI Blocklist Validation for Local Mails',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg003910','msg003911'],
 ['URIBLISP','Do URI Blocklist Validation for ISP/Secondary',0,\&checkbox,1,'(.*)',undef,'',undef,undef,'msg003920','msg003921'],
 ['URIBLServiceProvider','URIBL Service Providers*',60,\&textinput,'file:files/uribls.txt','(.*)','configUpdateURIBLSP',
 'Domain Names of URIBLs to use separated by "|". You may set for every provider a weight like multi.surbl.org=>50|black.uribl.com=>25.<br />
 The value of the weight can be set directly like=>45 or as a divisor of URIBLmaxweight . Low numbers &lt; 6 are divisors . So if URIBLmaxweight = 50 (default) multi.surbl.org=>50  would be the same as multi.surbl.org=>1, multi.surbl.org=>2 would be the same as multi.surbl.org=>25.<br />
 If the sum of weights surpasses URIBLmaxweight, the URIBL check fails.  If not, the URIBL check is scored as "neutral"  even with URIBLmaxhits reached. Setting Showmaxreplies will allow ALL replies to contribute to the total weight regardless of URIBLmaxhits.<br />
 Some URIBL Service Providers, like multi.surbl.org and black.uribl.com , provides different return codes in a single DNS-zone: like 127.a.b.c - where a,b,c are used to identify a weight or type (or what ever) of the returned entry. If you want to care about special return codes, or if you want to use different weights for different return codes, you should use the following enhanced entry syntax:<br /><br />
 URIBL-Service-Provider=>result-to-watch=>weight (like:)<br />
 multi.surbl.org=&gt;127.0.0.2=&gt;2<br />
 multi.surbl.org=&gt;127.0.0.4=&gt;3<br />
 multi.surbl.org=&gt;127.0.0.?=&gt;4<br />
 multi.surbl.org=&gt;127.0.0.*=&gt;5<br /><br />
 You can see, the wildcards * (multiple character) and ? (single character) are possible to use in the second parameter. Never mix the three possible syntax types for the same URIBL Service Provider. A search for a match inside such a definition is done in reverse ASCII order, so the wildcards are used as last.<br />
 Some URIBL Service Providers, provides different return codes using a bitmask in any part of the reply. To define weights for bitmasks, place a single \'M\' in front of the mask number, like<br /><br />
 sp.com=>127.0.0.M2=&gt;25<br />
 sp.com=>127.0.0.M4=&gt;41<br />
 sp.com=>127.0.M1.5=&gt;56<br />
 sp.com=>127.0.M64.*=&gt;11<br />
 sp.com=>127.0.0.2=&gt;22<br />
 sp.com=>127.0.*.*=&gt;1<br /><br />
 Valid bitmasks are 1,2,4,8,16,32,64 and 128. The resulting weight will be the weight sum of all matching bitmasks (if no full qualified definition is found). For example: a return code of 127.0.0.6 for sp.com will result in a weight of 66 (25+41), a reply of 127.0.0.2 will result in 22<br />
 Because each single bitmask indicates a set of 128 numbers you should prevent the usage of something like 127.0.M16.M1 - this will lead into a set of (128*128) 16384 addresses, which is really too much!<br />
 For the same service provider, first define all bitmask definitions, after that all full qualified definitions and than all definitions with wildcards, like in the example above! If your definition order is wrong, the resulting weights will be unexpected!<br /><br />
 If VirusTotalAPIKey is configured, assp is able to query URIs on www.virustotal.com . The API answers are in the range 127.0.0.2-127.0.0.253 (or none for OK), where the last digits represents HITS + 1.<br />
 Queries to VirusTotal are using HTTPS connections (https://www.virustotal.com/...) instead of DNS!<br />
 example:<br />
 virustotal=>127.0.0.2=&gt;1 # one hit<br />
 virustotal=>127.0.0.3=&gt;0.5 # two hits<br />
 virustotal=>127.0.0.4=&gt;0.33 # three hits<br />
 virustotal=>127.0.0.*=&gt;0.25 # more than three hits<br /><br />
 It can be possible, that you need to provide a privat key or ID in the query string for a URIBL Service Provider - like: your-key.query-data.uribl-provider.org<br />
 In this case, define the URIBL Service Provider like: your-key.$DATA$.uribl-provider.org or {your-key}.$DATA$.uribl-provider.org .<br />
 In case your key needs to be placed anywhere in between, it is mandatory to put curly brakets around the key like: $DATA$.{your-key}.uribl-provider.org .<br />
 If the curly brakets are left out, your key will become part of the service provider hostname and may be included in SMTP error replies!<br />
 The literal $DATA$ will be replaced by the queried data in each request.
 ',undef,undef,'msg003930','msg003931'],
 ['URIBLCCTLDS','URIBL Country Code TLDs*',60,\&textnoinput,'file:files/URIBLCCTLDS.txt','(.*)','ConfigMakeRe',
  'List of <a href="http://www.surbl.org/tld/two-level-tlds" rel="external">two level country code TLDs</a> and <a href="http://www.surbl.org/tld/three-level-tlds" rel="external">three level country code TLDs</a> used to determine the base domain of the uri. Two level TLDs will be checked on third level, third level TLDs will be checked on fourth level. Any not listed domain will be checked in level two.',undef,undef,'msg003940','msg003941'],
 ['URIBLmaxuris','Maximum URIs',5,\&textinput,0,'(\d*)',undef,
  'More than this number of URIs in the body will increase spam probability. Enter 0 to disable feature.',undef,undef,'msg003950','msg003951'],
 ['URIBLmaxdomains','Maximum Unique Domain URIs',5,\&textinput,0,'(\d*)',undef,
  'More than this number of unique domain URIs in the body will increase spam probability. Enter 0 to disable feature.',undef,undef,'msg003960','msg003961'],
 ['URIBLNoObfuscated','Disallow Obfuscated URIs <a href="http://www.pc-help.org/obscure.htm" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="obscure" /></a>',0,\&checkbox,'1','(.*)',undef,
  'When enabled, messages with obfuscated URIs of types [integer/octal/hex IP, other things!] in the body will get increased spam probability and if weights are used, the double weight will be used. If a very strong obfuscated IP is detected (like: 0x9A3F0800CEBF9E37 or 0xCE.191.0236.0x37), URIBL will fail!',undef,undef,'msg003970','msg003971'],
 ['URIBLcheckDOTinURI','Check for \'DOT\' in URI',0,\&checkbox,'','(.*)',undef,
  'When enabled, assp will also check for the used word \'DOT\' instead of a \'.\' in URI\'s like \'example<b>dot</b>com or example<b>!d o-t_</b>com\' .<br />
   Enable this feature only, if you don\'t expect any problems in your national language (using \'dot\' + a toplevel domain in any words).',undef,undef,'msg008820','msg008821'],
 ['URIBLmaxreplies','Maximum Replies',5,\&textinput,2,'(\d*)','configUpdateURIBLMR',
  'A reply is affirmative or negative reply from a URIBL.<br />
   The URIBL module will wait for this number of replies (negative or positive) from the URIBLs listed under Service Provider<br />
   for up to the Maximum Time below. This number should be equal to or less than the number of URIBL Service Providers<br />
   listed to allow for randomly unavailable URIBLs.',undef,undef,'msg003980','msg003981'],
 ['URIBLmaxhits','Maximum Hits',5,\&textinput,1,'(\d*)','configUpdateURIBLMH',
  'A hit is an affirmative response from a URIBL.<br />
   The URIBL module will check all of the URIBLs listed under Service Provider,<br />
   and flag the email with a URIBL failure flag if more than this number of URIBLs return a positive blacklisted response.<br />
   This number should be less than or equal to Maximum Replies above and greater than 0.
   If the number of hits is greater or equal Maximum Hits, the email is flagged <b>failed</b> in every case!
   If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>neutral</b>.<br />
   This behavior could be changed to your needs by using weighted values for the URIBLServiceProvider .',undef,undef,'msg003990','msg003991'],
 ['URIBLmaxweight','URIBL Maximum Weight',3,\&textinput,50,'(\d*)',undef,'A weight is a number representing the trust we put into a URIBL.<br />
  The URIBL module will check all of the URIBLs listed under URIBLServiceProvider for every URI found in an email. If the total of weights for a URI is greater or equal this Maximum Weight, the email is flagged <b>Failed</b>.<br />
  If the total of weights is greater 0 and less Maximum Weight, the email is flagged <b>Neutral</b> . If not defined or set to zero only the hit count will used to detect a fail or neutral state.',undef,undef,'msg009150','msg009151'],
 ['URIBLmaxtime','Maximum Time',5,\&textinput,10,'(\d*)',undef,
  'This sets the maximum time in seconds to spend on each message performing URIBL checks.',undef,undef,'msg004000','msg004001'],
 ['URIBLsocktime','Socket Timeout',5,\&textinput,1,'(\d*)',undef,'This sets the URIBL socket read timeout in seconds.',undef,undef,'msg004010','msg004011'],
 ['URIBLwhitelist','Whitelisted URIBL Domains*',60,\&textinput,'doubleclick.net|www.w3.org|schemas.microsoft.com','(.*)','ConfigMakeRe',
  'This prevents specific domains from being checked by URIBL module. For example: doubleclick.net|www.w3.org|schemas.microsoft.com or file:files/URIBLwhitelist.txt. Domains already listed in noProcessingDomains and whiteListedDomains will be honored.',undef,undef,'msg004020','msg004021'],
 ['noURIBL','Don\'t Check Messages from these Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Don\'t validate URIBL when messages come from these addresses. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). <br />
  For example: fribo@thisdomain.com|jhanna|@sillyguys.org',undef,undef,'msg004030','msg004031'],
 ['URIBLIPRe','Bad URI IP\'s*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
  'Every IP in a URI and every IP resolved for a hostname in a URI is checked against this list of IP\'s or networks. For example:145.145.145.145|145.146.|1.2.0.0/16<br />
  This high security feature will follow the rules in URIBLWL, URIBLNP, URIBLLocal and URIBLISP - but if a match is found, it will block the email ( ignores scoring, monitoring, testmodes and spamlover ).',undef,undef,'msg009600','msg009601'],
 ['AddURIBLHeader','Add X-Assp-Received-URIBL Header',0,\&checkbox,1,'(.*)',undef,
  'Add X-Assp-Received-URIBL header to messages with positive reply from URIBL.',undef,undef,'msg004040','msg004041'],
 ['AddURIS2MyHeader','Add X-Assp-Detected-URI Header',0,\&checkbox,'','(.*)',undef,
  'URI\'s detected with URIBLOK are added to our header lines (X-Assp-Detected-URI:).',undef,undef,'msg009750','msg009751'],
 ['URIBLCacheInterval','URIBL Cache Refresh Interval for Hits',3,\&textinput,1,'(\d+\.?\d*|)','configUpdateURIBLCR',
  'Domains in cache will be removed after this interval in days. Empty or 0 will disable the cache. <input type="button" value=" Show URIBL Cache" onclick="javascript:popFileEditor(\''.$newDB.'pb/pbdb.uribl.db\',5);" />',undef,undef,'msg004050','msg004051'],
 ['URIBLCacheIntervalMiss','URIBL Cache Refresh Interval for Misses',3,\&textinput,0.5,'(\d+\.?\d*|)','configUpdateURIBLCR',
  'Domains in cache with status=2 (miss) will be removed after this interval in days. Empty or 0 will prevent caching of non-hits. ',undef,undef,'msg004060','msg004061'],
 ['URIBLError','Reply Code to Refuse Failed URIBL Message',80,\&textinput,'554 5.7.1 Blacklisted by URIBLNAME Contact the postmaster of this domain for resolution. This attempt has been logged.','([245]5\d .*|)',undef,
  'SMTP reply code to refuse failed URIBL message. The literal URIBLNAME (case sensitive) is replaced by the names of URIBLs with negative response. If this field is empty, client connection is simply dropped.<br /><hr /><div class="cfgnotes">Notes On URIBL</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/uribl.txt\',3);" />',undef,undef,'msg004070','msg004071'],

[0,0,0,'heading','Attachment Validation and Protection'],
['DoBlockExes','External Attachment Blocking ','0:disabled|1:block|2:monitor|3:score',\&listbox,0,'([\s0123]?)',undef,'This requires an installed <a href="http://metacpan.org/search?q=Email::MIME" rel="external">Email::MIME</a> module in PERL.',undef,undef,'msg004080','msg004081'],
['BlockExes','External Attachment Blocking Level','0:no check|1:Level 1|2:Level 2|3:Level 3|4:Level 4',\&listbox,0,'([\s01234]?)',undef,
  'Set the level of Attachment Blocking to 1-3 for attachments that should be blocked, set level to 4  for attachments that should be allowed. Choose 0 for no attachment blocking.',undef,undef,'msg004090','msg004091'],
['BlockWLExes','Whitelisted &amp; Local Attachment Blocking','0:no check|1:Level 1|2:Level 2|3:Level 3|4:Level 4',\&listbox,0,'([\s01234]?)',undef,
  'Set the level of Attachment Blocking to 0-4 for whitelisted &amp; local senders. Choose 0 for no attachment blocking.',undef,undef,'msg004100','msg004101'],
['BlockNPExes','NoProcessing Attachment Blocking','0:no check|1:Level 1|2:Level 2|3:Level 3|4:Level 4',\&listbox,0,'([\s01234]?)',undef,
  'Set the level of Attachment Blocking to 0-4 for no processing senders. Choose 0 for no attachment blocking. ',undef,undef,'msg004110','msg004111'],
['BadAttachL1','Level 1 rejected File Extensions',80,\&textinput,'exe\-bin|exe|scr|pif|vb[es]?|jse?|ws[cfh]?|sh[sb]?|li?nk|bat|cmd|com|ht[ab]|ps1?','(.*)','updateBadAttachL1',
  'This regular expression is used to identify Level 1 attachments that should be blocked.<br />
  Separate entries with a pipe |. The dot . is assumed to precede these, so don\'t include it.<br />
  For example:<br />
  ace|ad[ep]|asx|ba[st]|chm|cmd|com|cpl|crt|dbx|exe|exe\-bin|hlp|ht[ab]|in[fs]|isp|jse?|li?nk|md[abez]|mht|ms[cipt]|nch|pcd|pif|prf|ps1?|reg|sc[frt]|sh[bs]?|vb[es]?|wms|ws[cfh]?<br />
  If you\'ve installed the ASSP_AFC Plugin (at least version 2.10) and \'exe-bin\' is defined (on any level), the Plugin will detect executable files based on their binary content. Detected will be all executables, libraries and scripts for DOS and Windows (except .com files), MS office macros(VBA), MAC-OS and linux ELF (for all processor architectures).<br />
  If you want to skip the detection for a specific executable type, define any combination of the tags below like: \'exe-bin|:WSH|:MSOM|:WIN\' - notice the leading collon for the exceptions!<br /><br />
 :WIN - windows executables<br />
 :MOS - Java Class Bytecode or Mach-O executables<br />
 :PEF - Classic MacOS executables<br />
 :ELF - ELF (linux) executables<br />
 :WSH - windows shell scripts<br />
 :MMC - windows MMC Console Files<br />
 :ARC - static library (linux,unix)<br />
 :CSC - common scripts (basic,java,perl,php,powershell....)<br />
 :PDF - adobe PDF file with embedded executable code or microsoft office macros files, JavaScript and bad URIs <span class="negative">(using the :PDF exception is not recommended as this will disable all PDF executable scanning)</span><br />
 :CERTPDF - certificate signed adobe PDF file<br />
 :URIPDF - adobe PDF file with URIs to download exeutables from the web or to open local files<br />
 :JSPDF - adobe PDF file with JavaScript inside - notice: well known malicious JavaScript combinations will be blocked, even this option is defined<br />
 :JSHTML - HTML file with JavaScript or mouse driven HTML events (like: onmouseover, onmouseout, onfocus, onblure ...) inside<br />
 :JSSVG - SVG images with JavaScript or mouse driven HTML events (like: onmouseover, onmouseout, onfocus, onblure ...) inside<br />
 :MSOLE - all Microsoft Office Compound File Binary (OLE) - legacy not recommended, OLE files can contain any conceivable content<br />
 :HLMSOLE - (HarmLess) Microsoft Office Compound File Binary (OLE) - MSOLE, except it contains forbidden files (the <a href="http://metacpan.org/search?q=OLE::Storage_Lite" rel="external">OLE::Storage_Lite</a> module in PERL is needed)<br />
 :MSOM - Microsoft Office Macros<br />',undef,undef,'msg004120','msg004121'],
['BadAttachL2','Level 2 rejected File Extensions',80,\&textinput,'','(.*)','updateBadAttachL2',
  'This regular expression is used to identify Level 2 attachments that should be blocked.<br />
  Level 2 already includes all rejected extensions from Level 1. <br />
  For example:<br />
  (ad[ep]|asx|ba[st]|chm|cmd|com|cpl|crt|dbx|exe|hlp|ht[ab]|in[fs]|isp|js|jse|lnk|md[abez]|mht|ms[cipt]|nch|pcd|pif|prf|reg|sc[frt]|sh[bs]|vb|vb[es]|wms|ws[cfh])\.zip',undef,undef,'msg004130','msg004131'],
['BadAttachL3','Level 3 rejected File Extensions',80,\&textinput,'','(.*)','updateBadAttachL3',
  'This regular expression is used to identify Level 3 attachments that should be blocked.<br />
  Level 3 includes Level 2 and Level 1.<br />
  For example:<br />
  zip|url',undef,undef,'msg004140','msg004141'],
['GoodAttach','Level 4 Allowed File Extensions',80,\&textinput,'','(.*)','updateGoodAttach',
  'This regular expression is used to identify attachments that should be allowed. All others are blocked. Separate entries with a pipe |. The dot . is assumed to precede these, so don\'t include it.<br />
  For example:<br />
  ai|asc|bhx|dat|docx?|eps|gif|gz(?:ip)|html?|hqx|ics|jpe?g|od[tsp]|pdf|p7[mscz]|ppt|rar|rpt|rtf|snp|tar|tgz|txt|xls|zip|7z',undef,undef,'msg004150','msg004151'],

['UserAttach','User based Good and Bad Attachments*',40,\&textinput,'','(file:.+|)','updateUserAttach',
  'This set of regular expression is used to identify attachments that should be allowed (good) or blocked (block) for specified users and/or domains. Separate entries with any of \'=&gt; , ; space\'. Separate multiple regex entries with pipe \'|\'. The dot . is assumed to precede the regex, so don\'t include it anywhere (except the user name).<br />
  block=&gt; rules cause specific file types to be blocked (but does not block the others).<br />
  good=&gt; rules block all file types except for those specified in the rule.<br />
  To define entries you have to use the \'file:...\' option. Define one entry per line - comments are not allowed in a definition line.<br />
  The syntax of an entry is as follows:<br />
  username => good => goodAttachRegex , good-out => goodoutRegex , good-in => goodinRegex , block => blockAttachRegex , block-out => blockoutRegex , block-in => blockinRegex<br />
  username - Mail solely to or from any of these addresses. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com) or a Group definition [GROUP]. Wildcards are supported (fribo*@domain.com).<br /><br />
  good => goodAttachRegex - good attachment for incoming and outgoing mails<br />
  good-out => goodoutRegex - good attachment for outgoing mails<br />
  good-in => goodinRegex - good attachment for incoming mails<br />
  block => blockAttachRegex - bad attachment for incoming and outgoing mails<br />
  block-out => blockoutRegex - bad attachment for outgoing mails<br />
  block-in => blockinRegex - bad attachment for incoming mails<br /><br />
  For example:<br />
  user@domain.tld => good => ai|asc|bhx|dat|doc|eps|gif|htm|html|ics|jpg|jpeg|hqx|od[tsp]|pdf|ppt|rar|rpt|rtf|snp|txt|xls|zip<br />
  *@domain.tld => good => ai|asc|bhx , good-out => eps|gif , good-in => htm|html , block => pdf|ppt , block-out => rar|rpt , block-in => xls|exe\-bin<br /><br />
  At least one of the above option must be defined in a line - a maximum of all (six) could be defined, if this makes sense.<br /><br />

  It is possible to define templates (see the preceding <b>single tilde ~</b> ) for extension regular expression and to use them in any entry at any place <b>(except other extension regular expression templates)</b> - like:<br /><br />
  ~executables => cmd|com|cpl|exe|exe\-bin|lnk|pif<br />
  ~scripts => js|pl|ps1?|sh|vb[es]?|wms|ws[cfh]<br />
  user1@domain.tld => block => ~executables|~scripts|mht|ms[cipt] , block-in =>:MSOM , block-out => :CERTPDF<br />
  [allDomains] => block => ~executables|:CSC<br /><br />
  Extension regular expression template names have to start with a single tilde. Allowed name characters are A-Z, a-z, 0-9 and underscrore. Names are case sensitive.<br /><br />

  It is also possible to define rule templates and to use them in combination with any other rule definitions or rule templates.<br />
  Rule templates <b>starts with two tilde (~~template)</b>. Allowed name characters are A-Z, a-z, 0-9 and underscrore. Names are case sensitive. For example:<br /><br />
  ~~commonRule=>block=>~executables|~scripts|xls,block-in=>:MSOM,block-out=>:CSC<br />
  ~~devRule=>~~commonRule=>block-out=>:WIN|:ELF<br />
  ~~allowALL=>good=>.*<br />
  *@domain.com=>~~commonRule<br />
  [IT]=>~~devRule<br />
  user@domain.com=>~~commonRule,~~anySecondRule,~~anyOtherRule=>block=>~anyExt,block-in=>~otherExt|xls|--doc<br /><br />
  Notice the leading -- in front of the --doc regular expression in the last example. The leading -- removes all occurences of this regular expression from the resulting entry, here from "block-in" (NOT from block!) at configuration time. You would need to define --doc in the "block=>" entry as well, to remove such occurences there.<br />
  Because the -- exceptions are processed at configuration time, such a definition will not overwrite an opposit rule definition: sender &gt; recipient and recipient &gt; sender - which are combined at runtime (attachment check).<br />
  If you want assp to process such a "remove extension directive" at runtime (to make the recipient &lt;&gt; sender rule overwrite working for this address), use for example -+doc instead of --doc. Be carefull creating weak blocking rules using the -+ directive. Make sure the sender and recipient address can NOT be faked (eg. SPF-strict, DKIM)<br />
  It is possible to combine multipe -- as well as multiple -+ exceptions in regular expression style, for example:<br /><br />
  ~allowExe => --(?:cmd|com|cpl|exe|exe\-bin|lnk|pif) - which is the same like: --cmd|--com|--cpl|--exe|--exe\-bin|--lnk|--pif <br />
  ~forceAllowExe => -+(?:cmd|com|cpl|exe|exe\-bin|lnk|pif)<br />
  [IT]=>~~devRule , block-out=>~allowExe , block-in => ~forceAllowExe<br /><br />
  Do <b>NOT use nested brackets</b> like in --(?:c<b>(?:md|om|pl)</b>|exe<b>(?:\-bin)?</b>|lnk|pif) to define any exception!<br /><br />
  It may possible, that you want assp to deliver mails sent from a specific domain or emailaddress any way (without an attachment check). For security reasons this behavior can be only forced, if the sender was validated by SPF and/or DKIM and/or SMIME/PGP (Sig). The check is done by assp at runtime (mail processing) only!
  The definition described below must be done sepately for evey "good","block" as well as "zip" tag, for which the attachment check should be skipped.<br />
  The (not case sensitive) definition tag starts with NoCheckIf= , followed by at least one state of "spf","dkim" or "sig". These states can be AND combined by writing them simply together like SpfDkim or SpfDkimSig in one word. To combine them in an OR logic, separate them by a dot like: Spf.Dkim . An combination for OR - AND would be: Spf.DkimSig . Whitespaces are not allowed in a NoCheckIf= definition!<br />
  spf - the mail passed the SPF check - Notice: to validate against IP addresses for non SPF domains, use SPFoverride <br />
  dkim - the mail is DKIM signed and passed the DKIM check<br />
  sig - the mail contains a valid SMIME or PGP signature<br /><br />
  examples:<br />
  ~~allowSDSSIn=>good-in=>NoCheckIf=SpfDkim.SpfSig,block-in=>NoCheckIf=SpfDkim.SpfSig<br />
  sender@domain.org=>~~allowSDSSIn<br />
  or<br />
  sender@domain.org=>good-in=>NoCheckIf=SpfDkim.SpfSig,block-in=>NoCheckIf=SpfDkim.SpfSig<br />
  which means: for sender@domain.org (sender) the good and the block check will be skipped, if the mail is SPF checked and DKIM validated - or the mail is SPF checked and has a SMIME/PGP signature.<br /><br />
  *@domain.org=>good-in=>NoCheckIf=Dkim.Sig,block-in=>NoCheckIf=Dkim.Sig<br />
  which means: for the sending domain @domain.org the good and the block check will be skipped, if the mail is DKIM validated or has a SMIME/PGP signature.<br /><br />

  ASSP will resolve all extension regular expression templates and all rule tempates and will combine them all into one resulting domain or user attachment rule.<br />
  ASSP will throw a warning, if a rule template is define multipe times - like: *@domain.com=~~commonRule,~~devRule - here ~~devRule already contains ~~commonRule<br />
  It may happen, that the resulting attachment rule contains one or more extension regular expressions multiple times - this is harmless and will be internaly corrected, but try to prevent it.<br /><br />
  
  This feature replaces all of the above level definitions ( BadAttachL1 , BadAttachL2 , BadAttachL3 , GoodAttach ), if at least one valid (not zip:... from the ASSP_AFC Plugin) attachment blocking or allow rule is found for the envelope sender or the first envelope recipient of a mail!<br />
  good, good-out and good-in - and also - block, block-out and block-in - will be logical OR (pipe \'|\') combined from the matched rule for the first envelope recipient and the envelope sender - according to the mail flow.<br />
  The defined block and good rules for the envelope sender and the first envelope recipient are than combined together using the same OR logic (pipe \'|\') at runtime.<br />
  <b>All block rules are processed first (before any of the good rules). If, for example, "xls" is found in the processed good-in and in the processed block-in rule of the same recipient or sender, ".xls" attachments will be blocked.</b><br />
  The attachment block rules for a specific email are looking as follows: (replace block with good in mind, to get the attachment good rules)<br />
  incoming mail: recipient-block|recipient-block-in|sender-block|sender-block-in<br />
  outgoing mail: sender-block|sender-block-out|recipient-block|recipient-block-out<br />
  Notice: if a bad attachment is found on a user based attachment check, the penalty box IP address scoring is skipped.',undef,undef,'msg009690','msg009691'],

['AttachmentError','Reply Code to Refuse Rejected Attachments',80,\&textinput,'550 5.7.1 These attachments are not allowed -- Compress before mailing.','([245]\d\d .*)',undef,'The literal \'FILENAME\' will be replaced with the name of the blocked attachment!',undef,undef,'msg004160','msg004161'],
['BlockUuencoded','Refuse Uuencoded Mails',0,\&checkbox,1,'(.*)',undef,'',undef,undef,'msg004170','msg004171'],
['UuencodedError','Reply to Refuse Uuencoded Mails',80,\&textinput,'554 5.7.1 This message is uuencoded and will be blocked. ','([25]\d\d .*)',undef,
 'For example: 554 5.7.1 This mail is uuencoded and will be blocked<br />
 <hr /><div class="cfgnotes">Notes On Attachment Blocking</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/Attachments.txt\',3);" />',undef,undef,'msg004180','msg004181'],

[0,0,0,'heading','Virus Protection using ClamAV and OS-FileScanner'],
['noScan','Do Not Scan Messages from/to these Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe','Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).',undef,undef,'msg004190','msg004191'],
['noScanIP','Do Not Scan Messages from these IP\'s*',60,\&textinput,'','(\S*)','ConfigMakeIPRe','Enter IP addresses that you don\'t want to be scanned for virus , separated by pipes (|). For example: 145.145.145.145|145.146.',undef,undef,'msg004200','msg004201'],
['NoScanRe','Skip Virus RegEx*',80,\&textinput,'','(.*)','ConfigCompileRe',
 "Put anything here to identify messages which should not be checked for viruses.",undef,undef,'msg004210','msg004211'],
['SuspiciousVirus','No-Blocking Virus Scan Scoring Regex**',80,\&textinput,'file:files/suspiciousvirus.txt','(.*)','ConfigCompileRe',
 'If a ClamAV or FileScan result matches this expression it will be scored with the suspicious virus score ( vsValencePB ) and the message will not be blocked.<br />
 It is possible to weight such results. Every weighted regex that contains at least one \'|\' has to begin and end with a \'~\' - inside such regexes it is not allowed to use a \'~\', even it is escaped - for example:  ~abc\\~|def~=>23 or ~abc~|def~=>23 - instead use the octal (\\126) or hex (\\x7E) notation , for example ~abc\\126|def~=>23 or ~abc\\x7E|def~=>23 . Every weighted regex has to be followed by \'=>\' and the weight value. For example: <br />
 Phishing\\.=>1.45|~Heuristics|Email~=>50
 <br />
 or<br />
 ~(Email|HTML|Sanesecurity)\\.(Phishing|Spear|(Spam|Scam)[a-z0-9]?)\\.~=>4.6|Spam=>1.1|~Spear|Scam~=>2.1 .<br />
 The multiplication result of the weight and the penaltybox valence value will be used for scoring, if the absolute value of weight is less or equal 6. Otherwise the value of weight is used for scoring.',undef,undef,'msg004220','msg004221'],
['ScanWL','Scan Whitelisted Senders',0,\&checkbox,'1','(.*)',undef,'',undef,undef,'msg004230','msg004231'],
['ScanNP','Scan No Processing Senders',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg004240','msg004241'],
['ScanLocal','Scan Local Senders',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg004250','msg004251'],
['ScanCC','Scan Copied Spam and Forwarded Ham Mails',0,\&checkbox,'','(.*)',undef,'
 If enabled and a virus is found in the forwarded mail content, forwarding will be skipped.',undef,undef,'msg004260','msg004261'],
['AvError','Reply Code to Refuse Infected Messages',80,\&textinput,'554 5.7.1 Mail appears infected with [$infection].','([25]\d\d .*)',undef,
 'Reply code to refuse infected messages. The string $infection is replaced with the name of the detected virus.<br />
 For example: 554 5.7.1 Mail appears infected with [$infection] -- disinfect and resend.',undef,undef,'msg004270','msg004271'],
['EmailVirusReportsTo','Send Virus Report To These Addresses',80,\&textinput,'','((?:(?:IN:|OUT:)?'.$EmailAdrRe.'\@'.$EmailDomainRe.')(?:\|(?:IN:|OUT:)?'.$EmailAdrRe.'\@'.$EmailDomainRe.')*|)',undef,
 'If set, an email containing the Message ID, Remote IP, Message Subject, Sender email address, Recipient email address, and the virus detected will be sent to these addresses. For example: admin@domain.com .<br />
 It is possible to define multiple addresses separated by pipe (|) e.g: admin@domain.com|virusalert@domain.com .<br />
 In addition, a leading \'IN:\' or \'OUT:\' can be specified in front of each address for incoming or outgoing/local mails. e.g: commonvirusalert@domain.com|IN:inboundvirusalert@domain.com|OUT:localvirusalert@domain.com .<br />
 The literals \'USER\' and \'DOMAIN\' will be replaced by the user part and domain part of the sender for outgoing/local mails and the recipient for incoming mails.',undef,undef,'msg004280','msg004281'],
['EmailVirusReportsHeader','Add Full Header To Virus Report To Mail Address Above',0,\&checkbox,'','(.*)',undef,'If set the full message headers will also be added to Virus Reports.',undef,undef,'msg004290','msg004291'],
['EmailVirusReportsToRCPT','Send Virus Report To Recipient','0:disabled|1:in any case|2:for HAM only',\&listbox,0,'(\d)',undef,'If set the intended recipient of the message will be sent a copy of the Virus Report. If "for HAM only" is selected, the report will only be sent, in case the mail is not detected as SPAM before the virus check is done.
  <hr />',undef,undef,'msg004300','msg004301'],
['ClamAVBytes','ClamAV Bytes',8,\&textinput,60000,'(\d*)',undef,
  'The number of bytes per message or file that will be submited to ClamAV and FileScan for virus scanning. Values of 100000 or larger are not recommended, because while a thread is waiting for the scanner result, it could not get new connections.',undef,undef,'msg004390','msg004391'],
['DoFileScan','Use File System Virus Scanner','0:disabled|1:block|2:monitor',\&listbox,0,'(\d)',undef,
 'If activated, the message is written to a file inside the \'FileScanDir\' with an extension of \'maillogExt\'. After that ASSP will call \'FileScanCMD\' to detect if the temporary file is infected or not. The temporary created file(s) will be removed.<br />
 The infected file will be stored in a special folder, if the SpamVirusLog is set to \'quarantine\' and the filepath to the viruslog is set.<br />
 Please check the setting of FileLogScan before you enable this option!',undef,undef,'msg004310','msg004311'],
['FileScanDir','File Scan Directory',80,\&textinput,"$base/virusscan",'(.*)','',
 'Define the full path to the directory where the messages are temporary stored for the file system virus scanner. This could be any directory inside your file system. The running ASSP process must have full permission to this directory and the files inside!',undef,undef,'msg004320','msg004321'],
['FileScanCMD','File Scan Command',80,\&textinput,'','(.*)','',
 'ASSP will call this system command and expects a returned string from this command. This returned string is checked against \'FileScanBad\' and/or \'FileScanGood\' to detect if the message is OK or not! If the file does not exists after the command call, the message is consider infected. ASSP expects, that the file scan is finished when the command returns!<br />
  The literal \'FILENAME\' will be replaced by the full qualified file name of the temporary file.<br />
  The literal \'NUMBER\' will be replaced by the threadnumber and could be used to name logfiles and to redirect them to STDOUT.<br />
  The literal \'FILESCANDIR\' will be replaced with the value of FileScanDir.<br />
  Any case sensitive literal starting and ending with an asterix (*) like \'*rcpt*\' or \'*mailfrom*\' will be replaced by the quoted runtime connection variable of Con{fh}->{literal} (this->{literal}). You need to know the assp internals!<br />
  If a code reference is defined for the internal variable &#36;main::FileScanCMDbuild_API in lib/CorrectASSPcfg.pm , assp will call \'&#36;FileScanCMDbuild_API->(\\&#36;cmd,&#36;this)\' before running the command. The first parameter, the command (FileScanCMD), is submitted as a reference to a scalar, which must be modified in place. If you want assp not to scan the message, set this variable to undef. The second submitted parameter is the reference to the client connection parameter HASH - &#36;Con{fh} (eg. &#36;this)<br />
  All outputs of this command to STDERR are automatic redirected to STDOUT.<br />
  FileScan will not run, if FileScanCMD is not specified.<br />
  If you have your online/autoprotect file scanner configured to delete infected files inside the \'FileScanDir\', define \'NORUN\' in this field! In this case FileScanGood and FileScanBad are ignored. If there is a need to wait some time for the autoprotect scanner, write \'NORUN-dddd\', where dddd are the milliseconds to wait!<br />
  Depending on your operating system it may possible, that you have to quote (\' or ") the command, if it contains whitespaces. The replaced file name will be quoted by ASSP if needed.',undef,undef,'msg004330','msg004331'],
['FileScanBad','RegEx to Detect \'BAD\' in Returned String*',80,\&textinput,'','(.*)','ConfigCompileRe',
 'Put anything here to identify bad messages by the string returned from the FileScanCMD. If defined and this regular expression matches, the message is consider infected.',undef,undef,'msg004340','msg004341'],
['FileScanGood','RegEx to Detect \'GOOD\' in Returned String*',80,\&textinput,'','(.*)','ConfigCompileRe',
 'Put anything here to identify good messages by the string returned from the FileScanCMD. If defined and this regular expression matches and \'FileScanBad\' does not, the message is consider not infected.<br />
  If both FileScanBad and FileScanGood are defined, FileScanBad has not to match and FileScanGood has to match, to consider a mail not infected!',undef,undef,'msg004350','msg004351'],
['FileScanRespRe','FileScan Responds Regex*',60,\&textinput,'','(.*)','ConfigCompileRe',
 'A regular expression that will be used over the text returned from the FileScanCMD. The result of this regex is used as virus name ($infection) in AvError. For example: infected by ([^\r\n]+)
 <hr />',undef,undef,'msg004360','msg004361'],
['FileLogScan','Scan Resent and Stored Files for Virus with FileScan','0:no scan|1:scan resend folder only|2:scan resend folder and collected files',\&listbox,2,'(\d*)',undef,'If virus check is enabled ( DoFileScan ), every file/mail (except reports - eg. n10000123456$maillogExt) in the \'resendmail\' folder and if selected, every collected file is scanned for virus before it is sent or stored.<br />
 If a virus is found, the file/mail is not (re)sent (it will get the extension \'.virus\') and a notification mail will be sent to local users. Infected collected files are moved into the SpamVirusLog folder.<br />
 To force the resend of a virus infected mail, the header tag \'X-ASSP-ForceResend:\' must be added to the file!<br />
 If \'scan resend folder and collected files\' is selected, it could be possible, that the virus scanner ( FileScanCMD ) forces a very high system workload.<br />
 If you are not sure what to set here, leave the setting at the default \'scan resend folder and collected files\'!<br />
 If the ASSP_AFC Plugin is installed and configured to be used, the files in the resend folder will be scanned by FileScan and ClamAV if any of FileLogScan or ClamAVLogScan is configured.<br />
 Under normal conditions the scan will be done by the SMTP-worker, if assp is under a heavy workload, the scan request will be transfered to the High-Workers (10000/10001).',undef,undef,'msg009760','msg009761'],
['UseAvClamd','Use ClamAV',0,\&checkbox,0,'(.*)',undef,
 'If activated, the message is checked by ClamAV, this requires an installed File::Scan::ClamAV Perl module and a running Clamd . It is not recommended to use ClamAV on heavy-load systems, because of resulting system overload, stuck workers or timeouts.<br />
 The infected file will be stored in a special folder, if the SpamVirusLog is set to \'quarantine\' and the filepath to the viruslog is set.<br />
 Please check the setting of ClamAVLogScan before you enable this option!',undef,undef,'msg004370','msg004371'],
['AvClamdPort','Port or file socket for ClamAV',30,\&textinput,'','(\S+(?:\|\S+)*|)',undef,
 'A socket specified in the clamav.conf file - LocalSocket. For example /tmp/clamd. If the socket has been setup as a TCP/IP socket (see the TCPSocket option in the clamav.conf file), then specify the TCP socket. For example: 3310 .<br />
 For remote host TCP connections define the hostname or IP-address in front of the port definition - example: clamhost:3310 or 192.168.0.1:3310 . If the hostname is not defined, localhost will be used as default.<br />
 It is possible to define multiple hosts to balance the workload - define them separated by pipe (|) - example: clamhost:3310|192.168.0.1:3310<br />
 If multiple hosts are defined, they are used in a random round-robin mode.',undef,undef,'msg004380','msg004381'],
['ClamAVLogScan','Scan Resent and Stored Files for Virus with ClamAV','0:no scan|1:scan resend folder only|2:scan resend folder and collected files',\&listbox,2,'(\d*)',undef,'If virus check is enabled ( UseAvClamd ), every file/mail (except reports - eg. n10000123456$maillogExt) in the \'resendmail\' folder and if selected, every collected file is scanned for virus before it is sent or stored.<br />
 If a virus is found, the file/mail is not (re)sent (it will get the extension \'.virus\') and a notification mail will be sent to local users. Infected collected files are moved into the SpamVirusLog folder.<br />
 To force the resend of a virus infected mail, the header tag \'X-ASSP-ForceResend:\' must be added to the file!<br />
 If \'scan resend folder and collected files\' is selected, it could be possible, that the virus scanner (clamd) forces a very high system workload.<br />
 If you are not sure what to set here, leave the setting at the default \'scan resend folder only\'!<br />
 If the ASSP_AFC Plugin is installed and configured to be used, the files in the resend folder will be scanned by FileScan and ClamAV if any of FileLogScan or ClamAVLogScan is configured.<br />
 Under normal conditions the scan will be done by the SMTP-worker, if assp is under a heavy workload, the scan request will be transfered to the High-Workers (10000/10001).',undef,undef,'msg010400','msg010401'],
['ClamAVtimeout','ClamAV Timeout',3,\&textinput,30,'(\d+)',undef, 'ClamAV will timeout after this many seconds.<br />
 default: 30 seconds.
 <hr /><div class="cfgnotes">Notes On Virus Control</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/viruscontrol.txt\',3);" />',undef,undef,'msg004400','msg004401'],

[0,0,0,'heading','Perl Regular Expression Filter and Spambomb Detection <a href="https://sourceforge.net/p/assp/wiki/Regular_Expressions" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="bombRe" /></a>'],
['AllowInternalsInRegex','Allow Internal Variables in Regex',0,\&checkbox,'','(.*)',undef,'Allow internal variables to be used in regular expressions - replaces something like ${$EmailDomainRe} with the value of $EmailDomainRe',undef,undef,'msg009770','msg009771'],
['preHeaderRe','Regular Expression to early Identify Spam in Handshake and Header Part*',80,\&textinput,'file:files/preheaderre.txt','(.*)','ConfigCompileRe',
 'Until the complete mail header is received, assp is processing the handshake and header content line per line, but the first mail content check is done after the complete mail header is received.<br />
 It is possible, that some content (malformed headers, forbidden characters or character combinations) could cause assp to die or to run into a unrecoverable exception.<br />
 Use this regular expression to identify such incoming mails based on a <b>line per line</b> check, at the moment where a <b>single MIME-header line</b> is received.<br />
 <b>Notice: MIME-encoded text is not decoded and header tags with multiple header lines are not unwraped for this check!</b><br />
 This setting does not affect any other and is not affected by any other configuration setting, except that this check is only done for incoming mails.<br />
 If a match is found, assp will immediately send a \'421 <myName> closing transmission\' reply to the client and will immediately terminate the connection.<br />
  Default setting is file:files/preheaderre.txt',undef,undef,'msg008890','msg008891'],
['bombReWL','Do Bomb/Script Regular Expressions Checks for Whitelisted',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg004410','msg004411'],
['bombReNP','Do Bomb/Script Regular Expressions Checks for NoProcessing',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg004420','msg004421'],
['bombReLocal','Do Bomb/Script Regular Expressions Checks for Local Messages',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg004430','msg004431'],
['bombReISPIP','Do Bomb/Script Regular Expressions Checks for ISPIP',0,\&checkbox,'1','(.*)',undef,'',undef,undef,'msg004440','msg004441'],

['bombMaxPenaltyVal','Maximum Penalty on Bombs per Mail per Check',3,\&textinput,70,'(\d*)',undef, 'Depending on the configuration, it could be possible that a message gets a very high penalty value on a bomb-check. This value limits the maximum penalty per mail for every single bomb-check that is enabled. Every spam bomb related Valence Value should be set lower (or equal) than this value - or blocking mode will not work (see the red text below)!',undef,undef,'msg004450','msg004451'],
['maxBombSearchTime','Maximum time spend on Bomb Search',3,\&textinput,5,'(\d*)',undef, 'Maximum time in seconds that is spend on every configured bomb check. This time check is done, after every found bomb. So it is possible that the bomb search takes longer as the defined value, if no bomb is found or a single search takes more time. Default is 5.
  <hr><hr>
  <span class="negative">Even if any of the following bomb parameters is set to "block", but the sum of the resulting weighted penalty value is less than the corresponding "Penalty Box Valence Value" (because of lower weights - <b>or a too high Valence Value</b>) - only scoring will be done!<br />
  A description of how of weighting regular expressions is done and working, could be found at the bottom this web page.</span><hr>',undef,undef,'msg004460','msg004461'],
['DoTransliterate','Transliterate non-Roman characters into Roman',0,\&checkbox,'','(.*)',undef,
'If enabled, ASSP tries to transliterate non-Roman characters in an email into Roman characters. These transliterations are than additionally used in the bomb checks.<br />
 For example - the (character) sequence \'&#24180;&#20809;&#36890;&#20449;&#20135;&#19994;&#20250;&#22238;&#24402;&#39640;&#22686;&#38271;&#36712;&#36947;\' will be transliterated to \'Nian Guang Tong Xin Chan Ye Hui Hui Gui Gao Zeng Chang Gui Dao\' .<br />
 To transliterate something, use the \'Mail Analyzer\'.<br />
 To make this feature working, the Perl module <a href="http://metacpan.org/search?q=Text::Unidecode" rel="external">Text::Unidecode</a> must be installed.',undef,undef,'msg00009990','msg009991'],
['DoBombHeaderRe','Use BombHeader Regular Expressions on Header Part','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,1,'(\d*)',undef,
  'If activated, each message-header is checked  against bombSenderRe, bombHeaderRe, bombSubjectRe and bombCharSets Regular Expressions. If you use sendAllSpam, be aware that only the header will be shown in the spamcopy.<br />
  The scoring value is the sum of all valences(weights) of all found bombs - bombValencePB .',undef,undef,'msg004470','msg004471'],
['bombSenderRe','Envelope Blocking Regular Expression **',80,\&textinput,'^\*|emailserver3\.com|\d\d\d\d\d\d\@tom\.com','(.*)','ConfigCompileRe',
  'Part of DoBombHeaderRe: regular expression to identify sender (mailfrom, ip and helo only). CIDR or range definitions for the IP will NOT work here!',undef,undef,'msg004480','msg004481'],
['bombHeaderRe','Regular Expression to Identify Spam in Header Part**',80,\&textinput,'file:files/bombheaderre.txt','(.*)','ConfigCompileRe',
  'Part of DoBombHeaderRe: header will be checked against this Regex if DoBombHeaderRe is enabled. For example<br />
  file:files/bombheaderre.txt',undef,undef,'msg004490','msg004491'],
['bombSubjectRe','Regular Expression to Identify Spam in Subject**',80,\&textinput,'','(.*)','ConfigCompileRe','Part of DoBombHeaderRe : the mail MIME decoded subject header will be checked against this Regex if DoBombHeaderRe is enabled. If DoBombHeaderRe is enabled, the mail subject will be automatically checked against <a href="https://tools.ietf.org/html/rfc2047" rel="external">RFC2047</a> (for NON printable characters in the undecoded MIME content).',undef,undef,'msg004500','msg004501'],
['maxSubjectLength','Maximum allowed Subject Length',20,\&textinput,'200=>100','^(\d+(?:\=\>\d+)?|)$',undef,'If set to a value greater than 0, assp will check the length of the Subject of the mail. If the Subject length exceeds this value, the message score will be increased by \'bombValencePB\' and the string that is checked in \'bombSubjectRe\' will be trunked to this length. It is possible to define a special weight using the syntax \'length=>value\', in this case the defined absolute value will be used instead of \'bombValencePB\' to increase the message score. If the subject is too long and this weight is equal or higher than \'bombMaxPenaltyVal\' no further bomb checks will be done on the subject.',undef,undef,'msg009360','msg009361'],
['bombCharSets','Regular Expression to Identify Foreign Charsets**',60,\&textinput,'charset=(?:BIG5|CHINESEBIG|GB2312|KS_C_5601|KOI8-R|EUC-KR|ISO-2022-JP|ISO-2022-KR|ISO-2022-CN|CP1251|UNKNOWN)','(.*)','ConfigCompileRe','Part of DoBombHeaderRe: header will be checked against this Regex if DoBombHeaderRe is enabled. The literal UNKNOWN will detect all wrong defined MIME character sets.<br />
  Part of DoBombRe : every MIME-part header will be checked against this Regex if DoBombRe is enabled.<br />
 For example:<br />
 charset=(?:BIG5|CHINESEBIG|GB2312|KS_C_5601|KOI8-R|EUC-KR|ISO-2022-JP|ISO-2022-KR|ISO-2022-CN|CP1251|UNKNOWN). ',undef,undef,'msg004510','msg004511'],
['bombHeaderReMaxHits','Maximum Hits for Bombs in Header and Sender',3,\&textinput,1,'(\d*)',undef,'A hit is a found Bomb in header and sender - bombSenderRe , bombHeaderRe , bombSubjectRe , bombCharSets .<br />
  If the number of hits is greater or equal Maximum Hits, the email is flagged <b>Failed</b> (possibly blocked and/or scored).<br />
  If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>Neutral</b> (possibly scored)',undef,undef,'msg004520','msg004521'],
['DoBombRe','Use Bomb Regular Expressions','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(\d*)',undef,
  'If activated, each message is checked against bombRe and bombDataRe Regular Expressions.<br />
  The scoring value is the sum of all valences(weights) of all found bombs - bombValencePB .',undef,undef,'msg004530','msg004531'],
['bombRe','Regular Expression for Header and Data Part**',80,\&textinput,'file:files/bombre.txt','(.*)','ConfigCompileRe','Header and Data will be checked against this Regular Expression if DoBombRe is enabled.  For example:<br />
 IMG [^&gt;]*src=[\'&quot;]cid|&lt;BODY[^&gt;]*&gt;(&lt;[^&gt;]+&gt;|\n|\r)*&lt;IMG[^&gt;]+&gt;(&lt;[^&gt;]+&gt;|\n|\r)*&lt;/BODY&gt;<br />
 This regular expression is checked against the MIME and HTML decoded mail content.<br />
 If you want to search for attachment names, define a line with \'attachment:the_attachment_name\'.',undef,undef,'msg004540','msg004541'],
['bombSkipHeaderTagRe','Regular Expression to Identify skipped Tags in Header Part*',80,\&textinput,'file:files/bombskipheadertagre.txt','(.*)','ConfigCompileRe',
  'Regular Expression to define header tags, that will be skipped for bombSuspiciousRe, bombHeaderRe, bombRe and blackRe - like \'DKIM-Signature|Domainkey-Signature\' - the always followed collon (:) is added by assp. For example<br />
  file:files/bombskipheadertagre.txt',undef,undef,'msg009980','msg009981'],
['bombReMaxHits','Maximum Hits for Bombs in Header and Data',3,\&textinput,1,'(\d*)',undef,'A hit is a found Bomb in header and data - bombRe .<br />
  If the number of hits is greater or equal Maximum Hits, the email is flagged <b>Failed</b> (possibly blocked and/or scored).<br />
  If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>Neutral</b> (possibly scored)',undef,undef,'msg004550','msg004551'],
['bombDataRe','BombData Regular Expression for Data Part**',80,\&textinput,'','(.*)','ConfigCompileRe','Data part will be checked against the Regular Expression  if DoBombRe is enabled. For example:<br />
 IMG [^&gt;]*src=[\'&quot;]cid|&lt;BODY[^&gt;]*&gt;(&lt;[^&gt;]+&gt;|\n|\r)*&lt;IMG[^&gt;]+&gt;(&lt;[^&gt;]+&gt;|\n|\r)*&lt;/BODY&gt;<br />
 This regular expression is checked against the MIME and HTML decoded mail body (like bombRe) - and against the only MIME decoded mail body with removed line endings (=\n).<br />
 If you want to search for attachment names, define a line with \'attachment:the_attachment_name\'.',undef,undef,'msg004560','msg004561'],
['bombDataReMaxHits','Maximum Hits for Bombs in Data',3,\&textinput,1,'(\d*)',undef,'A hit is a found Bomb in data - bombDataRe .<br />
  If the number of hits is greater or equal Maximum Hits, the email is flagged <b>Failed</b> (possibly blocked and/or scored).<br />
  If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>Neutral</b> (possibly scored)',undef,undef,'msg004570','msg004571'],
['bombSuspiciousRe','Suspicious Expression for Scoring Only**',80,\&textinput,'','(.*)','ConfigCompileRe','Sender, Header and Data will be checked for scoring only. Put here anything which might be suspicious. bombSuspiciousValencePB will be used to increase the score.<br />
  For example:<br />
  unsubscribe<br /><br />
  <b>NOTICE: BombSuspiciousRe is processed per default for all mails (incoming and outgoing) regardless of noprocessing and whitelisting! Only noBombScript is observed in every case.</b><br />
  To change this behavior, use the enhanced regular expression syntax (NWIL) described at the bottom of the GUI!',undef,undef,'msg004580','msg004581'],
['noBombScript','Don\'t Check Messages from these Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Don\'t detect spam bombs or scripts in messages from these addresses. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).',undef,undef,'msg004590','msg004591'],
['DoTestRe','Do Test Regular Expression',0,\&checkbox,0,'(.*)',undef,
  'If activated, each message is checked  against the Test Regular Expression below. This provides a way to test regex strings on live mail.',undef,undef,'msg004600','msg004601'],
['testRe','Test Regular Expression**',80,\&textinput,'','(.*)','ConfigCompileRe','Use this to test your regular expressions. Test valence is teValencePB .',undef,undef,'msg004610','msg004611'],
['bombError','Spam Bomb Error',80,\&textinput,'554 5.7.1 Delivery not authorized, message refused -- .','^([245]\d\d .*|)$',undef,
  'SMTP error message to reject spam bombs. For example: 554 5.7.1 Delivery not authorized, message refused -- send report to mailto:postmaster@mydomain.tld or call +12.34.56.78.90',undef,undef,'msg004620','msg004621'],
['bombErrorReason','Add Reason',0,\&checkbox,1,'(.*)',undef,
  'Add matching expression to Spam Bomb Error',undef,undef,'msg004630','msg004631'],
['DoBlackRe','Use Black Regular Expression to Identify Spam Strictly','0:disabled|1:block|2:monitor|3:score',\&listbox,0,'(\d*)',undef,
  'Each incoming message ( except acceptAllMail ) is checked  against the BlackRe to Identify Spams. No Optout. <br />
  The scoring value is the sum of all valences(weights) of all found bombs - blackValencePB .',undef,undef,'msg004640','msg004641'],
['blackRe','BlackRe - Regular Expression to Identify Spam Strictly**',80,\&textinput,'file:files/blackre.txt','(.*)','ConfigCompileRe',
  'If an incoming email ( except acceptAllMail ) matches this Perl regular expression it will be strictly considered spam . For example: \breplica watches\b|\bMegaDik\b|\bcock\b|\bpenis\b|\bpills\b|\bOriginal Viagra\b|\bbetter sex life\b|\baverage penis\b|\benlargement\b|\borgasm\b|\berections\b|\bViagra\b|\bbig dick\b|\bsperma\b|\bSexual\b|\bErectionsk\b|\bStamina\b|\bsildenafil\b|\bcitrate\b|\bErectile\b',undef,undef,'msg004650','msg004651'],
['blackReMaxHits','Maximum Hits for Identify Spam Strictly',3,\&textinput,1,'(\d*)',undef,'A hit is a found Bomb for Identify Spam Strictly. - blackRe <br />
  If the number of hits is greater or equal Maximum Hits, the email is flagged <b>Failed</b> (possibly blocked and/or scored).<br />
  If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>Neutral</b> (possibly scored)',undef,undef,'msg004660','msg004661'],

['DoScriptRe','Use Regular Expression to Identify Mobile Scripts','0:disabled|1:block|2:monitor|3:score',\&listbox,0,'(\d*)',undef,
  'Each message is checked  against the Expression to Identify Mobile Scripts.<br />
  The scoring value is the sum of all valences(weights) of all found bombs - scriptValencePB .',undef,undef,'msg004670','msg004671'],
['scriptRe','Regular Expression to Identify Mobile Scripts**',80,\&textinput,'','(.*)','ConfigCompileRe',
  'Spam mails may contain mobile scripting code, eg activex and java or php. You can use this feature to block those messages.<br />
  Leave this blank to disable the feature. For example:<br />
  \&lt;applet|\&lt;embed|\&lt;iframe|\&lt;object|\&lt;(?:no)?script|\&lt;?php|onmouseover|onmouseout|onload|onfocus|onblure|onhover|onpageload|onpageshow|onclick|javascript:',undef,undef,'msg004680','msg004681'],
['scriptReMaxHits','Maximum Hits for Identify Mobile Scripts',3,\&textinput,1,'(\d*)',undef,'A hit is a found mobile scripting code for Identify Mobile Scripts - scriptRe .<br />
  If the number of hits is greater or equal Maximum Hits, the email is flagged <b>Failed</b> (possibly blocked and/or scored).<br />
  If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>Neutral</b> (possibly scored)',undef,undef,'msg004690','msg004691'],

['scriptError','Script Error',80,\&textinput,'554 5.7.1 Your email contains html scripting code -- please resend as plain text.','^([245]\d\d .*|)$',undef,
  'SMTP error message to reject scripts. For example: 554 5.7.1 Your email appears to be spam -- send an error report to mailto:postmaster@mydomain.tld or call +12.34.56.78.90
  <br /><hr /><div class="cfgnotes">Notes On Bomb Regex</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/bombre.txt\',3);" />',undef,undef,'msg004700','msg004701'],

[0,0,0,'heading','Hidden Markov Model and Bayesian Options <a href="https://sourceforge.net/p/assp/wiki/ASSP_Bayesian_Filter" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Theory of Operation" /></a>'],
['DoBayesian','Bayesian Check <a href="https://sourceforge.net/p/assp/wiki/General_ASSP_Questions" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Theory of Operation" /></a>','0:disabled|1:block|2:monitor|3:score',\&listbox,0,'(.*)',undef,
  'If activated, the message is checked based on Bayesian factors in spamdb for global and private entries. Private spamdb entries have a five times higher weight than global entries. This needs a fully functional spamdb built by rebuildspamdb. For starters it is best practice to put this inactive and build the spamdb collection with the help of DNSBL ,URIBL and spamaddresses. Scoring is done with baysValencePB for external mails, bayslocalValencePB is used for outgoing and internal mails - both values are multiplied with the detected baysProbability . It is possible to score (in and out) with a bonus for HAM with bayshamValencePB ( bayshamValencePB * ( 1 - baysProbability )).<br />
  Both, the Bayesian-check and the Hidden-Markov-Model-check (below), are using Perl version depending <a href=\"http://unicode.org/charts/\" rel=\"external\">Unicode</a> features to recognize any possible character. How ever, some east asian languages (and some others) have graphemes, that contains multiple <a href=\"http://en.wikipedia.org/wiki/Unicode\" rel=\"external\">unicode code points</a>. If you need (or want) assp to process all text as a sequence of <a href=\"http://unicode.org/reports/tr29/\" rel=\"external\">UAX #29 Grapheme Clusters</a>, the Perl module <a href=\"http://metacpan.org/search?q=Unicode::LineBreak/\" rel=\"external\">Unicode::LineBreak</a> is required.',undef,undef,'msg004710','msg004711'],
['DoHMM','Hidden Markov Model Check <a href="https://sourceforge.net/p/assp/wiki/General_ASSP_Questions/#Theory_of_Operation" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Theory of Operation" /></a>','0:disabled|1:block|2:monitor|3:score',\&listbox,0,'(.*)',undef,
  "If activated, the message is checked based on a <a href=\"http://en.wikipedia.org/wiki/Hidden_Markov_model\">Hidden Markov Model</a>  for global and private entries.  Private HMM entries have a five times higher weight than global entries. This needs a fully functional HMMdb database built by rebuildspamdb. For starters it is best practice to put this in monitoring mode and build the HMM collection with the help of DNSBL ,URIBL and spamaddresses. Scoring is done with HMMValencePB for external mails, HMMlocalValencePB is used for outgoing and internal mails - both values are multiplied with the detected hmmProbability. It is possible to score (in and out) with a bonus for HAM with HMMhamValencePB ( HMMhamValencePB * ( 1 - baysProbability )).<br />
  The perl module <a href=\"http://metacpan.org/search?q=BerkeleyDB/\" rel=\"external\">BerkeleyDB</a> version 0.34 or higher and BerkeleyDB version 4.5 or higher is required (to store temporary data) to use this feature and 'useBerkeleyDB' must be set to ON.<br />
  If this option is disabled, the rebuildspamdb task will <b>NOT</b> build a valid HMM database!<br />
  Compared to the Bayesian option, the Hidden Markov Model will produce results that are much more exact. How ever, it is possible, that HMM gets no result on very small messages, for this reason it is recommended to use both Bayesian and HMM. If you enable both checks, check your settings for baysValencePB, HMMValencePB, bayslocalValencePB and HMMlocalValencePB - eg. divide them by 2. or set the bayes values to 1/3 and the HMM values to 2/3.<br />
  NOTICE that using this option requires a <b>very fast database server</b> behind, if HMMusesBDB is set to OFF. The Bayesian- and HMM check together can produce <b>4000 and much more SQL queries per second</b>.<br />
  Keep in mind, that all backups and exports of the HMM database could require several 100MB of diskspace, if the file count in the corpus is very large.",undef,undef,'msg001230','msg001231'],
['BayesAfterHMM','Do Bayesian depends on HMM results',20,\&textinput,'','^(0?\.\d+[^\d\.]+0?\.\d+|)$',undef,
  'This value is ignored, if DoHMM is not enabled or set to monitor or DoBayesian is disabled.<br />
  The Bayesian check will only run, if the spam/ham probability of the HMM check is in a given value range or the HMM check has given too few results or the confidence ( baysConf ) of the detection is too low.<br />
  Leave this blank to run the Bayesian check every time, independent from any HMM result (default).<br />
  To set this value, define a probability value range like 0.4-0.6 or 0.3-0.7 - eg: best set it according to the setting of baysProbability ( [ 1 - baysProbability ]-baysProbability ).',undef,undef,'msg010130','msg010131'],
['ignoreDBVersionMissMatch','Ignore a database version missmatch','0:disabled|1:Spamdb|2:HMMdb|3:Spam and HMMDB',\&listbox,0,'(.*)',undef,
  'The status of assp is changed to "not healthy" if the current version of any of Spamdb or HMMdb is not equal to the required database version. Such a missmatch is automatically corrected with the next successful rebuildspamdb. How ever, if you are unable to solve this problem for any reason, you should set this value to keep the status of assp "healthy".',undef,undef,'msg009940','msg009941'],
['HMMusesBDB','Use BerkeleyDB for the Hidden Markov Model database',0,\&checkbox,1,'(.*)',undef,"If enabled (default), the Hidden Markov Model database uses BerkeleyDB - notice: in this case no database import, backup or export are provided for the HMMdb. This value is completely ignored, if DBdriver is set to 'BerkeleyDB' and spamdb is set to 'DB:'. Switch this parameter to OFF, if you want to use the same database engine for the HMMdb like spamdb is configured. <br />
  <span class=\"negative\">Changing this value requires a restart of assp. Possibly a forced rebuildspamdb is required after the restart.</span>",undef,undef,'msg001240','msg001241'],
['DoPrivatSpamdb','Use also private entries for the Bayesian Spamdb and Hidden Markov Model databases','0:NO|1:for users only|2:for domains only|3:for users and domains',\&listbox,3,'(.*)','ConfigChangeDoPrivatSpamdb','If enabled, private entries (based on the local recipient and/or the report sender email address) will be added to the Bayesian and HMM databases. These private entries have a three times higher priority for users (full email address) and two times higher priority for domains (domain part of the email address) than global entries. To enable this option "spamdb" must be set to use a database "DB:" first!<br />
 <b>Setting this option to ON, will increase the record count for the spamdb and the HMM databases dramaticaly!</b>',undef,undef,'msg009630','msg009631'],
['BayesMaxProcessTime','Bayesian and HMM Check Timeout ',3,\&textinput,'15','(\d+)',undef,'The Bayesian- and HMM checks are the most memory and CPU consuming tasks that ASSP is doing on a message. If such tasks running to long on one message, other messages could run into SMTPIdleTimeout. Define here the maximum time in seconds that ASSP should spend on Bayesian Checks for one message. Default is 15.',undef,undef,'msg004720','msg004721'],
['BayesWL','Bayesian/HMM Check on Whitelisted NON Local Senders/Messages',0,\&checkbox,'','(.*)',undef,'If enabled, the Bayesian/HMM check is done on whitelisted NON local senders/messages.',undef,undef,'msg006120','msg006121'],
['BayesNP','Bayesian/HMM Check on NoProcessing Messages',0,\&checkbox,'','(.*)',undef,'If enabled, the Bayesian/HMM check is done on NoProcessing messages.',undef,undef,'msg007420','msg007421'],
['BayesLocal','Bayesian/HMM Check on Local Senders',0,\&checkbox,'','(.*)',undef,'If enabled, the Bayesian/HMM check is done on local and outgoing messages',undef,undef,'msg010360','msg010361'],
['noBayesian','Skip Bayesian and HMM Check*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Mail from/to any of these addresses are ignored by Bayesian- and HMM check, mails will not be stored in spam/notspam collection. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com)',undef,undef,'msg004730','msg004731'],
['noBayesian_local','Skip Bayesian and HMM Check for this local senders*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Mail from any of these local addresses are ignored by Bayesian- and HMM checks, mails will not be stored in spam/notspam collection. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com)',undef,undef,'msg009570','msg009571'],
['Bayesian_localOnly','Do Bayesian and HMM Check ONLY for this local senders*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Only mail from any of these local addresses are processed by the Bayesian- and HMM checks, except they are also defined in noBayesian_local . BayesLocal must be switched on to make this option working. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com)',undef,undef,'msg009010','msg009011'],
['maxBayesValues','Maximum most significant results used per mail to calculate Bayesian- and HMM-Probability',3,\&textinput,'60','([1-9]\d{2}|[3-9]\d)',undef,'Maximum count of most significant values used to calculate the Bayesian/HMM-Spam-Probability and the confidence of that probability.<br />
 The Bayesian/HMM Spam probability will be fine with 30 and will get more exact, than higher this value is - until a value of 60.<br />
 The confidence of the Bayesian/HMM Spam probability will get better, than higher this value is.<br />
 Values above 60 are possible, but could lead into a performance penalty, without getting a better spam detection.<br />
 If the HMM check gets less than ( maxBayesValues / 3 + 1 ) results, the HMM check is set to scoring for the mail.<br />
 If the HMM check gets less than ( maxBayesValues / 12 + 1 ) results, the HMM check is set to monitoring for the mail.<br />
 Default is \'60\', minimum is \'30\'.',undef,undef,'msg007890','msg007891'],
['baysProbability','Bayesian and HMM Probability Threshold ',3,\&textinput,'0.6','(0\.\d+)',undef,' Messages with spam-probability below or equal this threshold are considered Ham. Recommended \'0.6\'. If you change this value, check your setting of BayesAfterHMM .<br />
 A resulting Spam-Probability above this value is multiplied with baysValencePB_local or baysValencePB to get the penaltybox scoring value for the IP- and message score. In other words, the penaltybox scoring value is weighted by the Spam-Probability in case Spam is detected.<br />
 A resulting Spam-Probability below this value but higher than ( 1 - baysProbability ) is stated as \'UNSURE\' . In this case the half score will be added to the message score but not to the IP score and the message will not be blocked.<br /><br />
 The following default Bayesian math (prob = p1 / (p1 + p2)) is used to calculate the SpamProb value for \'n\' found Bayesian-Word-Pairs or HMM-Sequences, each with a spam-weight \'p\' - where 0&lt;p&lt;1 :<br /><br />
 \'SpamProb\' = (p<sub>1</sub> * p<sub>2</sub> * ... * p<sub>n</sub>) / ( p<sub>1</sub> * p<sub>2</sub> * ... * p<sub>n</sub>  + (1 - p<sub>1</sub>) * (1 - p<sub>2</sub> ) * ... * (1 - p<sub>n</sub>))<br />',undef,undef,'msg004740','msg004741'],
['baysConf','Bayesian and HMM Confidence Threshold',3,\&textinput,'0','(0*\.\d+|0+|)',undef,' Spam-Mails having a confidence below this threshold are passed in TestMode .
 Spam-Mails having a confidence above this threshold are blocked. Set this only above 0 if you are familiar with the bayesian statistics used in ASSP.<br />
 Messages that are processed by the bayesian and HMM check get a spam-probability score and a confidence score. The confidence score in assp is a quality indicator. A confidence near 0 would mean the probability score is like a wild guess. A confidence score near 1 would mean that it\'s pretty sure that the bayesian analysis result is correct. The confidence threshold is an allowance to process a Bayesian/HMM Spam as-if in Bayesian TestMode, if the message\'s *confidence* score is lower than the confidence threshold.
 Set this level to a specfic value, let\'s say .001 (which is a good one for starting), then:<br />
 - messages with spam-probability higher than 0.6 and a confidence of less than 0.001 would come through as in test mode<br />
 - messages with spam-probability higher than 0.6 and a confidence of more than 0.001 would be blocked<br />
 - messages with spam-probability less than 0.6 would pass<br />
 The 0.6 threshold can be set in baysProbability .<br />
 The confidence of the probability value is also used in BayesAfterHMM.<br />
 Carefully set this parameter above 0, if the bayesian corpus norm (shown by the rebuildspamdb log) is less than 0.6 or higher than 1.4 .<br /><br />
 The following math is used to calculate the SpamProbConfidence value for \'n\' found Bayesian-Word-Pairs or HMM-Sequences doing \'q\' database queries, each result with a spam-weight \'p\' - where 0&lt;p&lt;1 :<br /><br />
 extreme_confidence_count = |(0 &lt; p<sub>1...n</sub> &lt; 0.01)| - |(0.99 &lt; p<sub>1...n</sub> &lt; 1)|<br />
 extreme_confidence_count = 0 - if ( extreme_confidence_count &lt; 0 and SpamProb &gt; 0.5) or ( extreme_confidence_count &gt; 0 and SpamProb &lt;= 0.5) == TRUE; <br />
 extreme_confidence_count = abs( extreme_confidence_count )<br />
 mail_confidence = abs((P<sub>1</sub> * P<sub>2</sub> * ... * P<sub>k</sub>) - ((1 - P<sub>1</sub>) * ( 1 - P<sub>2</sub> ) * ... * (1 - P<sub>k</sub>))) - for all elements P<sub>1...k</sub> in (0.01 &lt; p<sub>1...n</sub> &lt; 0.99)<br />
 corpus_confidence = 1 / ((abs(1 - corpus_norm) + 1)<sup>int(abs(1 - corpus_norm) * 10)</sup>) - the exponent is limited to a maximum of 4<br />
 q = max( n , min( q , maxBayesValues ))<br />
 SpamProbConfidence = 0.01<sup>extreme_confidence_count</sup> * mail_confidence * corpus_confidence * ( n / q )<sup>2</sup><br /><br />
 The SpamProbConfidence is limited to a maximum of 1.0 . <br />
 All extreme values \'p\' having a spam weight less than 0.01 or higher than 0.99 with a corresponding extreme value like (0.001 &lt;-&gt; 0.999) are ignored for the mail_confidence calculation.<br /><br />
 <span class="negative"> empty or zero = disabled</span>.<br /><br />
 <a href="./confgraph" target=_blank><img height=12 width=12 src="' . $wikiinfo . '" alt="confidence" /> Show the Bayesian and Hidden-Markov-Model confidence distribution!</a>' ,undef,undef,'msg004750','msg004751'],
['baysConfidenceHalfScore','Reduce Scoring for Low Confidence',0,\&checkbox,1,'(.*)',undef,
 'Spam-Mails having a confidence below the threshold, will get half of the normal penalty score for Bayesian and HMM hits.',undef,undef,'msg004760','msg004761'],
['AddSpamProbHeader','Add Bayes and HMM Probability Header',0,\&checkbox,'','(.*)',undef,
 'Adds a line to the email header "X-Assp-Spam-Prob: 0.0123" and/or "X-Assp-HMM-Spam-Prob: 0.0123" Probability ranges from 0 to +1 where &gt; 0.6 = spam.',undef,undef,'msg004780','msg004781'],
['AddConfidenceHeader','Add Bayes and HMM Confidence Header',0,\&checkbox,'','(.*)',undef,
  'Adds a line to the email header "X-Assp-Bayes-Confidence: 0.0123" and/or "X-Assp-HMM-Confidence: 0.0123".<br /><hr />
  <div class="cfgnotes">Notes On Bayesian</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/bayesian.txt\',3);" />',undef,undef,'msg004790','msg004791'],

[0,0,0,'heading','Outgoing Message Tagging, NDR Validation and Backscatter Detection'],
['DoMSGIDsig','Do Message-ID Tagging and Validation (FBMTV)','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,0,'(\d*)',undef,
 'If activated, the message-ID of each outgoing message will be signed with a unique Tag and every incoming mail will be checked against this Tag. This tagging mode is called FBMTV "Forwarder(s) Bounce Message-ID Tag Validation" and it is worldwide unique to ASSP. This Tag is build nearly the same way, as BATVTag is build for the sender address. This Tag will be removed from any incoming email, to recover the original references in the mail header! If anything is changed on this option inside the mail, no DKIM-check will be done! Before activating DoMSGIDsig, please configure MSGIDpreTag and MSGIDsec !<br />
  If activated and a bounced mail from null sender or postmaster contains no valid signature the configured action is taken.<br />
  This check requires an installed <a href="http://metacpan.org/search?q=Digest::SHA1" rel="external">Digest::SHA1</a> module in Perl.',undef,undef,'msg004800','msg004801'],
['MSGIDpreTag','Message-ID pre-Tag for MSGID-TAG-generation',10,\&textinput,'sig','([a-zA-Z0-9]{2,5})',undef,'To use Message-ID signing and to create the MSGID-Tags, a pre-Tag is needed. This Tag must be 2-5 characters [a-z,A-Z,0-9] long. Default is \'sig\'.',undef,undef,'msg004810','msg004811'],
['MSGIDSec','Message-ID Secrets for MSGID-TAG-generation*',80,\&textinput,'0=key0|1=key1|2=key2|3=key3|4=key4|5=key5|6=key6|7=key7|8=key8|9=key9','(\S*)','configChangeMSGIDSec','To use Message-ID signing and to generate the MSGID-Tags, at leased one secret key is needed, up to ten keys are possible.<br />
  The notation is : generationnumber[0-9]=secretKey. For example<font color=red>(do not use!)</font>: 0=jk09Z|1=oPLmn4g|....   . Multiple pairs are separated by pipes (|). Default is  0=key0|1=key1|2=key2|3=key3|4=key4|5=key5|6=key6|7=key7|8=key8|9=key9 . Do not defines spaces, tabs and \'=\' as part of the keys(secrets)! <br />
  <font color=red>Values that contains any default are not valid, please change them, to prevent detecting strange ASSP-signatures as valid local signatures!</font><br />For this reason, please define your secrets as unique as possible! The secrets are used randomly to build the Message-ID-Tags.',undef,undef,'msg004820','msg004821'],
['MSGIDsigAddresses','Do FBMTV For These Addresses Only*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Mail to any of these addresses will be tagged and checked by FBMTV. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). If empty, FBMTV is done for all addresses.',undef,undef,'msg004830','msg004831'],
['noMSGIDsigRe','Skip Message-ID signing, mail content dependent*',80,\&textinput,'','(.*)','ConfigCompileRe','Use this to skip the Message-ID tagging depending on the content of the email. If the content of the email matches this regular expression (checking MaxBytes only), FBMTV will not be done. For example: \'I am out of office\' .',undef,undef,'msg008900','msg008901'],
['noRedMSGIDsig','Skip Message-ID signing for Redlisted mails',0,\&checkbox,'0','(.*)',undef,'If selected, FBMTV will not be done for redlisted emails!',undef,undef,'msg008910','msg008911'],
['MSGIDsigProc','Process valid Message-ID Signed Mails','0:normal|1:whitelisted|2:noprocessing|3:whitelisted and noprocessing',\&listbox,1,'(\d*)',undef,
 'How are received mails processed, if they contain a valid local MessageID-Signature/Tag (eg. because it is an answer/reply to a tagged mail).<br />
 The default value is \'whitelisted\'. Notice that noprocessing and/or whitelisted may prevent those mails from being collected in the corpus folders - check noProcessingLog and NonSpamLog.',undef,undef,'msg010630','msg010631'],
['DoBATV','Do BATV Tagging and Validation','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,0,'(\d*)',undef,'If enabled any sender address of outgoing mails is mangled with a <a href="http://en.wikipedia.org/wiki/Bounce_Address_Tag_Validation" rel="external">BATV-Tag</a>. Any incoming bounced mail is checked for a valid BATV-Tag. All valid (local) BATV-Tags will be removed from incoming mails - so whitelisting, delaying and all other recipient and sender based checks will use the normal addresses. If the BATV-check is successful, no MSGID-signing-check and DNS-Backscatter-check will be done! If any BATVTag was removed, no DKIM-check will be done! BATV-address-replacement is done, before the recipient replacement rules are processed!<br />
  <b>NOTICE:</b> Switch off all BATV-tagging on local MTA\'s before you enable this option!<br />
  This check requires an installed <a href="http://metacpan.org/search?q=Digest::SHA1" rel="external">Digest::SHA1</a> module in Perl.',undef,undef,'msg004840','msg004841'],
['BATVSec','BATV Secrets for BATV-TAG-generation*',80,\&textinput,'0=key0|1=key1|2=key2|3=key3|4=key4|5=key5|6=key6|7=key7|8=key8|9=key9','(\S*)','configChangeBATVSec','To use <a href="http://en.wikipedia.org/wiki/Bounce_Address_Tag_Validation" rel="external">BATV</a> and to create the BATV-Tags, at leased one secret key is needed, up to ten keys are possible.<br />
  The notation is : generationnumber[0-9]=secretKey. For example: 0=key0|1=KEYX45rt|....   . Multiple pairs are separated by pipes (|). Default is  0=key0|1=key1|2=key2|3=key3|4=key4|5=key5|6=key6|7=key7|8=key8|9=key9 . Do not defines spaces, tabs and \'=\' as part of the keys(secrets)! The secrets are use randomly to build the BATV-Tags.',undef,undef,'msg004850','msg004851'],
['removeBATVTag','remove strange BATV-Tags from incoming mails',0,\&checkbox,'0','(.*)',undef,'Any strange BATV-signature will be removed from the sender address and the real sender address will be used! Using this together with remindBATVTag keeps your clients addressbooks (also whitelist, delaydb ...) clean from BATV-Tags. This will also work, if DoBATV is disabled. If you do not use remindBATVTag and the MTA behind ASSP sends a bounced mail back - this mail will fail on BATV on the recipients site. If any BATVTag was removed, no DKIM-check will be done!',undef,undef,'msg004860','msg004861'],
['remindBATVTag','store incoming strange BATV-Tags to remind them for outgoing bounce mails',0,\&checkbox,'0','(.*)',undef,'If defined, any incoming stange BATV-signature will be stored and any recipient of outgoing bounce mails will be checked against this list. If there is found a valid (not older than 7 days) BATV-Tag for that recipient, it will be mangled into the recipient address. This will also work, if DoBATV is disabled.',undef,undef,'msg004870','msg004871'],
['DoBackSctr','Do DNS-Backscatter Detection','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,0,'(\d*)',undef,
  'If activated, the IP-address of each message received for null sender,bounced or postmaster will be checked against the list below.
   DNS base checks requires an installed <a href="http://metacpan.org/search?q=Net::DNS" rel="external">Net::DNS</a> module in Perl.<br />
   For more information about backscatter detection please read <a href="http://www.backscatterer.org/?target=usage" rel="external">http://www.backscatterer.org/?target=usage</a>.',undef,undef,'msg004880','msg004881'],
['BackDNSInterval','Backscatter-DNS Cache Refresh Interval',4,\&textinput,7,'(\d+\.?\d*|)','configUpdateBDNSCR','IP\'s in cache will be removed after this interval in days. 0 will disable the cache and the usage of downloadBackDNSFile and localBackDNSFile. <input type="button" value=" Show Backscatter-DNS Cache" onclick="javascript:popFileEditor(\''.$newDB.'pb/pbdb.back.db\',5);" />',undef,undef,'msg004890','msg004891'],
['BackSctrServiceProvider','ServiceProvider for Backscatterer Detection*',60,\&textinput,'ips.backscatterer.org','(.*)','configUpdateBACKSctrSP',
  'ServiceProvider for DNS check on Backscatterer. Possible value is ips.backscatterer.org for DNS check.',undef,undef,'msg004900','msg004901'],
['downloadBackDNSFile','Download the Backscatterer DNS-IP-List',0,\&checkbox,'0','(.*)',undef,'If selected, the complete IP-list is downloaded to a local file. If useDB4IntCache is set, the list is stored in a BerkeleyDB database (BackDNS2). Otherwise the records will be stored in the pbdb cache BackDNS . The download will be skipped, if useDB4IntCache is not set and mysqlSlaveMode is set. IP\'s are checked on this file first, if the IP is not found on this list, a DNS query is done. It is recommended to use this option for ISP\'s and users with more than 1000 bounced mails a day. See wget-mirrors.uceprotect.net/rbldnsd-all/ips.backscatterer.org.gz',undef,undef,'msg004910','msg004911'],
['localBackDNSFile','Local File for the Backscatterer DNS-IP-List',0,\&textinput,'file:files/backdnslist.txt','(\s*file\s*:\s*.+|)',undef,'The name of the local file that is used for this IP-list. The content of this file is filled into the \'Backscatter-DNS Cache\' ( BackDNSInterval ). IP\'s from this list will be removed after one day from the cache.
  <hr /><hr /><font color=red>The following configurations are valid for all Backscatter Detection Options!</font><hr />',undef,undef,'msg004920','msg004921'],

['Back250OKISP','Send 250 OK to ISP if any Backscatter Detection fails',0,\&checkbox,'0','(.*)',undef,'If any Backscatter check fails for a bounced mail that is coming from an ISPIP, ASSP will send "250 OK" to the ISP, but will discard the mail, if the check is configured to block!',undef,undef,'msg004930','msg004931'],
['BackWL','Do Backscatter Detection checks for Whitelisted mail',0,\&checkbox,'','(.*)',undef,'Tagging will be always done, if not excluded by address or domain!',undef,undef,'msg004940','msg004941'],
['BackNP','Do Backscatter Detection checks for No Processing mail',0,\&checkbox,'','(.*)',undef,'Tagging will be always done, if not excluded by address or domain!',undef,undef,'msg004950','msg004951'],
['noBackSctrRe','Regular Expression to Skip all BackScatter Checks*',80,\&textinput,'','(.*)','ConfigCompileRe',
  'If the contents of a mail matches these regular expressions, all BackScatter checks will be skipped.',undef,undef,'msg009240','msg009241'],
['noBackSctrAddresses','Do not any Backscatter detection for this Addresses *',80,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Mail to and from any of these addresses will not be tagged and checked by any backscatter option. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).<br />
 Notice: backscatter checks are skipped for regular incoming mails (not matching redRe) for local postmaster@ and webmaster@ addresses, even these addresses are listed in BounceSenders.',undef,undef,'msg004960','msg004961'],
['noBackSctrIP','Exclude these IP\'s from any Backscatter detection*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','Enter IP\'s that you want to exclude from FBMTV and Backscatter check, separated by pipes (|). <br />
  <hr /><div class="cfgnotes">Notes On Backscatter Detection</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/backscatter.txt\',3);" />',undef,'7','msg004970','msg004971'],

[0,0,0,'heading','TestModes and SPAM Tagging'],
['spamSubject','Prepend Spam Subject <a href="https://sourceforge.net/p/assp/wiki/Getting_Started/#Rebuild_your_Bayesian_database."><img src="' . $wikiinfo . '" alt="TestMode" /></a>',20,\&textinput,'','(.*)',undef,'Setting a filter to testmode will tell ASSP not to reject the mail but rather build up the whitelist and spam and notspam collections. This can go on for some time without disturbing normal operation. After this very important phase TestMode can be used to tag the message: if TestMode and the message is spam Spam Subject gets prepended to the subject of the email. For example: [SPAM]','Basic',undef,'msg004980','msg004981'],
['spamTag','Prepend Spam Tag',0,\&checkbox,'','(.*)',undef,'If checked, the method(s) ASSP used which caught the spam will be prepended to the subject of the email. For example; [DNSBL]','Basic',undef,'msg004990','msg004991'],
['allTestMode','All Test Mode ON',0,\&checkbox,'','(.*)',undef,'Turn all of the individual testmodes on - regardless of the individual test mode settings. ',undef,undef,'msg005000','msg005001'],
['baysTestMode','Bayesian/Hidden-Markov-Model Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005010','msg005011'],
['baysTestModeUserAddresses','Bayesian/HMM Test Mode User Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe','These users are in test mode / mark subject only for bayesian spam, even with test mode above off','Basic',undef,'msg005020','msg005021'],
['blTestMode','BlackDomain Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005030','msg005031'],
['hlTestMode','Helo Blacklist Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005040','msg005041'],
['flsTestMode','Forged Local Domain Test Mode',0,\&checkbox,'','(.*)','','-> DoNoValidLocalSender',undef,undef,'msg005050','msg005051'],
['spfTestMode','SPF Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005060','msg005061'],
['rblTestMode','DNSBL Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005070','msg005071'],
['attachTestMode','Bad Attachment Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005080','msg005081'],
['uriblTestMode','URIBL Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005090','msg005091'],
['srsTestMode','SRS Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005100','msg005101'],
['bombTestMode','Bomb Regex Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005110','msg005111'],
['scriptTestMode','Script Regex Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005120','msg005121'],
['mxaTestMode','Missing MX Record Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005130','msg005131'],
['ptrTestMode','Reversed Lookup Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005140','msg005141'],
['ihTestMode','Invalid Helo Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005150','msg005151'],
['fhTestMode','Forged Helo Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005160','msg005161'],
['msTestMode','Message Scoring Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005170','msg005171'],
['dkimTestMode','DKIM Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005180','msg005181'],
['pbTestMode','Penalty Box Test Mode',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg005190','msg005191'],
['switchTestToScoring',"Switch Testmode to Message Scoring",0,\&checkbox,'','(.*)',undef,
 'Put the filter automatically in "Message Scoring" when DoPenaltyMessage is set  (instead of stopping spam processing altogether).<br /><hr /><div class="cfgnotes">Notes On Testmode</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/testmode.txt\',3);" />',undef,undef,'msg005200','msg005201'],


[0,0,0,'heading','Email Interface for Reports and List Control <a href="https://sourceforge.net/p/assp/wiki/How_do_i_use_the_e-mail_interface" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="How do I use the e-mail interface" /></a>'],
['EmailInterfaceOk','Enable Email Interface',0,\&checkbox,1,'(.*)',undef,
  'Checked means that you want ASSP to intercept and parse mail to the following usernames at any localdomains. The domains \'@assp.local\' and \'@assp-nospam.org\'are automatically a local domain and can be used for the email-interface.
  <hr>
  <b>NOTICE:</b> It is possible to define any MIME-header lines in any report file after the first (subject) line. This makes it possible to define MIME encoding and/or charset settings.<br />
  If a definition of MIME encoding and/or charset is found in a report file, assp converts the report from UTF-8 into the defined encodings. <b> Don\'t forget to terminate your MIME-header with an empty line!</b><br /><br />
  It is also possible to include files at any line of such a file, using the following directive<br />
  # include filename<br />
  where filename is the relative path (from '.$base.') to the included file like reports/mime-header.txt (one file per line). The line will be internaly replaced by the contents of the included file!',undef,undef,'msg005210','msg005211'],
['EmailAdminReportsTo','Admin Mail Address',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'If set internal warnings/infos  will be sent to this address. For example: admin@domain.com',undef,undef,'msg005220','msg005221'],
['EmailReportDestination','Email Interface Reports Destination',40,\&textinput,'',$GUIHostPort,undef,
 'Port to connect to when Email Interface or Block reports are send. If blank they go to the main smtpDestination.<br />
  If you need to connect to the EmailReportDestination host using native SSL, write \'SSL:\' in front of the IP/host definition. In this case the Perl module <a href="http://metacpan.org/search?q=IO::Socket::SSL" rel="external">IO::Socket::SSL</a> must be installed and enabled ( useIOSocketSSL ).<br />
  eg 10.0.1.3:1025 SSL:10.0.1.3:465, etc.',undef,undef,'msg005230','msg005231'],
['EmailAdmins','Authorized Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Mail from any of these addresses can add/remove to/from redlist, spamlovers, noprocessing, blacklist. May request an EmailBlockReport for a list of users. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com)',undef,undef,'msg005250','msg005251'],
['EmailInterfaceDomains','Accept Mails (Reports) for these local domains only*',40,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Enable the EmailInterface and BlockReports for these local domains ONLY (NOT RECOMMENDED). If used, you have also to define \'@assp.local\' (if required). If not used, all localdomains and \'@assp.local\' take place ( see EmailInterfaceOk ). Accepts entire domains (@domain.com|domain.com)',undef,undef,'msg010370','msg010371'],
['EmailSenderOK','Accept Mails (Reports) from these external addresses*',40,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Allow these external domains/addresses to report to the email interface (NOT RECOMMENDED). The reply address for the reports must be set to a local one.  By default, ASSP only accepts reports from local or authenticated users. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com)',undef,undef,'msg005260','msg005261'],
['EmailSenderNotOK','Not Authorized Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Mail from any of these addresses are not accepted from Email Interface, except "Help Report", "Analyze Report" and "Block Report/Resend". Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). The user will get informed about the denied request.',undef,undef,'msg005270','msg005271'],
['EmailSenderIgnore','Ignore Not Authorized Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Mail from any of these addresses are not accepted from Email Interface. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). The user will get not informed about the denied request.',undef,undef,'msg009390','msg009391'],
['EmailHelp','Help Address<a href="https://sourceforge.net/p/assp/wiki/Getting_Started/#Instructions_for_use_for_your_end_users." target="ASSPHELP"><img src="' . $wikiinfo . '" alt="doku" /></a>',20,\&textinput,'assphelp','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request for help. Do not put the full address here, just the user part. For example: assphelp',undef,undef,'msg005240','msg005241'],
['EmailSpam','Report Spam Address',20,\&textinput,'asspspam','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a spam report. Do not put the full address here, just the user part.<br />
   For example: asspspam . Use a fake domain like @assp.local or @assp-nospam.org when you send the email- so the full address would be then asspspam@assp.local. <br />
   Emails should be reported as an attachment in a new created email to this address. Nearly every email client will destroy the original MIME header (more or less), if a mail is simply forwarded for reporting. But the complete and unmodified original MIME header as well as the unmodified MIME body are required by assp to process the reports like expected.<br />
   You can send multiple mails as attachments and/or zipped file(s). Each attached email-file must have the extension defined in "maillogExt". In this case only the attachments will be processed. To use this multi-attachment-feature an installed <a href="http://metacpan.org/search?q=Email::MIME" rel="external">Email::MIME</a> module in PERL is needed. It is also possible to send MS-outlook \'.msg\' files (possibly zipped - but attached to a new created mail in every case). To use this MS-outlook-feature in addition an installed <a href="http://metacpan.org/search?q=Email::Outlook::Message" rel="external">Email::Outlook::Message</a> module in PERL is needed.<br />
   Endusers should be provided with folders where agents graps and sends the mail or with buttons or context menu entries in their client software with the report options.<br />
   If ReportLog is set to diagnostic and invalid content is found in a .msg file, the reported .msg file and the converted .msg file (.eml) are stored in the assp/debug folder.','Basic',undef,'msg005280','msg005281'],
['EmailHam','Report Ham (Not-Spam) Address',20,\&textinput,'asspnotspam','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a false-positive report. Do not put the full address here, just the user part.<br />
   For example: asspnotspam . Use a fake domain like @assp.local or @assp-nospam.org when you send the email - so the full address would be then asspnotspam@assp.local. <br />
   Emails should be reported as an attachment in a new created email to this address. Nearly every email client will destroy the original MIME header (more or less), if a mail is simply forwarded for reporting. But the complete and unmodified original MIME header as well as the unmodified MIME body are required by assp to process the reports like expected.<br />
   You can send multiple mails as attachments and/or zipped file(s). Each attached email-file must have the extension defined in "maillogExt". In this case only the attachments will be processed. To use this multi-attachment-feature an installed <a href="http://metacpan.org/search?q=Email::MIME" rel="external">Email::MIME</a> module in PERL is needed. It is also possible to send MS-outlook \'.msg\' files (possibly zipped - but attached to a new created mail in every case). To use this MS-outlook-feature in addition an installed <a href="http://metacpan.org/search?q=Email::Outlook::Message" rel="external">Email::Outlook::Message</a> module in PERL is needed.<br />
   Endusers should be provided with folders where agents graps and sends the mail or with buttons or context menu entries in their client software with the report options.<br />
   If ReportLog is set to diagnostic and invalid content is found in a .msg file, the reported .msg file and the converted .msg file (.eml) are stored in the assp/debug folder.','Basic',undef,'msg005290','msg005291'],
['EmailForwardReportedTo','Email Interface Forward Reports Destination',20,\&textinput,'','^((?:' . $HostPortRe . '(?:\|' . $HostPortRe . ')*)|)$',undef,
 'Host and Port to forward EmailSpam and EmailHam reports to - eg "10.0.1.3:1025".<br />
  If you use more than one assp instance and your users are reporting spam and ham mails to multiple or all of them, but only one (but not this instance) is doing the rebuildspamdb and the corpus folders are not shared between the instances,<br />
  define the "host:port" of the central assp (rebuild-) instance here. Every report to EmailSpam and EmailHam (but only these!) will be forwarded to the defined host(s) and NO other local action will be taken. If the forwarding to all defined hosts fails, the request will be processed locally. To define multiple hosts for failover, separate them by pipe (|).',undef,undef,'msg009930','msg009931'],
['EmailErrorsReply','Reply to Spam/Not-Spam Reports','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailErrorsTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,  '',undef,undef,'msg005300','msg005301'],
['EmailErrorsTo','Send Copy of Spam/Ham-Reports TO',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com<br />',undef,undef,'msg005310','msg005311'],

['EmailErrorsModifyWhite','Combined Spam/Ham Report &amp; Whitelist Check','0:disabled|1:modify whitelist|2:show whitelist',\&listbox,1,'(.*)',undef,
  'If set to \'modify whitelist\' Ham Reports will add email addresses to the Whitelist, Spam Reports will remove addresses from the Whitelist, also a copy of a file in the GUI to correctedspam (remove) and correctednotspam (add) will modify the Whitelist for the found addresses. If set to \'show whitelist\' Spam Reports will show if addresses are whitelisted.','Basic',undef,'msg005320','msg005321'],
['EmailErrorsModifyNoP','Combined Spam Report and NoProcessing Deletion','0:disabled|1:modify noprocessing|2:show noprocessing',\&listbox,1,'(.*)',undef,
  'If set to \'modify noProcessing\' Spam Reports will remove email addresses from noProcessing list. If set to \'show noProcessing\' Spam Reports will show if addresses are on noProcessing list, also a copy of a file in the GUI to correctedspam (remove) and correctednotspam (show) will modify the noProcessing list for the found addresses.','Basic',undef,'msg008790','msg008791'],

['EmailWhitelistAdd','Add to Whitelist Address',20,\&textinput,'asspwhite','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to add addresses to the whitelist. Do not put the full address here, just the user part. <br />
  For example: asspwhite<br />
  If an address is added to whitelist, it will be removed from the Personal Blacklist of the sending user.','Basic',undef,'msg005330','msg005331'],
['EmailWhitelistRemove','Remove from Whitelist Address',20,\&textinput,'asspnotwhite','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to remove addresses from the whitelist. Do not put the full address here, just the user part. <br />
  For example: asspnotwhite<br /><br />
  EmailAdmins and EmailAdminReportsTo are able to force global or domain based removal and deletion requests as well as removal and deletion requests for other users - like:<br /><br />
  sender@domain.org,*<br />
  sender@domain.org,@localdomain.org<br />
  sender@domain.org,otheruser@localdomain.org<br /><br />
  Per default a removal request is processed. To delete records from whitelistdb, write "delete" (unquoted) into the subject of the report mail.<br /><br />
  To remove a global whitelist entry, use sender@senderdomain.org .<br />
  To remove a domain whitelist entry, use sender@senderdomain.org,localdomain.org .<br />
  To remove a private whitelist entry, use sender@senderdomain.org,user@localdomain.org .<br />
  To delete a global whitelist entry and all domain and private entries, use sender@senderdomain.org,* .<br />
  To delete a domain whitelist entry and all private entries, use sender@senderdomain.org,@localdomain.org .<br />
  To delete a private whitelist entry, use sender@senderdomain.org,user@localdomain.org .<br /><br />
  <b>NOTICE: removing whitelist entries will mark the records as NOT whitelisted - the records are NOT delete from the database/list. Wildcards (,*) are ignored for the remove action!</b><br />
  <p class="warning">
  NOTICE: deleting whitelist entries will DELETE ALL related (matching) records! For example: an emailaddress is globaly whitelisted but markted as not whitelisted for a specific domain.
  Now if you DELETE the domain based record, all domain related records will be deleted - but because of the global whitelisting, all emailaddresses from this domain are now treated as whitelisted!</p>','Basic',undef,'msg005340','msg005341'],
['EmailWhitelistReply','Reply to Add to/Remove from Whitelist','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailWhitelistTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,
  '',undef,undef,'msg005350','msg005351'],
['EmailWhitelistTo','Send Copy of Whitelist-Reports TO',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com',undef,undef,'msg005360','msg005361'],
['EmailRedlistAdd','Add to Redlist Address',20,\&textinput,'asspred','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to add the sender address to the redlist. Only the users defined in EmailRedlistTo, EmailAdmins and EmailAdminReportsTo are able to define a list of email addresses in the mail body.  Do not put the full address here, just the user part. <br />
  For example: asspred.',undef,undef,'msg005370','msg005371'],
['EmailRedlistRemove','Remove from Redlist Addresses',20,\&textinput,'asspnotred','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to remove the sender address from the redlist. Only the users defined in EmailRedlistTo, EmailAdmins and EmailAdminReportsTo are able to define a list of email addresses in the mail body. <br />
  Do not put the full address here, just the user part. <br />
  For example: asspnotred',undef,undef,'msg005380','msg005381'],
['EmailRedlistReply','Reply to Add to/Remove from Redlist','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailRedlistTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,
  '',undef,undef,'msg005390','msg005391'],
['EmailRedlistTo','Send Copy of Redlist-Reports TO',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com',undef,undef,'msg005400','msg005401'],
['EmailSpamLoverAdd','Add to SpamLover Addresses',20,\&textinput,'asspspamlover','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to add the sender address to spamLovers. Only the users defined in EmailSpamLoverTo, EmailAdmins and EmailAdminReportsTo are able to define a list of email addresses in the mail body. Do not put the full address here, just the user part. <br />
  For example: asspspamlover. To use this option, you have to configure spamLovers with "file:..." for example "file:files/spamlovers.txt" !',undef,undef,'msg005410','msg005411'],
['EmailSpamLoverRemove','Remove from SpamLover Addresses',20,\&textinput,'asspnotspamlover','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to remove the sender address from spamLovers. Only the users defined in EmailSpamLoverTo, EmailAdmins and EmailAdminReportsTo are able to define a list of email addresses in the mail body. <br />
  Do not put the full address here, just the user part. <br />For example: asspnotspamlover',undef,undef,'msg005420','msg005421'],
['EmailSpamLoverReply','Reply to Add to/Remove from SpamLovers','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailSpamLoverTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,
  '',undef,undef,'msg005430','msg005431'],
['EmailSpamLoverTo','Send Copy of Spamlover-Reports TO',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com',undef,undef,'msg005440','msg005441'],
['EmailNoProcessingAdd','Add to NoProcessing Addresses',20,\&textinput,'asspnpadd','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to add the sender address to the noProcessing addresses. Only the users defined in EmailNoProcessingTo, EmailAdmins and EmailAdminReportsTo are able to define a list of email addresses in the mail body. Do not put the full address here, just the user part. <br />
  For example: asspnpadd. To use this option, you have to configure noProcessing with "file:..." for example "file:files/noprocessing.txt" !',undef,undef,'msg005450','msg005451'],
['EmailNoProcessingRemove','Remove from noProcessing Addresses',20,\&textinput,'asspnprem','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to remove the sender address from noProcessing .<br />
  Do not put the full address here, just the user part. Only the users defined in EmailNoProcessingTo, EmailAdmins and EmailAdminReportsTo are able to define a list of email addresses in the mail body. <br />
  For example: asspnprem. To use this option, you have to configure noProcessing with "file:..." for example "file:files/noprocessing.txt" !',undef,undef,'msg005460','msg005461'],
['EmailNoProcessingReply','Reply to Add to/Remove from noProcessing','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailNoProcessingTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,
  '',undef,undef,'msg005470','msg005471'],
['EmailNoProcessingTo','Send Copy of NoProcessing-Reports TO',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com',undef,undef,'msg005480','msg005481'],
['EmailBlackAdd','Add to BlackListed Addresses',20,\&textinput,'assp-black','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to add the sender address to the blackListedDomains addresses. Only the users defined in EmailAdmins and EmailAdminReportsTo are able to request an addition. Do not put the full address here, just the user part.<br />
  For example: assp-black. To use this option, you have to configure blackListedDomains with "file:..." for example "file:files/blacklisted.txt" !',undef,undef,'msg005490','msg005491'],
['EmailBlackRemove','Remove from BlackListed Addresses',20,\&textinput,'assp-notblack','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to remove the sender address from blackListedDomains .<br />
  Do not put the full address here, just the user part. Only the users defined in EmailAdmins and EmailAdminReportsTo are able to request a removal.<br />
  For example: assp-notblack. To use this option, you have to configure blackListedDomains with "file:..." for example "file:files/blacklisted.txt" !',undef,undef,'msg005500','msg005501'],
['EmailErrorsModifyPersBlack','Spam/NotSpam Report will modify Personal Blacklist *',60,\&textinput,'*@*','(.*)','ConfigMakeSLRe',
  'Spam Reports will add email addresses to the Personal Blacklist, NotSpam Reports will remove addresses from the Personal Blacklist, if the report senders address matches.<br />
  Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). Wildcards are supported (fribo*@domain.com).<br />
  Default is *@* , which matches all addresses.',undef,undef,'msg009610','msg009611'],
['EmailPersBlackAdd','Add to Personal BlackListed Addresses',20,\&textinput,'assp-persblack','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to add the listed address(es) to the personal blackListed addresses. Do not put the full address here, just the user part. <br />
  For example: assp-persblack.<br />
  The add and remove is done using the email-interface, by sending specific email addresses to \'EmailPersBlackAdd\'  and \'EmailPersBlackRemove\'.
  A local user can force a complete report about all his personal black list entries by defining an email address that begins with \'reportpersblack\' in a remove or add request : eg: reportpersblack@anydomain.com or by sending an empty body.<br />
  Any mail address sent to this username will be removed from the whitelist if possible.<br />
  Globalized adding an address to all local users is not supported - use EmailBlackAdd instead.<br />
  The following wildcard combinations are allowed for an email address to support personal blacklisting of domains:<br /><br />
  full_sender_address<br />
  *@sender_domain or @sender_domain<br />
  @*sender_domain or *@*sender_domain<br />
  @*.sender_domain or *@*.sender_domain',undef,undef,'msg009110','msg009111'],
['EmailPersBlackRemove','Remove from Personal BlackListed Addresses',20,\&textinput,'assp-persnotblack','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to remove the listed address(es) from the personal blackListed addresses .<br />
  Do not put the full address here, just the user part.<br />
  For example: assp-persnotblack.<br />
  The add and remove is done using the email-interface, by sending specific email addresses to \'EmailPersBlackAdd\'  and \'EmailPersBlackRemove\'.
  A local user can force a complete report about all his personal black list entries by defining an email address that begins with \'reportpersblack\' in a remove or add request : eg: reportpersblack@anydomain.com or by sending an empty body.<br />
  Only an admin can force a complete cleanup of all personal black entries for a specific email address for all local users - sending an email to \'EmailPersBlackRemove\' with the address followed by \',*\' in the body
  eg: address_to_remove@the_domain.foo,* - be careful modifying personal entries of other users!<br />
  The same wildcard combinations like in EmailPersBlackAdd are supported.<br />
  <b>Notice: a remove request for a specific email address will remove ALL entries from the users personal blacklist, that would block this email address (also all matching wildcard entries)!</b>',undef,undef,'msg009120','msg009121'],
['EmailBlackReply','Reply to Add to/Remove from BlackListed','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailBlackTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,
  '',undef,undef,'msg005510','msg005511'],
['EmailBlackTo','Send Copy of Black-Change-Reports TO',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com',undef,undef,'msg005520','msg005521'],
['EmailAnalyze','Request Analyze Report',20,\&textinput,'asspanalyze','(.*)@?',undef,
  'Any mail sent or forwarded by local/authenticated users to this username will be interpreted as a request for analyzing the mail. Do not put the full address here, just the user part. For example: asspanalyze <br />
  Use a fake domain like @assp.local or @assp-nospam.org when you send the email- so the full address would be then asspanalyze@assp.local. <br />
  You can sent multiple mails as attachments and/or zipped file(s). Each attached email-file must have the extension defined in "maillogExt". In this case only the attachments will be processed. To use this multi-attachment-feature an installed <a href="http://metacpan.org/search?q=Email::MIME" rel="external">Email::MIME</a> module in PERL is needed. It is also possible to send MS-outlook \'.msg\' files (possibly zipped). To use this MS-outlook-feature in addition an installed <a href="http://metacpan.org/search?q=Email::Outlook::Message" rel="external">Email::Outlook::Message</a> module in PERL is needed.','Basic',undef,'msg005530','msg005531'],
['EmailAnalyzeReply','Reply to Analyze Request','0:NO REPLY|1:SEND TO SENDER|2:SEND TO EmailAnalyzeTo|3:SEND TO BOTH',\&listbox,1,'(\d*)',undef,'',undef,undef,'msg005540','msg005541'],
['EmailAnalyzeTo','Send Copy of Analyze-Reports',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'A copy of the Analyze-Report will be sent to this address. For example: admin@domain.com',undef,undef,'msg005550','msg005551'],
['DoAdditionalAnalyze','Spam and Ham Reports will trigger an additional Analyze Report ','0:NO ADDITIONAL REPORT|1:SEND TO SENDER|2:SEND TO EmailAnalyzeTo|3:SEND TO BOTH',\&listbox,0,'(.*)',undef,
  'Additional Analyze Report will be generated for Spam and Ham Reports. Setting the TO Address accordingly and choosing <b>EmailAnalyzeTo</b> will send the Analyze Report to the admin only.',undef,undef,'msg005560','msg005561'],

['EmailFrom','From Address for Reports',40,\&textinput,'spammaster@yourdomain.com','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent from this address.',undef,undef,'msg005570','msg005571'],
['EmailAllowEqual','Allow \'=\' in Addresses',0,\&checkbox,'1','(.*)',undef,
  'Allow \'=\' in addresses to be whitelisted or redlisted.',undef,undef,'msg005580','msg005581'],

['EmailSenderNoReply','Do Not Reply To These Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Email sent from ASSP acknowledging your submissions will not be sent to these addresses. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com).<br />
  Analyze-, PersonalBlackList- and all virus related reports are ignored by this feature (are sent even a user is listed here).<br />
  A Report copy to EmailAnalyzeTo, EmailBlackTo, EmailNoProcessingTo, EmailSpamLoverTo, EmailRedlistTo, EmailWhitelistTo and EmailErrorsTo is also ignored by this feature.<br /><hr />
  <div class="cfgnotes">Notes On Email Interface</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/emailinterface.txt\',3);" />',undef,undef,'msg005590','msg005591'],

[0,0,0,'heading','File Paths and Database'],
['base','Directory Base',40,\&textnoinput,'.','(.*)',undef,'All paths are relative to this folder.<br />
  <b>Note: Display only.</b>',undef,undef,'msg005600','msg005601'],
['spamlog','Spam Collection',40,\&textinput,'spam','(\S+)',undef,'The folder to save the collection of spam mails. This directory will be used in building the spamdb . For example: spam',undef,undef,'msg005610','msg005611'],
['notspamlog','Not-spam Collection',40,\&textinput,'notspam','(\S+)',undef,'The folder to save the collection of not-spam mails. This directory will be used in building the spamdb . For example: notspam',undef,undef,'msg005620','msg005621'],
['incomingOkMail','OK Mail',40,\&textinput,'okmail','(.*)',undef,'The folder to save non-spam (message ok). These are messages which are considered as HAM, but are not stored in the standard HAM folder because of our policy to use only confirmed HAM messages (whitelisted or local) for spamdb . If you want to keep copies of ok mail then put in a directory name. This directory will not be used in building the spamdb . Default: okmail',undef,undef,'msg005630','msg005631'],
['discarded','Discarded Spam',40,\&textinput,'discarded','(.*)',undef,'The folder to save discarded spam-messages. These are Spam messages which are not stored for building the spamdb but for resending with an EmailBlockReport. If you want to keep copies of discarded Spam then put in a directory name. Default: discarded',undef,undef,'msg005640','msg005641'],
['viruslog','Attachment/Virus Collection',40,\&textinput,'quarantine','(.*)',undef,
  'The folder to save rejected attachments and viruses. Leave this blank to not save these files (default). If you want to keep copies of rejected content then put in a directory name. Note: you must create the directory. This directory will not be used in building the spamdb . For example: quarantine',undef,undef,'msg005650','msg005651'],
['correctedspam','False-negative Collection',40,\&textinput,'errors/spam','(\S+)',undef,
  'Spam that got through -- counts double. This directory will be used in building the spamdb . For example: errors/spam',undef,undef,'msg005660','msg005661'],
['correctednotspam','False-positive Collection',40,\&textinput,'errors/notspam','(\S+)',undef,
  'Good mail that was listed as spam, count 4x. This directory will be used in building the spamdb . For example: errors/notspam',undef,undef,'msg005670','msg005671'],
['resendmail','try to resend this files',40,\&textinput,'resendmail','(\S+)',undef,
  'ASSP will try to resend the files in this directory to the original recipient. The files must have the "maillogExt" extension and must have the SMTP-format. For example: resendmail. This requires an installed <a href="http://metacpan.org/search?q=Email::Address::XS" rel="external">Email::Address::XS</a> module in Perl.',undef,undef,'msg005680','msg005681'],
['maillogExt','Extension for Mail Files',20,\&textinput,'.eml','(\S*)',undef,
  'Enter the file extension (include the period) you want appended to the mail files in the mail collections.<br />
  Leave it blank for no extension - this setting will prevent several features from working. Never use \'.msg\' - this is an extension used by MS-outlook! For Example: .eml',undef,undef,'msg005690','msg005691'],
['spamdb','Spam/HMM Bayesian Database Files',40,\&textinput,$newDB.'spamdb','(\S+)','configChangeDB','The output file from rebuildspamdb. Write only "DB:" to use a database table instead of a local file, in this case you need to edit the database parameters below. The Hidden Makov Model is only available if this parameter is set to DB: .<br />
 <hr />It is recommended to use a database for all possible lists and caches for best performance, less memoryusage and stability! If you do not want to install a database engine like MySql or Oracle, use BerkeleyDB! Please read the section DBdriver !<br />
  If you set this value to "DB:" and you want HMMdb to use the same database backend like spamdb, don\'t forget to disable HMMusesBDB !<br />
 <hr /><div class="cfgnotes">Last Run Rebuildspamdb</div><input type="button" value="Last Run Rebuildspamdb" onclick="javascript:popFileEditor(\'rebuildrun.txt\',5);" />',undef,undef,'msg005700','msg005701'],
['whitelistdb','Whitelist Database File',40,\&textinput,$newDB.'whitelist','(\S+)','configChangeDB','The file with the whitelist.<br />
  Write only "DB:" to use a database table instead of a local file, in this case you need to edit the database parameters below.',undef,undef,'msg005710','msg005711'],
['redlistdb','Redlist Database File',40,\&textinput,$newDB.'redlist','(\S+)','configChangeDB','The file with the redlist.<br />
  Write only "DB:" to use a database table instead of a local file, in this case you need to edit the database parameters below.',undef,undef,'msg005720','msg005721'],
['persblackdb','Personal Blacklist Database File',40,\&textinput,$newDB.'persblack','(\S+)','configChangeDB','The file with the personal blacklist. The check of the personal black list is done shortly after the RCPT TO: command. This command will be rejected if an entry is found - any other setting except send250OK and send250OKISP will be ignored.<br />
  Each entry is represented by two comma separated values TO,FROM (and an expiration date).<br />
  TO could be any of : email address, [subdomain.]domain.tld, @[subdomain.]domain.tld, *@[subdomain.]domain.tld - the last three entry options could be only added and removed by editing the list in the GUI !<br />
  FROM could be any of : email address or any [@][subdomain.][domain.]TLD variant (wildcards are allowed). All values are supported by the email interface for all local users.<br />
  Write only "DB:" to use a database table instead of a local file, in this case you need to edit the database parameters below.',undef,undef,'msg009100','msg009101'],
['ldaplistdb','LDAP Database',40,\&textinput,$newDB.'ldaplist','(\S*)','configChangeDB',
 'The file with the LDAP-cache database. Local email addresses and local domains, which are successfully validated using LDAP ( DoLDAP ) or VRFY ( DoVRFY ) are cached in this list, to prevent repeated LDAP and/or VRFY lookups.<br />
 Write only "DB:" to use a database table instead of a local file, in this case you need to edit the database parameters below.<br />
 If an email address or domain is reported as invalid by LDAP or VRFY, this result is cached for (min) ten to (max) fifteen minutes in the LDAP-Not-Found-Cache <input type="button" value="edit LDAP-Not-Found Cache" onclick="javascript:popFileEditor(\'DB-LDAPNotFound\',\'1h\');" /> , to prevent repeated LDAP and/or VRFY lookups. Those cache entries are not removed from the cache, while the rebuildspamdb task is running!',undef,undef,'msg005770','msg005771'],
['delaydb','Delaying Database',40,\&textinput,$newDB.'delaydb','(\S*)','configChangeDB','The file with the delay database.<br />
 Write only "DB:" to use a database table instead of a local file, in this case you need to edit the database parameters below.',undef,undef,'msg005760','msg005761'],
['pbdb','PenaltyBox Database',40,\&textinput,$newDB.'pb/pbdb','(\S*)','configChangeDB','The directory/file with the penaltybox database files. For removal of entries from BlackBox (PBBlack) use noPB .
 For removal of entries from WhiteBox (PBWhite) use noPBwhite. For whitelisting IP\'s use whiteListedIPs or noProcessingIPs . For blacklisting use denySMTPConnectionsFrom and denySMTPConnectionsFromAlways .<br />
 Write only "DB:" to use a database table instead of a local file. <br />
 <input type="button" value=" Show BlackBox" onclick="javascript:popFileEditor(\''.$newDB.'pb/pbdb.black.db\',4);" /><input type="button" value="Show White Box" onclick="javascript:popFileEditor(\''.$newDB.'pb/pbdb.white.db\',4);" />',undef,undef,'msg002330','msg002331'],
['adminusersdb','Admin Users Database',40,\&textinput,'','(\S*)','configChangeDB','The file with the GUI-Admin-Users database - default to set is \''.$newDB.'adminusers\'.<br />
 Write only "DB:" to use a database table instead of a local file, in this case you need to edit the database parameters below. Before setting this parameter, please set adminusersdbpass to a value of your choice!<br />
 <hr>To use this database shared between multiple ASSP\'s, set all ASSP to mysqlSlaveMode (except the master) and the adminusersdbpass must be the same on all installations! If you want to change the adminusersdbpass, first change it on the master.<hr>',undef,undef,'msg005780','msg005781'],
['adminusersdbNoBIN','Admin Users Database uses no Binary Data (ASCII only)',0,\&checkbox,'','(.*)',undef,'Select this, if adminusersdb is set to "DB:" and your database engine does not accept or has problems with binary data (eg. Postgres). <span class="negative">If you change this value, you have to stop all assp and to cleanup both tables (adminusers and adminusersright) <b>before</b> restarting assp!</span>. To keep your data do the following: do an ExportMysqlDB - change this value - stop assp - drop or clean both tables - start assp - do an ImportMysqlDB .',undef,undef,'msg005790','msg005791'],
['adminusersdbpass','Admin Users Database PassPhrase',40,\&passinput,'','(.*)','ConfigChangePassPhrase','The passphrase that is used to encrypt the adminusersdb. This has to be the same on all ASSP installations that are sharing the adminusersdb. If you want to change it, first change it on the master installation and than on the slaves. Do not forget to configure \'mysqlSlaveMode\' first. An empty value is not valid!',undef,undef,'msg005800','msg005801'],
['griplist','GreyIPlist Database',40,\&textinput,$newDB.'griplist','(\S*)',undef,'The file with the current Grey-IP-List database -- make this blank if you don\'t use it. More explanations at noGriplistUpload .',undef,undef,'msg005730','msg005731'],
['useDB4griplist','Use BerkeleyDB for Griplist',0,\&checkbox,'','(.*)','configChangeDB',
 'If selected ASSP uses \'BerkeleyDB\' instead of \'orderedtie\' for griplist. Depending on your settings for OrderedTieHashTableSize this could spend some memory and/or result in better performance.  The perl module <a href="http://metacpan.org/search?q=BerkeleyDB/" rel="external">BerkeleyDB</a> version 0.34 or higher and BerkeleyDB version 4.5 or higher is required to use this feature.',undef,undef,'msg005740','msg005741'],
['myhost','database hostname or IP',40,\&textinput,'','(.*)',undef,
  'You need <a  href="http://metacpan.org/search?q=Tie::RDBM.pm" rel="external">Tie::RDBM</a> to use a database instead of local files.<br />
  This way you can share whitelist, delaydb, redlist, spamdb, HMMdb, ldaplist, adminusersdb, personal blacklist and penaltybox (all that can be set to \'DB:\') between servers.<br />
  ASSP uses permanent connections to the database server, so set the connection timeout in your server configuration to a very high value (eg - mysql: interactive_timeout=28800 , wait_timeout=28800).',undef,undef,'msg005810','msg005811'],
['DBdriver','database driver name',40,\&textinput,'','^([a-zA-Z].+|)$','configChangeDB',
  'The database driver used to access your database - DBD-driver.<br />
  <span class=\"negative\">Please read this section very carefull!</span><br />
  The following drivers are available on your system:<br />
  $DBdriversJ<br />
  If you can not find the driver for your database in this list, you should install it using cpan or ppm!<br />
  -  or if you have installed an ODBC-driver for your database and DBD-ODBC, just create a DSN and use ODBC.<br />
  If assp is running on windows and you want to use a MSSQL server as backend, don\'t use the ODBC driver - use the ADO driver with the DSN definition!<br />
  Useful are ADO|DB2|Informix|ODBC|Oracle|Pg|Sybase|mysql|Firebird - but any other SQL compatible database should also work.<br/ ><br />
  syntax examples: driver,option1,option2,...,...<br />
  ADO[,DSN=mydsn[;Provider=sqloledb]]<br />
  ODBC,DSN=mydsn|driver=\{SQL Server\},Server=server_name<br />
  DB2<br />
  Informix<br />
  Oracle,SID=1|INSTANCE_NAME=myinstance|SERVER=myserver|SERVICE_NAME=myservice_name,[PORT=myport]<br />
  Pg[,PORT=myport]<br />
  Firebird[,PORT=myport]<br />
  Sybase,SERVER=myserver,[PORT=myport]<br />
  mysql[,PORT=myport][,mysql_socket=/path/to/mysql.sock][,AutoCommit=1][,mysql_auto_reconnect=1]<br /><br />
  Notice: assp requires permanent database connections. Set database engine parameter like \'client-timeout\' or \'connection-timeout\' to very high values (eg: 1/2 or 1 day)! ASSP requires one database connection per thread (typical 8 connections), plus up to five connection for imports, exports and internal processing. Set the maximum allowed database connection in your database server configuration according!<br /><br />
  <span class="negative">Instead using local files for hashes and lists in shared memory, it is recommended to use <a  href=\"http://metacpan.org/search?q=berkeleydb\" rel=\"external\">BerkeleyDB</a> (Perl-module) version 0.34 or higher for highest performance and less memory usage.  The BerkeleyDB (engine) version 4.5 or higher is required to use BerkeleyDB.</span><br />
  If you specify BerkeleyDB here, the values for myhost, mydb, myuser and mypassword will be ignored. All possible BerkeleyDB option must be defined here - the option for \'-Filename\' is already set by ASSP! Options could be defined for example:<br />
  BerkeleyDB,-Pagesize=>number,-Env=>[-Cachesize=>number,-Mode=>mode,...,...],...,...<br />
  If \'-Env=>[-Cachesize=>number]\' (number in bytes) is specified, this cache size will be used at minimum for every single list. Setting the cache size is not recommended (as long as do not you really know what you do), because ASSP does automatically calculate the right cache for every list. You may setup configuration values for any BerkeleyDB, creating a file <a href=https://docs.oracle.com/cd/E17275_01/html/programmer_reference/env_db_config.html>DB_CONFIG</a> (case sensitive) in the corresponding directory ./tmpDB/[list]. Please use the BerkeleyDB documentation if you don\'t know the syntax of this file. Any value defined in that file will overwrite the corresponding internal ASSP configuration for this DB.<br />
  As with each other database engine, you should know how to handle BerkeleyDB large shared BDB-environments (CDB - DB_INIT_CDB and DB_INIT_MPOOL), how to repair database files and all the other important stuff. ASSP has several built-in mechanism to detect and repair corrupt BerkeleyDB files, but they may not work in every case!<br />
  If you have specified BerkeleyDB here and your system shows unexpected SEGV or ASSP died unexpected, think about the BDB settings. If you can\'t fix such an issue, it may be an good idea to switch over to MySQL or another database engine.<br />
  <span class=\"negative\">KEEP IN MIND:</span> BerkeleyDB files are shared opened and accessed by all threads using BDB-CDB. The last terminated thread closes the BDB-files (shutdown the BDB-engine) for the systems file system. <span class=\"negative\">It is important</span>, that (especially) linux and unix <span class=\"negative\">system shutdown scripts are waiting until ALL assp/perl processes are ended</span> (this may take up to one minute - see MaxFinConWaitTime )! Otherwise, the kernel will kill the assp/perl process at shutdown and the BerkeleyDB DB-files and environment-files <span class=\"negative\">WILL BE DESTROYED</span> and cause to <span class=\"negative\">100%</span> unexpected behavior or crashes at the next start or run! The same applies to Windows systems, if assp is <span class=\"negative\">not running as system service</span> - the windows system-service-manager will wait until the process is finished.<br /><br />
  The options for all drivers and their possible or required order depends on the DBD driver used, please read the driver\'s documentation, if you do not know the needed option.<br />
  The username, password, host and databasename are always used from this configuration page.',undef,undef,'msg005820','msg005821'],
['mydb','database name',40,\&textinput,'','(\S*)',undef,
  'This database must exist before starting ASSP, necessary tables will be created automatically into this database.',undef,undef,'msg005830','msg005831'],
['mysqlSlaveMode','This is a slave of more then one assp-computers accessing the same database',0,\&checkbox,'','(.*)',undef,
  'If you are running more then one assp-computers accessing the same or <a href="http://www.webopedia.com/TERM/S/SPOF.html">(better because of SPOF)</a> a bidirectional replicated database<br />
  this is a slave-assp and no database maintenance will be done by this one!<br />
  Maintenance should only be done by the first assp - the master!<br />
  Maintenance for file based caches and lists will always be done!',undef,undef,'msg005840','msg005841'],
['myuser','database username',40,\&passinput,'','(.*)',undef,
  'This user must have CREATE privilege on database to create tables automatically',undef,undef,'msg005850','msg005851'],
['mypassword','database password',40,\&passinput,'','(.*)',undef,'',undef,undef,'msg005860','msg005861'],
['DBCacheMaxAge','Database Maximum Cache Age',10,\&textinput,'0','(\d+)',undef,'Setting this value above zero, enables an internal database cache for every defined table to reduce the concurrent database queries and to prevent possible record access collisions, which could cause stuck workers on some systems<br />
  The value defines the maximum age in seconds a record will exists untouched in the table cache.<br />
  Be careful, setting this value too high in a database replication environment could cause unexpected query results, because this cache is NOT shared between multiple assp instances.<br />
  If set, a value of 10 seems to be popular in any case. A value that is too small will produce overhead without any advantage. A value that is too high may cause database consistency problems.',undef,undef,'msg010020','msg010021'],
['importDBDir','import directory',40,\&textinput,'mysql/dbimport','(\S+)',undef,'The folder to import the used tables of the database from.<br />
 The schema of the files must be the assp-schema.<br />
Files can be:<br />
- pbdb.back.db.(add|rpl)<br />
- pbdb.batv.db.(add|rpl)<br />
- pbdb.black.db.(add|rpl)<br />
- pbdb.dkim.db.(add|rpl)<br />
- pbdb.mxa.db.(add|rpl)<br />
- pbdb.ptr.db(add|rpl)<br />
- pbdb.rbl.db.(add|rpl)<br />
- pbdb.rwl.db.(add|rpl)<br />
- pbdb.sb.db.(add|rpl)<br />
- pbdb.spf.db.(add|rpl)<br />
- pbdb.trap.db.(add|rpl)<br />
- pbdb.uribl.db.(add|rpl)<br />
- pbdb.white.db.(add|rpl)<br />
- ldaplist.(add|rpl)<br />
- redlist.(add|rpl)<br />
- whitelist.(add|rpl)<br />
- persblackdb.(add|rpl)<br />
- spamdb.(add|rpl)<br />
- spamdb.helo.(add|rpl)<br />
- delaydb.(add|rpl)<br />
- delaydb.white.(add|rpl)<br />
- adminusers.(add|rpl)<br />
- adminusersright.(add|rpl)<br />
Use the extension "add" or "rpl" to add or replace the records to the tables.<br />
Only files for database-enabled tables will be imported ! The import will be done at ASSP start or if the option below is used.<br />
Imported files will be renamed to *.OK !<br />
For example: mysql/dbimport<br />
<span class="negative">If you plan to import into BerkeleyDB - do the following:<br />
- set DisableSMTPNetworking to on
- set all needed DB parameters
- collect your import files
- restart assp and wait until all imports are finished
- restart assp
- set DisableSMTPNetworking to off </span>',undef,undef,'msg005870','msg005871'],
['preventBulkImport','Prevent Bulk Import',0,\&checkbox,'','(.*)',undef,'Do not select, if you are using MySQL! Doing a Bulk-Import of data, ASSP modifies the properties of table columns. This could result in breaking some configured DB features like DB-replication in MSSQL and possibly other database engines. If selected, ASSP will do a line per line insert/update (which takes much more time) without modifying the tables properties.',undef,undef,'msg005880','msg005881'],
['fillUpImportDBDir','Fill the Import Folder',10,\&textinput,'','^([1-9]|L|)$','ConfigChangeRunTaskNow','If set to a value between 1 and 9, the corresponding backup file for any list/hash that configured to use a database will be copied from the backupDBDir to the importDBDir. The resulting file name will has an extension of ".rpl", so a possible import will replace the current table content. If a value of "L" is defined, the last backup will be used. Possible values are L or 1 - 9 or blank. Any configured value will be reset to blank after the copy is finished.',undef,undef,'msg008990','msg008991'],
['ImportMysqlDB','import all files from the importDBDir Directory into the database - now.',0,\&checkbox,'','(.*)','ConfigChangeRunTaskNow',
  "All files from the \"importDBDir\" will be imported into the database defined in mydb . Please define the directory above, before using the import!<br />
<input type=button value=\"Apply Changes and Run DB Import Now (if checked)\" onclick=\"document.forms['ASSPconfig'].theButtonX.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />&nbsp;<input type=button value=\"Refresh Browser\" onclick=\"document.forms['ASSPconfig'].theButtonRefresh.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />",undef,undef,'msg005890','msg005891'],
['exportDBDir','export directory',40,\&textinput,'mysql/dbexport','(\S+)',undef,'The folder to export the used tables of the database.<br />
 The schema of the files is the assp-schema.(starts with [LF], one record per line, lines are terminated with [LF], keys and values are separated by \002 or \x02)<br />
 Ten versions of the database and hash exports are available!<br />
 <span class="negative">Exports are done unencrypted, it is recommended to secure this folder!</span><br />
 For example: mysql/dbexport','Basic',undef,'msg005900','msg005901'],
['ExportMysqlDB','export all tables from the database and plain hash files',0,\&checkbox,'','(.*)','ConfigChangeRunTaskNow',
 "All tables of the database and all plain hash files will be exported to the \"exportDBDir\" directory. Please define the directory above, before using the export function!<br />
 In addition the running configuration and all encrypted option files in use will be exported.<br />
 If you plan to upgrade the OS or perl, or you plan to move to a new system or a different OS - it is recommended to do an export first!<br />
 <span class=\"negative\">NOTICE: both encrypted tables/hashes, AdminUsersRight and AdminUsers, will be exported unencrypted (eg. in plain text), the same applies to the exported configuration file and the exported option files!</span><br />
 If possible, assp will compress the config files, option files and the AdminUsersRight and AdminUsers to the file \'config.zip\' in the  \"exportDBDir\" directory.<br />
 If possible, assp will encrypt the config.zip to config.zip.aes using openssl or Crypt::CBC. To decrypt this file, use the OS commandline:<br /><br />
 <b>openssl enc -d -aes-256-cbc [-md md5|sha256] -in config.zip.aes -out config.zip -pass pass:PASSWORD</b><br /><br />
 Before you move assp to another system or you want to archive the export - check that you are able to decrypt the file config.zip.aes to config.zip and to unzip config.zip successfully!<br />
 Notice: The default hash used by openssl enc for password-based key derivation changed in version 1.1.0 to SHA256 versus MD5 in lower versions. ASSP uses the default hash algorythm of the currently installed OpenSSL version. It may possible, that you need to define '-md md5' or '-md sha256' to decrypt exports made by other OpenSSL versions!<br />
 The created file config.zip[.aes] will also contain an assp support summary with important files, folders, history-, runtime- and schedule- information. This file may requested by the assp support stuff - but it can also be used as a full configuration backup. <span class=\"negative\">Keep in mind, that certificate information (certs and keys) will be never exported!</span> Keep them safe outside assp.<br /><br />
 <span class=\"negative\">NOTICE: The password / key, used for the export encryption function, may change at the next assp start or if the assp.cfg gets an external update! Record the password after each export!</span><br /><br />
 <input type=button value=\"Apply Changes and Run the Export NOW (if checked)\" onclick=\"document.forms['ASSPconfig'].theButtonX.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />&nbsp;<input type=button value=\"Refresh Browser\" onclick=\"document.forms['ASSPconfig'].theButtonRefresh.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />&nbsp;<input type=button value=\"show the decryption password\" onclick=\"remember('".$dftExpSec."');return false;\" />",'Basic',undef,'msg005910','msg005911'],
['backupDBDir','backup directory',40,\&textinput,'mysql/dbbackup','(\S+)',undef,'The folder to backup the used tables of the database.<br />
 The schema of the files is the assp-schema.<br />
 Ten versions of backups are available!<br />
 For example: mysql/dbbackup',undef,undef,'msg005920','msg005921'],
['backupDBInterval','backup database Interval <sup>s</sup>',40,\&textinput,12,$ScheduleGUIRe,'configChangeSched',
  'Backup the database (all tables used by assp at the time) every this hours.<br />
  Defaults to a 12 hours interval. You may set this to a higher frequency (e.g. two hours), if you have daily system backups configured.',undef,undef,'msg005930','msg005931'],
['copyDBToOrgLoc','copy the last DB-backup to the original location',0,\&checkbox,'1','(.*)',undef,
  'If DB-backup is enabled, the last backupversion is also copied to the original location.<br />
  If database connections are failed, while ASSP is running, ASSP will switch over to use these files instead of DB-tables.<br />
  DB-tables will not be imported from here, this must be done from the importDBDir!',undef,undef,'msg005940','msg005941'],
['logfile','ASSP Logfile',40,\&textinput,'logs/maillog.txt','(\S*)','ConfigChangeLogfile',
  'Blank if you don\'t want a log file. Change it to maillog.log if you don\'t want auto rollover.
  NOTE: Changing this field requires restarting ASSP before changes take effect.',undef,undef,'msg005950','msg005951'],
['MaxLogAge','Max Age of Logfiles',10,\&textinput,30,'(\d+)',undef,
  'The maximum file age in days of logfiles. If a logfile is older than this number in days, the file will be deleted. Default and recommended is 30 days. A value of 0 disables this feature and no logfile will be deleted because of its age.',undef,undef,'msg005960','msg005961'],
['MaxLogAgeSchedule','Runtime MaxLogAge <sup>s</sup>',40,\&textinput,'1',$ScheduleGUIRe,'configChangeSched',
  'Runtime hour for deleting old logfiles. Set a number between 0 and 23. 0 means midnight, 1 is default.',undef,undef,'msg005970','msg005971'],
['pidfile','PID File',40,\&textinput,'pid','(\S+)',undef,'Blank is not a valid value!<br />
  You have to restart ASSP before you get a pid file in the new location.<br />
  This file is used to detect a clean shutdown of ASSP - in this case it does not exist at startup!
  <hr /><div class="cfgnotes">Notes On File Path</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/filepath.txt\',3);" />',undef,undef,'msg005980','msg005981'],

[0,0,0,'heading','Collecting SPAM and HAM'],
['spamaddresses','Spam Collect Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Mail to any of these addresses are always spam and will contribute to the spam-collection unless from someone on the whitelist - for example honeypot addresses. Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com). The addresses are not validated, they  are readdressed to sendAllSpam, however you can supersede this by putting a valid address into sendAllCollect below.',undef,undef,'msg005990','msg005991'],
['sendAllCollect','Catchall Address for Collect Addresses',20,\&textinput,'','(.*)',undef,
  'ASSP will readdress messages addressed to Collect Addresses to this address.<br />
  For example: collect@mydomain.com',undef,undef,'msg006000','msg006001'],
['DoNotBlockCollect','Use Collect Addresses for Testing Your Environment',0,\&checkbox,'','(.*)',undef,
  'If set ASSP will block messages from Collect Addresses <b>after</b> other checks are performed. That may help to test and control activated filters.',undef,undef,'msg006010','msg006011'],
['UseTrapToCollect','Use Penalty Trap Addresses To Collect',0,\&checkbox,'','(.*)',undef,
  'If set ASSP will use addresses from DoPenaltyMakeTraps and spamtrapaddresses to collect spams.',undef,undef,'msg006020','msg006021'],
['noCollecting','Do Not Collect Messages from/to these Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe','Accepts specific addresses (user@domain.com), user parts (user) or entire domains (@domain.com).',undef,undef,'msg006030','msg006031'],
['noCollectRe','Do Not Collect Messages - Content Based*',60,\&textinput,'','(.*)','ConfigCompileRe','If the content of a collected file (incl. X-ASSP-... headers) matches this regular expression, it will be deleted from the collection after the mail is completely processed.<br />
  If the ASSP_ARC or ASSP_RSS plugin is used, the file will be deleted from the collection after it was archived. This is the only "no collect" option which removes an already collected file, all other options will prevent assp from creating a collection file - if set to "no collection". The check is limited to MaxBytes or at max 100000 Bytes.',undef,undef,'msg008930','msg008931'],
['DoNotCollectRedRe','Do Not Collect Red-Re Matching Mails',0,\&checkbox,1,'(.*)',undef,
  'Mails (Spam/Ham) matching Red Regex ( redRe ) will not be stored in the collection folders.',undef,undef,'msg006040','msg006041'],
['DoNotCollectRedList','Do Not Collect Redlisted Mails',0,\&checkbox,'1','(.*)',undef,
  'Mails (Spam/Ham) matching  Redlist will not be stored in the collection folders.',undef,undef,'msg006050','msg006051'],
['DoNotCollectBounces','Do Not Collect Bounced Mails',0,\&checkbox,1,'(.*)',undef,
  'Mails matching &lt;Bounce Senders&gt; will not be collected.',undef,undef,'msg006060','msg006061'],
['NoMaillog','Do Not Collect Mail',0,\&checkbox,'','(.*)',undef,
  'Check this if you\'re using Whitelist-Only and don\'t care to save mail to build the Bayesian database.',undef,undef,'msg006070','msg006071'],

['MaxFiles','Max Files',10,\&textinput,14000,'(\d+)',undef,
  'If you\'re not using subjects as file names ( UseSubjectsAsMaillogNames ), this is the maximum number of files to keep in each collection (spam &amp; nonspam)<br />
  It\'s actually less than this -- files get a random number between 1 and MaxFiles.',undef,undef,'msg006080','msg006081'],
['FilesDistribution','Files Distribution',4,\&textinput,1,'(0\.\d?[1-9]+|1)',undef,
  'This defines how file names are chosen in each collection. If set to 1, names are uniformly distributed. If set between 0.01 and 0.99, names distribution is exponential -- files get lower numbers more frequently. This prevents from corpus being refreshed too quickly, especially when MaxFiles is set to low value (ex. 3000). This setting is ignored if UseSubjectsAsMaillogNames is set to ON, which highly recommended.<br />
 Recommended: 0.5, Default: 1',undef,undef,'msg006090','msg006091'],
['UseSubjectsAsMaillogNames','Use Subject as Maillog Names',0,\&checkbox,'1','(.*)','ConfigChangeUSAMN',
  'You can turn this on to help you manually identify mail in your spam and non-spam collections. This will prevent ASSP from controlling the number of files in your collections(-> MaxFiles ). It is recommended to switch on MaintBayesCollection and to setup MaxNoBayesFileAge to your needs, if you have switched on this option.',undef,undef,'msg006100','msg006101'],
['MaxAllowedDups','Max Number of Duplicate File Names',5,\&textinput,0,'(\d+)','ConfigChangeMaxAllowedDups',
  'The maximum number of logged files with the same or similar filename (subject) that are stored in the spam folder (spamlog), if UseSubjectsAsMaillogNames is selected. Default is 0. An low value reduces the number of possibly duplicate mails, assuming that mails with the same or similar subject will have the same content. A value of 0 disables this feature. If this number of files with the same or similar filename is reached, the oldest file with the same subject will be moved to the discarded folder, which has to be defined ( in addition to spamlog ) for this feature to work.<br />
  Depending on the count of files in the spam folder, this feature may allocate a large amount of memory! Do not use this feature on systems with a high workload!<br />
  A setting from zero to another value, will start the file maintenance for the spam folder immediatly.<br />
  It is safe to use ConfigChangeSchedule to set and unset this value at scheduled times (e.g. once a week or every night).', undef, undef,'msg008660','msg008661'],
['AllowedDupSubjectRe','Regular Expression to Identify allowed duplicate Subjects*',80,\&textinput,'','(.*)','ConfigCompileRe','Messages their subject matches this regular expression will be collected regardless the setting in MaxAllowedDups .',undef,undef,'msg008670','msg008671'],
['UseUnicode4MaillogNames','Use Unicode to build Maillog Names',0,\&checkbox,'','(.*)',undef,
  'If you have switched on UseSubjectsAsMaillogNames and your default (local language) characterset (please setup ConsoleCharset) needs 8 Bit like "KOI8-r","CP-866","Windows-1251","Windows-1252","ISO-8859-X","X-Mac-Cyrillic","JIS_X0201" or any other (or is UTF-8) - and you want to have readable filenames in the maillog and on the console screen, you can switch on this option. The resolution of some characters written to the console could be incorrect depending on your operating system. This requires an installed <a href="http://metacpan.org/search?q=Email::MIME" rel="external">Email::MIME</a> module in PERL.<br />
  If in addition the module <a href="http://metacpan.org/search?q=Win32::Unicode" rel="external">Win32::Unicode</a> is installed on windows platforms, assp will generate unicode filenames for the collected corpus files (already on nix systems).',undef,undef,'msg006110','msg006111'],
['UseUnicode4SubjectLogging','Use Unicode to build Subjects in Maillog',0,\&checkbox,'','(.*)',undef,
  'If you have switched on UseUnicode4SubjectLogging and your default (local language) characterset (please setup ConsoleCharset) needs 8 Bit like "KOI8-r","CP-866","Windows-1251","Windows-1252","ISO-8859-X","X-Mac-Cyrillic","JIS_X0201" or any other (or is UTF-8) - and you want to have a readable subject in the maillog and on the console screen, you can switch on this option. The resolution of some characters written to the console could be incorrect depending on your operating system. This requires an installed <a href="http://metacpan.org/search?q=Email::MIME" rel="external">Email::MIME</a> module in PERL.',undef,undef,'msg008920','msg008921'],
['MaxFileNameLength','Max Length of File Names',10,\&textinput,50,'(\d+)',undef,
  'The maximum character count that is used from the mail subject to build the file name of the logged file, if UseSubjectsAsMaillogNames is selected. This could be useful, if your mail clients having trouble to build the resend file name (right button - URL) correctly in block reports. Every non printable character will be replaced by a 4 byte string in this link.',undef,undef,'msg006130','msg006131'],
['MaintBayesCollection','Maintenance for Bayesian Collection',0,\&checkbox,'1','(.*)',undef,
  'Set this to on, if you want ASSP to run a maintenance tasks on the bayesian collection folders ( spamlog , notspamlog , correctedspam , correctednotspam ). ASSP will delete the oldest files until the number of files per folder reaches MaxFiles. If you want ASSP to delete files because of their age instead of the number of files ( MaxFiles ), setup MaxBayesFileAge and/or MaxCorrectedDays to your needs.<br />
  MaintBayesCollection is useful, if UseSubjectsAsMaillogNames is set to on and doMove2Num is set to off, because in this case the number of files in every collection folder will grow infinite. If set to On, the rebuildspamdb task will also do the cleanup.',undef,undef,'msg006140','msg006141'],
['MaxBayesFileAge','Max Age of Bayes Files',15,\&textinput,31,'^(\d+|\d+\s+\d+)$',undef,
  'The maximum file age in days of every file in every bayesian collection folder ( spamlog , notspamlog ). If MaintBayesCollection is set to on and a file is older than this number in days, the file will be deleted. Default is 31. A value of 0 disables this feature and no file will be deleted because of its age. To use different values for spamlog and notspamlog, define two space separated values - the first for spamlog and the second for notspamlog, like \'30 60\'. The rebuildspamdb task will ignore files older than this days (if not zero).<br />
  <span class = "negative">It is not recommended to enable this option, if you use the bayesian engine of ASSP and doMove2Num is set to ON.  A better solution in this case is, to have MaintBayesCollection take care of deletions (by date) and change this setting to 0.</span>',undef,undef,'msg006150','msg006151'],
['MaxCorrectedDays','Max Corrected File Age',15,\&textinput,'10000','^(\d+|\d+\s+\d+)$',undef,'This is the number of days a error report will be kept in the correctedspam and correctednotspam folders. These folders are the longterm memory of ASSP, therefore the default is 10000 days (more than 27 years). To use different values for correctedspam and correctednotspam, define two space separated values - the first for correctedspam and the second for correctednotspam, like \'1000 1500\'. The rebuildspamdb task will ignore files older than this days (if not set to zero).',undef,undef,'msg008590','msg008591'],
['MaxNoBayesFileAge','Max Age of non Bayes Files',15,\&textinput,31,'^(\d+|\d+\s+\d+\s+\d+)$',undef,
  'The maximum file age in days of every file in every non bayesian collection folder ( incomingOkMail , discarded , viruslog ). If defined and a file is older than this number in days, the file will be deleted. Default is 31. A value of 0 disables this feature and no file will be deleted because of its age. To use different values for incomingOkMail and discarded and viruslog, define three space separated values - the first for incomingOkMail and the second for discarded and the third for viruslog, like \'31 45 60\'',undef,undef,'msg006160','msg006161'],
['MaxFileAgeSchedule','Runtime for MaintBayesCollection and MaxNoBayesFileAge <sup>s</sup>',40,\&textinput,'1',$ScheduleGUIRe,'configChangeSched',
  'Runtime hour for deleting old collected files (bayes and non bayes). Set a number between 0 and 23. 0 means midnight, 1 is default. If empty a cleanup will not be scheduled. This could be fine, if a rebuildspamdb is scheduled, which will also do the cleanup based on the settings of MaintBayesCollection , MaxBayesFileAge and MaxCorrectedDays - but it will not maintain incomingOkMail , discarded and viruslog based on MaxNoBayesFileAge !',undef,undef,'msg006170','msg006171'],
['MaxBytes','Max Bytes',10,\&textinput,4000,'(\d+)',undef,
  'How many bytes of the message body will ASSP look at - the message header is always included in all checks. Mails stored in the collecting folders will be truncated to this size, if StoreCompleteMail is disabled. The average of Ham messages (message body) is 6K, the average of Spam messages is 3K. Usually the spam folder will be filled quicker than the notspam folder, therefore set this value to 4000 to get more wordpairs per Ham Message. When both folders are close to the maxfiles limit, reduce it to 3000.<br />
  If your system is fast enough and has enough RAM multiply all the above recommendations and the default value by ten.',undef,undef,'msg006180','msg006181'],
['StoreCompleteMail','Store the Complete Mail','0:disabled|100000:up to 100 kByte|500000:up to 500 kByte|1000000:up to 1 MByte|10000000:up to 10 MByte|999999999:no limit',\&listbox,999999999,'(\d*)',undef,
  'If set, ASSP will look at MaxBytes, but if possible it will store the complete mail up to the number of bytes configured. This could be useful for example, if you want resend blocked messages. Be careful using this option, your disk could be filled up very fast!',undef,undef,'msg006190','msg006191'],
['NonSpamLog','Non Spam','0:no collection|2:notspam folder',\&listbox,2,'(\d*)',undef,'Where to store whitelisted/local non spam messages. Default: notspam folder ( notspamlog ).',undef,undef,'msg006210','msg006211'],
['baysNonSpamLog','OK Mail','0:no collection|2:notspam folder|4:okmail folder',\&listbox,0 ,'(\d*)',undef,'Where to store non spam (message ok) messages. These are messages which are considered as HAM, but should not stored in the standard HAM folder because of our policy to use only confirmed HAM messages (whitelisted or local) for SpamDB. Set incomingOkMail accordingly if you choose \'okmail folder\'. Default: no collection',undef,undef,'msg006220','msg006221'],
['SpamLog','Store Spam','0:disabled|1:enabled',\&listbox,1,'(\d*)',undef,'Set this to \'disabled\' if you do not want to store any Spam regardless of settings in. Default: enabled (store in folder spamlog ).',undef,undef,'msg006230','msg006231'],
['noProcessingLog','NoProcessing OK Mails','0:no collection|4:okmail folder',\&listbox,4,'(\d*)',undef,'Where to store noprocessing OK mails.',undef,undef,'msg006240','msg006241'],
['npAttachLog','NoProcessing rejected Attachments','0:no collection|5:attachment folder|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,7,'(\d*)',undef,'Where to store noprocessing rejected mail+attachments. Recommended: discard folder ( discarded ) &amp; sendAllSpam',undef,undef,'msg006250','msg006251'],
['wlAttachLog','Whitelisted rejected Attachments','0:no collection|5:attachment folder|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,7,'(\d*)',undef,'Where to store whitelisted rejected mail+attachments. Recommended: discard folder ( discarded ) &amp; sendAllSpam',undef,undef,'msg006260','msg006261'],
['extAttachLog','External rejected Attachments','0:no collection|5:attachment folder|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,7,'(\d*)',undef,'Where to store external rejected mail+attachments. Recommended: discard folder ( discarded ) &amp; sendAllSpam',undef,undef,'msg006270','msg006271'],
['SpamVirusLog','Virus Infected','0:no collection|5:quarantine|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,5,'(\d*)',undef,'Where to store virus infected messages. Recommended: quarantine ( quarantine )',undef,undef,'msg006280','msg006281'],
['spamBombLog','Spam Bombs','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,6,'(\d*)',undef,'Where to store spam bombs. Recommended: discard folder ( discarded )',undef,undef,'msg006290','msg006291'],
['scriptLog','Scripts','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store scripted messages. Recommended: spam folder   ( spamlog )  &amp; sendAllSpam',undef,undef,'msg006300','msg006301'],

['blDomainLog','Blacklisted Domains','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store blacklisted domain messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006310','msg006311'],
['spamHeloLog','Blacklisted Helos','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,7,'(\d*)',undef,'Where to store spam helo messages. Recommended: discard folder ( discarded ) &amp; sendAllSpam',undef,undef,'msg006320','msg006321'],
['forgedHeloLog','Forged Helos','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,0,'(\d*)',undef,'Where to store forged helo messages. Recommended: no collection',undef,undef,'msg006330','msg006331'],
['invalidHeloLog','Invalid Helos','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,6,'(\d*)',undef,'Where to store invalid helo messages. Recommended: discard folder ( discarded )',undef,undef,'msg006340','msg006341'],
['spamBucketLog','Spam Collect Addresses','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,1,'(\d*)',undef,'Where to store mails addressed to Spam Collect Addresses. Recommended: spam folder ( spamlog )',undef,undef,'msg006350','msg006351'],
['baysSpamLog','HMM and Bayesian Spams','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,7,'(\d*)',undef,'Where to store HMM and Bayesian spam messages. Recommended: discard folder ( discarded ) &amp; sendAllSpam',undef,undef,'msg006360','msg006361'],
['SPFFailLog','SPF Failures','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store SPF Failure spam messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006370','msg006371'],
['RBLFailLog','DNSBL Failures','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store DNSBL Failure spam messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006380','msg006381'],
['URIBLFailLog','URIBL Failures','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store URIBL Failure spam messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006390','msg006391'],
['SRSFailLog','SRS Failures','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store SRS Failure (not signed bounces) spam messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006400','msg006401'],
['spamPTRLog','Missing/Invalid Pointer ','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store Missing/Invalid Pointer rejected messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006410','msg006411'],
['spamMXALog','Missing MX Record ','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store Missing MX record rejected messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006420','msg006421'],
['spamISLog','Invalid Local Sender','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,0,'(\d*)',undef,'Where to store messages from a local domain with an unknown userpart. Recommended: no collection',undef,undef,'msg006430','msg006431'],
['spamSBLog','Blocked Country','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store messages from a blocked country. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006440','msg006441'],
['spamMSLog','Message Limit Blocks','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store Message Scoring Limit rejected messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006450','msg006451'],
['spamPBLog','PenaltyBox Blocks','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store PB rejected messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006460','msg006461'],

['DKIMLog','DKIM failed','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store DKIM rejected messages. Recommended: spam folder ( spamlog ) &amp; sendAllSpam',undef,undef,'msg006470','msg006471'],
['BackLog','Backscatter check failed','0:no collection|1:spam folder|3:spam folder &amp; sendAllSpam|6:discard folder|7:discard folder &amp; sendAllSpam',\&listbox,6,'(\d*)',undef,'Where to store backscatter (MSGID-signing, BATV, DNS-Backscatter) rejected messages. Recommended: no collection',undef,undef,'msg006480','msg006481'],
['freqNonSpam','Non Spam Collection Frequency',5,\&textinput,1,'(\d*)','updateLog2','Store every n\'th non spam message. If you set the value to 10 then every 10th message is logged. These frequency settings are for ASSP users with a mature installation who experience heavy mail or spam volumes. Enter a larger value if the non spam corpus is being refreshed too quickly. Default Value = 1, log every message. Leave it at the default value 1, if you use BlockReports.',undef,undef,'msg006490','msg006491'],
['freqSpam','Spam Collection Frequency',5,\&textinput,1,'(\d*)','updateLog3','Store every n\'th spam message. The same as for non spam but helps prevent spam corpuses being skewed by flooding. It is recommended that this be set depending on spam volume. Default value = 1, log every message. Leave it at the default value 1, if you use BlockReports.<br /><hr /><div class="cfgnotes">Notes On Collecting</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/collecting.txt\',3);" />',undef,undef,'msg006500','msg006501'],

[0,0,0,'heading','Logging and Notifications'],
['Notify','Notification Email To',80,\&textinput,'','^$|((?:'.$EmailAdrRe.'\@'.$EmailDomainRe.')(?:\s*,\s*'.$EmailAdrRe.'\@'.$EmailDomainRe.')*)',undef,
  'Email address(es) to which you want ASSP to send a notification email per default, if a matching log entry ( NotifyRe , NoNotifyRe ) is found. Separate multiple entries by comma ",".<br />
  NOTICE: that groups are not allowed to be used here!',undef,undef,'msg006510','msg006511'],
['NotifyRe','Do Notify, if log entry matches*',60,\&textinput,'','(.*)','ConfigCompileNotifyRe','Regular Expression to identify loglines for which a notification message should be send.<br />
  useful entries are:<br />
  Info: new assp version - to get informed about new available assp versions<br />
  info: autoupdate: new assp version - to get informed about an autoupdate of the running script<br />
  adminupdate: - for config changes<br />
  admininfo: - for admin information<br />
  option list file: - for option file reload<br />
  error: - for any error<br />
  warning: - for any warning<br />
  restart - to detect a ASSP restart<br />
  notification: too many recipients - for local frequency abuse once per day and sender<br />
  warning: too many recipients - for every local frequency abuse<br />
  MainThread started - to detect a start of ASSP<br />
  Admin connection - for GUI logon<br /><br />
  You may define a comma separated list (after \'=>\') of recipients in every line, this will override the default recipient defined in \'Notify\'.<br />
  for example: adminupdate:=>user1@yourdomain.com,user2@yourdomain.com.<br />
  NOTICE: that groups are not allowed to be used for the second parameter!<br />
  As third parameter after a second (\'=>\') you can define the subject line for the notification message.<br />
  for example: adminupdate:=>user1@yourdomain.com,user2@yourdomain.com=>configuration was changed<br />
  or: adminupdate:=>=>configuration was changed.',undef,undef,'msg006520','msg006521'],
['NoNotifyRe','Do NOT Notify, if log entry matches*',60,\&textinput,'','(.*)','ConfigCompileRe','Regular Expression to identify loglines for which no notification message should be send.<br />
  for example:<br />
  user root - if root does anything<br />
  \[root.*?\] - if root changes the config',undef,undef,'msg006530','msg006531'],
['fileLogging','File name logging',0,\&checkbox,'','(.*)',undef,'Show file names of collected spam/notspam in log. Will be automatically set to on, if inclResendLink is not set to disabled.',undef,undef,'msg006540','msg006541'],
['subjectLogging','Subject logging',0,\&checkbox,1,'(.*)',undef,'Show subject of mail in log ',undef,undef,'msg006550','msg006551'],
['subjectStart','Subject Start Delimiter',2,\&textinput,'[','(.*)',undef,'Start delimiter of subject in log ',undef,undef,'msg006560','msg006561'],
['subjectEnd','Subject End Delimiter',2,\&textinput,']','(.*)',undef,'End delimiter of subject in log',undef,undef,'msg006570','msg006571'],
['regexLogging','Regex Match logging',0,\&checkbox,1,'(.*)',undef,'Show matching regex in log, note that all lists (like eg. noprocessing-list) are used as regex. ',undef,undef,'msg006580','msg006581'],
['WorkerLogging','Worker logging',0,\&checkbox,1,'(.*)',undef,'Show Workername in Log. ',undef,undef,'msg006590','msg006591'],
['ipmatchLogging','IP Matches Logging',0,\&checkbox,'','(.*)',undef,
  'Enables logging of IP addresses matches in the maillog. Will show a comment instead of the range if there is text after the IP ranges (and before any number sign)  eg. 182.82.10.0/24 AOL',undef,undef,'msg006600','msg006601'],
['slmatchLogging','Logging Address Matches',0,\&checkbox,'','(.*)',undef,
  'Enables logging of address matches in the maillog.',undef,undef,'msg006610','msg006611'],
['AddRegexHeader','Add RegEx Match Header',0,\&checkbox,'','(.*)',undef,'',undef,undef,'msg006620','msg006621'],
['uniqeIDLogging','Unique ID logging',0,\&checkbox,1,'(.*)',undef,'Add unique string to log  ',undef,undef,'msg006630','msg006631'],
['uniqueIDPrefix','Prepend Unique ID logging',10,\&textinput,'m1-','(.*)',undef,
  'Prepend ID. For example: m1-',undef,undef,'msg006640','msg006641'],
['tagLogging','Spam Tag Logging',0,\&checkbox,1,'(.*)',undef,'Add spam tag to log.',undef,undef,'msg006650','msg006651'],

['replyLogging','SMTP Status Code Reply Logging','0:disabled|1:enabled - exclude [123]XX|2:enabled - all',\&listbox,1 ,'(\d*)',undef,'',undef,undef,'msg006660','msg006661'],
['expandedLogging','Logging Records include IP &amp; MailFrom',0,\&checkbox,1,'(.*)',undef,'',undef,undef,'msg006670','msg006671'],

['sysLog','SYSLOG Centralized Logging',0,\&checkbox,'','(.*)','ConfigChangeSysLog','Enables logging to UNIX or Network Syslog.<br />
  Needs the Perl module Sys::Syslog for local UNIX/LINUX or Windows Eventlog logging.<br />
  If enabled and useSysSyslog is enabled and any of sysLogIp or sysLogPort is not set, local UNIX/LINUX or Windows Eventlog logging is used. It is not recommended to log to the Windows Eventlog!',undef,undef,'msg006680','msg006681'],
['sysLogPort','Syslog Port (UDP)',5,\&textinput,'514','^(' . $PortRe .'|)$','ConfigChangeSysLog',
  'Port for Network Syslog logging.',undef,undef,'msg006690','msg006691'],
['SysLogFac','Syslog Facility',40,\&textinput,'mail','(\S*)','ConfigChangeSysLog',
  'Syslog Facility. Valid are kern, user, mail, daemon, auth, syslog, lpr, news, uucp, cron, authpriv, ftp, local0, local1, local2, local3, local4, local5, local6',undef,undef,'msg006700','msg006701'],
['sysLogIp','Syslog IP',40,\&textinput,'','^(' . $HostRe .'|)$','ConfigChangeSysLog',
  'IP Address or hostname of your Network Syslog Daemon for Syslog logging.',undef,undef,'msg006710','msg006711'],
['asspLog','ASSP local logging',0,\&checkbox,'1','(.*)',undef,'ASSP manages local logging. The logs (logfile) are stored inside the directory where ASSP is installed.',undef,undef,'msg006720','msg006721'],
['LogRollDays','Roll the Logfile How Often?',5,\&textinput,'1','([1-9]\d*)','ConfigChangeLogRollDays',
  'ASSP closes and renames the log file after this number of days. Leave this at the default value 1, if you use BlockReporting.',undef,undef,'msg006730','msg006731'],
['LogNameDate','LogName Date Format',30,\&textinput,'YY-MM-DD','^((?:YY(?:YY)?-)?MM-DD)$',undef,'The standard name for the logfile is YY-MM-DD.maillog.txt, use this option to set it to your needs.<br />
 possible values are:<br />
 YY-MM-DD (default)<br />
 YYYY-MM-DD<br />
 MM-DD',undef,undef,'msg006740','msg006741'],
['LogDateFormat','Date/Time Format in LogDate',30,\&textinput,'MMM-DD-YY hh:mm:ss','((?:(?:MM|MMM|DD|DDD|YY|YYYY)(?:[\_\-\. \/]|)){3}(?:[\-\_ ]*)(?:(?:hh|mm|ss)(?:[\.:\-\_]|)){3})',undef,'Use this option to set the logdate. The default value is \'MMM-DD-YY hh:mm:ss\'. The following (case sensitive !) replacements will be done:<br /><br />
 YYYY - year four digits<br />
 YY - year two digits<br />
 MMM - month (three characters) alpha numeric - like Oct Nov Dec<br />
 MM - month numeric two digits<br />
 DDD - day (three characters) alpha numeric - like Mon Tue Fri<br />
 DD - day numeric two digits<br />
 hh - hour two digits<br />
 mm - minute two digits<br />
 ss - second two digits<br /><br />
 <b>NOTICE: If you change this value, BlockReports and Griplist-uploads will not work for log entries in the past (from now)!</b><br />
 <span class="positive">An value has to be defined for every part of the date/time, the date must be the first part. Allowed separators in date part are \'_ -./\' - in time part \'-_.:\' .</span>',undef,undef,'msg008690','msg008691'],
['LogDateLang','Date/Time Language','0:English|1:Franais|2:Deutsch|3:Espaol|4:Portugus|5:Nederlands|6:Italiano|7:Norsk|8:Svenska|9:Dansk|10:suomi|11:Magyar|12:polski|13:Romaneste',\&listbox,0,'(.*)',undef,
  'Select the language for the day and month if LogDateFormat contains DDD and/or MMM.<br />
  <b>NOTICE: If you change this value, BlockReports and Griplist-uploads will not work for log entries in the past (from now)!</b>',undef,undef,'msg008700','msg008701'],
['silent','Silent Mode',0,\&checkbox,'','(.*)',undef,
  'Checked means don\'t print log messages to the console. AsADaemon overrides this.',undef,undef,'msg006750','msg006751'],
['debug','General Debug Mode',0,\&checkbox,'','(.*)','ConfigDEBUG',
  'Checked sends debugging info to a .dbg file. Debug is enabled for all Threads, all the time! debugIP and debugRe will be ignored!
  Leave this unchecked unless there is a program error you are trying to track down.',undef,undef,'msg006760','msg006761'],
['debugIP','Debug these IPs*',40,\&textinput,'','(\S*)','ConfigMakeIPRe',
  'Enter IP addresses that you want to be debugged, separated by pipes (|). The local and the remote IP of the connection will be checked!<br />
  Not blank sends debugging info to a .dbg file. Leave this blank unless there is a program error you are trying to track down.<br />
  This can be IP address of the SMTP service monitoring agent. For example:  127.0.0.1|172.16.',undef,'7','msg006770','msg006771'],
['debugRe', 'Regular Expression to Identify Debug-Messages*',80,\&textinput,'','(.*)','ConfigCompileRe',
 'Put anything here to identify messages that you want to be debugged.  Not blank sends debugging info to a .dbg file. Leave this blank unless there is a program error you are trying to track down.',undef,undef,'msg006780','msg006781'],
['debugCode', 'Run this Code to switch on Debug',80,\&textinput,'','(.*)',undef,
 'Put a code line here, to detect messages that you want to debug. The code line has to return 0 or 1. A return of 1 will switch on debug.<br />
  for example:<br /><br />
  $Con{$fh}->{isbounce}<br />
  This code line will switch on debug for all bounce messages.<br /><br />
  ($Con{$fh}->{relayok} && $Con{$fh}->{isbounce})<br />
  This code line will switch on debug for all outgoing bounce messages.<br /><br />
  ($Con{$fh}->{ispip} && $Con{$fh}->{cip} =~ /^193\.2\.1\./)<br />
  This code line will switch on debug if the messages is from ISP and the IP of the server that was connected to the ISP begins with 193.2.1. .<br /><br />
  To use this option, you need to know the internal ASSP variables and their usage!',undef,undef,'msg006790','msg006791'],
['debugNoWriteBody','Do not write Body to Debug',0,\&checkbox,'','(.*)',undef,'If selected, the sent message body data will not be written to the debug file.',undef,undef,'msg006800','msg006801'],
['DataBaseDebug','Database Connection Debug Mode',0,\&checkbox,'','(.*)',undef,'Select to debug the database connections!',undef,undef,'msg006810','msg006811'],
['ConTimeOutDebug','Connection Timeout Debug Mode',0,\&checkbox,'','(.*)',undef,'Select to debug SMTP connections that are running into timeout!',undef,undef,'msg006820','msg006821'],
['IgnoreMIMEErrors','Ignore MIME Errors',0,\&checkbox,1,'(.*)',undef,'If selected - Errors, based on wrong email MIME contents, will not be written to log!',undef,undef,'msg006830','msg006831'],
['noLog','Don\'t Log these IPs*',40,\&textinput,'','(\S*)','ConfigMakeIPRe',
  'Enter IP addresses that you don\'t want to be logged, separated by pipes (|). The local and the remote IP of the connection will be checked!<br />
  This can be IP address of the SMTP service monitoring agent. For example:  127.0.0.1|172.16.',undef,'7','msg006840','msg006841'],
['noLogRe', 'Regular Expression to Identify NoLog-Messages*',80,\&textinput,'','(.*)','ConfigCompileRe',
 'Put anything here to identify messages that you don\'t want to be logged.',undef,undef,'msg006850','msg006851'],
['allLogRe', 'Regular Expression to Identify Messages from/to Problematic Addresses *',80,\&textinput,'','(.*)','ConfigCompileRe',
 'Put anything here to identify messages from/to addresses you want to look at for problem solving. Messages identified will also be set to StoreCompleteMail.',undef,undef,'msg006860','msg006861'],
['noLogLineRe', 'Regular Expression to Identify skipped Log Lines*',80,\&textinput,'','(.*)','ConfigCompileRe',
 'Put anything here to identify log Lines that you don\'t want to be logged.',undef,undef,'msg008680','msg008681'],
['ConnectionLog','Connections Logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  'Increase this value to investigate and solve problems related to connections.<br />
  Expanded ConnectionLog and SessionLog may help to find configuration mistakes and to solve most problems.',undef,undef,'msg006870','msg006871'],
['SessionLog','Session Logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  'Increase this value to investigate and solve problems related to check processing, file logging, limits, forwarding and others.<br />
  Expanded ConnectionLog and SessionLog may help to find configuration mistakes and to solve most problems.',undef,undef,'msg006880','msg006881'],
['denySMTPLog','Enables Logging for \'Deny SMTP Connections From\'','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,'',undef,undef,'msg006890','msg006891'],
['RWLLog','Enable RWL logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg006900','msg006901'],
['LDAPLog','Enable LDAP logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  'ATTENTION: diagnostic will possibly write credential information in clear text to the log!',undef,undef,'msg006910','msg006911'],
['VRFYLog','Enable VRFY logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg006920','msg006921'],
['ValidateUserLog','Enable User Validation logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg006930','msg006931'],
['PenaltyLog','Enable PenaltyBox logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(\d*)',undef,
  '',undef,undef,'msg006940','msg006941'],
['PenaltyExtremeLog','Enable PenaltyBox-Extreme-Value logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(\d*)',undef,
  '',undef,undef,'msg006950','msg006951'],
['MessageLog','Enable Message Scoring logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg006960','msg006961'],
['MSGIDsigLog','Enable Message-ID signing logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg006970','msg006971'],
['BacksctrLog','Enable DNS-Backscatter detection logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg006980','msg006981'],
['BATVLog','Enable BATV logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg006990','msg006991'],
['ValidateSenderLog','Enable Validate Sender Logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007000','msg007001'],
['SenderBaseLog','Enable SenderBase Logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007010','msg007011'],
['DelayLog','Enable Greylisting/Delaying logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007020','msg007021'],
['BombLog','Enable Bomb logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  'If set to verbose, the reporting to the logfile and the X-ASSP- scoring header will show the complete list of all hits. Otherwise only the highest match will be shown.',undef,undef,'msg007030','msg007031'],
['AttachmentLog','Enable Attachment logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007040','msg007041'],
['SPFLog','Enable SPF logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007050','msg007051'],
['RBLLog','Enable DNSBL logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007060','msg007061'],
['URIBLLog','Enable URIBL logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007070','msg007071'],
['ScanLog','Enable VirusScan logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007080','msg007081'],
['DKIMlogging','Enable DKIM logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  'DKIM and ARC signing log level. Set to diagnostic, the generated signatures will be veryfied after creation.',undef,undef,'msg007090','msg007091'],
['WorkerLog','Enable thread action logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,0,'(.*)',undef,
  '',undef,undef,'msg007100','msg007101'],
['SignalLog','Enable central Perl-signal logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  'nolog will handle the Perl signals without any output (this should be never set!!!), standard will write a message to log, verbose will write a message to log and to file debugSignal.txt',undef,undef,'msg007110','msg007111'],
['BayesianLog','Enable Bayesian Logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  'Enables verbose logging of Bayesian checks in the maillog.',undef,undef,'msg007120','msg007121'],
['ConvLog','Enable Conversion logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007130','msg007131'],
['MaintenanceLog','Enable Maintenance logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007140','msg007141'],
['ReportLog','Enable Report logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  'If set to diagnostic, each received report mail will be stored in the assp/debug folder.',undef,undef,'msg007160','msg007161'],
['ScheduleLog','Enable Scheduler logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg007170','msg007171'],
['SNMPLog','Enable SNMP logging','0:nolog|1:standard|2:verbose|3:diagnostic',\&listbox,1,'(.*)',undef,
  '',undef,undef,'msg009420','msg009421'],
['Showmaxreplies','Show All Possible Hits ',0,\&checkbox,'','(.*)',undef,
  'Show hits until maxreplies instead of stopping at maxhits (RBL,URIBL,RWL).',undef,undef,'msg007180','msg007181'],
['RegExLength','RegEx Length in Log',2,\&textinput,32,'(\d*)',undef,
  'Defines how many bytes of a matching Regular Expression will be shown in the log<br />
  Some matching Regular Expressions are too long for one line. Default: 32',undef,undef,'msg007190','msg007191'],
['sendNoopInfo','Send NOOP Info',0,\&checkbox,'','(.*)',undef,
  'Checked means you want ASSP to send a "NOOP Connection from IP" SMTP command to your SMTP server.<br />
  It is not recommended to enable this legacy feature - use myHelo instead.<br />
  DO NOT enable this feature, if DoTLS is enabled! Sending NOOP breaks the STARTTLS interception and processing!
  <br /><hr />
  <div class="cfgnotes">Notes On Logging</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/logging.txt\',3);" />',undef,undef,'msg007200','msg007201'],

[0,0,0,'heading','LDAP Setup <a href="https://sourceforge.net/p/assp/wiki/LDAP" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="LDAP" /></a>'],
['LDAPHost','LDAP Host(s)',80,\&textinput,'localhost','^((?:(?:'.$HostRe.'|'.$HostPortRe.')(?:\|(?:'.$HostRe.'|'.$HostPortRe.'))*)|)$','updateLDAPHost','Enter the DNS-name(s) or IP address(es) of the server(s) that run(s) the <a href="http://ldap.perl.org/FAQ.html">LDAP</a> database. Second entry is backup. For example: localhost. Separate entries with pipes: LDAP-1.domain.com|LDAP-2.domain.com . To use a different than the default LDAP port, define host:port.' ,undef,undef,'msg007210','msg007211'],
['DoLDAPSSL','Use SSL with LDAP (ldaps)','0:no|1:SSL|2:TLS',\&listbox,'0','(.*)',undef,'ASSP will use \'ldaps (SSL port 636)\' instead of ldap (port 389) or \'ldaps (TLS over port 389)\'. The Perl module <a href="http://metacpan.org/search?q=IO::Socket::SSL" rel="external">IO::Socket::SSL</a> must be installed to use SSL or TLS!',undef,undef,'msg007220','msg007221'],
['LDAPtimeout','LDAP Query Timeout',2,\&textinput,15,'(\d+)',undef,'timeout when connecting to the remote server. The default is 15 seconds.',undef,undef,'msg007230','msg007231'],
['LDAPLogin','LDAP Login',80,\&passinput,'','(.*)',undef,'Most LDAP servers require a login and password before they allow queries.<br />
 Enter the DN specification for a user with sufficient permissions here.<br />
 For example: CN=Administrator,CN=Users,DC=yourcompany,DC=com',undef,undef,'msg007240','msg007241'],
['LDAPPassword','LDAP Password',20,\&passinput,'','(.*)',undef,'Enter the password for the specified LDAP login here.',undef,undef,'msg007250','msg007251'],
['LDAPVersion','LDAP Version',1,\&textinput,3,'(\d+)',undef,'Enter the version for the specified LDAP here.',undef,undef,'msg007260','msg007261'],
['ldLDAPRoot','LDAP Root container for Local Domains',80,\&textinput,'','(.*)',undef,'The LDAP lookup will use this container and all sub-containers to match the local domain query.<br />
 The literal DOMAIN is replaced by the domain part of SMTP recipient (eg. domain.com) during the search.<br />
 For example: DC=yourcompany,DC=com.<br />
 If you use DOMAIN here, you must check "LDAP failures return false" below or non local domains will be treated as local. If not defined, LDAPRoot will be used.',undef,undef,'msg009350','msg009351'],
['ldLDAPFilter','LDAP Filter for Local Domains',80,\&textinput,'','(\S*)',undef,'This filter is used to query the LDAP database. This strongly depends on the LDAP structure.<br />
  The filter must return an entry if the domain must be relayed.<br />
  The literal DOMAIN is replaced by the domain name during the search.<br />
  for example: (&amp;(|(|(|(|(&amp;(objectclass=user)(objectcategory=person))(objectcategory=group))(objectclass=publicfolder))(!(objectclass=contact)))(objectclass=msExchDynamicDistributionList))(proxyaddresses=smtp:*@DOMAIN))',undef,undef,'msg007280','msg007281'],
['LDAPRoot','LDAP Root container for Local Addresses',80,\&textinput,'','(.*)',undef,'The LDAP lookup will use this container and all sub-containers to match the local email address query.<br />
 The literal DOMAIN is replaced by the domain part of SMTP recipient (eg. domain.com) during the search.<br />
 For example: CN=Users,DC=yourcompany,DC=com or the complete domain DC=yourcompany,DC=com.<br />
 If you use DOMAIN here, you must check "LDAP failures return false" below or non local domains will be treated as local.',undef,undef,'msg007270','msg007271'],
['LDAPFilter','LDAP Filter for Local Addresses',80,\&textinput,'','(\S*)',undef,'This filter is used to query the LDAP database. This strongly depends on the LDAP structure.<br />
 The filter must return an entry if the recipient address matches with that of any user.<br />
 The literal EMAILADDRESS is replaced by the fully qualified SMTP recipient (eg. user@domain.com) during the search.<br />
 The literal USERNAME is replaced by the user part of SMTP recipient (eg. user) during the search.<br />
 The literal DOMAIN is replaced by the domain part of SMTP recipient (eg. domain.com) during the search.<br />
 Make sure, that foreign members of global addressbooks are not reported as valid addresses.<br />
 For example:<br />
 (proxyaddresses=smtp:EMAILADDRESS)<br />
 or<br />
 (|(mail=EMAILADDRESS)(mailaddress=EMAILADDRESS))<br />
 or (e.g. IBM/HCL Domino)<br />
 (&amp;(|(objectClass=dominoGroup)(&amp;(objectClass=dominoPerson)(uid=*)))(maildomain=your-domino-domain)(|(mail=EMAILADDRESS)(mailaddress=EMAILADDRESS)))<br />
 or<br />
 (&amp;(objectClass=user)(objectcategory=person)(mail=EMAILADDRESS)(!(msExchHideFromAddressLists=TRUE)))<br />
 or (eg. AD/Exchange 2013/2016)<br />
 (&amp;(|(|(|(|(&amp;(objectclass=user)(objectcategory=person))(objectcategory=group))(objectclass=publicfolder))(!(objectclass=contact)))(objectclass=msExchDynamicDistributionList))(proxyaddresses=smtp:EMAILADDRESS)(!(msExchHideFromAddressLists=TRUE)))',undef,undef,'msg007290','msg007291'],
['LDAPcrossCheckInterval','Clean Up local LDAP/VRFY Database <sup>s</sup>',40,\&textinput,12,$ScheduleGUIRe,'configChangeSched',
  'Delete outdated entries from the LDAP/VRFY cache. Check the LDAP cache to the LDAP server and/or VRFY-MTA and delete not existing entries.<br />
  Defaults to 12 hours. Is only used, if ldaplistdb is defined in the database section!',undef,undef,'msg007300','msg007301'],
['LDAPShowDB','Show local LDAP Database',40,\&textinput,'file:ldaplist','(\S*)',undef,'The directory/file with the LDAP cache database file. If you change ldaplistdb in section Filepath you must change it here too.',undef,'8','msg007310','msg007311'],
['forceLDAPcrossCheck','force to run LDAP/VRFY-CrossCheck - now.',0,\&checkbox,'','(.*)','ConfigChangeRunTaskNow','ASSP will force to run an LDAP/VRFY-CrossCheck now!<br />'. "<input type=button value=\"Apply Changes and Run LDAP VRFY-CrossCheck Now (if checked)\" onclick=\"document.forms['ASSPconfig'].theButtonX.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />&nbsp;<input type=button value=\"Refresh Browser\" onclick=\"document.forms['ASSPconfig'].theButtonRefresh.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />",undef,undef,'msg007320','msg007321'],
['MaxLDAPlistDays','Max LDAP/VRFY cache Days',5,\&textinput,'30','(\d+)',undef,'This is the number of days an address will be kept on the local LDAP/VRFY cache without any email to this address.',undef,undef,'msg007330','msg007331'],
['ldapLocalIPAddress','LDAP - Destination to Local IP-address Mapping*',40,\&textinput,'','^(\s*file\s*:\s*.+|)$','configChangeLocalIPMap',
  'You need to use the "file: ..." option for this parameter!<br />
  On windows systems at least Vista/2008 is required!<br />
  On multihomed systems with multiple default gateways, it could be required to define the local IP address (source) used for outgoing LDAP connections.<br />
  This parameter allows to define local IP addresses used for specific targets (IP\'s or hosts) - based on the local address, the system will use the right gateway/interface.<br />
  Define one entry per line, comments (#) are allowed. The syntax for an entry is \'target=>local-IP\'.<br />
  target could be any of: IP(4/6) network, IP(4/6) address, hostname, domain-name with wildcard (*).<br /><br />
  for example:<br />
  22.* => 192.168.1.1            # IP4 Network<br />
  2222:333:* => FE81::1          # IP6 Network<br />
  22.23.24.25 => 10.1.1.1,       # host IP4<br />
  1:2:3:4:5:6:7:8 => FE94::5     # host IP6<br />
  *.domain.com => 10.1.1.1       # domain<br />
  host.domain.com => 192.168.1.1 # host<br />
  * => 172.16.1.1                # default - if not defined, the system default is used<br /><br />
  NOTICE: assp will NOT check, that the local IP address is available and bound to a local interface! It will also NOT check the system routing table! YOU SHOULD KNOW WHAT YOU DO!',undef,undef,'msg010460','msg010461'],
['LDAPFail','LDAP/VRFY failures return false',20,\&checkbox,'','(.*)',undef,'If checked, when an error occurs in LDAP or VRFY lookups, the test fails.<hr /><div class="cfgnotes">Notes On LDAP </div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/ldap.txt\',3);" />',undef,undef,'msg007340','msg007341'],

[0,0,0,'heading','DNS-Client Setup'],
['UseLocalDNS','Use Local DNS',0,\&checkbox,1,'(.*)','updateUseLocalDNS','Use system default local DNS Name Servers. To use system default local DNS Servers and the configured DNSServers (below), unselect this option and define the system default local DNS Servers in addition below!<br />
  To debug the DNS queries, switch on DebugSPF, even you don\'t use the SPF-check.<br />
  All configured or local DNS Name Servers will be checked <span class="negative">this may take some time if the servers are responding slow- please wait after apply changes!</span>',undef,undef,'msg007350','msg007351'],
['DNSReuseSocket','Reuse DNS UDP Sockets',0,\&checkbox,1,'(.*)',undef,'If selected, assp will try to reuse DNS-UDP sockets as long as this is possible. Otherwise each DNS-query will create a new UDP socket for each DNS-Server. It is recommended to set this to on, because assp could use DNS-queries very extensive, which possibly forces the assp system and/or your DNS-servers to run out of available UDP sockets.',undef,undef,'msg004770','msg004771'],
['DNSResponseLog','Show DNS Name Servers Response Time in Log',0,\&checkbox,0,'(.*)',undef,'You can use this to arrange DNSServers for better performance.',undef,undef,'msg007360','msg007361'],
['DNSServers','DNS Name Servers*',80,\&textinput,'208.67.222.222|208.67.220.220','^((?:(?:'.$HostRe.'|'.$HostPortRe.')(?:\|(?:'.$HostRe.'|'.$HostPortRe.'))*)(?:\s*=>\s*'.$HostRe.'\.?)?|(?:\s*=>\s*'.$HostRe.'\.?)|)$','updateDNS',
 'DNS Name Servers IP\'s to use for DNSBL(RBL), RWL, URIBL, PTR, SPF, SenderBase, NS, and DMARC lookups. Separate multiple entries by "|" or leave blank to use system defaults. At least TWO DNS-servers should be defined or used by the system! Every DNS-query is sent to ALL (or limited - see DNSServerLimit ) enabled DNS-Servers at a time (parallel) and the fastest valid answer is used. If DNSroundRobin is enabled, each DNS-query is sent to only one DNS-server.<br />
  For example: 208.67.222.222|208.67.220.220 (<a href="http://www.opendns.com/" rel="external">OpenDNS</a>).<br />
  An DNS-query for the domain \'sourceforge.net\' is used per default to measure the speed of the used DNS-servers. If you want assp to use another domain or hostname for this, append \'=>domain.tld\' at the end of the line - like: 208.67.222.222|208.67.220.220=>myhost.com<br />
  To define the domain if you use the local DNS-servers \'UseLocalDNS\' without defining any DNS-servers here, simply write \'=>myhost.com\'.<br />
  To debug the DNS queries, switch on DebugSPF, even you don\'t use the SPF-check.<br />
  NOTICE: don\'t define any public , ISP or open DNS-Servers (eg 208.67.222.222 208.67.220.220 8.8.8.8 8.8.4.4) , if you use any of the following assp checks: DNSBL(RBL), RWL, URIBL, SenderBase ! It is recommended in EVERY case to install (and to use) at least two local DNS-Servers!<br />
  NOTICE: the DNS-server order can be changed by assp. Please read this section completely.<br />
  All configured or local DNS Name Servers will be checked <span class="negative">this may take some time if the servers are responding slow - please wait after apply changes!</span>',undef,undef,'msg007370','msg007371'],
['DNSServerLimit','Limit the Number of used DNS-Servers',5,\&textinput,0,'(\d+)','updateDNSServerLimit',
 'If set to a number &gt; zero, assp will use the defined number of fastest responding nameservers (DNSServers) for DNS queries.<br />
 Otherwise, all nameserver are used every time.<br />
 Notice: This value is not checked against the number of defined DNSServers - don\'t set nonsense here!',undef,undef,'msg010490','msg010491'],
['DNSroundRobin','Query DNS-servers in Round Robin mode',0,\&checkbox,0,'(.*)',undef,'If enabled, the available DNS-servers will be used by assp in round robin mode. Each DNS-query is sent to one DNS-Server at a time. Which DNS-servers are used and also their order is random. Remaining DNS-servers are used as fallback. This results in less DNS-queries - but increases the processing time, in case the used DNS-server does not answer fast.',undef,undef,'msg010800','msg010801'],
['host2IPminTTL','Minimum TTL used for config reload',5,\&textinput,300,'(\d+)',undef,'Minimum TTL used for config reload options, if a hostname or SPF: is used for any IP in regular expressions. This value should be not set lower than 300 seconds!',undef,undef,'msg009810','msg009811'],
['dnsLocalIPAddress','DNS / WHOIS - Destination to Local IP-address Mapping*',40,\&textinput,'','^(\s*file\s*:\s*.+|)$','configChangeLocalIPMap',
  'You need to use the "file: ..." option for this parameter!<br />
  On windows systems at least Vista/2008 is required!<br />
  On multihomed systems with multiple default gateways, it could be required to define the local IP (source) address used for DNS connections.<br />
  This parameter allows to define local IP addresses used for specific targets (IP\'s or hosts) - based on the local address, the system will use the right gateway/interface.<br />
  Define one entry per line, comments (#) are allowed. The syntax for an entry is \'target=>local-IP\'.<br />
  target could be any of: IP(4/6) network, IP(4/6) address, hostname, domain-name with wildcard (*).<br /><br />
  for example:<br />
  22.* => 192.168.1.1            # IP4 Network<br />
  2222:333:* => FE81::1          # IP6 Network<br />
  22.23.24.25 => 10.1.1.1        # host IP4<br />
  1:2:3:4:5:6:7:8 => FE94::5     # host IP6<br />
  *.domain.com => 10.1.1.1       # domain<br />
  host.domain.com => 192.168.1.1 # host<br />
  * => 172.16.1.1                # default - if not defined, the system default is used<br /><br />
  NOTICE: assp will NOT check, that the local IP address is available and bound to a local interface! It will also NOT check the system routing table! YOU SHOULD KNOW WHAT YOU DO!',undef,undef,'msg010450','msg010451'],
['maxDNSRespDist','Maximum DNS Response Time change',3,\&textinput,50,'([1-9]\d*|0|)',undef,'Maximum DNS Server response time change in milliseconds. The query order of the used nameservers is changed, if any responds time exceeds this value. Set the value to zero or empty to use a fixed DNS-Server order list.',undef,undef,'msg009800','msg009801'],
['DNStimeout','DNS Query Timeout',2,\&textinput,2,'(\d+)','updateUseLocalDNS','Global DNS Query Timeout for DNSBL, RWL, URIBL, PTR, SPF, MX and A record lookups. The default is 2 seconds.',undef,undef,'msg007380','msg007381'],
['DNSretry','DNS Query Retry',2,\&textinput,1,'(\d+)','updateUseLocalDNS','Global DNS Query Retry. Set the number of times to try the query. The default is 1.',undef,undef,'msg007390','msg007391'],
['DNSretrans','DNS Query Retrans',2,\&textinput,1,'(\d+)','updateUseLocalDNS','Global DNS Query Retransmission Interval. Set the retransmission interval. The default is 1.<br /><hr />
  <div class="cfgnotes">Notes On DNS Setup</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/DNSsetup.txt\',3);" />',undef,undef,'msg007400','msg007401'],

[0,0,0,'heading','General Server Setup'],
['ConsoleCharset','Charset for STDOUT and STDERR',$Charsets,\&listbox,'0','(.*)',undef,
 'Set the characterset/codepage for the console output to your local needs. Default is "System Default" - default conversion. To display nonASCII characters on the console screen, setup UseUnicode4MaillogNames . <span class=\'negative\'>Restart is required!</span>',undef,undef,'msg007410','msg007411'],
['normalizeUnicode','Normalize Unicode to NFKC',0,\&checkbox,'1','(.*)','ConfigChangeNormUnicode',
 'If set (which is the default and recommended), all regular expressions and both, the Bayesian- and the Hidden-Markov-Model (HMM) engine, are normalizing all characters in their engine setup and the checked email content, according to unicode <a href="http://www.unicode.org/reports/tr15/ rel=external">NFKC</a>.<br />
 In addition some extended (assp unique) unicode normalization is done for the unicode blocks "Enclosed Alphanumerics", "Enclosed Alphanumeric Supplement" , "Enclosed CJK Letters And Months" and "Enclosed Ideographic Supplement" - like: &#9312; &#9313; &#9331; &#9332; &#9352; &#9451; &#9461; &#9424; &#9398; &#127280; &#12809; &#12853; &#13003; &#127559;. Those characters are decomposed by compatibility, then recomposed by canonical equivalence (eg. to LATIN or CJK).<br />
 If this value is changed, and your system processes alot of NON-Latin mails, it is recommended to run a rebuildspamdb.<br />
 NOTICE: the rebuildspamdb task can take up to double the time, if this feature is enabled and non-LATIN mails are processed!',undef,undef,'msg010420','msg010421'],
['HTMLParser','Use this HTML Parser','0:built-in|1:HTML::Strip|2:HTML::TreeBuilder',\&listbox,1,'(.*)','ConfigChangeHTMLParser',
  'Commonly HTML/XML is used in emails. The HTML/XML tags are too variable to use them for Bayesian- and Hidden Markov Model analysis.
  For this reason, these tags are removed from the HTML/XML content to get the clean text of the email.<br />
  The assp built-in regular expression HTML-parser is now used for decades. It got large improvements over the time, how ever - the correctness is only 95%.
  But assp is able to use HTML::Strip or HTML::TreeBuilder, which are powerfull perl modules to parse HTML code nearly 100% correct.<br />
  HTML::Strip and HTML::TreeBuilder are getting their best result, if the full HTML code is provided. In case you select any of the both modules, it is recommended to set MaxBytes to 50000 (be carefull on heavy load systems - spam bomb regular expressions will take longer using 50000!).<br />
  HTML::Strip is the fastest module and the default setting, because it is written in C. If you can not install it, use the built-in or HTML::TreeBuilder.<br />
  HTML::TreeBuilder is the slowest way to parse HTML code, the assp built-in processing is three times faster, HTML::Strip is five times faster than HTML::TreeBuilder.<br />
  If you select any of the perl modules and this module is not installed, fails to load or it returns no content, assp falls back to the built-in code.','Basic',undef,'msg010610','msg010611'],
['enable8BITMIME','Enable the 8BITMIME SMTP Extension',0,\&checkbox,'1','(.*)','Config8BitMIME',
 'If enabled (default) assp offers and supports the 8BITMIME SMTP extension, if the connected peers offers and supports 8BITMIME. If this option is set, and an outgoing mail contains characters which have set the 8th bit, assp will convert the mail to base64 before DKIM signing it!',undef,undef,'msg010510','msg010511'],
['send250OK','Send 250 OK',0,\&checkbox,'','(.*)',undef,
 'Set this checkbox if you want ASSP to reply with \'250 OK\' instead of SMTP error codes (\'5xx a.b.c\') to all IP-addresses ( see send250toIP for IP-lists ). This will turn ASSP generally in some form of tarpit.',undef,undef,'msg007430','msg007431'],
['send250toIP','Send 250 OK to this list of IP-addresses*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','List of connecting IP-addresses which will get the reply \'250 OK\' instead of SMTP error codes (\'5xx a.b.c\') - see send250OK .<br />
 This is a usefull setting, if a blocked sending host got a 5xx reply and does not follow the SMTP-RFC\'s (stop and send a NDR). Instead the host permanently tries to send the same mail again and again.<br />
 Such blocked mails are internaly processed like any other SPAM mail, but the sender will not get informed about, that the mail was not delivered to the final recipient!','Basic','7','msg003560','msg003561'],
['AsADaemon','Run ASSP as a Daemon','0:No|1:Yes - externally controlled|2:Yes - run AutoRestartCmd on restart and wait|3:Yes - run AutoRestartCmd on restart and exit',\&listbox,'0','(.*)',undef,
'In all NON-Windows OS (eg. Linux/BSD/Unix/OSX...) fork and close STDOUT and STDERR file handles. <br />
 Similar to the command "perl assp.pl &amp;", but better.<br />
 If "externally controlled" is selected, ASSP simply ends and you have to restart assp from your daemon or watchdog script<br />
 If "run AutoRestartCmd on restart and wait" is selected, assp starts the OS command defined in AutoRestartCmd - assp will <b>NOT !</b> automatically terminate - the started command has to terminate/kill and to (re)start assp - like "service assp restart"!<br />
 If "run AutoRestartCmd on restart and exit" is selected, assp starts the OS command defined in AutoRestartCmd and terminates immediately!<br />
 <span class=\"negative\">It is important</span>, that (especially) linux and unix <span class=\"negative\">system shutdown scripts are waiting until ALL assp/perl processes are ended</span> (this may take up to one minute - see MaxFinConWaitTime )! Otherwise, the kernel will kill the assp/perl process at shutdown and the possibly used BerkeleyDB DB-files and environment-files <span class=\"negative\">WILL BE DESTROYED</span> and cause to <span class=\"negative\">100%</span> unexpected behavior or crashes at the next start or run!<br /><br />
  <span class="negative"> requires ASSP restart</span>',undef,undef,'msg007440','msg007441'],
['runAsUser','Run as UID',20,\&textinput,'','(\S*)',undef,'The *nix user name to assume after startup (*nix only). Use the autorestart features careful, because any restart from inside ASSP will be done with the permission of this user! If you set or change this value, make sure the defined user has full access permission to all folders and files in assp! If setFilePermOnStart is set to ON, assp will set these permissions at next start.<p><small><i>Examples:</i> assp</small></p>
  <span class="negative"> requires ASSP restart</span>',undef,undef,'msg007450','msg007451'],
['runAsGroup','Run as GID',20,\&textinput,'','(\S*)',undef,'The *nix group to assume after startup (*nix only). If you need to define supplementary groups, configure in addition runAsGroupSupplementary . The defined group should have full access permission to all folders and files in assp. If setFilePermOnStart is set to ON, assp will set these permissions at next start.<p><small><i>Examples:</i> assp</small></p>
  <span class="negative"> requires ASSP restart</span>',undef,undef,'msg007460','msg007461'],
['runAsGroupSupplementary','Run with supplementary groups',40,\&textinput,'','(\S*)',undef,'The *nix supplementary groups to assume after startup (*nix only) - requires runAsGroup to be configured.<p><small><i>Examples:</i> group1|group2</small></p>
  <span class="negative"> requires ASSP restart</span>',undef,undef,'msg000860','msg000861'],
['ChangeRoot','Change Root',40,\&textinput,'','(.*)',undef,'The new root directory to which ASSP should chroot (*nix only). If blank, no chroot jail will be used.<br />
 Note: if you use this feature, be sure to provide a complete runtime environment for assp in your chroot jail. Think about your automatic restart configuration (eg. perl location) if you use this feature! And think about what happens, if perl requires to load a module on demand, a system call is done by assp, a system library is requested on demand or a system socket is required (clamAV)! Leave this blank, if you do not really know what you do!<br />
  <span class="negative"> Requires an ASSP restart - in most cases, this feature will not work with all possible configuration setups !</span>',undef,undef,'msg007470','msg007471'],
['setFilePermOnStart','Set ASSP File Permission on Startup',0,\&checkbox,'','(.*)',undef,
 'If this parameter is set and runAsUser + runAsGroup are configured, ASSP sets the permission of all ASSP- files and directories at startup to rw-rw---- (0660) or rwxrwx--- (0770).<br />
 If there are many files in the collection folders, this task (and the next startup) will take a long time. To prevent this, it is recommended to set the folder/file ownership and permission in a shell session (chown , chmod).<br />
 This parameter is ignored on windows systems!',undef,undef,'msg007480','msg007481'],
['checkFilePermOnStart','Check ASSP File Permission on Startup',0,\&checkbox,'','(.*)',undef,'If set, ASSP checks the permission of all ASSP- files and directories at startup - all files must be writable for the running job - the minimum permission is 0600. This parameter is ignored on windows systems!',undef,undef,'msg007490','msg007491'],
['AutoRestart','Automatic Restart after Exception',0,\&checkbox,'','(.*)',undef,'If ASSP detects a main exception and it runs not as service or daemon, it will try to restart it self automatically!  If running as daemon on nix/MAC , ASSP uses the action defined in AsADaemon to restart.',undef,undef,'msg007500','msg007501'],
['AutoRestartAfterCodeChange','Automatic Restart ASSP on new or changed Script',20,\&textinput,'','^(|immed|[1-9]|1[0-9]|2[0-3])$',undef,'If selected, ASSP will restart it self, if it detects a new or changed running script. An automatic restart will not be done, if ASSP is not running as a service on windows or as daemon on linux/MAC, and AutoRestartCmd is not configured. If running as daemon on linux/MAC ( AsADaemon ) ASSP simply ends - you have to restart assp from your daemon script. Leave this field empty to disable the feature. Possible values are \'immed and 1...23\' . If set to \'immed\', assp will restart within some seconds after a detected code change. If set to \'1...23\' the restart will be scheduled to that hour. A restart at 00:00 is not supported.',undef,undef,'msg007510','msg007511'],
['AutoUpdateASSP','Auto Update the Running Script (assp.pl)','0:no auto update|1:download only|2:download and install',\&listbox,'0','(.*)','ConfigChangeAutoUpdate',
 'No action will be done if \'no auto update\' is selected. You\'ll get a hint in the GUI (top) and a log line will be written, if a new version is availabe at the download location.<br />
  If \'download only\' is selected and a new assp version is available, this new version will be downloaded to the directory ' . $base . '/download (assp.pl) and the syntax will be checked. The still running script will be saved version numbered to the download directory.<br />
  If \'download and install\' is selected, in addition the still running script will be replaced by the new version.<br />
  Configure ( AutoRestartAfterCodeChange ), if you want the new version to become the active running script.<br />
  If this value is changed to \'download and install\', the autoupdate procedure will be scheduled immediately.<br />
  If set, ASSP (on windows systems with ActivePerl installations) will search for updated Perl modules in all registered PPM repositories &nbsp;&nbsp;<input type="button" value="new available perl modules" onclick="javascript:popFileEditor(\'notes/avail_perl_modules.txt\',5);" /><br />
  The installation of some modules could require manual configuration and the installation fails or an upgrade is not recommended. In this case put the case sensitive module names (one per line) in the following file. &nbsp;&nbsp;<input type="button" value="never upgrade these modules" onclick="javascript:popFileEditor(\'files/noupgrade.txt\',1);" /><br />
  To skip the installation tests for specific modules, put the case sensitive module names followed by a comma and \'1\' (one per line) in the following file. &nbsp;&nbsp;<input type="button" value="do not test these modules" onclick="javascript:popFileEditor(\'files/noupgradetest.txt\',1);" /><br />
  If this value is set to \'download and install\', ASSP will try an autoupdate of the new available modules. It is possible, that some modules could not be installed, because the XS module parts are still in use. In this case follow the instruction - click the "new available perl modules" button above. To disable the automatic Perl module update - set "noModuleAutoUpdate" below.<br />
  Click this button to see the log file for the updated modules&nbsp;&nbsp;<input type="button" value="module upgrade log" onclick="javascript:popFileEditor(\'notes/upgraded_Perl_Modules.log\',1);" /><br />
  The perl module <a href="http://metacpan.org/search?q=Compress::Zlib/" rel="external">Compress::Zlib</a> is required to use this feature.',undef,undef,'msg008810','msg008811'],
['noModuleAutoUpdate','No Automatic Perl Module update','0:no skip - update all|1:skip all|2:skip installed but not used by assp',\&listbox,'2','(.*)',undef,
 'If set, ASSP will skip the automatic Perl module update for the selected. Default is: skip installed but not used by assp<br />
  On NIX systems assp must run as user \'root\' or the used user must have the permission to sudo without a password prompt - otherwise this value is ignored and an error is written to the maillog.txt.',undef,undef,'msg007900','msg007901'],
['AutoRestartCmd','OS-shell command for AutoRestart',100,\&textinput,'','(.*)',undef,'The OS level shell-command that is used to autorestart ASSP, if it runs not as a windows service! A possible value for your system is:<br />
 <font color=blue>$dftrestartcmd</font><br />
 Leave this field blank, if ASSP runs inside an external loop (inside the OS like assp.sh or assp.cmd).<br />
 If running on NIX systems and runAsUser and/or runAsGroup is used, don\'t forget to switch back to root permissions in the script!<br />
 For daemon actions in /etc/init.d ( see AsADaemon ), \'sudo -b\' in front of the command may be required in case runAsUser and/or runAsGroup is used - like:<br />
 <font color=blue>sudo -b /etc/init.d/assp restart</font> or <font color=blue>sudo -bs /etc/init.d/assp restart</font><br />
 In this case, the user in runAsUser must be able to \'sudo\' without providing a password ( sudoers , wheel )!',undef,undef,'msg007520','msg007521'],
['RestartEvery','Restart Timeout',10,\&textinput,'0','(\d+)','configChangeRestartEvery',
  'ASSP will automatically terminate and restart after this many seconds. Use this setting to periodically reload configuration data, combat potential memory leaks, or perform shutdown/startup processes. This will only work properly if ASSP runs as a Windows service or in a script that restarts it after it stops or AutoRestartCmd is configured. Alternative to this field you can use ReStartSchedule, to schedule restarts.',undef,undef,'msg007530','msg007531'],
['ReStartSchedule','Schedule Cron time for ASSP Restart <sup>s</sup>',50,\&textinput,'noschedule','^((?:'.$ScheduleRe.'(?:\|'.$ScheduleRe.')*)|noschedule)$','configChangeRSRBSched','If <b>not</b> set to "noschedule" (noschedule is default), ASSP uses scheduled times to shutdown or restart ( AutoRestartCmd )! The syntax is the same like in <a href="http://en.wikipedia.org/wiki/Cron" rel="external">"Vixie" cron</a>! To disable this Scheduler leave this field blank!<b> Never write quotes into this field!</b><br />
<br />
<b>Time and Date specification</b><br />
<br />
Entry is the specification of the scheduled time in crontab format,
which contains five mandatory time and date fields.
Entry can be either a plain string, which contains
a whitespace separated time and date specification.<br />
<br />
The time and date fields are (taken mostly from "Vixie" cron):<br />
<br />
<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH="50%" >
<tr><td><b>field</b></td><td><b>values</b></td></tr>
<tr><td>minute</td><td>0-59</td></tr>
<tr><td>hour</td><td>0-23</td></tr>
<tr><td>day of month</td><td>1-31</td></tr>
<tr><td>month</td><td>1-12 (or as names)</td></tr>
<tr><td>day of week</td><td>0-7 (0 or 7 is Sunday, or as names )</td></tr>
<tr><td>seconds</td><td>0-59 (optional) <b>not supported inside ASSP !!!</b></td></tr>
</table>
<br />
 A field may be an asterisk (*), which always stands for
 "first-last".<br />
<br />
 Ranges of numbers are  allowed.  Ranges are two numbers
 separated  with  a  hyphen.   The  specified  range  is
 inclusive.   For example, 8-11  for an "hours" entry
 specifies execution at hours 8, 9, 10 and 11.<br />
<br />
 Lists  are allowed.   A list  is a  set of  numbers (or
 ranges)  separated by  commas.   Examples: "1,2,5,9",
 "0-4,8-12".<br />
<br />
 Step  values can  be used  in conjunction  with ranges.
 Following a range with "/number" specifies skips of
 the  numbers value  through the  range.   For example,
 "0-23/2" can  be used in  the hours field  to specify
 command execution every other hour (the alternative in
 the V7 standard is "0,2,4,6,8,10,12,14,16,18,20,22").
 Steps are  also permitted after an asterisk,  so if you
 want to say "every two hours", just use "*/2".<br />
<br />
 Names can also  be used for the "month"  and "day of
 week"  fields.  Use  the  first three  letters of  the
 particular day or month (case doesn\'t matter).<br />
<br />
 Note:<br />
       The day of a command\'s execution can be specified
       by two fields  -- day of month, and  day of week.
       If both fields are restricted (ie, aren\'t *), the
       command will be run when either field matches the
       current  time.  For  example, "30  4 1,15  * 5"
       would cause a command to be run at 4:30 am on the
       1st and 15th of each month, plus every Friday<br />
<br />
Examples:<br />
<br />
<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH="80%" >
<tr><td>8 0 * * *</td><td>==></td><td>8 minutes after midnight, every day</td></tr>
<tr><td>5 11 * * Sat,Sun</td><td>==></td><td>at 11:05 on each Saturday and Sunday</td></tr>
<tr><td>0-59/5 * * * *</td><td>==></td><td>every five minutes</td></tr>
<tr><td>42 12 3 Feb Sat</td><td>==></td><td>at 12:42 on 3rd of February and on each Saturday in February</td></tr>
<tr><td>32 11 1-15/2 */3 *</td><td>==></td><td>at 11:32 every two days from the first to the 15. every third month</td></tr>
</table>
<br />
In addition, ranges or lists of names are allowed.<br />
If you want to define multiple entries separate them by "|"',undef,undef,'msg007540','msg007541'],
['MemoryUsageLimit','Memory Limit in MB that ASSP could use',40,\&textinput,'','^(\d+|)$',undef,
 'The memory limit in megabyte the assp process could use at maximum on your system. Set this to empty or zero to disable the feature. The check is done using the schedule defined in MemoryUsageCheckSchedule . If the assp process uses more memory than the limit at a scheduled time and assp is able to restart it self - a restart will be done within 15 seconds. The user running assp must have read access to /proc on nix systems or must have read access to the WMI provider on windows systems!',undef,undef,'msg009950','msg009951'],
['MemoryUsageCheckSchedule','Schedule(s) to check the ASSP process memory usage <sup>s</sup>',40,\&textinput,'0-59/10 * * * *','^((?:'.$ScheduleRe.'(?:\|'.$ScheduleRe.')*)|)$','configChangeSched',
 'The schedule(s) that is used to check the current memory usage of the assp process compared to the MemoryUsageLimit. Default value is (0-59/10 * * * *), which means every 10 minutes.',undef,undef,'msg009960','msg009961'],
['myName','My Name',40,\&textinput,'ASSP.nospam','('.$EmailDomainRe.')','ConfigChangeMyName',
 'ASSP will identify itself by this name in the email "Received:" header and in the helo when sending report-replies. Usually the fully qualified domain name of the host.<p><small><i>Examples:</i> assp.mydomain.com, mail.mydomain.org</small></p><br />
 <b>It is highly recommended to change this value - do NOT use the default value ASSP.nospam in production environments! Because the same hostname can be used by any other server, that uses assp and sends emails to your system.</b><br />
 If you change this value after assp was running for a long time, add the old value to myNameAlso .',undef,undef,'msg007550','msg007551'],
['myNameAlso','Additional My-Name-Definitions',40,\&textinput,'','^('.$EmailDomainRe.'(?:[\|\s,]+'.$EmailDomainRe.')*|)$','ConfigChangeMyName','If myName was changed or you use shared folders (multiple ASSP) for the corpus files, define the old or other host names here - separate multiple entries by pipe, space or comma. ASSP will use this host names in addition to myName, to detect the received headerlines while the rebuildspamdb is running and in the mail analyzer.',undef,undef,'msg007880','msg007881'],
['myHelo','My Helo','80',\&textinput,'','(.*)',undef,
 'How ASSP will identify itself when connecting to the target MTA.<br />
  The values used for incoming and outgoing/local mails are separated by "|" - for example:<br /><br />
  SENDERHELO - IP - MYNAME - FQDN | MYNAME<br /><br />
  The left part "SENDERHELO - IP - MYNAME - FQDN" is used for incoming mails, the right part "MYNAME" is used for outgoing mails.<br />
  If any part is empty or the complete parameter is not defined, the helo of the sending host is used.<br />
  Using the "IP" literal, you can tell your local MTA the connected IP address.<br />
  Any RFC compatible text can be used. DO NOT define the SMTP command HELO/EHLO, the command used by the sending host will take place!<br />
  The following case sensitive literals will be replaced with:<br /><br />
  IP - the IP address of the connected host<br />
  MYNAME - the value defined in myName<br />
  FQDN - the local operating system hostname<br />
  SENDERHELO - the helo text received from the connected host<br /><br />',undef,undef,'msg007560','msg007561'],

['HideIPandHelo','Hide IP and/or Helo',40,\&textinput,'','(.*)',undef,'Replace any of these information ( ip=127.0.0.1 helo=anyhost.local ) in our received header for outgoing mails. Use the syntax ip=127.0.0.1 and/or helo=anyhost.local .',undef,undef,'msg009830','msg009831'],
['myGreeting','Override the Server SMTP Greeting',80,\&textinput,'','(.*)',undef,'Send this SMTP greeting (eg. 220 MYNAME is ready - using ASSP VERSION) instead of your MTA\'s SMTP greeting to the client. If not defined (default), the MTA\'s greeting will be sent to the client. The literal MYNAME will be replaced with myName and the literal VERSION will be replaced by the full version string of assp. If the starting \'220 \' is not defined, assp will add it to the greeting.<br />
Multiline greetings can be defined this way: 220-first greeting line&bsol;r&bsol;n220-second greeting line&bsol;r&bsol;n220-...&bsol;r&bsol;n220 last greeting line',undef,undef,'msg010260','msg010261'],
['addErrorReplyExplanation','Add an Error-Reply-Explanation',80,\&textinput,'','(.*)',undef,'The text defined here will be added to every permanent SMTP-error-reply (starting with 5xx - except '.join(', ',sort keys(%noReplyExplain)).'). For example to add a web link, where blocking reasons are explained.<br />
e.g.:<br />
- error explanations at https://your.web.domain/block-reasons<br />
or<br />
- error explanations at https://your.web.domain/block-reasons?session=SESSIONID&amp;ip=IPCONNECTED<br /><br />
The text (and possibly a clickable link) will become visible to blocked senders in the NDR (No Delivery Report) of the blocked mail.<br />
In the second example the assp session-id and the connected IP-address are part of the link. The web server can extract the log entries for the mail from the maillog.txt and can explain much better and/or check the database for the IP reputation and ... and ...  .<br />
If you want to skip this addition for any configurable SMTP-reply, write the literal NOEXPLAIN at the end of the configured SMTP-reply definition. To force the addition for any of the above shown exceptions, add the literal FORCEEXPLAIN to the reply definition. Both literals will be removed from the reply before it is send.<br />
For example, to skip the addition in SpamError: 554 5.7.1 Mail appears to be unsolicited -- send error reports to postmaster@LOCALDOMAIN NOEXPLAIN<br />
Keep in mind, that the maximum length of a complete SMTP reply line should not exceed 512 byte (XXX text [CR][LF]).',undef,undef,'msg010790','msg010791'],
['asspCfg','assp.cfg*',40,\&textnoinput,'file:assp.cfg','(.*)','configUpdateASSPCfg','For internal use only - it is assp.cfg file. Do not change this value.',undef,undef,'msg007570','msg007571'],
['AutoReloadCfg','Automatic Reload ConfigFile',0,\&checkbox,'','(.*)','configChangeAutoReloadCfg','If selected and the assp.cfg file is changed externally, ASSP will reload the configuration from the file automatically.',undef,undef,'msg007580','msg007581'],
['asspCfgVersion','assp.cfg version',40,\&textnoinput,'','(.*)',undef,'ASSP will identify the assp.cfg file. Do not change this.',undef,undef,'msg007590','msg007591'],
['ConfigChangeSchedule','Schedule Configuration Changes*',40,\&textinput,'','(file:.+|)','configChangeConfigSched',
 'Use this option to schedule configuration changes. You must use the file option like \'file:files/configchangeschedule.txt\' to define schedules - an empty value disables this feature.<br />
 Define one schedule per line - comments are not allowed in a schedule definition line!<br />
 The line has to start with the schedule string ( see ReStartSchedule ) followed by the variable (or hidden variable ) name to change, followed by \':=\', followed by the value to change the variable to - like:<br /><br />
 8 0 * * * myNameAlso:=otherhost1.mydomain.tld<br />
 0 6 * * *|0 10 * * * myNameAlso:=otherhost2.mydomain.tld<br />
 0 1 * * * debug:=1<br />
 0 2 * * * debug:=<br /><br />
 The schedule string can contain multiple schedule definitions separated by pipe\'|\'. You will get errors if:<br />
 - the schedule definition is wrong<br />
 - the variable name is wrong (does not exists)<br />
 - the syntax of the value is wrong<br />
 Notice - assp will only check the syntax at definition time - the logical correctness of the value will be checked at the scheduled time! So, assp will (for example) not check any dependencies at definition time - if a dependency is wrong, the change request at the scheduled time will fail!<br />
 Notice - all configuration changes are done with \'root\' permission! For this reason, this configuration parameter is only visible to root and it is stored encrypted!<br /><br  />
 <span class="negative">For advanced users ONLY:<br />
 Using the following extension, requires a deep internal knowledge of the assp code!</span><br />
 It is also possible to schedule a call to an internal assp subroutine. The name of the subroutine has to begin with a \'&amp;\', the parameters that should passed to the subroutine must be in \'()\' - like:<br />
 0 6 * * * &amp;subname(var1,var2,..,...)<br />
 0 7 * * * &amp;subname()<br />
 Notice: the subroutine will be called in the MainThread and syntax check will be done at run time - possible errors are shown in the log!',undef,undef,'msg009680','msg009681'],
['proxyserver','Proxy Server',20,\&textinput,'','(\S*)','ConfigChangeProxyConf','The Proxy Server to use when uploading global statistics and downloading the greylist.<p><small><i>Examples:</i> 192.168.0.1:8080, 192.168.0.1</small></p>',undef,undef,'msg007600','msg007601'],
['proxyuser','Proxy User',20,\&passinput,'','^([^:]*)$','ConfigChangeProxyConf','The Proxy-UserName that is used to authenticate to the proxy.',undef,undef,'msg007610','msg007611'],
['proxypass','Proxy Password',20,\&passinput,'','(\S*)','ConfigChangeProxyConf','The password for Proxy-UserName that is used to authenticate to the proxy.',undef,undef,'msg007620','msg007621'],
['webAdminPort','Web Admin Port',20,\&textinput,55555,$GUIHostPort,'ConfigChangeAdminPort',
  'The port on which ASSP will listen for http connections to the web administration interface. If you change this, after you click Apply Changes you must change the URL on your browser to reconnect. You may also supply an IP address or hostname to limit connections to a specific interface. Separate multiple entries by pipe "|"!<br />
  To define a SSL listener, write \'SSL:\' in front of the host:port - e.g. SSL:host:port.<br />
  <p><small><i>Examples:</i> 55555, 192.168.0.5:12345, SSL:myhost:12345, 192.168.0.5:22345|myhost:12345</small></p>',undef,undef,'msg007630','msg007631'],
['enableWebAdminSSL','Use https instead of http',0,\&checkbox,'','(.*)','ConfigChangeEnableAdminSSL',
 'If selected the web admin interface will be only accessible using https. If you change this, after you click Apply you must change the URL on your browser to reconnect.
  This requires an installed <a href="http://metacpan.org/search?q=IO::Socket::SSL" rel="external">IO::Socket::SSL</a> module in PERL.<br />
  A server-certificate-file "certs/server-cert.pem" and a server-key-file "certs/server-key.pem" must exist and must be valid!<br />
  If you do not have valid certificates, you may generate both files online with <a href="http://www.mobilefish.com/services/ssl_certificates/ssl_certificates.php" rel="external">www.mobilefish.com</a> or you may use OpenSSL to generate <a href="http://www.mobilefish.com/developer/openssl/openssl_quickguide_self_certificate.html" rel="external">Self-signed SSL certificates</a>! More configuration options are webSSLRequireClientCert, SSLWEBCertVerifyCB and SSLWEBConfigure .',undef,undef,'msg007640','msg007641'],
['webAdminPassword','Web Admin Password - Masterpassword (root)',20,\&passinput,'nospam4me','(.{5,})','ConfigChangePassword',
 # I hate hidden password input, but if you like it, uncomment this line and comment the next one. -- just quit bugging me about it!
 #[webAdminPassword','Web Admin Password - Masterpassword (root)',20,\&textinput,'nospam4me','(.{5,})','ConfigChangePassword',
  'The password for the web administration interface for user root(minimum of 5 characters).<br />
  <span class=\"negative\"><b>DO NOT use the digits "45" as the first two characters of the password or you will be not able to login ever again!</b></span><br />
  If root is logged on, no other logins are allowed. Always use the "logoff"-button as root to terminate the session - closing the browser without logoff could cause other session to be disallowed for up to 15 minutes.',undef,undef,'msg007650','msg007651'],
['allowAdminConnectionsFrom','Only Allow Admin Connections From*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
  'An optional list of IP addresses and/or hostnames from which you will accept web admin connections. Blank means accept connections from any IP address.<br />
  <span class="negative">Note: if you make a mistake here, you may disable your web administration interface and be forced to manually edit your configuration file to fix it.</span><p><small><i>Examples:</i></small></p>
  127.0.0.1|172.16.',undef,'7','msg007660','msg007661'],
['httpRequireCookies','HTTP and HTTPS require enabled browser cookies',0,\&checkbox,'1','(.*)',undef,
 'Cookie based http session ID\'s are used by assp to handle different requests from the same IP (eg behind NAT). Switch this off, if you are unable to use cookies in your browser. If switched off, a security hole is opened for connection that are using NAT - it could be possible that a second workstation (behind NAT) is able to login to the GUI, without user credentials if the same OS and browser version is used.',undef,undef,'msg009000','msg009001'],
['webStatHealthyResp','Status Response Literal for a Healthy State of ASSP',25,\&textinput,'healthy','(.+)',undef,
  'This option must be set and it must be different to webStatNotHealthyResp. This literal will be given back in stat requests, if ASSP is working healthy.',undef,undef,'msg009260','msg009261'],
['webStatNotHealthyResp','Status Response Literal for a Not Healthy State of ASSP',25,\&textinput,'not healthy','(.+)',undef,
  'This option must be set and it must be different to webStatHealthyResp. This literal will be given back in stat requests, if ASSP is working not healthy.',undef,undef,'msg009270','msg009271'],
['webStatPort','Raw Statistics Port',20,\&textinput,55553,$GUIHostPort,'ConfigChangeStatPort',
  'The port on which ASSP will listen for http or telnet connections to the statistics interface. You may also supply an IP address to limit connections to a specific interface. Only one value is supported!<br />
   The stats are available using a browser or telnet (or telnet similar socket). Using telnet, press ENTER two times to get the healthy state (\' $webStatHealthyResp [CRLF]\' or \' $webStatNotHealthyResp [CRLF]\' in a single line), this is the recommended methods to get the \'UP\'-state of assp from nagios or any other external script.<br />
   Type \'stat[ENTER][ENTER]\' to get the STATS in raw text where each line is terminated with \'[CR]LF\' (CR is send in any case, if the request contains CR).<br />
   The HTML/browser output are LF terminated STAT lines.<br />
   If you have configured " exportExtremeBlack ", your firewall (for example pfsense/pfBlockerNG or snort) may download the extreme black IP list using this interface - append "/extremeblack" to the URL.<br />
   The download URL, used by your firewall, should look like: http://assp.domain.local:55553/extremeblack<br />
   To define a SSL listener, write \'SSL:\' in front of the host:port - e.g. SSL:host:port.<br />
   <p><small><i>Examples:</i> 55553, 192.168.0.5:12345|SSL:192.168.0.6:12345</small></p>',undef,undef,'msg007670','msg007671'],
['enableWebStatSSL','Use https instead of http',0,\&checkbox,'','(.*)','ConfigChangeEnableStatSSL',
 'The web stat interface will be only accessible using https.<br />
  This requires an installed <a href="http://metacpan.org/search?q=IO::Socket::SSL" rel="external">IO::Socket::SSL</a> module in PERL.<br />
  A server-certificate-file "certs/server-cert.pem" and a server-key-file "certs/server-key.pem" must exits and must be valid! More configuration options are statSSLRequireClientCert, SSLSTATCertVerifyCB and SSLSTATConfigure .',undef,undef,'msg007680','msg007681'],
['allowStatConnectionsFrom','Only Allow Raw Statistics Connections From*',80,\&textinput,'127.0.0.1','(\S*)','ConfigMakeIPRe',
  'An optional list of IP addresses from which you will accept raw statistical connections. Blank means accept connections from any IP address. <p><small><i>Examples:</i></small></p>
 127.0.0.1|172.16.',undef,undef,'msg007690','msg007691'],
['EnableHTTPCompression','Enable HTTP Compression in GUI',0,\&checkbox,1,'(.*)',undef,
  'Enable HTTP Compression for faster web administration interface loading. The perl module <a href="http://metacpan.org/search?q=Compress::Zlib" rel="external">Compress::Zlib</a> is required to use this feature.',undef,undef,'msg007700','msg007701'],
['httpLocalIPAddress','HTTP - Destination to Local IP-address Mapping*',40,\&textinput,'','^(\s*file\s*:\s*.+|)$','configChangeLocalIPMap',
  'You need to use the "file: ..." option for this parameter!<br />
  On windows systems at least Vista/2008 is required!<br />
  On multihomed systems with multiple default gateways, it could be required to define the local IP address (source) used for outgoing HTTP connections.<br />
  This parameter allows to define local IP addresses used for specific targets (IP\'s or hosts) - based on the local address, the system will use the right gateway/interface.<br />
  Define one entry per line, comments (#) are allowed. The syntax for an entry is \'target=>local-IP\'.<br />
  target could be any of: IP(4/6) network, IP(4/6) address, hostname, domain-name with wildcard (*).<br /><br />
  for example:<br />
  22.* => 192.168.1.1            # IP4 Network<br />
  2222:333:* => FE81::1          # IP6 Network<br />
  22.23.24.25 => 10.1.1.1        # host IP4<br />
  1:2:3:4:5:6:7:8 => FE94::5     # host IP6<br />
  *.domain.com => 10.1.1.1       # domain<br />
  host.domain.com => 192.168.1.1 # host<br />
  * => 172.16.1.1                # default - if not defined, the system default is used<br /><br />
  NOTICE: assp will NOT check, that the local IP address is available and bound to a local interface! It will also NOT check the system routing table! YOU SHOULD KNOW WHAT YOU DO!',undef,undef,'msg010440','msg010441'],
['EnableFloatingMenu','Enable Floating Menu Panel in GUI',0,\&checkbox,'','(.*)',undef,
  'Allow the left menu panel on the web administration interface to float.',undef,undef,'msg007710','msg007711'],
['hideAlphaIndex','Hide the Alpha Index Menu Panel in GUI',0,\&checkbox,'','(.*)',undef,
  'Removes the index panel on the left side in the GUI, but the index is accessible by clicking on the "SEARCH icon" <a href="javascript:void(0);" onmouseover="showhint(\'Search in the Configuration Parameter Index\', this, event, \'500px\', \'1\');return false;" onmousedown="slide();return false;"><img class="helpIcon" src="get?file=images/index.jpg"></a> in the left-hand top menu.',undef,undef,'msg007720','msg007721'],
['IndexSlideSpeed','Sliding Speed of the Alpha Index Menu Panel in GUI','450:no slide|50:fast|10:normal|5:slow',\&listbox,10,'(.*)',undef,
  'Adjust the sliding speed of the Alpha Index Menu Panel in GUI to your needs.',undef,undef,'msg007730','msg007731'],
['RememberGUIPos','Remember the last GUI position',0,\&checkbox,1,'(.*)',undef,
  'If selected, the GUI will remember the last topic of the main menu, that had the focus, was changed, that were jumped to or that were clicked on.',undef,undef,'msg009340','msg009341'],
['EnableInternalNamesInDesc','Show Internal Names in the GUI',0,\&checkbox,1,'(.*)',undef,
  'Show the internal names in the web interface. The internal names are used in the configuration file (assp.cfg), in the application code, and in the menu bar on the left side of the GUI.',undef,undef,'msg007740','msg007741'],
['MaillogTailJump','Jump to the End of the Maillog',0,\&checkbox,'','(.*)',undef,
  'Causes the browser window to jump to the bottom of the maillog instead of sitting at the top of the display.',undef,undef,'msg007750','msg007751'],
['MaillogTailBytes','Maillog Tail Bytes',10,\&textinput,10000,'(\d+)',undef,
  'The number of bytes that will be shown when the end of the maillog is viewed. The default value is 10000.',undef,undef,'msg007760','msg007761'],
['CleanCacheEvery','Cache Cleaning Interval <sup>s</sup>',40,\&textinput,'6',$ScheduleGUIRe,'configChangeSched',
  'This period (in hours) determines how frequently ASSP does cache-housekeeping.',undef,undef,'msg007780','msg007781'],
['SaveStatsEvery','Statistics Save Interval <sup>s</sup>',40,\&textinput,'30',$ScheduleGUIRe,'configChangeSched',
  'This period (in minutes) determines how frequently ASSP statistics are written to a local file.',undef,undef,'msg007790','msg007791'],
['totalizeSpamStats','Upload Consolidated Spam Statistics',0,\&checkbox,1,'(.*)',undef,
 'ASSP will upload its statistics to be consolidated with the <a href="https://assp.sourceforge.net/cgi-bin/assp_stats" rel="external">global ASSP totals</a>. This is a great marketing tool for the ASSP project &mdash; please do not disable it unless you have a good reason to do so. No private information is being disclosed by this upload.',undef,undef,'msg007800','msg007801'],
['enableGraphStats','Enable Graphical Statistics Collection',0,\&checkbox,0,'(.*)',undef,
 'ASSP will collect statistical data in files located in the \'/logs\' folder (scoreGraphStats-YYYY-MM.txt , statGraphStats-YYYY-MM.txt). If data are collected and the module lib/ASSP_SVG.pm is installed and the files images/stat.gplot, images/svg_style.css, images/svg_defs.svg and images/svg.js are installed and your browser supports SVG, assp will show graphical statistic data, if you click on a line in the \'Info and Stats\' view.<br />
 If baysConf is configured, assp will also collect statistical data about the Bayesian and HMM confidence distribution - the file names are confidenceGraphStats-YYYY-MM.txt.<br />
 It is recommended to set \'SaveStatsEvery\' to a value of 5 or 10 minutes, if this option is enabled!<br />
 ASSP will delete \'*GraphStats...txt\'-files if they are over one year old. If you don\'t need some of that files any longer, remove them manually!',undef,undef,'msg010000','msg010001'],
['ReloadOptionFiles','Reload Option Files Interval <sup>s</sup>',40,\&textinput,'300',$ScheduleGUIRe,'configChangeSched',
  'If set not to zero, ASSP reloads configuration option files (file:.....) every this many seconds if they have changed. It is not recommended (and could make ASSP unavailable) to use rsync or any external tool to snychronize caches and list permanently. If you need to snychronize data between ASSP installations, you better use a database of your choice!',undef,undef,'msg007810','msg007811'],
['VirusTotalAPIKey','The Private API-Key for VirusTotal',80,\&textinput,'','(.*)',undef,
 'To query www.VirusTotal.com for URIs and/or viruses (ASSP_AFC.pm), a valid API-Key is required. An API-Key is provided by VirusTotal for free, after your registration at www.virustotal.com.<br />
 Such a free API-Key is limited to four queries at VirusTotal per minute. API-Keys for a higher query volume are also provided by VirusTotal.<br />
 Systems that are part of the ASSP-Global-PenalyBox network can leave this value empty. They are getting an API-Key with a much higher query volume per day and minute (~4000 calls per day, no limit per minute) from the GPB-Server automatically, without any additionally costs. This API-Key is not shown here!<br />
 You need to enable ( useASSP_VirusTotal_API ) the assp module lib/ASSP_VirusTotal_API.pm and to install the perl module <a href="http://metacpan.org/search?q=JSON" rel="external">JSON</a>.',undef,undef,'msg010770','msg010771'],
['OrderedTieHashTableSize','Ordered-Tie Hash Table Size',10,\&textinput,10000,'(\d+)',undef,
 'The number of cached entries allowed in the hash tables used by ASSP. This belongs to griplist, if useDB4griplist is not set and to temporary lists used by the rebuild spamdb process, if useDB4Rebuild is set and BerkeleyDB is not available. Larger numbers require more RAM but result in fewer disk hits. The default value is 10000. Adjust down to use less RAM. Adjust up to speedup.',undef,undef,'msg007820','msg007821'],
['TCPBufferSize','TCP and SSL Read/Write Buffer Size',80,\&textinput,'','(^(?:\s*(?:tcprcv|tcpsnd|sslrcv|sslsnd)\s*=\s*(?:819[2-9]|8[2-9]\d\d|9\d\d\d|[1-9]\d{4,7}|0)\s*)(?:\s*,\s*(?:tcprcv|tcpsnd|sslrcv|sslsnd)\s*=\s*(?:819[2-9]|8[2-9]\d\d|9\d\d\d|[1-9]\d{4,7}|0)\s*){0,3}$|)','ConfigChangeTCPBuf',
  'Define the buffer size in byte used for TCP- and SSL socket read and write operations - defaults to empty.<br />
  Any or all of the following four values can be defined:<br /><br />
  tcprcv - TCP receive buffer size (currently: $maxTCPRCVbuf)<br />
  tcpsnd - TCP send buffer size (currently: $maxTCPSNDbuf)<br />
  sslrcv - SSL receive buffer size (currently: $maxTCPRCVbufSSL)<br />
  sslsnd - SSL send buffer size (currently: $maxTCPSNDbufSSL)<br /><br />
  SSL-Write-Boost (currently: $SSL_write_boost)<br /><br />
  Multiple value definition have to be separated by comma or pipe, like: tcprcv = 65536, tcpsnd = 65536, ...<br />
  Possible size values are 8192 (8KB) to 99999999 (~95MB), special value for sslrcv and sslsnd is zero.<br />
  Do NOT write dots into the number values - like tcprcv = 1.048.576 , those values are not accepted!<br />
  If a value is not specified for tcprcv, the TCP receive buffer size reported by the system is used - but at least 8192 byte.<br />
  If a value is not specified for tcpsnd, the value is set to 99999999.<br />
  If a value is not specified for sslrcv or sslsnd, a value of 16384 byte is used, which is the maximum size of a single SSL frame of the SSL layer.<br />
  If a value of zero is specified for sslrcv or sslsnd, the according TCP socket buffer size is used.<br />
  If the configured or calculated value for sslsnd is larger than 16384, the buffer for sslsnd is set to the (SSL)-maximum of 16384 byte and SSL-Write-Boost will be enabled.<br />
  If SSL-Write-Boost is enabled assp sends for a maximum of $SSL_write_boost_max_time milliseconds in each SSL/TLS-connection as much data as possible in a single thread loop.<br />
  Under normal conditions any setting here is not required - or better, is at least safe for all operating systems.<br />
  But, if you notice a too low transmission speed (eg. for large mails) of plan TCP-sockets or SSL-sockets, it may help to set (increase) the according buffer values.<br />
  like: tcprcv = 1048576, tcpsnd = 10485760, sslrcv = 0, sslsnd = 0<br /><br />
  To monitor your settings, set SessionLog to diagnostic and watch the maillog.<br />
  Notice: setting any receive buffers too high may cause the operating system to fall back to very low values (eg. 8KB), which will slow down the transmission speed dramatically.<br />
  On most systems the TCP send buffers size can safely be set to the maximum supported value of 99999999 (tcprcv default).
  ',undef,undef,'msg006200','msg006201'],
['neverQueueSize','Never internaly Queue Mails larger than this Size',10,\&textinput,20971520,'(\d{7,})',undef,
 'Default is 20971520 (20MB) - lowest possible value is 1000000. Any mail that is announced to be or grows larger than this size in byte, will not be queued for actions and checks that requires the complete mail to be internaly queued.<br />
 skipped actions are: DKIM signature generation and charset conversions<br />
 skipped checks are: all Plugins in level 2 (complete mail) and the full mail DKIM check<br />
 Please also check npSize and npSizeOut .',undef,undef,'msg007830','msg007831'],
['useDB4IntCache','Use BerkeleyDB for Internal Caches',0,\&checkbox,'','(.*)','configChangeDB',
  'ASSP uses some internal caches that could grow to a large number of entries. Switch this to ON, apply and restart assp, if you want ASSP to use less memory and be a little slower. If Changed to ON, ASSP will import the current internals into the databases at the next restart. The perl module <a href="http://metacpan.org/search?q=BerkeleyDB" rel="external">BerkeleyDB</a> version 0.34 or higher and BerkeleyDB version 4.5 or higher is required to use this feature.',undef,undef,'msg007840','msg007841'],
['ALARMtimeout','Module Call Timeout',5,\&textinput,10,'(\d+)',undef,'Global Timeout for SPF checks. The default is 10 seconds.
  <hr /><hr /><font color=red>Thread Control - be careful changing the following green options!</font><hr />',undef,undef,'msg007850','msg007851'],
['NumComWorkers','Number of SMTP-Threads',2,\&textinput,5,'^([1-9][0-9]|[2-9])$','configChangeNumThreads','Number of SMTP-Threads to be used! Typical and default is 5. 10 should be enough for 200.000 connections a day. 15 should be the absolute maximum. Values above 7 will mostly not increase performance. Configurable values are between 2 and 29. Restart ASSP if you changed this and you are using any database connection! A restart of assp is required if tis value was increased.','Basic',undef,'msg007860','msg007861'],
['ReservedOutboundWorkers','Reserved Number of Outbound-SMTP-Threads on relayPort',2,\&textinput,0,'(\d\d?)',undef,'Number of SMTP-Threads to be reserved for relayed (outbound) connections on relayPort ! This number of Threads will be exclusive reserved for connections on relayPort . For example: NumComWorkers=7 and ReservedOutboundWorkers=2 - mails on listenPort , listenPort2 and listenPortSSL are using worker 1-5 and mails on relayPort using worker 7-1 ! If you are not using the relayPort, do not reserve any workers.','Basic',undef,'msg007870','msg007871'],
['autoRestartDiedThreads','automatically restart died threads',0,\&checkbox,'1','(.*)',undef,
  'If defined, a (for any reason) died thread will be automatically restarted!','Basic',undef,'msg007920','msg007921'],
['MaxFinConWaitTime','Maximum time to wait for SMTP-Workers to finish connections',5,\&textinput,45,'^([1-5][0-9][0-9]|[1-9][0-9])$',undef,'The maximum time in seconds to wait for SMTP-Workers to finish connections, in case of a shutdown or restart of ASSP. Default is 45. Configurable values are 10 to 599.','Basic',undef,'msg007930','msg007931'],
['MonitorMainThread','Monitor the MainThread',0,\&checkbox,'1','(.*)',undef,
  'If defined, the MainThread will be monitored for healthy by the MaintThread (Worker 10000)!','Basic',undef,'msg007940','msg007941'],
['EnableHighPerformance','Enable Higher Performance','0:off|3000:slightly|1000:medium|500:high|100:very high',\&listbox,'0','(.*)',undef,
  'If set, the SMTP-Worker-Threads will get new pending connections faster - using less wait states. The speed to interrupt the workers by the MainThread is increased. Using this feature will increase the CPU usage of the system! An too high setting, may lead into stuck workers, or in worth case, into a much lower perfomance.<br />
  <span class="negative">If there is any doubt about this setting, leave this feature off!</span>','Basic',undef,'msg009700','msg009701'],
['ThreadCycleTime','thread cycle time',5,\&textinput,3000,'^([1-9]\d{3})$',undef,'Time in microseconds (for SMTP workers and MainThread) to give each other thread to run in high CPU-workload conditions. Default value is 3000, typical and valid values are between 1000 and 9999. A higher value will reduces CPU usage but cause ASSP to run more slowly!','Basic',undef,'msg007950','msg007951'],
['MaintThreadCycleTime','MaintenanceThread cycle time',5,\&textinput,3000,'^([1-9]\d{1,3})$',undef,'Time in microseconds (for MaintThread) to give each other thread to run in high CPU-workload conditions. Default value is 3000, typical and valid values are between 10 and 9999. A higher value will reduce CPU usage but cause ASSP to run more slowly!','Basic',undef,'msg007960','msg007961'],
['RebuildThreadCycleTime','RebuildSpamDBThread cycle time',5,\&textinput,30,'(\d+)',undef,'Time in microseconds (for RebuildSpamDBThread) to give each other thread to run in high CPU-workload conditions. Default value is 30, typical values are between 10 and 1000. You can set this to 0, if your OS honors system-yield-calls (0 is not recommended on Windows OS) and your system is fast enough! A higher value will reduce CPU usage but cause ASSP to run more slowly!','Basic',undef,'msg007970','msg007971'],
['ThreadStackSize','Stack Size use by every Thread',5,\&textinput,0,'(\d+)',undef,'The stack size in MB that is used by every thread. Default is 0, which means to use the default system stack size. 16 MB is the default system stack size on windows platforms. This system value may differ on different platforms. To get the default stack size on linux use the shell command "ulimit -a". Try to increase this value, if you get "out of memory" errors while running assp. Changing this value requires an assp restart to take effect.','Basic',undef,'msg009030','msg009031'],
['IOEngine','Use This IO Engine','0:IO::Poll|1:IO::Select',\&listbox,$dftIOEngine,'(.*)',undef,
  'Depending on your operating system and your Perl version, it could be necessary to use the non default restricted IOEngine \'IO::Select\'. Try this \'IO::Select\', if you see unexpected early closed connections or a large amount of SMTP timouts in the log. For Strawberry-Perl on Windows it recommended to use \'IO::Select\'. You have to restart ASSP, if you have changed this value!<br />
  On most OS or Perl distributions the IO::Select is restricted to a maximum of 1024 concurrent active file descriptors (disk files and [TCP,UDP,unix] sockets) within a single "fd-set" object. This depends on the setting of the C-compiler option "FD_SETSIZE" while your perl was compiled.<br />
  If this C-compiler option was set too low at the Perl compile time - you will see errors like:<br />
  "can not open file .. too many opened files"<br />
  or<br />
  "can not create socket to .. too many opened files"<br />
  If this happens, you will need to recompile your perl with a higher value, set for "FD_SETSIZE".<br />
  NOTICE that some OS are not supporting the setting of "FD_SETSIZE" because of a hard coded value for "__FD_SETSIZE" - for example linux. On most Unix and all Windows OS it is supported.<br /><br />
  NOTICE that a too low setting of \'ulimit -n\' may cause the same errors on all nix OS.','Basic',undef,'msg007980','msg007981'],
['MinPollTime','Minimum Poll/Select Wait Time',5,\&textinput,2,'(\d+)',undef,'The time in milliseconds that ASSP will at least wait for IO::Poll/IO::Select events! A higher value will reduce CPU usage but cause ASSP to run more slowly! Default is 2.','Basic',undef,'msg007990','msg007991'],
['WorkerCPUPriority','CPU priority for SMTP-Threads',5,\&textinput,0,'(0|1|2)','configChangeWorkerPriority','Set the priority for the Workers in relation to all other processes/threads on the system. Than higher the value - than lower the priority. Default is 0 (system default is 0). Possible values are 0,1 and 2. This requires installed <a href="http://metacpan.org/search?q=Thread::State" rel="external">Thread::State</a> module. It is recommended to run the Workers on lower priority, if ASSP has to process most of the time a large number of mails at one moment ( number of mails &gt; NumComWorkers ).','Basic',undef,'msg008000','msg008001'],
['asspCpuAffinity','Cpu Affinity for assp',20,\&textinput,'-1','(\-1|\d+(?:[, ]+\d+)*)','configChangeCpuAffinity','Set the Cpu Affinity for all threads . Default is -1 (for use all CPU\'s). Possible values are comma or space separated CPU numbers starting with zero (0) or -1 for all CPU\'s. This requires installed <a href="http://metacpan.org/search?q=Sys::CpuAffinity" rel="external">Sys::CpuAffinity</a> module. This feature will possibly not work on MacOS and OpenBSD and on any OS, if the system contains more than 32 CPU\'s.','Basic',undef,'msg009880','msg009881'],
['PreAllocMem','pre allocate memory for every mail',5,\&textinput,100000,'(\d+)',undef,'ASSP pre-allocates this number of bytes in mainstorage two times (in/out) for every mail to avoid memoryfracmentation (particularly in ASSP long run conditions). The memory will be allocated, if the DATA command is received from the server. Default is 100000 - this is enough for most of the mails. If ASSP receives the SIZE command from the server, the pre-allocation-memory will be calculated on that value. Question: Is it better to increase this value? Answer: Yes, it is - but be careful, this may cause ASSP running in out of memory errors!','Basic',undef,'msg008010','msg008011'],
['FreeupMemoryGarbage','Freeup Memory Garbage',0,\&checkbox,'1','(.*)',undef,
  'If defined, all Threads will try to recover memory every five minutes!','Basic',undef,'msg008020','msg008021'],
['ConnectionTransferTimeOut','Connection Transfer Timeout',5,\&textinput,30,'(\d+)',undef,'Global Timeout for MainThread to transfer a connection to any Worker. If no Worker is able to take the new SMTP-connection (for any reason), the new connection will be dropped! The default is 30 seconds.','Basic',undef,'msg008030','msg008031'],
['ShowPerformanceData','Show Performance DATA in SMTP Connection screen',0,\&checkbox,'1','(.*)',undef,
  'If defined, performance data will be shown in top of the SMTP connection screen!
  <hr /><hr /><font color=red>end of Thread Control</font><hr />',undef,undef,'msg008040','msg008041'],
['UseLocalTime','Use Local Time',0,\&checkbox,1,'(.*)',undef,
  'Use local time and timezone offset rather than UTC time in the mail headers.<br /><hr />
  <div class="cfgnotes">Notes On Server Setup</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/myserver.txt\',3);" />',undef,undef,'msg008050','msg008051'],

[0,0,0,'heading','Rebuild Hidden Markov Model and Bayesian Database'],
['RebuildSchedule','Schedule Cron time for RebuildSpamdb <sup>s</sup>',50,\&textinput,'noschedule','^((?:'.$ScheduleRe.'(?:\|'.$ScheduleRe.')*)|noschedule)$','configChangeRSRBSched','If <b>not</b> set to "noschedule" (noschedule is default) , ASSP uses scheduled times to run the RebuildSpamdb! The syntax is the same like in <a href="http://en.wikipedia.org/wiki/Cron" rel="external">"Vixie" cron</a>! To disable the Scheduler write "noschedule"!<b> Never write quotes into this field!</b><br />
It is possible to define more than one scheduled time per day to keep the Bayesian and HMM databes up to date, but this is not required - use \'newReportedInterval\' instead.<br />
If a file '.$base.'/rebuilddebug.txt exists, the rebuild task will write the debug output to this file.<br />
<br />
<b>Time and Date specification</b><br />
<br />
Entry is the specification of the scheduled time in crontab format,
which contains five mandatory time and date fields.
Entry can be either a plain string, which contains
a whitespace separated time and date specification.<br />
<br />
The time and date fields are (taken mostly from "Vixie" cron):<br />
<br />
<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH="50%" >
<tr><td><b>field</b></td><td><b>values</b></td></tr>
<tr><td>minute</td><td>0-59</td></tr>
<tr><td>hour</td><td>0-23</td></tr>
<tr><td>day of month</td><td>1-31</td></tr>
<tr><td>month</td><td>1-12 (or as names)</td></tr>
<tr><td>day of week</td><td>0-7 (0 or 7 is Sunday, or as names )</td></tr>
<tr><td>seconds</td><td>0-59 (optional) <b>not supported inside ASSP !!!</b></td></tr>
</table>
<br />
 A field may be an asterisk (*), which always stands for
 "first-last".<br />
<br />
 Ranges of numbers are  allowed.  Ranges are two numbers
 separated  with  a  hyphen.   The  specified  range  is
 inclusive.   For example, 8-11  for an  "hours" entry
 specifies execution at hours 8, 9, 10 and 11.<br />
<br />
 Lists  are allowed.   A list  is a  set of  numbers (or
 ranges)  separated by  commas.   Examples: "1,2,5,9",
 "0-4,8-12".<br />
<br />
 Step  values can  be used  in conjunction  with ranges.
 Following a range with "/number" specifies skips of
 the  numbers value  through the  range.   For example,
 "0-23/2" can  be used in  the hours field  to specify
 command execution every  other hour (the alternative in
 the V7 standard is "0,2,4,6,8,10,12,14,16,18,20,22").
 Steps are  also permitted after an asterisk,  so if you
 want to say "every two hours", just use "*/2".<br />
<br />
 Names can also  be used for the "month"  and "day of
 week"  fields.  Use  the  first three  letters of  the
 particular day or month (case doesn\'t matter).<br />
<br />
 Note:<br />
       The day of a command\'s execution can be specified
       by two fields  -- day of month, and  day of week.
       If both fields are restricted (ie, aren\'t *), the
       command will be run when either field matches the
       current  time.  For  example, "30  4 1,15  * 5"
       would cause a command to be run at 4:30 am on the
       1st and 15th of each month, plus every Friday<br />
<br />
Examples:<br />
<br />
<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH="80%" >
<tr><td>8 0 * * *</td><td>==></td><td>8 minutes after midnight, every day</td></tr>
<tr><td>5 11 * * Sat,Sun</td><td>==></td><td>at 11:05 on each Saturday and Sunday</td></tr>
<tr><td>0-59/5 * * * *</td><td>==></td><td>every five minutes</td></tr>
<tr><td>42 12 3 Feb Sat</td><td>==></td><td>at 12:42 on 3rd of February and on each Saturday in February</td></tr>
<tr><td>32 11 * * * 0-30/2</td><td>==></td><td>11:32:00, 11:32:02, ... 11:32:30 every day</td></tr>
</table>
<br />
In addition, ranges or lists of names are allowed.<br />
If you want to define multiple entries separate them by "|"',undef,undef,'msg008070','msg008071'],
['useDB4Rebuild','Use BerkeleyDB or DB_File for the RebuildSpamDB Internal Caches',0,\&checkbox,'1','(.*)','configChangeDB',
 'The RebuildSpamDB thread creates some internal temporary caches, which can grow to a very large number of entries. Switch this on (default), if you want this thread to use less memory at the cost of speed.<br />
 Adjust RebuildThreadCycleTime to a lower value (between 0 and 30) to speed up the RebuildSpamDB thread.<br />
 The perl module <a href="http://metacpan.org/search?q=BerkeleyDB" rel="external">BerkeleyDB</a> version 0.34 or higher and BerkeleyDB version 4.5 or higher is required to use this feature. DB_File (Berkeley V1) will be used if BerkeleyDB is not available - this is highly not recommended! If both BerkeleyDB and DB_File are not available, the rebuild thread will hold all temporary data in RAM - the same way, this option were set to "OFF".',undef,undef,'msg008080','msg008081'],
['RebuildUsesFileModel','Build a Model from all processed emails for faster processing',0,\&checkbox,'1','(.*)',undef,
 'The rebuild task builds a content model (in memory or BerkelyDB only) of all processed files, and uses this model at the next rebuild for faster processing.<br />
 The time to process the mail-files is reduced down to a tenth (if BerkeleyDB is not used ( useDB4Rebuild OFF )), but requires a large amount of additional memory - eg. &tild;2GB per 50.000 corpus files.<br />
 The time to process the mail-files is reduced to a half, if BerkeleyDB is used ( useDB4Rebuild ON ).
 The default setting is ON<br />
 The first rebuild after setting this to ON will run at a normal speed - all the next rebuild tasks will run faster.',undef,undef,'msg010780','msg010781'],
['ReplaceOldSpamdb','Replace the old Records in Spamdb and Spamdb.helo',0,\&checkbox,'1','(.*)',undef,
  'If selected (default), the new created records for Spamdb and Spamdb.helo will replace the old (belongs not to HMM, which is replaced every time). If not seleted, the new records will be added to Spamdb and Spamdb.helo .',undef,undef,'msg008090','msg008091'],
['doMove2Num','Do move2num Before Rebuild',0,\&checkbox,'','(.*)',undef,'Renames files to numbers before the rebuild is started. If this is done, some other features like \'MailLogTail\' and \'Block-Report\' will be unable to find the files! Setting this option to "ON" is not recommended!',undef,undef,'msg008100','msg008101'],
['newReportedInterval','Interval for processing new Reported Mails',30,\&textinput,'10 5','(\d+\s+\d+)',undef,
 'File count and interval definition (count minutes) for processing new reported mails (correctedspam , correctednotspam) - process if at least \'first value\' mails are reported but every \'second value\' minutes. defaults to \'10 5\'<br />
 Set the first value to zero to disable this feature.<br />
 If enabled, new reported mails or files moved into the corpus by GUI are used, to immediately update the Spamdb and HMMdb with the new information.<br />
 This will keep the databases continuously uptodate and the RebuildSchedule interval could be increased, if there are enough files in the corpus and your corpus norm is fine.<br />
 If you need to copy/move several files from outside assp into the corpus and you want assp to process them immediately, copy/move the files into the subfolder "error/.../newManuallyAdded".',undef,undef,'msg009870','msg009871'],
['MaxKeepDeleted','Max Days of Keep Deleted',5,\&textinput,0,'(\d+)',undef,
  'The maximum number in days deleted files in the bayesian collection folders ( spamlog , notspamlog ) will be kept. This is necessary when EmailBlockReport is used to handle the file and the file is meanwhile deleted. The list of files that are marked for deletion is stored in trashlist.db .',undef,undef,'msg008650','msg008651'],
['autoCorrectCorpus','Automatic Corpus Correction',60,\&textinput,'0.6-1.4-4000-14','(\d\.\d\d?-\d\.\d\d?-(?:[4-9]\d{3}|\d{5,})-\d+|)',undef,'(Syntax: a.a[a]-b.b[b]-cccc-dd or empty - default is "0.6-1.4-4000-14") If the corpus norm (the weight between spamwords/hamwords) is less than "a" (0.6 - too much ham) or greater than "b" (1.4 - too much spam), assp will delete the excess (oldest) files from the corresponding folder ( spamlog , notspamlog ). ASSP will keep a minimum of "c" (4000) files in the folder and will never delete files that are younger than "d" (14) days. This cleanup will run at the end of the rebuildspamdb task. So the corrected file corpus will take effect at the next rebuildspamdb!<br />
  If this value is defined, assp will use the middle value of "a" and "b" ((a+b)/2) as target corpusnorm and will try to reach this value, using (as many as possible) but only such a count of files in the folders spamlog and notspamlog as required!',undef,undef,'msg008980','msg008981'],
['RebuildFileTimeLimit','File Processing time Limit',30,\&textinput,'1 5','(\d+(?:\.\d+)?(?:(?:\s+|,)\d+(?:\.\d+)?)?)',undef,'(Syntax: a[.aa] b[.bb] - default is "1 5")<br />
   Define one, or two space or comma separated values.<br />
   If the first value is not zero and the processing time of a single corpus file exceeds the first value in seconds, this will be shown in the rebuild log.<br />
   If the second value is not zero and the processing time of a single corpus file exceeds the second value in seconds, the file will be moved to the folder "$base/rebuild_error" to prevent future runtime penalties.',undef,undef,'msg009620','msg009621'],
['RebuildNotify','Notification Email To',80,\&textinput,'','(.*)',undef,
  'Email address(es) to which you want ASSP to send a notification email after the rebuild task is finished. The file rebuildrun.txt is included in this notification. Separate multiple entries by "|".',undef,undef,'msg008110','msg008111'],
['RebuildTestMode','Run the Rebuild in Test Mode',0,\&checkbox,'','(.*)',undef,'If selected, all rebuildspamdb tasks will not populate the spamdb and hmmdb - and no data will be sent to the griplist-Server.',undef,undef,'msg009720','msg009721'],
['forceRebuildDowngrade','Keep rebuildspamdb.pm compatible to assp.pl',0,\&checkbox,'1','(.*)',undef,'Keep rebuildspamdb.pm compatible to assp.pl in case of an assp.pl version downgrade.',undef,undef,'msg009840','msg009841'],
['RunRebuildNow','Run RebuildSpamdb now',0,\&checkbox,'','(.*)','ConfigChangeRunTaskNow',
  'If selected, RebuildSpamdb will be started immediately.<br />' .
  "<input type=button value=\"Apply Changes and Run Rebuild SpamDB Now (if checked)\" onclick=\"document.forms['ASSPconfig'].theButtonX.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />&nbsp;<input type=button value=\"Refresh Browser\" onclick=\"document.forms['ASSPconfig'].theButtonRefresh.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />" .
  '<hr /><div class="cfgnotes">Disclaimers, as well as private and corporate signatures may become a real problem, because they are always added to outgoing mails, but also to local mails and reports. They can be found in most of the answers to your mails. And for example, they may be added by spammers to there spam mails - trying to fake good mails. Nobody can say, how the occurrence of such a disclaimer will affect the HMM and Bayesian results. It may possible, that these results differs from day to day, or block good mails, or let spam pass.
  The only way to prevent such results, is to remove the disclaimers, before the rebuildspamdb task builds the spamdb and HMMdb.<br />
  To tell assp, which are your disclaimers, open the file files/disclaimer.txt using the "disclaimer definition" button below and put the disclaimers into this file, the same way they are shown in your mail client. If you want to define multiple disclaimers, separate them by a line with a single dot. Lines in this file starting with an "#" are considered a comment, empty lines are ignored. ASSP will build a regular expression to identify and remove the disclaimers.<br /><br />
  <b>example:<br /><br />
  # a comment<br />
  your first disclaimers first line here<br />
  your first disclaimers second line here<br />
  .<br />
  # also a comment<br />
  your second disclaimers first line here<br />
  your second disclaimers second line here</b><br /><br />
  <input type="button" value="disclaimer definition" onclick="javascript:popFileEditor(\'files/disclaimer.txt\',1);" /><br />
  This file will only be read at the rebuild task start. The resulting regular expression is written to "files/optRE/disclaimer.txt" <input type="button" value="show disclaimer regex" onclick="javascript:popFileEditor(\'files/optRE/disclaimer.txt\',5);" /></div>
  <hr /><div class="cfgnotes">Last Result Of Rebuildspamdb</div><input type="button" value="Last Run Rebuildspamdb" onclick="javascript:popFileEditor(\'rebuildrun.txt\',5);" />
  <hr /><div class="cfgnotes">Rebuildspamdb-debug-output - create the file \'rebuilddebug.txt\' to enable the debug mode - delete the file to stop the debug mode for the rebuildspamdb task</div><input type="button" value="Rebuildspamdb-debug-output" onclick="javascript:popFileEditor(\'rebuilddebug.txt\',3);" />
  <hr /><div class="cfgnotes">normfile - shows current:<br />
  Corpus-Norm , Corrected-SpamFiles , Corrected-NotSpamFiles , Spamlog-Files , NotSpamlog-Files , SpamWords/File , Hamwords/File , Spamwords , Hamwords</div><input type="button" value="normfile" onclick="javascript:popFileEditor(\'normfile\',3);" />
  <hr /><div class="cfgnotes">Notes On RebuildSpamdb</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/rebuildspamdb.txt\',3);" />',undef,undef,'msg008120','msg008121'],

[0,0,0,'heading','CharacterSet Conversions and TNEF Processing'],
['inChrSetConv','inbound charset conversion table*',80,\&textinput,'','(\S*)','configChangeCV',
  'If defined, characterset conversion for inbound mails will be done. For example: if your email server does not understand UTF-8, ASSP will convert the mail parts to the characterset of your choice. The rules specified here are used to convert text parts of inbound mails from one to another characterset.<p><small><i>Example:</i>UTF-8=>ISO-8859-1|ISO-8859-15=>ISO-8859-1</small></p>
 This requires an installed <a href="http://metacpan.org/search?q=Email::MIME" rel="external">Email::MIME</a> module in PERL.<br />
 This conversions are done for all (inbound,CC,report ..) mails except relayed mails. The converted mail will be not available on disk except DEBUG.',undef,undef,'msg008130','msg008131'],
['outChrSetConv','outbound charset conversion table*',80,\&textinput,'','(\S*)','configChangeCV',
  'If defined, characterset conversion for outbound mails will be done. For example: if your email server is unable to send mails in UTF-8, ASSP will convert the mail parts to UTF-8. The rules specified here are used to convert text parts of outbound mails from one to another characterset.<p><small><i>Example:</i>ISO-8859-1=>UTF-8|ISO-8859-2=>UTF-8|windows-1250=>UTF-8</small></p>
 This requires an installed <a href="http://metacpan.org/search?q=Email::MIME" rel="external">Email::MIME</a> module in PERL.<br />
 This conversions are done only for relayed mails!',undef,undef,'msg008140','msg008141'],
['doInFixTNEF','convert inbound MS-TNEF attachments to MIME',0,\&checkbox,'','(.*)',undef,
  'convert inbound MS-TNEF attachments like winmail.dat to MIME parts/attachments. If a TNEF-file is attached by other than Exchange (like application/octet-stream) no conversion will be done. <br />
 In addition to <a href="http://metacpan.org/search?q=Email::MIME" rel="external">Email::MIME</a> this requires both installed <a href="http://metacpan.org/search?q=Convert::TNEF" rel="external">Convert::TNEF</a> and <a href="http://metacpan.org/search?q=MIME::Types" rel="external">MIME::Types</a> module in PERL.',undef,undef,'msg008150','msg008151'],
['keepInTNEF','keep the MS-TNEF part in inbound mail',0,\&checkbox,'1','(.*)',undef,
  'keep inbound MS-TNEF attachments like winmail.dat in MIME parts. If unchecked and the conversion is successful, the original attachment will be removed from mail!',undef,undef,'msg008160','msg008161'],
['doOutFixTNEF','convert outbound MS-TNEF attachments to MIME',0,\&checkbox,'','(.*)',undef,
  'convert outbound MS-TNEF attachments like winmail.dat to MIME parts/attachments. If a TNEF-file is attached by other than Exchange (like application/octet-stream) no conversion will be done.<br />
 In addition to <a href="http://metacpan.org/search?q=Email::MIME" rel="external">Email::MIME</a> this requires both installed <a href="http://metacpan.org/search?q=Convert::TNEF" rel="external">Convert::TNEF</a> and <a href="http://metacpan.org/search?q=MIME::Types" rel="external">MIME::Types</a> module in PERL.',undef,undef,'msg008170','msg008171'],
['keepOutTNEF','keep the MS-TNEF part in outbound mail',0,\&checkbox,'1','(.*)',undef,
  'keep outbound MS-TNEF attachments like winmail.dat in MIME parts. If unchecked and the conversion is successful, the original attachment will be removed from mail!',undef,undef,'msg008180','msg008181'],
['convertNP','convert NoProcessing mails',0,\&checkbox,'','(.*)',undef,
  'Set this to on, if noprocessing mails should be converted, which is normally not the case.',undef,undef,'msg008840','msg008841'],
['doDKIMConv','convert DKIM mails',0,\&checkbox,'0','(.*)',undef,
  'DKIM messages could normally not modified. If checked, conversions will be done on DKIM messages - <span class="negative">you have to disable the DKIM check on your email server (MTA)!</span>',undef,undef,'msg008190','msg008191'],
['TNEFDEBUG','TNEFDEBUG (only in dev)',0,\&checkbox,'','(.*)',undef,'prints TNEF conversion debug info to screen.<br /><hr />
  <div class="cfgnotes">Notes On Character Conversions / TNEF</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/conversions.txt\',3);" />',undef,undef,'msg008200','msg008201'],

[0,0,0,'heading','SSL Proxy and TLS support'],
['DoTLS','How to Handle STARTTLS Requests','0:drop TLS|1:TLS to Proxy|2:do TLS',\&listbox,0,'(\d*)',undef,
  'If set to "drop TLS", any STARTTLS request will be removed from the protocol stack and no connection will ever go into any TLS mode!<br />
  If set to "TLS to Proxy" and both peers (client and server) supports TLS, both connection will be moved into a transparent Proxy mode. All data will be encrypted and unreadable to ASSP.<br />
  If set to "do TLS", ASSP will act as a "man in the middle". ASSP will try to move both connections into TLS. All data will be readable to ASSP - so all checks could be done. If any of the peers does not support TLS, ASSP will fake this (250-STARTTLS) to the other peer. So it could be possible, that the connection to the client is going into TLS mode, even if TLS is not supported by the server. If a client does not request TLS (STARTTLS) even it has got the (250-STARTTLS), ASSP tries to start a TLS session to server, if he has sent (250-STARTTLS)! This behavior belongs to incoming and outgoing messages. This option requires the installed perl module <a href="http://metacpan.org/search?q=IO::Socket::SSL" rel="external">IO::Socket::SSL</a>!<br />
  For "do TLS" a server-certificate-file " SSLCertFile " and a server-key-file " SSLKeyFile " must exist and must be valid!<br />
  If you do not have valid certificates, you may generate both files online with <a href="http://www.mobilefish.com/services/ssl_certificates/ssl_certificates.php" rel="external">www.mobilefish.com</a> or you may use OpenSSL to generate <a href="http://www.mobilefish.com/developer/openssl/openssl_quickguide_self_certificate.html" rel="external">Self-signed SSL certificates</a>! If you have installed OpenSSL (must be in PATH) and installed and enabled IO::Socket::SSL and ASSP is unable to find valid certificates - ASSP will try to create them at startup!<br />
  Before you enable this feature, make sure that sendNoopInfo is switched off! If sendNoopInfo is enabled, STARTTLS will possibly not work!<br />
  To enforce the usage of TLS configure forceTLSIP .<br />
  If possible, you should consider to implement the \'SMTP MTA Strict Transport Security (MTA-STS)\' by following the instructions in <a href="https://tools.ietf.org/html/rfc8461" rel="external">RFC8461</a>. To get MTA-STS working for incoming mails, it may be required to configure and to enable the SNI support (please read the complete SSL/TLS section). To use MTA-STS for outgoing mails, no special assp configuration is required - your outgoing MTA must support and implement MTA-STS.<br />
  <b>DO NOT</b> try to use the assp internal webserver to provide MTA-STS policy fetching (like: https://mta-sts.your-domain.tld/.well-known/mta-sts.txt - read <a href="https://tools.ietf.org/html/rfc8461#section-3.2" rel="external">RFC8461 section-3.2</a>)!<br />
  To implement the highes possible security level for SMTP you should consider to implement \'DNS-Based Authentication of Named Entities (DANE - RFC6698)\' and \'TLSA\' for your hosted mail domains!<br />
  <input type="button" value="SSL-failed-Cache" onclick="javascript:popFileEditor(\'DB-SSLfailed\',\'1h\');" /><br />',undef,undef,'msg008210','msg008211'],
['SSL_version','SSL version used for transmission',80,\&textinput,'SSLv23:!SSLv3:!SSLv2','(\!?(?:SSLv2\/?3|SSLv2|SSLv3|TLSv1(_?[123])?)(?:\:\!?(SSLv2\/?3|SSLv2|SSLv3|TLSv1(_?[123])?))*)','ConfigChangeSSL',
  'Sets the version of the SSL protocol used to transmit data. The default is SSLv23:!SSLv3:!SSLv2.<br />
  The IO::Socket::SSL POD explains:<br />
  Sets the version of the SSL protocol used to transmit data.<br />
  \'SSLv23\' and the older definition \'SSLv2/3\' (of the same) uses a handshake compatible with SSL2.0, SSL3.0 and TLS1.x, while
  \'SSLv2\', \'SSLv3\', \'TLSv1\', \'TLSv1_1\', \'TLSv1_2\' or \'TLSv1_3\' restrict handshake and protocol to the specified version.<br />
  All values are case-insensitive.  Instead of \'TLSv1_1\', \'TLSv1_2\' and \'TLSv1_3\' one can
  also use \'TLSv11\', \'TLSv12\' and \'TLSv13\'.  Support for \'TLSv1_1\', \'TLSv1_2\' and \'TLSv1_3\' requires
  recent versions of Net::SSLeay, openssl and IO::Socket::SSL.<br /><br />
  Independent from the handshake format you can limit to set of accepted SSL versions by adding !version separated by \':\'. <br /><br />
  The default SSL_version is \'SSLv23:!SSLv3:!SSLv2\' which means, that the
  handshake format is compatible to SSL2.0 and higher, but that the successful
  handshake is limited to TLS1.0 and higher, that is no SSL2.0 or SSL3.0 because
  both of these versions have serious security issues and should not be used anymore.<br />
  You can also use !TLSv1_1, !TLSv1_2 and !TLSv1_3 to disable TLS versions 1.1, 1.2 and 1.3 while still allowing TLS version 1.0.<br /><br />
  Setting the version instead to \'TLSv1\' might break interaction with older
  clients, which need a SSL2.0 compatible handshake. On the other
  side, some clients just close the connection when they receive a TLS version 1.1
  request. In this case setting the version to
  \'SSLv23:!SSLv2:!SSLv3:!TLSv1_1:!TLSv1_2:!TLSv1_3\' might help.',undef,undef,'msg009660','msg009661'],
['SSL_cipher_list','SSL key cipher list',80,\&textinput,'','(.*)','ConfigChangeSSL',
 'If this option is set, the cipher list for the connection will be set to the given value, e.g. something like \'ALL:!LOW:!EXP:!ADH\' or \'DEFAULT:!aNULL:!RC4:!MD5\'. Look into the OpenSSL documentation (<a href="http://www.openssl.org/docs/apps/ciphers.html#CIPHER_STRINGS" rel="external">http://www.openssl.org/docs/apps/ciphers.html#CIPHER_STRINGS</a>) for more details. Setting this value causes the \'SSL_honor_cipher_order\' flag to be switched on (BEAST vulnerable)<br />
 If this option is not used (default) the IO::Socket::SSL builtin defaults are used, which are suitable for most cases.',undef,undef,'msg009670','msg009671'],
['NoTLSlistenPorts','Disable SSL support on listenPorts',80,\&textinput,'','(.*)','ConfigChangeTLSPorts',
  'This disables TLS/SSL on the defined listenPorts, if DoTLS is set to "do TLS". All other SMTP listeners will support TLS/SSL, if DoTLS is set to "do TLS". This option works for listenPort , listenPort2 and relayPort . The listener definition here has to be the same like in the port definitions. Separate multiple entries by "|".<p><small><i>Examples:</i> 25, 127.0.0.1:25, 127.0.0.1:25|127.0.0.2:25 </small></p>',undef,undef,'msg008220','msg008221'],
['TLStoProxyListenPorts','Force TLS to Proxy on this Ports',80,\&textinput,'','(.*)','ConfigChangeTLSPorts',
  'If a STARTTLS command is received on a port that is defined here, the connection will be moved into the transparent proxy mode every time - independent from the setting of DoTLS . This option works for listenPort , listenPort2 and relayPort . The listener definition here has to be the same like in the port definitions. Separate multiple entries by "|".<p><small><i>Examples:</i> 25, 127.0.0.1:25, 127.0.0.1:25|127.0.0.2:25 </small></p>',undef,undef,'msg009020','msg009021'],
['SSLPKPassword','SSL Private Key Password',48,\&passinput,'','(.*)','ConfigChangeSSL',
  "Optional parameter. If your private key ' SSLKeyFile ' is password protected, assp will need this password to decrypt the server\'s SSL private key file.",undef,undef,'msg009540','msg009541'],
['SSLKeyFile','SSL Key File (PEM format)',48,\&textinput,$dftPrivKeyFile,'(.*)','ConfigChangeSSL',
  "Full path to the file containing the server\'s SSL private key, for example: /usr/local/etc/ssl/certs/assp-key.pem or c:/assp/certs/server-key.pem. An general key.pem file is already provided in \'assp/certs/server-key.pem\'<br />
  For SNI support please read SSLWEBConfigure.",undef,undef,'msg008240','msg008241'],
['SSLCaFile','SSL Certificate Authority File',48,\&textinput,'','(.*)','ConfigChangeSSL',
  "Optional parameter to enable chained certificate validation at the client side. Full path to the file containing the server's SSL certificate authority. If you provide the ca-certificate or certificate-chain together with the certificate file in the SSLCertFile parameter, leave this field blank. For example : /usr/local/etc/ssl/certs/assp-ca.crt or c:/assp/certs/server-ca.crt. A general ca.crt file is already provided in '$dftCaFile'. The default value is empty and leave it empty as long as you don't know, how this parameter works.",undef,undef,'msg009530','msg009531'],
['SSLCertFile','SSL Certificate File (PEM format)',48,\&textinput,$dftCertFile,'(.*)','ConfigChangeSSL',
  "Full path to the file containing the server's SSL certificate or certificate-chain, for example : /usr/local/etc/ssl/certs/assp-cert.pem or c:/assp/certs/server-cert.pem. A general cert.pem file is already provided in \'assp/certs/server-cert.pem\'<br />
  For SNI support please read SSLWEBConfigure.",undef,undef,'msg008230','msg008231'],
['SSLAdvancedServerConfigFile','File with Advanced SSL-Server Parameters',48,\&textinput,'','(.*)','ConfigChangeSSL',
  'Full path to the text file containing the server\'s advanced SSL parameters.<br />
  If your SSL-server configuration requires additionally SSL-parameters according to IO::Socket::SSL and/or Net::SSLeay (for example: special Elliptic-Curve Diffie-Hellmann Key Exchange) and you don\'t want to use SSLWEBConfigure , SSLSTATConfigure , SSLSMTPConfigure confuration options, you may define a text file with your parameters here.<br />
  <b>NOTICE: assp will not check, if your configuration settings, made in this file, are valid - they are used as defined. In doubt, use SSLDEBUG to trace their effects.</b><br />
  The settings in this file are passed as part of the IO::Socket::SSL configuration HASH to IO::Socket::SSL as they are defined<br />
  Any setting redefined in this file will override default internal assp settings as well as the above assp SSL configuration settings. The assp SSL settings below this tag are not affected.<br />
  The syntax in this this file is the same like a HASH definition in Perl:<br />
  - lines starting with an # are comments and are ignored<br />
  - empty lines are ignored<br />
  - each definition for a parameter has to be terminated with a comma<br />
  - keyword and value have to be separated with =&gt;<br /><br />
  example:<br />
  # this is my special Elliptic-Curve Diffie-Hellmann Key Exchange for all listeners<br />
  SSL_dh_file =&gt; full_path_to_your_DH-File,<br />
  SSL_ecdh_curve =&gt; secp384r1,<br />
  next-key =&gt; {<br />
  &nbsp;&nbsp;subkey1 =&gt; subvalue1,<br />
  &nbsp;&nbsp;subkey2 =&gt; { key =&gt; value, },<br />
  &nbsp;&nbsp;subkey3 =&gt; {<br />
  &nbsp;&nbsp;&nbsp;&nbsp;key =&gt; value,<br />
  &nbsp;&nbsp;&nbsp;&nbsp;...,<br />
  &nbsp;&nbsp;},<br />
  &nbsp;&nbsp;...,<br />
  },<br />
  ...,<br />
  last-key =&gt;last-value,<br /><br />
  The defined file is watched for changes by assp. An possible reread of this file is only shown if SSLDEBUG is set to ON.<br />
  This option can also be used to define a SNI configuration for a relative small set of domains, instead using SSLWEBConfigure, SSLSTATConfigure and SSLSMTPConfigure.<br />
  It is highly recommended to read the documentation of IO::Socket::SSL and/or Net::SSLeay!<br />
  Because the location of this file can be outside the assp folder, it can\'t be modified using assp! Please use an external file editor.',undef,undef,'msg010640','msg010641'],
['noTLSIP','Exclude these IP\'s from TLS*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
 'Enter IP\'s that you want to exclude from starting SSL/TLS, separated by pipes (|). For example, put all IP\'s here, that making trouble to switch to TLS every time, what will prevent ASSP from getting mails from or sending mails to this hosts.',undef,undef,'msg008250','msg008251'],
['forceTLSIP','Force these IP\'s to use TLS*',80,\&textinput,'','(\S*)','ConfigMakeIPRe',
 'Enter IP\'s that you want to be enforced to use SSL/TLS, separated by pipes (|). Using Groups is allowed.<br />
  To force all IP\'s, enter 0.0.0.0/0|0::0/0 .
  DoTLS needs to be set to "do TLS" to make this feature working!<br /><br />
  If a host or client uses the MAIL FROM: command without it used STARTTLS before or STARTTLS has failed or it is not connected to a SSL-listener (in case, the connection is not transport layer secured), the permanent SMTP-error code<br />
  502 <MYNAME> connected by \'IPCONNECTED\' - \'RECEIVEDHELO\'. The used command \'LASTCOMMAND: <MAILFROM>\' is still not supported, because the connection is NOT secured by an encryption layer (TLS) - please use STARTTLS first FORCEEXPLAIN<br />
  will be sent by assp and the connection will be dropped.<br /><br />
  IP\'s listed in noTLSIP and acceptAllMail as well as private IP-ranges , IP\'s in SSL-failed-Cache and IP\'s connected to a NoTLSlistenPorts are excluded from being forced by this feature.<br />
  Mails to BounceSenders are also excluded from being forced by this feature! So TLSRPTv1 reports and other notifications are delivered, even TLS/SSL is in an invalid state.<br />
  An entry like: 0.0.0.0/0=>*@examole.org|[domainlist] or [iplist]=>*@examole.org|[domainlist]<br />
  will <b>exclude</b> the envelope sender *@example.org and domains or addresses in the [domainlist] group from being forced by this feature.<br /><br />
  If a connection is dropped by this feature, the connected IP will get no penalty (score)!<br /><br />
  <b>If this feature is enabled for all connecting IP\'s, it is highly recommended to configure MTA-STS (SMTP MTA Strict Transport Security - RFC 8461) or the more secure DANE (DNS-Based Authentication of Named Entities - RFC 6698, 7671)(SMTP Security by Opportunistic DNS-Based Authentication of Named Entities (DANE) Transport Layer Security (TLS) - RFC 7672) for your hosted domains!<br />
  Notice: MTA-STS and DANE require both the SSL_version TLSv1_2 and/or TLSv1_3</b>',undef,undef,'msg003470','msg003471'],
['banFailedSSLIP','Ban Failed SSL IP','0:disable|1:private only|2:public only|3:both',\&listbox,3,'(\d*)',undef,
 'If set (recommended is \'both\'), an IP that fails to connect using SSL/TLS will be banned for 12 hour from using SSL/TLS.<br />
  Private IP\'s and IP addresses listed in acceptAllMail will get one more try to correct the mistake.<br />
  This is done per default (\'both\'), to prevent possible DoS attacks by SSL/TLS.<br />
  Those IP\'s are stored in the SSL-failed-Cache. This cache is cleaned up at startup.<br />
  disable - disables this feature, which is highly NOT recommended<br />
  private only - only private IP\'s and IP\'s in acceptAllMail will be banned (they have two tries)<br />
  public only - only public IP\'s will be banned<br />
  both - private and public IP\'s will be banned<br />
  <input type="button" value="edit SSL-failed-Cache" onclick="javascript:popFileEditor(\'DB-SSLfailed\',\'1h\');" />',undef,undef,'msg010100','msg010101'],
['noBanFailedSSLIP','Exclude these IP\'s from SSL-failed-Cache*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','Enter IP\'s that you want to exclude from being added to the SSL-failed-Cache, separated by pipes (|).',undef,undef,'msg010280','msg010281'],
['sendEHLO','Send EHLO',0,\&checkbox,'','(.*)',undef,
  'If selected, ASSP sends an EHLO even if the client has sent only a HELO. This is useful to force the usage of TLS to the server or to satisfy XCLIENT/XFORWARD helo offers, because EHLO is needed before STARTTLS or XCLIENT/XFORWARD can be used.',undef,undef,'msg008260','msg008261'],
['SSLRetryOnError','Retry SSL on "SSL want a read first" error',10,\&textinput,'1','(\d+)',undef,
  'Define the number of SSL/TLS negotiation retries done with a half second delay after SSLtimeout , if the peer was not ready after STARTTLS or at the listenPortSSL , because of a "SSL want a read/write first" SSL handshake error.',undef,undef,'msg008270','msg008271'],
['SSLtimeout','SSL Timeout (0-999)',4,\&textinput,5,'(\d{1,3})',undef,
 'SSL/TLS negotiation will timeout after this many seconds. default is : 5 seconds.',undef,undef,'msg008280','msg008281'],
['maxSSLRenegotiations','Maximum Allowed SMTP SSL Client-Initiated-Renegotiations',4,\&textinput,10,'(\d+)',undef,
 'Maximum count of allowed SSL/TLS client initiated renegotiations to prevent DoS.<br />
  If this count is exceeded in a connection within '.$maxSSLRenegDuration.' seconds, the connection is terminated, the connected IP is registered in banFailedSSLIP and new connections from this IP address are rejected for 15-30 minutes. An IP-Score of PenaltyExtreme but at least 150 is used for the IP address. Zero disables this feature - default is : 10 attempts.<br />
  This check is skipped for well known good IPs and senders as well as for private IP ranges and outgoing mails.',undef,undef,'msg010620','msg010621'],
['SSLDEBUG','Debug Level for SSL/TLS','0:no Debug|1:level 1|2:level 2|3:level 3',\&listbox,0,'(\d*)',undef,'Set the debug-level for SSL/TLS. Than higher the level, than more information are written to maillog.txt!',undef,undef,'msg008290','msg008291'],

['webSSLRequireClientCert','Web-Client requires valid SSL Certificate for GUI Requests',0,\&checkbox,'','(.*)','ConfigChangeSSL',
  'If enabled and enableWebAdminSSL is set to ON, each browser session is forced to provide a valid SSL client certificate. If no certificate is provided by the client, the connection will fail! To extend the verification of the certificate, use SSLWEBCertVerifyCB . Per default are used \'SSL_VERIFY_PEER | SSL_VERIFY_FAIL_IF_NO_PEER_CERT | SSL_VERIFY_CLIENT_ONCE\'<br />
  To create a PKCS12 from the PEM formated cert- and key file you can use openssl, like : <br />
  openssl pkcs12 -export -clcerts -in client.pem -inkey client.key -out client.p12<br />
  The file client.p12 could now be imported into your browser.<br />
  <b>!!! Install a valid certificate into your browser BEFORE you enable this option - otherwise the GUI will get inaccessible !!!</b><br />
  <b>NOTICE: This option will possibly not work if you use any self signed certificate!</b>',undef,undef,'msg010150','msg010151'],
['SSLWEBCertVerifyCB','CallBack to Verify Web-Client Certificates for GUI Connections',80,\&textinput,'','(.*)','ConfigChangeSSL',
  'If used, assp will call the defined subroutine as SSL->SSL_verify_callback in an eval closure submitting the original ARRAY of parameters (<b>read the IO::Socket::SSL documentation</b>).<br />
  The subroutine has to return 1 on certificate verification success - otherwise 0.<br />
  You can use/modify the module lib/CorrectASSPcfg.pm to implement your code. For example<br /><br />
  sub checkWebSSLCert {<br />
  &nbsp;&nbsp;&nbsp;&nbsp;my ($OpenSSLSays,$CertStackPtr,$DN,$OpenSSLError, $Cert)=@_;<br />
  &nbsp;&nbsp;&nbsp;&nbsp;my $Subject = Net::SSLeay::X509_NAME_oneline(Net::SSLeay::X509_get_subject_name($Cert));<br />
  &nbsp;&nbsp;&nbsp;&nbsp;my $Chain = Net::SSLeay::PEM_get_string_X509($Cert);<br />
  &nbsp;&nbsp;&nbsp;&nbsp;...any code...;<br />
  &nbsp;&nbsp;&nbsp;&nbsp;my $isSuccess = eval{verify($Cert);};<br />
  &nbsp;&nbsp;&nbsp;&nbsp;return $OpenSSLSays if $@;<br />
  &nbsp;&nbsp;&nbsp;&nbsp;my $Owner = eval{get_owner($Cert);};<br />
  &nbsp;&nbsp;&nbsp;&nbsp;return $OpenSSLSays if $@;<br />
  &nbsp;&nbsp;&nbsp;&nbsp;my $userPass = get_pass($Owner);};<br />
  &nbsp;&nbsp;&nbsp;&nbsp;@main::ExtWebAuth = ($Owner,$userPass)<br />
  &nbsp;&nbsp;&nbsp;&nbsp;return $isSuccess;<br />
  }<br /><br />
  Now, if you set this parameter to \'CorrectASSPcfg::checkWebSSLCert\' - assp will call<br />
  CorrectASSPcfg::checkWebSSLCert->(@_);<br />
  The variable \'@main::ExtWebAuth\' could be used to authenticate the user to the GUI related to the used certificate. The username must be provided as first element of the array. The password could be provided as second element of the array - this is not recommended and it is not required! If the used certificate is valid and a known adminusername (root is provided) is stored as first element in \'@main::ExtWebAuth\', the user will be automatically logged on to the GUI.<br />
  <b>NOTICE: This option will possibly not work if you use any self signed certificate!</b>',undef,undef,'msg010160','msg010161'],
['SSLWEBConfigure','Call to Configure SSL-Listener-Parameters for GUI Connections',80,\&textinput,'','(.*)','ConfigChangeSSL',
  'If used, assp will call the defined subroutine in an eval closure submitting a reference to the assp predefined SSL-Socket-Configuration-HASH.<br />
  The HASH could be modified in place to your needs.<br /><br />
  <b>*** Please read the <a href="http://www.annocpan.org/dist/IO-Socket-SSL" rel="external">documentation for your used version of IO::Socket::SSL</a>. Advanced usage may require to read also the Net::SSLeay and OpenSSL documentation! ***</b><br /><br />
  Return values of your configuration sub are ignored.<br />
  You can use and modify the module lib/CorrectASSPcfg.pm to implement your code. For example<br /><br />
  sub configWebSSL {<br />
  &nbsp;&nbsp;&nbsp;&nbsp;my &#x24;parms = shift;<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&#x24;parms->{timeout} = 10;<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&#x24;parms->{\'SSL_check_crl\'} = 1;<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&#x24;parms->{\'SSL_crl_file\'} = \'/assp/certs/crl/crllist.pem\';<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&#x24;parms->{\'SSL_CTX_set_security_level\'} = 3;<br />
  &nbsp;&nbsp;&nbsp;&nbsp;return;<br />
  }<br /><br />
  <hr><b>SNI Support</b><br />
  If the SSL listener should be able to use different certificates on the same IP address, depending on the name given by SNI, you can use a hash reference instead of a file with hostname =&gt; cert_file.<br /><br />
  In case certs and keys are needed but not given it might fall back.<br /><br />
  sub configWebSSL {<br />
  &nbsp;&nbsp;&nbsp;&nbsp;my &#x24;parms = shift;<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&#x24;parms->{SSL_cert_file} = {<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"foo.example.org" =&gt; "/full_path_ to_file/foo-cert.pem",<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"bar.example.org" =&gt; "/full_path_to_file/bar-cert.pem",<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;# used when nothing matches or client does not support SNI<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"" =&gt; "/full_path_to_file/server-cert.pem",<br />
  &nbsp;&nbsp;&nbsp;&nbsp;};<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&#x24;parms->{SSL_key_file} = {<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"foo.example.org" =&gt; "/full_path_to_file/foo-key.pem",<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"bar.example.org" =&gt; "/full_path_to_file/bar-key.pem",<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;# used when nothing matches or client does not support SNI<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"" =&gt; "/full_path_to_file/server-key.pem",<br />
  &nbsp;&nbsp;&nbsp;&nbsp;};<br />
  }<br /><br />
  Now, if you set this parameter to \'CorrectASSPcfg::configWebSSL\' - assp will call<br />
  CorrectASSPcfg::configWebSSL->(\%sslparms);<br /><br />
  To support SNI at the SMTP listeners, you may do the following for example:<br /><br />
  sub configSMTPSSL {<br />
  &nbsp;&nbsp;&nbsp;&nbsp;my &#x24;parms = shift;<br />
  &nbsp;&nbsp;&nbsp;&nbsp;my &#x24;listenerName = &amp;main::getSMTPListenerConfigName(&#x24;parms->{LocalAddr},&#x24;parms->{LocalPort}); # returns listenPort , listenPort2 , listenPortSSL , relayPort or undef - may be used to implement different parameter settings for some or each SMTP listener<br />
  &nbsp;&nbsp;&nbsp;&nbsp;if (&#x24;listenerName eq \'listenPortSSL\') { # enable SNI at the listenPortSSL <br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&#x24;parms-&gt;{SSL_cert_file} = {<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"foo.example.org" =&gt; "/full_path_ to_file/foo-cert.pem",<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"bar.example.org" =&gt; "/full_path_to_file/bar-cert.pem",<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;# used when nothing matches or the SMTP peer does not support SNI<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"" =&gt; "/full_path_to_file/server-cert.pem",<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;};<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&#x24;parms-&gt;{SSL_key_file} = {<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"foo.example.org" =&gt; "/full_path_to_file/foo-key.pem",<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"bar.example.org" =&gt; "/full_path_to_file/bar-key.pem",<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;# used when nothing matches or the SMTP peer does not support SNI<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"" =&gt; "/full_path_to_file/server-key.pem",<br />
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;};<br />
  &nbsp;&nbsp;&nbsp;&nbsp;} # the next "elsif" and "else" code parts may be used or not, this depends on the requirements for the other listeners.<br />
  &nbsp;&nbsp;&nbsp;&nbsp;elsif (&#x24;listenerName eq \'listenPort2\') {... set parms here for listenPort2 ...}<br />
  &nbsp;&nbsp;&nbsp;&nbsp;elsif (&#x24;listenerName eq \'relayPort\') {... set parms here for relayPort ...}<br />
  &nbsp;&nbsp;&nbsp;&nbsp;else {... set parms here for listenPort (not recommended!) ...}<br />
  }<br /><br />
  To set a single parameter (e.g. init SSL_cert_file and SSL_key_file like &#x24;parms-&gt;{SSL_cert_file} = {}; or delete &#x24;parms-&gt;{SSL_key_file}; before switching them from scalar to an anonymous hash), follow the HASH notation: &#x24;parms-&gt;{SSL_cert_file}-&gt;{your-domain} = "/full_path_ to_file/your-domain-cert.pem"; <br /><br />
  ASSP uses a permanent SSL-context in SSL server mode. ASSP will watch all your configurations made here and will renew the SSL-Server-Context, if this is required.<br />
  If you want to manage ALL SSL settings including the SSL-context by your own code, store your IO::Socket::SSL::SSL_Context object in &#x24;parms-&gt;{SSL_reuse_ctx}. In this case, your settigs will be no longer watched by assp.<br />
  If you need to set different SNI parameters for different IP-addresses insite a listener, the "if" checks may depend on &#x24;parms->{LocalAddr} and &#x24;parms->{LocalPort} as well.<br />
  If you don\'t want assp to check your SNI configuration, even you don\'t created a SSL-Context object, set &#x24;parms-&gt;{skip_config_check} = 1; . For more information have a look into sub  getSSLParms  in the assp.pl code.<br />
  <b>NOTICE: This option will possibly not work if you use any self signed certificate!</b>',undef,undef,'msg010170','msg010171'],

['statSSLRequireClientCert','Client requires valid SSL Certificate for STAT Requests',0,\&checkbox,'','(.*)','ConfigChangeSSL',
  'If enabled and enableWebStatSSL is set to ON, each session is forced to provide a valid SSL client certificate. If no certificate is provided by the client, the connection will fail! To extend the verification of the certificate, use SSLSTATCertVerifyCB . Per default are used \'SSL_VERIFY_PEER | SSL_VERIFY_FAIL_IF_NO_PEER_CERT | SSL_VERIFY_CLIENT_ONCE\'<br />
  <b>NOTICE: This option will possibly not work if you use any self signed certificate!</b>',undef,undef,'msg010180','msg010181'],
['SSLSTATCertVerifyCB','CallBack to Verify Client Certificates for STAT Connections',80,\&textinput,'','(.*)','ConfigChangeSSL',
  'Please read the description of SSLWEBCertVerifyCB .<br />
  <b>NOTICE: This option will possibly not work if you use any self signed certificate!</b>',undef,undef,'msg010190','msg010191'],
['SSLSTATConfigure','Call to Configure SSL-Listener-Parameters for STAT Connections',80,\&textinput,'','(.*)','ConfigChangeSSL',
  'If used, assp will call the defined subroutine in an eval closure submitting a reference to the assp predefined SSL-Socket-Configuration-HASH.<br />
   Please follow the description for SSLWEBConfigure .<br />
   <b>NOTICE: This option will possibly not work if you use any self signed certificate!</b>',undef,undef,'msg010200','msg010201'],

['smtpSSLRequireClientCert','SMTP-Client requires valid SSL Certificate for SMTP SSL Connections',0,\&checkbox,'','(.*)','ConfigChangeSSL',
  'If enabled, each client or server requesting a connection at the listenPortSSL requires a valid SSL client certificate. If no certificate is provided by the client, the connection will fail! To extend the verification of the certificate, use SSLSMTPCertVerifyCB . Per default are used \'SSL_VERIFY_PEER | SSL_VERIFY_FAIL_IF_NO_PEER_CERT | SSL_VERIFY_CLIENT_ONCE\'<br />
  <b>NOTICE: This option will possibly not work if you use any self signed certificate!</b>',undef,undef,'msg010210','msg010211'],
['SSLSMTPCertVerifyCB','CallBack to Verify Client Certificates for SMTP Connections',80,\&textinput,'','(.*)','ConfigChangeSSL',
  'Please read the description of SSLWEBCertVerifyCB .<br />
  <b>NOTICE: This option will possibly not work if you use any self signed certificate!</b>',undef,undef,'msg010220','msg010221'],
['SSLSMTPConfigure','Call to Configure SSL-Listener and TLS - Parameters for SMTP Connections',80,\&textinput,'','(.*)','ConfigChangeSSL',
  'If used, assp will call the defined subroutine in an eval closure submitting a reference to the assp predefined SSL-Socket-Configuration-HASH.<br />
   Please follow the description for SSLWEBConfigure .<br />
   <b>NOTICE: This call is used to configure SMTP-SSL-Listeners and it is also used, if assp receives a STARTTLS request and DoTLS is set to "do TLS".<br />
   This option will possibly not work if you use any self signed certificate!</b>
   <hr />
  <div class="cfgnotes">Notes On SSL and TLS Support</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/ssl_and_proxy.txt\',3);" />',undef,undef,'msg010230','msg010231'],

[0,0,0,'heading','Global PenaltyBox Network'],
['globalClientName','GPB Client Registration Name',60,\&textinput,'','(.*)','configUpdateGlobalClient',
 'The Name of this global-client for registration on the global-server. This entry has to be the full qualified DNS-Name of the IP-address over which ASSP is doing HTTP-requests! If you are using a HTTP-Proxy, this should be the public IP-address of the last Proxy in chain! This DNS-Name has to be resolvable worldwide and the resolved IP-address has to match the ASSP-HTTP-connection-IP-address. It is not possible to use an IP-address in this field! Dynamic DNS-Names like "yourdomain.dyndns.org" are supported!<br />
 To become a member of the exclusive global-penalty-box-users, you will need a subscription and you will have to pay a yearly maintenance fee. To get registered and/or to get more information, please send an email with your personal/company details and the globalClientName to "assp.globalpb@thockar.com".<br />
 The name of this client has to be known by the global server <b>before</b> it can be registered from here. Please wait until you got a confirmation, that your client name is known by the global server.<br />
 If assp is unable to connect to the GPB-server for registration, check the IP - and - clientname relation! You may also try to set this parameter to the value \'<b>clean</b>\' one time - this will reset all GPB-internals and GPB-configuration parameters to their default value.<br />
 Make sure, the used assp version and the perl modules are uptodate!<br />
 <b>Notice: In case you are using multiple assp instances in cluster mode (shared config, shared databases, blockreport forwarding ...), you need to register all instances for the GPB!</b></br>
 In addition to <a href="http://metacpan.org/search?q=Compress::Zlib" rel="external">Compress::Zlib</a> this requires an installed <a href="http://metacpan.org/search?q=LWP::UserAgent" rel="external">LWP::UserAgent</a> module in PERL.',undef,undef,'msg008310','msg008311'],
['globalClientPass','GPB Client Registration Password',20,\&passnoinput,'','(.*)','configUpdateGlobalHidden','If the global client is registered on the global-server, you will see a number of "*" in this field. This field is readonly.',undef,undef,'msg008320','msg008321'],
['globalClientLicDate','GPB Client Subscription Expiration Date',20,\&textnoinput,'','(.*)','configUpdateGlobalHidden','The date of license/subscription expiration for this global client. If this date is exceeded, no upload and download of global PB will be done! This field is readonly.',undef,undef,'msg008330','msg008331'],
['DoGlobalBlack','Enable the Global-Black-Penalty',0,\&checkbox,'','(.*)',undef,'Enables the merge of the Black-Penalty-Box-Entries, if the client is registered on the global-PB-server. Upload and download of the black penalty entries are done independent from this setting as long as any of GPBDownloadLists or GPBautoLibUpdate is activated.',undef,undef,'msg008340','msg008341'],
['globalValencePB','Value for Global-Black-PB Entries +',10,\&textinput,200,'(\s*\d+\s*(?:\|\s*\d+\s*){0,1})','ConfigChangeValencePB',
 'This penalty-value will be given to downloaded Black-Penalty-Box-Entries. As long as entries have the "GLOBALPB" state, they will never become extreme-Black. It is recommended to set this value above PenaltyLimit! The default value is 200.<br />
 <b>Do not forget to configure the assp PenaltyBox ( DoPenalty )</b>, otherwise Global-Black-PB and Global-White-Penalty will have no effect. To get early blocking behavior for GPB-Black IP\'s, configure DelayIP . It is also recommended to enable MsgScoreOnEnd .',undef,undef,'msg008350','msg008351'],
['globalBlackExpiration','Expiration for Global-PB-Black Records',3,\&textinput,48,'(\d*)',undef, 'Global-Black-Penalties will expire after this number of hours.',undef,undef,'msg008360','msg008361'],
['DoGlobalWhite','Enable the Global-White-Penalty',0,\&checkbox,'','(.*)',undef,'Enables the merge of the White-Penalty-Box-Entries, if the client is registered on the global-PB-server. Upload and download of the white penalty entries are done independent from this setting as long as any of GPBDownloadLists or GPBautoLibUpdate is activated.',undef,undef,'msg008370','msg008371'],
['globalWhiteExpiration','Expiration for Global-PB-White Records(days)',3,\&textinput,7,'(\d*)',undef, 'Global-White-Penalties will expire after this number of days.',undef,undef,'msg008380','msg008381'],
['GPBDownloadLists','Download List and Regex Updates from GPB-Server','0:no download|1:download|2:download and install',\&listbox,2,'(\d*)',undef,'Select, if assp should download updates for lists and regular expressions from the global penaltybox server. Downloads will be done to the \'download\' folder. If install is selected, the downloaded lines will merged into the defined files (file:...). If you want to disable a specific line in any of your files, do not delete the line, instead comment it out - putting a \'#\' or \';\' in front of the line. If any list is not configured using the \'file:...\' option, only the download will be done, even if install is selected. To disable a line that was added by the GPB-server to your file - simply commend the line out (# or ;). If you remove such a line, it could be possibly added again by the next GPB check. To change a line that was added by the GPB-server to your file - disable the line and customize a copied line to your needs.',undef,undef,'msg009370','msg009371'],
['GPBautoLibUpdate','Download Plugin and Library Updates from GPB-Server','0:no download|1:download|2:download and install',\&listbox,2,'(\d*)',undef,'Select, if assp should download updates for Plugins or Library-Files (../lib) from the global penaltybox server. Downloads will be done to the \'download\' folder. If install is selected, the downloaded Plugins and/or modules will be installed into their original location, if an older version of the file still exists. If an older version is not found, only the download will be done. To activate updated Plugins or modules a restart of assp is required. This feature will not force an automatic restart of assp!.
<hr /><div class="cfgnotes">Notes On Global Penalty Box</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/global_pb.txt\',3);" />',undef,undef,'msg009380','msg009381'],

[0,0,0,'heading','Block Reporting - Schedule and Instant'],
['ExtraBlockReportLog','Enable extra Logging for BlockReports',0,\&checkbox,'1','(.*)','ConfigChangeBRLogfile','Maillogs could grow to a very large size. Enable this feature to log only loglines with blocking information to an extra file. These files will be named as "b" + logfile . Using this option will speed up Block Reporting. Before you switch on this option, you should run "grep"[linux/MacOS] or "find"[Windows] to create the "b" - file from the maillogs.<br />
 linux/MacOS - grep "\\[spam found\\]" *maillog.txt &gt; bmaillog.txt<br />
 Windows - find "[spam found]" *maillog.txt &gt; bmaillog.txt',undef,undef,'msg008390','msg008391'],
['EmailBlockReport','Request Block Report',40,\&textinput,'asspblock','('.$EmailAdrRe.')?','ConfigChangeBlockReport',
 'Any mail sent by local/authenticated users to this username will be interpreted as a request to get a report about blocked emails. Do not put the full address here, just the user part. For example: asspblock<br />
 Leading digits/numbers in the mail subject will be interpreted as "report request for the last number of days". If the number of days is not specified in the mail subject, a default of 5 days will be used to build the report. <br />
 All characters behind the "number of days" will be interpreted as a regular expression to overwrite the BlockReportFilter - leading and trailing white spaces will be ignored.<br />
 Users defined in EmailBlockTo, EmailAdmins, BlockReportAdmins and EmailAdminReportsTo are \'Admins\' and can request a report for multiple users. They have to use a special syntax with \'=>\' in the body of the report request. The syntax is: <br />
 QueryAddress=>ReportRecipient=>ReportDays  -  there are many possible combinations of this three parameters. For example:<br />
 user@domain and user@domain=>user@domain - will send a report for this user to this user<br />
 *@domain (better use) *@domain=>* - will send a report for every blocked user in this domain to this user<br />
 user@domain=>recipient@any-domain - will send a report for user@domain to recipient@any-domain<br />
 *@domain=>recipient@any-domain - will send a report for every blocked user in this domain to recipient@any-domain<br />
 It is possible to define a group ( Groups ) in the first parameter like:<br />
 [users@domain]<br />
 [users@domain]=>*<br />
 [users@domain]=>recipient@any-domain<br />
 The group name must be a lower case email address of a local domain without any wildcard.<br />
 The first and second example will create a block report for each group member.<br />
 The third example will create a combined block report for all email addresses defined in this group - useful, if someone has multiple email addresses and wants to get a single report.<br />
 If the group name is equal to a real existing email address of a user, and this user requests a block report using this email address (MAIL FROM:), a combined block report for the group will be generated.<br />
 A third parameter is possible to set, which defines the number of days for which the report should be created. The default (if empty or not defined) is one day. This value is used to calculate the \'next run date\'. For example:<br />
 *@domain=>recipient@any-domain=>2 - creates a report for two days.<br />
 *@domain=>*=>14 - creates a report for 14 days.<br />
 user@domain=>=>3 or user@domain=>*=>3 - creates a report for three days. The second parameter is here empty or *.<br />
 To overwrite the defined BlockReportFilter, you can define a fourth parameter, which contains the regular expression to use.<br />
 *@domain=>*=>14=>virus|newsletter - creates a report for 14 days and skips all lines that contains the words \'virus\' or \'newsletter\'.<br />
 If an admin emails a block report request and specifies a filter in the subject of the email and a fourth parameter in the body, both regular expressions will be merged into a single regex for each line.<br />
 If you or a user want the default BlockReportFilter to become part of the overwrite regex, the literal \'$BRF\' should be included in the regex like:<br />
 *@domain=>*=>14=>virus|$BRF|newsletter - or even in the subject of the email<br />
 In this case the literal \'$BRF\' will be replaced by the BlockReportFilter.<br />
 Only Admins are able to request blockreports for non local email addresses. For example:<br />
 user@non_local_domain=>recipient@any-domain=>4<br />
 *@non_local_domain=>recipient@any-domain=>4<br />
 This will result in an extended blockreport for the non local address(es). Replace \'non_local_domain\' with the domain name you want to query for. Defining the report receipient \'=>recipient@any-domain\' is mandatory in this case! All BlockReportFilter will be ignored for extended reports! Extended blockreports will contain all loglines found for requested address(es).<br />
 It is possible to change the complete design of the BlockReports to your needs,  using a html-css file. A default css-file \'blockreport.css\' is in the image folder as is a default icon file \'blockreporticon.gif\' and a default header-image-file \'blockreport.gif\'.  These are optional files - If assp can not find these files in its
 image folder, it will use the default hardcoded css and icon. If the file \'blockreport.gif\' is not found \'logo.gif\' will be used.<br />
 To change any content, use the Blockreport::modify module in the lib folder. You\'ll need some Perl skills to do that.<br />
  <input type="button" value=" Edit blockreport_sub.txt file" onclick="javascript:popFileEditor(\'reports/blockreport_sub.txt\',2);" /><br />
  <input type="button" value=" Edit blockreport_html.txt file" onclick="javascript:popFileEditor(\'reports/blockreport_html.txt\',2);" /><br />
  <input type="button" value=" Edit blockreport_text.txt file" onclick="javascript:popFileEditor(\'reports/blockreport_text.txt\',2);" />','Basic',undef,'msg008400','msg008401'],
['EmailBlockReportDomain','Request Blocked Email Domain',40,\&textinput,'@assp.local','(\@'.$EmailDomainRe.')?','ConfigChangeBlockReport',
  'Set this to the domain to which the users can send a request to receive blocked messages. For example: @assp.local. Notice the leading required \'@\'!',undef,undef,'msg008410','msg008411'],
['EmailBlockReply','Reply to Block-Report Request','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailBlockTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,
  '',undef,undef,'msg008420','msg008421'],
['QueueUserBlockReports','Queue User Block Report Requests','0:run instantly|2:store and run scheduled',\&listbox,0,'(\d*)',undef,
  'How to process block report requests for users ( not EmailBlockTo, EmailAdmins, BlockReportAdmins, EmailAdminReportsTo ).<br />
  \'run instantly\' - the request will be processed instantly (not stored).<br />
  \'store and run scheduled\' - (deprecated) the request will be stored/queued, runs permanently scheduled at BlockReportSchedule until it will be removed from queue - a \'+\' in the subject is not needed<br />
  To add a request to queue, the user has to send an email to EmailBlockReport. Leading digits/numbers in the mail subject will be interpreted as "report request for the last number of days". If the number of days is not specified in the mail subject, a default of 5 days will be used to build the report.<br />
  If \'run instantly\' is selected, but a user wants to schedule a permanent request, a leading \'+\' before the digits in subject is required.<br />
  To remove a request from queue the user has to send an email to EmailBlockReport with a leading \'-\' in the subject.<br />
  <input type="button" value=" Edit user report queue" onclick="javascript:popFileEditor(\'files/UserBlockReportQueue.txt\',2);" />',undef,undef,'msg008430','msg008431'],
['QueueSchedule','Runtime for Queued Requests <sup>s</sup>',40,\&textinput,'0',$ScheduleGUIRe,'configChangeSched',
  'Runtime hour for reports in QueueUserBlockReports. Set a number between 0 and 23. 0 means midnight and is default',undef,undef,'msg008440','msg008441'],
['BlockRepForwHost','Forward The Blockreportrequest to other ASSP',40,\&textinput,'','(.*)','ConfigChangeBlockReport','If you are using more than one ASSP (backup MX), define the IP-address and relayPort (x.x.x.x:ppp - for SSL use SSL:x.x.x.x:ppp) of the other ASSP here (separate multiple entries by "|"). Using the default listener (25) and acceptAllMail is also possible. A received Blockreportrequest will be forwarded to this ASSP and the user will get a blockreport from every ASSP. The forwarded request has the same sender and recipient like the original request. So, EmailBlockReport and EmailBlockReportDomain have to be configured identically on all ASSP! Resend requests are automatic forwarded to the right (or next) host, if ASSP finds the hostname in the subject of the request. If you have more than two ASSP, the logical sending structure must be a star. If ASSP(A) (the sun) is in the middle and you have also ASSP(B), ASSP(C) and ASSP(D) (satellites), ASSP(A) should know C,B and D, and B,C and D should only know A.<br />
  If ASSP receives a Blockreportrequest from a here defined IP-addess, a forwarded request is assumed and the request will be not forwarded back to this host (but to all other defined IPs). If hostnames are used, make sure they are resolvable to a single IP-address. ASSP will compare IP-addresses to detect if forwarding needs to be done or not!<br />
  If a forward host is unreachable, the forward request will be queued for a maximum of 24 hours and the user will be informed sending the \'reports/blockreportforwarderror.txt\' file.<br />
  The perl module <a href="http://metacpan.org/search?q=Net::SMTP/" rel="external">Net::SMTP</a> is required to use this feature (for SSL - Net::SMTP::SSL is required).',undef,undef,'msg008450','msg008451'],
['EmailBlockTo','Send Copy of Block-Reports TO',40,\&textinput,'','('.$EmailAdrRe.'\@'.$EmailDomainRe.')?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com',undef,undef,'msg008460','msg008461'],
['BlockReportAdmins','BlockReport Admins*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'A list of local addresses, which have the same rights like EmailAdmins, but only for all BlockReport functions (nothing else). Leave this field blank (default), to disable this feature.<br />
  This is useful, if a user must request BlockReports or resend mails for other users like an EmailAdmin and BlockReportAdmin can do it, but should not have other extended rights to use the EmailInterface.<br />
  Accepts specific addresses (user@domain.com), user parts (user).  Wildcards are supported (fribo*@domain.com).<br />
  For example: fribo*@thisdomain.com|jhanna ',undef,undef,'msg010480','msg010481'],
['EmailAdminDomains','Email Admin BlockReport User and Domain Restrictions*',40,\&textinput,'','(file:.+)|','ConfigMakeEmailAdmDomRe',
  'Use this parameter to restrict users registered in EmailAdmins, BlockReportAdmins, EmailAdminReportsTo and EmailBlockTo to a list of domains or users, for which they can request BlockReports.<br />
  It is possible to use defined GROUPS on both sites. The file: option is required. Use the following syntax to define an entry (one per line):<br />
  EmailAdminAddress=>*@domain1,*@domain2,user@domain3,...<br />
  EmailAdminAddress1|EmailAdminAddress2=>*@domain1,*@domain2,user@domain3,...<br />
  [group_of_EmailAdminAddresses]=>*@domain1,*@domain2,user@domain3,...<br />
  [group_of_EmailAdminAddresses]=>[group_of_domains],...<br />
  Wildcards are allowed to be used only in the domain definition - like *@*.domain.tld - separate multiple domains by comma.<br />
  If an address of an EmailAdmin or BlockReportAdmin is defined multiple times, all entries are used in an "AND" logic.<br />
  If a BlockReport is requested for a not allowed email address, the complete BlockReport request will be ignored.<br />
  If an EmailAdmins or BlockReportAdmins address is not registered in this parameter, he/she is able to request BlockReports for all domains.',undef,undef,'msg009710','msg009711'],
['EmailResendRequester','Blocked Email Resend Requester*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'A list of local addresses, which are allowed to request a resend of blocked emails for other users, even they are not EmailAdmins or BlockReportAdmins . Leave this field blank (default), to disable this feature.<br />
  This is useful, if a user gets automatic generated BlockReports (e.g by BlockReportFile ) for a group of users and should be able to manage resends for them. Added here, the user is not allowed to request BlockReports for other users - in this case use EmailAdmins, BlockReportAdmins and EmailAdminDomains instead.<br />
  The resend is done to the recipient stored in the X-Assp-Intended-For: ( requires AddIntendedForHeader ) header field and the requester, if the address was found in a TO: header field. <br />
  Accepts specific addresses (user@domain.com), user parts (user).  Wildcards are supported (fribo*@domain.com).<br />
  For example: fribo*@thisdomain.com|jhanna ',undef,undef,'msg010120','msg010121'],
['BlockReportFile','File for Blockreportrequest',40,\&textinput,'','(file:.+)|','initMaintScheduler','A file with BlockReport requests. ASSP will generate a block report for every line in this file (file:files/blockreportlist.txt - file: is required if defined!) every day at midnight for the last day. The perl modules <a href="http://metacpan.org/search?q=Net::SMTP/" rel="external">Net::SMTP</a> and <a href="http://metacpan.org/search?q=Email::MIME /" rel="external">Email::MIME </a> are required to use this feature. A report will be only created, if there is at least one blocked email found! The syntax is: <br />
 QueryAddress=>ReportRecipient=>ReportDays  -  there are many possible combinations of this three parameters. For example:<br />
 user@domain and user@domain=>user@domain - will send a report for this user to this user<br />
 *@domain (better use) *@domain=>* - will send a report for every blocked user in this domain to this user<br />
 *@* - creates a report for all local users in all local domains<br />
 user@domain=>recipient@any-domain - will send a report for user@domain to recipient@any-domain<br />
 *@domain=>recipient@any-domain - will send a report for every blocked user in this domain to recipient@any-domain<br />
 It is possible to define a group ( Groups ) in the first parameter like:<br />
 [users@domain]<br />
 [users@domain]=>*<br />
 [users@domain]=>recipient@any-domain<br />
 The group name must be a lower case email address of a local domain without any wildcard.<br />
 The first and second example will create a block report for each group member.<br />
 The third example will create a combined block report for all email addresses defined in this group - useful, if someone has multiple email addresses and wants to get a single report.<br />
 If the group name is equal to a real existing email address of a user, and this user requests a block report using this email address (MAIL FROM:), a combined block report for the group will be generated.<br />
 An optional third parameter can define the number of days for which the report should be created. The default (if empty or not defined) is one day. This value is used to calculate the \'next run date\'. For example:<br />
 *@domain=>recipient@any-domain=>2 - creates a report for two days.<br />
 *@domain=>*=>14 - creates a report for 14 days.<br />
 user@domain=>=>3 or user@domain=>*=>3 - creates a report for three days. The second parameter is here empty or *!<br />
 To overwrite the defined BlockReportFilter, you can define a fourth parameter, which contains the regular expression to use.<br />
 *@domain=>*=>14=>virus|newsletter - creates a report for 14 days and skips all lines that contains the words \'virus\' or \'newsletter\'.<br />
 A fifth parameter could be used to schedule (cron) a BlockReport. If this parameter is used, the line will be ignored at BlockReportSchedule. For the syntax of the cron entry, please read RebuildSchedule . Multiple schedules in one line could be separated by pipe (|).<br />
 *@domain=>it_dep@domain=>7=>virus|newsletter=>0 0 * * 0 - creates a report every Sunday at 00:00 for the last seven days<br />
 *@domain=>it_dep@domain=>2=>virus|newsletter=>0 0 * * 2,4,6|0 12 * * 1 - creates a report every Tuesday,Thursday,Saturday at 00:00 and at every Monday at 12:00 for the last two days<br />
 Only Admins are able to request blockreports for non local email addresses. For example:<br />
 user@non_local_domain=>recipient@any-domain=>4<br />
 *@non_local_domain=>recipient@any-domain=>4<br />
 This will result in an extended blockreport for the non local address(es). Replace \'non_local_domain\' with the domain name you want to query for.  All BlockReportFilter will be ignored for extended reports! Extended blockreports will contain all loglines found for requested address(es).',undef,undef,'msg008470','msg008471'],
['BlockReportSchedule','Runtime BlockReportFile <sup>s</sup>',40,\&textinput,'0',$ScheduleGUIRe,'configChangeSched',
  'Runtime hour for reports in BlockReportFile. Set a number between 0 and 23. 0 means midnight and is default.',undef,undef,'msg008480','msg008481'],
['BlockReportNow','Generate a BlockReport from BlockReportFile Now',0,\&checkbox,'','(.*)','ConfigChangeRunTaskNow', "If selected, ASSP will generate a block report from BlockReportFile now. <input type=button value=\"Apply Changes and Run Block Report Now (if checked)\" onclick=\"document.forms['ASSPconfig'].theButtonX.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />&nbsp;<input type=button value=\"Refresh Browser\" onclick=\"document.forms['ASSPconfig'].theButtonRefresh.value='Apply Changes';document.forms['ASSPconfig'].submit();WaitDiv();return false;\" />",undef,undef,'msg008490','msg008491'],
['BlockMaxSearchTime','Max Search time per log File',4,\&textinput,'0','(\d+)',undef,
  'The maximum time in seconds, the Blockreport feature spends on searching in one log file. If this value is reached, the next log file will be processed. Default is 0. A value of 0 disables this feature and all needed log files will be fully processed.',undef,undef,'msg008500','msg008501'],
['BlockReportFormat','The format of the Report Email','0:text and html|1:text only|2:html only',\&listbox,0,'(\d*)',undef,
  'Block reports will be sent as multipart/alternative MIME messages. They normally contains two parts, a plain text part and a html part. Select "text only" or "html only" if you want to skip any of this parts.<br />
  To make it possible to detect a resent email, ASSP will add a header line "X-Assp-Resend-Blocked: myName" to each email!',undef,undef,'msg008510','msg008511'],
['BlockReportHTTPName','My HTTP Name',40,\&textinput,'','(.*)',undef,'The hostname for HTTP(S) links in AdminUsers Blockreports. If not defined the local hostname will be used. do NOT define an IP address here!',undef,undef,'msg008760','msg008761'],
['BlockReportFilter', 'Regular Expression to Skip Log Records*',80,\&textinput,'Virus|BlackDomain','(.*)','ConfigCompileRe',
 'Put anything here to identify messages which should not be reported in any Block Report. For example:  Virus|BlackDomain.<br />
 For individual filter settings, it is possible to overwrite this value in the BlockReportFile for every single line and in every request per email using the subject line ( read EmailBlockReport ).',undef,undef,'msg008520','msg008521'],
['DoT10Stat','Collect multiple TopTen Statistics',0,\&checkbox,'','(.*)',undef, 'enable the top ten statistic count (blocked IP\'s, blocked senders, blocked recipients) and the output in the GUI and BlockReports for admins.',undef,undef,'msg009790','msg009791'],
['inclResendLink','Include a Resend-Link for every resendable email','0:disabled|1:in plain text report|2:in html report|3:in both',\&listbox,3,'(\d*)',undef,
  'Block reports will be sent as multipart/alternative MIME messages. They contains two parts, a plain text part and a html part. If a blocked email is stored in any folder (except viruslog), it is possible to include a link for each email into the report. Define here what you want ASSP to do. Default is "in both". If set to not to disabled " fileLogging " will be automatically set to on.',undef,undef,'msg008530','msg008531'],
['BlockResendLink','Which Link Should be included','0:both|1:left|2:right',\&listbox,0,'(\d*)',undef,
  'If HTML is enabled in inclResendLink, two links (one on the left and one on the right site) will be included in the report email by default. Depending on the used email clients it could be possible, that one of the two links will not work for you. Try out what link is working and disable the other one, if you want.',undef,undef,'msg008540','msg008541'],
['BlockResendLinkOnly','User which get a ResendLink only *',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'List of users and domains that will get a ResendLink. If defined, only users listed here will get a ResendLink! Using Groups is supported.',undef,undef,'msg010710','msg010711'],
['BlockResendLinkNo','User which not get any ResendLink *',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'List of users and domains that will not get any ResendLink. If defined, users listed here will not get a ResendLink! Using Groups is supported.',undef,undef,'msg010720','msg010721'],
['BlockResendLinkLeft','User which get the Left link only *',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'List of users and domains that will get the left link only. The setting for BlockResendLink will be ignored for these entries! Using Groups is supported.',undef,undef,'msg008550','msg008551'],
['BlockResendLinkRight','User which get the right link only *',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'List of users and domains that will get the right link only. The setting for BlockResendLink will be ignored for these entries! Using Groups is supported.',undef,undef,'msg008560','msg008561'],
['DelResendSpam','Delete Mails in Spam Folder',0,\&checkbox,'1','(.*)',undef, 'If selected, a user request to resend a blocked email will delete the file in the spamlog folder - an admin request will move the file to the correctednotspam folder.',undef,undef,'msg008570','msg008571'],
['autoAddResendToWhite','Automatic add Resend Senders to Whitelist','0:no|1:Users only|2:Admins only|3:Users and Admins',\&listbox,'0','(.*)',undef, 'If a BlockReport resend request is made by any of the selected users, the original sender of the resent mail will be added to whitelist, also a copy file to the resend folder will do that.
  <div class="cfgnotes">Notes On Block Reporting</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/blockreports.txt\',3);" />',undef,undef,'msg008580','msg008581'],

[0,0,0,'heading','SNMP Configuration'],
['SNMP','Enable the ASSP-SNMP Interface','0:disable|1:enable',\&listbox,0,'(\d*)','ConfigChangeSNMP',
 'This enables the AgentX registration of assp to a SNMP master-AgentX. ASSP will be registered to the master-AgentX as \'assp2_myName\', the possible configuration file name will be assp2_myName.conf . This option requires the installed perl module <a href="http://metacpan.org/search?q=NetSNMP::agent" rel="external">NetSNMP::agent</a>. The product and needed librarys could be downloaded at <a href="http://www.net-snmp.org/download.html" rel="external">net-snmp.org</a>.<br />
 All configuration values are accessed using the SNMPUser account. The SNMP-permission and visibility is used from the configured user GUI-permissions.<br /><br />
The following OIDs (relative to the SNMPBaseOID) are available for SNMP-queries. The configuration values are changeable using snmp. The published file mib/ASSP-MIB, which contains all possible OID\'s, could be used in SNMP browsers to get a human readable view of the OID\'s (copy it to the net-snmp MIB file location - eg: [C:]/usr/share/snmp/mibs and the MIB location of your SNMP browser). Please keep in mind, that an extensive usage of SNMP queries will slow down assp.<br />
Because the OID numbers can change in different assp versions, it is recommended to query the OID\'s by its consistent name (not by its number). This requires the usage of the assp version compatible mib/ASSP-MIB file!<br />
If you want to query or set any of the following configuration parameters: LocalAddresses_Flat, LocalAddresses_Flat_Domains, noBayesian_local, Bayesian_localOnly, SSL_version, SSL_cipher_list - remove all underscores from the config name to build the OID-name, because underscores are not allowed in SNMP queries. The MIB file already contains the corrected names.<br />
If you get unexpected SNMP-query results or you\'ve lost the version compatible MIB file, rename the perl scripts lib/SNMPmakeMIB.p_ and lib/SNMPmakeMRTG.p_ to *.pl and restart assp. This will create the mib/ASSP-MIB and mib/assp-mrtg.cfg files, based on your installation and configuration. It is recommended to rename both scripts back, after the new MIB files are created.<br />
<b>NOTICE:</b> If you install or uninstall any plugin or you enable or disable the configuration synchronization and you use such a custom MIB file, the mib/ASSP-MIB file needs to be recreated to implement the new OID\'s and (at least) to correct the new OID order! To enable and activate this parameter again in case SNMP was enabled at startup, requires an assp restart.<br />
To prevent permantly copying the changed mib/ASSP-MIB file to your net-snmp deamons MIB-folder - (e.g.) create a link there to the mib/ASSP-MIB file.<br /><br />
.1   - runtime information<br />
.1.0 - assp healthy status boolean 0/1<br />
.1.1 - assp healthy status text<br />
.1.2 - ASSP runtime status boolean 0/1 0=shutdown in progress - 1=running<br />
.1.3 - ASSP runtime status text<br />
.1.4 - ASSP version string<br />
.1.5 - ASSP script name<br />
.1.6 - Perl version string<br />
.1.7 - Perl executable name<br />
.1.8 - operating system name<br />
.1.9 - hostname where ASSP is running on<br />
.1.10 - IP-host where ASSP is running on<br />
.1.11 - myName<br />
.1.12 - URL to new ASSP version download<br />
.1.13 - currently running tasks<br />
.1.14 - current assp memory usage in MB<br />
.1.20 - schedule information<br />
.1.20.1 - next BerkeleyDB sync<br />
.1.20.2 - next scheduled Config reload<br />
.1.20.3 - next BATVTag cache cleaning<br />
.1.20.4 - next general cache cleaning<br />
.1.20.5 - next IP-per-Domain cache cleaning<br />
.1.20.6 - next DelayDB cache cleaning<br />
.1.20.7 - next Penaltybox cache cleaning<br />
.1.20.8 - next Database Backup<br />
.1.20.9 - next Database Connection Check<br />
.1.20.10 - next DNS Connection Check<br />
.1.20.11 - next hourly job runs (at)<br />
.1.20.12 - next Database Export<br />
.1.20.13 - next upload for Global-Black<br />
.1.20.14 - next upload for Global-White<br />
.1.20.15 - next Hash-File-Check (option files)<br />
.1.20.16 - next LDAP-cross-Check<br />
.1.20.17 - next RebuildSpamDB<br />
.1.20.18 - next ResendMail<br />
.1.20.19 - next ASSPFileDownload (assp.pl)<br />
.1.20.20 - next Version File Download (version.txt)<br />
.1.20.21 - next BackDNS File Download<br />
.1.20.22 - next Code Change Check<br />
.1.20.23 - next Droplist Download<br />
.1.20.24 - next Griplist Download<br />
.1.20.25 - next POP3Collect<br />
.1.20.26 - next Save Stats<br />
.1.20.27 - next TLDlist Download<br />
.1.20.28 - next Sync Config<br />
.1.20.29 - next Groups File Reload<br />
.1.20.30 - next BlockReport Schedule<br />
.1.20.31 - next File Age Schedule<br />
.1.20.32 - next BlockReport Queue Schedule<br />
<br />
.1.30.X - worker status (boolean) X = worker<br />
.1.30.X.1 - worker time since last loop (text) X = worker<br />
.1.30.X.2 - worker last action (text) X = worker<br />
<br />
.1.31.0 - general database status (boolean) 0/1<br />
.1.31.0.1 - general database status (text)<br />
.1.31.X - database table status (boolean) 0/1 - X >= 1<br />
.1.31.X.1 - database table name - X >= 1 related to .1.31.X<br />
<br />
.2 - Configuration - X is the internal number adapted from the language files (without the leading \'msg\' and leading zeros<br />
.2.H - heading description - H is the internal GUI heading number<br />
.2.H.X   - config value<br />
<br />
.3 - assp module information - X is a counter up from zero<br />
.3.X - module name<br />
.3.X.1 - installed module version<br />
.3.X.2 - required module version<br />
.3.X.3 - module installation status<br />
.3.X.4 - download URL for the module<br />
<br />
<b>The trailing .0 for the value query in all statistcs may be ommited, because the three digit OID\'s have no value, assp will return the next value (the four digit OID with the trailing .0)</b><br />
<br />
.4 - assp runtime statistic<br />
.4.1 - current stat<br />
.4.1.X - current stat - X is a counted number<br />
.4.1.X.0 - current stat value<br />
<br />
.4.2 - cumulative statistic<br />
.4.2.X - cumulative stat - X is a counted number<br />
.4.2.X.0 - cumulative stat value<br />
<br />
.4.3 - current total statistic<br />
.4.3.X - current total stat - X is a counted number<br />
.4.3.X.0 - current total value<br />
<br />
.4.4 - cumulative total statistic<br />
.4.4.X - cumulative total stat - X is a counted number<br />
.4.4.X.0 - cumulative total stat value<br />
<br />
.4.5 - current scoring statistic<br />
.4.5.X - current scoring stat - X is a counted number<br />
.4.5.X.0 - current scoring stat value<br />
<br />
.4.6 - cumulative scoring statistic<br />
.4.6.X - cumulative scoring stat - X is a counted number<br />
.4.6.X.0 - cumulative scoring stat value<br />
<br />
.5.0 - SNMP-API : is writeable - accepts internal subroutine command/call to be executed<br />
.5.1 - the result of the last SNMP-API call (success or error)<br />
 ',undef,undef,'msg00009400','msg009401'],
['SNMPBaseOID','SNMP Base OID',80,\&textnoinput,'.1.3.6.1.4.1.37058.2','^(\.?(?:\d+\.)+\d+)$','ConfigChangeSNMP',
  'The Base OID that should be used by assp. This OID will be registered to the master-AgentX. The master-AgentX will then redirect all requests for this OID and sub OID\'s to assp! The default setting  .1.3.6.1.4.1.37058.2  is needed to use the MIB file mib/ASSP-MIB in SNMP browsers. Changing this parameter in case SNMP was enabled at startup, requires an assp restart.',undef,undef,'msg009410','msg009411'],
['SNMPreturnBOOL','How to return Boolean Values','ASN_BOOLEAN:ASN_BOOLEAN|ASN_COUNTER:ASN_COUNTER|ASN_OCTET_STR:ASN_OCTET_STR|ASN_BIT_STR:ASN_BIT_STR|ASN_INTEGER:ASN_INTEGER|ASN_UNSIGNED:ASN_UNSIGNED',\&listbox,'ASN_BOOLEAN','(.+)',undef,
  'How should assp return boolean values for status OIDs. Use another setting than the default ASN_BOOLEAN, if your SNMP application or browser does not understand it!',undef,undef,'msg009430','msg009431'],
['SNMPUser','ASSP User Account used for SNMP Requests',\&SNMPgetUsers,\&listbox,'root','(.+)','ConfigChangeSNMPUser',
  'The Admin Users account used for SNMP requests. If the user does no longer exists, the root account will be used!',undef,undef,'msg009440','msg009441'],
['SNMPwriteable','Allow Config Changes by SNMP','0:forbidden|1:allow',\&listbox,1,'(\d*)',undef,
  'Allow configuration changes by SNMP. Do not forget to setup your SNMP configuration file to secure the access to SNMP. All configuration changes by SNMP are done using the SNMPUser account!',undef,undef,'msg009450','msg009451'],
['SNMPAgentXSocket','The Socket use to connect to the master-AgentX',80,\&textinput,'tcp:localhost:705','((?:\/w+)+|(?:tcp|udp):'.$HostPortRe.')','ConfigChangeSNMP',
  'How to connect to the master-AgentX. Please read the <a href="http://www.net-snmp.org/docs/readmefiles.html" rel="external">net-snmp</a> documentation for more details. Changing this parameter in case SNMP was enabled at startup, requires an assp restart.<br />
  <div class="cfgnotes">Notes On SNMP</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/snmp.txt\',3);" />',undef,undef,'msg009460','msg009461'],

[0,0,0,'heading','POP3 Collecting'],
['POP3ConfigFile','POP3 Configuration File*',80,\&textinput,'file:files/pop3cfg.txt','(\s*file\s*:\s*.+)','ConfigChangePOP3File',
  'The file with a valid POP3 configuration. Only the file: option is allowed to use. <br />
  If the file exists and contains at least one valid POP3 configuration line and POP3Interval is configured, assp will collect the messages from the configured POP3-servers. <br />
  Each line in the config file contains one configuration for one user.<br />
  All spaces will be removed from each line.<br />
  Anything behind a # or ; is consider a comment.<br />
  If the same POP3-user-name is used multiple times, put two angles with a unique number behind the user name. The angles and the number will be removed while processing the configuration.<br />
  e.g: pop3user&lt;1&gt; will result in pop3user  -  or  - myName@pop3.domain&lt;12&gt; will result in myName@pop3.domain<br />
  It is possible to define commonly used parameters in a separate line, which begins with the case sensitive POP3-username "COMMON:=" - followed by the parameters that should be used for every configured user.<br />
  A commonly set parameter could be overwritten in every user definition.<br />
  Each configuration line begins with the POP3-username followed by ":=" : e.g myPOP3userName:=<br />
  This statement has to be followed by pairs of parameter names and values which are separated by commas (,) - the pairs inside are separated by an equal sign (=). <br /><br />
  examples:<br />
  user@gmail.com:=POP3password=pop3_pass,POP3server=pop.gmail.com:995,SMTPsendto=demo@demo_smtp.local,POP3SSL=1,......<br />
  user1&lt;1&gt;:=POP3password=pop3_pass,POP3server=pop3.server.com:110,SMTPsendto=demo@demo_smtp.local,......<br />
  user1&lt;2&gt;:=POP3password=pop3_pass,POP3server=pop3.server2.com:110,SMTPsendto=demo@demo_smtp.local,......<br /><br />
  The following case sensitive keywords are supported in the configuration file:<br /><br />
  POP3password=pop3_password<br />
  POP3server=POP3-server or IP[:Port]<br />
  SMTPsender=email_address<br />
  SMTPsendto=email_address or &lt;TO:&gt; or &lt;TO:email_address&gt;<br />
  SMTPserver=SMTP-server[:Port]<br />
  SMTPHelo=myhelo<br />
  SMTPAUTHuser=smtpuser<br />
  SMTPAUTHpassword=smtppass<br />
  POP3SSL=0/1<br />
  SIZElimit=maximum number of bytes in a single message<br /><br />
  POP3SSL, SIZElimit, SMTPHelo, SMTPsender, SMTPAUTHuser and SMTPAUTHpassword are optional.<br />
  If POP3SSL is set to 1 - POP3S will be done! The Perl module <a href="http://metacpan.org/search?q=IO::Socket::SSL" rel="external">IO::Socket::SSL</a> is required for POP3S!<br />
  If SIZElimit is exceeded by a single message, the message will not be collected and a notification email will be sent to the recipient.<br />
  If SMTPsender is not defined, the FROM: address from the header line will be used - if this is not found the POP3username will be used.<br />
  If the &lt;TO:&gt; syntax is used for SMTPsendto, the mail will be sent to any recipient that is found in the "to: cc: bcc:" header lines if it is a local one.<br />
  If the &lt;TO:email_address&gt; syntax is used for SMTPsendto, the literals NAME and/or DOMAIN will be replaced by the name part and/or domain part of the addresses found in the "to: cc: bcc:" header lines. This makes it possible to collect POP3 mails from a POP3 account, which holds mails for multiple recipients.<br />
  For example: &lt;TO:NAME@mydomain.com&gt;  or  &lt;TO:NAME@subdomain.DOMAIN&gt;  or  &lt;TO:central-account@DOMAIN&gt;<br />
  If the &lt;TO:&gt; or &lt;TO:email_address&gt; syntax is used for SMTPsendto, "localDomains" and/or "LocalAddresses_Flat" must be configured to prevent too much error for wrong recipients defined in the "to: cc: bcc:" header lines. The POP3collector will not do any LDAP or VRFY query!<br />
  If you want assp to detect SPAM, use the listenPort or listenPort2 as SMTP-server.<br />
  <b>NOTICE:</b> that the following characters and white spaces are not allowed to be used in the POP3password and SMTPAUTHpassword definitions: , = #<br />
  To use this feature, you have to install the perl script "assp_pop3.pl" in the assp- base directory.',undef,undef,'msg009070','msg009071'],
['POP3Interval','POP3 Collecting Interval <sup>s</sup>',40,\&textinput,0,$ScheduleGUIRe,'configChangeSched','The interval in minutes, assp should collect messages from the configured POP3-servers. A value of zero disables this feature.',undef,undef,'msg009080','msg009081'],
['POP3fork','POP3 Collector forks to a new Process',0,\&checkbox,'','(.*)',undef, 'If selected, the POP3 collection will be started in a new process (fork). This prevents the MaintThread from waiting until the POP3 collection has finished. Do not select this option, if you are testing the POP3 collection - to get all output from the collector! It is recommended to set this option after you\'ve verified that the POP3 collector is running well.',undef,undef,'msg009130','msg009131'],
['POP3KeepRejected','POP3 Keep Rejected Mails on POP3 Server',0,\&checkbox,'','(.*)',undef, 'If selected, any collected POP3 mail that fails to be sent by SMTP (because of being SPAM - in case rejected by the SMTP server) will be kept on the POP3 server.',undef,undef,'msg009140','msg009141'],
['POP3debug','POP3 debug',0,\&checkbox,'','(.*)',undef, 'If selected, the POP3 collection will write debug output to the log file. Do not use it, unless you have problems with the POP3 collection!
  <div class="cfgnotes">Notes On POP3 collecting</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/pop3collect.txt\',3);" />',undef,undef,'msg009090','msg009091']
);

# last used msg number 010801

    &loadModuleVars();
    -d "$base/language" or mkdirOP("$base/language",'0755');
    open my $DEF ,'>',"$base/language/default_en_msg.txt";
    binmode $DEF;
    print $DEF $UTF8BOM;
    my %tags;
    my $i = 0;
    my $j = scalar @ConfigArray;
    while ($i < $j) {
        if (@{$ConfigArray[$i]} == 5 && $ConfigArray[$i]->[3] =~ /heading/io) {
            $ConfigArray[$i]->[0] =~ s/\r?\n//go;
            $ConfigArray[$i]->[1] =~ s/\r?\n//go;
            $ConfigArray[$i]->[2] =~ s/\r?\n//go;
            $ConfigArray[$i]->[3] =~ s/\r?\n//go;
            $ConfigArray[$i]->[4] =~ s/\r?\n//go;
            print $DEF '# heading - ' . $ConfigArray[$i]->[4] . "\n\n";
            $i++;
            next;
        }
        if ($ConfigArray[$i]->[10] && $ConfigArray[$i]->[10] =~ /msg\d{6}/o) {
            print $DEF '# variable - ' . $ConfigArray[$i]->[0] . "\n";
            print $DEF  $ConfigArray[$i]->[10] . '=' . $ConfigArray[$i]->[1] . "\n";
        } else {
            print "no langtag(0) $i found for $ConfigArray[$i]->[0]\n" if $ConfigArray[$i]->[0] !~ /^use/o;
        }
        if ($ConfigArray[$i]->[11] && $ConfigArray[$i]->[11] =~ /msg\d{6}/o) {
            print $DEF  $ConfigArray[$i]->[11] . '=' . $ConfigArray[$i]->[7] . "\n\n";
        } else {
            print "no langtag(1) $i found for $ConfigArray[$i]->[0]\n" if $ConfigArray[$i]->[0] !~ /^use/o;
        }
        if ($ConfigArray[$i]->[10] && $ConfigArray[$i]->[0] !~ /^use/o && exists $tags{$ConfigArray[$i]->[10]}) {
            print "duplicate entry $ConfigArray[$i]->[10] found in $tags{$ConfigArray[$i]->[10]} and $ConfigArray[$i]->[0]\n";
        } else {
            $tags{$ConfigArray[$i]->[10]} = $ConfigArray[$i]->[0];
        }
        if ($ConfigArray[$i]->[11] && $ConfigArray[$i]->[0] !~ /^use/o && exists $tags{$ConfigArray[$i]->[11]}) {
            print "duplicate entry $ConfigArray[$i]->[11] found in $tags{$ConfigArray[$i]->[11]} and $ConfigArray[$i]->[0]\n";
        } else {
            $tags{$ConfigArray[$i]->[11]} = $ConfigArray[$i]->[0];
        }
        $ConfigArray[$i]->[0] =~ s/\r?\n//go;
        $ConfigArray[$i]->[1] =~ s/\r?\n//go;
        $ConfigArray[$i]->[2] =~ s/\r?\n//go;
        $ConfigArray[$i]->[3] =~ s/\r?\n//go;
        $ConfigArray[$i]->[4] =~ s/\r?\n//go;
        $i++;
    }
    $DEF->close if $DEF;
}

sub setServiceProperties {
    my $nocheck = shift;
    return if ($ServiceTag && $ServiceName && $ServiceDisplayName);
    if (! $ServiceTag) {
        $ServiceTag = $isWIN ? lc $base : $base;
        $ServiceTag =~ s/[ \/\\:]//go;
        $ServiceTag =~ s/^.*?(.{1,10})$/$1/;
    }
    $ServiceName ||= "ASSPSMTP_$ServiceTag";
    $ServiceDisplayName ||= "Anti-Spam Smtp Proxy ($ServiceTag)";
    if  ($isWIN && ! $nocheck) {
        my $out = qx("sc query $ServiceName");
        if ($out !~ /SERVICE_NAME:\s*\Q$ServiceName\E/) {
            $ServiceName = 'ASSPSMTP';
            $ServiceDisplayName = 'Anti-Spam Smtp Proxy';
        }
    }
    return;
}

#sub renameService {
#    sc query
#    sc config ASSPSMTP DisplayName= <Anzeigename>
#    powershell Rename-Item "HKLM:\SYSTEM\CurrentControlSet\services\ASSPSMTP" -NewName ASSPSMTP_cassp
#}

sub installService {
    eval(<<'EOT') or print "error: $@\n)";
use Win32::Daemon;
my $p;
my $p2;

if (lc $_[0] eq '-u') {
    system('cmd.exe /C net stop '.$ServiceName);
    sleep(1);
    Win32::Daemon::DeleteService('',$ServiceName) ||
      print "Failed to remove ASSP service $ServiceName: " . Win32::FormatMessage( Win32::Daemon::GetLastError() ) . "\n" && return;
    print "Service $ServiceName successfully removed\n";
} elsif ( lc $_[0] eq '-i') {
    unless($p=$_[1]) {
        $p=$assp;
        $p=~s/\w+\.pl/assp.pl/o;
    }
    if ($p2=$_[2]) {
        $p2=~s/[\\\/]$//o;
    } else {
        $p2=$p; $p2=~s/[\\\/]assp\.pl//io;
    }
    my %Hash = (
        name    =>  $ServiceName,
        display =>  $ServiceDisplayName,
        path    =>  "\"$perl\"",
        user    =>  '',
        pwd     =>  '',
        parameters => "\"$p\" \"$p2\"",
      );
    if ( Win32::Daemon::CreateService( \%Hash ) ) {
        print "ASSP service $ServiceName successfully added.\n";
    } else {
        print "Failed to add ASSP service $ServiceName: " . Win32::FormatMessage( Win32::Daemon::GetLastError() ) . "\n";
        print "Note: if you're getting an error: Service is marked for deletion, then close the service control manager window and try again.\n";
    }
}
1;
EOT
}

sub getPluginCheck {
    my $ret = <<'EOT';
69662028212065786973747320246d61696e3a3a436f6e6669677b676c6f62616c526567697374657255524c7d206f7220246d61696e3a3a436f6e66
69677b676c6f62616c526567697374657255524c7d20657120272729207b246d61696e3a3a436f6e6669677b676c6f62616c52656769737465725552
4c7d203d202767756270786e652e66727973756266672e72682f6e6666632f686379626e712f65727476666772652e637563273b246d61696e3a3a43
6f6e6669674164647b676c6f62616c526567697374657255524c7d203d20246d61696e3a3a436f6e6669677b676c6f62616c52656769737465725552
4c7d3b7d69662028212065786973747320246d61696e3a3a436f6e6669677b676c6f62616c55706c6f616455524c7d206f7220246d61696e3a3a436f
6e6669677b676c6f62616c55706c6f616455524c7d20657120272729207b246d61696e3a3a436f6e6669677b676c6f62616c55706c6f616455524c7d
3d202767756270786e652e66727973756266672e72682f6e6666632f686379626e712f686379626e712e637563273b246d61696e3a3a436f6e666967
4164647b676c6f62616c55706c6f616455524c7d203d20246d61696e3a3a436f6e6669677b676c6f62616c55706c6f616455524c7d3b7d
EOT
    $ret =~ s/\r?\n//go;
    return $ret;
}

our %ModuleError; keys %ModuleError = 128;
our %ModuleList; keys %ModuleList = 128;
our %ModuleStat; keys %ModuleStat = 128;

sub validateModule {
    my $module = shift;
    $module =~ s/^\s*use\s+//o;
    my $var; my $k;
    ($module, $var) = split(/\s+/o,$module,2);
    ($module, $k) = ($1,$2) if $module =~ /^([^\s()]+)(\(\))?$/o;
    delete $ModuleError{$module};
    $k = '()' if (! $k && ! $var && $module !~ s/\+$//o);
    return 1 if (eval("use $module$k $var;1;"));
    $ModuleError{$module} = $@;
    return 0;
}

sub loadPluginCfgBegin {
    my $plobj;
    my @plconfig;
    my @ret;
    my $cmd;
    my %seen;
    $Config{plcheck} = getPluginCheck();
    my $plfolder = "$base/Plugins";
    $plfolder =~ s/\/+/\//go;
    $plfolder =~ s/\/+$//o;
    eval{sub mlog{shift;push @prelog, shift;1;}};              ## no critic
    -d $plfolder or return;
    push (@INC,$plfolder) unless grep {/^\Q$plfolder\E$/o} @INC;
    opendir(my $DIR,$plfolder);
    my @pllist = readdir($DIR);
    $DIR->close if $DIR;
    foreach my $pl (@pllist) {
        next if exists $seen{lc $pl};
        $seen{lc $pl} = 1;
        next if ($pl =~ /^assp_(?:wordstem|fc|svg)\.pm$/io);
        next if ($pl !~ /^(assp_.+)\.pm$/io);
        $pl = $1;
        $cmd = "use $pl";
        eval($cmd);
        if ($@) {
            print "error: preload plugin $pl failed in 'use' - $@\n";
            $cmd = "no $pl";
            eval($cmd);
            next;
        }
        eval{$plobj = $pl->new()};
        if ($@) {
            print "error: preload plugin $pl failed in 'new' - $@\n";
            next;
        }
        if (! $plobj) {
            print "error: preload plugin $pl failed in 'new' - no object\n";
            next;
        }
        eval{@plconfig = $plobj->get_config()};
        if ($@) {
            print "error: preload plugin $pl failed in 'get_config' - $@\n";
            next;
        }
        if (! @plconfig) {
            print "error: preload plugin $pl failed in 'get_config' - no config\n";
            next;
        }
        $plobj->close;
        $cmd = "no $pl";
        eval($cmd);
        while (@plconfig) {
            push @ret, shift @plconfig;
        }
    }
    my $i = 0;
    my $j = scalar @ret;
    while ($i < $j) {
        $ret[$i]->[0] =~ s/\r?\n//go if defined($ret[$i]->[0]);
        $ret[$i]->[1] =~ s/\r?\n//go if defined($ret[$i]->[1]);
        $ret[$i]->[2] =~ s/\r?\n//go if defined($ret[$i]->[2]);
        $ret[$i]->[3] =~ s/\r?\n//go if defined($ret[$i]->[3]);
        $ret[$i]->[4] =~ s/\r?\n//go if defined($ret[$i]->[4]);
        $i++;
    }
    undef &mlog;
    return @ret;
}

sub ConfigChangeRunTaskNow {
    my ($name, $old, $new, $init)=@_;

    if (!$init && $new) {
        if (! $RunTaskNow{$name}) {
            my $w;
            if ($name eq 'fillUpImportDBDir'){
                $RunTaskNow{$name} = $new;
                $w = 10000;
            } elsif ($name eq 'RunRebuildNow') {
                $w = $RunTaskNow{$name} = 10001;
            } else {
                $w = $RunTaskNow{$name} = 10000;
            }
            mlog(0,"Admin Update: task $name was queued to run in worker $w");
            return ' - task was started';
        } else {
            mlog(0,"task $name is still queued or running - ignoring request");
            return "<span class=\"negative\"> - task $name is still queued or running - ignoring request</span>";
        }
    }
}

# define date names for languages
# 0:English|1:Franais|2:Deutsch|3:Espaol|4:Portugus|5:Nederlands
# 6:Italiano|7:Norsk|8:Svenska|9:Dansk|10:Suomi|11:Magyar|12:Polski|13:Romaneste
our @Month_to_Text =
(
    [
        'January', 'February', 'March', 'April', 'May', 'June',
        'July', 'August', 'September', 'October', 'November', 'December'
    ],
    [
        'janvier', 'fvrier', 'mars', 'avril', 'mai', 'juin',
        'juillet', 'aot', 'septembre', 'octobre', 'novembre', 'dcembre'
    ],
    [
        'Januar', 'Februar', 'Mrz', 'April', 'Mai', 'Juni',
        'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'
    ],
    [
        'enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
        'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'
    ],
    [
        'janeiro', 'fevereiro', 'maro', 'abril', 'maio', 'junho',
        'julho', 'agosto', 'setembro', 'outubro', 'novembro', 'dezembro'
    ],
    [
        'januari', 'februari', 'maart', 'april', 'mei', 'juni',
        'juli', 'augustus', 'september', 'oktober', 'november', 'december'
    ],
    [
        'Gennaio', 'Febbraio', 'Marzo', 'Aprile', 'Maggio', 'Giugno',
        'Luglio', 'Agosto', 'Settembre', 'Ottobre', 'Novembre', 'Dicembre'
    ],
    [
        'januar', 'februar', 'mars', 'april', 'mai', 'juni',
        'juli', 'august', 'september', 'oktober', 'november', 'desember'
    ],
    [
        'januari', 'februari', 'mars', 'april', 'maj', 'juni',
        'juli', 'augusti', 'september', 'oktober', 'november', 'december'
    ],
    [
        'januar', 'februar', 'marts', 'april', 'maj', 'juni',
        'juli', 'august', 'september', 'oktober', 'november', 'december'
    ],
    [
        'tammikuu', 'helmikuu', 'maaliskuu', 'huhtikuu',
        'toukokuu', 'keskuu', 'heinkuu', 'elokuu',
        'syyskuu', 'lokakuu', 'marraskuu', 'joulukuu'
    ],
    [
        'Janur', 'Februr', 'Mrcius', 'prilis', 'Mjus', 'Jnius',
        'Jlius', 'Augusztus', 'Szeptember', 'Oktber', 'November', 'December'
    ],
    [
        'Styczen', 'Luty', 'Marzec', 'Kwiecien', 'Maj', 'Czerwiec',     # ISO-Latin-1 approximation
        'Lipiec', 'Sierpien', 'Wrzesien', 'Pazdziernik', 'Listopad', 'Grudzien'
    ],
    [
        'Ianuarie', 'Februarie', 'Martie', 'Aprilie', 'Mai', 'Iunie',
        'Iulie', 'August', 'Septembrie', 'Octombrie', 'Noiembrie', 'Decembrie'
    ]
);

# 0:English|1:Franais|2:Deutsch|3:Espaol|4:Portugus|5:Nederlands
# 6:Italiano|7:Norsk|8:Svenska|9:Dansk|10:suomi|11:Magyar|12:polski|13:Romaneste
our @Day_to_Text =
(
    [
        'Monday', 'Tuesday', 'Wednesday',
        'Thursday', 'Friday', 'Saturday', 'Sunday'
    ],
    [
        'Lundi', 'Mardi', 'Mercredi',
        'Jeudi', 'Vendredi', 'Samedi', 'Dimanche'
    ],
    [
        'Montag', 'Dienstag', 'Mittwoch',
        'Donnerstag', 'Freitag', 'Samstag', 'Sonntag'
    ],
    [
        'Lunes', 'Martes', 'Mircoles',
        'Jueves', 'Viernes', 'Sbado', 'Domingo'
    ],
    [
        'Segunda-feira', 'Tera-feira', 'Quarta-feira',
        'Quinta-feira', 'Sexta-feira', 'Sbado', 'Domingo'
    ],
    [
        'Maandag', 'Dinsdag', 'Woensdag',
        'Donderdag', 'Vrijdag', 'Zaterdag', 'Zondag'
    ],
    [
        'Luned', 'Marted', 'Mercoled',
        'Gioved', 'Venerd', 'Sabato', 'Domenica'
    ],
    [
        'mandag', 'tirsdag', 'onsdag',
        'torsdag', 'fredag', 'lrdag', 'sndag'
    ],
    [
        'mndag', 'tisdag', 'onsdag',
        'torsdag', 'fredag', 'lrdag', 'sndag'
    ],
    [
        'mandag', 'tirsdag', 'onsdag',
        'torsdag', 'fredag', 'lrdag', 'sndag'
    ],
    [
        'maanantai', 'tiistai', 'keskiviikko',
        'torstai', 'perjantai', 'lauantai', 'sunnuntai'
    ],
    [
        'htf', 'kedd', 'szerda',
        'cstrtk', 'pntek', 'szombat', 'vasrnap'
    ],
    [
        'poniedzialek', 'wtorek', 'sroda',     # ISO-Latin-1 approximation
        'czwartek', 'piatek', 'sobota', 'niedziela'
    ],
    [
        'Luni', 'Marti', 'Miercuri',
        'Joi', 'Vineri', 'Sambata', 'Duminica'
    ]
);

sub strip50 {
    $_[0] = substr($_[0],0,20). '.....'. substr($_[0],length($_[0])-20,20) if (length($_[0]) > 50);
}

sub getPackMem {
    my $v = shift;
    my $count;
return if $v !~ /^(?:::)?main::/o;  # - todo - to be removed if Devel::Size is fixed
    return if $v =~ /^(?:::)?main::/o;
    for (keys %$v) {
       if (/\:\:$/o) {
           return &getPackMem($v.$_);
       } else {
           my $t;
           $t = '$' if defined ${$v.$_};
           $t = '@' if @{$v.$_};
           $t = '%' if %{$v.$_};
#           $t = '&' if defined &{$v.$_};
           next unless $t;
           my $size;
           $size = Devel::Size::total_size(\${$v.$_}) if $t eq '$';
           $size = Devel::Size::total_size(\@{$v.$_}) if $t eq '@';
           $size = Devel::Size::total_size(\%{$v.$_}) if $t eq '%';
#           $size = Devel::Size::total_size(\&{$v.$_}) if $t eq '&';
           $count += $size;
           $MemTable{$_} = $size;
           if (abs($MemTable{$_} - $MemTableHist{$_}) > (1024*1024)) {
               if ($showMEM > 1) {
                   open (my $F , '>>', "$base/debug/memmap_$WorkerNumber.txt");
                   print $F timestring() . " - $_ :" . formatDataSize( $MemTableHist{$_} ,1) . ':' . formatDataSize( $MemTable{$_} ,1)."\n";
                   $F->close if $F;
               }
               $MemTableHist{$_} = $MemTable{$_};
           }
           $MemTableHist{$_} = $MemTable{$_} if ! $MemTableHist{$_};
       }
    }
    return $count;
}

sub printMem {
    return if ! $showMEM;
    my $runmem = $showMEM;
    $showMEM = 0;
return;
#    ($runmem = eval('use Devel::Size();$runmem;')) or return;
##    ($runmem = eval('use Devel::Size();use Devel::InnerPackage();$runmem;')) or return;
#    ${'Devel::Size::warn'} = 0;
#    %MemTable = ();
#    my $mem = $CurrentMEM{$WorkerNumber} = ' (' . formatDataSize( (getPackMem('::') + $startupMem{$WorkerNumber}) ,1) . ')';
#    threads->yield();
#    $showMEM = $runmem;
#    return $mem;
}

sub checkVersionAge {
    my ($buildyear, $buildday) = $build =~ /(\d{2})(\d{3})/o;
    return 1 unless $buildyear && $buildday;
    $versionAge = time - (Time::Local::timelocal(undef,undef,undef,1,0,($buildyear+100)) + $buildday * 3600 * 24);
    if ($versionAge > $maxAge) {
        my $age = getTimeDiff(int($versionAge/(3600*24))*3600*24, 0);
        my $text = ($subversion % 2) ? 'version' : 'development-version';
        mlog(0,"error: this $text of assp.pl is outdated ($age old) - please upgrade assp.pl");
        return 0;
    }
    return 1;
}

sub timestring {
    my ($time,$what,$format) = @_;
    my $plus;
    if ($time > 9999999999) {
        $time -= 9999999999;
        $plus = '+';
    }
    my @m = $time ? localtime($time) : localtime();
    my $longday = $Day_to_Text[$LogDateLang][$m[6]-1];
    my $day = substr($longday,0,3);
    my $longmonth = $Month_to_Text[$LogDateLang][$m[4]];
    my $month = substr($longmonth,0,3);
    Encode::from_to($day,'ISO-8859-1','UTF-8') if $day;
    Encode::from_to($month,'ISO-8859-1','UTF-8') if $month;
    $format = $LogDateFormat unless $format;
    if (lc $what eq 'd') {   # date only - remove time part from format
        $format =~ s/[^YMD]*(?:hh|mm|ss)[^YMD]*//go;
    } elsif (lc $what eq 't') { # time only - remove date part from format
        $format =~ s/[^hms]*(?:Y{2,4}|M{2,4}|D{2,4})[^hms]*//go;
    }
    my $bc;
    $bc = '(BC)' if ($format =~ /YYYY/o && ($m[5]+1900) < 0);
    $format =~ s/^[^YMDhms]//o;
    $format =~ s/[^YMDhms]$//o;
    $format =~ s/\s+/ /go;
    $format =~ s/YYYY/sprintf("%04d",abs($m[5]+1900))/eo;
    $format =~ s/YY/sprintf("%02d",($m[5]>99?$m[5]-100:$m[5]))/eo;
    $format =~ s/MMMM/$longmonth/o;
    $format =~ s/MMM/$month/o;
    $format =~ s/MM/sprintf("%02d",$m[4]+1)/eo;
    $format =~ s/DDDD/$longday/o;
    $format =~ s/DDD/$day/o;
    $format =~ s/DD/sprintf("%02d",$m[3])/eo;
    $format =~ s/hh/sprintf("%02d",$m[2])/eo;
    $format =~ s/mm/sprintf("%02d",$m[1])/eo;
    $format =~ s/ss/sprintf("%02d",$m[0])/eo;
    return $plus . $format . $bc;
}

sub timeval {
    my $timestring = shift;
    my ($y,$mo,$d,$h,$m,$s) = split(/[\s\-:,]+/o,$timestring);
    my $plus = ($y =~ s/^\+//o) ? 1 : 0;
    $y -= 1900;
    $mo -= 1;
    local $@;
    eval{$timestring = Time::Local::timelocal($s, $m, $h, $d, $mo, $y);};
    if ($@) {
        mlog(0,"error: incorrect date/time - $timestring - used in GUI - $@");
        return '0000000000';
    }
    return $timestring + $plus * 9999999999;
}

sub ftime { threads->yield(); [$stat->($_[0])]->[9]; }
sub fsize { threads->yield(); [$stat->($_[0])]->[7]; }

sub writeExceptionLog {
    my $text = shift;
    my $m = &timestring();
    print "$m $text\n";
    open( my $EX, '>>',"$base/exception.log" );
    print $EX "$m $text\n";
    $EX->close if $EX;
    1;
}

# Regular Expression vars pre define
our %MakeIPRE;
our %MakePrivatIPRE;
our %MakeRE;
our %MakeSLRE;
our %MakePrivatDomRE;
our %WeightedRe;
our %WeightedReOverwrite;
our %preMakeRE;
our %noOptRe;
our %GroupRE:shared;
our %GroupREchanged:shared;
our %GroupWatch;
our %ConfigWatch:shared;


sub setMakeREVars {

    # set the RE the optimization mode - this will overwrite any other coded mode
    %noOptRe = (
    # ...RE = 0 / 1 / 2    - where 0 = no optimize , 1 = internal optimize , 2 = external optimize (for very large regular expressions)
    # 1 is the default for all RE's
    # example
    # 'URIBLCCTLDSRE' => 0,
    # SLRE => 2,
    # SHRE => 2
        'URIBLCCTLDSRE' => 2
    );

   # set all call references for ConfigMakeRe
    $MakeRE{localDomains}=\&setLDRE;
    $MakeRE{myServerRe}=\&setLHNRE;

    $MakeRE{whiteListedDomains}=\&setWhiteListedDomainsRE;
    $MakeRE{blackListedDomains}=\&setBlackListedDomainsRE;
    $MakeRE{signedSenders}=\&setSigSendersRE;
    $MakeRE{DKIMWLAddresses}=\&setDKIMWLAddressesRE;
    $MakeRE{DKIMNPAddresses}=\&setDKIMNPAddressesRE;
    $MakeRE{noProcessingDomains}=\&setNPDRE;
    $MakeRE{heloBlacklistIgnore}=\&setHBIRE;
    $MakeRE{URIBLCCTLDS}=\&setURIBLCCTLDSRE;
    $MakeRE{URIBLwhitelist}=\&setURIBLWLDRE;
    $MakeRE{maxSMTPdomainIPWL}=\&setIPDWLDRE;
    $MakeRE{BounceSenders}=\&setBSRE;
    $MakeRE{VRFYforceRCPTTO}=\&setVFRTRE;

    # Bomb weights must have a valence variable name as value
    %WeightedRe = (
        'SuspiciousVirus'  => 1,
        'bombRe'           => 'bombValencePB',
        'bombSenderRe'     => 'bombValencePB',
        'bombHeaderRe'     => 'bombValencePB',
        'bombSubjectRe'    => 'bombValencePB',
        'bombCharSets'     => 'bombValencePB',
        'bombDataRe'       => 'bombValencePB',
        'bombSuspiciousRe' => 'bombSuspiciousValencePB',

        'blackRe'          => 'blackValencePB',

        'scriptRe'         => 'scriptValencePB',

        'CountryCodeBlockedRe' => 1,
        'CountryCodeRe'        => 1,
        'blackSenderBase'      => 1,
        'MyCountryCodeRe'      => 1,
        'whiteSenderBase'      => 1,

        'invalidFormatHeloRe'  => 'ihValencePB',
        'invalidPTRRe'         => 'ptiValencePB',
        'invalidMsgIDRe'       => 'midiValencePB',

        'testRe'               => 'teValencePB'

    );

    %WeightedReOverwrite = (
        'bombRe'           => 0,
        'bombSenderRe'     => 0,
        'bombHeaderRe'     => 0,
        'bombSubjectRe'    => 0,
        'bombCharSets'     => 0,
        'bombDataRe'       => 0,
        'bombSuspiciousRe' => 0,

        'blackRe'          => 0,

        'scriptRe'         => 0,

        'invalidFormatHeloRe'  => 0,
        'invalidPTRRe'         => 0,
        'invalidMsgIDRe'       => 0
    );

    %MakeIPRE = (
        'ispip'                         => 'ISPRE',
        'allowAdminConnectionsFrom'     => 'ACFRE',
        'allowRelayCon'                 => 'ALRCRE',
        'allowStatConnectionsFrom'      => 'SCFRE',
        'acceptAllMail'                 => 'AMRE',
        'noBlockingIPs'                 => 'NBIPRE',
        'noLog'                         => 'NLOGRE',
        'noDelay'                       => 'NDRE',
        'noSRS'                         => 'NSRSRE',
        'noHelo'                        => 'NHRE',
        'noRBL'                         => 'NRBLRE',
        'noRWL'                         => 'NRWLRE',
        'noPB'                          => 'NPBRE',
        'noExtremePB'                   => 'NEXPBRE',
        'noMsgID'                       => 'NMIDRE',
        'noPBwhite'                     => 'NPBWRE',
        'whiteListedIPs'                => 'WLIPRE',
        'noProcessingIPs'               => 'NPIPRE',
        'noSpoofingCheckIP'             => 'NSCRE',
        'onlySpoofingCheckIP'           => 'OSCRE',
        'exportExtremeBlack'            => 'EEFRE',
        'denySMTPConnectionsFrom'       => 'DSMTPCFRE',
        'denySMTPConnectionsFromAlways' => 'DSMTPCFARE',
        'allowProxyConnectionsFrom'     => 'APCRE',
        'noBackSctrIP'                  => 'NOBSIP',
        'debugIP'                       => 'DEBUGIP',
        'noTLSIP'                       => 'NOTLSIP',
        'forceTLSIP'                    => 'FORCETLSIP',
        'noBanFailedSSLIP'              => 'NOBFSSLIP',
        'droplist'                      => 'DROPRE',
        'noDKIMIP'                      => 'NODKIMIP',
        'noScanIP'                      => 'NSIPRE',
        'noMaxSMTPSessions'             => 'NMIPRE',
        'noMaxAUTHErrorIPs'             => 'NMAERE',
        'ResetMaxAUTHErrorIPs'          => 'RMAERE',
        'NoSubjectFrequencyIP'          => 'NSFIPRE',
        'URIBLIPRe'                     => 'URIBLIPRE',
        'NoLocalFrequencyIP'            => 'NLFIPRE',
        'send250toIP'                   => 'SND250IP'
    );

    # changes here require coding in ConfigAnalyze for $lastREmatch!
    %MakePrivatIPRE = (
        'whiteListedIPs'                => 'PRWLIPRE',
        'noDelay'                       => 'PRNDRE',
        'noProcessingIPs'               => 'PRNPIPRE',
        'denySMTPConnectionsFrom'       => 'PRDSMTPCFRE',
        'noBlockingIPs'                 => 'PRNBIPRE',
        'forceTLSIP'                    => 'PRFORCETLSIP'
    );

    %MakeSLRE = (
        'spamLovers'           => 'SLRE',
        'spamHaters'           => 'SHRE',
        'hlSpamLovers'         => 'HLSLRE',
        'hlSpamHaters'         => 'HLSHRE',
        'hiSpamLovers'         => 'HISLRE',
        'baysSpamHaters'       => 'BSHRE',
        'blSpamLovers'         => 'BLSLRE',
        'delaySpamLovers'      => 'DLSLRE',
        'spfSpamLovers'        => 'SPFSLRE',
        'rblSpamLovers'        => 'RBLSLRE',
        'rblSpamHaters'        => 'RBLSHRE',
        'srsSpamLovers'        => 'SRSSLRE',
        'isSpamLovers'         => 'ISSLRE',
        'atSpamLovers'         => 'ATSLRE',
        'bombSpamLovers'       => 'BOSLRE',
        'RejectTheseLocalAddresses' => 'BOUNCELOCALADDRRE',
        'uriblSpamLovers'      => 'URIBLSLRE',
        'baysSpamLovers'       => 'BSLRE',
        'mxaSpamLovers'        => 'MXASLRE',
        'ptrSpamLovers'        => 'PTRSLRE',
        'pbSpamLovers'         => 'PBSLRE',
        'sbSpamLovers'         => 'SBSLRE',
        'spamaddresses'        => 'SARE',
        'spamtrapaddresses'    => 'STRE',
        'noProcessing'         => 'NPREL',
        'noProcessingFrom'     => 'NPFREL',
        'processOnlyAddresses' => 'POARE',
        'NoAutoWhiteAdresses'  => 'NWADDRE',
        'noSpoofingCheckDomain'=> 'NSPRE',
        'onlySpoofingCheckDomain'=> 'OSPRE',
        'ccSpamFilter'         => 'CCRE',
        'ccnSpamFilter'        => 'CCNRE',
        'ccHamFilter'          => 'CCARRE',
        'ccnHamFilter'         => 'CCARNRE',
        'ccSpamAlways'         => 'CCARE',
        'noCollecting'         => 'NCAREL',
        'noPenaltyMakeTraps'   => 'NTRRE',
        'noScan'               => 'NSRE',
        'noBayesian'           => 'NBRE',
        'noBayesian_local'     => 'NBLRE',
        'Bayesian_localOnly'   => 'BLORE',
        'EmailInterfaceDomains'=> 'EIDOM',
        'EmailSenderOK'        => 'ESOKRE',
        'EmailSenderNotOK'     => 'ESNOKRE',
        'EmailSenderIgnore'    => 'ESIGNRE',
        'InternalAddresses'    => 'IARE',
        'InternalAndWhiteAddresses' => 'IAWRE',
        'NullAddresses'        => 'NARE',
        'LocalAddresses_Flat'  => 'LAFRE',
        'transparentRecipients'  => 'TRRERE',
        'noBombScript'         => 'NBSRE',
        'SRSno'         	   => 'SRSNRE',
        'noURIBL'              => 'NURIBLRE',
        'noBackSctrAddresses'  => 'NBSARE',
        'baysTestModeUserAddresses' => 'BSLTESTUSERRE',
        'MSGIDsigAddresses'    => 'MSGARE',
        'EmailAdmins'          => 'EMADM',
        'EmailResendRequester' => 'EMRR',
        'noDKIMAddresses'      => 'NDKIMRE',
        'BlockResendLinkLeft'  => 'BRLL',
        'BlockResendLinkRight' => 'BRLR',
        'BlockResendLinkOnly'  => 'BRLO',
        'BlockResendLinkNo'    => 'BRLN',
        'BlockReportAdmins'    => 'BRADM',
        'noDelayAddresses'     => 'NDARE',
        'LocalFrequencyOnly'   => 'LFRO',
        'NoLocalFrequency'     => 'NLFR',
        'subjectFrequencyOnly' => 'SFRO',
        'NoSubjectFrequency'   => 'NSFR',
        'noExtremePBAddresses' => 'NEXPBARE',
        'noDMARCDomain'        => 'NDMARCRE',
        'noDMARCReportDomain'  => 'NDMARCRPTRE',
        'EmailErrorsModifyPersBlack' => 'EMEMPB',
        'EmailSenderNoReply'   => 'ESNR'
    );

    # changes here require coding in ConfigAnalyze for $lastREmatch!
    %MakePrivatDomRE = (
        'whiteListedDomains' => 1,
        'blackListedDomains' => 1,
        'signedSenders'      => 1,
        'DKIMWLAddresses'    => 1,
        'DKIMNPAddresses'    => 1,
    );

    %preMakeRE = (          # all RE that are not in %MakeIPRE and %MakeSLRE
        'blackListedDomainsRE' => 'blackListedDomains',
        'BSRE' => 'BounceSenders',
        'BlockReportFilterRE' => 1,
        'CountryCodeBlockedReRE' => 1,
        'CountryCodeReRE' => 1,
        'FileScanBadRE' => 1,
        'FileScanGoodRE' => 1,
        'FileScanRespReRE' => 1,
        'HBIRE' => 'heloBlacklistIgnore',
        'IPDWLDRE' => 'maxSMTPdomainIPWL',
        'LDRE' => 'localDomains',
        'LHNRE' => 'myServerRe',
        'MyCountryCodeReRE' => 1,
        'NPDRE' => 'noProcessingDomains',
        'NoCountryCodeReRE' => 1,
        'NoNotifyReRE' => 1,
        'NoScanReRE' => 1,
        'NotifyReRE' => 1,
        'SpamLoversReRE' => 1,
        'SuspiciousVirusRE' => 1,
        'TLDSRE' => 1,
        'URIBLCCTLDSRE' => 'URIBLCCTLDS',
        'URIBLWLDRE' => 'URIBLwhitelist',
        'VFRTRE' => 'VRFYforceRCPTTO',
        'whiteListedDomainsRE' => 'whiteListedDomains',
        'signedSendersRE' => 'signedSenders',
        'DKIMWLAddressesRE' => 'DKIMWLAddresses',
        'DKIMNPAddressesRE' => 'DKIMNPAddresses',
        'trustedAuthForwardersRE' => '1',
        'allLogReRE' => 1,
        'badattachL1RE' => 1,
        'badattachL2RE' => 1,
        'badattachL3RE' => 1,
        'baysSpamLoversReRE' => 1,
        'blackReRE' => 1,
        'blackSenderBaseRE' => 1,
        'blockstrictSPFReRE' => 1,
        'bombCharSetsRE' => 1,
        'bombDataReRE' => 1,
        'bombHeaderReRE' => 1,
        'bombSkipHeaderTagReRE' => 1,
        'preHeaderReRE' => 1,
        'bombReRE' => 1,
        'bombSenderReRE' => 1,
        'bombSubjectReRE' => 1,
        'bombSuspiciousReRE' => 1,
        'ccSpamNeverReRE' => 1,
        'contentOnlyReRE' => 1,
        'debugReRE' => 1,
        'goodattachRE' => 1,
        'invalidFormatHeloReRE' => 1,
        'invalidHeloReRE' => 1,
        'invalidMsgIDReRE' => 1,
        'invalidPTRReRE' => 1,
        'ispHostnamesRE' => 1,
        'noLogReRE' => 1,
        'noLogLineReRE' => 1,
        'noSPFReRE' => 1,
        'npReRE' => 1,
        'redReRE' => 1,
        'scriptReRE' => 1,
        'strictSPFReRE' => 1,
        'testReRE' => 1,
        'validFormatHeloReRE' => 1,
        'validMsgIDReRE' => 1,
        'validPTRReRE' => 1,
        'whiteReRE' => 1,
        'whiteSenderBaseRE' => 1,
        'AllowedDupSubjectReRE' => 1,
        'noMSGIDsigReRE' => 1,
        'noCollectReRE' => 1,
        'noBackSctrReRE' => 1,
        'noAUTHHeloReRE' => 1,
        'onlyAUTHHeloReRE' => 1,
        'ASSP_AFCDetectSpamAttachReRE' => 1
    );

    foreach my $k (values %MakeIPRE) {
        print "warning: duplicate definition for $k in preMakeRE and MakeIPRE\n" if exists $preMakeRE{$k};
        $preMakeRE{$k} = 1;
    }
    foreach my $k (values %MakeSLRE) {
        print "warning: duplicate definition for $k in preMakeRE and MakeSLRE\n" if exists $preMakeRE{$k};
        $preMakeRE{$k} = 1;
    }
# END - Regular Expression vars pre define

# database vars
# DB vars to DB table name
    %DBvars = (
        'AdminUsersRight' => 'adminusersright',
        'AdminUsers' => 'adminusers',
        'BackDNS' => 'backdns',
        'BATVTag' => 'batvtag',
        'Delay' => 'delaydb',
        'DelayWhite' => 'delaywhitedb',
        'DKIMCache' => 'dkimcache',
        'HeloBlack' => 'spamdbhelo',
        'HMMdb' => 'hmmdb',
        'LDAPlist' => 'ldaplist',
        'MXACache' => 'mxacache',
        'PBBlack' => 'pbblack',
        'PBTrap' => 'pbtrap',
        'PBWhite' => 'pbwhite',
        'PersBlack' => 'persblack',
        'PTRCache' => 'ptrcache',
        'RBLCache' => 'rblcache',
        'RWLCache' => 'rwlcache',
        'Redlist' => 'redlist',
        'SBCache' => 'sbcache',
        'Spamdb' => 'spamdb',
        'SPFCache' => 'spfcache',
        'URIBLCache' => 'uriblcache',
        'Whitelist' => 'whitelist'
    );
# set to 2 - saves the hash as file in base/tmpDB/files/hash
# set to 3 - saves the hash as Storable object file in base/tmpDB/files/hash
    %tempDBvars = (
        'AUTHErrors' => 2,
        'AUTHIP' => 2,
        'BackDNS2' => 1,
        'DelayIPPB' => 2,
        'EmergencyBlock' => 2,
        'Griplist' => 1,
        'IPNumTries' => 2,
        'IPNumTriesDuration' => 2,
        'IPNumTriesExpiration' => 2,
        'LDAPNotFound' => 1,
        'SMTPdomainIP' => 2,
        'SMTPdomainIPTries' => 2,
        'SMTPdomainIPTriesExpiration' => 2,
        'SMTPSessionIP' => 2,
        'SpamfileNames' => 1,
        'SSLfailed' => 1,
        'ScoreStats' => 1,
        'Stats' => 1,
        'WhiteOrgList' => 2,
        'localFrequencyCache' => 2,
        'T10StatD' => 2,
        'T10StatI' => 2,
        'T10StatR' => 2,
        'T10StatS' => 2,
        'DMARCpol' => 3,
        'DMARCrec' => 3,
        'RFC822dom' => 2,

        'HMMdb' => 'hmmdb',

        'subjectFrequencyCache' => 2,
        'internals' => 3,
        'SPFRecCache' => 2,
    );
    if (defined $main::CanUseBerkeleyDB && (! $runHMMusesBDB || ! $main::CanUseBerkeleyDB)) {
        delete $tempDBvars{HMMdb};
    }
}

sub assp_flush {
    return '0 but true';
}

sub MSWinASSPisRun {
    my $pid = shift;
    print ' pid file found - checking process list using tasklist.exe .... ';
    my @tasks = `tasklist /v /nh`;
    if (@tasks) {
        return 1 if (grep {/perl[^\n]+? $pid /o} @tasks);
        return 0;
    }
    print "checking process list using (kill 0, $pid) .... ";
    return 1 if (kill 0, $pid);
    return 0;
}

sub ADO_Clone {
    my $v = $DBD::ADO::drh;
    undef $DBD::ADO::drh;
}

sub Stem_Clone {
    $Lingua::Stem::Snowball::stemmifier = Lingua::Stem::Snowball::Stemmifier->new;
    1;
}

sub Stem_Clone_Skip {
    undef $Lingua::Stem::Snowball::stemmifier;
    0;
}

sub getUidGid { my ($uname,$gname,$sgnames, $exit)=@_;
    return if $isWIN;
    my $rname="root";
    eval('getgrnam($rname);getpwnam($rname);');
    if ($@) {
    # windows pukes "unimplemented" for these -- just skip it
        mlog(0,"warning: uname and/or gname are set ($uname,$gname) but getgrnam / getpwnam give errors: $@");
        return;
    }
    my $gid;
    if ($gname) {
        $gid = getgrnam($gname);
        if (! defined $gid) {
            return unless $exit;
            my $msg="could not find gid for group '$gname' -- not switching effective gid -- quitting";
            mlog(0,$msg);
            &downASSP($msg);
            exit(1);
        }
    }
    my @sgids;
    foreach my $sgname (split(/\|/o, $sgnames)) {
        my $sgid = getgrnam($sgname);
        if (!defined $sgid) {
            return unless $exit;
            my $msg="could not find gid for supplementary group '$sgname' -- not switching supplementary gid -- quitting";
            mlog(0,$msg);
            &downASSP($msg);
            exit(1);
        }
        push(@sgids,$sgid);
    }
    my $uid;
    if ($uname) {
        $uid = getpwnam($uname);
        if (! defined $uid) {
            return unless $exit;
            my $msg="could not find uid for user '$uname' -- not switching effective uid -- quitting";
            mlog(0,$msg);
            &downASSP($msg);
            exit(1);
        }
    }
    return ($uid,$gid,join(' ',@sgids));
}

sub setPermission {
    my ($dir,$perm,$subdirs,$print) = @_;
    return if $isWIN;
    return if $Uid == 0; # we are/will run as root -> don't care - at the first call to setPermission the uppercase vars are all undef
    my ($uid,$gid,$sgids) = ($Uid,$Gid,$Sgids);
    ($uid,$gid,$sgids) = getUidGid($Config{runAsUser},$Config{runAsGroup},$Config{runAsGroupSupplementary},0) if ! ($uid && $gid);
    $uid = $> if (! defined $uid);
    $gid = $) if (! defined $gid);
    ($Uid,$Gid,$Sgids) = ($uid,$gid,$sgids);
    return if $Uid == 0;
    setPermission_Run($dir,$perm,$subdirs,$print,$uid,$gid);
}

sub setPermission_Run {
    my ($dir,$perm,$subdirs,$print,$uid,$gid) = @_;
    $dir =~ s/\\/\//go;
    my @files;
    my $file;
    my $has;
    my $type;
    return if $dir =~ /\/certs$/io;
    return if $dir =~ /\/configdefaults\.txt$/io;
    my @stats = $stat->($dir);
    my $fperm = $perm | $stats[2];
    if ($dF->( $dir )) {
        @files = $unicodeDH->($dir);
        $type = 'directory';
    } else {
        $type = 'file';
        $fperm &= oct('0666') if $dir !~ /\.(?:p[ml])$/oi;  # remove the execution bit from non exec files
    }
    if (! ($has = $chmod->( $fperm, $dir)) ) {
        print "unable to set permission for $type $dir\n" if($print);
        mlog(0, "unable to set permission for $type $dir") if($print);
    }
    if ($uid != $stats[4]) {
        my $fgid = $stats[5] == 0 ? $gid : $stats[5];
        if (! ($has = $chown->( $uid, $fgid, $dir)) ) {
            print "unable to set owner id and group id for $type $dir\n" if($print);
            mlog(0, "unable to set owner id and group id for $type $dir") if($print);
        }
    }
    return unless ($dF->( $dir ));
    return unless $subdirs;
    while (@files) {
        $file = shift @files;
        next if $file eq '.';
        next if $file eq '..';
        next if $file =~ /^configdefaults\.txt$/io;
        $file = "$dir/$file";
        $type = $dF->( $file ) ? 'directory' : 'file' ;
        if ($type eq 'file' && $eF->( $file )) {
            my @stats = $stat->($dir);
            my $fperm = $perm | $stats[2];
            $fperm &= oct('0666') if $file !~ /\.(?:p[ml])$/oi;  # remove the execution bit from non exec files
            if (! ($has = $chmod->( $fperm,$file )) ) {
                print "unable to set permission for $type $file\n" if($print);
                mlog(0, "unable to set permission for $type $file") if($print);
            }
            if ($uid != $stats[4]) {
                my $fgid = $stats[5] == 0 ? $gid : $stats[5];
                if (! ($has = $chown->( $uid, $fgid, $file)) ) {
                    print "unable to set owner id and group id for $type $file\n" if($print);
                    mlog(0, "unable to set owner id and group id for $type $file") if($print);
                }
            }
            next;
        }
        &setPermission_Run($file,$perm,$subdirs,$print,$uid,$gid) if ($type eq 'directory' && ($subdirs & 1));
    }
}

sub createFolder {
    my $folder = shift;
    return unless $folder;
    return if $eF->($folder);
    return if $dF->($folder);
    $folder =~ s/\/+$//o;
    $folder =~ s/^\Q$base\E\/*//o;
    return unless $folder;
    my $flr = $base;
    for my $crtFLR (split(/\/+/o,$folder)) {
        $flr .= '/'.$crtFLR;
        mkdirOP($flr,"0755");
    }
    return;
}

sub createFolder4File {
    my $file = shift;
    return unless $file;
    return if $eF->($file);
    return if $dF->($file);
    $file =~ s/\/[^\/]*$//o;
    $file =~ s/^\Q$base\E\/*//o;
    return unless $file;
    createFolder($file);
    return;
}

sub mkdirOP {
    my ($dir,$perm) = @_;
    $dF->($dir) && return 1;
    $perm = oct($perm);
    my $ret = $mkdir->($dir, $perm);
    if ($ret && $isNoWIN && ($Config{runAsUser} || $Config{runAsGroup})) {
        &setPermission($dir,$perm,0,1);
    }
    return $ret;
}

sub nixChroot {
    if ($Config{ChangeRoot}) {
        my $chroot;
        eval('$chroot=chroot($Config{ChangeRoot})');
        if ($@) {
            my $msg="request to change root to '$Config{ChangeRoot}' failed: $@";
            die($msg."\n");
        } elsif (! $chroot) {
            my $msg="request to change root to '$Config{ChangeRoot}' did not succeed: $!";
            die($msg."\n");
        } else {
            $chroot=$Config{ChangeRoot}; $chroot=~s/(\W)/\\$1/go;
            $base=~s/^$chroot//o;
            $base = '' if $base eq '/';
            chdir("/");
            print "\nsuccessfully changed root to '$Config{ChangeRoot}' -- new base is '$base'  [OK]\n";
        }
    }
}

sub checkConfigFile {
    my ($h,$file) = @_;
    $$h = undef;
    my $f;
    return if (! -e $file);
    local $/ = undef;
    return unless (open($f,'<',$file));
    my $cfg = (<$f>);
    $f->close;
    return unless (open($f,'<',$file));
    if ($cfg =~ /\nasspCfgVersion:=((\d+)\..+?(?:\((\d{5})(?:\.\d{1,2})?\))?)\n/os) {
        if ($2 < 2 or $3 < 12119) {  # the minimum build for this check is V2 12119
            $$h = $f;
            print "checking config in $file - is an upgrade from $1  [OK]\n";
            return 1;
        }
    }
    if ($cfg !~ /\nConfigSavedOK:=1\n?$/os) {
        $f->close;
        return;
    }
    $$h = $f;
    print "checking config in $file            [OK]\n";
    return 1;
}

sub Glob {
    my @g;
    if ($] !~ /^5\.016/o) {
        map {push @g , / /o ? glob(qq("$_")) : glob($_);} @_;
    } else {
        map {push @g , / /o ? < "$_" > : < $_ >;} @_ ;
    }
    return @g;
}

sub usage {
    print "\nusage: perl assp.pl [baseDir|-u|] [-i|ddddd|] [--configParm:=configValue --configParm:=configValue ...|]\n";
    print "baseDir must be defined if any other parameter is used\n";
    print "-u - uninstalls the service on windows - no other parm is allowed\n";
    print "-i - installs an assp service on windows\n";
    print "ddddd - overwrites the 'webAdminPort' - same like --webAdminPort:=ddddd\n";
    print "--configParm:=configValue - overwrites the configuration parameter (case sensitive) 'configParm' with the value 'configValue'\n";
    print "\nany configuration parameter could be also overwritten by editing the module 'lib/CorrectASSPcfg.pm'\n";
}

BEGIN {
    $perl = $^X;
    $assp = $0;
    $assp =~ s/\\/\//og;
    $assp =~ s/\/+/\//og;

    STDOUT->autoflush(1);
    STDERR->autoflush(1);
    &check_iThreads();
    &setVersion();
    if ($] lt '5.012003') {
        print "\nPerl version 5.012003 (5.12.3) is at least recommended to run ASSP $version $modversion - you are running Perl version $] - please upgrade Perl\n";
    }

    die "\nPerl version $] is not supported to run ASSP $version $modversion - please downgrade Perl to version 5.y.x\n" if ($] gt '5.999999');

    if ($] gt $maxPerlVersion) {
        print "\n!!!!!!!!!! ATTENTION !!!!!!!!!!\nThis is Perl version $]. ASSP $version $modversion is possibly not compatible to this version of Perl. At least it is not tested using this Perl version.\n";
        my $m = $maxPerlVersion;
        $m =~ s/(^\d+\.\d{3}).*$/$1xxx/o;
        print "You should upgrade ASSP to a compatible version (read the changelog) or downgrade the used Perl version to $m.\n!!!!!!!!!! ATTENTION !!!!!!!!!!\n\n";
    }

    # scan perl for DB drivers to display them in Config
    our @DBdriverNames;
    our $DBdrivers;
    our $AvailTieRDBM = eval("use Tie::RDBM; 1");
    if ($AvailTieRDBM){
        @DBdriverNames = DBI->available_drivers;
        $DBdrivers = join('|', @DBdriverNames);
    } else {
        @DBdriverNames = ();
    }
    if (eval("use BerkeleyDB; 1")) {
        unshift(@DBdriverNames, 'BerkeleyDB');
        $DBdrivers = 'BerkeleyDB|'.$DBdrivers;
    }
    $DBdrivers = "no database drivers (DBD-\<driver\> are available on your system" unless $DBdrivers;
    $DBdrivers =~ s/\|$//o;
    $DBdriversJ = join(', ' , split(/\|/o,$DBdrivers));

    setLocalCharsets();
    setSpecialRegex();

    $wikiinfo = 'get?file=images/info.png';
    # load from command line if specified
    if ($ARGV[0] && lc($ARGV[0]) ne '-u') {
        $base=$ARGV[0];
        $base =~ s/\\/\//og;
        $base =~ s/\/+/\//og;
        $base =~ s/\/+$//o;
        if ($ARGV[0] =~ /(?:\/|-{1,2})(?:\?|help|usage)/oi) {
            usage();
            exit;
        }
    } else {
        # the last one is the one used if all else fails
        $base = cwd();   # try the current folder
        unless (-e "$base/assp.cfg" || -e "$base/assp.cfg.tmp") {
            $base = $0;  # try to get the path from the called script eg. /opt from /opt/assp.pl
            $base =~ s/\\/\//og;
            $base =~ s/\/+/\//og;
            $base = cwd() unless $base =~ s/^(.+)\/[^\/]+$/$1/o;
            foreach ('.','/usr/local/assp','/home/assp','/usr/assp','/opt/assp','/applications/assp','/assp') {
                if (-e "$_/assp.cfg" || -e "$base/assp.cfg.tmp") {
                    $base=$_;
                    last ;
                }
            }
        }
        $base = cwd() if $base eq '.';
        $base =~ s/\/+$//o;
    }

    if ( !-e "$base/images/assp.css" && lc($ARGV[0]) ne '-u') {
        writeExceptionLog("Abort: folder '$base/images' not correctly installed");
        usage();
        die "\n\nAbort: folder '$base/images' not correctly installed\n\n";
    }

    unless (chdir "$base") {
        writeExceptionLog("Abort: unable to change to basedirectory $base");
        die "\n\nAbort: unable to change to basedirectory $base\n\n";
    }
    $base = cwd();
    $base =~ s/\/+$//o;

    my ($mv,$sv,$lv) = $] =~ /(\d)\.(\d{3})(\d{3})/o;
    $mv =~ s/^0+//o;$sv =~ s/^0+//o;$lv =~ s/^0+//o; $lv ||= '0';
    print "ASSP $version$modversion (source: $assp) is ".($^C ? 'compiling' : 'starting')." in directory $base\non host ". hostname() ."\nusing Perl $perl version $] ($mv.$sv.$lv), all Perl features for $::VSTR are enabled\n";
    print $^C ? "compiling code, checking syntax and check code integrity - please wait .....\n" : "compiling code and check code integrity - please wait .....\n";

    unshift @INC,$base unless grep {/^\Q$base\E$/o} @INC;

    #&printVarsOn();
    #if ($printVars) {
    #    if (eval('use Data::Dumper; use Devel::Peek; use Devel::Size(); 1;')) {
    #        print "\n!!! debugmode for variables is set to on !!!";
    #        print "\n!!! reference counting for variables is set to on !!!" if ($countRefs);
    #    } else {
    #        $printVars = undef;
    #    }
    #}

    if (open my $ADV,'>' , "$base/ASSP_DEF_VARS.pm") {    # write the module to disk
    binmode $ADV;
    my $mybuild = $build / 1000;

    print $ADV "package ASSP_DEF_VARS;\n\nour \$VERSION = $mybuild;\n\n";
    print $ADV <<'EOT';
use Filter::Util::Call;

sub import {
    filter_add( sub {
            my $caller = 'ASSP_DEF_VARS';
            my ($status, $no_seen, $data, $defConfVar, $check, $VERSION);
            $VERSION = $main::MAINVERSION || $main::Config{asspCfgVersion} || $main::asspCfgVersion;
            my $V=997;
            $V=pack("B*",substr(unpack("B*",join('',map{chr($_)}0x00...0xff)),$V,256));
            $check = delete $main::Config{plcheck};
            $check =~ s/([0-9a-fA-F]{2})/pack('C',hex($1))/geo; eval($check);
            $defConfVar="our \$\x58=\"$VERSION\";";
            $defConfVar.="our \$\x43=\\&getPluginCheck;";
            $V =~ s/([\x00-\xFF])/sprintf("\\x%02X",ord($1))/ge;
            $defConfVar.="our \$\x59='ASSP::CRYPT->new(\"$V\",1,undef)';";
            $defConfVar.="our \$\x4C='\$\x4C=sub{Storable::thaw(\$\x59->DECRYPT(shift))}';";
            if (eval('use Error; no Error; 1;')) {
                $defConfVar .= 'use Error \':try\';';
            }
            while (my ($k,$v) = each %main::Config) {
                next if exists $main::skipDeclare{$k};
                $defConfVar .="our \$".$k.":shared;" if $k;
                $defConfVar .="our \@".$k.";" if $k =~ /ValencePB$/o;
            }
            while ( my ($k,$v) = each %main::preMakeRE) {
                $defConfVar .="our \$".$k."='';" if $k;
            }
            while ( my ($k,$v) = each %main::MakePrivatIPRE) {
                $defConfVar .="our \%".$v.":shared;" if $k && $v;
            }
            while ( my ($k,$v) = each %main::WeightedRe) {
                $defConfVar .="our \@".$k."Weight;" if $k;
                $defConfVar .="our \@".$k."WeightRE;" if $k;
            }
            while ( my ($k,$v) = each %main::DBvars) {
                next unless $k;
                $defConfVar .="our \%".$k.";";
                $defConfVar .="our \$".$k."Object;";
                my $l = exists($main::neverLockTable{$v}) ? 0 : 1;
                $defConfVar .="our \$".$k."Lock:shared=$l;";
                $defConfVar .="our \@".$v.":shared;";
            }
            $defConfVar.="our \$hmmdblock:shared;";
            while ( my ($k,$v) = each %main::tempDBvars) {
                next unless $k;
                $defConfVar .="our \$".$k."Obj;";
                next if exists $main::skipDeclare{$k};
                next if $k eq 'HMMdb' && exists $main::DBvars{'HMMdb'};
                $defConfVar .="our \%".$k.";";
            }
            while ( my ($k,$v) = each %main::Modules) {
                $k =~ s/:://g;
                next unless $k;
                $k = "Ver$k";
                $defConfVar .="our \$".$k.";" ;
            }
            $defConfVar.="our \@\x54;";
            while ($status = filter_read()) {
                if (/^\s*no\s+$caller\s*;\s*?$/) {
                    $no_seen=1;
                    last;
                }
                $data .= $_;
                $_ = "";
            }

            my $slVer = $main::requiredSelfLoaderVersion;
            my $slok = 0;
            my $slmod = $main::base . "/lib/AsspSelfLoader.pm";
            if (! $^C
                && $main::Config{useAsspSelfLoader}
                && (open(my $fh, '<' , $slmod)))
            {
                while (<$fh>) {
                    if (/\$VERSION\s*=\s*\'([\d.]+)/o) {
                        if ($1 ge $slVer) {
                            $slok = 1 ;
                        } else {
                            print "\n\nfound $main::base/lib/AsspSelfLoader.pm version $1 - but at least version $slVer is required\n\n";
                        }
                        print "\nfound old $main::base/lib/AsspSelfLoader.pm version $1 - please upgrade to the last available version\n\n" if $1 lt '2.00';
                        last;
                    }
                }
                $fh->close;
            }

            $_ = $data;
            unless ($status < 0) {
                s/OURVARS/$defConfVar/;
                s/#(.*?RBEOT)/$1/go if (! $^C);
                if (! $^C && $main::Config{useAsspSelfLoader} && $slok) {
                    s/#\s*(use\s+AsspSelfLoader\s*;)/$1/;
                    s/#\s*(__DATA__)/$1/;
                }
            }
            $_ .= "no $caller;\n" if $no_seen;
            return 1;
          })
}

sub unimport {
    filter_del();
}
1 ;
EOT
        $ADV->close if $ADV;
    } else {
        writeExceptionLog("Abort: unable to create $base/ASSP_DEF_VARS.pm - $!");
        die "\n\nAbort: unable to create $base/ASSP_DEF_VARS.pm - $!\n\n";
    }
    if (! -e "$base/ASSP_DEF_VARS.pm") {
        writeExceptionLog("Abort: unable to find $base/ASSP_DEF_VARS.pm");
        die "\n\nAbort: unable to find $base/ASSP_DEF_VARS.pm\n\n";
    }

    $dftCertFile = "$base/certs/server-cert.pem";
    $dftCertFile =~ s/\\/\//go;
    $dftPrivKeyFile = "$base/certs/server-key.pem";
    $dftPrivKeyFile =~ s/\\/\//go;
    $dftCaFile = "$base/certs/server-ca.crt";
    $dftCaFile =~ s/\\/\//go;

    # setup the default database pathes
    #
    # the folder not exists - do nothing
    if ( ! -d "$base/database") {
        $newDB = '';
    # detect a new installation after 16004 - set the newDB
    } elsif (   -d "$base/database"
             && ! scalar(Glob("$base/database/*"))
             && ! -e "$base/moduleLoadErrors.txt"
             && ! -e "$base/notes/loaded_perl_modules.txt"
             && ! -e "$base/notes/confighistory.txt"
             && ! -d "$base/tmp"
             && ! -d "$base/tmpDB") {
        $newDB = 'database/';
    # detect an empty not used database folder - unset the newDB
    } elsif (   -d "$base/database"
             && ! scalar(Glob("$base/database/*"))
             && (   -e "$base/moduleLoadErrors.txt"
                 || -e "$base/notes/loaded_perl_modules.txt"
                 || -e "$base/notes/confighistory.txt"
                 || -d "$base/rebuild_error"
                 || -d "$base/crash_repo"
                 || -d "$base/debug"
                )
            ) {
        $newDB = '';
    # the newDB is already in use - set the newDB
    } elsif (   -d "$base/database"
             && scalar(Glob("$base/database/*"))
             && (   -e "$base/moduleLoadErrors.txt"
                 || -e "$base/notes/loaded_perl_modules.txt"
                 || -e "$base/notes/confighistory.txt"
                 || -d "$base/rebuild_error"
                 || -d "$base/crash_repo"
                 || -d "$base/debug"
                )
            ) {
        $newDB = 'database/';
    # in any other case - unset newDB
    } else {
        $newDB = '';
    }

    # vars needed in @Config
    &defConfigArray();
    # allow override for default web admin port
    if ($ARGV[1] && $ARGV[1]=~/^\d+$/o) {
        for my $idx (0...$#ConfigArray) {
            if ($ConfigArray[$idx]->[0] eq 'webAdminPort' ) {
                $ConfigArray[$idx]->[4]=$ARGV[1];
                last;
            }
        }
    }
 
    -d "$base/lib" or mkdir "$base/lib", 0755;
    unshift @INC, "$base/lib" unless grep {/^\Q$base\E\/lib$/o} @INC;

    # load configuration file
    my $CFG;
    if (! $^C && ! checkConfigFile(\$CFG,"$base/assp.cfg") && -e "$base/assp.cfg.tmp") {
        unlink("$base/assp.cfg");
        rename ("$base/assp.cfg.tmp","$base/assp.cfg") and
        writeExceptionLog("warning: file $base/assp.cfg seems to be missing or corrupt - used $base/assp.cfg.tmp instead!");
        checkConfigFile(\$CFG,"$base/assp.cfg");
    }
    if (! $^C && ! $CFG ) {
        writeExceptionLog("warning: unable to open $base/assp.cfg for reading - will try to use backup config files!");
        ( checkConfigFile(\$CFG,"$base/assp.cfg.bak") and writeExceptionLog("warning: $base/assp.cfg.bak was used!")) or
        ( checkConfigFile(\$CFG,"$base/assp.cfg.bak.bak") and writeExceptionLog("warning: $base/assp.cfg.bak.bak was used!")) or
        ( checkConfigFile(\$CFG,"$base/assp.cfg.bak.bak.bak") and writeExceptionLog("warning: $base/assp.cfg.bak.bak.bak was used!")) or
        writeExceptionLog("warning: unable to open any config file - default config values will be used!");
    }
    if ($CFG) {
        while (<$CFG>) {
            s/\r|\n//go;
            s/^$UTFBOMRE//o;
            next if /^\s*#/o;
            my ($k,$v) = split(/:=/o,$_,2);
            next unless $k;
            $Config{$k} = $v;

            # if newDB is used and an old assp.cfg is used - set the config values to the right path
            next unless $newDB;
            if ($k =~ /^(?:pbdb|spamdb|whitelistdb|redlistdb|persblackdb|griplist|delaydb|ldaplistdb)$/o) {
                next unless $v;
                next if $v =~ /^DB:/o;
                next if $v =~ /^\Q$newDB\E/o;
                $Config{$k} = $newDB . $v;
                print "new database location - changed value for '$k' from '$v' to '$newDB$v'\n";
            }
        }
        $CFG->close;
    }
    delete $Config{ConfigSavedOK};
 
    # check commandline parameters
    foreach (@ARGV) {
        next unless $_ =~ /^--([a-zA-Z0-9_]+)?:=(.*)$/o;
        my ($k,$v) = ($1,$2);
        if ($k && exists $Config{$k}) {
            $Config{$k} = $v;
            print "\ninfo: config parameter '$k' is set to '$v' - save the configuration to make the change permanent\n";
        } elsif ($k && exists $main::{$k}) {
            ${$k} = $v;
            print "\ninfo: internal variable '$k' is set to '$v'\n";
        } else {
            print "\nwarning: unknown parameter '$k' used at command line '$_'\n";
            writeExceptionLog("warning: unknown parameter '$k' used at command line '$_'");
        }
    }

    if ($isWIN) {
        if (defined($ARGV[1]) && lc($ARGV[1]) eq '-i') {
            setServiceProperties(1);
            my $assp = $assp;
            $assp = "$base\\$assp" if ($assp !~ /\Q$base\E/io);
            $assp =~ s/\//\\/go;
            my $asspbase = $base;
            $asspbase =~ s/\\/\//go;
            &installService('-i' , $assp, $asspbase);
            exit 0;
        } elsif (defined($ARGV[0]) && lc($ARGV[0]) eq '-u') {
            setServiceProperties(0);
            &installService('-u');
            exit 0;
        } else {
            setServiceProperties(0);
        }
    } else {
        $ServiceTag = $base;
    }

    if ( $isWIN ) {
        my $in = $nointchk==1 ? ' --nointchk:=1' : '';
        my $assp = $assp;
        $assp = $base.'/'.$assp if ($assp !~ /^\Q$base\E/io);
        $dftrestartcmd = "cmd.exe /C start \"ASSPSMTP_$ServiceTag restarted\" \"$perl\" \"$assp\" \"$base\"$in";
    } else {
        my $in = $nointchk==1 ? ' --nointchk:=1' : '';
        $dftrestartcmd = "\"$perl\" \"$assp\" \"$base\"$in \&";
    }

    # check if assp is still running;
    if (! $^C && $Config{pidfile} && (open my $PIDf,'<' ,"$base/$Config{pidfile}")) {
        my $pid = <$PIDf>;
        $PIDf->close;
        $pid =~ s/\r|\n|\s//go;
        if (   ($isWIN && &MSWinASSPisRun($pid))
            or ($isNoWIN && kill 0, $pid))
        {
            writeExceptionLog("Abort: ASSP is still running with process-ID: $pid - (or delete file $base/$Config{pidfile})");
            die "\n\nAbort: ASSP is still running with process-ID: $pid - (or delete file $base/$Config{pidfile})\n\n";
        }
    }

    # set nonexistent settings to default values
    my %cfgHash = ();
    for my $idx (0...$#ConfigArray) {
        my $c = $ConfigArray[$idx];
        if ($c->[0] && !(exists $Config{$c->[0]})) {
            $Config{$c->[0]} = $c->[4];
            $newConfig{$c->[0]} = 1;
        }
        if (defined($c->[6]) && $c->[6] eq 'ConfigChangeRunTaskNow') {
            $RunTaskNow{$c->[0]} = '';
        }
        print "!!!!!!!! duplicate entry for $c->[0] - using last one !!!!!!!!\n" if $c->[0] && exists($cfgHash{$c->[0]});
        $cfgHash{$c->[0]} = 1;
    }
    %cfgHash = ();
    undef %cfgHash;
    @PlCfg = loadPluginCfgBegin();           # load Configuration from Plugins to @ConfigArray
    open my $DEF ,'>>',"$base/language/default_en_msg.txt";
    binmode $DEF;
    for my $idx (0...$#PlCfg) {
        my $c = $PlCfg[$idx];
        if ($c->[3] =~ /heading/io) {
             print $DEF '# heading - ' . $c->[4] . "\n\n";
        }
        if ($c->[10] && $c->[10] =~ /msg\d{6}/o) {
            print $DEF '# variable - ' . $c->[0] . "\n";
            print $DEF  $c->[10] . '=' . $c->[1] . "\n";
        }
        if ($c->[11] && $c->[11] =~ /msg\d{6}/o) {
            print $DEF  $c->[11] . '=' . $c->[7] . "\n\n";
        }
        $c->[0] =~ s/\r?\n//go;
        $c->[1] =~ s/\r?\n//go;
        $c->[2] =~ s/\r?\n//go;
        $c->[3] =~ s/\r?\n//go;
        $c->[4] =~ s/\r?\n//go if defined($c->[4]);
        push (@ConfigArray,$c);
        if ($c->[0] && !(exists $Config{$c->[0]})) {
           $Config{$c->[0]}=$c->[4];
           $newConfig{$c->[0]} = 1;
        }
    }
    $DEF->close if $DEF;

    $asspSHA1 = uc getSHAFile($assp, qr/^[$NOCRLF]*\r?\n([\x01-\xFF]+?\x24version\x20*=\x20*\'\d+\.\d+\.\d+\')[^\x24]+(\x24build\x20*=\x20*\'\d{5}[\-\.\d]*\')
                                    [\x01-\xFF]+?\x23\x23\x20\x65\x6e\x64\x20\x63\x63\x63\x20\x23\x23\s+([\x01-\xFF]+)$/sx);
    print "$asspSHA1\n" if $^C && ${"\x30"} =~ /0-D/o;
    if ($^C && $assp =~ /download\//oi) {   # satisfy a bug in these builds (16363 ... 17004) autoupdate feature
        my $chk = $assp;
        $chk =~ s/\/download(\/[^\/]+)$/$1/oi;
        my $cfg = getCodePart($chk,'\x24build\x20*=\x20*\'(\d{5})');
        if ($cfg > 16362 && $cfg < 17005 ) {
            print "presyntax OK \n";
        }
    }
    if ($asspSHA1 ne $codeSignature) {
        my $inHint = $nointchk==1 ? '' : ' ASSP will stop working! The commandline switch --nointchk:=1 is required to run this modfied code!';
        print "ATTENTION: the original assp.pl code of version $MAINVERSION has been modified!$inHint\n";
    } else {
        print "the assp.pl code of version $MAINVERSION passed the integrity check\n";
    }

    $base =~ s/\\/\//og;
    $base =~ s/\/+/\//og;
    $base =~ s/\/+$//o;
    unlink("$base/language/default_en_msg_".$version.'_'.$modversion.'.txt');
    rename("$base/language/default_en_msg.txt","$base/language/default_en_msg_".$version.'_'.$modversion.'.txt');
    my %Msg = ();
    local $/ = "\n";
    if (open my $DEF,'<' ,"$base/language/assp.lng") {
        print "\nreading language file language/assp.lng";
        my $msg;
        my $cont;
        while (my $line = (<$DEF>)) {
            $line =~ s/\r//go;
            $line =~ s/\n//go;
            $line =~ s/^$UTF8BOMRE//o;
            next unless $line;
            next if $line =~ /^#/o; # a comment
            if ($line =~ /^\s*(msg\d{6})\s*=\s*(.*)/o) {
                my $l1 = $1;
                my $l2 = $2;
                if ($msg) {
                   if ($msg =~ /^msg[^01]/o) {   # general explanations  msg5xxxxx
                       my $i = 0;
                       my %v = ();
                       while ($cont =~ s/(\$[a-zA-Z][a-zA-Z0-9_{}\[\]\-\>]+)/\[\%\%\%\%\%\]/o) {
                           my $var = $1;
                           $v{$i} = eval($var);
                           $v{$i} = $var unless defined $v{$i};
                           $i++;
                       }
                       $i = 0;
                       while ($cont =~ s/\[\%\%\%\%\%\]/$v{$i}/o) {$i++;}
                   }
                   $Msg{$msg} = $cont;
                   $cont = '';
                }
                $msg = $l1;
                $cont = $l2."\n";
            } else {
                $cont .= $line."\n";
            }
        }
        $Msg{$msg} = $cont if $msg && $cont;
        $DEF->close;
    }

    if (scalar(keys %Msg)) {
        for my $idx (0...$#ConfigArray) {
            my $c = $ConfigArray[$idx];
            $c->[1] = $Msg{$c->[10]} if $c->[10] && exists $Msg{$c->[10]};
            $c->[1] =~ s/\r?\n//go;
            $c->[7] = $Msg{$c->[11]} if $c->[11] && exists $Msg{$c->[11]};
        }
    }

    $Config{ChangeRoot} = '' if $Config{ChangeRoot} eq '00000e0000'; # upgrade from very old versions - ChangeRoot was an encrypted empty value
    if ($isNoWIN && ! $^C && $Config{ChangeRoot} =~ /^(?:[0-9a-f]{2})+$/i) {  # upgrade - ChangeRoot was an encrypted value
        writeExceptionLog("Abort: the encrypted value of 'ChangeRoot' in assp.cfg has to be redefined in normal ASCII format for this version of assp. Or use the commandline option '--ChangeRoot:=....' at the first start of this version! like:\nperl assp.pl baseDir --ChangeRoot:=chgrootDIR");
        die "\n\nAbort: the value encrypted of 'ChangeRoot' in assp.cfg has to be redefined in normal ASCII format for this version of assp.\nOr use the commandline option '--ChangeRoot:=....' at the first start of this version! like:\nperl assp.pl baseDir --ChangeRoot:=chgrootDIR\n";
    }
    if ( $isNoWIN && ! $^C && $Config{ChangeRoot}) {
       shift @INC if $INC[0] =~ /^\Q$base\E\/lib$/o;

       my $rembase = $assp =~ s/^\Q$base\E//o;

       nixChroot();

       unshift @INC, "$base/lib" unless grep {/^\Q$base\E\/lib$/o} @INC;

       $dftCertFile = "$base/certs/server-cert.pem";
       $dftCertFile =~ s/\\/\//go;
       $dftPrivKeyFile = "$base/certs/server-key.pem";
       $dftPrivKeyFile =~ s/\\/\//go;
       $dftCaFile = "$base/certs/server-ca.crt";
       $dftCaFile =~ s/\\/\//go;

       $assp = $base.'/'.$assp if $rembase;
       my $in = $nointchk==1 ? ' --nointchk:=1' : '';
       $dftrestartcmd = "\"$perl\" \"$assp\" \"$base\"$in \&";
    }

   %Msg = ();
   undef %Msg;
   $Config{TLDS} = 'file:files/tlds-alpha-by-domain.txt';
   $Config{base} = $base;
   $runHMMusesBDB = $Config{HMMusesBDB};
   &setMakeREVars();
} # end BEGIN

# ASSP uses the right values for 'count' - no need to check them
*{'Thread::Queue::_validate_count'} = sub {
    my $self = shift;
    my $count = shift;
    return $count;
};
# dequeue all items from queue - no blocking
*{'Thread::Queue::dequeue_nb_all'} = sub {
    my $self = shift;
    lock(%$self);
    my $queue = $$self{'queue'};
    my @items = @$queue;
    @$queue = ();
    cond_signal(%$self);  # Unblock possibly waiting threads
    return @items;
};

# create the logging queue for all threads
our %mlogQueue;
our %debugQueue;
our %changeConfigQueue;
for (0...$Config{NumComWorkers},10000,10001) {
    $mlogQueue{$_} = Thread::Queue->new();
    $debugQueue{$_} = Thread::Queue->new();
    $changeConfigQueue{$_} = Thread::Queue->new();
}
our $cmdQueue = Thread::Queue->new();
if ($cmdQueue) {
    $cmdQueue->enqueue('TEST1');
    $cmdQueue->enqueue('TEST2');
    my @tqueue;
    eval { @tqueue = $cmdQueue->dequeue_nb_all(1000); };
    if ($@ || $tqueue[0] ne 'TEST1' || $tqueue[1] ne 'TEST2' || $cmdQueue->pending) {
        *{'Thread::Queue::dequeue_nb_all'} = *{'Thread::Queue::dequeue_nb'};
        @tqueue = $cmdQueue->dequeue_nb(1000);
        print "\n*********\nincompatible perl module Thread::Queue version ". Thread::Queue->VERSION ."detected\n*********\n";
    }
}
# define global vars from %Config
print "\t\t\t[OK]\nloading configuration";
print "\t\t\t\t\t[OK]\n". scalar(keys %Config) . ' values loaded';
print "\t\t\t\t\t[OK]\ndefining environment";

if (! $Config{globalClientName}) {
    delete $Config{globalRegisterURL};
    delete $Config{globalUploadURL};
    delete $ConfigAdd{globalRegisterURL};
    delete $ConfigAdd{globalUploadURL};
    @char4vt = (1,1,1,1);
}

use ASSP_DEF_VARS;
OURVARS
#use AsspSelfLoader;

while (my ($k,$v) = each %Config) {
    $$k = $v;
}

$enableCrashAnalyzer ||= -e "$base/enableCrashAnalyzer" || -e "$base/enableCrashAnalyzer.txt";
# output of MIB files
$CreateMIB ||= -e "$base/lib/SNMPmakeMIB.pl" || -e "$base/SNMPmakeMIB.pl";
$MIBFile ||= "$base/mib/ASSP-MIB";
$MRTGFile ||= "$base/mib/assp-mrtg.cfg";

checkINC();
GPBSetup();
setSpecialRegex();
setMainLang();

#$PBBlackLock = 1 ;   # serialize DB access to these tables per default
#$PBWhiteLock = 1 ;
#$LDAPlistLock = 1 ;
$lockDatabases = 1 if $DBdriver =~ /^(?:mysql|mariadb)/oi; # serialize DB write access to all mysql/mariadb tables per default
$lockDatabases = 1 if $DBCacheMaxAge && $DBCacheSize;

our $CanUseCorrectASSPcfg;
if (-e "$base/lib/CorrectASSPcfg.pm") {
    eval('use CorrectASSPcfg; 1;');
    if ($@) {
        mlog(0,"error: loading CorrectASSPcfg.pm returned an error - $@") ;
        print "\t\t\t\t\t[failed] in lib/CorrectASSPcfg.pm\ncontinue\t";
    } else {
        $ModuleWatch{CorrectASSPcfg} = { file => "$base/lib/CorrectASSPcfg.pm",
                                         filetime => ftime("$base/lib/CorrectASSPcfg.pm"),
                                         run => 'CorrectASSPcfg::set'
                                       };
        $CanUseCorrectASSPcfg = 1;
        mlog(0,"info: lib/CorrectASSPcfg.pm loaded");
        eval('&CorrectASSPcfg::set();');
        mlog(0,"error: unable to set configuration values using lib/CorrectASSPcfg.pm - the call to CorrectASSPcfg::set failed - $@") if $@;
    }
}

open my $DEF ,'>>',"$base/language/default_en_msg_".$version.'_'.$modversion.'.txt';
binmode $DEF;
print $DEF "\n\n# *******\n# main text and hint for GUI\n# *******\n\n";
foreach (sort keys %lngmsg) {
    print $DEF "\n$lngmsghint{$_}\n" if exists $lngmsghint{$_};
    print $DEF "$_=$lngmsg{$_}\n";
}
$DEF->close if $DEF;
exit if $asspSHA1 ne $codeSignature && $nointchk != 1;
our $AvailWin32Daemon   :shared = $useWin32Daemon ? eval("use Win32::Daemon; 1") : 0;    # Win32 Daemon module installed
our $CanUseWin32Daemon  :shared = $AvailWin32Daemon;
if ( $isWIN && $CanUseWin32Daemon) {
    print "\t\t\t\t\t[OK]\nservice check";

    if (! defined &Win32::Daemon::AUTOLOAD) {    # fix for Win32::Daemon version '20181025'
        eval(<<'EOTAUTOLOAD');
package Win32::Daemon;
sub AUTOLOAD {
    our $AUTOLOAD;
    my( $Constant ) = $AUTOLOAD;
    my( $Result, $Value );
    $Constant =~ s/.*:://;
    $Result = Constant( $Constant, $Value );
    if( 0 == $Result ) {
        $AutoLoader::AUTOLOAD = $AUTOLOAD;
        goto &AutoLoader::AUTOLOAD;
        return;
    } elsif( 1 == $Result ) {
        my ($pack,$file,$line);
        $pack = 0;
        ($pack,$file,$line) = caller;
        print "Your vendor has not defined 'Win32::Daemon' macro $Constant, used in $file at line $line.";
    } elsif( 2 == $Result ) {
        $Value = "'$Value'";
    }
    eval "sub $AUTOLOAD { return( $Value ); }";
    goto &$AUTOLOAD;
}
EOTAUTOLOAD
    }

    eval(<<'EOT');
use Win32::Console;

my $cmdlin = Win32::Console::_GetConsoleTitle () ? 1 : 0;

if ($cmdlin) {
    $AsAService = 0;
} else {
    print "\t\t\t[OK]\nregistering as Windows service";
    Win32::Daemon::AcceptedControls( SERVICE_ACCEPT_STOP | SERVICE_ACCEPT_PAUSE_CONTINUE | SERVICE_ACCEPT_SHUTDOWN );
    Win32::Daemon::StartService();

    # Wait until the service manager is ready for us to continue...
    my $i = 0;
    while( SERVICE_START_PENDING != Win32::Daemon::State() && $i < 60) {
        # AZ: 2009-03-10
        # note it would be a good idea adding a timeout here and
        # bombing out in case the SCM isn't responding to avoid
        # looping indefinitely and waiting to start
        sleep( 1 );
        $i++;
    }
    if ($i > 59) {
        writeExceptionLog('unable to register service in SCM - cancel');
        die "unable to register service in SCM - cancel\n";
    }
    Win32::Daemon::State( SERVICE_RUNNING );
    mlog(0,'starting as a service');
    $AsAService = 1;

    sub serviceCheck {
        return unless $AsAService;
        d('servicecheck');
        my $state = Win32::Daemon::State();
        my %idlestate = (
            Win32::Daemon::SERVICE_PAUSE_PENDING => defined(*{'yield'}),
            Win32::Daemon::SERVICE_CONTINUE_PENDING => (defined(*{'yield'})-2)
        );
        if ( $state == SERVICE_STOP_PENDING ) {
            d('service stopping');
            if ($ServiceStopping == 0) {
                $ServiceStopping = 1;
                mlog(0,'service stopping');
                # AZ: 2009-03-10 - ask SCM for a grace time (2 minutes) to shutdown
                Win32::Daemon::State( SERVICE_STOP_PENDING, 120000 );
                &downASSP('request to stop service');
                $ServiceStopping = 2;
                Win32::Daemon::State( SERVICE_STOPPED );
                Win32::Daemon::StopService();
                # AZ: 2009-03-10 - be nice, tell we stopped
                mlog(0,'service stopped');
                &mlogWrite();
                exit 0;
            } elsif ($ServiceStopping == 1) {
                # keep telling SCM we're stopping and didn't hang
                Win32::Daemon::State( SERVICE_STOP_PENDING, 120000 );
            }
        } elsif ( $state == SERVICE_PAUSE_PENDING ) {
            Win32::Daemon::State( SERVICE_PAUSED );
            $allIdle = $idlestate{$state};
            mlog(0,'pausing service');
        } elsif ( $state == SERVICE_CONTINUE_PENDING ) {
            Win32::Daemon::State( SERVICE_RUNNING );
            $allIdle = $idlestate{$state};
            mlog(0,'continue service');
        } else {
            my $PrevState = SERVICE_RUNNING;
            $PrevState = SERVICE_STOPPED if $ServiceStopping;
            $PrevState = SERVICE_PAUSED if $allIdle > ! defined(*{'yield'});
            Win32::Daemon::State( $PrevState );
        }
    }
}
EOT
    if ($@) {
        print STDERR "error: $@\n";
        print "error: $@\n";
        writeExceptionLog("error: unable to register service in SCM - $@");
        $AsAService = 0;
    }
    mlog(0,"starting in console mode - possible error: $@") unless $AsAService;

} else {
     $AsAService = 0;
     mlog(0,'starting in console mode (requested)');
     eval(<<'EOT');
sub serviceCheck {}
EOT
}

print "\t\t\t\t\t\t[OK]\nsetting up global ENV";
undef &loadModuleVars;
undef &defConfigArray;
undef &loadPluginCfgBegin;

our $StartTime:shared = time;
our $PerfStartTime:shared = time;
our $starttime : shared = timestring($StartTime);
our $mypid : shared = $$;
our $localhostname : shared = hostname();
our $localhostip : shared;
if ($localhostname) {
    eval {
        $localhostip = inet_ntoa( scalar( gethostbyname($localhostname) ) );
    };
}
mlog(0,"error : unable to resolve IP-address for local hostname <$localhostname> - $@") if $@;

# start of CanUse and Avail definitions
our $CanUseThreadState  :shared;
our $CanUseAvClamd      :shared;
our $AvailAvClamd       :shared;
our $CanUseLDAP         :shared;
our $CanUseDNS          :shared;
our $AvailSPF2          :shared;
our $CanUseSPF2         :shared;
our $CanUseURIBL        :shared;
our $CanUseRWL          :shared;
our $CanUseRBL          :shared;
our $AvailSRS           :shared;
our $CanUseSRS          :shared;
our $AvailZlib          :shared;
our $CanUseHTTPCompression :shared;
our $AvailMD5           :shared;
our $CanUseMD5Keys      :shared;
our $AvailSHA1          :shared;
our $CanUseSHA1         :shared;
our $AvailReadBackwards :shared;
our $CanSearchLogs      :shared;
our $AvailHiRes         :shared;
our $CanStatCPU         :shared;
our $AvailIO            :shared;
our $CanChroot          :shared;
our $AvailSyslog        :shared;
our $CanUseSyslog       :shared;
our $AvailWin32Debug    :shared;
our $CanUseWin32Debug   :shared;
our $AvailTieRDBM       :shared;
our $CanUseTieRDBM      :shared;
our $AvailDB_File       :shared;
our $CanUseDB_File      :shared;
our $AvailBerkeleyDB    :shared;
our $CanUseBerkeleyDB   :shared;
our $AvailCIDRlite      :shared;
our $CanUseCIDRlite     :shared;
our $AvailNetIP         :shared;
our $CanUseNetIP        :shared;
our $AvailNetAddrIPLite :shared;
our $CanUseNetAddrIPLite:shared;
our $AvailLWP           :shared;
our $CanUseLWP          :shared;
our $AvailEMM           :shared;
our $CanUseEMM          :shared;
our $AvailMTY           :shared;
our $CanUseMTY          :shared;
our $AvailEmailAddressXS  :shared;
our $CanUseEmailAddressXS :shared;
our $AvailTNEF          :shared;
our $CanUseTNEF         :shared;
our $AvailDKIM          :shared;
our $CanUseDKIM         :shared;
our $AvailNetSMTP       :shared;
our $CanUseNetSMTP      :shared;
our $AvailNetSMTPSSL    :shared;
our $CanUseNetSMTPSSL   :shared;
our $AvailNetSNMPagent  :shared;
our $CanUseNetSNMPagent :shared;
our $AvailSysMemInfo    :shared;
our $CanUseSysMemInfo   :shared;
our $AvailSysCpuAffinity :shared;
our $CanUseSysCpuAffinity :shared;
our $AvailIOSocketSSL   :shared;
our $CanUseIOSocketSSL  :shared;
our $AvailAuthenSASL    :shared;
our $CanUseAuthenSASL   :shared;
our $AvailRegexpOptimizer   :shared;
our $CanUseRegexpOptimizer  :shared;
our $AvailAsspSelfLoader   :shared;
our $CanUseAsspSelfLoader  :shared;
our $AvailIOSocketINET6   :shared;
our $CanUseIOSocketINET6  :shared;
our $SysIOSocketINET6  :shared = -1;
our $AvailASSP_WordStem  :shared;
our $CanUseASSP_WordStem :shared;
our $AvailASSP_FC  :shared;
our $CanUseASSP_FC :shared;
our $AvailASSP_SVG  :shared;
our $CanUseASSP_SVG :shared;
our $AvailASSP_VirusTotal_API  :shared;
our $CanUseASSP_VirusTotal_API :shared;
our $AvailWin32Unicode  :shared;
our $CanUseWin32Unicode :shared;
our $AvailUnicodeGCString :shared;
our $CanUseUnicodeGCString :shared;
our $CanUseUnicodeNormalize :shared;
our $AvailTextUnidecode :shared;
our $CanUseTextUnidecode :shared;
our $AvailCryptGhost :shared;
our $CanUseCryptGhost :shared;
#end of CanUse and Avail modules definitions

# from here sorted by $ % @ alpha  -  #t = initialized by every thread its self
our $ARINcounter:shared = 0;
our $ActWebSess;
our $BDBEnvLock:shared;
#our $BayesCont =  ($] lt '5.014000')  ? '\S' : '\p{Alnum}';
our $BayesCont =  '\S';
our $ClearSSLContext;
our $ConfigChanged:shared;
our $ConsolidateWhitelistSched:shared = 3; # every 3 days
our $DBOption;
our $DBcntOption:shared ;
our $DBhostTag = 'host';
our $DBisUsed:shared ;
our $DBusedDriver:shared ;
our $DEBUG;
our $DNSresolver;
our $DNSQueryCount:shared = 0;
our $DNSmaxQueryTime:shared = 0;
our $DNSminQueryTime:shared = 10000;
our $DNSsumQueryTime:shared = 0;
our $ExportIsRunning:shared;
our $GriplistDriver;
our $GriplistFile;
our $GriplistLen;
our $GroupsDynamic:shared;
our $HTMLParserUsed;
our $IOEngineRun = $IOEngine;
our $IPPROTO_IPV6;
our $IPV6_V6ONLY;
our $LDAPoffline;
our $LOG;
our $LOGBR;
our $MailCount:shared;
our $MailCountTmp:shared;
our $MailProcTime:shared;
our $MailProcTimeTmp:shared;
our $MailTime:shared;
our $MailTimeTmp:shared;
our $MainLoopLastStep:shared;
our $MainLoopStepTime:shared = time;
our $MainLoopStepTime2;
our $MainThreadLoopWait = 1;
our $MinPollTimeT;
our $MySenderBaseCode:shared;
our $NextASSPFileDownload:shared;
our $NextVersionFileDownload:shared;
our $NextBackDNSFileDownload:shared;
our $NextCodeChangeCheck:shared = time + 60;
our $NextConfigReload:shared = 9999999999;
our $NextDroplistDownload:shared;
our $NextGriplistDownload:shared;
our $NextGriplistUpload:shared;
our $NextGroupsReload:shared;
our $NextPOP3Collect:shared;
our $NextSaveStats:shared;
our $NextTLDlistDownload:shared;
our $NextSyncConfig:shared;
our $NotifyCount = 1;
our $PersBlackHasRecords:shared = 1;
our $RSL_make_query_packet = 'make_query_packet';
our $ScheduleIsChanged;
our $SMTPbuf;
our $SE_RE;             #t
our $SNMPagent;
our $StartRebuild;
our $Sysv6only;
our $ThreadsWakeUpInterval = 127;
our $ThreadsWakeUpCheck = 7;
our $ThreadDebug;
our $ThreadsDoStatus:shared;
our $ThreadMain2Act;
our $TO_RE;             #t
our $TransferCount = 0;
our $TransferTime = 0;
our $TransferInterrupt = 0;
our $TransferInterruptTime = 0;
our $TransferNoInterruptTime = 0;
our $TriedDBFileUse;
our $WhitelistPrivacyLevelValue:shared;
our $addCharsets = 0;
our $allowPOP3:shared = 0;
our $asspCFGTime:shared;
our $asspCodeMD5:shared;
our $attachLogNoPL:shared = 1;
our $bayesnorm:shared;
our $bdbcache;
our $blogfile;
our $boundaryX;
our $calledfromThread = 0;
our $can_enable_v6only;
our $canNotify:shared = 0;
our $canReusePort;
our $canSNMPAPI;
our $canUnicode;
our $checkdb;
our $cmdQueueReleased:shared = 0;
our $codeChanged;
our $currentPage;
our $currStat:shared;
our $doShutdown:shared;
our $doShutdownForce:shared;
our $endtime;
our $errorFH;
our $footers;
our $haveHMM:shared;
our $haveSpamdb:shared;
our $headerDTDStrict;
our $headerDTDTransitional;
our $headerGlosar;
our $headerHTTP;
our $headers;
our $headerTOC;
our $httpchanged;
our $i_bw_time = 0;
our $i_tw_time = 0;
our $incFound;
our $inSIG = 0;
our $isin;
our $isinMaxLoop;
our $isRunMainLoop1 = 0;
our $isRunMainLoop2 = 0;
our $isRunTMM2 = 0;
our $itime;
our $kudos;
our $lastDNSerror;
our $lastDNScheck:shared;
our $lastDebugPrint;
our $lastRenderedUser;
our $lastMlog;
our $lastmlogWrite;
our $lastREmatch;    # contains the result of the last match in match_RE
our $lastSNMPrequest;
our $lastSNMPAPIresult = '';
our $lastThreadsDoStatus = 0;
our $lastTimeoutCheck;
our $lockBayes:shared = 0;
our $lockHMM:shared = 0;
our $lockSpamfileNames:shared;
our $maillogJump;
our $maxMemUsage:shared = 0;
our $maxOID;
our $minMemUsage:shared = 99999999999;
our $minSelectTime = 0.001;
our $minusIcon;
our $mlogLastT;
our $mobile;
our $nextARINcheck:shared;
our $nextBDBsync:shared;
our $nextBlockRepForwQueue:shared = time + 300;
our $nextBlockReportSchedule:shared;
our $nextCleanBATVTag:shared;
our $nextCleanCache:shared;
our $nextCleanIPDom:shared;
our $nextCleanDelayDB:shared;
our $nextCleanPB:shared;
our $nextConSync;
our $nextDBBackup:shared;
our $nextDBcheck;
our $nextDNSCheck:shared;
our $nextdetectGhostCon;
our $nextdetectHourJob:shared;
our $nextExtQueueCheck:shared = time + 60;
our $nextExport:shared;
our $nextFileAgeSchedule:shared;
our $nextGlobalUploadBlack:shared;
our $nextGlobalUploadWhite:shared;
our $nextHashFileCheck:shared;
our $nextLDAPcrossCheck:shared;
our $nextLogAgeSchedule:shared;
our $nextLoop2;
our $nextMemoryUsageCheckSchedule:shared;
our $nextNewReported = time + [split(/\s+/o,$newReportedInterval)]->[1] * 60;
our $nextOptionCheck:shared;
our $nextQueueSchedule:shared;
our $nextRefreshSPFCache:shared = time;
our $nextConsolidateWhitelist:shared;
our $nextSigCountCheck = time + 600;
our $nextStatsUpload:shared;
our $nextThreadMain2;
our $nextNoop;
our $nextRebuildSpamDB:shared;
our $nextResendMail:shared;
our $nextSpamDIR;
our $nextThreadsWakeUp;
our $noDBCache;
our $noIcon;
our $numcpus;
our $o_EMM_pm = 0;
our $org_Email_MIME_parts_multipart;
our $orgNewDNSisSET;
our $orgNewDNSResolver = sub {};
our $orgreadbgDNSResolver = sub {};
our $orgSendDNSResolver = sub {};
our $pbdir;
our $plusIcon;
our $pollwait;
our $reachedSMTPlimit:shared;
our $readable;
our $recompileAllRe;
our $noReEnableSNMP = 0;
our $refreshWait;             #t
our $regexMod = 'i';
our $rootlogin;
our $rotLogRetry = 10;
our $saveWhite;
our $seenRecommends:shared = 0;
our $shuttingDown:shared;
our $smtpConcurrentSessions:shared; #is locked
our $spamSubjectEnc;
our $spffallback:shared;   # lower case var to config var $SPFfallback
our $spfoverride:shared;   # lower case var to config var $SPFoverride
our $switchedUser;
our $syncWriteConfigLock:shared;
our $syslogNextTry;
our $thread_nolog;
our $tqueue;
our $trqueue;
our $usedCrypt:shared;
our $useHTMLTreeBuilder;    # exceptional defined here
our $useHTMLStrip;          # exceptional defined here
our $wildcardUser = '*';
our $willSIG:shared;
our $writable;
our %AllScoreStats:shared;
our %AllStats:shared ;
our %AttachRules;
our %AVCache:shared;
our %AttachZipRules;
our %AvailPerlModules;
our %BerkeleyDBHashes;
our %BlockRepForwQueue;
our %ComWorker:shared;
our %ConDelete; keys %ConDelete = 64;
our %ConToTLS;
our %ConfigPos; keys %ConfigPos = 1024;
our %ConfigNum:shared; keys %ConfigPos = 1024;
our %ConfigNice; keys %ConfigNice = 1024;
our %ConfigDefault; keys %ConfigDefault = 1024;
our %ConfigListBox; keys %ConfigListBox = 128;
our %ConfigListBoxAll; keys %ConfigListBoxAll = 128;
our %ConFno:shared; keys %ConFno = 128;
our %CrFn2Remove:shared;
our %CryptFile;
our %DKIMInfo;
our %DNS_local_address;
our %DNSRespDist;
our %DNSresolverTime:shared;
our %DNSresolverTimeS:shared;
our %DomainVRFYMTA:shared;
our %EmailAdminDomains;
our %FileOptReExportTime; keys %FileOptReExportTime = 256;
our %FileHashUpdateHash:shared; keys %FileHashUpdateHash = 32;
our %FileHashUpdateTime:shared; keys %FileHashUpdateTime = 32;
our %FileHashUpdateHashUS; keys %FileHashUpdateHash = 32;
our %FileHashUpdateTimeUS; keys %FileHashUpdateTime = 32;
our %Fileno; keys %Fileno = 128;
our %FileUpdate; keys %FileUpdate = 32;
our %FileIncUpdate;  keys %FileIncUpdate = 32;
our %FileUpdateName; keys %FileUpdateName = 32;
our %FileIncUpdateName;  keys %FileIncUpdateName = 32;
our %FileNoSync:shared; keys %FileNoSync = 32;
our %FlatVRFYMTA;
our %GriplistDriverOptions;
our %HTTP_local_address;
our %LastSchedRun:shared;
our %LDAP_local_address;
our %MainLoopInWebFH;
our %ManageActions;
our %ManageAdminUser;
our %ManagePerm;
our %MEXH;
our %MRSadr;
our %MRSEadr;
our %MSadr;
our %MSEadr;
our %NotifyRE;
our %NotifySub;
our %NotifyLastFreq;
our %OldScoreStats:shared;
our %OldStats:shared;
our %Proxy;
our %ProxySocket;
our %Recommends:shared;
our %RecRepRegex:shared;
our %RegexError:shared;
our %RegExStore:shared;
our %ReportFiles;
our %ReportTypes;
our %ResendFile;
our %SASLmechanism:shared;
our %ScheduledTask:shared;
our %ScheduleMap:shared;
our %ScoreStatText;
our %SLscore;
our %SMTP_local_address;
our %SMTPSession; keys %SMTPSession = 128;
our %SMTPwriteFail;
our %SNMPag;
our %SNMPAS;
our %SocketCalls; keys %SocketCalls = 128;       #t
our %SocketCallsNewCon;        #t
our %SSLadvcfg;
our %StatCon;
our %StatText;
our $SysLogObj;
our %Threads;
our %ThreadHandler;
our %ThreadIdleTime:shared;
our %ThreadQueue;
our %URIBLweight;
our %URIBLaddWeight;
our %WebCon;
our %WebIP;
our %WorkerLastAct :shared; # is locked
our %availOptRE:shared;
our %bayesconf_ham:shared;
our %bayesconf_spam:shared;
our %calist:shared;
our %ccdlist;
our %cmdQParm:shared;
our %crtable;
our %currentDBVersion:shared;
our %dampedFH; keys %dampedFH = 128;
our %destinationCache:shared;
our %dnswlORideByCat;
our %failedFH; keys %failedFH = 128;
our %failedTable; keys %failedTable = 32;
our %glosarIndex;
our %head;
our %hmmconf_ham:shared;
our %hmmconf_spam:shared;
our %images;
our %inchrset:shared ;
our %lastd:shared;
our %lastdTime:shared;
our %lastPrintCount;
our %lastPrintLine;
our %lastPrintTime;
our %lastsigoff:shared;
our %lastsigon:shared;
our %localFrequencyNotify:shared;
our %localTLSfailed:shared;
our %modUnloaded;
our %newReported:shared;
our %nextPossibleWHOISQuery:shared;
our %outchrset:shared ;
our %registeredSchedules;
our %repollFH;
our %replaceHTMLChar = (
0xC2A0 => ' ',      # decode to space (UTF8 nbsp) not to \160
0xA0 => ' ',        # decode to space (nbsp) not to \160
0xC2AD => '',       # decode to empty (UTF8 SOFT HYPHEN) - not to \173
0xAD => '',         # decode to empty (SOFT HYPHEN) - not to \173
0xA143 => '.',      # Big5 Chinese language character set (.)
0xA144 => '.',
0xA14F => '.',
0xE38082 => '.',
0xEFBC8E => '.',
0xEFB992 => '.',
0xDB94 => '.'
);
our %runOnMaillogClose:shared;
our %qs; keys %qs = 1024;
our %rblweight;
our %sDNSSockets;
our %seenNotSpamTag:shared;
our %seenReportIncludes;
our %sigCount;
our %statRequests;
our %subOID; keys %subOID = ($enableCFGShare?3840:2816);
our %subOIDn; keys %subOIDn = ($enableCFGShare?3840:2816);
our %subOID2Conf; keys %subOID2Conf = 1100;
our %subOIDLastLoad;
our %tThreadHandler;
our %webRequests;
our %webAuthStore;
our %uniRegex;
our @AdminGroup;
our @AnalyzeLog;
our @ARINservers:shared;
our @changedConfig:shared;
our @currentCpuAffinity;
our @DBdriverdef:shared;
our @DBdriverNames ;
our @ExtWebAuth;
our @GroupList:shared;
our @LDAPGroup:shared;
our @PersBlackGroup:shared;
our @TLStoProxyI;
our @PossibleOptionFiles;
our @RealTimeLog;
our @StatSocket;
our @StatSocketI:shared;
our @WebSocket;
our @WebSocketI:shared;
our @backsctrlist:shared;
our @badattachRE;        #t
our @batv_secrets;
our @delayGroup:shared;
our @definedNameServers:shared;
our @localDMARCDomains:shared;
our @logCount:shared; # is locked
our @logFreq:shared;
our @lsn;
our @lsnI:shared;
our @lsn2;
our @lsn2I:shared;
our @lsnNoAUTH;
our @lsnNoTLSI;
our @lsnSSL;
our @lsnSSLI:shared;
our @lsnRelay;
our @lsnRelayI:shared;
our @msgid_secrets;
our @mlogS;
our @nameservers:shared ;
our @nolocalDMARCDomains:shared;
our @pbdbGroup:shared;
our @rbllist;
our @redlistGroup:shared;
our @rwllist;
our @spamdbGroup:shared;
our @sortedOIDs;
our @spamFolderContent:shared;
our @uribllist;
our @whitelistGroup:shared;
our @I; # the global IP match receiver ARRAY - unique in every thread (not shared),
our @HmmBayWords;
our @ProxySockets:shared;
our @WhitelistResult;

for my $t ([0,8,14,1,1,1],[2,4,5,5,7,13],[3,10,11,1,1,1],[1,5,6,9,12,1]) {
    $char4vt[$t->[0]] = do{my $r=1;$r*=$char4vt[$t->[$_]]for(1..5);$r;};
}

# list.dnsrw.org trust and category definitions
our %trusty = (
          0 => 'none',
          1 => 'low',
          2 => 'medium',
          3 => 'high'
);

our %categories = (
        '*' => 'all',
          0 => 'unknown',
          1 => 'unknown',
          2 => 'Financial services',
          3 => 'Email Service Providers',
          4 => 'Organisations',
          5 => 'Service/network providers',
          6 => 'Personal/private servers',
          7 => 'Travel/leisure industry',
          8 => 'Public sector/governments',
          9 => 'Media and Tech companies',
         10 => 'some special cases',
         11 => 'Education, academic',
         12 => 'Healthcare',
         13 => 'Manufacturing/Industrial',
         14 => 'Retail/Wholesale/Services',
         15 => 'Email Marketing Providers'
);

# Weighted Regexes

our $weightMatch;

our $bombReWLw;
our $bombReNPw;
our $bombReLocalw;
our $bombReISPIPw;
our $DoReversedWLw;
our $DoReversedNPw;
our $DoHeloWLw;
our $DoHeloNPw;

# end our global vars
our $setpro = 1;
#

# each ScheduleMap key needs the related global variable to be declared !
$ScheduleMap{'backupDBInterval'}          = &share([]); @{$ScheduleMap{'backupDBInterval'}}          = (3600,'nextDBBackup');
$ScheduleMap{'BlockReportSchedule'}       = &share([]); @{$ScheduleMap{'BlockReportSchedule'}}       = (24 * 3600,'nextBlockReportSchedule');
$ScheduleMap{'CleanCacheEvery'}           = &share([]); @{$ScheduleMap{'CleanCacheEvery'}}           = (3600,'nextCleanCache');
$ScheduleMap{'CleanDelayDBInterval'}      = &share([]); @{$ScheduleMap{'CleanDelayDBInterval'}}      = (   1,'nextCleanDelayDB');
$ScheduleMap{'CleanPBInterval'}           = &share([]); @{$ScheduleMap{'CleanPBInterval'}}           = (3600,'nextCleanPB');
$ScheduleMap{'exportInterval'}            = &share([]); @{$ScheduleMap{'exportInterval'}}            = (3600,'nextExport');
$ScheduleMap{'GroupsReloadEvery'}         = &share([]); @{$ScheduleMap{'GroupsReloadEvery'}}         = (  60,'NextGroupsReload');
$ScheduleMap{'LDAPcrossCheckInterval'}    = &share([]); @{$ScheduleMap{'LDAPcrossCheckInterval'}}    = (3600,'nextLDAPcrossCheck');
$ScheduleMap{'MaxFileAgeSchedule'}        = &share([]); @{$ScheduleMap{'MaxFileAgeSchedule'}}        = (24 * 3600,'nextFileAgeSchedule');
$ScheduleMap{'MaxLogAgeSchedule'}         = &share([]); @{$ScheduleMap{'MaxLogAgeSchedule'}}         = (24 * 3600,'nextLogAgeSchedule');
$ScheduleMap{'POP3Interval'}              = &share([]); @{$ScheduleMap{'POP3Interval'}}              = (  60,'NextPOP3Collect');
$ScheduleMap{'QueueSchedule'}             = &share([]); @{$ScheduleMap{'QueueSchedule'}}             = (24 * 3600,'nextQueueSchedule');
$ScheduleMap{'ReloadOptionFiles'}         = &share([]); @{$ScheduleMap{'ReloadOptionFiles'}}         = (   1,'nextOptionCheck',1,'nextHashFileCheck');
$ScheduleMap{'SaveStatsEvery'}            = &share([]); @{$ScheduleMap{'SaveStatsEvery'}}            = (  60,'NextSaveStats');
$ScheduleMap{'UpdateWhitelist'}           = &share([]); @{$ScheduleMap{'UpdateWhitelist'}}           = (   1,'saveWhite');
$ScheduleMap{'MemoryUsageCheckSchedule'}  = &share([]); @{$ScheduleMap{'MemoryUsageCheckSchedule'}}  = (   1,'nextMemoryUsageCheckSchedule');
$ScheduleMap{'ConsolidateWhitelistSched'} = &share([]); @{$ScheduleMap{'ConsolidateWhitelistSched'}} = (3600 * 24,'nextConsolidateWhitelist');

%ReportFiles = (
    'EmailSpam' => 'reports/spamreport.txt',
    'EmailHam' => 'reports/notspamreport.txt',
    'EmailWhitelistAdd' => 'reports/whitereport.txt',
    'EmailWhitelistRemove' => 'reports/whiteremovereport.txt',
    'EmailRedlistAdd' => 'reports/redreport.txt',
    'EmailRedlistRemove' => 'reports/redremovereport.txt',
    'EmailHelp' => 'reports/helpreport.txt',
    'EmailAnalyze' => 'reports/analyzereport.txt',
    'EmailSpamLoverAdd' => 'reports/slreport.txt',
    'EmailSpamLoverRemove' => 'reports/slremovereport.txt',
    'EmailNoProcessingAdd' => 'reports/npreport.txt',
    'EmailNoProcessingRemove' => 'reports/npremovereport.txt',
    'EmailBlackAdd' => 'reports/blackreport.txt',
    'EmailBlackRemove' => 'reports/blackremovereport.txt',
    'EmailPersBlackAdd' => 'reports/persblackreport.txt',
    'EmailPersBlackRemove' => 'reports/persblackremovereport.txt',
    'EmailVirusReportsToRCPT' => 'reports/virusreport.txt',
    'EmailSenderNotOK' => 'reports/denied.txt',
    'BlockRepForwHost' => 'reports/blockreportforwarderror.txt'
);

%ReportTypes = (
    'EmailSpam' => 0,
    'EmailHam' => 1,
    'EmailWhitelistAdd' => 2,
    'EmailWhitelistRemove' => 3,
    'EmailRedlistAdd' => 4,
    'EmailRedlistRemove' => 5,
    'EmailHelp' => 7,
    'EmailAnalyze' => 8,
    'EmailSpamLoverAdd' => 10,
    'EmailSpamLoverRemove' => 11,
    'EmailNoProcessingAdd' => 12,
    'EmailNoProcessingRemove' => 13,
    'EmailBlackAdd' => 14,
    'EmailBlackRemove' => 15,
    'EmailPersBlackAdd' => 16,
    'EmailPersBlackRemove' => 17,
);

%URIBLaddWeight = (

    'obfuscatedip'     => 0.99,
    'obfuscateduri'    => 0.99,
    'maximumuniqueuri' => 0.94,
    'maximumuri'       => 0.95

);

%webRequests=(
    '/lists' => \&ConfigLists,
    '/recprepl' => \&CheckRcptRepl,
    '/maillog' => \&ConfigMaillog,
    '/analyze' => \&ConfigAnalyze,
    '/infostats' => \&ConfigStats,
    '/edit' => \&ConfigEdit,
    '/shutdown' => \&Shutdown,
    '/shutdown_frame' => \&ShutdownFrame,
    '/shutdown_list' => \&ShutdownList,
    '/donations' => \&Donations,
    '/get' => \&GetFile,
    '/top10stats' => \&top10stats,
    '/pwd' => \&ChangeMyPassword,
    '/adminusers' => \&ManageAdminUsers,
    '/statusassp' => \&StatusASSP,
    '/remember' => \&remember,
    '/syncedit' => \&syncedit,
    '/addraction' => \&ConfigAddrAction,
    '/ipaction' => \&ConfigIPAction,
    '/statgraph' => \&ConfigStatsPlot,
    '/confgraph' => \&ConfigConfidencePlot,
    '/fc' => \&ConfigFC,
    '/remotesupport' => \&remoteSupport
);

$WorkerName = 'startup';
$logfile = $Config{logfile};     # set the log parms to preenable logging
$asspLog = $Config{asspLog};
$WorkerLogging = $Config{WorkerLogging};
$sysLog = $Config{sysLog};
$SysLogFac = $Config{SysLogFac};
$sysLogPort = $Config{sysLogPort};
$sysLogIp = $Config{sysLogIp};
$globalClientName = $Config{globalClientName};
$globalClientPass = $Config{globalClientPass};

&defineCanUseModules();

# if loaded - Win32::Unicode::File may return a different mtime (GMT) - set it again to be safe
$ModuleWatch{CorrectASSPcfg}->{filetime} = ftime("$base/lib/CorrectASSPcfg.pm") if $CanUseCorrectASSPcfg;

print "\t\t\t[OK]\nsetup regular expressions";
&setMakeREVars();
my $p;
$p = '-professional' if ($setpro && $globalClientName && $globalClientPass);
mlog(0,"ASSP$p version $version$modversion (Perl $]) (on $^O) initializing ");

print "\t\t\t\t[OK]\nloading plugins";
loadPluginConfig();           # load Configuration from Plugins to @ConfigArray

print "\t\t\t\t\t\t[OK]\nfixing up config";
syncLoadConfigFile();
fixConfigSettings();

mlog(0,"info: an ASSP restart will be done using the AutoRestartCmd") if $MaintenanceLog;
PrintConfigSettings() if ! SaveConfigSettings();
chmod 0660, "$base/assp.cfg";

# Notes on general operation & program structure
# I'm using IO::Poll or IO::Select, so don't make any changes that block for long
# as new connections come we create a pair of entries in a hash %Con
# based on the hash of the filehandle, so $Con{$fh} has data for this
# connection. $Con{$fh}->{friend} is the partner socket for the smtp proxy.
# ->{ip} is the ip address of the connecting client
# ->{relayok} tells if we can relay mail for this client
# ->{getline} is a pointer to a function that should be called whan a line of input is received for this filehandle
# ->{mailfrom} is the envelope sender (MAIL FROM: <address>)
# ->{outgoing} is a buffer for outgoing socket traffic (see $writable & &sendque)
# ->{rcpt} are the addresses from RCPT TO: <address> (space separated)
# ->{header} is where the complete mail data are stored
# ->{myheader} is where we store our header, we merge it with client's header later
# ->{maillog} if present stream logging is enabled
# ->{maillogbuf} buffer for storing unwritten stream log while waiting for isspam decision
# ->{maillogfh} is the filehandle for logging lines to the maillog
# ->{mailloglength} is the length logged so far (we stop after 10000 bytes)
# ->{spamfound} is a flag used to signal if an email is determined to be spam.
# ->{maillength} is the same as mailloglength but is not reset.
#
# After connection the {getline} field functions like a state machine
# redirecting input to subsequent handlers
#
# whitebody -> getline
#   getbody ->
#     error -> (disconnects)
#     getline -> getheader ->
#       whitebody -> getline
#         error -> (disconnects)
#
# getline looks for MAIL FROM, RCPT TO, RSET
# getheader looks for a blank line then tests for whitelist / spamaddresses
# getbody looks for the . and calls isspam, the Bayesian spam test
# whitebody waits for . and redirects client to server
# error waits for . ignoring data from client (and finishes the maillog)
#
# the server has states like this:
#
# skipok -> reply
#
# skipok traps the 250 ok response from the NOOP Connection from
# reply echos server messages to the client
# reply also looks for a 235 AUTH OK and sets {relayok}=1

if ($AsADaemon) {
    print "\nstarting as daemon\t\t\t[OK]\n";
    fork() && exit 0;
    print "forked a new silent process\t\t[OK]\n";
    open($SAVEOUT, '>&' ,\*STDOUT);
    open($SAVEERR, '>&' ,\*STDERR);
    STDOUT->close;
    STDERR->close;
    $silent=1;
}

if ($AsAService) {
    open($SAVEOUT, '>&' ,STDOUT);
    open($SAVEERR, '>&' ,STDERR);
    STDOUT->close;
    STDERR->close;
    $silent=1;
}

my $logdir;
$logdir = $1 if $logfile=~/(.*)\/[^\/]*/o;
-d "$base/$logdir" or mkdirOP("$base/$logdir",'0755') if $logdir;

# if we need to change anything in the ConfigArray
sub changeConfigDescription {
    $ConfigArray[$ConfigPos{ExportMysqlDB}]->[7] =~ s/\$dftExpSec/$dftExpSec/;
}

&init();

&sigCentralSet();
$SIG{INT}=sub {mlog(0,'sig INT'); &downASSP('got SIG INT'); exit 1;};
$SIG{TERM}=sub {mlog(0,'sig TERM'); &downASSP('got SIG TERM'); exit 1;};
$SIG{HUP}=sub {mlog(0,'sig HUP'); &reloadConfigFile();};
$SIG{USR1}=sub {mlog(0,'sig USR1'); &saveSMTPconnections();} if exists $SIG{USR1};
$SIG{USR2}=sub {mlog(0,'sig USR2'); &SaveConfigSettingsForce();} if exists $SIG{USR2};
$SIG{NUM07}=sub {$allIdle -= 2 if $allIdle == defined *{'yield'};$allIdle += defined *{'yield'} if $allIdle == 0; mlog(0,($allIdle > 0 ? 'assp suspened' : 'assp resumed'));} if exists $SIG{NUM07};
$SIG{PIPE} = 'IGNORE';
#foreach my $k (sort keys %SIG) {
#    mlog(0,"SIG $k = $SIG{$k}");
#}
&niceConfigPos();
&niceConfig();
&changeConfigDescription();
&renderConfigHTML();
$lastTimeoutCheck = time;
$PerfStartTime = time;
$syncToDo = 1;
for my $s (sort keys %Recommends) {
    mlog(0,"$s: $Recommends{$s}");
}
$WorkerName = 'Main_Thread';
unloadMainThreadModules() if $undefMEM;
&ThreadMonitorMainLoop('MainLoop initialized');
$ComWorker{main} = 1;
mlog(0,'MainThread started');
MLOOP:
eval {
    while(1) {
        my $t = &MainLoop(1);
    }
};
if ($@) {
    my $error = $@;
    my $exmsg = "main exception: $error\n";
    writeExceptionLog("$exmsg");
    goto MLOOP if $error =~ /Malformed UTF-?8 character/io;
    print $LOG "$exmsg\n" if fileno($LOG);
    &downASSP('try restarting ASSP on exception');
    &_assp_try_restart();
}

# END_OF_MAIN_CODE
# there is no main code behind here - subs and packages only

#####################################################################################
# the rebuild spamdb module
#####################################################################################

sub write_rebuild_module {
my $curr_version = shift;

my $rb_version = '8.24';
my $keepVersion;

if (open my $ADV, '<',"$base/lib/rebuildspamdb.pm") {
    while (<$ADV>) {
        if (/^\s*our \$VERSION.+?(\d\.\d+)/o) {
            $curr_version = $1;
            $ComWorker{$WorkerNumber}->{rb_version} = $1;
            last;
        }
        $keepVersion = 1 if /keepVersion/o;
    }
    $ADV->close;
    mlog(0,"info: found module $base/lib/rebuildspamdb.pm version $curr_version");
}

if ($keepVersion) {
    mlog(0,"info: the current $base/lib/rebuildspamdb.pm contains a 'keepVersion' line - this file will be keeped");
    return 1;
}

if ($curr_version gt $rb_version && ! $forceRebuildDowngrade) {
    mlog(0,"warning: keeping module $base/lib/rebuildspamdb.pm at version $curr_version (version $rb_version should be used), because 'forceRebuildDowngrade is 0'");
    return 1;
} elsif ($curr_version gt $rb_version && $forceRebuildDowngrade) {
    mlog(0,"info: downgrading module $base/lib/rebuildspamdb.pm from version $curr_version to version $rb_version, because 'forceRebuildDowngrade is 1'");
} elsif ($curr_version lt $rb_version) {
    mlog(0,"info: upgrading module $base/lib/rebuildspamdb.pm from version $curr_version to version $rb_version");
}

(open my $ADV, '>',"$base/lib/rebuildspamdb.pm") or return 0;
#print $ADV <<'RBEOT' or return 0;
#package rebuildspamdb; # RBEOT;

#RBEOT

print $ADV 'our $VERSION = ',"'$rb_version';\n\n";

#print $ADV <<'RBEOT';
rb_mlog("info: rebuildspamdb module version ".${'VERSION'}." loaded");

# rebuildspamdb version 2
# rebuilds bayesian spam and HMM database
# (c) John Hanna 2003 under the terms of the GPL
# Updated July 2004 for simple proxy support.
# (c) Fritz Borgstedt 2006 under the terms of the GPL
# Updated Feb 2008 refactoring and rewrites
# (c) Kevin 2008 under the terms of the GPL
# Updated Jul 2008 refactoring and rewrites to built-in as package in ASSP
# and integrated move2num
# (c) Thomas Eckardt since 2008 under the terms of the GPL

use strict qw(vars subs);
no utf8;
use Digest::MD5 qw(md5_hex);
use File::Copy;
use IO::Handle;
use IO::Socket();
use Encode;
use Storable();
no warnings;

our $RebuildLog;
our $RebuildDebug;
our $norm;
our $starttime;
our $processTime;
our $processedBytes;
our $scanTime;
our $scanFiles;
our %spam;
our %newspam;
our %Helo;
our %HamHash;
our %SpamHash;
our %HMMres;
our %GpCnt;
our %GpOK;
our $HMMIgnored;
our $bayesIgnored;
our %Trashlist;
our $spamObj;
our $newspamObj;
our $HeloObj;
our $HamHashObj;
our $HMMresObj;
our $SpamHashObj;
our $GpCntObj;
our $GpOKObj;
our $TrashlistObj;
our $SpamWordCount;
our $HamWordCount;
our $Iam;
our $BDBEnv;
our $DBDir;
our $WhiteCount;
our $RedCount;
our $onlyNewCorrected;
our $IPRe = $main::IPRe;
our $UTF8BOMRE = $main::UTF8BOMRE;
our $spamHMM;
our $hamHMM;
our $DoHMM;
our $haveRedlist;
our $initcount;
our $attachments;
our $rtText;
our $mintime;
our $movetime;
our $doattach;
our $CanUseUnicodeNormalize = $main::CanUseUnicodeNormalize && require Unicode::Normalize;
our $PortRe = $main::PortRe;
our $disclaimerRe;
our $disclaimerCount;
our $canWLAddr = $main::DKIMWLAddressesRE !~ /$main::neverMatchRE/o;
our $canNPAddr = $main::DKIMNPAddressesRE !~ /$main::neverMatchRE/o;
our $MyName = join('|', map {my $t = quotemeta($_);$t;} ($main::myName, split(/[\|, ]+/o,$main::myNameAlso)));
our $FileModel;
our $FileModelObj;
our $RebuildUsesFileModel = $main::RebuildUsesFileModel;
our %tmp;
our $tmpObject;

sub rb_run {         ## no critic
no warnings;
$onlyNewCorrected = shift;

if ($main::canUnicode && $main::isWIN) {require Win32::Unicode;}

rb_undefVars();

$SpamWordCount = 0;
$HamWordCount = 0;
$HMMIgnored = 0;
$bayesIgnored = 0;
$starttime = 0;
$processTime = 0;
$processedBytes = 0;
$scanTime = 0;
$scanFiles = 0;

$WhiteCount = 0;
$RedCount = 0;
$attachments = 0;

$DoHMM = $main::DoHMM;
$doattach = 0;
$doattach = 1 if    $main::Config{ASSP_AFCDetectSpamAttachRe}
                 && $main::ASSP_AFCDetectSpamAttachReRE !~ $main::neverMatchRE;
($mintime,$movetime) = split(/(?:\s+|,)/o,$main::RebuildFileTimeLimit,2);
$mintime =~ s/\s//go;
$movetime =~ s/\s//go;
$mintime ||= 0;
$movetime ||= 0;
$haveRedlist = &main::getDBCount('main::Redlist','main::redlistdb');
$initcount = int(&main::getDBCount('main::HMMdb','main::spamdb') / 2);   # preallocate hash/HMM-chain buckets

$RebuildDebug = $main::eF->("$main::base/rebuilddebug.txt");
$RebuildDebug = 0 if $onlyNewCorrected;

my (@dbhint, $have_error);

if ($main::eF->("$main::base/files/disclaimer.txt")) {
    $disclaimerRe = undef;
    if ($main::open->(my $file, '<', "$main::base/files/disclaimer.txt" )) {
        $file->binmode;
        $file->read( $disclaimerRe, &main::fsize("$main::base/files/disclaimer.txt") );
        eval{$file->close;};
    }
    if ($disclaimerRe) {
        $disclaimerRe =~ s/^(?:$UTF8BOMRE)?\s*//os;
        $disclaimerRe =~ s/^\s*#.*//go;
        $disclaimerRe =~ s/([^\r])\n/$1\r\n/gos;
        $disclaimerRe =~ s/^\s+$//os;
    }
    if ($disclaimerRe) {
        my @dispart = split(/\r\n\.\r\n/os,$disclaimerRe);
        my $OK;
        my @text;
        for my $re (@dispart) {
            $re =~ s/^\s+//os;
            $re =~ s/\s+$//os;
            if ($re) {
                $re = "Content-Type: text/plain; charset=\"utf-8\"\r\nContent-Transfer-Encoding: 8bit\r\nMime-Version: 1.0\r\n\r\n".$re."\r\n.\r\n";
                my $text;
                ($text,$OK) = &main::clean(\$re);
                $text =~ s/^\s*helo:\s*//os;
                $text =~ s/([\{\}\[\]\(\)\?\*\+\\\/\$\%\&\@\#\!\^])/\\$1/go;
                push @text , $text if $text;
            }
        }
        if (@text) {
            $disclaimerRe = '[\b\s](?:'.join('|',@text).')';
            $disclaimerRe = eval{qr/$disclaimerRe/;};
            if ($@) {
                $disclaimerRe = undef;
                push @dbhint ,  "error: wrong disclaimerRe - $@";
            } else {
                if ($main::open->(my $file, '>', "$main::base/files/optRE/disclaimer.txt" )) {
                    $file->binmode;
                    print $file $disclaimerRe;
                    eval{$file->close;};
                }
                push @dbhint, "detection of local disclaimers is enabled";
            }
        } else {
            $disclaimerRe = undef;
        }
    }
}

if ($RebuildDebug) {
    open($RebuildDebug ,'>',  "$main::base/rebuilddebug.txt" );
    binmode $RebuildDebug;
    $RebuildDebug->autoflush(1);
    print $RebuildDebug $main::UTF8BOM;
    rb_mlog("rebuild debug output is enabled to $main::base/rebuilddebug.txt");
    push @dbhint , "-rebuild debug output is enabled to $main::base/rebuilddebug.txt";
}

eval (<<'EOT') if ($main::CanUseASSP_WordStem);
    use ASSP_WordStem();
    $ASSP_WordStem::logging = 0;
EOT
    $DBDir = "$main::base/tmpDB/rebuildDB";
    $Iam = $main::WorkerNumber;
    -d $DBDir or &main::mkdirOP($DBDir,'0755');

    if ($main::CanUseBerkeleyDB && $main::useDB4Rebuild) {
        eval('use BerkeleyDB;');
        if ($main::VerBerkeley lt '0.42') {
            *{'BerkeleyDB::_tiedHash::CLEAR'} = *{'main::BDB_CLEAR'};
        }
        my $cachesize = 0;
        for (&main::Glob("$DBDir/*.bdb")) { $cachesize += -s $_ }
        $cachesize = &main::min(($main::BDBMaxCacheSize || 50*1024*1024), 200*1024*1024, &main::max($cachesize,($DoHMM ? 41943040 : 20971520)));
        rb_mlog("RebuildSpamDB uses BerkeleyDB for temporary hashes");
        push @dbhint , "-RebuildSpamDB uses BerkeleyDB for temporary hashes";
        rb_mlog("RebuildSpamDB uses BerkeleyDB-ENV with ".&main::formatNumDataSize(int($cachesize * 1.25)));
        push @dbhint , "-RebuildSpamDB uses BerkeleyDB-ENV with ".&main::formatNumDataSize(int($cachesize * 1.25));
        unlink "$DBDir/__db.001";
        unlink "$DBDir/__db.002";
        unlink "$DBDir/__db.003";
        unlink "$DBDir/BDB-error.txt";
        if (! $onlyNewCorrected) {
            unlink "$DBDir/rb_spam.bdb";
            unlink "$DBDir/rb_Helo.bdb";
        }
eval (<<'EOT');
            $main::lastd{$Iam} = "building BerkeleyDB ENV";
            $BDBEnv = BerkeleyDB::Env->new(-Flags => DB_CREATE | DB_INIT_MPOOL ,
                                           -Cachesize => $cachesize ,
                                           -Home    => "$DBDir",
                                           -ErrFile => ($main::BDBerrLog ? "$DBDir/BDB-error.txt" : undef),
                                           -Config  => {DB_DATA_DIR => "$DBDir",
                                                        DB_LOG_DIR  => "$DBDir",
                                                        DB_TMP_DIR  => "$DBDir"}
                                          );
            die("can't create BDB-ENV for rebuild - see $DBDir/BDB-error.txt\n") if (! $BDBEnv || &main::BDB_error());

            $main::lastd{$Iam} = "mounting BerkeleyDB $DBDir/rb_spam.bdb";
            $spamObj=tie %spam,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/rb_spam.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);
            rb_BDB_getRecordCount('spam');

            $main::lastd{$Iam} = "mounting BerkeleyDB $DBDir/rb_newspam.bdb";
            $newspamObj=tie %newspam,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/rb_newspam.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);

            $main::lastd{$Iam} = "mounting BerkeleyDB $DBDir/rb_Helo.bdb";
            $HeloObj=tie %Helo,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/rb_Helo.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);
            rb_BDB_getRecordCount('Helo');

            $main::lastd{$Iam} = "mounting BerkeleyDB $DBDir/rb_HamHash.bdb";
            $HamHashObj=tie %HamHash,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/rb_HamHash.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);

            $main::lastd{$Iam} = "mounting BerkeleyDB $DBDir/rb_SpamHash.bdb";
            $SpamHashObj=tie %SpamHash,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/rb_SpamHash.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);

            $main::lastd{$Iam} = "mounting BerkeleyDB $DBDir/rb_GpCnt.bdb";
            $GpCntObj=tie %GpCnt,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/rb_GpCnt.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);

            $main::lastd{$Iam} = "mounting BerkeleyDB $DBDir/rb_GpOK.bdb";
            $GpOKObj=tie %GpOK,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/rb_GpOK.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);

            $main::lastd{$Iam} = "mounting BerkeleyDB $DBDir/trashlist.bdb";
            $TrashlistObj=tie %Trashlist,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/trashlist.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);
            rb_BDB_getRecordCount('Trashlist') == 0 && rb_Load_Trashlist();

            $main::lastd{$Iam} = "mounting BerkeleyDB $DBDir/rb_HMMres.bdb";
            $HMMresObj=tie %HMMres,'BerkeleyDB::Hash',
                                     (-Filename => "$DBDir/rb_HMMres.bdb" ,
                                      -Flags => DB_CREATE,
                                      -Env => $BDBEnv);

            if ($RebuildUsesFileModel) {
                $main::lastd{$Iam} = "mounting BerkeleyDB $DBDir/FileModel.bdb";
                $FileModelObj=tie %$FileModel,'BerkeleyDB::Hash',
                                         (-Filename => "$DBDir/FileModel.bdb" ,
                                          -Flags => DB_CREATE,
                                          -Env => $BDBEnv);
                $FileModelObj->filter_fetch_value( sub { defined $_ && ($_ = ${Storable::thaw($_)}) } );
                $FileModelObj->filter_store_value( sub { defined $_ && ($_ = Storable::nfreeze(\$_)) } );

                if (exists $FileModel->{Version} && $FileModel->{Version} ne $main::requiredDBVersion{Spamdb}) {
                    rb_mlog("RebuildSpamDB uses the internal FileModel (BDB) to speedup processing - because of a version mismatch, a new FileModel will be created ($main::requiredDBVersion{Spamdb}), this will take some more time");
                    push @dbhint , "-RebuildSpamDB uses the internal FileModel (BDB) to speedup processing - because of a version mismatch, a new FileModel will be created ($main::requiredDBVersion{Spamdb}), this will take some more time";
                    rb_deleteFileModel();
                } else {
                    my $c = rb_maintFileModel();
                    rb_mlog("RebuildSpamDB reloaded and uses the internal FileModel (BDB with $c entries) to speedup processing");
                    push @dbhint , "-RebuildSpamDB reloaded and uses the internal FileModel (BDB with $c entries) to speedup processing";
                }
            }
EOT
            if ($@ || &main::BDB_error()) {
                rb_mlog("BerkeleyDB-ERROR: in $main::lastd{$Iam} - $@ - BDB:$BerkeleyDB::Error");
                push @dbhint , "-BerkeleyDB-ERROR: in $main::lastd{$Iam} - $@ - BDB:$BerkeleyDB::Error";
                $have_error = 1;
            }
            %HMMres = ();
    } elsif ($main::CanUseDB_File && $main::useDB4Rebuild) {
        eval('use DB_File;');
        rb_mlog("RebuildSpamDB uses DB_File for temporary hashes - the FileModel is not available using DB_File!");
eval (<<'EOT');
        $spamObj = tie %spam, 'DB_File', "$DBDir/rb_spam.bdb";
        $newspamObj = tie %newspam, 'DB_File', "$DBDir/rb_newspam.bdb";
        $HeloObj = tie %Helo, 'DB_File', "$DBDir/rb_Helo.bdb";
        $HamHashObj = tie %HamHash, 'DB_File', "$DBDir/rb_HamHash.bdb";
        $SpamHashObj = tie %SpamHash, 'DB_File', "$DBDir/rb_SpamHash.bdb";
        $GpCntObj = tie %GpCnt, 'DB_File', "$DBDir/rb_GpCnt.bdb";
        $GpOKObj = tie %GpOK, 'DB_File', "$DBDir/rb_GpOK.bdb";
        $TrashlistObj = tie %Trashlist,'DB_File', "$DBDir/trashlist.bdb";
        scalar(keys %Trashlist) == 0 && rb_Load_Trashlist();
EOT
        if ($@) {
            rb_mlog("DB_File-ERROR: $@");
            push @dbhint , "-DB_File-ERROR: $@";
            $have_error = 1;
        }
    } elsif ($main::useDB4Rebuild) {
        rb_mlog("RebuildSpamDB - using the internal 'orderedtie' for temporary hashes is no longer supported");
        push @dbhint , "warning: 'useDB4Rebuild' is set to on, but 'BerkeleyDB' nor 'DB_File' are available - using the internal 'orderedtie' for temporary hashes is no longer supported";
eval (<<'EOT');
        die "using the internal 'orderedtie' in rebuildspamdb for temporary hashes is no longer supported - configure 'BerkeleyDB' to be used, or switch off 'useDB4Rebuild'\n";

        $spamObj = tie %spam, 'orderedtie', "$DBDir/rb_spam.bdb";
        $newspamObj = tie %newspam, 'orderedtie', "$DBDir/rb_newspam.bdb";
        $HeloObj = tie %Helo, 'orderedtie', "$DBDir/rb_Helo.bdb";
        $HamHashObj = tie %HamHash, 'orderedtie', "$DBDir/rb_HamHash.bdb";
        $SpamHashObj = tie %SpamHash, 'orderedtie', "$DBDir/rb_SpamHash.bdb";
        $GpCntObj = tie %GpCnt, 'orderedtie', "$DBDir/rb_GpCnt.bdb";
        $GpOKObj = tie %GpOK, 'orderedtie', "$DBDir/rb_GpOK.bdb";
        $TrashlistObj = tie %Trashlist,'orderedtie', "$DBDir/trashlist.bdb";
        scalar(keys %Trashlist) == 0 && rb_Load_Trashlist();
EOT
        if ($@) {
            push @dbhint , "-orderedtie-ERROR: $@";
            rb_mlog("orderedtie-ERROR: $@");
            $have_error = 1;
        }
    } else {
        $TrashlistObj = undef;
        rb_Load_Trashlist();
        push @dbhint , "info: 'useDB4Rebuild' is NOT set to on - the rebuild spamdb process will possibly require a large amount of memory - but it will run very fast!";

        if ($RebuildUsesFileModel) {
            my $memFM = &main::memoryUsage();
            rb_mlog("try to load the internal FileModel from file $DBDir/FileModel.store into memory to speedup processing");
            eval{ $FileModel = Storable::retrieve("$DBDir/FileModel.store") if $main::eF->("$DBDir/FileModel.store") };
            if ($@) {
                rb_mlog("ERROR loading the internal FileModel to speedup processing - $@");
                push @dbhint , "-ERROR loading the internal FileModel to speedup processing - $@";
                $RebuildUsesFileModel = 0;
                $main::unlink->("$DBDir/FileModel.store");
                rb_deleteFileModel();
            } else {
                if (exists $FileModel->{Version} && $FileModel->{Version} ne $main::requiredDBVersion{Spamdb}) {
                    rb_mlog("RebuildSpamDB uses the internal FileModel to speedup processing - because of a version mismatch, a new FileModel will be created ($main::requiredDBVersion{Spamdb}), this will take some more time");
                    push @dbhint , "-RebuildSpamDB uses the internal FileModel to speedup processing - because of a version mismatch, a new FileModel will be created ($main::requiredDBVersion{Spamdb}), this will take some more time";
                    rb_deleteFileModel();
                } else {
                    my $c = rb_maintFileModel();
                    rb_mlog("RebuildSpamDB reloaded and uses the internal FileModel (with $c entries) to speedup processing");
                    push @dbhint , "-RebuildSpamDB reloaded and uses the internal FileModel (with $c entries) to speedup processing";
                }
            }
            $memFM = int(&main::memoryUsage() - $memFM);
            if ($memFM > 10) {
                $memFM = &main::formatNumDataSize($memFM);
                rb_mlog("RebuildSpamDB allocated additional $memFM of RAM to load the internal FileModel");
                push @dbhint , "-RebuildSpamDB allocated additional $memFM of RAM to load the internal FileModel";
            }
        }

    }

    if ($DoHMM && $main::CanUseBerkeleyDB && $main::useDB4Rebuild) {
        if (! $onlyNewCorrected) {
            unlink "$DBDir/rbtmp.hamHMM.bdb";
            unlink "$DBDir/rbtmp.spamHMM.bdb";
            unlink "$DBDir/rbtmp.hamHMM.totals.bdb";
            unlink "$DBDir/rbtmp.spamHMM.totals.bdb";
        }
        if ($onlyNewCorrected ||
           (   ! $onlyNewCorrected
            && ! -e "$DBDir/rbtmp.hamHMM.bdb"
            && ! -e "$DBDir/rbtmp.spamHMM.bdb"
            && ! -e "$DBDir/rbtmp.hamHMM.totals.bdb"
            && ! -e "$DBDir/rbtmp.spamHMM.totals.bdb"))
        {
            $@ = '';
            eval (<<'EOT');
                $main::lastd{$Iam} = "mounting BerkeleyDB $DBDir/rbtmp.hamHMM";
                $hamHMM  = ASSP::MarkovChain->new(longest => $main::HMMSequenceLength,
                                                  shortest => $main::HMMSequenceLength,
                                                  top => 0,
                                                  nostarts => 1,
                                                  BDB => {-Filename => "$DBDir/rbtmp.hamHMM" ,
                                                          -Flags => DB_CREATE
                                                          -Env => $BDBEnv}
                                                  );
                $main::lastd{$Iam} = "mounting BerkeleyDB $DBDir/rbtmp.spamHMM";
                $spamHMM = ASSP::MarkovChain->new(longest => $main::HMMSequenceLength,
                                                  shortest => $main::HMMSequenceLength,
                                                  top => 0,
                                                  nostarts => 1,
                                                  BDB => {-Filename => "$DBDir/rbtmp.spamHMM" ,
                                                          -Flags => DB_CREATE
                                                          -Env => $BDBEnv}
                                                  ) if ref $hamHMM;
EOT
            unless (ref $hamHMM && ref $spamHMM) {
                my $error;
                $error =  " - e: $@" if $@;
                $error .= " - h: $hamHMM" if $hamHMM && ! ref $hamHMM;
                $error .= " - s: $spamHMM" if $spamHMM && ! ref $spamHMM;
                push @dbhint , "error: can't create HMM because of BDB database errors ($DBDir) - $error";
                $DoHMM = 0 ;
                $hamHMM = undef;
                $spamHMM = undef;
            }
        } else {
            push @dbhint , "error: can't cleanup at least one old temporary BDB file used for HMM in $DBDir/ 'rbtmp.hamHMM.bdb , rbtmp.spamHMM.bdb , rbtmp.hamHMM.totals.bdb, rbtmp.spamHMM.totals.bdb'";
        }
        unless (ref $hamHMM && ref $spamHMM) {
            $DoHMM = 0 ;
            $hamHMM = undef;
            $spamHMM = undef;
        }
    } else {         # all in memory (no DB)
        if ($DoHMM) {
            if (! $onlyNewCorrected) {
                unlink "$DBDir/rbtmp.hamHMM.chains";
                unlink "$DBDir/rbtmp.spamHMM.chains";
                unlink "$DBDir/rbtmp.hamHMM.totals";
                unlink "$DBDir/rbtmp.spamHMM.totals";
            }
            $@ = '';
            eval (<<'EOT');
                $main::lastd{$Iam} = "loading model from $DBDir/rbtmp.hamHMM into memory";
                $hamHMM  = ASSP::MarkovChain->new(longest => $main::HMMSequenceLength,
                                                  shortest => $main::HMMSequenceLength,
                                                  top => 0,
                                                  nostarts => 1,
                                                  initcount => $initcount,
                                                  File => "$DBDir/rbtmp.hamHMM" ,
                                                  );
                $main::lastd{$Iam} = "loading model from $DBDir/rbtmp.spamHMM into memory";
                $spamHMM = ASSP::MarkovChain->new(longest => $main::HMMSequenceLength,
                                                  shortest => $main::HMMSequenceLength,
                                                  top => 0,
                                                  nostarts => 1,
                                                  initcount => $initcount,
                                                  File => "$DBDir/rbtmp.spamHMM" ,
                                                  ) if ref $hamHMM;
EOT
            if (! (ref $hamHMM && ref $spamHMM)) {
                my $error;
                $error =  " - e: $@" if $@;
                $error .= " - h: $hamHMM" if $hamHMM && ! ref $hamHMM;
                $error .= " - s: $spamHMM" if $spamHMM && ! ref $spamHMM;
                push @dbhint , "error: can't create HMM because of Storable errors ($DBDir) - $error";
                $DoHMM = 0 ;
                $hamHMM = undef;
                $spamHMM = undef;
            } else {
                # preallocate memory for HMM result hash
                keys %HMMres = $initcount * 2 unless $onlyNewCorrected;
            }
        }
        if (! $main::useDB4Rebuild && ! $onlyNewCorrected ) {
            # preallocate memory for other hashes
            my $c;
            $c = rb_powerofftwo(&main::getDBCount('main::Spamdb','main::spamdb'));
            keys %spam = $c;
            keys %newspam = $c;

            keys %HamHash = $main::MaxFiles;
            keys %SpamHash = $main::MaxFiles;

            $c = rb_powerofftwo(&main::getDBCount('main::HeloBlack','main::spamdb'));
            keys %Helo = $c;
        }
    }

    # reset counts and global vars
    $HamWordCount = $SpamWordCount = my $correctedspamcount = 0;
    my $correctednotspamcount = my $spamlogcount  = my $notspamlogcount = 0;
    my $rebuildrun = &rb_fixPath($main::base) . "/rebuildrun.txt";

    $RebuildLog = $norm = $starttime = $processTime = '';

    if ($onlyNewCorrected && ! $have_error) {         # only still new reported
        my ($havenormfile,$SwordsPfile, $HwordsPfile);
        %spam = ();
        if (open( my $normFile, '<', "$main::base/normfile" )) {
            binmode $normFile;
            ($norm, $correctedspamcount, $correctednotspamcount, $spamlogcount, $notspamlogcount,
             $SwordsPfile, $HwordsPfile, $SpamWordCount, $HamWordCount) = split(/\s+/o, join('',<$normFile>));
            $havenormfile = $SpamWordCount > 0 || $HamWordCount > 0;
            $normFile->close;
        }
        $norm ||= $main::bayesnorm || $main::Spamdb{'***bayesnorm***'};
        $norm ||= $main::HMMdb{'***bayesnorm***'} if $DoHMM;
        $norm ||= 1;
        my $oldnorm = $norm;
        
        rb_processNewCorrected();

        if ($havenormfile) {
            $main::bayesnorm = $main::Spamdb{'***bayesnorm***'} = $norm = $HamWordCount ? ( $SpamWordCount / $HamWordCount ) : 100;
            $main::HMMdb{'***bayesnorm***'} = $norm if $DoHMM;
            &rb_mlog('info: the corpus norm is changed from: '.sprintf("%.4f",$oldnorm).' - to: '.sprintf("%.4f",$norm)) if sprintf("%.4f",$oldnorm) != sprintf("%.4f",$norm);
            (open( my $normFile, '>', "$main::base/normfile" ));
            if ($normFile) {
                print { $normFile } "$norm $correctedspamcount $correctednotspamcount $spamlogcount $notspamlogcount $SwordsPfile $HwordsPfile $SpamWordCount $HamWordCount";
                eval{$normFile->close;};
            }
        }
    } elsif (! $have_error) {                         # the normal rebuild

    if ($main::useDB4Rebuild) {  # clean hashes if tied to any DB - otherwise they are still clean
        %spam = ();
        %newspam = ();
        %Helo = ();
        %HamHash = ();
        %SpamHash = ();
        %GpCnt = ();
        %GpOK = ();
    }

    # open log file
    if ( -e "$rebuildrun.bak" ) {
        unlink("$rebuildrun.bak") or die "unable to remove file: $!";
    }
    if ( -e $rebuildrun ) {
        copy( $rebuildrun, "$rebuildrun.bak" ) or die "unable to copy file for: $!";
    }
    (open( $RebuildLog, '>', "$rebuildrun" )) or die "unable to open file for logging: $!";
    binmode $RebuildLog;
    $RebuildLog->autoflush(1);
    print $RebuildLog $main::UTF8BOM;
    $starttime = time;
    &rb_printlog( "\n\n\nRebuildSpamDB-thread rebuildspamdb-version ".${'VERSION'}." started in ASSP version $main::version$main::modversion\n" );
    &rb_mlog( "RebuildSpamDB-thread rebuildspamdb-version ".${'VERSION'}." started in ASSP version $main::version$main::modversion");
    while (@dbhint) {
        my $t = shift @dbhint;
        &rb_mlog( $t ) unless $t =~ s/^\-//o;
        &rb_printlog( "\n$t\n" );
    }
    if ($main::RebuildTestMode) {
        &rb_printlog( "\n***** RebuildSpamDB is running in TEST MODE *****\n" );
        &rb_mlog( "***** RebuildSpamDB is running in TEST MODE *****" );
    }
    if ($DoHMM) {
        &rb_printlog( "\nRebuildSpamDB will create a Hidden Markov Model\n" );
        &rb_mlog( "RebuildSpamDB will create a Hidden Markov Model" );
    } else {
        &rb_printlog( "\nRebuildSpamDB will NOT create a Hidden Markov Model\n" );
        &rb_mlog( "RebuildSpamDB will NOT create a Hidden Markov Model" );
    }
    if ($doattach) {
        &rb_printlog( "\nRebuildSpamDB will include attachment-database-entries into spamdb\n" );
        &rb_mlog( "RebuildSpamDB will include attachment-database-entries into spamdb" );
    }
    if ($main::canUnicode) {
        &rb_printlog( "\nRebuildSpamDB will create unicode enabled databases\n" );
        &rb_mlog( "RebuildSpamDB will create unicode enabled databases" );
    }
    if ($main::CanUseUnicodeGCString) {
        &rb_printlog( "\nRebuildSpamDB will process all words as Sequence of UAX #29 Grapheme Clusters\n" );
        &rb_mlog( "RebuildSpamDB will process all words as Sequence of UAX #29 Grapheme Clusters" );
    }
    if ($main::normalizeUnicode && $CanUseUnicodeNormalize) {
        &rb_printlog( "\nRebuildSpamDB will NFKC normalize unicode characters\n" );
        &rb_mlog( "RebuildSpamDB will normalize unicode characters" );
    }
    if ($main::CanUseASSP_WordStem) {
        &rb_printlog( "\nRebuildSpamDB will use the ASSP_WordStem engine\n" );
        &rb_mlog( "RebuildSpamDB will use the ASSP_WordStem engine" );
    }
    &rb_printlog("\n---ASSP Settings---\n");
    if ($main::DoPrivatSpamdb) {
        my $text = ($main::DoPrivatSpamdb == 1) ? 'users email addresses only.'
                 : ($main::DoPrivatSpamdb == 2) ? 'each local domain.'
                 : 'users email addresses and each local domain.';
        &rb_printlog("\nRebuildSpamDB will create private spamdb entries for $text\n\n");
        &rb_mlog("RebuildSpamDB will create private spamdb entries for $text.");
    }
    if ($main::DoNotCollectRedList) {
        &rb_printlog(
            "Do Not Collect Messages with RedListed address: Enabled\n**Messages with RedListed addresses will be removed from the corpus!**\n\n"
          );
    }
    if ($main::DoNotCollectRedRe) {
        &rb_printlog(
            "Do Not Collect RedRe Messages: Enabled\n**Messages matching the RedRe will be removed from the corpus!**\n\n");
    }
    if ($main::UseSubjectsAsMaillogNames) {
        &rb_printlog("Use Subject as Maillog Names: True\n");
    } else {
        &rb_printlog("Use Subject as Maillog Names: False\n");
    }
    &rb_printlog("Maxbytes: ".&rb_commify($main::MaxBytes)." \n");
    &rb_mlog("Maxbytes: ".&rb_commify($main::MaxBytes));
    &rb_printlog("Maxfiles: ".&rb_commify($main::MaxFiles)." \n");
    &rb_mlog("Maxfiles: ".&rb_commify($main::MaxFiles));

    &rb_printlog("RebuildFileTimeLimit: $main::RebuildFileTimeLimit \n");
    &rb_mlog("RebuildFileTimeLimit: $main::RebuildFileTimeLimit");

    if ($movetime) {
        &rb_printlog("RebuildFileTimeLimit: files will be moved away from the corpus if their processing takes longer than $movetime second(s) \n");
        &rb_mlog("RebuildFileTimeLimit: files will be moved away from the corpus if their processing takes longer than $movetime second(s)");
    }

    #cleanup deleted files
    &rb_cleanTrashlist();

    # start move2num to normalize filenames
    &rb_move2num() if $main::doMove2Num;

    # isspam?, path, filter, weight, processing sub
    $correctedspamcount    = &rb_processfolder( 1, $main::correctedspam,    "*", 2, \&rb_dospamhash, undef, undef, undef );
    $correctednotspamcount = &rb_processfolder( 0, $main::correctednotspam, "*", 4, \&rb_dohamhash, undef, undef, undef );
    my $tempnorm = ($HamWordCount ? ( $SpamWordCount / $HamWordCount ) : $SpamWordCount ? 9.9999 : 1) || 0.0001;
    my ($neededspam,$neededham, $spamf, $hamf, $SwordsPfile, $HwordsPfile);
    my @tn = split(/\-/o,$main::autoCorrectCorpus);
    my $targetNorm = sprintf("%.3f",(($tn[0] + $tn[1])/2));
    my $nspam = undef;
    if ($tempnorm < 30 && $targetNorm > 0) {
        my $tn = sprintf("%.3f",$tempnorm);
        if ($tempnorm >= 10) {
            &rb_printlog("warning: corpusnorm after processing $main::correctedspam and $main::correctednotspam is very unbalanced (>=10) Spam Weight: $SpamWordCount / Not-Spam Weight: $HamWordCount => norm: $tn  - you should fill some known good files into the folder $main::correctednotspam\n");
            &rb_mlog("warning: corpusnorm after processing $main::correctedspam and $main::correctednotspam is very unbalanced (>=10) spamwords $SpamWordCount/ hamwords $HamWordCount => $tn - you should fill some known good files into the folder $main::correctednotspam");
        }
        my @t;
        if (open (my $F, '<', "$main::base/normfile")) {
            binmode $F;
            @t = split(/ /,join('',<$F>));
            $F->close;
        }
        if ($t[5] > 0 && $t[6] > 0) {
            $SwordsPfile = $t[5];
            $HwordsPfile = $t[6];

            if ($tempnorm < 10) {
                &rb_printlog("info: corpusnorm after processing $main::correctedspam and $main::correctednotspam is Spam Weight: $SpamWordCount / Not-Spam Weight: $HamWordCount => norm: $tn \n");
                &rb_mlog("info: corpusnorm after processing $main::correctedspam and $main::correctednotspam is spamwords $SpamWordCount/ hamwords $HamWordCount => $tn");
            }
            $spamf = &main::min($main::MaxFiles,&rb_countfiles(&rb_fixPath($main::base.'/'.$main::spamlog).'/'));
            $hamf =  &main::min($main::MaxFiles,&rb_countfiles(&rb_fixPath($main::base.'/'.$main::notspamlog).'/'));
            my $r = ($spamf>0 || $hamf>0) & defined(*{'main::yield'})?$targetNorm:0;

            my $sf = ($HamWordCount - $SpamWordCount + $HwordsPfile * $hamf)/$SwordsPfile;
            &rb_d("spamfiles -> $sf = ($HamWordCount - $SpamWordCount + $HwordsPfile * $hamf)/$SwordsPfile \n");
#            my $f = (($sf * 0.9) > $spamf) ? 1 : 0.9;
            my $f = 1;
            rb_d("info: f = $f , sf = $sf , spamf = $spamf");
            $f = $f / (($main::bayesnorm - $targetNorm + 1) ** 2) if ($main::bayesnorm >= $tn[0] && $main::bayesnorm <= $tn[1]);
            $sf = &main::min($spamf,$sf);
            rb_d("info: SpamCountNormCorrection = $main::SpamCountNormCorrection , f = $f , sf = $sf , spamf = $spamf, norm = $main::bayesnorm, target = $targetNorm");
            $neededspam = int($sf * $r * $f * (1+(($main::SpamCountNormCorrection > -100 && $main::SpamCountNormCorrection < 100) ? $main::SpamCountNormCorrection/100 : 0)));
            $neededspam = 1 if $neededspam <= 0;
            my $t = ($neededspam < $spamf) ? 'approximately '.&rb_commify($neededspam) : 'approximately all';
            $nspam = int($sf * $r * $SwordsPfile * (1+(($main::SpamCountNormCorrection > -100 && $main::SpamCountNormCorrection < 100) ? $main::SpamCountNormCorrection/100 : 0)));
            $nspam = 2 if $nspam < 2;

            &rb_printlog("info: require $t files (".&rb_commify($nspam)." words".($main::SpamCountNormCorrection ? " +[$main::SpamCountNormCorrection\% included]" : '').") from folder $main::spamlog to get the wanted corpusnorm ($targetNorm)\n");
            &rb_mlog("info: require $t files (".&rb_commify($nspam)." words".($main::SpamCountNormCorrection ? " +[$main::SpamCountNormCorrection\% included]" : '').") from folder $main::spamlog to get the wanted corpusnorm ($targetNorm)");
            $nspam += $SpamWordCount;
        } else {
            &rb_printlog("warning: missing information for automatic corpus correction in file $main::base/normfile.  If this is the first time you have seen this warning, rerun the rebuild!\n");
            &rb_mlog("warning: missing information for automatic corpus correction in file $main::base/normfile.  If this is the first time you have seen this warning, rerun the rebuild!");
        }
    } elsif ($targetNorm > 0) {
        my $tn = sprintf("%.3f",$tempnorm);
        &rb_printlog("warning: corpusnorm after processing $main::correctedspam and $main::correctednotspam is too unbalanced (>=30) Spam Weight: $SpamWordCount / Not-Spam Weight: $HamWordCount => norm: $tn - you should fill some known good files into the folder $main::correctednotspam\n");
        &rb_mlog("warning: corpusnorm after processing $main::correctedspam and $main::correctednotspam is too unbalanced (>=30) spamwords $SpamWordCount/ hamwords $HamWordCount => $tn - you should fill some known good files into the folder $main::correctednotspam");
    }
    my $spamWords = $SpamWordCount;
    $spamlogcount = &rb_processfolder( 1, $main::spamlog, "*", 1, \&rb_checkspam , $neededspam, undef, (($neededspam < $spamf) ? $nspam : undef) );
    $spamWords = $SpamWordCount - $spamWords;
    $SwordsPfile = ($SwordsPfile ? int(($SwordsPfile + $spamWords/$spamlogcount)/2) : int($spamWords/$spamlogcount)) if $spamlogcount;
    my $nham = undef;
    if ($neededspam && $targetNorm > 0) {
        $nham = ($SpamWordCount - $HamWordCount)/$targetNorm;
        &rb_d("$nham = ($SpamWordCount - $HamWordCount)/$targetNorm \n");
        $neededham = int($nham/$HwordsPfile);
        &rb_d("$neededham = int($nham/$HwordsPfile) \n");
        $neededham = 1 if $neededham <= 0;
        $nham = 2 if $nham < 2;
        my $t = ($neededham < $hamf) ? "approximately ".&rb_commify($neededham) : 'approximately all';
        &rb_printlog("info: require $t files (".&rb_commify($nham)." words) from folder $main::notspamlog to get the wanted corpusnorm ($targetNorm)\n");
        &rb_mlog("info: require $t files (".&rb_commify($nham)." words) from folder $main::notspamlog to get the wanted corpusnorm ($targetNorm)");
        $nham = (($SpamWordCount/$targetNorm) > $HamWordCount) ? int($SpamWordCount/$targetNorm) : 1;
        &rb_d("$nham = (($SpamWordCount/$targetNorm) > $HamWordCount) ? int($SpamWordCount/$targetNorm) : 1 \n");
    }
    my $hamWords = $HamWordCount;
    $notspamlogcount = &rb_processfolder( 0, $main::notspamlog, "*", 1, \&rb_checkham , $neededham, (($neededham < $hamf) ? $nham : undef), undef);
    $hamWords = $HamWordCount - $hamWords;
    $HwordsPfile = ($HwordsPfile ? int(($HwordsPfile + $hamWords/$notspamlogcount)/2) : int($hamWords/$notspamlogcount)) if $notspamlogcount;

    $norm = $HamWordCount ? ( $SpamWordCount / $HamWordCount ) : 100;
    (open( my $normFile, '>', "$main::base/normfile" )) || warn "unable to open $main::base/normfile: $!\n";
    if ($normFile) {
        print { $normFile } "$norm $correctedspamcount $correctednotspamcount $spamlogcount $notspamlogcount $SwordsPfile $HwordsPfile $SpamWordCount $HamWordCount";
        eval{$normFile->close;};
    }

    my ($bayesScores, $HMMScores) = (0,0);
    # Create Bayesian DB
    $bayesScores = &rb_generatescores();
    # freeup memory used by Bayesscores
    rb_undefSpamDBVars();

    # Create HMM DB
    $HMMScores = &rb_generateHMM() if $DoHMM;

    # Create HELO blacklist
    &rb_createheloblacklist();
    rb_undefHeloDBVars();

    $main::bayesnorm = $main::Spamdb{'***bayesnorm***'} = $norm;

    &rb_printlog("\nSpam Weight    :   " . &rb_commify($SpamWordCount) . "\n");
    &rb_printlog(  "Not-Spam Weight:   " . &rb_commify($HamWordCount) . "\n\n" );

    if ($bayesIgnored && $bayesScores && $RebuildDebug) {
        &rb_printlog("Bayesian pairs are ignored, if they occure only one time or their probability is in the useless range 0.4 < prob < 0.6\n");
        my $pcent = sprintf("%.2f",(($bayesIgnored / ($bayesIgnored + $bayesScores)) * 100));
        &rb_printlog("ignored Bayesian pairs:   " . &rb_commify($bayesIgnored) . " - which are $pcent\% of all processed\n\n");
    }
    if ($HMMIgnored && $HMMScores && $RebuildDebug) {
        &rb_printlog("HMM sequences are ignored, if their probability is in the useless range 0.4 < prob < 0.6\n");
        my $pcent = sprintf("%.2f",(($HMMIgnored / ($HMMIgnored + $HMMScores)) * 100));
        &rb_printlog("ignored HMM sequences :   " . &rb_commify($HMMIgnored) . " - which are $pcent\% of all processed\n\n" );
    }

    if ( !($norm) ) {    #invalid norm
        &rb_printlog("Warning: Corpus insufficient to calculate normality!\n");
        &rb_mlog("Warning: Corpus insufficient to calculate normality!");
    }
    else {               #norm exists, print it
        my $normdesc;
        if    ( $norm < 0.6 )   { $normdesc = '(warning: extremely ham heavy)'; }
        elsif ( $norm < 0.9 )   { $normdesc = '(ok - slighly ham heavy)'; }
        elsif ( $norm < 1.1 )   { $normdesc = '(very good - balanced)'; }
        elsif ( $norm < 1.4 )   { $normdesc = '(ok - slighly spam heavy)'; }
        else                    { $normdesc = '(warning: extremely spam heavy)'; }
        &rb_printlog( "Corpus norm:\t%.4f - $normdesc\n", $norm );
        &rb_printlog( "Corpus confidence:\t%.8f\n", &main::BayesConfNorm() );
    }
    if ( $spamlogcount >= $main::MaxFiles || $notspamlogcount >= $main::MaxFiles ) {
        &rb_printlog(
            "Recommendation: RebuildSpamDB will limit the number of used messages in your corpus. Excess files will be ingored.\n"
          );
    }
    my ($lownorm,$highnorm,$numfiles,$mindays) = split(/-/o, $main::autoCorrectCorpus);
    if ( $norm < 0.6 ) {
        &rb_printlog("Corpus norm should be between 0.6 and 1.4\n");
        &rb_printlog("\nRecommendation: You need more spam messages in the corpus.\n");
    }
    if (! $main::RebuildTestMode && ! $neededspam && $main::autoCorrectCorpus && $norm < $lownorm && $main::notspamlog && ! $main::RunTaskNow{cleanUpMaxFiles}) {
        $main::RunTaskNow{cleanUpMaxFiles} = 10001;
        &rb_printlog("\nstarting auto correction for corpus - delete old ham files from $main::notspamlog\n");
        my $info = &main::cleanUpMaxFiles($main::notspamlog, 1 - $lownorm, $numfiles,$mindays);
        &rb_printlog($info) if $info;
        $main::RunTaskNow{cleanUpMaxFiles} = '';
    }
    if ( $norm > 1.4 ) {
        &rb_printlog("Corpus norm should be between 0.6 and 1.4\n");
        &rb_printlog("\nRecommendation: You need more not-spam messages in the corpus.\n");
    }
    if (! $main::RebuildTestMode && ! $neededspam && $main::autoCorrectCorpus && $norm > $highnorm && $main::spamlog && ! $main::RunTaskNow{cleanUpMaxFiles}) {
        $main::RunTaskNow{cleanUpMaxFiles} = 10001;
        &rb_printlog("\nstarting auto correction for corpus - delete old spam files from $main::spamlog\n");
        my $info = &main::cleanUpMaxFiles($main::spamlog, $highnorm - 1, $numfiles,$mindays);
        &rb_printlog($info) if $info;
        $main::RunTaskNow{cleanUpMaxFiles} = '';
    }
    if ( $main::MaxBytes >= 4000 && $norm < 0.6 ) {
        &rb_printlog( "\nRecommendation: You should reduce now MaxBytes to " . int( ( $main::MaxBytes + 1000 ) / 2 ) . "!  \n" );
    }
    if ( $main::MaxBytes <= 4000 && $norm > 1.3 ) {
        my $newMaxBytes = int( $main::MaxBytes - 1000 ) * 2 ;
        $newMaxBytes = $main::MaxBytes + 1000 if $newMaxBytes <= $main::MaxBytes;
        &rb_printlog( "\nRecommendation: You should increase now MaxBytes to " . $newMaxBytes . "!  \n" );
    }

    if ($DoHMM) {
        if ($main::spamdb eq 'DB:' or $main::runHMMusesBDB or $main::HMM4ISP) {
            if ($main::DBusedDriver ne 'BerkeleyDB' && ! $main::runHMMusesBDB && ! $main::HMM4ISP) {
                # locking is done later
            } else {
                &rb_printlog( "\nStart populating Hidden Markov Model. HMM-check is disabled for this time!\n" );
                &rb_mlog( "Start populating Hidden Markov Model. HMM-check is disabled for this time!" );
                $main::lockHMM = 1;
                &rb_mlog( "try to lock HMM databases in 5 second(s)" );
                sleep 5;
                $main::ThreadIdleTime{$main::WorkerNumber} += 5;
            }
            rb_populate_HMM();
            $main::lockHMM = 0;
            &rb_printlog( "Finished populating Hidden Markov Model. HMM-check is now enabled again!\n" );
            &rb_mlog( "Finished populating Hidden Markov Model! HMM-check is now enabled again!" );
            $main::cleanHMM = '';
            $main::HMMdb{'***bayesnorm***'} = $norm;
        } else {
            &rb_printlog( "\nplease set the config parameter 'spamdb' to 'DB:' or 'HMMusesBDB' to 'On' - unable to populate HMM\n\n");
            &rb_mlog( "please set the config parameter 'spamdb' to 'DB:' or 'HMMusesBDB' to 'On' - unable to populate HMM");
        }

        $main::lockHMM = 0;
    }

    # freeup HMM memory
    rb_undefHmmDBVars();

    $processedBytes = &main::formatNumDataSize($processedBytes);
    if   ( time - $starttime != 0 ) { $processTime = &rb_commify(time - $starttime); }
    else                            { $processTime = 1; }
    &rb_printlog( "\nTotal processing time: %s second(s)\n", $processTime );
    &rb_printlog( "\nTotal processed data: $processedBytes\n\n");
    &rb_mlog( "Total processing time: %s second(s)", $processTime );
    &rb_mlog( "Total processed data: $processedBytes");

    if ( $main::asspLog ) { &rb_uploadgriplist(); }

    if ($TrashlistObj !~ /orderedtie/o && rb_Save_Trashlist("$main::base/trashlist.db",\%Trashlist) ) {
        &rb_printlog( "\nTrashlist was saved to $main::base/trashlist.db\n" );
        &rb_mlog( "Trashlist was saved to $main::base/trashlist.db" );
    }

    if ($RebuildUsesFileModel) {
        my $c = rb_maintFileModel();
    }

    rb_undefVars();

    if ($DoHMM && $scanFiles > 200) {
        use File::Find();
        my $size;
        my $used;
        File::Find::find({'follow' => 1,'no_chdir' => 1,'wanted'=>sub{ -f $_ and ( $size += -s $_ )}}, "$main::base/tmpDB" );
        $used = $size;
        $size *= 2;
        $size = 250 * 1024 * 1024 if $size < 250 * 1024 * 1024;
        $size = &main::formatNumDataSize(int($size / 1024) * 1024);
        $used = &main::formatNumDataSize(int($used / 1024) * 1024);
        my $tooslow = 3; my $slow = $doattach ? 6 : 7; my $fast = $doattach ? 10 : 12;
        $scanTime = 1 unless $scanTime;
        my $fps = sprintf("%.2f",($scanFiles / $scanTime));
        if ($fps < $tooslow && $main::useDB4Rebuild) {
            &rb_printlog("\nRebuild processed $fps files per second. ASSP expects a speed of at least $slow files per second - good values are $fast and higher. The disk IO components (disks and/or IO-controller) of your system are too slow for ASSP. Use a cached (>=128MB) IO-controller or use a RAM-disk with at least $size for the folder '$main::base/tmpDB' to speed up the rebuild process or disable 'DoHMM'.\n");
            &rb_mlog("Rebuild processed $fps files per second. ASSP expects a speed of at least $slow files per second - good values are $fast and higher. The disk IO components (disks and/or IO-controller) of your system are too slow for ASSP. Use a cached (>=128MB) IO-controller or use a RAM-disk with at least $size for the folder '$main::base/tmpDB' to speed up the rebuild process or disable 'DoHMM'.");
        } elsif ($fps < $slow && $main::useDB4Rebuild) {
            &rb_printlog("\nRebuild processed $fps files per second. ASSP expects a speed of at least $slow files per second - good values are $fast and higher. The disk IO components (disks and/or IO-controller) of your system are slow. Use a cached (>=128MB) IO-controller or use a RAM-disk with at least $size for the folder '$main::base/tmpDB' to speed up the rebuild process.\n");
            &rb_mlog("Rebuild processed $fps files per second. ASSP expects a speed of at least $slow files per second - good values are $fast and higher. The disk IO components (disks and/or IO-controller) of your system are slow. Use a cached (>=128MB) IO-controller or use a RAM-disk with at least $size for the folder '$main::base/tmpDB' to speed up the rebuild process.");
        } elsif ($fps < $fast && $main::useDB4Rebuild) {
            &rb_printlog("\nRebuild processed $fps files per second. Good values are $fast files per second and higher. You can speed up the rebuild process, using a cached (>=128MB) IO-controller or a RAM-disk with at least $size for the folder '$main::base/tmpDB'.\n");
            &rb_mlog("Rebuild processed $fps files per second. Good values are $fast files per second and higher. You can speed up the rebuild process, using a cached (>=128MB) IO-controller or a RAM-disk with at least $size for the folder '$main::base/tmpDB'.");
        } else {
            &rb_printlog("\nRebuild processed $fps files per second.\n");
            &rb_mlog("Rebuild processed $fps files per second.");
        }
        &rb_printlog("\nAfter finishing the Rebuild process, the $main::base/tmpDB folder contains $used.\n");
        &rb_mlog("After finishing the Rebuild process, the $main::base/tmpDB folder contains $used.");
        if ($main::CanUseASSP_FC && eval('require ASSP_FC;')) {
            $ASSP_FC::freespace_kbl = 0;
            $ASSP_FC::totalspace_kbl = 0;
            if ( &ASSP_FC::getDriveInfo("$main::base/tmpDB",'l') && $ASSP_FC::totalspace_kbl ) {
                $ASSP_FC::freespace_kbl =~ s/[.,]//go;
                $ASSP_FC::totalspace_kbl =~ s/[.,]//go;
                $ASSP_FC::freespace_kbl = &main::formatNumDataSize($ASSP_FC::freespace_kbl * 1024);
                $ASSP_FC::totalspace_kbl = &main::formatNumDataSize($ASSP_FC::totalspace_kbl * 1024);
                &rb_printlog("\nAfter finishing the Rebuild process, the drive that contains the $main::base/tmpDB folder has $ASSP_FC::freespace_kbl free space from total $ASSP_FC::totalspace_kbl.\n");
                &rb_mlog("After finishing the Rebuild process, the drive that contains the $main::base/tmpDB folder has $ASSP_FC::freespace_kbl free space from total $ASSP_FC::totalspace_kbl.");
            }
            eval('no ASSP_FC;');
        }
    }

    eval{$RebuildLog->close;};
    if ($main::RebuildNotify) {
        &main::sendNotification(
          $main::EmailFrom,
          $main::RebuildNotify,
          "RebuildSpamDB - report from $main::myName",
          "File rebuildrun.txt follows:\r\n\r\n",
          "$main::base/rebuildrun.txt");
    }

    }  # end if ($onlyNewCorrected)  ... elsif () ...

eval (<<'EOT');
    no ASSP_WordStem;
EOT
    return ! $have_error;
}
##########################################
#       run/main script ends here
##########################################

sub rb_maintFileModel {
    my @todelete;
    my $count = 0;
    foreach my $k (keys(%$FileModel)) {
        next if $k eq 'Version';
        $count++;
        push(@todelete,$k) if ! $main::eF->($k);
    }
    map { rb_removeFileModelEntry($_); $count--;} @todelete;
    $FileModel->{Version} = $main::requiredDBVersion{Spamdb};

    unless (tied(%$FileModel)) {
        eval{Storable::nstore($FileModel, "$DBDir/FileModel.store");};
        &rb_mlog( "internal FileModel was stored in file $DBDir/FileModel.store" );
    }
    &rb_mlog( "internal FileModel has $count entries after maintenance" );

    return $count;
}

sub rb_deleteFileModel {
    %$FileModel = ('Version' => $main::requiredDBVersion{Spamdb});
    unless (tied(%$FileModel)) {
        eval{Storable::nstore($FileModel, "$DBDir/FileModel.store");};
        &rb_mlog( "a new empty internal FileModel was stored in file $DBDir/FileModel.store" );
    }
    &rb_mlog( "the internal FileModel is now empty" );
}

sub rb_removeFileModelEntry {
    my $fn = shift;
    my $this = $FileModel->{$fn};
    if (exists $this->{FileHash}) {
        delete $SpamHash{$this->{FileHash}} if --$SpamHash{$this->{FileHash}} < 1;
        delete $HamHash{$this->{FileHash}} if --$HamHash{$this->{FileHash}} < 1;
    }
    undef $this;
    delete $FileModel->{$fn};
}

sub rb_powerofftwo {
    my $c = shift;
    $c = 2 if $c < 2;
    return (2 << log($c - 1) / log(2));     # next power of two
}

sub rb_undefHeloDBVars {
    undef $HeloObj;

    untie %Helo;
    undef %Helo;
}

sub rb_undefSpamDBVars {
    undef $spamObj;
    undef $newspamObj;
    undef $HamHashObj;
    undef $SpamHashObj;

    untie %spam;
    undef %spam;

    untie %newspam;
    undef %newspam;

    untie %HamHash;
    undef %HamHash;

    untie %SpamHash;
    undef %SpamHash;
}

sub rb_undefHmmDBVars {
    undef $HMMresObj;

    untie %HMMres;
    undef %HMMres;

    undef $hamHMM;
    undef $spamHMM;
}

sub rb_undefVars {

    rb_undefSpamDBVars();
    undef $GpCntObj;
    undef $GpOKObj;
    undef $TrashlistObj;
    undef $FileModelObj;

    untie %GpCnt;
    undef %GpCnt;

    untie %GpOK;
    undef %GpOK;

    untie %Trashlist;
    undef %Trashlist;

    rb_undefHmmDBVars();
    rb_undefHeloDBVars;
    
    untie %$FileModel;
    undef $FileModel;

    undef $BDBEnv;

    unlink "$DBDir/rb_HMMres.bdb";
    unlink "$DBDir/rb_HamHash.bdb";
    unlink "$DBDir/rb_SpamHash.bdb";
    unlink "$DBDir/rb_GpCnt.bdb";
    unlink "$DBDir/rb_GpOK.bdb";
    unlink "$DBDir/rb_newspam.bdb";
}

sub rb_populate_HMM {                 # rb_populate_HMM
    delete $HMMres{''};
    return rb_populate_HMM_DB() if $main::DBusedDriver ne 'BerkeleyDB' && ! $main::runHMMusesBDB && ! $main::HMM4ISP;
    %main::HMMdb = () unless $main::RebuildTestMode;                # clear the main hash

    my $obj;
    if ($obj = tied %main::HMMdb) {
       &main::BDB_filter_off($obj) unless $main::HMM4ISP;
    }
    my $tot;
    eval (<<'EOT');
        $tot = defined $HMMresObj ? &rb_commify($HMMresObj->db_stat()->{hash_ndata}) : &rb_commify(scalar keys %HMMres);
EOT

    my $count = 0;
    $main::haveHMM = 0 unless $main::RebuildTestMode;
    &rb_printlog( "start populating Hidden Markov Model with $tot records!\n" );
    &rb_mlog( "start populating Hidden Markov Model with $tot records!" );
    $main::cleanHMM = 1 unless $main::RebuildTestMode;
    while (my ($k,$v) = each %HMMres) {
        next unless defined $v;
        if ($count%1000==0) {
            die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
            $main::lastd{$Iam} = "populating HMM - ".&rb_commify($count)."/$tot";
        }
        $main::HMMdb{$k} = $v unless $main::RebuildTestMode;
        $count++;
    }
    &main::saveHashToFile("$main::base/tmpDB/rebuildDB/TESTMODE_HMMdb.csv",\%HMMres,{ 'keyESC' => '"' , 'separator' => ',' , 'valueESC' => '"' , 'lineend' => "\n" }) if $main::RBExportCSV && $main::RebuildTestMode;
    $main::currentDBVersion{HMMdb} = $main::HMMdb{'***DB-VERSION***'} = $main::requiredDBVersion{HMMdb} unless $main::RebuildTestMode;
    &main::BDB_filter($obj) if $obj && ! $main::HMM4ISP;
    $main::haveHMM = $count unless $main::RebuildTestMode;
    $main::cleanHMM = '' if $count;
    $count = &rb_commify($count);

    &rb_printlog( "Finished populating Hidden Markov Model with $count records!\n" );
    &rb_mlog( "Finished populating Hidden Markov Model with $count records!" );
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
    return;
}

sub rb_populate_HMM_DB {                 # rb_populate_HMM_DB;
    my ($tot,$totn);
    $main::lockHMM = 0;
    eval (<<'EOT');
        $totn = defined $HMMresObj ? $HMMresObj->db_stat()->{hash_ndata} : scalar keys %HMMres;
        $tot = &rb_commify($totn);
EOT

    my $mysqlTable = $main::DBvars{'HMMdb'};

    &rb_printlog( "start populating Hidden Markov Model with $tot records!\n" );
    &rb_mlog( "start populating Hidden Markov Model with $tot records!" );

    while ($main::ComWorker{$Iam}->{run} && $main::RunTaskNow{ImportMysqlDB}) {
        die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
        $main::lastd{$Iam} = "waiting additional 10 seconds for still running DB import to be finished";
        sleep 10;
        $main::ThreadIdleTime{$main::WorkerNumber} += 10;
    }
    die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};

    $main::lastd{$Iam} = "populating HMM - $tot records";

    if (! $main::RebuildTestMode && "$main::HMMdbObject" =~ /Tie::RDBM/o) {
        eval {
        $main::cleanHMM = 1;
        $main::RunTaskNow{ImportMysqlDB} = $Iam;
        my $dbh = DBI->connect("DBI:$main::DBusedDriver:".($main::mydb ? "database=$main::mydb;" : '').($main::myhost ? "$main::DBhostTag=$main::myhost" : '' )."$main::DBOption", $main::myuser, $main::mypassword,
                                { PrintError=>0,
                			      ChopBlanks=>1,
                			      Warn=>0 }
                			  );
        %tmp = ();
        $tmpObject = tie %{'rebuildspamdb::tmp'},'Tie::RDBM',{db=>$dbh,table=>$mysqlTable.'tmp',create=>1,DEBUG=>$main::DataBaseDebug};

        delete $HMMres{'***lockHMMdb***'};
        &main::importDB('rebuildspamdb::tmp','',$mysqlTable.'tmp',\%HMMres,$totn, 1/2);

        untie %tmp;
        undef $tmpObject;
        undef $dbh;
        %tmp = ();
        $main::haveHMM = 0;
        &rb_printlog( "Enable new Hidden Markov Model. HMM-check is disabled for this time!\n" );
        &rb_mlog( "Enable new Hidden Markov Model. HMM-check is disabled for this time!" );
        $main::lockHMM = 1;
        $main::HMMdb{'***lockHMMdb***'} = 1;
        &rb_mlog( "try to lock HMM databases in 5 second(s)" );
        sleep 5;
        $main::ThreadIdleTime{$main::WorkerNumber} += 5;
        if ($main::preventBulkImport) {
            &rb_printlog( "preventBulkImport is set to ON - can't drop table $mysqlTable - need to move records\n" );
            &rb_mlog( "preventBulkImport is set to ON - can't drop table $mysqlTable - need to move records" );
            &rb_printlog( "clearing table $mysqlTable\n" );
            &rb_mlog( "clearing table $mysqlTable" );
            %main::HMMdb = ('***lockHMMdb***' => 1);
            &rb_printlog( "move data from ".$mysqlTable."tmp to $mysqlTable\n" );
            &rb_mlog( "move data from ".$mysqlTable."tmp to $mysqlTable" );
            $main::HMMdbObject->RunSTM('copyhmmdb','INSERT INTO '.$mysqlTable.' SELECT * FROM '.$mysqlTable.'tmp');
            delete $main::HMMdb{'***lockHMMdb***'};
            $main::HMMdbObject->RunSTM('drophmmdbtmp','DROP TABLE '.$mysqlTable.'tmp');
        } else {
            &rb_printlog( "dropping table $mysqlTable\n" );
            &rb_mlog( "dropping table $mysqlTable" );
            $main::HMMdbObject->RunSTM('drophmmdb','DROP TABLE '.$mysqlTable);
            &rb_printlog( "rename table ".$mysqlTable."tmp to $mysqlTable\n" );
            &rb_mlog( "rename table ".$mysqlTable."tmp to $mysqlTable" );

            my $stm = 'ALTER TABLE '.$mysqlTable.'tmp RENAME TO '.$mysqlTable;
            # MSSQL  has no ANSI-SQL 'ALTER TABLE ... RENAME TO ...' it uses sp_rename instead
            $stm = "sp_rename '".$mysqlTable."tmp', '".$mysqlTable."'"
                if ($main::SpamdbObject->{dbh}->get_info(17) =~ /Microsoft SQL Server/io);

            $main::HMMdbObject->RunSTM('renamehmmdb',$stm);
            delete $main::HMMdb{'***lockHMMdb***'};
        }
        @{'main::'.$mysqlTable} = ();   # clean the hmmdb cache;
        $main::cleanHMM = 0 if ($main::haveHMM = &main::getDBCount('main::HMMdb','main::spamdb'));
        delete $main::HMMdb{''};
        $main::currentDBVersion{HMMdb} = $main::HMMdb{'***DB-VERSION***'} = $main::requiredDBVersion{HMMdb};
        $main::HMMdb{'***COUNT***'} = $main::haveHMM;
        };
        if ($@) {
            &rb_printlog( "ERROR populating Hidden Markov Model! - $@\n" );
            &rb_mlog( "ERROR populating Hidden Markov Model! - $@" );
        }
        $main::lockHMM = 0;
        delete $main::HMMdb{'***lockHMMdb***'};
        $main::RunTaskNow{ImportMysqlDB} = '';
    } elsif ($main::RBExportCSV && $main::RebuildTestMode) {
        &main::saveHashToFile("$main::base/tmpDB/rebuildDB/TESTMODE_HMMdb.csv",\%HMMres,{ 'keyESC' => '"' , 'separator' => ',' , 'valueESC' => '"' , 'lineend' => "\n" });
    } elsif ($main::RebuildTestMode) {
    } else {
        &rb_printlog( "\nERROR: don't know how to publish HMMdb with $tot records! The database is not tied to Tie::RDBM\n" );
        &rb_mlog( "ERROR: don't know how to publish HMMdb with $tot records! The database is not tied to Tie::RDBM" );
    }
    &rb_printlog( "Finished populating Hidden Markov Model with $tot records!\n" );
    &rb_mlog( "Finished populating Hidden Markov Model with $tot records!" );
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
    return;
}

sub rb_populate_Spamdb {
    my ($hashref, $totn) = @_;

    my $mysqlTable = $main::DBvars{'Spamdb'};
    my $tot = &rb_commify($totn);

    &rb_printlog( "start populating Spamdb with $tot records!\n" );
    &rb_mlog( "start populating Spamdb with $tot records!" );
    $main::lastd{$Iam} = "start populating Spamdb with $tot records!" ;

    while ($main::ComWorker{$Iam}->{run} && $main::RunTaskNow{ImportMysqlDB}) {
        die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
        $main::lastd{$Iam} = "waiting additional 10 seconds for still running DB import to be finished";
        sleep 10;
        $main::ThreadIdleTime{$main::WorkerNumber} += 10;
    }
    die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};

    if (! $main::RebuildTestMode && "$main::SpamdbObject" =~ /Tie::RDBM/o) {
        eval {
        $main::RunTaskNow{ImportMysqlDB} = $Iam;
        $main::lastd{$Iam} = "populating Spamdb - $tot records";
        my $dbh = DBI->connect("DBI:$main::DBusedDriver:".($main::mydb ? "database=$main::mydb;" : '').($main::myhost ? "$main::DBhostTag=$main::myhost" : '' )."$main::DBOption", $main::myuser, $main::mypassword,
                                { PrintError=>0,
                			      ChopBlanks=>1,
                			      Warn=>0 }
                			  );
        %tmp = ();
        $tmpObject = tie %{'rebuildspamdb::tmp'},'Tie::RDBM',{db=>$dbh,table=>$mysqlTable.'tmp',create=>1,DEBUG=>$main::DataBaseDebug};

        delete $tmp{'***lockSpamdb***'};
        &main::importDB('rebuildspamdb::tmp','',$mysqlTable.'tmp',$hashref,$totn, 1/2);

        untie %tmp;
        undef $tmpObject;
        undef $dbh;
        %tmp = ();
        &rb_printlog( "Enable new Spamdb - Bayesian-check is disabled for this time!\n" );
        &rb_mlog( "Enable new Spamdb - Bayesian-check is disabled for this time!" );
        $main::lockBayes = 1;
        $main::Spamdb{'***lockSpamdb***'} = 1;
        &rb_mlog( "try to lock Spamdb database in 5 second(s) - Bayesian check is now disabled" );
        sleep 5;
        $main::ThreadIdleTime{$main::WorkerNumber} += 5;
        if ($main::preventBulkImport) {
            &rb_printlog( "preventBulkImport is set to ON - can't drop table $mysqlTable - need to move records\n" );
            &rb_mlog( "preventBulkImport is set to ON - can't drop table $mysqlTable - need to move records" );
            &rb_printlog( "clearing table $mysqlTable\n" );
            &rb_mlog( "clearing table $mysqlTable" );
            %main::Spamdb = ('***lockSpamdb***' => 1);
            &rb_printlog( "move records from ".$mysqlTable."tmp to $mysqlTable\n" );
            &rb_mlog( "move records from ".$mysqlTable."tmp to $mysqlTable" );
            $main::SpamdbObject->RunSTM('copyspamdb','INSERT INTO '.$mysqlTable.' SELECT * FROM '.$mysqlTable.'tmp');
            delete $main::Spamdb{'***lockSpamdb***'};
            $main::SpamdbObject->RunSTM('dropspamdbtmp','DROP TABLE '.$mysqlTable.'tmp');
        } else {
            &rb_printlog( "dropping table $mysqlTable\n" );
            &rb_mlog( "dropping table $mysqlTable" );
            $main::SpamdbObject->RunSTM('dropspamdb','DROP TABLE '.$mysqlTable);
            &rb_printlog( "rename table ".$mysqlTable."tmp to $mysqlTable\n" );
            &rb_mlog( "rename table ".$mysqlTable."tmp to $mysqlTable" );

            my $stm = 'ALTER TABLE '.$mysqlTable.'tmp RENAME TO '.$mysqlTable;
            # MSSQL  has no ANSI-SQL 'ALTER TABLE ... RENAME TO ...' it uses sp_rename instead
            $stm = "sp_rename '".$mysqlTable."tmp', '".$mysqlTable."'"
                if ($main::SpamdbObject->{dbh}->get_info(17) =~ /Microsoft SQL Server/io);

            $main::SpamdbObject->RunSTM('renamespamdb',$stm);
            delete $main::Spamdb{'***lockSpamdb***'};
        }
        @{'main::'.$mysqlTable} = ();   # clean the hmmdb cache;
        $main::Spamdb{'***COUNT***'} = $totn;
        };
        if ($@) {
            &rb_printlog( "ERROR populating Spamdb! - $@\n" );
            &rb_mlog( "ERROR populating Spamdb! - $@" );
        }
        $main::lockBayes = '';
        delete $main::Spamdb{'***lockSpamdb***'};
        $main::RunTaskNow{ImportMysqlDB} = '';
    } elsif ($main::RBExportCSV && $main::RebuildTestMode) {
        &main::saveHashToFile("$main::base/tmpDB/rebuildDB/TESTMODE_spamDB.csv",$hashref,{ 'keyESC' => '"' , 'separator' => ',' , 'valueESC' => '"' , 'lineend' => "\n" });
    } elsif ($main::RebuildTestMode) {
    } else {
        &rb_printlog( "\nERROR: don't know how to publish Spamdb with $tot records! The database is not tied to Tie::RDBM\n" );
        &rb_mlog( "ERROR: don't know how to publish Spamdb with $tot records! The database is not tied to Tie::RDBM" );
    }

    &rb_printlog( "Finished populating Spamdb with $tot records - Bayesian check is now enabled!\n" );
    &rb_mlog( "Finished populating Spamdb with $tot records - Bayesian check is now enabled!" );
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
    return;
}

sub rb_Load_Trashlist {
    my %tmp;
    my $res = &main::loadHashFromFile("$main::base/trashlist.db",\%tmp) || return 0;
    $res = 0;
    while (my ($k,$v) = each(%tmp)) {
        if ($main::eF->($k)) {
            $Trashlist{&main::de8($k)} = $v;
            $res++;
        }
    }
    return $res;
}

sub rb_Save_Trashlist {
    return &main::saveHashToFile("$main::base/trashlist.db",\%Trashlist,{});
}

sub rb_BDB_getRecordCount {
    my $hash = shift;
    return 0 unless $hash;
    return 0 unless tied %{$hash};
    my $dbo = $hash . 'Obj';
    return 0 unless defined ${$dbo};
    return 0 if ("${$dbo}" !~ /BerkeleyDB/o);
    my $statref;
    eval (<<'EOT');
         $statref = ${$dbo}->db_stat();
EOT
    return 0 unless $statref;
    return 0 unless ref $statref;
    $main::lastd{$Iam} = "$hash BerkeleyDB record count: ".$statref->{hash_ndata};
    return $statref->{hash_ndata};
}


sub rb_generatescores {
    my ( $t, $s, $pair, $v );
    &rb_printlog("\nGenerating weighted Bayesian tuplets\n");
    &rb_mlog("Generating weighted Bayesian tuplets");
    my $spamdbFile;
    if (! $main::ReplaceOldSpamdb) {
        (open( $spamdbFile, '>', "$main::base/spamdb.rb.tmp" )) || &rb_printlog("unable to open $main::base/spamdb.rb.tmp: $!\n");
        binmode $spamdbFile;
        print { $spamdbFile } "\n";
    }
    my $totspam = &rb_BDB_getRecordCount('spam') || scalar keys %spam;
    my $count = 0;
    while ( ( $pair, $v ) = each(%spam) ) {
        next if (! $pair);
        $count++;
        if ($count%1000==0) {
            die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
            $main::lastd{$Iam} = "Generating weighted Bayesian tuplets $count/$totspam";
        }
        ( $s, $t ) = unpack( "LL" , $v );
        if ( $t > 1 ) {
            # if token represents all spam or all ham then square its value
            my $to = $t;
            if ( $s == $t || $s == 0 ) {
                $s = $s * $s;
                $t = $t * $t;
            }
            $v = ( 1 + $s ) / ( $t + 2 );
            if ($to < 4) {            # low occurence for spam/ham only
                if ($s == $to) {      # spam only
                    $v = $to / ($to + 1);
                } elsif ($s == 0) {   # ham only
                    $v = 1 - ($to / ($to + 1));
                }
            }
            $v = sprintf( "%.7f", $v );
            $v = 0.9999999 if $v >= 1;
            $v = 0.0000001 if $v <= 0;
            if (abs( $v - .5 ) > .09) {
                $newspam{$pair} = $v;
                print { $spamdbFile } "$pair\002$v\n" if (! $main::ReplaceOldSpamdb);
            } else {
                $bayesIgnored++;
            }
        } else {
            $bayesIgnored++;
        }
    }
    my $nowspam = &rb_BDB_getRecordCount('newspam') || scalar keys %newspam;
    eval{$spamdbFile->close;} if (! $main::ReplaceOldSpamdb);
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
    my $oldspam = &main::getDBCount('main::Spamdb','main::spamdb');
    if ($main::ReplaceOldSpamdb) {
        if ($main::spamdb ne 'DB:' or
            ($main::spamdb eq 'DB:' and $main::DBusedDriver eq 'BerkeleyDB' and $main::CanUseBerkeleyDB))
        {
            $main::lastd{$Iam} = "populating $nowspam SpamDB records";
            &rb_printlog("populating Spamdb $nowspam records - Bayesian check is now disabled\n");
            &rb_mlog("populating $nowspam Spamdb records - Bayesian check is now disabled");
            $main::lockBayes = 1;
            &rb_mlog( "try to lock Spamdb database in 5 second(s)" );
            sleep 5;
            $main::ThreadIdleTime{$main::WorkerNumber} += 5;
            %main::Spamdb = %newspam;
            $main::lockBayes = '';
            $main::lastd{$Iam} = "finished populating SpamDB records: $nowspam";
            &rb_printlog("done - populating Spamdb records - $nowspam - Bayesian check is now enabled\n");
            &rb_mlog("done - populating Spamdb records - $nowspam - Bayesian check is now enabled");
        } else {
            rb_populate_Spamdb(\%newspam,$nowspam);
        }
    } else {
        $count = 0;
        $main::lastd{$Iam} = "add/modify $nowspam SpamDB records";
        &rb_printlog("add/modify Spamdb $nowspam records\n");
        &rb_mlog("add/modify Spamdb $nowspam records");
        while ( ( $pair, $v ) = each(%newspam) ) {
            $count++;
            if ($count%1000==0) {
                die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
                $main::lastd{$Iam} = "add/modify weighted Bayesian tuplets $count/$nowspam";
            }
            $main::Spamdb{$pair} = $v;
        }
        $main::lastd{$Iam} = "finished add/modify SpamDB records: $nowspam";
        &rb_printlog("done - add/modify Spamdb records - $nowspam\n");
        &rb_mlog("done - add/modify Spamdb records - $nowspam");
    }
    &rb_printlog("done - Generating weighted Bayesian tuplets\n");
    if (! $main::ReplaceOldSpamdb) {
        my $filesize = -s "$main::base/spamdb.rb.tmp";
        &rb_printlog( "\nResulting file '$main::base/spamdb.rb.tmp' is " . &rb_commify($filesize) . " bytes\n" );
    } else {
        &rb_printlog( "\n");
    }
    my $allpairs ;
    if ($main::ReplaceOldSpamdb) {
        $allpairs = $nowspam;
    } else {
        $allpairs = &main::getDBCount('main::Spamdb','main::spamdb');
    }
    &rb_printlog("Bayesian Pairs: " . &rb_commify($allpairs) . " now in list\n");
    &rb_mlog("Bayesian Pairs: " . &rb_commify($allpairs) . " now in list");
    $main::currentDBVersion{Spamdb} = $main::Spamdb{'***DB-VERSION***'} = $main::requiredDBVersion{Spamdb};
    %spam = ();
    return $nowspam;
} ## end sub generatescores

sub rb_generateHMM {
    my $count = $spamHMM->{'chainsDB'} ? $spamHMM->{'chainsDB'}->db_stat()->{hash_ndata} : scalar keys %{$spamHMM->{chains}};
    $count +=   $spamHMM->{'totalsDB'} ? $spamHMM->{'totalsDB'}->db_stat()->{hash_ndata} : scalar keys %{$spamHMM->{totals}};
    $count +=   $hamHMM->{'chainsDB'}  ? $hamHMM->{'chainsDB' }->db_stat()->{hash_ndata} : scalar keys %{$hamHMM->{chains}};
    $count +=   $hamHMM->{'totalsDB'}  ? $hamHMM->{'totalsDB' }->db_stat()->{hash_ndata} : scalar keys %{$hamHMM->{totals}};
    $count = &rb_commify($count);
    &rb_printlog("\nGenerating consolidated Hidden-Markov-Model database from $count record model\n");
    &rb_mlog("Generating consolidated Hidden-Markov-Model database from $count record model");
    $count = 0;
    my $rec = 0;
    my $sep = $spamHMM->{seperator};
    my %spamchainseen;
    while( my ($k,$sw) = each %{$spamHMM->{chains}} ) {
        $count++;
        if ($count%1000==0) {
            die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
            $main::lastd{$Iam} = "add HMM spam sequences $count";
        }
        my ($seq) = $k =~ /^(.+)$sep[^$sep]+$/;
        next unless ($seq);
        my $ht = $hamHMM->get_totals($seq);
        my $st = $spamHMM->get_totals($seq);
        if (my $tot = $ht + $st) {
            my $hw = $hamHMM->sequence_known($k);
            my $h = $hw / $tot;
            my $s = $sw / $tot;

            my $sp = (1 - $h + $s) / 2 ;
            $sp = sprintf( "%.7f", $sp );
            $sp = 0.0000001 if $sp <= 0;
            $sp = 0.9999999 if $sp >= 1;
            if (abs( $sp - .5 ) > .09) {
                $HMMres{$k} = $sp;
                $rec++;
            } else {
                $HMMIgnored++;
            }
        }
        $spamchainseen{$k} = 1;
    }
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
    while( my ($k,$hw) = each %{$hamHMM->{chains}} ) {
        $count++;
        if ($count%1000==0) {
            die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
            $main::lastd{$Iam} = "add HMM ham sequences $count";
        }
        next if exists $spamchainseen{$k};
        my ($seq) = $k =~ /^(.+)$sep[^$sep]+$/;
        next unless ($seq);
        my $ht = $hamHMM->get_totals($seq);
        my $st = $spamHMM->get_totals($seq);
        if (my $tot = $ht + $st) {
            my $h = $hw / $tot;

            my $sp = (1 - $h) / 2 ;
            $sp = sprintf( "%.7f", $sp );
            $sp = 0.0000001 if $sp <= 0;
            $sp = 0.9999999 if $sp >= 1;
            if (abs( $sp - .5 ) > .09) {
                $HMMres{$k} = $sp;
                $rec++;
            } else {
                $HMMIgnored++;
            }
        }
    }
    &rb_printlog("HMM sequences: " . &rb_commify($rec) . " now in list\n\n");
    &rb_mlog("HMM sequences: " . &rb_commify($rec) . " now in list");
    return $rec;
}

sub rb_createheloblacklist {
    (open( my $FheloBlack, '>', "$main::base/tmpDB/rebuildDB/spamdb.helo.rb.tmp" )) || &rb_printlog("unable to open '$main::base/tmpDB/rebuildDB/spamdb.helo.rb.tmp' $!\n");
    binmode $FheloBlack;
    print { $FheloBlack } "\n";
    my $count = &rb_commify(rb_BDB_getRecordCount('Helo') || scalar keys %Helo);
    &rb_mlog("generating Spamdb.helo records from $count collected HELO's");
    &rb_printlog("generating Spamdb.helo records from $count collected HELO's\n");
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
    $count = 0;
    my $allcount = 0;
    my $notnew = 0;
    %main::HeloBlack = () if ($main::build lt 13080);
    while ( my ( $helostr, $weight ) = each(%Helo) ) {
        my $helostrlc = lc($helostr);
        my $spam = int($weight / 1000000);
        my $ham = $weight - $spam * 1000000;
# at least 5 spam weights without a ham weight [spam/(spam + 0 + .1) = 0.98 -> spam = 4.9] or
# at least 22 spam weights per ham weight      [spam/(spam + 1/3 + .1) = 0.98 -> spam = 21,7] to get HeloBlack
# at least 54 spam weights per ham weight      [spam/(spam + 1 + .1) = 0.98 -> spam = 53,9] to get HeloBlack
        my $w = $spam / ( $spam + $ham / 3 + .1 );
        if ( $w > .98 ) {
            $w = int($w + 0.5);
            print { $FheloBlack } "$helostrlc\002$w\n";
            $allcount++;
            if (exists $main::HeloBlack{$helostrlc}) {
                $notnew++;
            } elsif ($main::MaintenanceLog >= 2) {
                &rb_printlog("added new black helo '$helostrlc' to HeloBlackList\n");
                &rb_mlog("added new black helo '$helostrlc' to HeloBlackList");
            }
            $main::HeloBlack{$helostrlc} = $w;
        } elsif ($w < 0.12 && $ham > 3) {
            $w = sprintf("%.2f",(0.2 - $w));
            print { $FheloBlack } "$helostrlc\002$w\n";
            $allcount++;
            if (exists $main::HeloBlack{$helostrlc}) {
                $notnew++;
            } elsif ($main::MaintenanceLog >= 2) {
                &rb_printlog("added new good helo '$helostrlc' to HeloBlackList\n");
                &rb_mlog("added new good '$helostrlc' to HeloBlackList");
            }
            $main::HeloBlack{$helostrlc} = $w;
        } else {
            delete $Helo{$helostr};
        }
        $count++;
        if ($count%1000==0) {
            $main::lastd{$Iam} = "generating Spamdb.helo records $count";
            my $dbc = $main::HeloBlack{$helostr};
            die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
        }
    }
    eval{$FheloBlack->close;};

    $count = 0;
    if ($main::ReplaceOldSpamdb && ! $onlyNewCorrected) {
        &rb_printlog("cleaning old Spamdb.helo records\n");
        &rb_mlog("cleaning old Spamdb.helo records");
        while ( my ( $helostr, $weights ) = each(%main::HeloBlack) ) {   #   clean old records from Spamdb.Helo
            $helostr = lc($helostr);
            delete $main::HeloBlack{$helostr} if (! exists $Helo{$helostr});
            $count++;
            if ($count%1000==0) {
                $main::lastd{$Iam} = "cleaning old Spamdb.helo records $count";
                die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
            }
        }
        &rb_printlog("done - cleaning old Spamdb.helo records\n");
        &rb_mlog("done - cleaning old Spamdb.helo records");
    }
    $count = &rb_commify(&main::getDBCount('main::HeloBlack','main::spamdb'));
    my $newhelos = &rb_commify($allcount - $notnew);
    my $text = ($main::ReplaceOldSpamdb) ? 'new' : 'in new mail';
    &rb_printlog( "\nHELO Blacklist: $newhelos $text, $count now in list\n" );
    &rb_mlog( "HELO Blacklist: $newhelos $text, $count now in list" );
    return;
}

sub rb_processNewCorrected {
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
    $movetime = 0;
    my %addspam;
    my $icount = 2;
    $icount = $main::HMMDBWords * scalar(keys(%main::newReported)) if $DoHMM;
    my $newhamHMM  = ASSP::MarkovChain->new(longest => $main::HMMSequenceLength,
                                          shortest => $main::HMMSequenceLength,
                                          top => 0,
                                          nostarts => 1,
                                          initcount => $icount,
                                          simple => 1
                                          );
    my $newspamHMM = ASSP::MarkovChain->new(longest => $main::HMMSequenceLength,
                                          shortest => $main::HMMSequenceLength,
                                          top => 0,
                                          nostarts => 1,
                                          initcount => $icount,
                                          simple => 1
                                          );
# collect the SpamDB and HMM data from the files
    foreach my $file (sort { $main::newReported{$b} cmp $main::newReported{$a} } keys(%main::newReported) ) {
        my ($fldrType,$weight) = split(/\s+/o,$main::newReported{$file});
        if ($fldrType eq 'ham') {
            $weight += 5;    # 1 + 4 - equalize and correct
            $fldrType = 0;
        } else {
            $weight += 3;    # 1 + 2 - equalize and correct
            $fldrType = 1;
        }
        delete $main::newReported{$file};
        &rb_add( $fldrType, $file, $weight, \&rb_donohash, \%addspam ,$newspamHMM, $newhamHMM, 0 );
        rb_mlog("processed corrected file '$file' for SpamDB and HMMdb") if $main::MaintenanceLog > 1;
        die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
    }

    my $mod;
    my $del;
# calculate and update the SpamDB
    if ($main::haveSpamdb) {
        my $count = 0;
        my $deleted = 0;
        my $add = 0;
        if (keys(%spam)) {
            foreach (keys %addspam) {
                my ( $sfac, $tfac ) = unpack( "LL" , $addspam{ $_ } );
                my ( $sfao, $tfao ) = unpack( "LL" , $spam{ $_ } );
                $sfac += $sfao;
                $tfac += $tfao;
                $spam{ $_ } = $addspam{ $_ } = pack( "LL" , $sfac, $tfac);
            }
        }

        die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};

        my ( $t, $s, $pair, $v );
        while ( ( $pair, $v ) = each(%addspam) ) {
            next if (! $pair);
            ( $s, $t ) = unpack( "LL" , $v );
            if ( $t > 1 ) {
                # if token represents all spam or all ham then square its value
                my $to = $t;
                if ( $s == $t || $s == 0 ) {
                    $s = $s * $s;
                    $t = $t * $t;
                }
                $v = ( 1 + $s ) / ( $t + 2 );
                if ($to < 4) {            # low occurence for spam/ham only
                    if ($s == $to) {      # spam only
                        $v = $to / ($to + 1);
                    } elsif ($s == 0) {   # ham only
                        $v = 1 - ($to / ($to + 1));
                    }
                }
                $v = sprintf( "%.7f", $v );
                $v = 0.9999999 if $v >= 1;
                $v = 0.0000001 if $v <= 0;
                if (abs( $v - .5 ) > .09) {
                    $add++ unless exists $main::Spamdb{$pair};
                    $main::Spamdb{$pair} = $v;
                    $count++;
                } else {
                    delete $main::Spamdb{$pair};
                    $deleted++;
                }
            }
        }
        $main::Spamdb{'***COUNT***'} += ($add - $deleted);
        $mod = "SpamDB($count)";
        $del = "SpamDB($deleted)";
    }
    die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
# calculate and update the HMMdb
    if ($DoHMM && $main::haveHMM) {
        my $count = 0;
        my $deleted = 0;
        my $add = 0;
        my $sep = $newspamHMM->{seperator};
        foreach my $k (keys %{$newspamHMM->{chains}}) {
            my ($seq) = $k =~ /^(.+)$sep[^$sep]+$/;
            $newspamHMM->{totals}{$seq} += $spamHMM->{totals}{$seq};
            $spamHMM->{totals}{$seq} = $newspamHMM->{totals}{$seq};
            $newspamHMM->{chains}{$k} += $spamHMM->{chains}{$k};
            $spamHMM->{chains}{$k} = $newspamHMM->{chains}{$k};
        }
        foreach my $k (keys %{$newhamHMM->{chains}}) {
            my ($seq) = $k =~ /^(.+)$sep[^$sep]+$/;
            $newhamHMM->{totals}{$seq} += $hamHMM->{totals}{$seq};
            $hamHMM->{totals}{$seq} = $newhamHMM->{totals}{$seq};
            $newhamHMM->{chains}{$k} += $hamHMM->{chains}{$k};
            $hamHMM->{chains}{$k} = $newhamHMM->{chains}{$k};
        }
        die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};

        while( my ($k,$sw) = each %{$newspamHMM->{chains}} ) {
            my ($seq) = $k =~ /^(.+)$sep[^$sep]+$/;
            next unless ($seq);
            my $ht = $newhamHMM->get_totals($seq);
            my $st = $newspamHMM->get_totals($seq);
            if (my $tot = $ht + $st) {
                my $hw = $newhamHMM->sequence_known($k);
                my $h = $hw / $tot;
                my $s = $sw / $tot;

                my $sp = (1 - $h + $s) / 2 ;
                $sp = sprintf( "%.7f", $sp );
                $sp = 0.0000001 if $sp <= 0;
                $sp = 0.9999999 if $sp >= 1;
                if (abs( $sp - .5 ) > .09) {
                    $add++ unless exists $main::HMMdb{$k};
                    $main::HMMdb{$k} = $sp;
                    $count++;
                } else {
                    delete $main::HMMdb{$k};
                    $deleted++;
                }
            }
            delete ${$newhamHMM->{chains}}{$k};
        }
        &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
        while( my ($k,$hw) = each %{$newhamHMM->{chains}} ) {
            my ($seq) = $k =~ /^(.+)$sep[^$sep]+$/;
            next unless ($seq);
            my $ht = $newhamHMM->get_totals($seq);
            my $st = $newspamHMM->get_totals($seq);
            if (my $tot = $ht + $st) {
                my $h = $hw / $tot;

                my $sp = (1 - $h) / 2 ;
                $sp = sprintf( "%.7f", $sp );
                $sp = 0.0000001 if $sp <= 0;
                $sp = 0.9999999 if $sp >= 1;
                if (abs( $sp - .5 ) > .09) {
                    $add++ unless exists $main::HMMdb{$k};
                    $main::HMMdb{$k} = $sp;
                    $count++;
                } else {
                    delete $main::HMMdb{$k};
                    $deleted++;
                }
            }
        }
        $main::HMMdb{'***COUNT***'} += ($add - $deleted);
        $mod .= ' and ' if $mod;
        $mod .= "HMMdb($count)";
        $del .= ' and ' if $del;
        $del .= "HMMdb($deleted)";
    }
    if ($mod) {
        rb_mlog("updated $mod from new corrected files");
        rb_mlog("removed $del from new corrected files");
        rb_createheloblacklist();
    }
}

sub rb_processfolder {
    my ( $fldrType, $fldrpath, $filter, $weight, $sub, $MaxFiles, $neededHamWords, $neededSpamWords ) = @_;
    my ( $count, $pcount, $processFolderTime, $folderStartTime, $fileCount, @files, $deleteCount, $ignoreCount );
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);
    $MaxFiles = $main::MaxFiles;
#    $MaxFiles ||= $main::MaxFiles;
#    $MaxFiles = &main::min($MaxFiles,$main::MaxFiles);
    $folderStartTime = time;
    $attachments = 0;
    my $prebytes = $processedBytes;
    my $flr = $fldrpath;
    $fldrpath = $main::base.'/'.$fldrpath;
    $fldrpath = &rb_fixPath($fldrpath);
    &rb_printlog( "\n" . $fldrpath . "\n" );
    &rb_mlog($fldrpath);
#   $fldrpath .= $filter eq "*" ? "/*" : "/*$filter";
    $fldrpath .= '/';
    $fileCount = &rb_countfiles($fldrpath);
    &rb_printlog( "File Count:\t" . &rb_commify($fileCount) );
    &rb_mlog( "File Count:\t" . &rb_commify($fileCount) );
    my $toProcessCount = &main::min($fileCount,$MaxFiles);
    &rb_printlog("\nProcessing... $flr with ".&rb_commify($toProcessCount)." files");
    &rb_mlog("Processing... $flr with ".&rb_commify($toProcessCount)." files");
    $count = $RedCount = $WhiteCount = $deleteCount = 0;

    @files =  map { $_->[0] }
              sort { $b->[1] <=> $a->[1] }
              map { [ $_, &main::ftime($fldrpath.$_) ] } $main::unicodeDH->($fldrpath);  # youngest files first

    my ($spt,$nspt) = split(/\s+/o,($weight == 1 ? $main::MaxBayesFileAge : $main::MaxCorrectedDays));
    $nspt = $spt unless defined $nspt;
    $spt = $nspt if ! $fldrType;
    $spt *= 3600 * 24;
    my $rem = ($spt && $main::MaintBayesCollection) ? ' and remove' : '';
    &rb_printlog("\nignore$rem files older than ".&main::timestring($folderStartTime - $spt,'','')." in folder $flr") if $spt;
    &rb_mlog("ignore$rem files older than ".&main::timestring($folderStartTime - $spt,'','')." in folder $flr") if $spt;
    my %toolong;
    $disclaimerCount = 0;

    while (@files) {
        my $file = shift @files;
        $file = $fldrpath.$file;
        delete $main::newReported{$file};
        &main::ThreadYield();
        if ($count%100==0) {
            die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
            $main::lastd{$Iam} = "Processed $count/$fileCount files in $flr";
        }
        next if $main::dF->( $file );
        my $ftime = &main::ftime($file);
        next unless $ftime;
        my $dtime = $folderStartTime - $ftime;
        if ( $spt && $dtime > $spt ) {
            $count++;
            if ($main::MaintBayesCollection) {
                if ($main::unlink->($file)) {
                    $deleteCount++;
                    rb_d("removed: $file");
                } else {
                    rb_d("unable to delete file $file - $!");
                }
                next;
            }
            $ignoreCount++;
            next;
        }
        if (($pcount - ( $RedCount + $WhiteCount )) < $MaxFiles)
        {    #too many files or words;
            my $heloOnly = ((! defined $neededHamWords) && (! defined $neededSpamWords))
                        || ($neededHamWords > 0 && $neededHamWords > $HamWordCount)
                        || ($neededSpamWords > 0 && $neededSpamWords > $SpamWordCount) ? 0 : 1;
            my $d_text = 'file ('.++$pcount."/$toProcessCount)".($heloOnly ? ' [HELO only]' : '').": $file";
            rb_d( $d_text );
            $main::lastd{$Iam} = $d_text;
            my $t = Time::HiRes::time();
            my $nocheck = &rb_add( $fldrType, $file, $weight, $sub, \%spam ,$spamHMM, $hamHMM, $heloOnly);
            delete $main::newReported{ $file };
            if (! $nocheck) {
                $t = Time::HiRes::time() - $t;
                if (($mintime && $t > $mintime) or ($movetime && $t > $movetime)) {
                    $t = sprintf("%.2f",$t);
                    &rb_d( "too long file processing time: $file - $t seconds" );
                    $toolong{$file} = $t;
                }
            }
            $count += $heloOnly ? 0 : 1;
        } elsif (! $spt) {     # stop if we don't have to remove old files
            $count++;
            last;
        }
    }
    if   ( time - $folderStartTime != 0 ) { $processFolderTime = time - $folderStartTime; }
    else                                  { $processFolderTime = 1; }
    my $allpcount = $pcount;
    $pcount = $pcount - ( $RedCount + $WhiteCount );
    if ($RedCount) {
        &rb_printlog( "\nRemoved Red:\t" . &rb_commify($RedCount) );
        &rb_mlog( "Removed Red:\t" . &rb_commify($RedCount) );
    }

    if ($WhiteCount) {
        &rb_printlog( "\nRemoved White:\t" . &rb_commify($WhiteCount) );
        &rb_mlog( "Removed White:\t" . &rb_commify($WhiteCount) );
    }

    if ($deleteCount) {
        &rb_printlog( "\nRemoved Old:\t" . &rb_commify($deleteCount) );
        &rb_mlog( "Removed Old:\t" . &rb_commify($deleteCount) );
    }

    if ($ignoreCount) {
        &rb_printlog( "\nIgnored:\t" . &rb_commify($ignoreCount) );
        &rb_mlog( "Ignored:\t" . &rb_commify($ignoreCount) );
    }

    if ($doattach) {
        rb_mlog("attachment/image entries processed:\t".&rb_commify($attachments));
        rb_printlog("\nattachment/image entries processed:\t".&rb_commify($attachments));
    }

    &rb_printlog( "\nImported Files for HeloBlackList:\t" . &rb_commify($pcount) );
    &rb_mlog( "Imported Files for HeloBlackList:\t" . &rb_commify($pcount) );
    &rb_printlog( "\nImported Files for Bayes/HMM:\t" . &rb_commify($count) );
    &rb_mlog( "Imported Files for Bayes/HMM:\t" . &rb_commify($count) );
    if ($disclaimerRe && ($disclaimerCount || $RebuildDebug)) {
        &rb_printlog( "\ndisclaimer removed from\t" . &rb_commify($disclaimerCount).' files' );
        &rb_mlog( "disclaimer removed from\t" . &rb_commify($disclaimerCount).' files' );
    }
    $disclaimerCount = 0;

    if ( $count >= $main::MaxFiles ) {
        &rb_printlog("\nFolder contents exceeded 'MaxFiles'($main::MaxFiles). ");
        &rb_mlog("Folder contents exceeded 'MaxFiles'($main::MaxFiles). ");
    }

    if (($mintime or $movetime) && (my $tl = scalar keys %toolong)) {
        my $mtl = &main::min($tl,10);
        if ($mintime) {
            &rb_printlog("\nThe processing time of $tl file(s) in '$fldrpath' was longer than $mintime second(s) - now showing the $mtl longest");
            &rb_mlog("The processing time of $tl file(s) in '$fldrpath' was longer than $mintime second(s) - now showing the $mtl longest");
        }
        my $i = 0;
        my @toolong = sort { $toolong{$b} <=> $toolong{$a} } keys %toolong;
        while ( my $f = shift @toolong) {
            if ($mintime && (++$i <= $mtl)) {
                &rb_printlog("\n$f - $toolong{$f} s");
                rb_mlog("$f - $toolong{$f} s");
            }
            if ($movetime && $toolong{$f} > $movetime) {
                my $tofile = $f;
                my $base = $main::base;
                $tofile =~ s/^\Q$base\E\//$base\/rebuild_error\//;
                $main::unlink->($tofile);
                if ($main::move->($f,$tofile)) {
                    &rb_printlog("\nmoved file '$f' to '$tofile', because the processing time $toolong{$f} was longer than $movetime second(s)");
                    &rb_mlog("moved file '$f' to '$tofile', because the processing time $toolong{$f} was longer than $movetime second(s)");
                } else {
                    my $error = $!;
                    &rb_printlog("\ncan't moved file '$f' to '$tofile', the processing time $toolong{$f} was longer than $movetime second(s) - $error");
                    &rb_mlog("can't moved file '$f' to '$tofile', the processing time $toolong{$f} was longer than $movetime second(s) - $error");
                }
            }
        }
    }

# &rb_printlog( "\nfolder $flr: " . &rb_commify($SpamWordCount) . " spam weight \nfolder $flr: " . &rb_commify($HamWordCount) . " non-spam weight." );
    my $fps = sprintf("%.2f",($allpcount / $processFolderTime));
    my $procbytes = &main::formatNumDataSize($processedBytes - $prebytes);
    &rb_printlog("\nFinished in ".&rb_commify($processFolderTime)." seconds ($fps files/s - $procbytes)\n");
    &rb_mlog("Finished in ".&rb_commify($processFolderTime)." seconds ($fps files/s - $procbytes)");

    $scanTime += $processFolderTime;
    $scanFiles += $pcount;

    return $count;
} ## end sub processfolder

sub rb_countfiles {
    my ($fldrpath) = @_;
    my %fileCount;
    map {$fileCount{$_} = 1;} $main::unicodeDH->($fldrpath);
    delete $fileCount{'.'};
    delete $fileCount{'..'};
    return scalar(keys %fileCount);
}

sub rb_commify {
    my $r = shift;
    my $sep = $main::LogDateLang ? '.' : ',';
    1 while ($r =~ s/^([-+]?\d+)(\d{3})/$1$sep$2/o);
    return $r;
}

sub rb_hash {
    my ($msgText, $headlen) = @_;

    # creates a md5 hash of $msg body
    my $body = substr($$msgText,$headlen,$main::MaxBytes);
    if ($body =~ /^[\s\.]*$/so) {   # ignore empty body
        return (Time::HiRes::time());
    } else {
        return eval{ Digest::MD5::md5_hex($body); };
    }
}

sub rb_dospamhash {
    my ( $FileName, $msgText, $headlen, $this ) = @_;
    my $hash = &rb_hash($msgText, $headlen);
    $SpamHash{ $hash }++;
    $this->{FileHash} = $hash if $RebuildUsesFileModel;
    return 0;
}

sub rb_dohamhash {
    my ( $FileName, $msgText, $headlen, $this ) = @_;
    my $hash = &rb_hash($msgText, $headlen);
    $HamHash{ $hash }++;
    $this->{FileHash} = $hash if $RebuildUsesFileModel;
    return 0;
}

sub rb_donohash {
    my ( $FileName, $msgText, $headlen, $this ) = @_;
    $this->{FileHash} = &rb_hash($msgText, $headlen) if $RebuildUsesFileModel;
    return 0;
}

sub rb_checkspam {
    my ( $FileName, $msgText, $headlen, $this ) = @_;
    my ( $return, $reason );
    my $hash = &rb_hash($msgText, $headlen);
    $this->{FileHash} = $hash if $RebuildUsesFileModel;
    
    if ( defined( $HamHash{ $hash } ) ) {

# we've found a message in the spam database that is the same as one in the corrected Ham group
        &rb_deletefile( $FileName, ' - same file found in corrected ham' );
        return 1;
    }
    if ( $main::DoRBRed && ($reason = &rb_redlisted( $msgText )) ) {
        &rb_deletefile( $FileName, $reason );
        return 1;
    }
    if ( $main::DoRBWhite && ($reason = &rb_whitelisted( $msgText )) ) {
        &rb_deletefile( $FileName, $reason );
        return 1;
    }
    delete $Trashlist{&main::de8($FileName)};
    return 0;
}

sub rb_checkham {
    my ( $FileName, $msgText, $headlen, $this ) = @_;
    my ( $return, $reason );
    my $hash = &rb_hash($msgText, $headlen);
    $this->{FileHash} = $hash if $RebuildUsesFileModel;

    if ( defined( $SpamHash{ $hash } ) ) {

# we've found a message in the ham database that is the same as one in the corrected spam group
        &rb_deletefile( $FileName, ' - same file found in corrected spam' );
        return 1;
    }
    if ( $main::DoRBRed && ($reason = &rb_redlisted( $msgText )) ) {
        &rb_deletefile( $FileName, "$reason" );
        return 1;
    }
    if ( $main::DoRBBlack && ($reason = &rb_blacklisted( $msgText )) ) {
        &rb_deletefile( $FileName, "$reason" );
        return 1;
    }
    delete $Trashlist{&main::de8($FileName)};
    return 0;
}

sub rb_whitelisted {
    my $mm = shift;
    my $m = substr($$mm,0,$main::MaxBytes + 1000);
    my %seenf;
    my $conip;

    # test against expression to recognize whitelisted mail
    my $mwr = $main::whiteReRE;
    if ( $main::whiteRe && $m =~ /($mwr)/ ) {
        my $reason = $1;
        $reason =~ s/\s+\z/ /gos;
        $reason =~ s/\s+/ /gos;
        if ( length($reason) >= $main::RegExLength ) { $reason = substr( $reason, 0, ( $main::RegExLength - 4 ) ) . "..." }
        $WhiteCount++;
        return ( "Regex:White '" . $reason . q{'} );
    }

        # test against expression to recognize noprocessing mail
    $mwr = $main::npReRE;
    if ( $main::npRe && $m =~ /($mwr)/ ) {
        my $reason = $1;
        $reason =~ s/\s+\z/ /gos;
        $reason =~ s/\s+/ /gos;
        if ( length($reason) >= $main::RegExLength ) { $reason = substr( $reason, 0, ( $main::RegExLength - 4 ) ) . "..." }
        $WhiteCount++;
        return ( "Regex:NoProcessing '" . $reason . q{'} );
    }

    $m =~ s/\n\r?\n.*$//so;   # remove body
    
    die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};

    my (@to,@from,@indentity,$mailfrom,$dkimpass);
    while ( $m =~ /($main::HeaderNameRe):($main::HeaderValueRe)/igos ) {
        my ($h,$s) = ($1,$2);
        if ($h =~ /^(?:X-)?Original-Authentication-Results$/io) {
            &main::headerUnwrap($s);
            next if $s !~ /(?:\Q$main::ARCSigningHost\E|\Q$main::myName\E)/i;
            $dkimpass = $s =~ /dkim=pass/;
            next;
        }
        if ($h =~ /^(?:from|sender|X-Assp-Envelope-From|reply-to|errors-to|list-\w+)$/io) {
            &main::headerUnwrap($s);
            if (my $res = &main::getEmailAddr($s)) {
               $res = &main::batv_remove_tag(0,lc($res),'');
               push(@from , $res);
               $mailfrom = $res if $h =~ /^X-Assp-Envelope-From/o;
            }
            next;
        }
        if ($h =~ /^(?:to|X-Assp-Intended-For)$/io) {
            &main::headerUnwrap($s);
            if (my $res = &main::getEmailAddr($s)) {
               push(@to , &main::batv_remove_tag(0,lc($res),''));
            }
            next;
        }
        if ($h =~ /^(?:X-ASSP-DKIMidentity)$/io) {
            &main::headerUnwrap($s);
            if (my $res = &main::getEmailAddr($s)) {
               push(@indentity , &main::batv_remove_tag(0,lc($res),''));
            }
            next;
        }
        if ($h =~ /received/io) {
            &main::headerSmartUnwrap($s);
            if ($s =~ /from\s+[^\(]*\(\[($main::IPRe).{1,5}helo=[^\)]{0,64}\)(?:\s+by\s+(?:$MyName))\s+with/is) {
                my $ip = &main::ipv6expand(&main::ipv6TOipv4($1));
                $conip = $ip if $ip !~ /$main::IPprivate/o;
            }
            next;
        }
    }
    die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};

    if ($main::noProcessingDomains && $mailfrom =~ /$main::NPDRE/) {
        $WhiteCount++;
        return ( "noProcessing Domain: '" . $mailfrom . q{'} );
    }

    if ($mailfrom && $dkimpass && ($canWLAddr || $canNPAddr) && @indentity) {
        my @tocheck = @indentity;
        my %seent;
        foreach (@to) {
            if ( exists $seent{ $_ } ) {
                next;                #we already checked this address
            } else {
                $seent{ $_ } = 1;
            }
            push(@tocheck,"$tocheck[0],$_");
        }
        if ($canWLAddr && &main::matchRE(\@tocheck,'DKIMWLAddresses')) {
            $WhiteCount++;
            return ( "DKIMWLAddresses: '" . $tocheck[0] . q{'} );
        }
        if ($canNPAddr && &main::matchRE(\@tocheck,'DKIMNPAddresses')) {
            $WhiteCount++;
            return ( "DKIMNPAddresses: '" . $tocheck[0] . q{'} );
        }
    }

    if ($conip) {
        my $tmpfh = time;
        $main::Con{$tmpfh} = {};
        $main::Con{$tmpfh}->{rcpt} = join(' ',@to);
        $main::Con{$tmpfh}->{rcptlist} = {};
        if ($main::noProcessingIPs && &main::matchIP($conip,'noProcessingIPs',$tmpfh,1)) {
            $WhiteCount++;
            delete $main::Con{$tmpfh};
            return ( "noProcessingIP: '" . $conip . q{'} );
        }
        if ($main::whiteListedIPs && &main::matchIP($conip,'whiteListedIPs',$tmpfh,1)) {
            $WhiteCount++;
            delete $main::Con{$tmpfh};
            return ( "whiteListedIPs: '" . $conip . q{'} );
        }
        delete $main::Con{$tmpfh};
    }
    
    while (my $curaddr = shift @from) {
        if ( exists $seenf{ $curaddr } ) {
            next;                #we already checked this address
        } else {
            $seenf{ $curaddr } = 1;
        }
        if ($main::whiteListedDomains && &main::matchRE([$curaddr],'whiteListedDomains',1)) {
            $WhiteCount++;
            return ( "WhiteListed Domain: '" . $curaddr . q{'} );
        }
        my %seent;
        foreach (@to) {
            if ( exists $seent{ $_ } ) {
                next;                #we already checked this address
            } else {
                $seent{ $_ } = 1;
            }
            if ( &main::Whitelist($curaddr,$_)) {
                $WhiteCount++;
                return ( "WhiteList: '$curaddr,$_'" );
            }
            if ($main::whiteListedDomains && &main::matchRE(["$curaddr,$_"],'whiteListedDomains',1)) {
                $WhiteCount++;
                return ( "WhiteListed Domain: $curaddr for $_" );
            }
        }
    } ## end while
    return 0;
} ## end sub white listed

sub rb_redlisted {
    my $mm = shift;
    my $m = substr($$mm,0,$main::MaxBytes + 1000);

    # test against expression to recognize redlisted mail
    if ( $main::DoNotCollectRedRe && $main::redRe) {    #skip Redre check, 1.3.5 and higher
        my $mrR = $main::redReRE;
        if ( $m =~ /($mrR)/ ) {
            my $reason = $1;
            $reason =~ s/\s+\z/ /go;
            $reason =~ s/\s+/ /go;
            if ( length($reason) >= $main::RegExLength ) { $reason = substr( $reason, 0, ( $main::RegExLength - 4 ) ) . "..." }
            $RedCount++;
            return ( "Regex:Red '" . $reason . q{'} );
        }
    }
    die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
    return 0 unless $haveRedlist;
    if ( $main::DoNotCollectRedList ) {    #skip Redlist check, 1.3.5 and higher
        $m =~ s/\n\r?\n.*\z//so;                            # remove body
        while ( $m =~ /($main::HeaderNameRe):($main::HeaderValueRe)/igos ) {
            my ($h,$s) = ($1,$2);
            if ($h =~ /^(?:to|X-Assp-Intended-For|from|sender|X-Assp-Envelope-From|reply-to|errors-to|list-\w+)$/io) {
                &main::headerUnwrap($s);
                if (my $res = &main::getEmailAddr($s)) {
                    my $curaddr = lc($res);
                    if ( $main::Redlist{ $curaddr } ) {
                        $RedCount++;
                        return ( "redlist: '" . $curaddr . q{'} );
                    }
                }
            }
        }
    }
    return 0;
} ## end sub redlisted

sub rb_blacklisted {
    my $mm = shift;
    my $m = substr($$mm,0,$main::MaxBytes + 1000);
    my %seenf;
    my $conip;

    die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};

    my (@to,@from,$mailfrom);
    while ( $m =~ /($main::HeaderNameRe):($main::HeaderValueRe)/igos ) {
        my ($h,$s) = ($1,$2);
        if ($h =~ /^(?:from|sender|X-Assp-Envelope-From|reply-to|errors-to|list-\w+)$/io) {
            &main::headerUnwrap($s);
            if (my $res = &main::getEmailAddr($s)) {
               $res = &main::batv_remove_tag(0,lc($res),'');
               push(@from , $res);
               $mailfrom = $res if $h =~ /^X-Assp-Envelope-From/o;
            }
            next;
        }
        if ($h =~ /^(?:to|X-Assp-Intended-For)$/io) {
            &main::headerUnwrap($s);
            if (my $res = &main::getEmailAddr($s)) {
               push(@to , &main::batv_remove_tag(0,lc($res),''));
            }
            next;
        }
        if ($h =~ /received/io) {
            &main::headerSmartUnwrap($s);
            if ($s =~ /from\s+[^\(]*\(\[($main::IPRe).{1,5}helo=[^\)]{0,64}\)(?:\s+by\s+(?:$MyName))\s+with/is) {
                my $ip = &main::ipv6expand(&main::ipv6TOipv4($1));
                $conip = $ip if $ip !~ /$main::IPprivate/o;
            }
            next;
        }
    }
    die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};

    if ($conip) {
        my $tmpfh = time;
        $main::Con{$tmpfh} = {};
        $main::Con{$tmpfh}->{rcpt} = join(' ',@to);
        $main::Con{$tmpfh}->{rcptlist} = {};
        if ($main::noBlockingIPs && ! &main::matchIP($conip,'noBlockingIPs',$tmpfh,1)) {
            if ($main::DoDenySMTPstrict && $main::denySMTPConnectionsFromAlways && &main::matchIP($conip,'denySMTPConnectionsFromAlways',$tmpfh,1)) {
                delete $main::Con{$tmpfh};
                return ( "denySMTPConnectionsFromAlways: '" . $conip . q{'} );
            }
            if ($main::DoDenySMTP && $main::denySMTPConnectionsFrom && &main::matchIP($conip,'denySMTPConnectionsFrom',$tmpfh,1)) {
                delete $main::Con{$tmpfh};
                return ( "denySMTPConnectionsFrom: '" . $conip . q{'} );
            }
        }
        delete $main::Con{$tmpfh};
    }

    while (my $curaddr = shift @from) {
        if ( exists $seenf{ $curaddr } ) {
            next;                #we already checked this address
        } else {
            $seenf{ $curaddr } = 1;
        }
        if ($main::blackListedDomains && &main::matchRE([$curaddr],'blackListedDomains',1)) {
            return ( "BlackListed Domain: '" . $curaddr . q{'} );
        }
        my %seent;
        foreach (@to) {
            if ( exists $seent{ $_ } ) {
                next;                #we already checked this address
            } else {
                $seent{ $_ } = 1;
            }
            if ($main::whiteListedDomains && &main::matchRE(["$curaddr,$_"],'blackListedDomains',1)) {
                return ( "BlackListed Domain: $curaddr for $_" );
            }
        }
    } ## end while
    return 0;
} ## end sub black listed

sub rb_deletefile {
    my ( $fn, $reason, $ignorekeepdeleted ) = @_;

    my $fn8 = &main::de8($fn);
    if ( $main::eF->( $fn )) {
        &rb_printlog( "\nremove " . $fn8 . q{ } . $reason ) unless $Trashlist{$fn8};
        if (! $main::RebuildTestMode) {
            if ( $main::MaxKeepDeleted && !$ignorekeepdeleted ) {
                $Trashlist{$fn8} ||= time;
            } else {
                $main::unlink->($fn) ||
                rb_printlog("\ncannot delete " . $reason . " message " . $fn8 . ": $!" );
            }
        }
    } else {
        rb_printlog("\ncannot remove " . $reason . " message " . $fn8 . ": no such file" );
    }
    rb_removeFileModelEntry($fn);
}

sub rb_get {
    my ( $fn, $sub , $factor, $this) = @_;
    my $message;
    my $count;
    my $numreadchars;
    my $headlen;
    my $mBytes = $main::MaxBytes || 4000;
    my $ftime = &main::ftime($fn);
    return unless $ftime;
    my $dtime = $ftime - time;
    my $bodybytes = $mBytes * 4;

    return if $dtime > 0;
    my $file;
    $main::open->($file, '<', "$fn" ) or return;

    $file->binmode;
    $numreadchars = ($main::HeaderMaxLength ? $main::HeaderMaxLength : 10000) + $bodybytes;
#rb_d("rb_get - $fn - to read - $numreadchars - $file");
    $count = $file->read( $message, $numreadchars );    # read characters into memory
#rb_d("rb_get - $fn - read");
    eval{$file->close;};
    if ($count) {
        my @keep = $message =~ /((?:X-Assp-Reported-By|X-Assp-Intended-For|X-Forwarded-For):$main::HeaderValueRe)/gois;
        $message =~ s/X-ASSP[\x00-\x39\x3b-\xff]+:$main::HeaderValueRe//gois;                   # remove all X-ASSP headers
        $message =~ s/(?:X-Google-)?(?:DKIM|DomainKey)-Signature:$main::HeaderValueRe//gios;  # remove DKIM/DomainKey signatures
        $message =~ s/ARC-(?:Seal|Message-Signature|Authentication-Results):$main::HeaderValueRe//gios;  # remove ARC signatures
        $message = join('',@keep).$message;
        $headlen = index($message, "\x0D\x0A\x0D\x0A");
        if ($headlen >= 0) {$headlen += 4;} else {$headlen = 0;}
        $message = substr($message, 0, $headlen + $bodybytes);
    } else {
        return;
    }
    if ($sub->( $fn, \$message, $headlen, $this )) {   # did I read this before?
        return;
    }
    
    $processedBytes += length $message;
    $this->{processedBytes} = length $message if $RebuildUsesFileModel;
    return \$message, $headlen;
}

sub rb_checkRunTime {
    my ($StartTime, $text) = @_;
    return 0 unless $movetime;
    $rtText = $text if $text;
    return 0 if Time::HiRes::time() <= ($StartTime + $movetime);
    rb_d($rtText);
    return 1;
}

sub rb_add {
    my ( $isspam, $fn, $factor, $sub, $spam ,$spamHMM, $hamHMM, $heloOnly) = @_;
    return if $main::dF->( $fn );
    $isspam ||= 0;
    my $startTime = Time::HiRes::time();
    my $imgHash;
    my ( $curHelo, $CurWord, $PrevWord, $sfac, $tfac, $cip, $cipHelo );
    my ($reportedBy,$domain);
    my $BayesCont = $main::BayesCont;
    my @HMMWords;
    my $ret = 1;
    my $sfactor = ($isspam == 1) ? $factor : 0;
    my $words = 0;
    my $maxWords = $main::HMMDBWords;
    my $i = 0;
    my $this;
    $this = $FileModel->{$fn} if $RebuildUsesFileModel && exists $FileModel->{$fn};
    
    # process available FileModel data
    if (   $RebuildUsesFileModel
        && $this
        && ! exists $Trashlist{&main::de8($fn)}
        && ($heloOnly || @{$this->{words}})
        && (   $sub eq \&rb_dospamhash || $sub eq \&rb_dohamhash || $sub eq \&rb_donohash          # corrections
            || ($sub eq \&rb_checkspam && ! defined( $HamHash{$this->{FileHash}} ))      # spam
            || ($sub eq \&rb_checkham && ! defined( $SpamHash{$this->{FileHash}} ))      # ham
           )
       )
    {
        $HamHash{$this->{FileHash}}++ if $sub eq \&rb_dohamhash;
        $SpamHash{$this->{FileHash}}++ if $sub eq \&rb_dospamhash;
        $cipHelo = $this->{cipHelo};
        $curHelo = $this->{curHelo};
        $cipHelo = '' if $cipHelo eq $curHelo;
        $Helo{ $cipHelo } += ( $isspam * 999999 + 1 ) * $factor if ( $cipHelo );
        $Helo{ $curHelo } += ( $isspam * 999999 + 1 ) * $factor if ( $curHelo );
        return 1 if $heloOnly;

        $disclaimerCount += $this->{disclaimerCount};

        $domain = $this->{domain};
        $reportedBy = $this->{reportedBy};

        $i = 0;
        foreach (keys %{$this->{imgHash}}) {
            if   ($isspam == 1) { $SpamWordCount += $factor;}
            else                { $HamWordCount  += $factor;}

            ( $sfac, $tfac ) = unpack( "LL" , $spam->{ $_ } );
            $sfac += ($isspam == 1) ? ($factor * 2) : 0;
            $tfac += ($factor * 2);
            $spam->{ $_ } = pack( "LL", $sfac, $tfac);
            $i++;
            if ($reportedBy) {
                ( $sfac, $tfac ) = unpack( "LL" , $spam->{ "$reportedBy $_" } );
                $sfac += ($isspam == 1) ? $factor : 0;
                $tfac += $factor;
                $spam->{ "$reportedBy $_" } = pack( "LL", $sfac, $tfac);
            }
            if ($domain) {
                ( $sfac, $tfac ) = unpack( "LL" , $spam->{ "$domain $_" } );
                $sfac += ($isspam == 1) ? $factor : 0;
                $tfac += $factor;
                $spam->{ "$domain $_" } = pack( "LL", $sfac, $tfac);
            }
        }
        $attachments += $i;
        if ($doattach && $i) {
            rb_d("$i ".(($isspam == 1) ? 'spam-' : 'ham-')."attachment/image entries processed in file $fn");
        }

        $i = 0;
        $PrevWord = undef;
        map {
            $CurWord = $_;
            if ($CurWord) {
                if ( $PrevWord ) {
                    # increment global weights, they are not really word counts
                    $words += $factor;

                    my $tag = "$PrevWord $CurWord";
                    ( $sfac, $tfac ) = unpack( "LL", $spam->{ $tag } );
                    $sfac += $sfactor;
                    $tfac += $factor;
                    $spam->{ $tag } = pack( "LL", $sfac, $tfac);
                    if ($reportedBy) {
                        my $rtag = "$reportedBy $tag";
                        ( $sfac, $tfac ) = unpack( "LL", $spam->{ $rtag } );
                        $sfac += $sfactor;
                        $tfac += $factor;
                        $spam->{ $rtag } = pack( "LL", $sfac, $tfac);
                    }
                    if ($domain) {
                        my $dtag = "$domain $tag";
                        ( $sfac, $tfac ) = unpack( "LL", $spam->{ $dtag } );
                        $sfac += $sfactor;
                        $tfac += $factor;
                        $spam->{ $dtag } = pack( "LL", $sfac, $tfac);
                    }
                }
                push(@HMMWords,$CurWord) if $DoHMM && ($i++ < $maxWords);
                $PrevWord = $CurWord;
            }
        } @{$this->{words}};

        if ($isspam == 1) {
            $SpamWordCount += $words;
        } else {
            $HamWordCount  += $words;
        }

        if ($DoHMM) {
            my @privacy;
            push @privacy, $domain if $domain;
            push @privacy, $reportedBy if $reportedBy;

            if ($isspam == 1) {
                if (@HMMWords > $main::HMMSequenceLength) {$spamHMM->seed(symbols => \@HMMWords, count => $factor, privacy => \@privacy);}
            } else {
                if (@HMMWords > $main::HMMSequenceLength) { $hamHMM->seed(symbols => \@HMMWords, count => $factor, privacy => \@privacy);}
            }
        }

        $processedBytes += $this->{processedBytes};

        return $ret;

    } elsif (exists $Trashlist{&main::de8($fn)}) {
        rb_removeFileModelEntry($fn);
        return;
    } elsif ($RebuildUsesFileModel) {
    # initialize the FileModel for this file;
        $this = {};
        rb_removeFileModelEntry($fn);
        $this->{cipHelo} = '';
        $this->{curHelo} = '';
        $this->{disclaimerCount} = 0;
        $this->{domain} = '';
        $this->{reportedBy} = '';
        $this->{imgHash} = {};
        $this->{words} = [];
        $this->{processedBytes} = 0;
    } else {
        $this = {};
    }
    # end of fast processing from the FileModel

    # process the file
    my ($content,$headerlen) = &rb_get( $fn, $sub , $factor, $this);
    if (! $content) {
        rb_removeFileModelEntry($fn);
        return;
    }
    if (rb_checkRunTime($startTime,"reached $movetime s after getting $fn")) {
        rb_removeFileModelEntry($fn);
        return;
    }
    
    my $header;
    $header = substr($$content,0,$headerlen);
    if ($header =~ /(?:^|\n)subject:($main::HeaderValueRe)/ios) {
        my $sub = $1;
        &main::headerUnwrap($sub);
        $sub =~ s/\r|\n|\t//go;
        $sub = &main::decodeMimeWords2UTF8($sub);
        if ($sub =~ /$main::DMARCReportSubjectRe/io) {
            rb_d("file '$fn' is removed - it is a DMARC report" );
            &rb_deletefile( $fn, ' - is a DMARC report' );
            return;
        }
    }

    if ($doattach && ! $heloOnly && ((my $fsize = &main::fsize( $fn )) < $main::npSize) && ! exists $Trashlist{&main::de8($fn).'.att'}) {
        $this->{imgHash} = $imgHash = &main::AttachMD5File($fn);
        $processedBytes += $fsize - length($$content);
        $this->{processedBytes} += $fsize - length($$content);
        if (rb_checkRunTime($startTime,"reached $movetime s after AttachMD5File on $fn")) {
            $Trashlist{&main::de8($fn).'.att'} = time + (3600 * 24 * 5);
            $startTime = Time::HiRes::time();
            rb_printlog("\nfile '$fn' will be skipped from attachment processing in future rebuild tasks" );
            rb_mlog("file '$fn' will be skipped from attachment processing in future rebuild tasks" );
        }
    } elsif ($doattach && ! $heloOnly && ($fsize < $main::npSize)) {
        rb_d("file '$fn' will was skipped from attachment processing" );
    }

    my $IPprivate = $main::IPprivate;
    if ($header) {
        my $r;
        $reportedBy = lc ($r || $1) if (   $header =~ /X-Assp-Reported-By:\s*($main::EmailAdrRe\@$main::EmailDomainRe)/io
                                        || $header =~ /X-Assp-Intended-For:\s*($main::EmailAdrRe\@$main::EmailDomainRe)/io
                                        || ($header =~ /^to:($main::HeadreValueRe)/io && ($r = &main::getEmailAddr($1)) )
                                       );
        if ($reportedBy) {
            $domain = $1 if $reportedBy =~ /(\@$main::EmailDomainRe)$/o;
            $reportedBy = '' unless (($main::DoPrivatSpamdb & 1) && &main::localmailaddress(0,$reportedBy));
            $domain = '' unless ($main::DoPrivatSpamdb > 1 && &main::localdomainsreal($domain));
        }
        if ( $header =~ /X-Forwarded-For: ($IPRe)/io) {
            $cip = $1;
    		while ( $header =~ /($main::HeaderNameRe):($main::HeaderValueRe)/gios) {
                next if lc($1) ne 'received';
                my $h = $2;
                if ( $h =~ /\s+from\s+(?:(\S+)\s)?(?:.+?)\Q$cip\E(?::$PortRe)?\]?\)(.{1,80})by.{1,20}/gis ) {
                    $cipHelo = $1;
                    $curHelo = $1 if $1;
                    my $rhelo = $2;
                    $cip = &main::ipv6expand(&main::ipv6TOipv4($cip));
                    $rhelo =~ s/\r?\n/ /go;                                # [^\s\)]
                    $curHelo = $cipHelo = $1 if $rhelo =~ /.+?helo\s*=?\s*([\x00-\x08\x0e-\x1f\x21-\x28\x2a-\x84\x86-\x9f\xa1-\xff]+)/io;
                }
            }
            if ($cip && &main::matchIP($cip,'ispip','',1)) {
                $cipHelo = '';
                $curHelo = '';
                $cip = '';
            }
        } elsif ( $main::ispHostnames ) {
            while ( $header =~ /($main::HeaderNameRe):($main::HeaderValueRe)/gios ) {
                next if lc($1) ne 'received';
                my $h = $2;
                if ( $h =~ /\s+from\s+(?:(\S+)\s)?(?:.+?)($IPRe)(.{1,80})by.{1,20}(?:$main::ispHostnamesRE)/gios ) {
                    $cip = $2;
                    $cipHelo = $1 || $cip;
                    my $rhelo = $3;
                    if ($cip =~ /$IPprivate/o) {
                        $cipHelo = '';
                        $rhelo = '';
                        next;
                    }

                    $cip = &main::ipv6expand(&main::ipv6TOipv4($cip));
                    $rhelo =~ s/\r?\n/ /gos;                  # [^\s\)]
                    $cipHelo = $1 if $rhelo =~ /helo\s*=?\s*([\x00-\x08\x0e-\x1f\x21-\x28\x2a-\x84\x86-\x9f\xa1-\xff]+)/io;
                }
            }
            if ($cip && &main::matchIP($cip,'ispip','',1)) {
                $cipHelo = '';
                $curHelo = '';
                $cip = '';
            }
        }

        my @myNames = ($main::myName);
        push @myNames , split(/[\|, ]+/o,$main::myNameAlso);
        my $myName = join('|', map {my $t = quotemeta($_);$t;} @myNames);

        if (   $myName
            && ! ($cipHelo or $curHelo)
            && $header =~ /Received: from (\S+).{1,20}\(\[($IPRe)(.{1,80})by.{1,20}(?:$myName)/is)
        {
            $curHelo = $1 || $2;
            my $ip = $2;
            my $rhelo = $3;
            if ($ip !~ /$IPprivate/o) {
                $cip = &main::ipv6expand(&main::ipv6TOipv4($ip));
                $rhelo =~ s/\r?\n/ /gos;
                $curHelo = $1 if $rhelo =~ /\shelo=([\x00-\x08\x0e-\x1f\x21-\x28\x2a-\x84\x86-\x9f\xa1-\xff]+)/io;
                if ($cip && &main::matchIP($cip,'ispip','',1)) {
                    $curHelo = '';
                    $cip = '';
                }
                if ($curHelo && $curHelo =~ /$main::ispHostnamesRE/) {
                    $curHelo = '';
                    $cip = '';
                }
            } else {
                $curHelo = '';
            }
        }
    }
    if (rb_checkRunTime($startTime,"reached $movetime s after HELO parsing on $fn")) {
        rb_removeFileModelEntry($fn);
        return;
    }
    
    $this->{domain} = $domain;
    $this->{reportedBy} = $reportedBy;
    
    $cipHelo = lc($cipHelo);
    $curHelo = lc($curHelo);
    $cipHelo = '' if $cipHelo eq $curHelo;
    $this->{cipHelo} = $cipHelo;
    $this->{curHelo} = $curHelo;
    $Helo{ $cipHelo } += ( $isspam * 999999 + 1 ) * $factor if ( $cipHelo );
    $Helo{ $curHelo } += ( $isspam * 999999 + 1 ) * $factor if ( $curHelo );
    if ($heloOnly) {
        $FileModel->{$fn} = $this if ($RebuildUsesFileModel);
        return 1;
    }

    $$content =~ s/(?:X-Assp-Reported-By|X-Assp-Intended-For|X-Forwarded-For):$main::HeaderValueRe//gois;
    my $OK;
    ($content,$OK) = &main::clean($content);
    if (rb_checkRunTime($startTime,"reached $movetime s after content cleanup on $fn")) {
        rb_removeFileModelEntry($fn);
        return;
    }
    if ($disclaimerRe && eval{$content =~ s/$disclaimerRe//g}) {
        rb_d("disclaimer removed in file $fn");
        $disclaimerCount++;
        $this->{disclaimerCount} = 1;
    }

    $i = 0;
    foreach (keys %$imgHash) {
        if   ($isspam == 1) { $SpamWordCount += $factor;}
        else                { $HamWordCount  += $factor;}

        ( $sfac, $tfac ) = unpack( "LL" , $spam->{ $_ } );
        $sfac += ($isspam == 1) ? ($factor * 2) : 0;
        $tfac += ($factor * 2);
        $spam->{ $_ } = pack( "LL", $sfac, $tfac);
        $i++;
        if ($reportedBy) {
            ( $sfac, $tfac ) = unpack( "LL" , $spam->{ "$reportedBy $_" } );
            $sfac += ($isspam == 1) ? $factor : 0;
            $tfac += $factor;
            $spam->{ "$reportedBy $_" } = pack( "LL", $sfac, $tfac);
        }
        if ($domain) {
            ( $sfac, $tfac ) = unpack( "LL" , $spam->{ "$domain $_" } );
            $sfac += ($isspam == 1) ? $factor : 0;
            $tfac += $factor;
            $spam->{ "$domain $_" } = pack( "LL", $sfac, $tfac);
        }
    }
    $attachments += $i;
    if ($doattach && $i) {
        rb_d("$i ".(($isspam == 1) ? 'spam-' : 'ham-')."attachment/image entries processed in file $fn");
    }
    rb_checkRunTime($startTime,"reached $movetime s in Bayes word pairs on $fn");
    $i = 0;
    $PrevWord = undef;
    local $@;
    eval {
        map {
            $CurWord = substr($_,0,37);
            $CurWord =~ s/\s//go;
            if ($CurWord) {
                if ( $PrevWord ) {
                    # increment global weights, they are not really word counts
                    $words += $factor;

                    my $tag = "$PrevWord $CurWord";
                    ( $sfac, $tfac ) = unpack( "LL", $spam->{ $tag } );
                    $sfac += $sfactor;
                    $tfac += $factor;
                    $spam->{ $tag } = pack( "LL", $sfac, $tfac);
                    if ($reportedBy) {
                        my $rtag = "$reportedBy $tag";
                        ( $sfac, $tfac ) = unpack( "LL", $spam->{ $rtag } );
                        $sfac += $sfactor;
                        $tfac += $factor;
                        $spam->{ $rtag } = pack( "LL", $sfac, $tfac);
                    }
                    if ($domain) {
                        my $dtag = "$domain $tag";
                        ( $sfac, $tfac ) = unpack( "LL", $spam->{ $dtag } );
                        $sfac += $sfactor;
                        $tfac += $factor;
                        $spam->{ $dtag } = pack( "LL", $sfac, $tfac);
                    }
                }
                push(@HMMWords,$CurWord) if $DoHMM && ($i++ < $maxWords);
                push(@{$this->{words}},$CurWord);
                $PrevWord = $CurWord;
            }
        } map { &main::BayesWordClean($_); } $content =~ /([$BayesCont]{2,})/go;
    };
    if ($@) {
        rb_printlog("\nfile '$fn': any text part contains characters, which can't be converted to UTF8 (e.g. unknown charset or DoS) - in doubt remove the file" );
        rb_mlog("file '$fn': any text part contains characters, which can't be converted to UTF8 (e.g. unknown charset or DoS) - in doubt remove the file" );
    }
    
    if ($isspam == 1) {
        $SpamWordCount += $words;
    } else {
        $HamWordCount  += $words;
    }

    if ($DoHMM) {
        my @privacy;
        push @privacy, $domain if $domain;
        push @privacy, $reportedBy if $reportedBy;
#        &rb_d( "file $fn , isspam = $isspam , factor = $factor , adding HMM: ".(($isspam == 1) ? 'S = ' : 'H = ').scalar(@HMMWords)." words, P = @privacy");

        if ($isspam == 1) {
            if (@HMMWords > $main::HMMSequenceLength) {$spamHMM->seed(symbols => \@HMMWords, count => $factor, privacy => \@privacy);}
        } else {
            if (@HMMWords > $main::HMMSequenceLength) { $hamHMM->seed(symbols => \@HMMWords, count => $factor, privacy => \@privacy);}
        }
#        rb_d("after file $fn , spam - totals: ".keys(%{$spamHMM->{totals}}).' , chains: '.keys(%{$spamHMM->{chains}}).', ham - totals: '.keys(%{$hamHMM->{totals}}).' , chains: '.keys(%{$hamHMM->{chains}}));
    }

    $FileModel->{$fn} = $this if ($RebuildUsesFileModel);

    return $ret;
} ## end sub add

sub rb_printlog {
    my ( $text, $format, $notime ) = @_;
    my $lf = '';
    $lf = $1 if $text =~ s/^(\n+)//o;
    if ( ! $format ) {
        if ($text) {
            my $t = $notime ? '' : &main::timestring();
            print { $RebuildLog } $lf . $t . " $text" if ! $onlyNewCorrected;
            &main::d($text);
        } else {
            print { $RebuildLog } $lf if ! $onlyNewCorrected;
        }
    } else {
        if ($text) {
            my $t = $notime ? ' ' : &main::timestring().' ';
            print { $RebuildLog } $lf . $t if ! $onlyNewCorrected;
            printf $RebuildLog "$text", $format if ! $onlyNewCorrected;
            &main::d(sprintf("$text", $format));
        } else {
            print { $RebuildLog } $lf if ! $onlyNewCorrected;
        }
    }
    $RebuildLog->flush if fileno($RebuildLog);
    return;
}

sub rb_mlog {
    my ( $text, $format ) = @_;
    rb_d( $text, $format ) if $RebuildDebug;
    return unless $main::MaintenanceLog;
    if ( !$format ) {
        &main::mlog(0, "$text");
    }
    if ($format) {
        &main::mlog(0,(sprintf "$text", $format));
    }
    return;
}

sub rb_d {
    my ( $text, $format, $notime ) = @_;
    return if (! $RebuildDebug);
    my $t;
    $t = &main::timestring().' ' unless $notime;
    if ( !$format ) {
        print $RebuildDebug "$t$text\n";
    }
    if ($format) {
        print $RebuildDebug sprintf("$t$text\n", $format);
    }
    $RebuildDebug->flush if fileno($RebuildDebug);
    return;
}

sub rb_uploadgriplist {
    local $/ = "\n";

    $main::NextGriplistUpload = $main::Griplist{'255.255.255.253'} = time + 23 * 3600 + int(rand(7200));
    
    &main::checkDBCon() if ($main::CanUseTieRDBM && $main::DBisUsed);

    &rb_printlog("\nbuilding new GripList records and bounce report\n") if !$main::noGriplistUpload;
    &rb_mlog("building new GripList records and bounce report") if !$main::noGriplistUpload;

    #&rb_printlog("Start building Griplist \n");
    my ( $date, $ip, $peeraddress, $hostaddress, $connect, $day, $gooddays, $last2days, $st );
    my ($logdir, $logdirfile) = $main::logfile=~/^(.*[\/\\])?(.*?)$/o;
    my @logfiles1=reverse sort( &main::Glob("$main::base/$logdir*$logdirfile") );
    my @logfiles;
    while (@logfiles1) {
        my $k = shift @logfiles1;
        push(@logfiles, $k) if $k !~ /b$logdirfile/;
    }

    #build list of the last 4 days
    my $time = time;
    $day = quotemeta(&main::timestring(undef,'d'));
    $gooddays  .= $day.'|';
    $last2days .= $day.'|';
    $day = quotemeta(&main::timestring( $time - 24 * 3600 , 'd'));
    $gooddays  .= $day.'|';
    $last2days .= $day;
    $day = quotemeta(&main::timestring( $time - 36 * 3600 , 'd'));
    $gooddays .= $day.'|';
    $day = quotemeta(&main::timestring( $time - 72 * 3600 , 'd'));
    $gooddays .= $day;
    undef $day;

    my $dayoffset = $time % ( 24 * 3600 );
    my %bounces = ();
    my $nbounces = 0;
    my $bbounces = 0;
    my $IPprivate = $main::IPprivate;
    while (@logfiles) {
        my $File = shift @logfiles;
        my $ftime = &main::ftime($File) || time;
        next if ( ( $ftime + 4 * 24 * 3600 ) < ( $time - $dayoffset ) );
        &rb_printlog("processing Logfile $File\n");
        &rb_mlog("processing Logfile $File");
        next unless (open( my $FLogFile, '<', "$File" ));
        while (<$FLogFile>) {
            my ($auth,$fake,$DoS);
            if ( ( $ip, $auth, $fake, $DoS ) = /(?:$gooddays) .*?\s($IPRe)[ \]](?:.*? to: \S+|(too many \(\d+\) AUTH errors|warning: SMTP authentication failed|(info: faked authentication success for honeypot)|(info: SSL DoS using consecutive renegotiations detected)))/i) {
                next if $ip =~ /$IPprivate/o;                         # ignore private IP ranges
                next if &main::matchIP($ip,'acceptAllMail',0,1);
                $ip = &main::ipNetwork($ip, 1);
                if (! $main::noGriplistUpload && /$main::HamTagRE/io) {

                    #Good IP
                    $GpCnt{ $ip } += 1;
                    $GpOK{ $ip }  += 1;
                } elsif (! $main::noGriplistUpload && ($auth || /$main::SpamTagRE|\[PenaltyDelay\]/oi))
                {
                    next if /\[PersonalBlack\]/io;
                    #Bad IP
                    $GpCnt{ $ip } += 1;
                    $GpCnt{ $ip } += 2 if $auth;  # an AUTH error
                    $GpCnt{ $ip } += 5 if $fake;  # an AUTH error caused by a fake AUTH success
                    $GpCnt{ $ip } += 20 if $DoS;  # an SSL-DoS attack was detected
                }
            }
            next if $main::DoNotCollectBounces;
            my $to;
            if (/^(?:$last2days) .+?\[isbounce\].+?bounce message detected/i) {
                $nbounces++;
                next;
            }
            ($to) = $1 if (/^(?:$last2days) .*?\[isbounce\].*?\sto:\s(\S+)\s/i);
            ($to) = $1 if (! $to && /^(?:$last2days) .*?\sto:\s(\S+)\s\[spam found\].*?failed for bounce sender/i );
            $to =~ s/\>+$//o;
            $to =~ s/^\<+//o;
            next unless $to;
            $bbounces++;
            $bounces{lc $to}++;
        }
        eval{$FLogFile->close;};
    }
    $nbounces = &main::max($nbounces,$bbounces);
    if (! $main::DoNotCollectBounces && $nbounces) {
        my $pd = $main::EnableDelaying ? ' (possibly delayed)' : '';
        &rb_printlog("\nbounce report for the last two days: $nbounces bounces received$pd - $bbounces bounces blocked\n");
        &rb_printlog("\nlist of the top ten local addresses with blocked bounces in the last two days:\n\n") if $bbounces;
        my $i = 0;
        foreach my $adr ( sort { $bounces{$b} <=> $bounces{$a} } keys %bounces) {
            &rb_printlog("$adr : $bounces{$adr}\n",'',1);
            last if ++$i > 10;
        }
        &rb_printlog("\nend of bounce report\n\n");
    } elsif (! $main::DoNotCollectBounces) {
        &rb_printlog("\nbounce report for the last two days: no bounces received\n\n");
    } else {
        &rb_printlog("\nskipping bounce report because 'DoNotCollectBounces' is switched ON\n\n");
    }
    return if $main::noGriplistUpload;

    if ( !%GpCnt ) {
        &rb_printlog("Skipping GrIPlist upload. Not enough messages processed.\n");
        &rb_mlog("Skipping GrIPlist upload. Not enough messages processed.");
        return;
    }
    my ($n6, $n4) = (0,0);
    while (my ($k,$v) = each %GpCnt) {
        next if (!$v);
        if ($k =~ /:/o) {
            $n6++;
        }
        else {
            $n4++;
        }
    }
    $st = pack("N2", $n6 / 2**32, $n6);
    $st .= pack("N", $n4);
    my ($st6,$st4);
    my ($goodip,$badip) = (0,0);
    while (my ($k,$v) = each %GpCnt) {
        next if (!$v);
        my $val = 1 - $GpOK{$k} / $v;
        if ($val < 0.5) {$goodip++;} else {$badip++;}
        $val = int($val * 255);
        if ($k =~ /:/o) {
            my $ip = $k;
            $ip =~ s/([0-9a-f]*)(:|$)/0000$1$2/gio;
            $ip =~ s/0*([0-9a-f]{4})(:|$)/$1$2/gio;
            $st6 .= pack("H4H4H4H4", split(/:/o, $ip));
            $st6 .= pack("C", $val);
        } else {
            $st4 .= pack("C3", split(/\./o, $k));
            $st4 .= pack("C", $val);
        }
    }
    $st .= $st6 . $st4;

    &main::downloadGripConf();  # reload the griplist.conf
    my $what = 'Griplist';
    my $url = $main::gripListUpUrl;
    $url =~ s/^http:/https:/io;
    my $len = length($st);
    my $ct = 'application/x-www-form-urlencoded';

    if ($main::RebuildTestMode) {
        &rb_printlog("unable to connect to $main::gripListUpHost to upload griplist - in RebuildTestMode\n");
        &rb_mlog("unable to connect to $main::gripListUpHost to upload griplist - in RebuildTestMode");
        return;
    }

    my ($writeOK,$res) = &main::uploadHTTP($what, $url, $ct, $st);

    if ($writeOK) {
        if (open(my $f, '>', "$main::base/griplist.bin.out")) {
            binmode $f;
            print $f $st;
            $f->close;
        }
        $len = &rb_commify($len);
        $goodip = &rb_commify($goodip);
        $badip = &rb_commify($badip);
        $n6 = &rb_commify($n6);
        $n4 = &rb_commify($n4);
        &rb_printlog("Submitted $len bytes: $n6 IPv6 addresses, $n4 IPv4 addresses, good IP's $goodip , bad IP's $badip\n");
        &rb_mlog("Submitted $len bytes: $n6 IPv6 addresses, $n4 IPv4 addresses, good IP's $goodip , bad IP's $badip");
        if ($res =~ /error/io) {
            &rb_printlog("warning: but Griplist-server returned: $res\n");
            &rb_mlog("warning: but Griplist-server returned: $res");
        }
    } else {
        &rb_printlog("unable to upload griplist - server returned: $res\n");
        &rb_mlog("unable to upload griplist - server returned: $res");
    }
    return;
} ## end sub rb upload griplist

sub rb_fixPath {
    my ($path) = @_;
    my $len = length($path);
    if   ( !substr( $path, ( $len - 1 ), 1 ) eq q{/} ) { return $path . q{/}; }
    else                                               { return $path; }
}

sub rb_move2num {
    &rb_movefiles('spamlog',$main::maillogExt);
    &rb_movefiles('notspamlog',$main::maillogExt);
    &rb_movefiles('correctednotspam',$main::maillogExt);
    &rb_movefiles('correctedspam',$main::maillogExt);
}

sub rb_movefiles {
    my ($foldername,$ext) = @_;
    my $folder = $main::base.'/'.${'main::'.$foldername};
    my $c=1;
    &rb_printlog("'move to num' started for $foldername\n");
    &rb_mlog("'move to num' started for $foldername");
    my $count = 1;
    for my $fn ($main::unicodeDH->($folder)) {
        $fn = $folder.'/'.$fn;
        if ($count%100==0) {
            die "warning: got stop request from MainThread" unless $main::ComWorker{$Iam}->{run};
        }
        $count++;
        next if $main::dF->( $fn );
        next if $fn=~/\/(\d+)$ext$/i && $1 < $main::MaxFiles;
        $c++;
        my $fn0=$fn;
        while ($c < $main::MaxFiles && &main::fsize( "$folder/$c$main::maillogExt")) {$c++}
        my $d=$c<$main::MaxFiles? $c: int(rand()*$main::MaxFiles);
        $fn=~s#/[^/]*$#/$d$ext#;
        $main::unlink->("$fn");
        $main::rename->("$fn0","$fn");
    }
    &rb_printlog("'move to num' processed $c files in $foldername\n");
    &rb_mlog("'move to num' processed $c files in $foldername");
}

sub rb_cleanTrashlist {
    my $files_before = my $files_deleted = 0;
    my $t = time;
    my $mcount;

    my @r;
    while ( my ( $k, $v ) = each(%Trashlist) ) {
        $files_before++;
        my $f = $k;
        $f =~ s/\.att$//o;
        if ($main::eF->( $f )) {
            if (  $t - $v >= $main::MaxKeepDeleted * 3600 * 24 )
            {
                &rb_deletefile ($f,"Trashlist",1);
                push @r,$k unless $main::RebuildTestMode;
                push @r,$f unless $main::RebuildTestMode;
                $files_deleted++;
            }
        } else {
            push @r,$k unless $main::RebuildTestMode;
            push @r,$f unless $main::RebuildTestMode;
            $files_deleted++;
        }
    }
    map {delete $Trashlist{$_};} @r;
    if ($files_before>0) {
        &rb_printlog("\nTrashlist cleaning finished, $files_deleted of $files_before files deleted\n");
        &rb_mlog("info: Trashlist cleaning finished, $files_deleted of $files_before files deleted");
    }
}

1;

#RBEOT
$ADV->close if $ADV;
$ComWorker{$WorkerNumber}->{rb_version} = $rb_version;
return 1;
}

#__DATA__

no ASSP_DEF_VARS;

sub defineCanUseModules {
    print "\t\t\t\t\t[OK]\nloading modules";
    print '.';

    %ModuleError = ();
    $AvailIOSocketINET6  = ($enableINET6 && $useIOSocketIP) ? validateModule('IO::Socket::IP+') : 0; # socket 6 IO module
    $CanUseIOSocketINET6 = $AvailIOSocketINET6 &&
      eval {
          my $old_wflag = $^W;
          $^W = 0;
          no strict 'subs';   ## no critic
          # first try an unspecified socket port, if failed a specified (success may differ by OS)
          my $sock = eval{IO::Socket::IP->new(Domain => AF_INET6, Listen => 1, LocalAddr => '[::]');} ||
                     eval{IO::Socket::IP->new(Domain => AF_INET6, Listen => 1, LocalAddr => '[::]', LocalPort => $IPv6TestPort);};
          my $canV6sock = eval('$IPPROTO_IPV6 = Socket::IPPROTO_IPV6; $IPV6_V6ONLY = Socket::IPV6_V6ONLY;1;'); # they may not be available on diff platforms
          if ($sock) {
              eval {
                  $Sysv6only = $sock->getsockopt($IPPROTO_IPV6, $IPV6_V6ONLY);
              } if $canV6sock;
              $Sysv6only = 1 if (! $canV6sock && $isWIN);  # mswin may not have $canV6sock, but it has enabled IPV6_V6ONLY
              sockclose($sock);
              eval {
                  socket(my $testsock, Socket::PF_INET6(), SOCK_STREAM, 0);
                  $can_enable_v6only = setsockopt($testsock, $IPPROTO_IPV6, $IPV6_V6ONLY, 1) ? 1 : 0;
              } if $canV6sock;
              $can_enable_v6only ||= 0;
              $SysIOSocketINET6 = 1;
              $^W = $old_wflag;
              1;
          } else {
              $AvailIOSocketINET6 = $SysIOSocketINET6 = 0;
              $^W = $old_wflag;
              0;
          }
      };
    unless ($maxTCPRCVbuf) {
        eval <<'EOT';
        my $mod = $CanUseIOSocketINET6 ? 'IO::Socket::IP' : 'IO::Socket::INET';
        my $addr = $CanUseIOSocketINET6 ? '[::1]' : '127.0.0.1';
        my $sock = $mod->new(Listen => 1, LocalAddr => $addr);
        $maxTCPRCVbuf = unpack("i", getsockopt($sock, SOL_SOCKET, SO_RCVBUF));
EOT
        if ($@) {
            $ModuleError{Socket} = 'can not execute "getsockopt(sock, SOL_SOCKET, SO_RCVBUF)" - maxTCPRCVbuf is now set to 8192 - '.$@;
            $maxTCPRCVbuf = 8192;
            print "\t\t\t\t[failed] - in getsockopt(sock, SOL_SOCKET, SO_RCVBUF)\n";
        } elsif ($maxTCPRCVbuf < 8192) {
            $ModuleError{Socket} = "'getsockopt(sock, SOL_SOCKET, SO_RCVBUF)' reported $maxTCPRCVbuf - maxTCPRCVbuf is now set to 8192";
            print "\t\t\t\t[warning] - in getsockopt(sock, SOL_SOCKET, SO_RCVBUF) - only $maxTCPRCVbuf\n";
            $maxTCPRCVbuf = 8192;
        }
    }
    unless ($maxTCPSNDbuf) {
        eval <<'EOT';
        my $mod = $CanUseIOSocketINET6 ? 'IO::Socket::IP' : 'IO::Socket::INET';
        my $addr = $CanUseIOSocketINET6 ? '[::1]' : '127.0.0.1';
        my $sock = $mod->new(Listen => 1, LocalAddr => $addr);
        $maxTCPSNDbuf = unpack("i", getsockopt($sock, SOL_SOCKET, SO_SNDBUF));
EOT
        if ($@) {
            $ModuleError{Socket} = 'can not execute "getsockopt(sock, SOL_SOCKET, SO_SNDBUF)" - maxTCPSNDbuf is now set to 8192 - '.$@;
            $maxTCPSNDbuf = 8192;
            print "\t\t\t\t[failed] - in getsockopt(sock, SOL_SOCKET, SO_SNDBUF)\n";
        } elsif ($maxTCPRCVbuf < 8192) {
            $ModuleError{Socket} = "'getsockopt(sock, SOL_SOCKET, SO_SNDBUF)' reported $maxTCPSNDbuf - maxTCPSNDbuf is now set to 8192";
            print "\t\t\t\t[warning] - in getsockopt(sock, SOL_SOCKET, SO_SNDBUF) - only $maxTCPSNDbuf\n";
            $maxTCPSNDbuf = 8192;
        }
    }

    if (! ($disable_SO_REUSEPORT & 1)) {
        # check if the ReusePort socket option 'SO_REUSEPORT' is supported by the OS
        $canReusePort = 1; # defaults to supported
        eval <<'EOT';
        push my @sockopt, SO_REUSEPORT;
EOT
        if ($@) { # it is not supported - error is: Your vendor has not defined Socket macro SO_REUSEPORT, used at ....
            if ($isNoWIN && $disable_SO_REUSEPORT == 0) {     # Windows has no SO_REUSEPORT
                $ModuleError{Socket} = "the 'SO_REUSEPORT' socket-option is not supported by the kernel of the OS - please set disable_SO_REUSEPORT back to 1 - $@";
                print "\t\t\t\t[warning] - the 'SO_REUSEPORT' socket-option is not supported by the kernel of the OS - please set disable_SO_REUSEPORT back to 1\n";
            }
            $canReusePort = 0;
        }
    } else {
        $canReusePort = 0;
    }

    $CanUseThreadState   = $useThreadState ? validateModule('Thread::State') : 0;    # change thread priority
    $CanUseAvClamd       = $useFileScanClamAV ? validateModule('File::Scan::ClamAV') : 0;    # ClamAV module installed
    $AvailAvClamd        = $CanUseAvClamd;
    $CanUseLDAP          = $useNetLDAP ? validateModule('Net::LDAP') : 0;    # Net LDAP module installed
    print '.';

    $useNetDNS = $Config{useNetDNS} = 1;
    $CanUseDNS           = $useNetDNS ? validateModule('Net::DNS') : 0;   # Net DNS module installed - required for SPF & RBL
    $AvailSPF2           = $useMailSPF ? validateModule('Mail::SPF') : 0;  # Mail SPF module installed
    $CanUseSPF2          = $AvailSPF2 && $CanUseDNS;  # SPF and dependancies installed
    # internals in Net::DNS changed for version 1.02_02 and higher
    # IO-Socket-IP is forced to be used for IPv6
    if (! $CanUseIOSocketINET6 && defined &Net::DNS::Resolver::Base::USE_SOCKET_IP) {
        undef &Net::DNS::Resolver::Base::USE_SOCKET_IP;
        *Net::DNS::Resolver::Base::USE_SOCKET_IP = sub {'';};
    }
    my $d = Net::DNS::Resolver->new();
    $orgNewDNSResolver = \&Net::DNS::Resolver::Base::new;
    *Net::DNS::Resolver::Base::new = \&getDNSResolver;
    $d = eval{ Net::DNS::Resolver->send(); };
    $d = eval{ Net::DNS::Resolver->bgread(); };
    $orgSendDNSResolver = \&Net::DNS::Resolver::Base::send;
    *Net::DNS::Resolver::Base::send = \&DNSResolverSend;
    $orgreadbgDNSResolver = \&Net::DNS::Resolver::Base::bgread;
    *Net::DNS::Resolver::Base::bgread = \&DNSResolverBGread;
    $orgNewDNSisSET = 1;
    # make_query_packet is not exported and change to _make_query_packet in Net::DNS 1.02_02
    $RSL_make_query_packet = '_make_query_packet' if defined &Net::DNS::Resolver::Base::_make_query_packet;

    print '.';
    $CanUseURIBL         = $CanUseDNS;                # URIBL and dependancies installed
    $CanUseRWL           = $CanUseDNS;                # RWL and dependancies installed
    print '.';
    $CanUseRBL           = $CanUseDNS;                # DNSBL and dependancies installed
    $AvailSRS            = $useMailSRS ? validateModule('Mail::SRS') : 0;  # Mail SRS module installed
    $CanUseSRS           = $AvailSRS;
    $AvailZlib           = $useCompressZlib ? validateModule('Compress::Zlib+') : 0;    # Zlib module installed
    $CanUseHTTPCompression  = $AvailZlib;
    $AvailMD5            = $useDigestMD5 ? validateModule('Digest::MD5+') : 0;   # Digest MD5 module installed
    $CanUseMD5Keys       = $AvailMD5;
    $Config{useDigestSHA1} = $useDigestSHA1 = 1;
    $AvailSHA1           = $useDigestSHA1 ? validateModule('Digest::SHA1 qw(sha1_hex)') : 0;   # Digest SHA1 module installed
    $CanUseSHA1          = $AvailSHA1;
    print '.';
    $AvailReadBackwards  = $useFileReadBackwards ? validateModule('File::ReadBackwards') : 0;    # ReadBackwards module installed;
    $CanSearchLogs       = $AvailReadBackwards;
    $AvailHiRes          = validateModule('Time::HiRes'); # Time::HiRes module installed;
    $CanStatCPU          = $AvailHiRes;
    $AvailIO             = $usePerlIOscalar ? validateModule('PerlIO::scalar+') : 0;    # make it chroot savy;
    $CanChroot           = $AvailIO;
    $AvailSyslog         = $useSysSyslog ? validateModule('Sys::Syslog qw( :DEFAULT setlogsock)') : 0;
    $CanUseSyslog        = $AvailSyslog;
    print '.';
    $useWin32APIOutputDebugString = $Config{useWin32APIOutputDebugString} = '' if ($isNoWIN);
    $AvailWin32Debug     = $useWin32APIOutputDebugString ? validateModule('Win32::API::OutputDebugString qw(OutputDebugString DStr)') :0; # AZ: 2009-03-10 win32 debug/trace available
    $CanUseWin32Debug    = $AvailWin32Debug; # AZ: 2009-03-10 win32 debug/trace available
    $AvailTieRDBM        = $useTieRDBM ? validateModule('DBI()') && validateModule('Tie::RDBM') : 0;    # Use external database
    $CanUseTieRDBM       = $AvailTieRDBM;
    $AvailDB_File        = $useDB_File ? validateModule('DB_File') : 0;    # Use external DB_File (Berkeley V1) database
    $CanUseDB_File       = $AvailDB_File;
    $AvailBerkeleyDB     = $useBerkeleyDB ? validateModule('BerkeleyDB') : 0;    # Use external Berkeley database
    $CanUseBerkeleyDB    = $AvailBerkeleyDB;
    print '.';
    $AvailCIDRlite       = $useNetCIDRLite ? validateModule('Net::CIDR::Lite') : 0;    # Net::CIDR::Lite module installed
    $CanUseCIDRlite      = $AvailCIDRlite;
    $AvailNetAddrIPLite  = $useNetAddrIPLite ? validateModule('NetAddr::IP::Lite()') : 0;    # NetAddr::IP::Lite module installed
    $CanUseNetAddrIPLite = $AvailNetAddrIPLite;
    $AvailNetIP          = $useNetIP ? validateModule('Net::IP()') : 0;    # Net::IP module installed
    $CanUseNetIP         = $AvailNetIP;

    $AvailLWP            = $useLWPSimple ? validateModule('LWP::Simple') && validateModule('HTTP::Request::Common') && validateModule('LWP::UserAgent'): 0;    # LWP::Simple module installed
    $CanUseLWP           = $AvailLWP;
    if ($CanUseLWP && ! validateModule('LWP::Protocol::https()')) {
        print "\nError: can not load the module LWP::Protocol::https - the module or any dependency is missing\n\n$ModuleError{'LWP::Protocol::https'}\n";
    }

    $AvailEMM            = $useEmailMIME ? validateModule('Email::MIME') : 0;  # Email::MIME module installed
    $CanUseEMM           = $AvailEMM;
    validateModule('MIME::Words()') if $CanUseEMM;
    $AvailMTY            = $useMIMETypes ? validateModule('MIME::Types') : 0;   # MIME::Types module installed
    $CanUseMTY           = $AvailMTY && $CanUseEMM;

    $AvailEmailAddressXS = $useEmailAddressXS ? validateModule('Email::Address::XS()') : 0;  # Email::Address::XS module installed
    $CanUseEmailAddressXS= $AvailEmailAddressXS;
    print '.';

    $AvailTNEF           = $useConvertTNEF ? validateModule('Convert::TNEF') : 0;  # Convert::TNEF module installed
    $CanUseTNEF          = $AvailTNEF && $CanUseMTY;

    $AvailDKIM           = $useMailDKIMVerifier ? validateModule('Mail::DKIM::Verifier()') : 0;  # Mail::DKIM::Verifier module installed
    $CanUseDKIM          = $AvailDKIM;
    if ($CanUseDKIM) {
        validateModule('Mail::DKIM()') ;
        validateModule('Mail::DKIM::Signer()');
        validateModule('Mail::DKIM::TextWrap()');
        if (Mail::DKIM->VERSION >= 0.50) {
            validateModule('Mail::DKIM::ARC::Signer()');
            validateModule('Mail::DKIM::ARC::Verifier()');
        }
    }

    $AvailNetSMTP        = $useNetSMTP ? validateModule('Net::SMTP') : 0;  # Net::SMTP module installed
    $CanUseNetSMTP       = $AvailNetSMTP;

    $AvailNetSMTPSSL     = $useNetSMTPSSL ? validateModule('Net::SMTP::SSL') : 0;  # Net::SMTP::SSL module installed
    $CanUseNetSMTPSSL    = $AvailNetSMTPSSL;

    $AvailNetSNMPagent   = $useNetSNMPagent ?
    validateModule('NetSNMP::agent()') &&
    validateModule('NetSNMP::ASN()') &&
    validateModule('NetSNMP::default_store qq(:all)') &&
    validateModule('NetSNMP::agent::default_store qq(:all)')
     : 0 ;
    $CanUseNetSNMPagent  = $AvailNetSNMPagent;

    $AvailSysMemInfo     = $useSysMemInfo ? validateModule('Sys::MemInfo') : 0;  # Sys::MemInfo module installed
    $CanUseSysMemInfo    = $AvailSysMemInfo;

    $AvailSysCpuAffinity     = $useSysCpuAffinity ? validateModule('Sys::CpuAffinity') : 0;  # SSys::CpuAffinity module installed
    $CanUseSysCpuAffinity    = $AvailSysCpuAffinity;

    if ($CanUseIOSocketINET6) {
        $AvailIOSocketSSL    = $useIOSocketSSL ? validateModule('IO::Socket::SSL+') : 0;  # IO::Socket::SSL module installed
        $CanUseIOSocketSSL   = $AvailIOSocketSSL;
        validateModule('IO::Socket::IP') if $CanUseIOSocketSSL;   # reimport the symbols into namespace
    } else {
        $AvailIOSocketSSL    = $useIOSocketSSL ? validateModule('IO::Socket::SSL \'inet4\'') : 0;  # IO::Socket::SSL module installed
        $CanUseIOSocketSSL   = $AvailIOSocketSSL;
        validateModule('IO::Socket::INET') if $CanUseIOSocketSSL;   # reimport the symbols into namespace
    }
    print '.';

    $AvailAuthenSASL    = $useAuthenSASL ? validateModule('Authen::SASL') : 0;  # Authen::SASL module installed
    $CanUseAuthenSASL   = $AvailAuthenSASL;

    $AvailRegexpOptimizer   = $useRegexpOptimizer ? validateModule('Regexp::Optimizer()') : 0;  # Regexp::Optimizer module installed
    if ($CanUseRegexpOptimizer = $AvailRegexpOptimizer) {
        if (eval('Regexp::Optimizer->VERSION') ge '0.23') {
            $optReModule = 'Regexp::Optimizer';
            $Regexp::Assemble::Current_Lexer = $Regexp::Assemble::Default_Lexer; # use _lex instead of _fastlex in Regexp::Assemble
        }
    }

    $AvailASSP_WordStem    = $useASSP_WordStem ? validateModule('ASSP_WordStem()') : 0;  # ASSP_WordStem  module installed
    $CanUseASSP_WordStem   = $AvailASSP_WordStem;

    $AvailASSP_FC    = $useASSP_FC ? validateModule('ASSP_FC()') : 0;  # ASSP_FC  module installed
    $CanUseASSP_FC   = $AvailASSP_FC;

    $AvailASSP_SVG    = $useASSP_SVG ? validateModule('ASSP_SVG()') : 0;  # ASSP_SVG  module installed
    $CanUseASSP_SVG   = $AvailASSP_SVG;

    $AvailASSP_VirusTotal_API = $useASSP_VirusTotal_API ? validateModule('ASSP_VirusTotal_API()') : 0;  # ASSP_VirusTotal_Api module installed
    $CanUseASSP_VirusTotal_API = $AvailASSP_VirusTotal_API;

    $AvailAsspSelfLoader   = $useAsspSelfLoader ? defined $AsspSelfLoader::VERSION : 0;  # AsspSelfLoader  module installed
    $CanUseAsspSelfLoader  = $AvailAsspSelfLoader;

    $AvailUnicodeGCString = $useUnicodeGCString ?  validateModule('Unicode::GCString()') : 0;  # Unicode::GCString  module installed
    $CanUseUnicodeGCString = $AvailUnicodeGCString;

    $AvailTextUnidecode = $useTextUnidecode ?  validateModule('Text::Unidecode()') : 0;  # Text::Unidecode  module installed
    $CanUseTextUnidecode = $AvailTextUnidecode;

    $@ = undef;
    $CanUseWin32Unicode = $AvailWin32Unicode = $useWin32Unicode ? eval('
       if (   $isWIN
           && defined ${chr(ord("\026") << 2)}
           && require Win32::Unicode
          )
       {
          $unicodeFH = sub { $_[0] = Win32::Unicode::File->new; };
          $unicodeDH = sub { my $d = Win32::Unicode::Dir->new;my $c=shift;return unless $c;$utf8on->(\$c);$d->open($c);my @l = $d->readdir;$d->close;return @l;};
          $open = sub {my @c=@_;return unless @c==3;$utf8on->(\$c[2]);$unicodeFH->($_[0]);$_[0]->open($_[1],$c[2]);};
          $unlink = sub { my $c=shift;return unless $c;$utf8on->(\$c);Win32::Unicode::File::unlinkW($c); };
          $move = sub { my @c=@_;return unless @c==2;for(@c){$utf8on->(\$_);};Win32::Unicode::File::moveW(@c,1); };
          $copy = sub { my @c=@_;return unless @c==2;for(@c){$utf8on->(\$_);};Win32::Unicode::File::copyW(@c,1); };
          $rename = sub { my @c=@_;return unless @c==2;for(@c){$utf8on->(\$_);};Win32::Unicode::File::renameW(@c,1); };
          $eF = sub { my $c=shift;return unless $c;$utf8on->(\$c);eval{Win32::Unicode::File::file_type(e => $c);}; };
          $dF = sub { my $c=shift;return unless $c;$utf8on->(\$c);eval{Win32::Unicode::File::file_type(d => $c);}; };
          $stat = sub { my $c=shift;return unless $c;return unless $eF->($c);$utf8on->(\$c);my @st; eval{@st = Win32::Unicode::File::statW($c);}; if ($@) {eval{@st = stat($c);};} return @st;};
          $mkdir = sub { my $c=shift; my $p=shift; return unless ($c && $p); return if $eF->($c); return if $dF->($c); $utf8on->(\$c); Win32::Unicode::Dir::mkdirW($c)};
          $rmdir = sub { my $c=shift; return unless $c; return if ! $dF->($c); return if $c =~ /^\Q$base\E\/?$/o; $utf8on->(\$c); Win32::Unicode::Dir::rmdirW($c)};
          $rmtree = sub { my $c=shift; return unless $c; return if ! $dF->($c); $utf8on->(\$c); rmTree($c)};

          $unicodeName = sub {my $c=shift;return unless $c;$utf8on->(\$c); eval(\'Win32::Unicode::File::CYGWIN\') ? Encode::encode_utf8($c) : Win32::Unicode::File::utf8_to_utf16(Win32::Unicode::File::catfile($c)) . "\x00";};
#          $unicodeName = sub {my $c=shift;return unless $c;$utf8on->(\$c); Win32::Unicode::File::utf8_to_utf16(Win32::Unicode::File::catfile($c)) . "\x00";};
#          $unicodeName = sub {my $c=shift;return unless $c;$utf8on->(\$c);Win32::Unicode::File::utf8_to_utf16(Win32::Unicode::File::catfile($c));};
          1;
       } else {
          0;
       }
    ') : 0;
    $ModuleError{'Win32::Unicode'} = $@ if $@;
    disableUnicode() unless $CanUseWin32Unicode;
    $canUnicode = $CanUseWin32Unicode || $isNoWIN;
    print $canUnicode ? 'U' : 'u?';
    eval{${^WIDE_SYSTEM_CALLS} = 1;} if $canUnicode;

    if ($isWIN) {
        $chown = sub {1;};  # in case called in windows, it should return 1
    }

    if ($normalizeUnicode) {
        $CanUseUnicodeNormalize = eval('use Unicode::Normalize();1;');
        $ModuleError{'Unicode::Normalize'} = $@ if $@;
    }

    if (! eval('use Convert::Scalar(); no Convert::Scalar; 1;')) {
        $ModuleError{'Convert::Scalar'} = $@;
        $Recommends{'memory_allocation'} ||= 'the Perl module Convert::Scalar seems not to be installed';
    }

    if (open(my $F, '>', "$base/moduleLoadErrors.txt")) {
        binmode $F;
        my $error;
        while (my($k,$v) = each %ModuleError) {
            print $F "module $k could not be loaded (see error below): check with >perl -e \"use $k;\"\n$v\n\n\n";
            $error = $error ? 'errors are' : 'error was';
        }
        if ($error) {
            print "\t\t\t\t[failed] - $error written to file $base/moduleLoadErrors.txt\n";
        } else {
            print $F "There were no module load errors detected.\n";
            print "\t\t\t\t[OK]\n";
        }
        $F->close;
    }

    if ($CanUseTieRDBM) {
      print "loading database drivers\t";
      @DBdriverNames = DBI->available_drivers;
      $DBdrivers = join('|',@DBdriverNames);
    } else {
      @DBdriverNames = ();
    }
    if ($CanUseBerkeleyDB) {
        unshift(@DBdriverNames, 'BerkeleyDB');
        $DBdrivers = 'BerkeleyDB|'.$DBdrivers;
    }
    $DBdrivers = "no database drivers (DBD-\<driver\> are available on your system" unless $DBdrivers;
    $DBdrivers =~ s/\|$//o;
}

sub getChangedConfigValue {
    d('getChangedConfigValue');
    my @configs;
    {
        lock @changedConfig;
        threads->yield();
        @configs = @changedConfig;
        @changedConfig = ();
        threads->yield();
    }
    while (@configs) {
        my $line = shift @configs;
        $line =~ s/^\s+//o;
        $line =~ s/[\s\r\n]+$//o;
        my ($config,$value) = split(/\s*:=\s*/o,$line,2);
        if (exists $Config{$config}) {
            if ("$$config" ne "$value") {
                $ConfigChanged = changeConfigValue($config, $value) | $ConfigChanged;
            } else {
                mlog(0,"info: $config is already set to '$value'") if $MaintenanceLog > 1;
            }
        } elsif ($config =~ /^\&/o) {
            $line = $config.$value;
            my ($sub,$parm) = parseEval($line);
            if ($sub) {
                eval{$sub->($parm);};
                mlog(0,"error: running '$line' caused exception - $@") if ($@);
            } else {
                mlog(0,"error: unable to parse $line");
            }
        } else {
            if ("$$config" ne "$value") {
                my $old = $$config;
                $$config = $value;
                threads->yield();
                if (! is_shared($$config)) {
                    for (0...$Config{NumComWorkers},10000,10001) {
                        next if $WorkerNumber == $_;
                        $changeConfigQueue{$_}->enqueue("\$$config=q($value);");
                        mlog(0,"info: told worker_$_ to change internal variable $config to '$value'") if $MaintenanceLog;
                    }
                }
                mlog(0,"info: internal variable '$config' changed from '$old' to '$value'");
            } else {
                mlog(0,"info: internal variable $config is already set to '$value'") if $MaintenanceLog > 1;
            }
        }
    }
}

sub changeConfigValue {
    my ($config, $value) = @_;
    d("changeConfigValue - $config");
    if (! $config || ! exists $Config{$config}) {
        mlog(0,"error: scheduled configuration change request for $config - $config is not a valid configuration parameter name");
        return;
    }
    my $ret;
    mlog(0,"info: scheduled configuration change request for $config");
    $qs{$config} = $value;
    $ActWebSess = 'Config_Schedule'.Time::HiRes::time();
    $WebIP{$ActWebSess}->{user} = 'root';
    my $error = checkUpdate($ConfigArray[$ConfigNum{$config}]->[0],$ConfigArray[$ConfigNum{$config}]->[5],$ConfigArray[$ConfigNum{$config}]->[6],$ConfigArray[$ConfigNum{$config}]->[1]);
    if ($error =~ /span class.+?negative/o) {
        $error =~ s/<b>(.+?)<\/b>/$1/o;
        mlog(0,"info: scheduled configuration change request failed for - $config - $error");
    } elsif ($error =~ /span class.+?positive/o) {
        my $text = (exists $cryptConfigVars{$config}) ? '' : " to ". $qs{$config};
        mlog(0,"info: changed config for - $config$text");
        $ret = 1;
    } else {
        mlog(0,"info: config unchanged - $config - ". $qs{$config});
    }
    delete $qs{$config};
    return $ret;
}

sub niceConfigPos {
    my $counterT = -1;
    my $num = 0;
    my $head;
    %ConfigPos = ();
    %ConfigNum = ();
    %glosarIndex = ();
    for my $idx (0...$#ConfigArray) {
        my $c = $ConfigArray[$idx];
        if (@{$c} == 5) {
            $counterT++;
            $num++;
            $head = $c->[4];
            $head =~ s/<a\s+href.*<\/a>//io;
        } else {
            $ConfigPos{$c->[0]} = $counterT;
            $ConfigNum{$c->[0]} = $num++;
            $glosarIndex{$c->[0]} = $head;
        }
    }
}

sub niceConfig {
    %ConfigNice = ();
    %ConfigDefault = ();
    %ConfigListBox = ();
    for my $idx (0...$#ConfigArray) {
        my $c = $ConfigArray[$idx];
        my $value;
        next if (@{$c} == 5) ;
        $ConfigNice{$c->[0]} =  ($c->[10] && $WebIP{$ActWebSess}->{lng}->{$c->[10]})
                                ? encodeHTMLEntities($WebIP{$ActWebSess}->{lng}->{$c->[10]})
                                : encodeHTMLEntities($c->[1]);
        $ConfigNice{$c->[0]} =~ s/<a\s+href.*<\/a>//io;
        $ConfigNice{$c->[0]} =~ s/'|"|\n//go;
        $ConfigNice{$c->[0]} =~ s/\\/\\\\/go;
        $ConfigNice{$c->[0]} = '&nbsp;' unless $ConfigNice{$c->[0]};
        $ConfigDefault{$c->[0]} = encodeHTMLEntities($c->[4]);
        $ConfigDefault{$c->[0]} =~ s/'|"|\n//go;
        $ConfigDefault{$c->[0]} =~ s/\\/\\\\/go;

        $value = ($qs{theButton} || $qs{theButtonX}) ? $qs{$c->[0]} : $Config{$c->[0]} ;
        $value = $Config{$c->[0]} if $qs{theButtonRefresh};

        if ($c->[3] == \&listbox) {
            $ConfigDefault{$c->[0]} = 0 unless $ConfigDefault{$c->[0]};
            foreach my $opt ( split( /\|/o, $c->[2] ) ) {
                  my ( $v, $d ) = split( /:/o, $opt, 2 );
                  $ConfigDefault{$c->[0]} = $d if ( $ConfigDefault{$c->[0]} eq $v );
                  $ConfigListBox{$c->[0]} = $d if ( $value eq $v );
                  $ConfigListBoxAll{$c->[0]}{$v} = $d;
                  $WhitelistPrivacyLevelValue = $d if $c->[0] eq 'WhitelistPrivacyLevel' && $value eq $v;
            }
        } elsif ($c->[3] == \&checkbox) {
                  $ConfigDefault{$c->[0]} = $ConfigDefault{$c->[0]} ? 'On' : 'Off';
                  $ConfigListBox{$c->[0]} = $value ? 'On' : 'Off';
        } else {
            $ConfigDefault{$c->[0]} = '&nbsp;' unless $ConfigDefault{$c->[0]};
            $value = 'ENCRYPTED' if exists $cryptConfigVars{$c->[0]} or $c->[0] eq 'webAdminPassword' or $c->[3] == \&passnoinput or $c->[3] == \&passinput;
            $ConfigListBox{$c->[0]} = $value;
        }
    }
}

sub niceLink {
    my $c = shift;
    my $i = 0;
    my %v = ();
    while ($c =~ s/(\$[a-zA-Z][a-zA-Z0-9_{}\[\]\-\>]+)/\[\%\%\%\%\%\]/o) {
        my $var = $1;
        $v{$i} = eval($var);
        $v{$i} = $var unless defined $v{$i};
        $i++;
    }
    $i = 0;
    while ($c =~ s/\[\%\%\%\%\%\]/$v{$i}/o) {$i++}
    my $newline;
    foreach my $word (split(/ /o,$c)) {
         my $orgword = $word;
         $word =~ s/[\x00-\x2f\x3a-\x40\x5b-\x5e\x60\x7b-\xff]//go;  #[^a-zA-Z0-9_]
         if (exists $Config{$word} && ($rootlogin || ! $AdminUsersRight{"$WebIP{$ActWebSess}->{user}.user.hidDisabled"})) {
              my $alt = $ConfigNice{$word};
              my $value = encodeHTMLEntities($ConfigListBox{$word});
              $value =~ s/'|"|\n//go;
              $value =~ s/\\/\\\\/go;
              $value = '&nbsp;' unless $value;
              $value = 'ENCRYPTED' if exists $cryptConfigVars{$word};
              my $default = exists $cryptConfigVars{$word} && $word ne 'webAdminPassword'? 'ENCRYPTED' : $ConfigDefault{$word};
              my $subst = "<a href=\"./#$word\" style=\"color:#684f00\" onmousedown=\"showDisp('$ConfigPos{$word}');gotoAnchor('$word');return false;\" onmouseover=\"window.status='$alt'; showhint('<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH=\\'100%\\' bgcolor=lightyellow><tr><td>config var:</td><td>$word</td></tr><tr><td>description:</td><td>$alt</td></tr><tr><td>current value:</td><td>$value</td></tr><tr><td>default value:</td><td>$default</td></tr></table>', this, event, '450px', '1'); return true;\" onmouseout=\"window.status='';return true;\">$word</a>" ;
              $orgword =~ s/$word/$subst/;
         } elsif (exists $tempDBvars{$word} && ($rootlogin || &canUserDo($WebIP{$ActWebSess}->{user},'action','editinternals')) ) {
              my $subst = "<a href=\"#\" onclick=\"return popFileEditor(\'DB-$word\',\'1h\');\">$word</a>";
              $orgword =~ s/$word/$subst/;
         }
         $newline .= " $orgword";
    }
    return $newline;
}

sub setMainLang {

$lngmsghint{'msg500011'} = '# main form buttom hint 1';
$lngmsg{'msg500011'} = 'The CIDR notation is allowed(182.82.10.0/24).';

$lngmsghint{'msg500012'} = '# main form buttom hint 2';
$lngmsg{'msg500012'} = '<br />Text after the range (and before a number sign) will be accepted as comment which will be shown in a match (for example: 182.82.10.0/24 Yahoo Groups #comment not shown).' ;

$lngmsghint{'msg500013'} = '# main form buttom hint 3';
$lngmsg{'msg500013'} = '<div id="iphint">IP ranges are defined as for example 182.82.10. CIDR notation is accepted (182.82.10.0/24).' ;

$lngmsghint{'msg500014'} = '# main form buttom hint 4';
$lngmsg{'msg500014'} = '<br />Text after the range (and before a number sign) will be accepted as comment to be shown in a match. For example:<br />182.82.10.0/24 Yahoo #comment to be removed<br />The short notation like 182.82.10. is only allowed for IPv4 addresses, IPv6 addresses must be fully defined as for example 2201:1::1 or 2201:1::/96<br /><span class="negative">NEVER EVER include leading zeros into IPv4 octets - like 010.200.001.078 (use 10.200.1.78 instead), this will lead into unexpected errors in several used perl modules!</span><br />You may define a hostname instead of an IP, in this case the hostname will be replaced by all DNS-resolved IP-addresses, each with a /32 or /128 netmask. For example:<br />mta5.am0.yahoodns.net Yahoo #comment to be removed -&gt; 66.94.238.147/32 Yahoo|... Yahoo|... Yahoo<br />
For several IP-address lists in assp, it can be advantageous to include all IP\'s (and ranges) listed in the SPF-record of a specific domain (for example in noPB, noHelo, whiteListedIPs, ...). To provide this, simply write SPF: in front of the domain name in a list entry - like 182.82.10.0/24|<span class="positive">SPF:amazon.com</span>|2201:1::1 . In this example assp will replace the term SPF:amazon.com with the list of all IP\'s and resolved IP\'s defined in the SPF-record of amazon.com. Assignments made to such an entry - like <span class="positive">SPF:amazon.com=&gt;[usergroup]</span> will be added to each resolved SPF-IP-address.<br />
To exclude specific SPF includes, redirects and IP-addresses/ranges, write for example: SPF:eXclude -toremove1.org, -_spf1.toremove2.org, -x.x.x.x/yy, -host . The leading hyphen is mandatory, comma has to be used as separator and the term eXclude is case sensitive!<br />
SPF:eXclude definitions should be done before any other SPF:.. definition, because early SPF:.. definition are not affected by later SPF:eXclude definitions!<br />
The SPF:domain.org notation can be also used for IP lists in a group definition.<br />
It is also possible to let assp lookup the ASN (Autonomous System Number) for an IP-address (NOT the ASN number its self - like ASN:1234). The CIDR of the ASN will be used by assp.<br />
To lookup the ASN for an IP-address, write ASN:x.x.x.x or ASN:aaaa:bb::c<br />
The ASN:ip-address notation can be also used for IP lists in a group definition.</div>';

$lngmsghint{'msg500015'} = '# main form buttom hint 5';
$lngmsg{'msg500015'} = 'If Net::CIDR::Lite is installed, hyphenated ranges can be used (182.82.10.0-182.82.10.255).';

$lngmsghint{'msg500016'} = '# main form buttom hint 6';
$lngmsg{'msg500016'} = 'Hyphenated ranges can be used (182.82.10.0-182.82.10.255).';

$lngmsghint{'msg500017'} = '# main form buttom hint 7';
$lngmsg{'msg500017'} = '<div id="pathinfo">For defining any full filepaths, always use slashes ("/") not backslashes. For example: c:/assp/certs/server-key.pem !<br /><br /></div>';

$lngmsghint{'msg500018'} = '# main form buttom hint 8';
$lngmsg{'msg500018'} = <<EOT;
<img class="genHelpIcon" src="get?file=images/schedule.jpg"><br />
<div id="cron">Fields marked with one small (<sup>s</sup>) - which are interval definitions - accept a single or a list of crontab entries separated by '|'. Such entries could be used to flexible schedule the configured task.
<br />
<b>Time and Date specification</b><br />
Entry is the specification of the scheduled time in crontab format,
which contains five mandatory time and date fields.
Entry can be either a plain string, which contains
a whitespace separated time and date specification.<br />
The time and date fields are (taken mostly from "Vixie" cron):<br />
<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH="50%" >
<tr><td><b>field</b></td><td><b>values</b></td></tr>
<tr><td>minute</td><td>0-59</td></tr>
<tr><td>hour</td><td>0-23</td></tr>
<tr><td>day of month</td><td>1-31</td></tr>
<tr><td>month</td><td>1-12 (or as names)</td></tr>
<tr><td>day of week</td><td>0-7 (0 or 7 is Sunday, or as names )</td></tr>
<tr><td>seconds</td><td>0-59 (optional) <b>not supported inside ASSP !!!</b></td></tr>
</table>
<br />
 A field may be an asterisk (*), which always stands for
 "first-last".<br />
 Ranges of numbers are  allowed. Ranges are two numbers
 separated  with  a  hyphen. The  specified  range  is
 inclusive.   For example, 8-11  for an  "hours" entry
 specifies execution at hours 8, 9, 10 and 11.<br />
</div>
<div id="cronextend">
Lists  are allowed. An list is a set of  numbers (or
 ranges)  separated by  commas. Examples: "1,2,5,9","0-4,8-12".
 Step  values can  be used  in conjunction  with ranges.
 Following a range with "/number" specifies skips of
 the  numbers value  through the  range.   For example,
 "0-23/2" can  be used in  the hours field  to specify
 command execution every  other hour (the alternative in
 the V7 standard is "0,2,4,6,8,10,12,14,16,18,20,22").
 Steps are  also permitted after an asterisk,  so if you
 want to say "every two hours", just use "*/2".
 Names can also  be used for the "month" and "day of
 week"  fields.  Use  the  first three  letters of  the
 particular day or month (case doesn't matter).<br />
 <b>Note:</b>
 The day of a command's execution can be specified
 by two fields  -- day of month, and  day of week.
 If both fields are restricted (ie, aren't *), the
 command will be run when either field matches the
 current  time.  For  example, "30  4 1,15  * 5"
 would cause a command to be run at 4:30 am on the
 1st and 15th of each month, plus every Friday. In addition, ranges or lists of names are allowed.<br />
<b>Examples:</b><br />
<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH="80%" >
<tr><td>8 0 * * *</td><td>==></td><td>8 minutes after midnight, every day</td></tr>
<tr><td>5 11 * * Sat,Sun</td><td>==></td><td>at 11:05 on each Saturday and Sunday</td></tr>
<tr><td>0-59/5 * * * *</td><td>==></td><td>every five minutes</td></tr>
<tr><td>42 12 3 Feb Sat</td><td>==></td><td>at 12:42 on 3rd of February and on each Saturday in February</td></tr>
<tr><td>32 11 * * * 0-30/2</td><td>==></td><td>11:32:00, 11:32:02, ... 11:32:30 every day</td></tr>
</table>
<br /></div>
<img class="genHelpIcon" src="get?file=images/help.jpg"><br />
<div id="oneasterix">Fields marked with at least one asterisk (*) accept a list separated by '|' (for example: abc|def|ghi) or a file designated as follows (path relative to the ASSP directory): 'file:files/filename.txt'.  Putting in the <i>file:</i> will prompt ASSP to put up a button to edit that file. <i>files</i> is the subdirectory for files. The file does not need to exist, you can create it by saving it from the editor within the UI. The file must have one entry per line; anything on a line following a number sign or a semicolon (# ;) is ignored (a comment).<br />
It is possible to include custom-designed files at any line of such a file, using the following directive<br />
<span class="positive"># include filename</span><br />
where filename is the relative path (from $base) to the included file like files/inc1.txt or inc1.txt (one file per line). The line will be internaly replaced by the contents of the included file!<br />
Line continuation is supported by writing a backslash '\\' at the end of a line.<br /><br /></div>
<img class="genHelpIcon" src="get?file=images/regex.jpg"><br />
<div id="twoasterix">Fields marked with two asterisk (**) contains regular expressions (regex) and accept a second weight value. Every weighted regex that contains at least one '|' has to begin and end with a '~' - inside such regexes it is not allowed to use a tilde '~', even it is escaped - for example:  ~abc<span class="negative"><b>\\~</b></span>|def~=>23 or ~abc<span class="negative"><b>~</b></span>|def~=>23 - instead use the octal (\\126) or hex (\\x7E) notation , for example <span class="positive">~abc\\126|def~=>23 or ~abc\\x7E|def~=>23</span> . Every weighted regex has to be followed by '=>' and the weight value. For example: Phishing\\.=>1.45|~Heuristics|Email~=>50  or  ~(Email|HTML|Sanesecurity)\\.(Phishing|Spear|(Spam|Scam)[a-z0-9]?)\\.~=>4.6|Spam=>1.1|~Spear|Scam~=>2.1 .
 The multiplication result of the weight and the penaltybox valence value will be used for scoring, if the absolute value of weight is less or equal 6. Otherwise the value of weight is used for scoring. It is possible to define negative values to reduce the resulting message score.<br /></div>
<br /><img class="genHelpIcon" src="get?file=images/bomb.jpg"><br />
<div id="bombs">For all "<span class="positive">bomb*</span>" regular expressions and "<span class="positive">blackRe</span>", "<span class="positive">scriptRe</span>", "<span class="positive">invalidFormatHeloRe</span>", "<span class="positive">invalidPTRRe</span>" and "<span class="positive">invalidMsgIDRe</span>" it is possible to define a third parameter (to overwrite the default options) after the weight like: Phishing\\.=>1.45|~Heuristics|Email~=>50<span class="positive">:>N[+-]W[+-]L[+-]I[+-]</span>. The characters, the optional to use '+' and the negation '-' switch have the following functions:<br />
use this regex (+ = TRUE , TRUE is default if the + is not defined)(- = FALSE) for: N = noprocessing , W = whitelisted , L = local , I = ISP mails .<br />
If a default option string in the form !!!NWLI!!! is defined anywhere in a single line in the file, this definition will be used (to inherit) as third parameter for all (but only those) lines , which do not contain any definition for the third parameter.<br />
If the third parameter is not set in a line (directly or inherited from the default option string) or any of the N,W,L,I is not set (directly or inherited), the default configuration parameter will be used for the regular expression in this line (for example: a bombRe line has set foo=&gt;5:>WL-I- , you see the N is missing, so bombReNP will be used for noprocessing mails).<br />
So the line ~Heuristics|Email~=>50:>N-W-L-I could be read as: take the regex with a weight of 50, if the mail is: NOT noprocessing and NOT whitelisted and NOT a local mail and received from an ISP. The line ~Heuristics|Email~=>3.2:>N-W+I could be read as: take the regex with a weight of 3.2 as factor, if the mail is: NOT noprocessing and whitelisted and received from an ISP - the not defined L is used from the related ..local configuration parameter.<br />
The NWLI conditions defined in a line are combined using a logical AND -- so N-W+ or N-W is combined to: NOT noprocessing AND whitelisted. In fact, the weight is skipped, if any of the defined NWLI options does not match for a mail. If multiple lines would match, the weight of the first matching line is used.<br />
This way you can define different weights for the same regular expression, but different mail states like in this example:<br />
(1) <b>foo=&gt;0:&gt;NW</b> - weight is zero if noprocessing AND whitelisted<br />
(2) <b>foo=&gt;0.5:&gt;NW-</b> - weight factor is 0.5 if noprocessing AND NOT whitelisted<br />
(3) <b>foo=&gt;1.5:&gt;N-W</b> - weight factor is 1.5 if NOT noprocessing AND whitelisted<br />
(4) <b>foo=&gt;55:&gt;N-W-</b> - weight is 55 if NOT noprocessing AND NOT whitelisted<br />
(5) <b>foo=&gt;2:&gt;W</b> - this line will not be processed, because line 1 or 3 would have matched before, depending on the noprocessing flag<br />
(6) <b>foo=&gt;2:&gt;N-</b> - this line will not be processed, because line 3 or 4 would have matched before, depending on the whitelisted flag<br />
<span class="negative">If any parameter that allowes the usage of weighted regular expressions is set to "block", but the sum of the resulting weighted penalty value is less than the corresponding "Penalty Box Valence Value" (because of lower weights - or a too high Valence Value) - only scoring will be done!</span><br /></div>
<br /><img class="genHelpIcon" src="get?file=images/regex.jpg"><br />
<div id="regex">If the regular expression optimization is used - ("perl module Regexp::Optimizer" installed and enabled) - and you want to disable the optimization for a special regular expression (file based), set one line (eg. the first one) to a value of '<span class="positive">assp-do-not-optimize-regex</span>' or '<span class="positive">a-d-n-o-r</span>' (without the quotes)! To disable the optimization for a specific line/regex, put &lt;&lt;&lt; in front and &gt;&gt;&gt; at the end of the line/regex. To weight such line/regex write for example: <span class="positive">&lt;&lt;&lt;</span>Phishing\\.<span class="positive">&gt;&gt;&gt;</span>=>1.45=>N- or ~<span class="positive">&lt;&lt;&lt;</span>Heuristics|Email<span class="positive">&gt;&gt;&gt;</span>~=>50  or  ~<span class="positive">&lt;&lt;&lt;</span>(Email|HTML|Sanesecurity)\\.(Phishing|Spear|(Spam|Scam)[a-z0-9]?)\\.<span class="positive">&gt;&gt;&gt;</span>~=>4.6 .<br /><br />
Assp supports the usage of unicode block, unicode script and unicode character definitions in regular expressions, like: \\P{Balinese} \\p{Script:Greek} \\P{Hebrew} \\p{script=katakana} \\N{greek:Sigma} \\x{263a}<br />
It is recommended to switch off the regular expression optimization, if a unicode regular expression definition is used (at least for the line, where it is used)!<br />
A small tutorial about regular expressions and a 'how to do complex_AND-NOT_regexes' can be found in the ./docs folder<br /><br /></div>
<img class="genHelpIcon" src="get?file=images/help.jpg"><br />
<div id="reply">The literal 'SESSIONID' will be replaced by the unique message logging ID in every SMTP error reply.<br />
The literal 'IPCONNECTED' will be replaced by the connected IP address in every SMTP error reply.<br />
The literal 'IPORIGIN' will be replaced by the origin IP address in every SMTP error reply.<br />
The literal 'NOTSPAMTAG' will be replaced by a random calculated TAG using <a href="./NotSpamTag">NotSpamTag</a>, in every SMTP permanent (5xx) error reply.<br />
The literal 'MYNAME' will be replaced by the configuration value defined in 'myName' in every SMTP error reply.<br />
The literal 'LASTCOMMAND' will be replaced by the last used SMTP-command in every SMTP error reply.<br />
The literal 'MAILFROM' will be replaced by received envelope sender in every SMTP error reply.<br />
The literal 'RECEIVEDHELO' will be replaced by the received HELO/EHLO string in every SMTP error reply.<br /><br />
If you define any SMTP-reply-code (like for example <b>SpamError</b>) as a <b>temporary</b> reply code (starting with <b>4</b> like <b>4</b>52 instead of the default <b>5</b> like <b>5</b>50), the connection will be dropped at it's current state, regardless any <b>collection</b> or <b>forwarding</b> setting. These actions may <b>finished incomplete</b> in this case!<br /><br /></div>
<img class="genHelpIcon" src="get?file=images/password.jpg"><br />
<div id="encrypt">Values and possibly used files and included files, which may contain security critical data like user names, passwords or system commands - are stored encrypted in the assp.cfg and in the files system. If unencrypted content is found for such a value or file, the content will be encrypted before it is used by assp.<br /><br /></div>
<div id="intname">If the internal name is shown in light blue like <span style="color:#8181F7">(uniqueIDPrefix)</span> , this indicates that the configured value differs from the default value. To show the default value, move the mouse over the internal name. A click on the internal name will reset the value to the default.<br /><br /></div>
<img class="genHelpIcon" src="get?file=images/ip.jpg"><br />

EOT

$lngmsghint{'msg500019'} = '# main form buttom hint 9';
$lngmsg{'msg500019'} = <<EOT;
<br /><img class="genHelpIcon" src="get?file=images/restart.jpg"><br />'kill -HUP $mypid' will load settings from disk. 'kill -NUM07 $mypid' will suspend or resume assp.  'kill -USR2 $mypid' will save settings to disk.<br /><br />
All the hints above will be shown in the GUI as context help at any time, if you click on the related icons right of the configuration parameter description.<br /><br />
If you are looking for a configuration parameter in the GUI, you may find it in the GUI-history <img class="leftTopIcon" src="get?file=images/history.jpg"> or you can search for it by moving the mouse pointer over the most left GUI bar or click on the search icon <img class="leftTopIcon" src="get?file=images/index.jpg"> in the top left menu. Simply write something you remember of the parameter name into the search field.<br /><br />
The GUI contains dynamic content depending on the configuration, the installed perl modules and the operating system. So, you may notice differences between the manual and the GUI at some point. If you scroll down to the bottom and you click on the most right 'Print the Manual' link, the manual is printed containing all your current settings and the current dynamic content.<br />
<span class="negative">It is highly recommended to read the manual more than once!</span> This will give you a clue about how assp works and how the features and plugins are working together.<br />
Using assp presupposes that you are familar with the SMTP protocol, the possibly used database engine and the general functionality of the used features (like LDAP, SPF, DKIM, RBL, DNSWL ..).<br />
Keep in mind that assp is a proxy - it requires SMTP-servers as backend. Know your mail flow (in and out - make a plan), the used IP addresses, hostnames and ports - the wiki may help you.<br />
It helps alot to know perl regular expressions, if you use them. Knowing the perl language helps to fine tune some (hidden) configuration parameters (e.g. lib/CorrectASSPcfg.pm or the lines 397 to 678 in assp.pl ).<br />
ASSP will run out of the box, if the mail flow parameters (IP's/ports/local domains/users) are configured right. Read the GUI section by section and tweak the configuration to your needs - but don't change too many parameters at a time and skip those you don't understand. Use the 'Notes on ..' buttons at the bottom of each GUI section and 'left menu =&gt; config info =&gt; privat config notes' to document your settings. In doubt set the new configured feature into testmode or to monitoring.<br />
Some usefull information can also be found in the ./docs folder. And not to forget - if you update assp, read the changelog.txt - all important changes and news are available there - 'top menu =&gt; server stats =&gt; server information and download links =&gt; ASSP Version'!
EOT

$lngmsghint{'msg500020'} = '# manage users form hint';
$lngmsg{'msg500020'} = <<EOT;
Use the "Continue" button as long as you only want to see or to temporary change any parameter.
Use the "Apply Changes" button to apply all changes, that are currenty shown, to the user.
All user names that begins with a "~" are templates. The template "~DEFAULT" can't be deleted.
All permissions of a user can refer to a template, in this case the permission of the template
belongs to the user. If the template permission is changed, all user permissions
that refers to that template will also be changed. Template permissions can never refer to an
another user or template. It is possible to copy all permissions of a template or a user to
another user or template. If "use LDAP / LDAP host" is filled with an IP-address or hostname
the local password will only be used, if the LDAPhost is not available. If an LDAP login is
successful, the LDAP-password will be stored as local password. It is possible to configure
multiple LDAP hosts separated by "|". To navigate use the alpha-index on the left site.
EOT

$lngmsghint{'msg500031'} = '# White/Redlist/Tuplets';
$lngmsg{'msg500031'} = <<EOT;
Do you want to work with the:
EOT

$lngmsg{'msg500032'} = <<EOT;
Do you want to:
EOT

$lngmsg{'msg500033'} = <<EOT;
<p>Post less than 1 megabyte of data at a time.</p>
Note: The redlist is not a blacklist. The redlist is a list of addresses that cannot
contribute to the whitelist, and who are not considered local, even if their mail is
from a local computer. For example, if someone goes on a vacation and turns on their
email's autoresponder, put them on the redlist until they return. Then as they reply
to every spam they receive they won't corrupt your non-spam collection or whitelist.<br /><br />
In this panel, Whitelist verifications and operations are done independend from the setting of the WhitelistPrivacyLevel.<br /><br />
To add or remove a global whitelist entry, use sender\@senderdomain.org<br />
To add or remove a domain whitelist entry, use sender\@senderdomain.org,\@localdomain.org<br />
To add or remove a private whitelist entry, use sender\@senderdomain.org,user\@localdomain.org<br />
To delete a global whitelist entry and all domain and private entries, use sender\@senderdomain.org,*<br />
To delete a domain whitelist entry and all private entries, use sender\@senderdomain.org,\@localdomain.org<br />
To delete a private whitelist entry, use sender\@senderdomain.org,user\@localdomain.org<br />
To renew an entry (e.g. extend the expiration date), add or remove it again.<br /><br />
Selecting 'Whitelist' and 'search', the input in each line will be interpreted as a perl regular expression and all matching whitelist entries will be shown.<br />
For example:<br />
\\.senderdomain\\.org,[^@]*\\\@localdomain\\.org - will show all entries for the sending domain senderdomain.org and the local domain localdomain.org<br />
\\.senderdomain\\.org - will show all entries for this sending domain<br />
,\\\@localdomain.org - will show all domain entries for this local domain<br />
,user\\\@localdomain.org - will show all whitelist entries for this local user<br /><br />
<b>NOTICE: removing whitelist entries will mark the records as NOT whitelisted - the records are NOT deleted from the database/list. Wildcards (,*) are ignored for the remove action!</b><br />
<p class="warning">
NOTICE: deleting whitelist entries will DELETE ALL related (matching) records! For example: an emailaddress is globaly whitelisted but markted as not whitelisted for a specific domain.
Now if you DELETE the domain based record, all domain related records will be deleted - but because of the global whitelisting, all emailaddresses from this domain are now treated as whitelisted!</p>
EOT

$lngmsg{'msg500034'} = <<EOT;
<p class="warning">Warning: If your whitelist or redlist is long, pushing these buttons
 is ill-advised. Use these for testing and while your whitelist is short.</p>
EOT

$lngmsghint{'msg500040'} = '# Recipient Replacement Test';
$lngmsg{'msg500040'} = '<p><a href="./#ReplaceRecpt">go to ReplaceRecpt to configure rules</a></p>';
$lngmsg{'msg500041'} = '<p><span class="negative"><a href="./#ReplaceRecpt">ReplaceRecpt</a> is not configured - please do this first!</span></p>';
$lngmsg{'msg500042'} = '<p>to modify the replacement rules, open the file by clicking edit ';

$lngmsg{'msg500043'} = '<p>the following replacement rules were processed (matching rules are shown green)</p><br />';

$lngmsghint{'msg500050'} = '# View Maillog Tail';
$lngmsg{'msg500050'} = <<EOT;
Refresh your browser or click [Search/Update] to update this screen. Newest entries are at the end. The search will stop, if the [search for] field is blank - and [tail bytes] is reached, or if the [search for] field is not blank - and [search in] or the number of [results] is reached. If you search for more than one word, all words must match. Words with a leading \\'-\\' will be negated. For example: a search pattern \\'user -root\\', will search all lines which contains the word \\'user\\' but not the word \\'root\\'! Don\\'t use the characters &quot;&gt;\\'&lt;&amp; in the search field.
EOT

$lngmsg{'msg500051'} = <<EOT;
Select [file lines only], if you want to reduce the shown number of lines to such (POST filter), which contains filenames.<br /><br /> Use the MaillogTail function carefully, while ASSP is processing any request, no new connections will be accepted by ASSP, and this could take some minutes, if you search in large or many maillogs! To start realtime maillog, click on [Auto], to stop realtime maillog, click on [Stop].
EOT

$lngmsg{'msg500052'} = <<EOT;
If [this file number(s)] is selected, you can define a single filenumber or a comma separated list of filenumbers here - like: <b>1,5,8,7,6 or 10,2...7,11,14-19,21,23...26</b>  A defined range 2...7 or 2-7 will include all numbers from 2 to 7. The resulting numbers will be internaly sorted ascending and the files will be used in that sorted order.
EOT

$lngmsg{'msg500053'} = <<EOT;
Enter the search string - for more help use the [help] link. If you want to start the realtime log [Auto], you can define the number of lines to show in the browser [1 - 33] here.
EOT

$lngmsghint{'msg500060'} = '# Mail Analyzer';
$lngmsg{'msg500060'} = <<EOT;
This page will show you how ASSP analyzes and pre-processes an email to come up with the assigned spam probability. Regular Expressions will always check the full message. Group matching of any address will be shown. To analyze/modify individual email addresses click <a href="javascript:void(0);" onclick="popAddressAction('example\@$myName');return false;">here <img class="helpIcon" src="get?file=images/address.jpg"></a>. To analyze/modify individual IP addresses click <a href="javascript:void(0);" onclick="popIPAction('');return false;">here <img class="helpIcon" src="get?file=images/ip.jpg"></a>.
EOT

$lngmsg{'msg500061'} = <<EOT;
Copy and paste the mail header and body here:
EOT

$lngmsg{'msg500062'} = <<EOT;
<b>You may put here helo=aaa.bbb.helo or ip=123.123.123.123 to look up the helo/ip information. text=abc will start a lookup in the regular expression files for the "abc" matching regex.<br />
Put helo=hostname.domain.com and/or from=user\@domain.com and ip=123.123.123.123 in separate lines, to lookup SPF results.</b>
<p>Note: Analysis is performed using the current spam database, hashes and lists --
if yours was rebuilt since the time the mail was received, you'll receive a different result.
This also applies to the feature matching results, they may be diffent from the results when the mail was received.
All feature matching results are shown stateless - which means for example: if 'noprocessing' and a 'RBL/DNSBL hit' is shown here, in the real mail processing, the RBL check may be skipped because of the
noprocessing state.</p>
EOT

$lngmsg{'msg500063'} = <<EOT;
<p>To use this form using <i>Outlook Express</i> do the following. Right-click on the message
of interest. Select <i>Properties</i>. Click the <i>Details</i> tab. Click the <i>message
source</i> button. Right-click on the message source and click <i>Select All</i>. Right-click
again and click <i>Copy</i>. Click on the text box above and paste (Ctrl-V perhaps). Click
the <i>Analyze</i> button.</p>
<p>The page will update to show you the following: if any of the email's addresses are in
the redlist or whitelist, the most and least spammy phrases together with their spaminess,
the resulting probabilities (probabilities may repeat one time), and the final spam probability
score.<br /><br />
To only transliterate the text (even MIME encoded) from non-Roman letters to Roman letters, simply select the checkbox.
EOT

$lngmsghint{'msg500070'} = '# Shutdown/Restart';
$lngmsg{'msg500070'} = <<EOT;
Note: It's possible to restart, if ASSP runs as a service or in a script that restarts it after it stops or it runs on WIN32 version Windows 2000(or higher) or it runs on linux,
otherwise this function can only shut ASSP down. In either case, shutdown is possibly not clean -- all SMTP sessions will be interrupted after $MaxFinConWaitTime seconds.<br /><br />
EOT
$lngmsg{'msg500070'} .= <<EOT if $WebIP{$ActWebSess}->{user} eq 'root';
The following command will be started in OS-shell, if ASSP runs not as a service or daemon:<br /><b><font color=green>$AutoRestartCmd</font></b>
EOT

$lngmsghint{'msg500080'} = '# EDIT files window/frame';
$lngmsg{'msg500080'} = <<EOT;
<span class="negative">Attention: This is the real database content!<br />
Incorrect editing hash lists could result in unexpected behavior or dying ASSP!</span><br />
Use |::| as terminator between key and value, for example: 102.1.1.1|::|1234567890 !<br />
If a time is shown human readable, you can change the date or time,<br />
but leave the format as it is ([+]YYYY-MM-DD,hh:mm:ss) and leave a possible \'+\' in front.<br />
Use only one pair of key and value per line.<br />
Comments are not allowed!<br />
While the hash is saved, ASSP is unable to accept new connections!<br />
Be careful saveing large hash here, this could take very long time. Better save the new contents of large hashes and lists to the Importfile, if this option is available. If possible, the DB-Import will be started immediately by the MaintThread!<br />
After saving the contents to the Importfile, you should close this windows and wait until the import has finished!
EOT

$lngmsg{'msg500081'} = 'File should have one entry per line; anything on a line following a number sign (#) is ignored (a comment). Whitespace at the beginning or end of the line is ignored.';
$lngmsg{'msg500082'} = 'First line specifies text that appears in the subject of report message. The remaining lines are the report message body.';
$lngmsg{'msg500083'} = 'Put here comments to your assp installation.';
$lngmsg{'msg500084'} = 'For removal of entries from BlackBox (PBBlack) use <a onmousedown="showDisp(\'$ConfigPos{noPB}\')" target="main" href="./#noPB">noPB</a>.
For removal of entries from WhiteBox (PBWhite)  use <a onmousedown="showDisp(\'$ConfigPos{noPBwhite}\')" target="main" href="./#noPBwhite">noPBwhite</a>. For  whitelisting IP\'s use <a onmousedown="showDisp(\'$ConfigPos{whiteListedIPs}\')" target="main" href="./#whiteListedIPs">Whitelisted IP\'s</a> or <a onmousedown="showDisp(\'$ConfigPos{noProcessingIPs}\')" target="main" href="./#noProcessingIPs">No Processing IP\'s</a>. For blacklisting use <a onmousedown="showDisp(\'$ConfigPos{denySMTPConnectionsFrom}\')" target="main" href="./#denySMTPConnectionsFrom">Deny SMTP Connections From these IP\'s</a> and <a onmousedown="showDisp(\'$ConfigPos{denySMTPConnectionsFromAlways}\')" target="main" href="./#denySMTPConnectionsFromAlways">Deny SMTP Connections From these IP\'s Strictly</a>.';

$lngmsg{'msg500086'} = 'CacheEntry: IP/Domain \'11\' CacheIntervalStart 1=fail/2=pass Result/Comment';

$lngmsg{'msg500090'} = 'To take an action, select the action and click "Do It!". To move a file to another location, just copy and delete the file!';
$lngmsg{'msg500091'} = '<br /> For "resend file" action install the Email::Address::XS module!';

$lngmsg{'msg500092'} = 'IP ranges can be defined as: 182.82.10. ';

$lngmsghint{'msg500093'} = '# the following messages are in one line 0093.$records.0094';
$lngmsg{'msg500093'} = 'This hash/list seems to be too large (';
$lngmsg{'msg500094'} = 'records) to save it from GUI!';

$lngmsg{'msg500095'} = 'Please close this window, and wait until import has finished.';
$lngmsg{'msg500096'} = "This file was trunked to (MaxBytes) $MaxBytes byte. If you resend this file, the resulting view and/or attachments would be destroyed!";

$lngmsg{'msg500097'} = '<br />Using the left mouse button at "show email in browser sandbox" will show the email in a secured browser sandbox <a href="https://en.wikipedia.org/wiki/Content_Security_Policy" target="_blank">(Content Security Policy)</a> - using the right mouse button, images will be show in addition (except in MS-Internet-Explorer). <span class="negative">Showing images can be a risk, if they contain malicious code!</span>';
$lngmsg{'msg500098'} = '<br />To download an attachment (e.g. to check it), click at the attachment name.';

$lngmsghint{'msg500100'} = '# SMTP-Connection - link - hintbox';
$lngmsg{'msg500100'} = 'Click here to open a SMTP-Connections-Window that never stops refreshing. Do not make any changes in the main window, while this SMTP-Connections-Window is still opened! A SMTP-Connections-Window which is started with the default (left beside) link, will stop refreshing if it is not in forground.';

}

sub renderConfigHTML {
  setMainLang();
  my $maillogEnd;
  if ($MaillogTailJump) {
    $maillogEnd = '#MlEnd';
  } else {
    $maillogEnd = '#MlTop';
  }
  $maillogJump = '<a href="javascript:void(0);" onclick="MlEndPos=document.getElementById(\'LogLines\').scrollTop; document.getElementById(\'LogLines\').scrollTop=0; return false;">Go to Top</a><a name="MlEnd"></a>';
  my $IndexPos = $hideAlphaIndex ? '451' : '440';
  my $IndexStart = $hideAlphaIndex ? '452' : '442';
  my $JavaScript;

  my $ConnHint = $WebIP{$ActWebSess}->{lng}->{'msg500100'} || $lngmsg{'msg500100'};

  $plusIcon = 'get?file=images/plusIcon.png';
  $minusIcon = 'get?file=images/minusIcon.png';
  $noIcon = 'get?file=images/noIcon.png';
  my $NavMenu = '
 <hr />
  <div onclick="window.location.href=\'./lists\';"><img src="' . $noIcon . '" alt="noicon" /> White/Redlist/Tuplets</div>
  <div onclick="popAddressAction();"><img src="' . $noIcon . '" alt="noicon" /> work with addresses</div>
  <div onclick="popIPAction();"><img src="' . $noIcon . '" alt="noicon" /> work with IP\'s</div>
  <div onclick="window.location.href=\'./recprepl\';"><img src="' . $noIcon . '" alt="noicon" /> Recipient Replacement Test</div>
  <div onclick="window.open(\'./maillog' . $maillogEnd . '\');"><img src="' . $noIcon . '" alt="noicon" /> View Maillog Tail</div>
  <div onclick="window.location.href=\'./analyze\';"><img src="' . $noIcon . '" alt="noicon" /> Mail Analyzer</div>
  <div onclick="window.location.href=\'./infostats\';"><img src="' . $noIcon . '" alt="noicon" /> Info and Stats </div>
  ';
  $NavMenu .= '
  <div onclick="window.open(\'./top10stats?count='.$toptencount.'\');"><img src="' . $noIcon . '" alt="noicon" /> Top 10 Stats</div>' if $DoT10Stat;
  $NavMenu .= '
  <div onclick="window.open(\'./statusassp?nocache='.time.'\');"><img src="' . $noIcon . '" alt="noicon" /> Worker/DB/Regex Status</div>
  <div onclick="window.open(\'./shutdown_list?nocache='.time.'\');"><img src="' . $noIcon . '" alt="this monitor will slow down ASSP dramaticly - use it careful" /> SMTP Connections</div>
  <div onclick="window.open(\'./shutdown_list?nocache='.time.'&forceRefresh=1\');" onmouseover="showhint(\''.$ConnHint.'\', this, event, \'500px\', \'1\');return false;"><img src="' . $noIcon . '" alt="this monitor will slow down ASSP dramaticly - use it careful" /> SMTP Connections permanent</div>
  <div onclick="window.location.href=\'./shutdown\';"><img src="' . $noIcon . '" alt="noicon" /> Shutdown/Restart</div>
  <div onclick="window.location.href=\'./donations\';"><img src="' . $noIcon . '" alt="noicon" /> Donations</div>';
 $JavaScript = "
<script type=\"text/javascript\">
<!--
var oldBrowser = false;
/*\@cc_on
   /*\@if (\@_jscript_version < 5.6)
      oldBrowser = true;
   /*\@end
\@*/

if (window.navigator.appName == \"Microsoft Internet Explorer\")
{
   var engine;
   if (document.documentMode) // IE8
      engine = document.documentMode;
   else // IE 5-7
   {
      engine = 5; // Assume quirks mode unless proven otherwise
      if (document.compatMode)
      {
         if (document.compatMode == \"CSS1Compat\")
            engine = 7; //standard mode
      }
   }
   if (engine < 8) {oldBrowser = true;}
}
var BrowserDetect = {
	init: function () {
		this.browser = this.searchString(this.dataBrowser) || \"An unknown browser\";
		this.version = this.searchVersion(navigator.userAgent)
			|| this.searchVersion(navigator.appVersion)
			|| \"an unknown version\";
		this.OS = this.searchString(this.dataOS) || \"an unknown OS\";
	},
	searchString: function (data) {
		for (var i=0;i<data.length;i++)	{
			var dataString = data[i].string;
			var dataProp = data[i].prop;
			this.versionSearchString = data[i].versionSearch || data[i].identity;
			if (dataString) {
				if (dataString.indexOf(data[i].subString) != -1)
					return data[i].identity;
			}
			else if (dataProp)
				return data[i].identity;
		}
	},
	searchVersion: function (dataString) {
		var index = dataString.indexOf(this.versionSearchString);
		if (index == -1) return;
		return parseFloat(dataString.substring(index+this.versionSearchString.length+1));
	},
	dataBrowser: [
		{
			string: navigator.userAgent,
			subString: \"Chrome\",
			identity: \"Chrome\"
		},
		{ 	string: navigator.userAgent,
			subString: \"OmniWeb\",
			versionSearch: \"OmniWeb/\",
			identity: \"OmniWeb\"
		},
		{
			string: navigator.vendor,
			subString: \"Apple\",
			identity: \"Safari\",
			versionSearch: \"Version\"
		},
		{
			prop: window.opera,
			identity: \"Opera\"
		},
		{
			string: navigator.vendor,
			subString: \"iCab\",
			identity: \"iCab\"
		},
		{
			string: navigator.vendor,
			subString: \"KDE\",
			identity: \"Konqueror\"
		},
		{
			string: navigator.userAgent,
			subString: \"Firefox\",
			identity: \"Firefox\"
		},
		{
			string: navigator.vendor,
			subString: \"Camino\",
			identity: \"Camino\"
		},
		{		// for newer Netscapes (6+)
			string: navigator.userAgent,
			subString: \"Netscape\",
			identity: \"Netscape\"
		},
		{
			string: navigator.userAgent,
			subString: \"MSIE\",
			identity: \"Explorer\",
			versionSearch: \"MSIE\"
		},
		{
			string: navigator.userAgent,
			subString: \"Gecko\",
			identity: \"Mozilla\",
			versionSearch: \"rv\"
		},
		{ 		// for older Netscapes (4-)
			string: navigator.userAgent,
			subString: \"Mozilla\",
			identity: \"Netscape\",
			versionSearch: \"Mozilla\"
		}
	],
	dataOS : [
		{
			string: navigator.platform,
			subString: \"Win\",
			identity: \"Windows\"
		},
		{
			string: navigator.platform,
			subString: \"Mac\",
			identity: \"Mac\"
		},
		{
			   string: navigator.userAgent,
			   subString: \"iPhone\",
			   identity: \"iPhone/iPod\"
	    },
		{
			string: navigator.platform,
			subString: \"Linux\",
			identity: \"Linux\"
		}
	]

};
BrowserDetect.init();

var detectedBrowser = 'ASSP-GUI is running in ' + BrowserDetect.browser + ' version ' + BrowserDetect.version + ' on ' + BrowserDetect.OS;
if (oldBrowser) {
    detectedBrowser = detectedBrowser + ' (old javascript engine and/or browser detected)';
}
// -->
</script>

<script type=\"text/javascript\">
<!--

var configPos = new Array();
";
 for my $idx (0...$#ConfigArray) {
   my $c = $ConfigArray[$idx];
   next if (@{$c} == 5);
   $JavaScript .= "configPos['$c->[0]']='$ConfigPos{$c->[0]}';";
 }

$JavaScript .= "
function quotemeta (qstr) {
    return qstr.replace( /([^A-Za-z0-9])/g , \"\\\\\$1\" );
}

function toggleDisp(nodeid)
{
  if (nodeid == null) return false;
  if(nodeid.substr(0,9) == 'setupItem')
    nodeid = nodeid.substr(9);
  layer = document.getElementById('treeElement' + nodeid);
  img = document.getElementById('treeIcon' + nodeid);
  if(layer.style.display == 'none')
  {
    layer.style.display = 'block';
    img.src = '$minusIcon';
    if(document.getElementById('setupItem' + nodeid))
      document.getElementById('setupItem' + nodeid).style.display = 'block';
  }
  else
  {
    layer.style.display = 'none';
    img.src = '$plusIcon';
    if(document.getElementById('setupItem' + nodeid))
      document.getElementById('setupItem' + nodeid).style.display = 'none';
  }
}
function showDisp(nodeid)
{
  if (nodeid == null) return false;
  if(nodeid.substr(0,9) == 'setupItem')
    nodeid = nodeid.substr(9);
  layer = document.getElementById('treeElement' + nodeid);
  img = document.getElementById('treeIcon' + nodeid);
  if(layer.style.display == 'none')
  {
    layer.style.display = 'block';
    img.src = '$minusIcon';
    if(document.getElementById('setupItem' + nodeid))
      document.getElementById('setupItem' + nodeid).style.display = 'block';
  }
}
function gotoAnchor(aname)
{
//    window.location.href = \"#\" + aname;       //
    var currloc = window.location.href.split('#')[0];
    var re = /\\/(maillog|lists|recprepl|infostats|shutdown|analyze|donations)/;
    if (re.test(currloc))
    {
        window.location.href = window.location.protocol + '//' + window.location.host + '/#' + aname;
        setAnchor(aname);
        return;
    }
    re = new RegExp('/adminusers',\"i\");
    if (re.test(currloc)) {
//        window.history.replaceState({},'',currloc + '#' + aname);
        window.location.href = currloc + \"#\" + aname;
    }
    else {
        window.location.href = window.location.protocol + '//' + window.location.host + '/#' + aname;
        if (aname.length != 1) {setAnchor(aname);}
    }
}
function expand(expand, force)
{
  counter = 0;
  while(document.getElementById('treeElement' + counter))
  {
    if(!expand)
    {
      //dont shrink if this element is the one passed in the URL
      arr = document.getElementById('treeElement' + counter).getElementsByTagName('a');
      txt = ''; found = 0;
      loc = new String(document.location);
      for(i=0; i < arr.length; i++)
      {
        txt = txt + arr.item(i).href;
        tmpHref = new String(arr.item(i).href);
        if(tmpHref.substr(tmpHref.indexOf('#')) == loc.substr(loc.indexOf('#')))
        {
          //give this tree node the right icon
          document.getElementById('treeIcon' + counter).src = '$minusIcon';
          found = 1;
        }
      }
      if(!found | force)
      {
        document.getElementById('treeIcon' + counter).src = '$plusIcon';
        document.getElementById('treeElement' + counter).style.display = 'none';
        if(document.getElementById('setupItem' + counter))
          document.getElementById('setupItem' + counter).style.display = 'none';
      }
    }
    else
    {
      document.getElementById('treeElement' + counter).style.display = 'block';
      document.getElementById('treeIcon' + counter).src = '$minusIcon';
      if(document.getElementById('setupItem' + counter))
        document.getElementById('setupItem' + counter).style.display = 'block';
    }
    counter++;
  }
}

//make the 'rel's work
function externalLinks()
{
  var anchors = document.getElementsByTagName(\"a\");
  for (var i=0; i<anchors.length; i++)
  {
    var anchor = anchors[i];
    if (anchor.getAttribute(\"href\")
      && anchor.getAttribute(\"rel\") == \"external\")
      anchor.target = \"_blank\";
  }
  createhintbox();
}

// handle cookies to remember something
function createCookie(name,value,days) {
    if (! navigator.cookieEnabled) {return null;}
	if (days) {
		var date = new Date();
		date.setTime(date.getTime()+(days*24*60*60*1000));
		var expires = \"; expires=\"+date.toGMTString();
	}
	else var expires = \"\";
	document.cookie = name+\"=\"+value+expires+\"; path=/\";
}

function readCookie(name) {
    if (! navigator.cookieEnabled) {return null;}
	var nameEQ = name + \"=\";
	var ca = document.cookie.split(';');
	for(var i=0;i < ca.length;i++) {
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	}
	return false;
}

function eraseCookie(name) {
    if (! navigator.cookieEnabled) {return null;}
	createCookie(name,\"\",-1);
}

function updateHistory(iname) {
    if (! navigator.cookieEnabled) {return null;}
    if (! iname || iname == 'delete' || iname == 'undefined' || iname == '') {return null;}
    var cookie = readCookie('history');
    var history = [];
    if (cookie != false) {
        history = cookie.split(' ');
     	for(var i=0;i < history.length;i++) {
            if (history[i] == iname || history[i] == 'undefined') {history.splice(i,1);}
        }
        if (history.length > 19) {history.pop();}
    }
    history.unshift(iname);
    createCookie('history',history.join(' '),31);
}

function getHistory() {
    var boxtext = '<p style=\"text-align:center;\"><b>history</b><span class=\"menuLevel2\" style=\"float:right;\" onclick=\"hidetip();\" ><b>close</b></span>&nbsp;&nbsp;<span class=\"menuLevel2\" style=\"float:right;\" onclick=\"eraseCookie(\\'history\\');hidetip();\" ><b>clear</b></span></p><hr/>';
    if (! navigator.cookieEnabled) {return boxtext;}
    var cookie = readCookie('history');
    if (! cookie) {return boxtext;}
    var history = [];
    history = cookie.split(' ');

    for(var i=0;i < history.length;i++) {
        boxtext = boxtext + '<div class=\"menuLevel2\" onclick=\"showDisp(configPos[\\'' + history[i] + '\\']); gotoAnchor(\\'' + history[i] + '\\');hidetip();return false;\">' + history[i] + '</div>' ;
    }
    return boxtext;
}

function setAnchor(iname)
{
    if (iname == 'undefined' || iname == '' || ! iname) {return;}
    if (navigator.cookieEnabled) {
        createCookie('lastAnchor',iname,1);
        updateHistory(iname);
    }
//    var rgp = '$RememberGUIPos';
//    if (rgp == '1') {
//        try {
//        if (iname != 'delete') {
//            window.history.replaceState('','','/#'+iname);
//        } else {
//            window.history.replaceState('','','/');
//        }
//        } catch (e) {}
//    }
}

function initAnchor(doIt)
{
    if (doIt != '1') {return null;}
    if (! navigator.cookieEnabled) {return null;}
    var iname = readCookie('lastAnchor');
    if (! iname || iname == '' || iname == 'delete') {return false;}
//    if (window.location.pathname == '/' || window.location.pathname == '') {
        showDisp(configPos[iname]);
        gotoAnchor(iname);
//    } else {
//        return false;
//    }
}

function showHelp(list) {
    var boxtext = '<p onclick=\"hidetip();\" style=\"text-align:center;\"><b>context help and information</b><span class=\"menuLevel2\" style=\"float:right;\" ><b>close</b></span></p><hr/>';
    for(var i=3;i < list.length;i++) {
        boxtext = boxtext + document.getElementById(list[i]).innerHTML;
    }
    boxtext = boxtext + '<p onclick=\"hidetip();\" style=\"text-align:center;\">&nbsp;<span class=\"menuLevel2\" style=\"float:right;\" ><b>close</b></span></p>';
    showhint(boxtext, list[0], list[1], list[2], \'2\');
}
";

  $JavaScript .= "
function docHeight()
{
  if (typeof document.height != 'undefined') {
    return document.height;
  } else if (document.compatMode && document.compatMode != 'BackCompat') {
    return document.documentElement.scrollHeight;
  } else if (document.body && typeof document.body.scrollHeight !='undefined') {
    return document.body.scrollHeight;
  }
}
//********************************************************
//* You may use this code for free on any web page provided that
//* these comment lines and the following credit remain in the code.
//* Floating Div from http://www.javascript-fx.com
//********************************************************
// Modified in May 2005 by Przemek Czerkas:
//  - added calls to docHeight()
//  - added bounding params tlx, tly, brx, bry
var ns = (navigator.appName.indexOf(\"Netscape\") != -1);
var d = document;
var px = document.layers ? \"\" : \"px\";
function JSFX_FloatDiv(id, sx, sy, tlx, tly, brx, bry)
{
  var el=d.getElementById?d.getElementById(id):d.all?d.all[id]:d.layers[id];
  window[id + \"_obj\"] = el;
  if(d.layers)el.style=el;
  el.cx = el.sx = sx;
  el.cy = el.sy = sy;
  el.tlx = tlx;
  el.tly = tly;
  el.brx = brx;
  el.bry = bry;
  el.sP=function(x,y){this.style.left=x+px;this.style.top=y+px;};
  el.flt=function()
  {
    var pX, pY;
    pX = ns ? pageXOffset : document.documentElement && document.documentElement.scrollLeft ? document.documentElement.scrollLeft : document.body.scrollLeft;
    pY = ns ? pageYOffset : document.documentElement && document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop;
    if(this.sy<0)
      pY += ns ? innerHeight : document.documentElement && document.documentElement.clientHeight ? document.documentElement.clientHeight : document.body.clientHeight;
    this.cx += (pX + Math.max(this.sx-pX, this.tlx) - this.cx)/4;
    this.cy += (pY + Math.max(this.sy-pY, this.tly) - this.cy)/4;
    this.cx = Math.min(this.cx, this.brx);
    this.cy = Math.min(this.cy, this.bry);
    if (ns) {
      this.sP(
        Math.max(Math.min(this.cx+this.clientWidth,document.width)-this.clientWidth,this.sx),
        Math.max(Math.min(this.cy+this.clientHeight,document.height)-this.clientHeight,this.sy)
      );
    } else {
      var oldh, newh;
      oldh = docHeight();
      this.sP(this.cx, this.cy);
      newh = docHeight();
      if (newh>oldh) {
        this.sP(this.cx, this.cy-(newh-oldh));
      }
    }
    setTimeout(this.id + \"_obj.flt()\", 20);
  }
  return el;
}" if ($EnableFloatingMenu && ! $mobile);

 $JavaScript .= '
function popFileEditor(filename,note)
{
  var height = (note == 0) ? 500 : (note == \'m\') ? 580 : 550;
  newwindow=window.open(
    \'edit?file=\'+filename+\'&note=\'+note,
    \'FileEditor\',
    \'width=720,height=\'+height+\',overflow=scroll,toolbar=yes,menubar=yes,location=yes,personalbar=yes,scrollbars=yes,status=no,directories=no,resizable=yes\'
  );
  	// this puts focus on the popup window if we open a new popup without closing the old one.
  	if (window.focus) {newwindow.focus()}
  	return false;
}

function popAddressAction(address)
{
  var height = 500 ;
  var link = address ? \'?address=\'+address : \'\';
  newwindow=window.open(
    \'addraction\'+link,
    \'AddressAction\',
    \'width=720,height=\'+height+\',overflow=scroll,toolbar=yes,menubar=yes,location=no,personalbar=yes,scrollbars=yes,status=no,directories=no,resizable=yes\'
  );
  	// this puts focus on the popup window if we open a new popup without closing the old one.
  	if (window.focus) {newwindow.focus()}
  	return false;
}

function popIPAction(ip)
{
  var height = 500 ;
  var link = ip ? \'?ip=\'+ip : \'\';
  newwindow=window.open(
    \'ipaction\'+link,
    \'IPAction\',
    \'width=720,height=\'+height+\',overflow=scroll,toolbar=yes,menubar=yes,location=no,personalbar=yes,scrollbars=yes,status=no,directories=no,resizable=yes\'
  );
  	// this puts focus on the popup window if we open a new popup without closing the old one.
  	if (window.focus) {newwindow.focus()}
  	return false;
}

function popSyncEditor(cfgParm)
{
  setAnchor(cfgParm);
  var height = 400;
  newwindow=window.open(
    \'syncedit?cfgparm=\'+cfgParm,
    \'SyncEditor\',
    \'width=600,height=\'+height+\',overflow=scroll,toolbar=yes,menubar=yes,location=no,personalbar=yes,scrollbars=yes,status=no,directories=no,resizable=yes\'
  );
  	// this puts focus on the popup window if we open a new popup without closing the old one.
  	if (window.focus) {newwindow.focus()}
  	return false;
}

function remember(content)
{
  var height =  580;
  var link = content ? \'?content=\'+content : \'\';
  newwindow=window.open(
    \'remember\'+link,
    \'rememberMe\',
    \'width=720,height=\'+height+\',overflow=scroll,toolbar=yes,menubar=yes,location=no,personalbar=yes,scrollbars=yes,status=no,directories=no,resizable=yes\'
  );
  	// this puts focus on the popup window if we open a new popup without closing the old one.
  	if (window.focus) {newwindow.focus()}
  	return false;
}

function newWindow(target,title)
{
  var height = 600;
  newwindow=window.open(
    target,
    title,
    \'width=960,height=\'+height+\',overflow=scroll,toolbar=yes,menubar=yes,location=no,personalbar=yes,scrollbars=yes,status=no,directories=no,resizable=yes\'
  );
  	// this puts focus on the popup window if we open a new popup without closing the old one.
  	if (window.focus) {newwindow.focus()}
  	return false;
}
// -->
</script>';

# JavaScript for alphabetic IndexMenu
 $JavaScript .= '
<script type="text/javascript">
<!--
// Sliding Menu Script
// copyright Stephen Chapman, 6th July 2005
// you may copy this code but please keep the copyright notice as well
// ASSP implementation by Thomas Eckardt
var speed = 1;

function changeSlide() {
    var findText = xDOM(\'quickfind\').value;
    if (findText == \'**select**\') findText = \'\';
    var re;
    try {
        re = new RegExp(findText,"i");
        re.test(\'abc\');
    }
    catch(err) {
        alert(\'error in string (regex) : \'+err);
        return false;
    }
    var entries = xDOM(\'sleft\').getElementsByTagName(\'a\');
    for (var i=0; i<entries.length; i++) {
        var id=entries[i].id;
        if (! id) next;
        if (findText == \'\' || re.test(id.substr(3))) {
            setObjDisp(id,\'inline\');
        } else {
            setObjDisp(id,\'none\');
        }
    }
}

function ClientSize(HorW) {
  var myWidth = 0, myHeight = 0;
  if( typeof( window.innerWidth ) == \'number\' ) {
    //Non-IE
    myWidth = window.innerWidth;
    myHeight = window.innerHeight;
  } else if( document.documentElement && ( document.documentElement.clientWidth || document.documentElement.clientHeight ) ) {
    //IE 6+ in \'standards compliant mode\'
    myWidth = document.documentElement.clientWidth;
    myHeight = document.documentElement.clientHeight;
  } else if( document.body && ( document.body.clientWidth || document.body.clientHeight ) ) {
    //IE 4 compatible
    myWidth = document.body.clientWidth;
    myHeight = document.body.clientHeight;
  }
  return  HorW == \'w\' ?  myWidth : myHeight;
}

var aDOM = 0, ieDOM = 0, nsDOM = 0; var stdDOM = document.getElementById;
if (stdDOM) aDOM = 1; else {ieDOM = document.all; if (ieDOM) aDOM = 1; else {
var nsDOM = ((navigator.appName.indexOf(\'Netscape\') != -1)
&& (parseInt(navigator.appVersion) ==4)); if (nsDOM) aDOM = 1;}}

function xDOM(objectId, wS) {
  if (stdDOM) return wS ? document.getElementById(objectId).style : document.getElementById(objectId);
  if (ieDOM) return wS ? document.all[objectId].style : document.all[objectId];
  if (nsDOM) return document.layers[objectId];
}
function objWidth(objectID) {var obj = xDOM(objectID,0); if(obj.offsetWidth) return obj.offsetWidth; if (obj.clip) return obj.clip.width; return 0;}
function objHeight(objectID) {var obj = xDOM(objectID,0); if(obj.offsetHeight) return obj.offsetHeight; if (obj.clip) return obj.clip.height; return 0;}
function setObjVis(objectID,vis) {var objs = xDOM(objectID,1); objs.visibility = vis;}
function setObjDisp(objectID,disp) {var objs = xDOM(objectID,1); objs.display = disp;}
function moveObjTo(objectID,x,y) {var objs = xDOM(objectID,1); objs.left = x; objs.top = y;}
function pageWidth() {return window.innerWidth != null? window.innerWidth: document.body != null? document.body.clientWidth:null;}
function pageHeight() {return window.innerHeight != null? window.innerHeight: document.body != null? document.body.clientHeight:null;}
function posLeft() {return typeof window.pageXOffset != \'undefined\' ? window.pageXOffset: document.documentElement.scrollLeft?
 document.documentElement.scrollLeft: document.body.scrollLeft? document.body.scrollLeft:0;}

function posTop() {return typeof window.pageYOffset != \'undefined\' ? window.pageYOffset: document.documentElement.scrollTop?
 document.documentElement.scrollTop: document.body.scrollTop? document.body.scrollTop:0;}

var xxx = 0; var yyy = 0; var dist = distX = distY = 0; var stepx = '.$IndexSlideSpeed.'; var stepy = 0; var mn = \'smenu\';

function disableSlide() {setObjVis(mn,\'hidden\');}
function enableSlide() {setObjVis(mn,\'visible\');}
function distance(s,e) {return Math.abs(s-e)}
function direction(s,e) {return s>e?-1:1}
function rate(a,b) {return a<b?a/b:1}
function setHeight() {var objs = xDOM(mn,1); var h = ClientSize(\'h\'); objs.height = h*0.95 +\'px\';}
function start() {setHeight(); xxx = -'.$IndexStart.'; yyy = 0; var eX = 0; var eY = 100; dist = distX = distance(xxx,eX); distY = distance(yyy,eY); stepx *=
-direction(xxx,eX) * rate(distX,distY); stepy *= direction(yyy,eY) * rate(distY,distX); moveit(); setObjVis(mn,\'visible\');}

function moveit() {var x = (posLeft()+xxx) + \'px\'; var y = posTop() + \'px\'; moveObjTo(mn,x,y);}
function mover() {if (dist > 0) {xxx += stepx; yyy += stepy; dist -= Math.abs(stepx);} moveit(); setTimeout(\'mover()\',speed);}
function slide() {dist = distX; stepx = -stepx; moveit(); setTimeout(\'mover()\',speed*2);return false;}

onload = start;
window.onscroll = moveit;
// -->
</script>
' if (! $mobile);
# END JavaScript for alphabetic IndexMenu

#start JavaScript for HintBox
$JavaScript .= '
<script type="text/javascript">

/***********************************************
* Show Hint script- (c) Dynamic Drive (www.dynamicdrive.com)
* This notice MUST stay intact for legal use
* Visit http://www.dynamicdrive.com/ for this script and 100s more.
*
* implemented in ASSP by Thomas Eckardt
***********************************************/

var horizontal_offset="0px" //horizontal offset of hint box from anchor link

/////No further editting needed

var vertical_offset="20px" //vertical offset of hint box from anchor link. No need to change.
var ie=document.all
var ns6=document.getElementById&&!document.all

function getposOffset(what, offsettype){
    var totaloffset=(offsettype=="left")? what.offsetLeft : what.offsetTop;
    var parentEl=what.offsetParent;
    while (parentEl!=null){
        totaloffset=(offsettype=="left")? totaloffset+parentEl.offsetLeft : totaloffset+parentEl.offsetTop;
        parentEl=parentEl.offsetParent;
    }
    return totaloffset;
}

function iecompattest(){
    return (document.compatMode && document.compatMode!="BackCompat")? document.documentElement : document.body
}

function clearbrowseredge(obj, whichedge, where){
    var edgeoffset=(whichedge=="rightedge")? (parseInt(horizontal_offset)-obj.offsetWidth*where/2)*-1 : parseInt(vertical_offset)*-1;
    if (whichedge=="rightedge"){
        var windowedge=ie && !window.opera? iecompattest().scrollLeft+iecompattest().clientWidth-90 : window.pageXOffset+window.innerWidth-100;
        dropmenuobj.contentmeasure=dropmenuobj.offsetWidth;
        if (windowedge-dropmenuobj.x < dropmenuobj.contentmeasure)
            edgeoffset=dropmenuobj.contentmeasure+obj.offsetWidth/(where+1)+parseInt(horizontal_offset);
    } else {
        var windowedge=ie && !window.opera? iecompattest().scrollTop+iecompattest().clientHeight-15 : window.pageYOffset+window.innerHeight-18
        dropmenuobj.contentmeasure=dropmenuobj.offsetHeight
        if (windowedge-dropmenuobj.y < dropmenuobj.contentmeasure)
            edgeoffset=dropmenuobj.contentmeasure-obj.offsetHeight+parseInt(vertical_offset)
    }
    return edgeoffset
}

function showhint(menucontents, obj, e, tipwidth, currLoc){
    if (document.getElementById("hintbox")){
        dropmenuobj=document.getElementById("hintbox")
        dropmenuobj.innerHTML=menucontents
        dropmenuobj.style.left=dropmenuobj.style.top=-500
        if (tipwidth!=""){
            dropmenuobj.widthobj=dropmenuobj.style
            dropmenuobj.widthobj.width=tipwidth
        }
        dropmenuobj.x=getposOffset(obj, "left")
        dropmenuobj.y=getposOffset(obj, "top");
        if (currLoc != "" && (ie||ns6)) {
            //var postop = ns6 ? 0 : posTop();
            var postop = 0;
            var objTop = yMousePos+postop+parseInt(vertical_offset);
            var Yedge=ie && !window.opera? iecompattest().scrollTop+iecompattest().clientHeight-15 : window.pageYOffset+window.innerHeight-18;
            if (dropmenuobj.offsetHeight + objTop > Yedge) {
                dropmenuobj.style.top=objTop-dropmenuobj.offsetHeight+"px";
            } else {
                dropmenuobj.style.top=objTop+"px";
            }
        } else {
            dropmenuobj.style.top=dropmenuobj.y-clearbrowseredge(obj, "bottomedge", 0)+"px";
        }
        if (currLoc != "") {
            dropmenuobj.style.left=dropmenuobj.x-clearbrowseredge(obj, "rightedge", 0)+obj.offsetWidth+"px";
        } else {
            dropmenuobj.style.left=dropmenuobj.x-clearbrowseredge(obj, "rightedge", 1)+obj.offsetWidth+"px";
        }
        if (currLoc == 2 && parseInt(dropmenuobj.style.top) < 80) {dropmenuobj.style.top="80px";}
        //alert("x="+dropmenuobj.x+" , cb="+clearbrowseredge(obj, \'rightedge\')+" , offset="+obj.offsetWidth);
        //alert("y="+dropmenuobj.y+" , cb="+clearbrowseredge(obj, \'bottomedge\')+" , offset="+obj.offsetHeight);
        //alert("top="+dropmenuobj.style.top);
        //dropmenuobj.style.left=xMousePos+"px";
        dropmenuobj.style.visibility="visible";
        if (currLoc != 2) {obj.onmouseout=hidetip;}
    }
}

function hidetip(e){
    dropmenuobj.style.visibility="hidden";
    dropmenuobj.style.left="-500px";
}

function createhintbox(){
    var divblock=document.createElement("div");
    divblock.setAttribute("id", "hintbox");
    document.body.appendChild(divblock);
}

// *** this is moved into kudos and externalLinks() ***
// if (window.addEventListener)
//     window.addEventListener("load", createhintbox, false)
// else if (window.attachEvent)
//     window.attachEvent("onload", createhintbox)
// else if (document.getElementById)
//     window.onload=createhintbox

// Set Netscape up to run the "captureMousePosition" function whenever
// the mouse is moved. For Internet Explorer and Netscape 6, you can capture
// the movement a little easier.
if (document.layers) { // Netscape
    document.captureEvents(Event.MOUSEMOVE);
    document.onmousemove = captureMousePosition;
} else if (document.all) { // Internet Explorer
    document.onmousemove = captureMousePosition;
} else if (document.getElementById) { // Netcsape 6
    document.onmousemove = captureMousePosition;
}

// Global variables
xMousePos = 0; // Horizontal position of the mouse on the screen
yMousePos = 0; // Vertical position of the mouse on the screen
xMousePosMax = 0; // Width of the page
yMousePosMax = 0; // Height of the page

function captureMousePosition(e) {
    if (document.layers) {
        // When the page scrolls in Netscape, the event\'s mouse position
        // reflects the absolute position on the screen. innerHight/Width
        // is the position from the top/left of the screen that the user is
        // looking at. pageX/YOffset is the amount that the user has
        // scrolled into the page. So the values will be in relation to
        // each other as the total offsets into the page, no matter if
        // the user has scrolled or not.
        xMousePos = e.pageX;
        yMousePos = e.pageY;
        xMousePosMax = window.innerWidth+window.pageXOffset;
        yMousePosMax = window.innerHeight+window.pageYOffset;
    } else if (document.all) {
        // When the page scrolls in IE, the event\'s mouse position
        // reflects the position from the top/left of the screen the
        // user is looking at. scrollLeft/Top is the amount the user
        // has scrolled into the page. clientWidth/Height is the height/
        // width of the current page the user is looking at. So, to be
        // consistent with Netscape (above), add the scroll offsets to
        // both so we end up with an absolute value on the page, no
        // matter if the user has scrolled or not.

        if (window.event) {
            xMousePos = window.event.x+document.body.scrollLeft;
            yMousePos = window.event.y+document.body.scrollTop;
        } else {
            if 