#!/bin/bash

#--------------------------------------
# Synametrics Software
# Copyright (C) 2003-2010 Synametrics Technologies, Inc.
# All Rights Reserved.
# This script installs XEAMS.
# - First login as root
# - Execute script using "./Install.sh"
#--------------------------------------

# global variables
APP_NAME="Xeams"
SHORTNAME="xeams"
DEFAULT_HOME="/opt/"
DEFAULT_DIR="$APP_NAME"
INNER_TAR_NAME="Xeams.tar"
SM_TAR_NAME="$INNER_TAR_NAME.gz"
SRV_DIR_MADLINUX="/etc/init.d/"
FEDORA_SUSE_RUN_SCRIPT="synafed.sh"
# PIDDIR="/var/run/Xeams"
# PIDEXT=".pid"
APPFULL="Xeams SMTP Server and Spam Filter"



echo "[.] Installing $APP_NAME. "

#1 user must be root
if [ $USER != "root" ]
then
	echo "[*] You must login as root, Installation... [FAILED]"
	exit 1
fi

cp $SM_TAR_NAME tmp$SM_TAR_NAME

#2 tar exist or not
if [ ! -f $SM_TAR_NAME ]
then
	echo "[*] $SM_TAR_NAME not found with package, Installation... [FAILED]"
	exit 1
fi

#3 install where
echo "[.] Please specify, installation directory or leave blank for default"
echo -n "    Please enter (e.g. /opt/): "
read INSTALL_WHERE

if [ -z $INSTALL_WHERE ]
then	
	INSTALL_WHERE=$DEFAULT_HOME
fi

echo "[.] Installation directory = $INSTALL_WHERE"



echo -n "[.] Unzipping $SM_TAR_NAME file... "
gzip -df9 $SM_TAR_NAME

if [ $? -eq 1 ]
then  
	echo "[FAILED]"
	exit 1
else 
	echo "[OK]"
fi

mv tmp$SM_TAR_NAME $SM_TAR_NAME

# create folder if not exist
if [ ! -d $INSTALL_WHERE$DEFAULT_DIR ]
then
	echo "[.] Creating $INSTALL_WHERE$DEFAULT_DIR folder..."
	mkdir -pv $INSTALL_WHERE$DEFAULT_DIR
	#mkdir $PIDDIR
fi

echo -n "[.] Extracting $INNER_TAR_NAME file..."
tar -xf $INNER_TAR_NAME -C $INSTALL_WHERE$DEFAULT_DIR
#tar -xf $INNER_TAR_NAME -C $INSTALL_WHERE 

if [ $? -eq 1 ]
then  
	echo "[FAILED]"
	exit 1
else 
	echo "[OK]"
fi

# set full rights for Root
chmod -R u+wrx $INSTALL_WHERE$DEFAULT_DIR
# chmod -R u+wrx $PIDDIR
rm -rf $INNER_TAR_NAME

echo "[.] Configuring Startup Script..."


# create init.d directory if folder does not exist.


if [[ ! -e /etc/init.d/ ]]; then
        mkdir -p /etc/init.d/
        echo "Created init.d directory."
else
        echo "Init.d directory already exists, no need to create it."

fi



# Write startup script to /etc/init.d

cat > /etc/init.d/$SHORTNAME <<FromHere
#!/bin/sh
#
# Skeleton sh script suitable for starting and stopping 
# wrapped Java apps on the Solaris platform. 
#
# Make sure that PIDFILE points to the correct location,
# if you have changed the default location set in the 
# wrapper configuration file.
#

# Activates on boot: although these are comments, they are used by chkconfig
# command and must be present. This particular line defines that on 
# runlevels 2,3,4 and 5, this subsystem will be activated with priority 95 
# (one of the lasts), and deactivated with priority 05 (one of the firsts).

# chkconfig: 2345 95 09
### BEGIN INIT INFO
# Provides:			$APP_NAME
# Required-Start:		\$network
# Required-Stop:	
# Default-Start:		2 3 4 5
# Default-Stop:			0 1 6
# Short-Description:		$APPFULL 
# Description:			Starts $APPFULL
### END INIT INFO

#-----------------------------------------------------------------------------
# These settings can be modified to fit the needs of your application



# Application
APP_NAME=$APP_NAME
APP_LONG_NAME="$APPFULL"



# Priority at which to run the wrapper.  See "man nice" for valid priorities.
#  nice is only used if a priority is specified.
PRIORITY=

# Location of the pid file.
# PIDDIR="/var/run/$APP_NAME"

# Do not modify anything beyond this point
#-----------------------------------------------------------------------------

# Get the fully qualified path to the script
case \$0 in
    /*)
        SCRIPT="\$0"
        ;;
    *)
        PWD=\`pwd\`
        SCRIPT="\$PWD/\$0"
        ;;
esac

# Change spaces to ":" so the tokens can be parsed.
SCRIPT=\`echo \$SCRIPT | sed -e 's; ;:;g'\`
# Get the real path to this script, resolving any symbolic links
TOKENS=\`echo \$SCRIPT | sed -e 's;/; ;g'\`
REALPATH=
for C in \$TOKENS; do
    REALPATH="\$REALPATH/\$C"
    while [ -h "\$REALPATH" ] ; do
        LS="\`ls -ld "\$REALPATH"\`"
        LINK="\`expr "\$LS" : '.*-> \(.*\)\$'\`"
        if expr "\$LINK" : '/.*' > /dev/null; then
            REALPATH="\$LINK"
        else
            REALPATH="\`dirname "\$REALPATH"\`""/\$LINK"
        fi
    done
done
# Change ":" chars back to spaces.
REALPATH=\`echo \$REALPATH | sed -e 's;:; ;g'\`

# Change the current directory to the location of the script
cd "\`dirname "\$REALPATH"\`"

# Process ID
#PIDFILE="\$PIDDIR/\$APP_NAME.pid"
pid=""

# Resolve the location of the 'ps' command
PSEXE="/usr/bin/ps"
if [ ! -x \$PSEXE ]
then
 PSEXE="/bin/ps"
    if [ ! -x \$PSEXE ]
    then
        echo "Unable to locate 'ps'."
        echo "Please report this with the location on your system."
        exit 1
    fi
fi

# Build the nice clause
if [ "X\$PRIORITY" = "X" ]
then
    CMDNICE=""
else
    CMDNICE="nice -\$PRIORITY"
fi

getpidx() {

if [ -f \$PIDFILE ]
    then
        if [ -r \$PIDFILE ]
        then
            pid=\`cat \$PIDFILE\`
            if [ "X\$pid" != "X" ]
            then
                # Verify that a process with this pid is still running.
                pid=\`\$PSEXE -p \$pid | grep \$pid | grep -v grep | awk '{print \$1}' | tail -1\`
                if [ "X\$pid" = "X" ]
                then
                    # This is a stale pid file.
                    rm -f \$PIDFILE
                    echo "Removed stale pid file: \$PIDFILE"
                fi
            fi
        else
            echo "Cannot read \$PIDFILE."
            exit 1
        fi
    fi
}

getpid() {

  pid=\`\$PSEXE aux | grep -i Xeams.jar | grep -v grep | awk '{print \$2}'\`

}

testpid() {
    pid=\`\$PSEXE -p \$pid | grep \$pid | grep -v grep | awk '{print \$1}' | tail -1\`
   
# if [ "X\$pid" = "X" ]
 #   then
        # Process is gone so remove the pid file.
        #rm -f \$PIDFILE
  #  fi
}

 
start() {
    echo "Starting \$APP_LONG_NAME..."
    getpid 
    if [ "X\$pid" = "X" ]
    then
        #added 26-11-2004: for increasing ULIMIT options
	ulimit -n 8192
	#NEW CALL TO RUN.SH
	cd $INSTALL_WHERE$DEFAULT_DIR
	#if [ ! -d "/var/run/$APP_NAME" ]
	#then
	# mkdir /var/run/$APP_NAME
	# fi
	./run.sh
	# sleep 3
	# Create the pidfile with the process ID
	#	 \$PSEXE aux | grep -i Xeams.jar | grep -v grep | awk '{print \$2}' > \$PIDFILE
		
	

	cd /etc/init.d	


    else
        echo "\$APP_LONG_NAME is already running."
        exit 1
    fi
}
 
stopit() {
    echo "Stopping \$APP_LONG_NAME..."
	getpid
    if [ "X\$pid" = "X" ]
    then
        echo "\$APP_LONG_NAME was not running."
    else
         # Running so try to stop it.
        kill \$pid
        if [ \$? -ne 0 ]
        then
            # An explanation for the failure should have been given
            echo "Unable to stop \$APP_LONG_NAME."
            exit 1
        fi

        # We can not predict how long it will take for the wrapper to
        #  actually stop as it depends on settings in wrapper.conf.
        #  Loop until it does.
        savepid=\$pid
        CNT=0
        TOTCNT=0
        while [ "X\$pid" != "X" ]
        do
            # Loop for up to 5 minutes
            if [ "\$TOTCNT" -lt "300" ]
            then
                if [ "\$CNT" -lt "5" ]
                then
                    CNT=\`expr \$CNT + 1\`
                else
                    echo "Waiting for \$APP_LONG_NAME to exit..."
                    CNT=0
                fi
                TOTCNT=\`expr \$TOTCNT + 1\`

                sleep 1

                testpid
            else
                pid=
            fi
        done

        pid=\$savepid
        testpid
        if [ "X\$pid" != "X" ]
        then
            echo "Timed out waiting for \$APP_LONG_NAME to exit."
            echo "  Attempting a forced exit..."
            kill -9 \$pid
        fi

        pid=\$savepid
        testpid
        if [ "X\$pid" != "X" ]
        then
            echo "Failed to stop \$APP_LONG_NAME."
            exit 1
        else
            echo "Stopped \$APP_LONG_NAME."
        fi
    fi
}

status() {
    getpid
    if [ "X\$pid" = "X" ]
    then
        echo "\$APP_LONG_NAME is not running."
        exit 1
    else
        echo "\$APP_LONG_NAME is running (\$pid)."
        exit 0
    fi
}

dump() {
    echo "Dumping \$APP_LONG_NAME..."
    getpid
    if [ "X\$pid" = "X" ]
    then
        echo "\$APP_LONG_NAME was not running."

    else
        kill -3 \$pid
		
        if [ \$? -ne 0 ]
        then
            echo "Failed to dump \$APP_LONG_NAME."
            exit 1
        else
            echo "Dumped \$APP_LONG_NAME."
        fi
    fi
}

case "\$1" in

    'console')
        console
        ;;

    'start')
        start
        ;;

    'stop')
        stopit
        ;;
		
    'restart')
        stopit
        start
        ;;

    'status')
        status
        ;;

    'dump')
        dump
        ;;

    *)
	echo "Usage: \$0 { console | start | stop | restart | status | dump }"
        exit 1
        ;;
esac

exit 0


FromHere


chmod 755 /etc/init.d/$SHORTNAME

if [ $? -eq 1 ]
then  
	echo "[FAILED]"
	exit 1
else 
	echo "[OK]"
fi


echo  "[.] Getting Operating System Info:"

currOS="lsb_release"
osOutput=""

if [[ ! -x $currOS ]]
then
 currOS="/usr/sbin/lsb_release"
fi
 
if [[ ! -x $currOS ]]
    then
    	 currOS="/usr/bin/lsb_release"
fi

    	 
if [[ ! -x $currOS ]]
        then
         currOS="/bin/lsb_release"
fi

         
if [[ ! -x $currOS ]]
 			then       
         
        		
 					currOS=$( ls /etc/*-release) 
 					

if [ ! -z "$currOS" ]
then
        			currOS="cat /etc/*-release"
osOutput=$( $currOS) 
fi
fi


if [ -z "$osOutput" ] && [ "$currOS" != *_* ]
then
echo -n "Checking Available LSB Modules..."
osOutput=$( $currOS -a) 


fi
  				    		     



if [ "$currOS" == "cat /etc/*-release" ] && [ ! -z "$currOS" ]
then
osOutput=$( $currOS) 

if [ -z "$osOutput" ]
then
echo "[FAILED]"
echo "************ WARNING: $APP_NAME could not be configured for startup because no startup program was found   ************"
fi
else

if [ -z "$osOutput" ]
then
echo "[FAILED]"
echo "**************** WARNING: $APP_NAME could not be configured at boot because there is no startup program found *************"
fi

fi


echo "[.] Configuring $APP_NAME to start on boot..."

if [[ "$osOutput" == *Ubuntu* ||  "$osOutput" == *Debian* ]]
then

startupProg="update-rc.d"

if [ ! -x $startupProg ]
then
 startupProg="/usr/sbin/update-rc.d"
 
fi
   
   
if [ ! -x $startupProg ]
then
    startupProg="/usr/bin/update-rc.d"
fi
 
if [ ! -x $startupProg ]
then
    startupProg="/bin/update-rc.d"
         
fi

if [ ! -x $startupProg ]
then
    startupProg="/sbin/update-rc.d"
         
fi
 			
if [ ! -x $startupProg ]
then       
         
        echo "****** WARNING **********"
        echo "Path to startup program not found.  $APP_NAME will NOT start at system boot!"
        echo "Please report this with the location on your system."
          	
fi

if [ -x $startupProg ]
then
$startupProg $SHORTNAME defaults  
#$startupProg $SHORTNAME enable  
if [ $? -eq 1 ]
then  
	echo "[FAILED]"
	exit 1
else 
	echo "[OK]"
fi
fi

echo -n "[.] Starting $APP_NAME Server...."

if [ $? -eq 1 ]
then  
	echo "[FAILED]"
	exit 1
else 
	echo "[OK]"
fi

#Checks CentOS. If it is NOT chkconfig, then check for systemctl (for CENTOS 7 and so on)

elif [[ "$osOutput" == *CentOS* ]]
then
startupProg="chkconfig"

if [ ! -x $startupProg ]
then
 startupProg="/usr/sbin/chkconfig"

fi

if [ ! -x $startupProg ]
then
  startupProg="/usr/bin/chkconfig"
fi

if [ ! -x $startupProg ]
then
   startupProg="/bin/chkconfig"
fi

if [ ! -x $startupProg ]
then
   startupProg="/sbin/chkconfig"
fi

if [ ! -x $startupProg ]
then
   startupProg="systemctl"
fi

if [ ! -x $startupProg ]
then
 startupProg="/usr/sbin/systemctl"
fi

if [ ! -x $startupProg ]
then
  startupProg="/usr/bin/systemctl"
fi

if [ ! -x $startupProg ]
then
   startupProg="/bin/systemctl"
fi

if [ ! -x $startupProg ]
then
   startupProg="/sbin/systemctl"
fi

if [ ! -x $startupProg ]
then       
    echo "[Failed]"     
        echo "****** WARNING **********"
        echo "Path to startup program not found.  $APP_NAME will NOT start at system boot!"
        echo "Please report this with the location on your system."
        
        	
fi

if [ $startupProg == "/usr/sbin/chkconfig" ] || [ $startupProg == "/usr/bin/chkconfig" ] || [ $startupProg == "/bin/chkconfig" ] || [ $startupProg == "/sbin/chkconfig" ]
then
$startupProg --level 2345 $SHORTNAME on 

if [ $? -eq 1 ]
then  
	echo "[FAILED]"
	exit 1
else 
	echo "[OK]"
fi
fi

if [ $startupProg == "systemctl" ] || [ $startupProg == "/usr/sbin/systemctl" ] || [ $startupProg == "/usr/bin/systemctl" ] || [ $startupProg == "/bin/systemctl" ] || [ $startupProg == "/sbin/systemctl" ]

then echo "Systemctl is in use. Will refer to systemd script to start on boot."

if [ $? -eq 1 ]
then  
	echo "[FAILED]"
	exit 1
else 
	echo "[OK]"
fi
fi

#below is commented out, check line #717
#
#echo -n  "[.] Starting $APP_NAME Server..."
#/etc/init.d/$SHORTNAME start 
#
#if [ $? -eq 1 ]
#then  
#	echo "[FAILED]"
#	exit 1
#else 
#	echo "[OK]"
#fi


elif [[ "$osOutput" == *Fedora* ]]
then
cat > /etc/systemd/system/$SHORTNAME.service <<FromHere
[Unit]
Description=$APPFULL
Requires=network.target
After=network.target

[Service] 
Type=forking
RemainAfterExit=yes
WorkingDirectory=$INSTALL_WHERE$DEFAULT_DIR
ExecStart=/etc/init.d/$SHORTNAME start
ExecStop=/etc/init.d/$SHORTNAME stop



[Install]
WantedBy=multi-user.target

FromHere





chmod +x $INSTALL_WHERE$DEFAULT_DIR/synafed.sh
systemctl enable $SHORTNAME.service
systemctl daemon-reload
echo "[.] Starting $APP_NAME Server..."
systemctl start $SHORTNAME.service

if [ $? -eq 1 ]
then  
	echo "[FAILED]"
	exit 1
else 
	echo "[OK]"
fi


elif [[ "$osOutput" == *openSUSE* ]]
then

mkdir $INSTALL_WHERE$DEFAULT_DIR/opensusescript

mv /etc/init.d/$SHORTNAME $INSTALL_WHERE$DEFAULT_DIR/opensusescript

cat > /etc/systemd/system/$SHORTNAME.service <<FromHere
[Unit]
Description=$APPFULL
Requires=network.target
After=network.target

[Service] 
Type=forking
RemainAfterExit=yes
WorkingDirectory=$INSTALL_WHERE$DEFAULT_DIR
ExecStart=$INSTALL_WHERE$DEFAULT_DIR/opensusescript/xeams start
ExecStop=$INSTALL_WHERE$DEFAULT_DIR/opensusescript/xeams stop



[Install]
WantedBy=multi-user.target

FromHere





chmod +x $INSTALL_WHERE$DEFAULT_DIR/synafed.sh
systemctl enable $SHORTNAME.service
systemctl daemon-reload
echo "[.] Starting $APP_NAME Server..."
systemctl start $SHORTNAME.service

if [ $? -eq 1 ]
then  
	echo "[FAILED]"
	exit 1
else 
	echo "[OK]"
fi


fi

# adding xeams.service if systemd is used


echo "[.] Checking if systemd is used..."

result=$(ps --no-headers -o comm 1)
if [[ $result == "systemd" ]] && [[ "$osOutput" != *openSUSE* ]]; then
        echo "[.] Adding xeams service to systemd..."
		
# remove existing xeams.service in systemctl
		systemctl stop $SHORTNAME.service > /dev/null 2>&1
		systemctl disable $SHORTNAME.service > /dev/null 2>&1
		systemctl daemon-reload > /dev/null 2>&1
		systemctl reset-failed > /dev/null 2>&1
cat > /etc/systemd/system/$SHORTNAME.service <<FromHere
[Unit]
Description=Xeams Spam Filtering Server
Requires=network.target
After=network.target

[Service]
Type=forking
RemainAfterExit=yes
WorkingDirectory=$INSTALL_WHERE$DEFAULT_DIR
ExecStart=/etc/init.d/$SHORTNAME start
ExecStop=/etc/init.d/$SHORTNAME stop

[Install]
WantedBy=multi-user.target

FromHere

    systemctl enable $SHORTNAME.service
	systemctl daemon-reload
	systemctl start $SHORTNAME.service
/etc/init.d/$SHORTNAME start
        echo "[.] Added xeams to systemd."

else
        echo "[.] Operating system is not using systemd, or it is openSUSE"
		 
		
if [ $? -eq 1 ]
then  
	echo "[FAILED]"
	exit 1
else 
	echo "[OK]"
fi


fi


# create uninstall script


echo -n "[.] Configuring Uninstall script..."

cat > $INSTALL_WHERE$DEFAULT_DIR/Uninstall.sh <<FromHere
#!/bin/bash
result=$(ps --no-headers -o comm 1)
#This Script removes $APP_NAME

#1 user must be root
if [ \$USER != "root" ]
then
	echo "[*] You must login as root, Uninstall... [FAILED]"
	exit 1
fi

echo "[.] Stopping $APP_NAME..."
/etc/init.d/$SHORTNAME stop

if [ \$? -eq 1 ]
then  
	echo "[FAILED]"
	exit 1
else 
	echo "[OK]"
fi

currOS="lsb_release"
osOutput=""

if [[ ! -x "\$currOS" ]]
then
 currOS="/usr/sbin/lsb_release"
fi
 
if [[ ! -x "\$currOS" ]]
    then
    	 currOS="/usr/bin/lsb_release"
fi

    	 
if [[ ! -x "\$currOS" ]]
        then
         currOS="/bin/lsb_release"
fi

         
if [[ ! -x "\$currOS" ]]
 			then       
         
        		
 					currOS=\$( ls /etc/*-release)
 					

if [ ! -z "\$currOS" ]
then
        			currOS="cat /etc/*-release"
osOutput=\$( \$currOS)
fi
fi


if [ -z "\$osOutput" ] && [ "\$currOS" != *_* ]
then

osOutput=\$( \$currOS -a)


fi




if [[ "\$osOutput" == *Ubuntu* ||  "\$osOutput" == *Debian* ]]
then

startupProg="update-rc.d"

if [ ! -x \$startupProg ]
then
 startupProg="/usr/sbin/update-rc.d"
 
fi
   
   
if [ ! -x \$startupProg ]
then
    startupProg="/usr/bin/update-rc.d"
fi
 
if [ ! -x \$startupProg ]
then
    startupProg="/bin/update-rc.d"
         
fi

if [ ! -x \$startupProg ]
then
    startupProg="/sbin/update-rc.d"
         
fi
 			
if [ ! -x \$startupProg ]
then       
         
        echo "****** WARNING **********"
        echo "Path to startup program not found.  $APP_NAME will NOT start at system boot!"
        echo "Please report this with the location on your system."
        exit 1     	
fi



echo "Removing Installed $APP_NAME Files..."
rm -rf /etc/init.d/$SHORTNAME

if [ -x \$startupProg ]
then
\$startupProg $SHORTNAME remove 
fi


# rm -rf /var/run/$APP_NAME
rm -rf $INSTALL_WHERE$DEFAULT_DIR


elif [[ "\$osOutput" == *CentOS* ]]
then
startupProg="chkconfig"

if [ ! -x \$startupProg ]
then
 startupProg="/usr/sbin/chkconfig"

fi

if [ ! -x \$startupProg ]
then
  startupProg="/usr/bin/chkconfig"
fi

if [ ! -x \$startupProg ]
then
   startupProg="/bin/chkconfig"
fi

if [ ! -x \$startupProg ]
then
   startupProg="/sbin/chkconfig"
fi

if [ ! -x \$startupProg ]
then
   startupProg="systemctl"
fi

if [ ! -x \$startupProg ]
then
 startupProg="/usr/sbin/systemctl"
fi

if [ ! -x \$startupProg ]
then
  startupProg="/usr/bin/systemctl"
fi

if [ ! -x \$startupProg ]
then
   startupProg="/bin/systemctl"
fi

if [ ! -x \$startupProg ]
then
   startupProg="/sbin/systemctl"
fi

if [ ! -x \$startupProg ]
then       
         
        echo "****** WARNING **********"
        echo "Path to startup program not found.  $APP_NAME will NOT start at system boot!"
        echo "Please report this with the location on your system."
        exit 1
        	
fi


if [ $startupProg == "/usr/sbin/chkconfig" ] || [ $startupProg == "/usr/bin/chkconfig" ] || [ $startupProg == "/bin/chkconfig" ] || [ $startupProg == "/sbin/chkconfig" ]
then
\$startupProg --del $SHORTNAME 
fi

if [ $startupProg == "systemctl" ] || [ $startupProg == "/usr/sbin/systemctl" ] || [ $startupProg == "/usr/bin/systemctl" ] || [ $startupProg == "/bin/systemctl" ] || [ $startupProg == "/sbin/systemctl" ]

then echo "Systemctl is in use. Will remove systemd script through systemctl."

echo "Removing Installed $APP_NAME Files..."
rm -rf /etc/init.d/$SHORTNAME
# rm -rf /var/run/$APP_NAME
rm -rf $INSTALL_WHERE$DEFAULT_DIR

fi

elif [[ "\$osOutput" == *Fedora*  ||  "\$osOutput" == *openSUSE* ]]
then

startupProg="systemctl";

if [ ! -x \$startupProg ]
then
 startupProg="/usr/sbin/systemctl"
fi

if [ ! -x \$startupProg ]
then
startupProg="/usr/bin/systemctl"
    	
fi

if [ ! -x \$startupProg ]
then
   startupProg="/bin/systemctl";
fi
 			
if [ ! -x \$startupProg ]
then       
         
        echo "****** WARNING **********"
        echo "Path to startup program not found.  $APP_NAME will NOT start at system boot!"
        echo "Please report this with the location on your system."
        exit 1
        	
     
fi

echo "Removing Installed $APP_NAME Files..."
rm -rf /etc/init.d/$SHORTNAME
# rm -rf /var/run/$APP_NAME
rm -rf $INSTALL_WHERE$DEFAULT_DIR
rm -rf /etc/systemd/system/$SHORTNAME.service
systemctl daemon-reload
systemctl reset-failed

else

rm -rf /etc/init.d/$SHORTNAME
# rm -rf /var/run/$APP_NAME
rm -rf $INSTALL_WHERE$DEFAULT_DIR


fi



# checks if systemd is used before removing xeams.service files.

if [ $result == "systemd" ]; then
        echo "Removing xeams.service in systemd..."
		systemctl stop xeams.service
		systemctl disable xeams.service
		rm -rf /etc/systemd/system/xeams.service
		systemctl daemon-reload
		systemctl reset-failed

else
		echo "No service found in systemd. Skipping this step..."


fi

exit 0

FromHere

if [ $? -eq 1 ]
then  
	echo "[FAILED]"
	exit 1
else 
	echo "[OK]"
fi


exit 0






