
<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Access Control</h1>
<br>


<div class="well">
You can restrict access to the <b>admin</b> account by specifying a list of IP addresses. When no IP addresses
are specified, Xeams will allow administrators to connect from any IP address.
				
</div>
				
<div class="row">
	<div class="col-md-6">
		<!-- ******* Create Window Panel ******* -->
		
				
				
				<div class="well-info-wrap">
					<div class="well-info-header"><span class="glyphicon glyphicon-plus"></span>Add New IP</div>
					<div class="well-info-body no-padding" style="padding-bottom:10px;">
						<div class="well-info-additional">
							<ul class="text-left">
							<u>Examples</u>:
							<li>192.168.1.10  &nbsp;&nbsp;&nbsp;(Adds one IP)</li>
							<li>192.168.1.0/24  &nbsp;&nbsp;&nbsp;&nbsp;(Use CIDR format to specify a range)</li>
							</ul>
						</div>
						
						<div style="padding:10px;">
							<form action="<%= request.getAttribute("appPath") %>" method="post">
								<span class="form-control form-left form-text pull-left wth-4">IP Address</span>
								<input class="form-control form-right pull-left wth-6" input type="text" name="ip">
							
								<button class="btn btn-sm btn-submit pull-right" style="margin-right:10px;" value="Add new address" type="submit">Submit</button>
								<input type="hidden" value="245" name="operation"/>
								<input type="hidden" value="a" name="st"/>
							</form>
						</div>
						<br style="clear:both;">
					</div>
				</div>
				
				
				
				
	</div>
	
	<div class="col-md-6">
		
		
		<%
		List<String> aclList = (List<String>) request.getAttribute("aclList");
		
		if(aclList == null || aclList.size() == 0){
			%>
			<div class="alert alert-success">
			Access to <b>admin</b> account is currently allowed from every IP
			</div>
			<%
		}else{
			%>
			<table class="table table-bordered">
				<tr>
					<th>Entered Value</th>
					<th>Staring IP</th>
					<th>Ending IP</th>
					<th>Action</th>
				</tr>
				
				<%
				for(String oneIP : aclList){
					
				%>
				<tr>
					<td><%= oneIP %></td>
					<td><%= ResourceBean.getStartingEndingIPFromRange(oneIP, true) %></td>
					<td><%= ResourceBean.getStartingEndingIPFromRange(oneIP, false) %></td>
					<td><a href="<%=response.encodeURL("FrontController?operation=245&ip=" + oneIP + "&st=r") %>" title="Click to remove <%= oneIP%> from this list">Remove</a></td>
				</tr>
				<%	
				}%>
			</table>
			<%
		}
		%>
		
	</div>
</div>








<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
