<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Attachment Conversion</h1>


<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-info text-center"><%=infoMsg %></div>
	<%
}


String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}


%>

<div class="row">
	<div class="col-md-6">
	
		<div class="well">
			<h2>What is Attachment Conversion</h2>
			<p>Opening attachments in emails coming in from the untrusted sources is risky. When this feature
			is enabled, Xeams will convert attachments into plain text files, and attach the textual version of the document
			along with the original file. This allows users to file contents before opening the actual file.
			</p>
			<p>The following file types are supported</p>
			<ul>
				<li>Microsoft Word (*.doc, *.docx, *.dot, *.dotx)</li>
				<li>Microsoft Excel (*.xls, *.xlsx, *.xlt, *.xltx)</li>
				<li>Microsoft Powerpoint (*.ppt, *.pptx) </li>
				<li>Microsoft Publisher (*.pub)</li>
				<li>Adobe Acrobat (*.pdf)</li>
				<li>Rich Text Format (*.rtf)</li>
				<li>HTML Files (*.htm, *.html)</li>
				<li>Compressed Files (*.zip, *.tar, *.jar, *.gz, *.7z, *.ar, *.arj)</li>
				<li>winmail.dat (MS Outlook Email Format)</li>
			</ul>
		</div>
		
	</div>
	
	<div class="col-md-6">
	
	
	<div class="well-info-wrap">
		<div class="well-info-header">Configuration</div>
		<div class="well-info-body">
		
		
			<form action="<%= request.getAttribute("appPath") %>" method="post">
	
	
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('enabled')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Enabled</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1"><input id="chk-srv" type="checkbox" value="1" name="enabled" <%= request.getAttribute("enabled") %>  ><label for="chk-srv"></label></span>
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="enabled">
					If checked, this feature will be enabled and Xeams will convert attachments to text files.
				</div>
							
							
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('readme')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Include ReadMe.txt</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1"><input id="chk-srv2" type="checkbox" value="1" name="readme" <%= request.getAttribute("readme") %> ><label for="chk-srv2"></label></span>
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="readme">
					If checked, a ReadMe.txt file will be added containing helpful tips for the end-user.
				</div>
						
						
									
				<!-- ******* Create Text Input Field ******* -->
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('minScore')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Score Threshold</span>
				<input class="form-control form-right pull-left wth-5" type="number" name="minScore" value="<%= request.getAttribute("minScore") %>">
			
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="minScore">
					Attachments are converted if the score is higher than this value.
				</div>
			
			
			
				<br style="clear:both;">
				<!-- ******* Save Button | default is pulled right ******* -->
				<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
			
				<br><br>
				<input type="hidden" name="st" value="t">
				<input type="hidden" name="operation" value="atconv">
				
			</form>
		</div>
	</div>
	
	
	
		
	
	
	</div>
</div>










<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
