<%@page import="javax.mail.internet.MimeUtility"%>
<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>


<script type="text/javascript" src="<%= imagePath %>calendar.js"></SCRIPT>

<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Message Catalog</h1>

<%
String todayMinusThree = (String)request.getAttribute("TodayMinusThree");
String todaysDate = (String)request.getAttribute("TodaysDate");

if(todayMinusThree == null) todayMinusThree = "20180505";
if(todaysDate == null) todaysDate = "20180508";

%>
<div class="row">
	<div class="col-md-6">
		<div class="alert alert-success">
		Display a list of attachments for both inbound and outbound emails. 
		</div>
	
	</div>
	<div class="col-md-6">
		<!-- ******* Create Window Panel ******* -->
		<div class="well-info-wrap">
			<div class="well-info-header">Search Criteria</div>
			<div class="well-info-body">
				<form action="<%= request.getAttribute("appPath") %>" method="post">
					<div class="row">
						<div class="col-md-6 col-xs-12">
							<b>Message type:</b>
							<select class="form-control" name="msgType">
								<option value="-1">All Types
								<option value="0">Junk Messages
								<option value="2">Possible Junk Messages
								<option value="1">Good Messages
							</select>
						</div>
						
						<br class="hide_lg" style="clear:both;"><br class="hide_lg">
						<div class="col-md-6 col-xs-12">
							
							<b>Filter:</b>
							<input class="form-control" type="text" name="fileNameFilter" value="<%= request.getParameter("fileNameFilter") == null ? "" : request.getParameter("fileNameFilter") %>">
						</div>
					</div>
					
					
					<br style="clear:both;">
					<div class="row">
						<div class="col-md-6 col-xs-12">
							<b>Start date:</b>
							<script type="text/javascript">DateInput('startDate', true, 'YYYYMMDD', '<%=todayMinusThree%>')</script>
						</div>
						
						<br class="hide_lg" style="clear:both;"><br class="hide_lg">
						<div class="col-md-6 col-xs-12">
							<b>End date:</b>
							<script type="text/javascript">DateInput('endDate', true, 'YYYYMMDD', '<%=todaysDate%>')</script>
						</div>
					</div>
					
					<br style="clear:both;">
					<button class="btn btn-sm btn-submit pull-right" type="submit">Search</button>
					<input type="hidden" name="operation" value="249">
					<br style="clear:both;">	
				</form>
			</div>
		</div>
	</div>
</div>


<%
List<AttachmentLogHolder> resultList = (List<AttachmentLogHolder>) request.getAttribute("records");
if(resultList != null){
	
	%>
	<br><br>
	<div class="alert alert-warning">
		Displaying data <%= request.getAttribute("resultTitle") %>
	</div>
	<br><br>

	
	<div class="table-responsive">
	<table class="table table-condensed table-bordered table-hover">
	<thead>
		<tr>
			<th>File Name</th>
			<th>Sender</th>
			<th>Recipient(s)</th>
			<th>Action</th>
			
		
		</tr>
	</thead>
	<%
	
	String inboundArrow = "<span class=\"glyphicon glyphicon-arrow-right\" style=\"color:#f6383e;\" title=\"Inbound Email\"></span>";
	String outboundArrow = "<span class=\"glyphicon glyphicon-arrow-left\" style=\"color:#243724;\" title=\"Outbound Email\"></span>";
	
	for(AttachmentLogHolder oneRecord : resultList){
		String labelColor;
		if(oneRecord.getMsgType() == MaxEmailActions.GOOD){
			labelColor = "#326bac";
		}else if(oneRecord.getMsgType() == MaxEmailActions.SPAM){
			labelColor = "#aa3333";
		}else{
			labelColor = "#dcdcdc";
		}
	%>
		<tr>
			<td><%= oneRecord.getDirection() == 2 ? inboundArrow : outboundArrow %>
			    <%=oneRecord.getFileNameForWeb() %> <small><span style="color:<%=labelColor%> ">(<%=oneRecord.getFileSizeStr() %>)</span></small>
			    <span class="label label-default pull-right" style="background-color: <%= labelColor%>"><%=oneRecord.getMsgTypeStr() %></span>
			</td>
			<td><%=oneRecord.getSender() %></td>
			<td><%=oneRecord.getRecipient() %></td>
			<td><a href="<%=response.encodeURL("FrontController?operation=23&searchBy=lcid&txtSearchFor=" + 
					oneRecord.getLcid() + "&txtFileDate=" + oneRecord.getDateStr()) + "&msgType=" +
					oneRecord.getMsgTypeStr4Search()%>" 
				title="View Message"><i class="glyphicon glyphicon-search"></i></a></td>
			
			
			
		</tr>
	<%
	}
	%>
	</table>
	</div>
	<%
}
%>





<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
