<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>


<script type="text/javascript" src="<%= imagePath %>calendar.js"></SCRIPT>

<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Audit Logs</h1>

<a href="<%=response.encodeURL("FrontController?operation=60") %>">Home</a> &raquo;
<a href="<%=response.encodeURL("FrontController?operation=245") %>">Access Control</a>

<br><br>

<%
String todayMinusThree = (String)request.getAttribute("TodayMinusThree");
%>


<div class="row">
	<div class="col-md-6">
		<div class="well">
			<h4>Search Criteria</h4>
			<table class="table">
				<tr>
					<th>Login ID:</th><td><%= request.getAttribute("login") %></td>
				</tr>
				<tr>
					<th>Starting Date:</th><td><%= request.getAttribute("stDate") %></td>
				</tr>
				<tr>
					<th>Number of Days:</th><td><%= request.getAttribute("daysFor") %></td>
				</tr>
				<tr>
					<th>Operation Type:</th><td><%= request.getAttribute("opType") %></td>
				</tr>
			</table>
		</div>
	</div>
	<div class="col-md-6">
		<!-- ******* Create Window Panel ******* -->
		<div class="well-info-wrap">
			<div class="well-info-header">Search Criteria</div>
			<div class="well-info-body">
				<form action="<%= request.getAttribute("appPath") %>" method="post">
					<div class="row">
						<div class="col-md-6 col-xs-12">
							<b>Login ID:</b>
							<select class="form-control" name="u">
								<option value="">-- ALL --</option>
								<%
								List<String> adminNames = (List<String>) request.getAttribute("admins");
								for(String anAdmin : adminNames){
									%>
									<option value="<%= anAdmin%>"><%= anAdmin%></option>
									<%
								}
								%>
								
							</select>
						</div>
						
						<br class="hide_lg" style="clear:both;"><br class="hide_lg">
						<div class="col-md-6 col-xs-12">
							
							<b>Operation Type:</b>
							<select class="form-control" name="c">
								<option value="a">-- ALL --</option>
								<option value="c">Create</option>
								<option value="u">Update</option>
								<option value="d">Delete</option>
								<option value="r">Read</option>
								
							</select>
	
						</div>
					</div>
					
					
					<br style="clear:both;">
					<div class="row">
						<div class="col-md-6 col-xs-12">
							<b>Start date:</b>
							<script type="text/javascript">DateInput('startDate', true, 'YYYYMMDD', '<%=todayMinusThree%>')</script>
						</div>
						
						<br class="hide_lg" style="clear:both;"><br class="hide_lg">
						<div class="col-md-6 col-xs-12">
							<b>Number of days:</b>
							<input class="form-control" type="text" name="d" value="3">
						</div>
					</div>
					
					<br style="clear:both;">
					<button class="btn btn-sm btn-submit pull-right" type="submit">Search</button>
					<input type="hidden" name="operation" value="263">
					<br style="clear:both;">	
				</form>
			</div>
		</div>
		
	</div>
</div>

<br><br>

<%
List<AuditLogBean> records = (List<AuditLogBean>) request.getAttribute("records");
%>


<table class="table table-condensed table-hover table-bordered table-responsive">
	<thead style="background-color:#333333;color:#DFDFDF;">
	<tr>
		<th>Time</th>
		<th>User</th>
		<th>Operation</th>
		<th>Profile</th>
		<th>Source</th>
		<th>Field Name</th>
		<th>Old Value</th>
		<th>New Value</th>
	</tr>
	</thead>
	<%
	String iconCreate = "<i class='glyphicon glyphicon-plus-sign'> </i>";
	String iconDelete = "<i class='glyphicon glyphicon-minus-sign'> </i>";
	String iconUpdate = "<i class='glyphicon glyphicon-ok-sign'> </i>";
	String iconRead = "<i class='glyphicon glyphicon-info-sign'> </i>";
	String selectedIcon = iconUpdate;
	long lastGroup = -1;
	boolean displayCommon;
	String rowBkClass = "active";
	
	for(int i = records.size() - 1; i >= 0; i--){
		AuditLogBean aRecord = records.get(i);
		
		
		
		displayCommon = lastGroup != aRecord.groupID;
		lastGroup = aRecord.groupID;
		
		boolean forRead = false;
		String colSpan = "";
		if(aRecord.crud.equalsIgnoreCase("R")){
			forRead = true;
			colSpan = " colspan='4'";
		}
		
		if(displayCommon){
			if(aRecord.crud.equalsIgnoreCase("c")){
				selectedIcon = iconCreate;
				rowBkClass="warning";
			}else if(aRecord.crud.equalsIgnoreCase("d")){
				selectedIcon = iconDelete;
				rowBkClass="danger";
			}else if(aRecord.crud.equalsIgnoreCase("u")){
				selectedIcon = iconUpdate;
				rowBkClass="info";
			}else{
				selectedIcon = iconRead;
				rowBkClass="success";
			}
		}
		
		%>
		<tr class="<%= rowBkClass %>">
			<%
			if(displayCommon){
			%>
			<td><%= aRecord.getFormattedTime() %></td>
			<td><%= aRecord.user %></td>
			<td><%= selectedIcon%> <%= aRecord.getCrud() %></td>
			<td><%= aRecord.getProfileId() %></td>
			<td<%= colSpan %>><%= aRecord.getFormatedSource() %></td>
			<%}else{
				%>	
			<td></td>
			<td></td>
			<td></td>
			<td></td>
			<td></td>
				<%
			}%>
			
			<%if(!forRead){ %>
			<td><%= aRecord.fieldName %></td>
			<td><%= aRecord.getOldFormattedValue() %></td>
			<td><%= aRecord.getNewFormattedValue() %></td>
			<%} %>
		</tr>
		<%
	}
	%>
</table>




<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
