
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<%


String status = (String)request.getAttribute("Status");
String interestingWordCount = (String)request.getAttribute("InterestingWordCount");
String learningCurve = (String)request.getAttribute("LearningCurve");
String graduationCurve = (String)request.getAttribute("GraduationCurve");
String maxRepeat = (String)request.getAttribute("MaxRepeat");
String maxLength = (String)request.getAttribute("MaxLength");
String minLength = (String)request.getAttribute("MinLength");
String bayesianScore = (String)request.getAttribute("BayesianScore");
String totalSpamCorpus = (String)request.getAttribute("TotalSpamCorpus");
String totalHamCorpus = (String)request.getAttribute("TotalHamCorpus");
String totalSpamWord = (String)request.getAttribute("TotalSpamWord");
String totalHamWord = (String)request.getAttribute("TotalHamWord");


String learningSelected = "";
String disableSelected = "";
String enabledSelected = "";

if(status.equals("1")){
    learningSelected = " selected ";
}else if(status.equals("2")){
    disableSelected = " selected ";
}else{
    enabledSelected = " selected ";
}
%>

<h1>Bayesian Analysis</h1>

<br>
<div class="well-info-wrap">
	<div class="well-info-header">The Bayesian Filter</div>
	<div class="well-info-body">
		<p>
		The Bayesian filter is adaptive, meaning that over time it learns what you consider to be junk
		and what you consider to be valid E-Mail. This filter studies the emails that you have
		received in the past and, based on that, makes judgement about future emails.
		</p>

		<p>
		Initially, this filter watches all inbound and outbound messages and puts relevant information
		in its database that determine the "spaminess" of an email. Once this database grows to a sufficient
		size, <%= productName %> automatically changes the status of this filter to <b>Enabled</b>.
		</p>
	</div>
</div>

<br style="clear:both;">
<div class="row">
	<div class="col-md-8">
		<div class="well-info-wrap">
			<div class="well-info-header">Bayesian Configuration</div>
			<div class="well-info-body no-padding" style="padding-bottom:10px;">
				<div class="well-info-additional">
					Typically, you will not have to modify any settings except the <b>Bayesian Score</b>.
				</div>
				<form action="<%= request.getAttribute("appPath") %>" method="post">
				
				<div style="padding:10px;">
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('score')"><b>?</b></div>
					<span class="form-control form-middle pull-left form-text wth-5">Bayesian Score</span>
					<input class="form-control form-right pull-left text-center wth-4" name="BayesianScore" type="text" value="<%=bayesianScore%>">
						<br style="clear:both;">
						<div id="score" class="alert alert-info more_info">Score assigned to Bayesian Analysis. This is a two way score and therefore, will assign
						negative values for good emails and positive values for spam messages</div>


					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('status')"><b>?</b></div>
					<span class="form-control form-middle pull-left form-text wth-5">Status</span>
					<select class="form-control form-right pull-left text-center wth-4" name="Status">
					<option value="1" <%=learningSelected%> >Learning</option>
					<option value="3" <%=enabledSelected%>>Enabled</option>
					<option value="2" <%=disableSelected%>>Disabled</option>
					</select>
					
						<br style="clear:both;">
						<div id="status" class="more_info alert alert-info">Status will automatically change to enabled after <%= productName %> has analysed sufficient data</div>

					
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('wordCount')"><b>?</b></div>
					<span class="form-control form-middle pull-left form-text wth-5">Interesting word count</span>
					<input class="form-control form-right pull-left text-center wth-4" name="InterestingWordCount" type="text" value="<%=interestingWordCount%>" size="4"></td>
					
						<br style="clear:both;">
						<div id="wordCount" class="more_info alert alert-info">A Bayesian filter extracts a few words from every message for analysis.
						These words usually have a high probability of either being spammy or hammy. Do NOT change this value
						if you are not sure how bayesian works.
						</div>


					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('repeatCount')"><b>?</b></div>
					<span class="form-control form-middle pull-left form-text wth-5">Repeat Count</span>
					<input class="form-control form-right pull-left text-center wth-4" name="MaxRepeat" type="text" value="<%=maxRepeat%>"  size="4"></td>
					
						<br style="clear:both;">
						<div id="repeatCount" class="more_info alert alert-info">This variable defines the maximum number of times a
						word should be counted if it appears more than one in an email.
						</div>


					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('minLength')"><b>?</b></div>
					<span class="form-control form-middle pull-left form-text wth-5">Minimum Length</span>
					<input class="form-control form-right pull-left text-center wth-4" name="MinLength" type="text" value="<%=minLength%>" size="4"></td>
					
						<br style="clear:both;">
						<div id="minLength" class="more_info alert alert-info">Minimum length of words to be considered for analysis
						</div>


					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('maxLength')"><b>?</b></div>
					<span class="form-control form-middle pull-left form-text wth-5">Maximum Length</span>
					<input class="form-control form-right pull-left text-center wth-4" name="MaxLength" type="text" value="<%=maxLength%>" size="4"></td>
					
						<br style="clear:both;">
						<div id="maxLength" class="more_info alert alert-info">Maximum lenght of words to be considered for analysis
						</div>



					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('learnCurve')"><b>?</b></div>
					<span class="form-control form-middle pull-left form-text wth-5">Learning Curve</span>
					<input class="form-control form-right pull-left text-center wth-4" name="LearningCurve" type="text" value="<%=learningCurve%>" size="4"></td>
					
						<br style="clear:both;">
						<div id="learnCurve" class="more_info alert alert-info"><%= productName %> will analyse this many emails before automatically enabling
						Bayesian filtering.
						</div>


					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('gradCount')"><b>?</b></div>
					<span class="form-control form-middle pull-left form-text wth-5">Graduation Curve</span>
					<input class="form-control form-right pull-left text-center wth-4" name="GraduationCurve" type="text" value="<%=graduationCurve%>" size="4"></td>
					
						<br style="clear:both;">
						<div id="gradCount" class="more_info alert alert-info">Bayesian database will stop learning once this many emails have been analysed. Once
							this stage is reached the database will only change if a user explicitly marks an email good or spam.
						</div>
				</div>
				
				<br>
				<table class="table table-bordered table-striped table-hover">
				<tr>
				<td><b>Total spam messages analysed</b></td>
				<td><%=totalSpamCorpus%></td>
				<td>Number of spam messages analysed so far</td>
				</tr>




				<tr>
				<td><b>Total good messages analysed</b></td>
				<td><%=totalHamCorpus%></td>
				<td>Number of good messages analysed so far</td>
				</tr>




				<tr>
				<td><b>Total spam filters</b></td>
				<td><%=totalSpamWord%></td>
				<td>Number of filters currently considered for spam messages</td>
				</tr>



				<tr>
				<td><b>Total good filters</b></td>
				<td><%=totalHamWord%></td>
				<td>Number of filters currently considered for good messages</td>
				</tr>
				</table>
				
				<button alt="Submit Form" class="btn btn-sm btn-submit pull-right" style="margin-right:10px;" type="submit">Submit</button>
				<input class="form-control" type="hidden" name="operation" value="54">
				</form>
				<br style="clear:both;">
			</div>
		</div>
	</div>
	
	<br style="clear:both;" class="hide_lg">
	<div class="col-md-4">
		<div class="well-info-wrap">
			<div class="well-info-header">Shrink Bayesian Database</div>

			<div class="well-info-body">
				<p>
				The number of bayesian filters can grow to a large number over time. If you see too much
				memory being used by <%= productName %>, you might want to shrink the bayesian database. We recommend
				that you shrink this database if the number of filters go over 1,000,000.
				</p>

				<form action="<%= request.getAttribute("appPath") %>" method="GET">
				<input class="form-control" type="hidden" value="79" name="operation"/>
				<button class="btn btn-sm btn-menu pull-right" type="submit">Shrinking Wizard &nbsp; &raquo;</button>
				</form>
				<br style="clear:both;">
			</div>
		</div>
	</div>
</div>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
