<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<%
int[][] bayesianBottom = (int[][])request.getSession().getAttribute("BayesianBottom");

String autoShrinkEnabled = (String)request.getAttribute("AutoShrinkEnabled");
if(autoShrinkEnabled == null) autoShrinkEnabled = "";

String occurrenceCount = (String)request.getAttribute("AutoShrinkOccurrenceCount");
String bayesianWordCount = (String)request.getAttribute("AutoShrinkWordCount");
String totalWordsInBayesianDB = (String)request.getAttribute("TotalWordsInBayesianDB");

%>

<h1>Bayesian Database Analysis</h1>
<br>
<div class="well">
	The number of bayesian filters can grow to a large number over time. If you see too much
	memory being used by <%= productName %>, you might want to shrink the bayesian database. We recommend
	that you shrink this database if the number of filters go over 1,000,000.
</div>

<div class="row">
	<div class="col-md-6">
		<img alt="Bayesian Trimming Analysis" src="ImageController?operation=9" style="width:100%;">
	</div>
	
	<div class="col-md-6">
		<br><br>
		<div class="alert alert-info text-center">Currently there are <b><%=totalWordsInBayesianDB%></b> words in the Bayesian database.</div>
		
		<div class="well-info-wrap">
			<div class="well-info-header">What does this mean?</div>
			<div class="well-info-body">
				The graph shows the word distribution in the Bayesian database.
				<br><br>
				There are <%=bayesianBottom[0][1]%> words that occurred only once, 
				<%=bayesianBottom[1][1]%> words that occurred twice in the past and so on.
				The bayesian database can be trimmed by specifying the occurrence count. Therefore,
				if you specify the occurrence count to be 1, you will delete <%=bayesianBottom[0][1]%>
				words from the database.
				<br><br>
				Notice that if as the occurrence count increases the incremental difference in word count decrease. Therefore,
				you save most on memory where the occurrence count is less than 10.
			</div>
		</div>
	</div>

	<br style="clear:both;"><br>
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Shink Database</div>
			<div class="well-info-body no-padding" style="padding-bottom:10px;">
				<form action="<%= request.getAttribute("appPath") %>" method="post">
					<table class="table table-striped table-bordered">
						<tr>
							<td>Occurrence Count for Trimming:</td>
							<td><input class="form-control text-center" type="text" name="txtOC" value="5"></td>
						</tr>
					</table>
					<p style="padding:0px 10px;">The digit <b>"5"</b> means that every word that occurred less than or equal to 5 times in the past
						will get deleted. Many spammers use invalid words in their emails that do not repeat in other
						messages. Therefore, deleting words that seldom appear in emails shrinks the database with minimal
						change in the effectiveness of Bayesian filter.</p>
					
					<button type="submit" class="btn btn-sm btn-submit pull-right" style="margin-right:10px;">Submit</button>
					<input type="hidden" name="operation" value="95" />
				</form>
				<br style="clear:both;">
			</div>
		</div>
	</div>
	
	<br class="hide_lg">
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Auto Shrinking</div>
			<div class="well-info-body no-padding" style="padding-bottom:10px;">
				<form action="<%= request.getAttribute("appPath") %>" method="post">

				<table class="table table-striped table-bordered">
					<tr>
						<td><b>Enable Auto Shrink:</b></td>
						<td><span class="chkbox-cust form-control pull-left wth-3"><input id="chk-shrink" type="checkbox" name="chkEnableAutoShrink" <%=autoShrinkEnabled%> /><label for="chk-shrink"></label></span></td>
					</tr>

					<tr>
						<td><b>Shrink once word count reaches:</b></td>
						<td><input class="form-control" type="text" name="txtWordCount" value="<%=bayesianWordCount%>" /></td>
					</tr>

					<tr>
						<td><b>Delete words that appeared less than:</b></td>
						<td><input class="form-control" type="text" name="txtoccurrenceCount"  value="<%=occurrenceCount%>"/></td>
					</tr>

				</table>

				<button class="btn btn-sm btn-submit pull-right" style="margin-right:10px;" type="submit">Save</button>
				<input type="hidden" name="operation" value="96" />

				</form>
				<br style="clear:both">
			</div>
		</div>
	</div>
</div>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
