<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<%
if(authorizationLevel >= ResourceBean.AL_ADMIN_USER){ //for admin menu links
%>
<a href="<%=response.encodeURL("FrontController?operation=60") %>">Home</a> &raquo;
<a href="<%=response.encodeURL("FrontController?operation=9&type=custom") %>">Custom Filters</a>

<%
}
%>



<h1>BCC Rejectors</h1>


<div class="row">
	<div class="col-md-6">
		<p>This filter assigns a score if any of the recipients specified on this page receive an email as BCC. Good 
		candidates to add here are mailing lists such as <code>sales@yourcompany.com</code>, and <code>support@yourcompany.com</code>. 
		Spammers know that most companies will have an address like <b>sales</b> and therefore, send fake purchase orders. On
		the flip side, real companies will most likely use either TO or CC fields, rather than BCC.</p>
		
		<p>Do not specify a very high score to this rule.</p>
		
		<h3>Add New Email</h3>
		
		<form action="<%= request.getAttribute("appPath") %>" method="post">
								
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('txtFrn')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">Email:</span>
			<input class="form-control form-right pull-left wth-5" value="" type="email" name="ae" required>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="txtFrn">
				<p>An email to add in this rule. </p>
			</div>
			
			
			<br>
			<button class="btn btn-sm btn-submit pull-right" type="submit" title="Add new relay host">Add</button>
			
			<br><br>
			<input type="hidden" name="operation" value="mbbcrl" />
		</form>
	</div>
	
	<div class="col-md-6">
	
		<%
		List<String> rejectors = (List<String>) request.getAttribute("rejectors");
		if(rejectors != null && rejectors.size() > 0){
			%>
			
			<h3>Existing Addresses</h3>
			
			<table class="table table-bordered table-hover">
				<tr>
					<td>Email</td>
					<td>Action</td>
				</tr>
				
				<%
				for(String oneEmail : rejectors){
					%>
					<tr>
						<td><%= oneEmail %></td>
						<td><a href="<%=response.encodeURL("FrontController?operation=mbbcrl&re=" + oneEmail) %>"><i class="glyphicon glyphicon-trash"></i> Remove</a></td>
					</tr>
					<%
				}
				%>
			</table>
			<%
		}
		%>
	</div>
</div>







<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
