<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->


<a href="<%=response.encodeURL("FrontController?operation=60") %>">&laquo;&laquo; Home</a> / Appearance


<h1>Appearance</h1>
<br>




<%
String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}
%>


<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-success"><%=infoMsg %></div>
	<%
}
%>



Using Appearance you can customize the web interface of Xeams to give a more personal touch. <br><br>
<div class="row">
	<div class="col-md-4">
	
		<div class="well">
			<h2>Note</h2>
			Appearance will hide references to <b>Xeams</b> and <b>Synametrics Technologies, Inc.</b> from the public interface of Xeams - meaning when a non-admin user logs in. 
			<br><br>
			It will <b>NOT</b> hide these names when an someone logs in using the <b>admin</b> account.
		</div>
	
		<div>
			<h2>Tip: Changing Login Image</h2>
			<p>Want to change the image on login screen?</p> 
			Create a file called <code>xLogin.png</code> and save it 
			in <code>$INSTALL_DIR/config</code> folder. You will have to restart after saving the file.
		</div>
		<!-- ******* Save Button | default is pulled right ******* -->
		<%if(ResourceBean.getTheme().equals("custom-theme")){	%>
		
		
		<a href="<%=response.encodeURL("FrontController?operation=colors") %>"><button class="btn btn-menu" title="Click to customize colors">Customize Colors</button></a>
		<%} %>
			
	</div>
	<div class="col-md-8">

<!-- ******* Create Window Panel ******* -->
<div class="well-info-wrap">
	<div class="well-info-header">Input Parameters</div>
	<div class="well-info-body">
		<form action="<%= request.getAttribute("appPath") %>" method="post">

			<!-- ******* Create Text Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('pName')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">Top-Level Name</span>
			<input class="form-control form-right pull-left wth-5" type="text" name="pName" value="<%= request.getAttribute("pName") %>" >
		
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="pName">
				The value you specify here will replace the word "Xeams" in the web interface 
			</div>
			
			<!-- ******* Create Text Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('sHeading')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">Sub Heading</span>
			<input class="form-control form-right pull-left wth-5" type="text" name="sHeading" value="<%= request.getAttribute("sHeading") %>">
		
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="sHeading">
				A sub-heading that appears next to your product name. 
			</div>
			
			
			<!-- ******* Create Text Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('logoImage')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">Logo Image</span>
			<input class="form-control form-right pull-left wth-5" type="text" name="logoImage" value="<%= request.getAttribute("logoImage") %>" placeholder="Absolute URL to an image file">
		
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="logoImage">
				URL to the image that is displayed in the upper left hand corner of Xeam's web interface. This must be an absolute URL, for example: http://yourcompany.com/images/logo.png
			</div>
			
			
			<!-- ******* Create Text Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('reportImage')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">Report Image</span>
			<input class="form-control form-right pull-left wth-5" type="text" name="reportImage" value="<%= request.getAttribute("reportImage") %>" placeholder="Absolute URL to an image file">
		
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="reportImage">
				Image specified in this field is included in the Daily Quarantine Reports generated by Xeams. Recommended size for this image file is 750 x 100 pixels. This must be an absolute URL, for example: http://yourcompany.com/images/logo.png
			</div>
			
			<!-- ******* Create Checkbox Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('hideSupportTip')"><b>?</b></div>
			<span class="form-control form-text form-middle pull-left wth-8">Hide Support Link</span>
			<span class="chkbox-cust form-control form-right pull-left wth-1">
				<input id="hideSupport" type="checkbox" name="hideSupport"  value="1" <%= request.getAttribute("hideSupport") %>>
				<label for="hideSupport"></label>
			</span>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="hideSupportTip">
				If checked, hides the support link for non-admin users
			</div>
		
			
			
			<!-- ******* Create Checkbox Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('hideFooterTip')"><b>?</b></div>
			<span class="form-control form-text form-middle pull-left wth-8">Hide Footer</span>
			<span class="chkbox-cust form-control form-right pull-left wth-1">
				<input id="hideFooter" type="checkbox" name="hideFooter"  value="1" <%= request.getAttribute("hideFooter") %> >
				<label for="hideFooter"></label>
			</span>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="hideFooterTip">
				If checked, will hide the footer at the bottom to remove links about Xeams and Synametrics Technologies, Inc.
			</div>
		
		
			<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('theme')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Color Theme</span>
				<select class="form-control form-right pull-left wth-5" name="theme">
					<option value="defaulttheme" <%= ResourceBean.getTheme().equals("defaulttheme") ? "selected" : "" %> >Default</option>
					<%
					List<String[]> availableThemes = ResourceBean.fetchAvailableThemes();
					for(String[] themeNames: availableThemes){
						%>
						<option value="<%=themeNames[0] %>" <%= ResourceBean.getTheme().equals(themeNames[0]) ? "selected" : "" %> ><%=themeNames[1] %></option>
						<%
					}
					%>
					
					<!-- 
					<option value="bluetheme" <%= ResourceBean.getTheme().equals("bluetheme") ? "selected" : "" %> >Blue</option>
					<option value="browntheme" <%= ResourceBean.getTheme().equals("browntheme") ? "selected" : "" %> >Brown</option>
					<option value="lightpinktheme" <%= ResourceBean.getTheme().equals("lightpinktheme") ? "selected" : "" %> >Rose</option>
					<option value="limegreentheme" <%= ResourceBean.getTheme().equals("limegreentheme") ? "selected" : "" %> >Lime Green</option>
					<option value="pinktheme" <%= ResourceBean.getTheme().equals("pinktheme") ? "selected" : "" %> >Pink</option>
					<option value="redtheme"  <%= ResourceBean.getTheme().equals("redtheme") ? "selected" : "" %> >Red</option> 
					
					-->
				</select>
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="theme">
					Select a theme color for the web interface
				</div>
		
		
		
		
		
			<br><br>
			
			
			
			<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
			
			<input type="hidden" name="s" value="1" />
			<input type="hidden" name="operation" value="230">
		</form>
		
		<br><br><br>
	</div>
</div>

</div>

</div>






<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
