<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>




<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->


<a href="<%=response.encodeURL("FrontController?operation=60") %>">Home</a> &raquo; Broadcast


<h1>Email Broadcast</h1>



<%
String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger">
		<h4>Error</h4>
		<%= errorMsg %>
	</div>
	<%
}

String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-success">
		<%= infoMsg %>
	</div>
	<%
}

%>

<div class="well">

	<div class="row">
		<div class="col-md-9">
			Email broadcasting is a convenient way of sending an email to every user in your organization. You can compose a new email based on a pre-existing
			template. <a href="<%=response.encodeURL("FrontController?operation=bcast&st=dte") %>">Click here</a> to manage templates.
			
			
			
		</div>
		<div class="col-md-3">
			<a href="<%=response.encodeURL("FrontController?operation=bcast&st=dte") %>"><button class="btn btn-sm btn-menu">Manage Templates</button></a>
		</div>
	</div>
</div>




<!-- ******* Create Window Panel ******* -->
<div class="well-info-wrap">
	<div class="well-info-header">Broadcast Parameters</div>
	<div class="well-info-body">
		
		<form action="<%= request.getAttribute("appPath") %>" method="post" onsubmit="copyBody()">
			
			
			
			<div class="row">
				<div class="col-md-1">
					<b>Templates:</b>
				</div>
				<div class="col-md-6">
					<div  class="form-group">
						<select id="templates" class="form-control" onchange="loadTemplate()">
						<%
							List<BroadcastTemplateBean> templates = (List<BroadcastTemplateBean>) request.getAttribute("templates");
							for(BroadcastTemplateBean template : templates){
								%>
								<option value="<%= template.getIndex()%>"><%= template.getTitle()%></option>
								<%
							}
						%>
							
						</select>
					</div>
				</div>
			</div>
		  	
		  	

		
			
			<div class="panel panel-default">
				<div class="panel-body">
				
					<div  class="form-group">
						<div class="row">
							<div class="col-md-4">
								<span class="chkbox-cust form-control pull-left" style="width:75px;">
									<input id="includeBpList" type="checkbox" name="iBu" value="1" 
									checked='checked' 
									>
									<label for="includeBpList" 
									title="Bypassed users, who do not get their emails filtered, will be included in the broadcast message." ></label>
								</span>
								&nbsp;
								<b>Include Bypassed Users</b>
							</div>
							
							<div class="col-md-4">
								<span class="chkbox-cust form-control pull-left"  style="width:75px;">
									<input id="includeDlist" type="checkbox" name="iDl" value="1">
									<label for="includeDlist"
									title="Emails will be sent to distribution lists as well"
									></label>
								</span>
								&nbsp;
								<b>Include Distribution List</b>
							</div>
							
							
							<div class="col-md-4">
								<span class="chkbox-cust form-control pull-left"  style="width:75px;">
									<input id="dryRun" type="checkbox" name="isDr" value="1">
									<label for="dryRun" title="Email will only be sent to the administrator. However, you will see a list of users who would have received the message."></label>
								</span>
								&nbsp;
								<b>Dry Run</b>
							</div>
						</div>
					</div>
					
					<div  class="form-group">
						<input class="form-control" type="text" id="subject" name="subject" placeholder="Enter Email subject..." required >
					</div>
					
					<br>
					
					<div  class="form-group">
						<div class="standalone-container">
						  <div id="snow-container"></div>
						</div>
					</div>
			
				</div>
			</div>
			
			
			
			
			
			
			

			<input type="hidden" name="actualBodyText"  id="actualBodyText">
			
			
			<div class="row">
				<div class="col-md-6">
					<button class="btn btn-sm btn-menu" type="submit" name="savet">Save Template</button>
				</div>
				<div class="col-md-6">
					<!-- ******* Save Button | default is pulled right ******* -->
					<button class="btn btn-sm btn-submit pull-right" type="submit" name="send">Send Message</button>
		
				</div>
				
			</div>
			
			<br><br><br>
			<input type="hidden" name="operation"  value="bcast">
			<input type="hidden" name="st"  value="send">
			
			
		</form>
		
	</div>
</div>





<%@ include file="QuillHolder.jsp" %>

<script type="text/javascript">
loadTemplate();
</script>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
