<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->


<a href="<%=response.encodeURL("FrontController?operation=60") %>">Home</a> &raquo;
<a href="<%=response.encodeURL("FrontController?operation=bcast") %>">Broadcast</a>



<h1>Broadcast Templates</h1>


<%
String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger">
		<h4>Error</h4>
		<%= errorMsg %>
	</div>
	<%
}

String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-success">
		<%= infoMsg %>
	</div>
	<%
}

%>



<div class="row">
	<div class="col-md-6 col-md-offset-3">
		<div class="well-info-wrap">
			<div class="well-info-header">Existing Templates</div>
			<div class="well-info-body">
				
				<h2>Existing Templates</h2>
				<table class="table table-bordered table-hover">
					<thead>
						<tr><th>Template Name</th> <th>Action</th></tr>
					</thead>
					
					<%
					List<BroadcastTemplateBean> templates = (List<BroadcastTemplateBean>) request.getAttribute("templates");
					for(BroadcastTemplateBean template : templates){
						
						if(template.getIndex() <= 1){
							continue; //templates at index 0 and 1 are static. They don't change.
						}
						%>
						
						<tr>
							<td><%= template.getTitle() %></td>
							<td><a href="<%=response.encodeURL("FrontController?operation=bcast&st=met&i=" + template.getIndex() ) %>"><i class="glyphicon glyphicon-pencil"></i> Modify</a> | 
							    <a href="<%=response.encodeURL("FrontController?operation=bcast&st=rt&i=" + template.getIndex() ) %>"><i class="glyphicon glyphicon-trash"></i> Remove</a> </td>
						</tr>
						<%
					}
					%>
				</table>
			</div>
		</div>
	</div>
	
	<div class="col-md-3">
		<a href="<%=response.encodeURL("FrontController?operation=bcast&st=cnt") %>"><button class="btn btn-sm btn-menu">New Template</button></a>
	</div>
</div>









<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
