<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>





<a href="<%=response.encodeURL("FrontController?operation=60") %>">Home</a> &raquo;
<a href="<%=response.encodeURL("FrontController?operation=500") %>">User Administration</a>


<%
String message = (String)request.getAttribute("message");
if(message != null){
	%>
	<div class="infoMessage"><%=message %></div>
	<%
}


List<UserBean> users = (List<UserBean>)request.getAttribute("users");


%>

<h1>User Report Schedule</h1>

<div class="row">
	<div class="col-md-6">
		<div class="well">
			User notification reports can be sent multiple times. These reports contain a list of email address that have been quarantined by
			the server. Users can view as well as restore any quarantined message by just clicking on the appropriate link.<br><br>

			<b>Note:</b> Reports sent at midnight will include data for the previous day.<br><br>
		</div>
	</div>
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Modify Schedule for ALL users</div>
			<div class="well-info-body no-padding">
				<div class="well-info-additional">Apply the same schedule for every user in the system.</div>
				<div style="padding:10px;">
					<%
					
					if(users != null && users.size() > 0){
						UserBean tempUser = users.get(0);
						%>
						<form action="<%= request.getAttribute("appPath") %>" method="post">
						
						<%= tempUser.generateHTMLSelectOptionsForReportTimes("everyUser_", false) %>
						
						<br style="clear:both;">
						<button class="btn btn-sm btn-submit pull-right" type="submit" value="Save" title="Click here to apply this schedule to every user.">Save</button>
						<input type="hidden" name="operation" value="180" >
						</form>
						<br style="clear:both;">
						
					<%
					}
					%>
				</div>
			</div>
		</div>
	</div>
	
	<br style="clear:both;"><br>
	<div class="col-md-12">
		<div class="well-info-wrap">
			<div class="well-info-header">Modify Schedule for INDIVIDUAL users</div>
			<div class="well-info-body no-padding">
				<div class="well-info-additional">
				<div class="row">
					<div class="col-md-6">
						The following is a list of every user along with the time when they receive notification emails.
					</div>
					<div class="col-md-6">
						
						<form  action="<%= request.getAttribute("appPath") %>" class="form-inline pull-right">
						
							
							<input type="hidden" name="operation" value="179">
							
							<div class="input-group">
						
								<select name="f"  class="form-control">
									 <%= request.getAttribute("repTimes") %>
								</select>
							</div>&nbsp;&nbsp;
							<input type="Submit" value="Filter"  class="form-control btn btn-sm btn-menu">&nbsp;&nbsp;
							
						</form>
					</div>
				</div>
				
				
				</div>
				
				<form action="<%= request.getAttribute("appPath") %>" method="post">
				<table class="table table-striped table-bordered">
				
				<%
				
				for(int i = 0; i < users.size(); i++){
					%>
					<tr>
						<td><%=users.get(i).getEmail() %></td>
						<td class="text-center"><%=users.get(i).generateHTMLSelectOptionsForReportTimes(users.get(i).getEmail() + "_", false) %></td>
					</tr>
					<%
				}

				if(users.size() > 0){
					%>
					<%
				}else{
					%>
					<tr class="text-center"><td colspan=2>
					No users have been created on the system. You must create at least one user before assigning a schedule for notification reports.
					</td></tr>
					<%
				}
				%>
				</table>
				
				<div style="padding:10px;">
					<button class="btn btn-sm btn-submit pull-right" type="submit">Save</button>
					<input type="hidden" name="operation" value="180">
					<br style="clear:both;">
				</div>
				</form>
			</div>
		</div>
	</div>
</div>


<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
