
<%@ page import="java.util.*" %>

<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>


<table width="100%" border="0" cellpadding="0" cellspacing="0">
<tr align="left" valign="top">
<%@ include file="LeftButtons.jsp" %>
<td>

<h1>CSRF Attack Prevention</h1><br><br>

Similar to any web based application, <%= productName %> is also vulnerable to attacks from the Internet. In many cases, such as an XSS attack, <%= productName %> automatically handles and prevents such intrusion. 
However, in case of CSRF attacks, administrators have an option to disable it completely on their server.

<br><br>
<a href="http://en.wikipedia.org/wiki/Cross-site_request_forgery" target="_blank">Click here</a> to read more about CSRF attacks. 

<br><br>
A CSRF attack can potentially change configuration of your <%= productName %> without your knowledge. However, in order for such attacks to succeed, <b>ALL</b> of the following
conditions must be met.

<ul>
	<li>You get an email containing a hyper link from an unknown user.<br><br></li>
	<li>You mistakenly click on that link <b>while you are logged</b> in as an administrator. This attack does not affect regular users. The attack cannot occur if you are not logged in.<br><br></li>
	<li>Your browser is on the same machine where <%= productName %> is running (URL refers to localhost) OR the sender of the link knows the IP address and port of your <%= productName %> web server.<br><br></li>	
</ul>

From a practical perspective, if is very unlikely you will ever become a victim of such attack. Public sites like Facebook.com and Gmail.com are more vulnerable because,
a) their URL (host and port) is publicly known, b) users stay logged in to the site for a longer period of time and c) unlike administrators, a novice user is more likely to click on a link sent
from an unknown source. 

<br><br>
You gain performance benefits when this type of attack is not checked. Therefore, consider enabling this check if it is required by your company policy or you are required by law.

<br><br>
<h2>Enable/Disable CSRF prevention</h2>
<form action="<%= request.getAttribute("appPath") %>" method="post">
	<table width="80%">		
		<tr>
		<td><b>Enable CSRF filtering:</b></td><td><input name="enableCsrf" type="radio"  value="true"></td>
		</tr>
		
		<tr>
		<td><b>Disable CSRF filtering:</b></td><td><input name="enableCsrf" type="radio" checked value="false"></td>
		</tr>
		
		<tr><td></td><td><input type="image" class="form_button" src="<%= imagePath %>button_blank.png"></td></tr>
	</table>
	<input type="hidden" name="operation" value="25">
</form>

</td>
</tr>
</table>


<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
