<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<!-- NEW CLUSTERING -->

<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Clustering</h1>


<%
String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%= errorMsg %></div>
	<%
}

%>

<!-- ******* Create Window Panel ******* -->
<div class="well-info-wrap">
	<div class="well-info-header">Cluster Configuration</div>
	<div class="well-info-body">
		Clustering allow multiple <%= productName %> servers to coordinate with each other. When clustering is enabled, you must configure this server to play one of
		the following roles:<br><br>
		<ul>
			<li><b>No Clustering</b> - Clustering will be disabled</li>
			<li><b>Master</b> - Changes made to this <%= productName %> will be automatically pushed to every client running as <b>Slave</b></li>
			<li><b>Slave</b> - You will not be able change some configuration and filtering rules on this server. Instead, rules you modify on the <b>Master</b> will be pushed automatically</li>
		</ul>
		
		<br><br>
		<form action="<%= request.getAttribute("appPath") %>" method="post" class="form-inline">
				
			<label for="cRole">Select a role</label>
			<div class="form-group">
				
				<select class="form-control" id="cRole" name="cRole">				
				  <option value="0" <%= request.getAttribute("cRoleDisabled") != null ? "selected" : "" %> >Disabled</option>
				  <option value="1" <%= request.getAttribute("cRoleMaster") != null ? "selected" : "" %> >Master</option>
				  <option value="2" <%= request.getAttribute("cRoleSlave") != null ? "selected" : "" %> >Slave</option>
				</select>
				
			</div>
			<div class="form-group">
				<button class="btn btn-submit btn-sm" type="submit">Save</button>
			</div>
			<input type="hidden" name="operation" value="223">
			<input type="hidden" name="st" value="cr">
			
		</form>
		
	</div>
</div>


<%
if(request.getAttribute("cRoleMaster") != null){
	List<ClusterBean> slaves = (List<ClusterBean>) request.getAttribute("slaves");
	
	%>
	
<h2>Current Role: <small>Master</small></h2>	
This server is configured as <b>Master</b>. When you add/modify or delete a rule on this server, they will automatically get pushed to the slaves.



<div class="row">
	<div class="col-md-4">
	
		<div class="well">
		<H4>Add a slave</H4>
		<form action="<%= request.getAttribute("appPath") %>" method="post">
			
			
			<!-- ******* Create Text Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('sUrl')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">Slave URL</span>
			<input class="form-control form-right pull-left wth-5" type="text" name="sUrl" placeholder="Eg. http://server02:5272" required>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="sUrl">
				The URL to the Admin Console on the slave, which is same value you use in your browser's address bar.
			</div>
						
			<button class="btn btn-submit btn-sm" type="submit">Add</button>
			
			<input type="hidden" name="operation" value="223">
			<input type="hidden" name="st" value="as">
			
		</form>
		</div>
</div>
	<div class="col-md-8">
	
	
	<h3>Existing Slaves</h3>
<%
if(slaves.size() == 0){
	%>
No slaves configured yet. Enter the URL for a slave server below. After adding a new slave, ensure you have configured the other <%= productName %> as a Slave.
	<%
}else{
	
	boolean notAuthError = false;
	boolean noConnectError = false;
	boolean invalidRespError = false;
	%>
	<table class="table table-condensed table-bordered">
	<tr><th>Slave's URL</th><th>Status</th><th>Action</th>
	<%
	for(int i = 0; i < slaves.size(); i++){
		ClusterBean oneBean = slaves.get(i);
		%>
		<tr>
		<td><%= oneBean.getUrl() %></td>
		<td><% 
			if(oneBean.getStaus() == 1){ invalidRespError = true; %>
				<i class="glyphicon glyphicon-thumbs-down"> </i> <abbr title="A server seems to be running but is not responding in an expected manner." >Invalid Response</abbr>
			<%}else if(oneBean.getStaus() == 2){notAuthError = true; %>
				<i class="glyphicon glyphicon-question-sign"> </i> <abbr title="Slave is rejecting Master's request. You must authorized this master on the slave." >Not Authorized</abbr>
			<%}else if(oneBean.getStaus() == 3){%>
				<i class="glyphicon glyphicon-ok"> </i> <abbr title="Slave server running fine." >Up and running</abbr>
			<%}else{ noConnectError = true; %>
				<i class="glyphicon glyphicon-ban-circle"> </i> <abbr title="The slave server cannot be reached." >Unable to connect</abbr>
			<%}
		
		
		%></td>
		<td><a href="<%=response.encodeURL("FrontController?operation=223&st=rs&idx=" + oneBean.getIndex()) %>">Remove</a>
		</tr>
		<%
		
	}
	%>
	</table>
	<%
	
	if(invalidRespError || notAuthError || noConnectError){
		%>
		<div class="alert alert-success">
			<h3>Error Description</h3>
			<dl class="dl-horizontal">
			  <dt>Invalid Response</dt>
			  <dd>Occurs when the slave server is either not Xeams or is an older build that does not support clustering</dd>
			  
			  <dt>Not Authorized</dt>
			  <dd>Occurs when the Master server's IP address is not authorized or the server is not configured to be a slave.</dd>
			  
			  <dt>Unable to connect</dt>
			  <dd>The desired slave server cannot be reached. It could be down or the URL is referring to an invalid address.</dd>
			  
			</dl>
	 	</div>
		<%
	}
	
	
}
%>
	
	
	</div>
</div>


	<%
	
	// MASTER Configuration ends here.
	
	
}else if(request.getAttribute("cRoleSlave") != null){
	// SLAVE Configuration starts here
	%>
	<h2>Current Role: <small>Slave</small></h2>	
	
	
	<div class="row">
	<div class="col-md-6">
	
		<div class="well">
		<H4>Authorized Master</H4>
		
		Slaves can receive updates from only one master server. Specify the IP address of your Master server below.
		<br><br> 
		<form action="<%= request.getAttribute("appPath") %>" method="post">
			
			
			<!-- ******* Create Text Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('mip')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">Master IP:</span>
			<input class="form-control form-right pull-left wth-5" type="text" name="mip" placeholder="Eg. 192.168.1.20" required value="<%= request.getAttribute("mip") %>">
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="mip">
				Specify the IP address of the master server. If you have multiple IP address on that machine, separate each IP with a comma.
			</div>
						
						
			<!-- ******* Create Text Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('murl')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">Master's URL:</span>
			<input class="form-control form-right pull-left wth-5" type="url" name="murl" placeholder="Eg. https://xeams.example.com" required value="<%= request.getAttribute("murl") %>">
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="murl">
				URL of the Master Xeams. This is usually same as the preferred URL specified under Server Configuration.
			</div>			
						
			<button class="btn btn-submit btn-sm" type="submit">Add</button>
			
			<input type="hidden" name="operation" value="223">
			<input type="hidden" name="st" value="sm">
			
		</form>
		</div>
	</div>
	<div class="col-md-6">
		<%
		String masterIP = (String) request.getAttribute("mip");
		if(masterIP != null && masterIP.trim().length() > 0){
			
			if(request.getAttribute("stalePingWarning") == null){
			%>
			
			<h3>Ping Status: <b>Success</b></h3>
			<b>Last ping received at: </b> <%= request.getAttribute("lastCommWithServer") %>
			<%
			}else{
				%>
				<div class="alert alert-danger">
					<h4>Warning!</h4>
					The master server is supposed to ping every slave once every 10 minutes. You see this message if:<br><br>
					<ul>
						<li>No pings have been received yet. In this case, ensure this instance of Xeams is among the slaves configure for the Master server.</li>
						<li>It's been more than 10 minutes a ping was received. Ensure the server is up and running and there is no problem at the network level.</li>
					</ul>
					
					<br><br>
					<b>Last ping received at: </b> <%= request.getAttribute("lastCommWithServer") %>
				</div>
				
				<%
			}
		}
		
		%>
	
	</div>
</div>
	<%
}
%>





<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
