<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Updating JRE</h1>



<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-info text-center"><%=infoMsg %></div>
	<%
}


String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}

%>

<style>


.liwp {
    margin-bottom: 10px;
}

</style>


<%
if(request.getAttribute("supported").equals("true")){
	%>
	
	<div class="well-info-wrap">
		<div class="well-info-header">Important Information</div>
		<div class="well-info-body">
			<p>Please read the following instructions carefully before upgrading.</p>
			
			<ul>
				<li class="liwp">Expect around 3 minutes of down-time.</li>
				<li class="liwp">Backup the following folders, in case you need to rollback:
					<ol>
						<li><kbd><%= request.getAttribute("jrePath") %></kbd></li>
						<li><kbd><%= System.getProperty("user.dir") %>/lib</kbd></li>
					</ol>
					Restoring these folders will undo these steps.
				</li>
				<li class="liwp">Click the proceed button below when ready. DO NOT refresh or click another link after clicking the
				Proceed button.</li>
			</ul>
			
			<center>
				<a href="<%=response.encodeURL("FrontController?operation=update-jre&p=1") %>" class="btn btn-submit">Proceed</a>
			</center>
		</div>
	</div>
	
	
	
	<%
}else{
	%>
	
	
	<h2>Not Supported</h2>
	
	
	<div class="well-info-wrap">
		<div class="well-info-header">Automatic upgrading is not supported for your platform</div>
		<div class="well-info-body">
			
		
	
	
			<p>
			Unfortunately, upgrading JRE to the latest version is not supported on this platform. You will have to manually
			upgrade using the following steps:
			</p>
			
			<ol>
				<li class="liwp">Backup the following folders:
					<ul>
						<li><kbd><%= request.getAttribute("jrePath") %></kbd></li>
						<li><kbd><%= System.getProperty("user.dir") %>/lib</kbd></li>
					</ul>
				</li>
				<li class="liwp">Stop Xeams</li>
				<li class="liwp">Rename <kbd><%= request.getAttribute("jrePath") %></kbd> to something like <kbd>jre.older</kbd>.
				<li class="liwp">Download the latest JRE for your platform from any publicly available bundle, such as 
					<a href="https://adoptium.net/" target="_blank">Adoptium</a>.</li>
				<li>Extract the downloaded files into <kbd><%= request.getAttribute("jrePath") %></kbd></li>
				<li class="liwp"><b>VERY IMPORTANT:</b> Once downloading it complete, run the following command:
					<pre><%= request.getAttribute("jrePath") %>/bin/java -version</pre>
					This ensures files are saved correctly. If you get an error complaining file is not found, check the location where you saved the extracted
					files.
				</li>
				<li class="liwp">Download <a href="https://web.synametrics.com/files/lib4njre.jar">https://web.synametrics.com/files/lib4njre.jar</a> and
				save it in the <kbd><%= System.getProperty("user.dir") %>/lib</kbd> folder.</li>
				<li class="liwp">Restart Xeams</li>
			</ol>
	
		</div>
	</div>
	<%
}
%>


	






<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
