
<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>

<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<%
if(!ResourceBean.isIP2CountryInitialized()){
    out.println("IP-to-country database is not initialized. Try restarting " + productName + " and see if that " +
    	" fixes the problem. Contact technical support if the problem persists");
    return;
}
%>


<%
boolean isNotInverted = request.getAttribute("inverse") == null || request.getAttribute("inverse").toString().isEmpty();
%>
<h1>Country Filters</h1>
<div class="well">	

	<%
	if(isNotInverted){
		%>
		Country filters are based on IP addresses. Every email message contains a series of IP Addresses belonging to
		intermediate servers that were involved in delivering the message. <%= productName %> analyzes these IP Address,
		finds out its country of origin and can assign a score.
		<%
	}else{
	%>		
		Country filters are based on IP addresses. Emails coming in from countries other than the ones specified 
		below will be assigned a score of <%= request.getAttribute("invScore") %>.
	<%
	}
	%>
	<form  action="<%= request.getAttribute("appPath") %>" method="post" >
		<br style="clear:both;">
		<br style="clear:both;">
		<div class="row">
			<div class="col-md-3">
				
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblInverted')"><b>?</b></div>
				<span class="form-control pull-left form-middle form-text wth-5">Inverted</span>
				<span class="chkbox-cust form-control form-right pull-left wth-2">
					<input id="chk-inverse" type="checkbox" name="inverse" <%= request.getAttribute("inverse") %>>
					<label for="chk-inverse"></label>
				</span>
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="lblInverted">
					If checked, the country filters will be inverted. In other words, a score will be assigned to countries that are not explicitly selected on this page.
				</div>
			</div>
			<div class="col-md-1">
				<button type="submit" class="btn btn-menu" style="margin-right:10px">Save</button>
			</div>
			<div class="col-md-8">
				Refer <a href="https://www.xeams.com/countryfilter.htm" target="_blank">to this page</a> for further details.
			</div>
		</div>			
		
		<input type="hidden" value="121" name="operation"/>
		<input type="hidden" value="1" name="ci"/>
	</form>
</div>


<%
if(isNotInverted){
	%>
	<%@ include file="CountryFiltersDefault.jsp" %>
	<%
}else{
	%>
	<%@ include file="CountryFiltersInverted.jsp" %>
	<%
}
%>





<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
