<div class="row">
	<div class="col-md-6">		
		<div class="well-info-wrap">
			<div class="well-info-header">New Country Filter</div>
			<div class="well-info-body no-padding" style="padding-bottom:10px;">
				<div class="well-info-additional">
					To <em>modify</em> an existing entry, add a new record with the same country name.
					This will modify the existing country rather than creating a new record for it.
				</div>
				
				<div style="padding:10px;">	
					<form action="<%= request.getAttribute("appPath") %>" method="post">
					<br>
					<span class="form-control pull-left form-left form-text wth-6">Country Name</span>
					<select class="form-control pull-left wth-4" name="lstCountryNames">
						<%= ResourceBean.getCountryNamesForIPLookup() %>
					</select>
					
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('score')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-5">Score</span>
					<input class="form-control pull-left form-right wth-4" type="text" name="txtScore" value="">
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="score">
						Score that will be assigned to the email.
					</div>
					
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('includeIP')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-8">Include All IP</span>
					<span class="chkbox-cust form-control form-right pull-left wth-1">
						<input id="chk-ip" type="checkbox" name="chkAllIP" check="checked">
						<label for="chk-ip"></label>
					</span>
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="includeIP">
						An email may come through different SMTP servers all
						in different countries. For example, you select Italy as the country name in the filter. Let's say a message
						originates from China, goes through a server in Italy and Germany and finally arrives to your SMTP server. When this
						option is checked, a score will be assigned since Italy is the second SMTP server in the chain.
						However, when this option is NOT checked, a score will be assigned only if the Italian server is the
						last server in the chain.
					</div>
					
					<br style="clear:both;">
				</div>
				<button type="submit" class="btn btn-sm btn-submit pull-right" style="margin-right:10px">Submit</button>
				<input type="hidden" value="123" name="operation"/>
				</form>
				<br style="clear:both;">
			</div>
		</div>
	</div>
	
	<div class="col-md-6">		
		<div class="table-responsive well-info-wrap">
			<table class="table table-striped table-bordered table-condensed table-hover">
				<tr class="well-info-header">
					<th>Country Name</font></th>
					<th>Score</font></th>
					<th>Include all IP</font></th>
					<th>Action</font></th>
				</tr>


				<%
				String odd = "#FFFFFF";
				String even = "#DDDDDD";
				String bgcolor;
				List<CountryFilterBean> ipList = (List<CountryFilterBean>)request.getAttribute("FilterList");

				CountryFilterBean aFilter;

				if(ipList != null){
					for(int i = 0; i < ipList.size(); i++){
						if((i % 2) == 0){
							bgcolor = odd;
						}else{
							bgcolor = even;
						}

						aFilter = ipList.get(i);
						%>
						<tr bgcolor="<%=bgcolor%>">
							<td><%=aFilter.getCountry()%></td>
							<td><%=aFilter.getScore()%></td>
							<td><%=aFilter.isAllIP() ? "Yes" : "No"%></td>
							<td><a href="<%=response.encodeURL("FrontController?operation=122") %>&index=<%=i%>">Remove</a></td>
						</tr>

						<%
					}
				}
				%>
			</table>
		</div>
	</div>
</div>
