<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<a href="<%=response.encodeURL("FrontController?operation=60") %>">Home</a> &raquo;
<a href="<%=response.encodeURL("FrontController?operation=500") %>">User Administration</a>

<h1><%=productName %> User Editor</h1>

<%@ include file="LicenseWarning.jsp" %>





<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-info text-center"><%=infoMsg %></div>
	<%
}


String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}

%>


<%
String msg = (String)request.getAttribute("Message");
if(msg != null){ 
	%>
	<div class="alert alert-danger"><%= msg %></div>
	<%
	
}

UserBean user = (UserBean)request.getAttribute("user");
String activated;
String notify;
String serverHost, reportReceiver;
String restrictToBuddy = "";
String crEnabled = "";
String addOutboundRecipientsToWhiteList = "";
String allowUserToAssociate = "";
String forcePwdChange = "";
String strictLocal = "";

String emailIsReadonly = "";
if(user == null){
 	activated = " checked ";
    notify = " checked ";
    reportReceiver = "";
    serverHost = ResourceBean.getFirstIP(); //This will find out what is the IP address of the server machine
    
    if(request.getAttribute("preferredServerHost") != null){ //Added build 5928
    	serverHost = (String) request.getAttribute("preferredServerHost");
    }
}else{
	activated = user.isActive() ? " checked " : "";
 	notify = user.isNotify() ? " checked " : "";
 	emailIsReadonly = " readonly='true'";
 	restrictToBuddy = user.isRestrictIncomingToFriendsOnly() ? " checked " : "";
 	addOutboundRecipientsToWhiteList = user.isAddOutboundRecipientsToWhiteList() ? " checked " : "";
	serverHost = user.getServerHostName(); //This will create a new value if no value exists
	allowUserToAssociate = user.isAllowUserToAssociate() ? " checked " : "";
	reportReceiver = user.getReportReceiver() == null ? "" : user.getReportReceiver();
	forcePwdChange = user.isForcePasswordChange() ? " checked " : "";
	strictLocal = user.isStrictLocal() ? " checked " : "";
	crEnabled = user.isChallengeResponseEnabled() ? " checked " : "";
	
}
%>






<div class="row">
	
	<div class="col-md-6 col-md-offset-3">
	
	
		<%
		if(user != null && user.isMidnightReportMissing()){
			%>
			<div class="alert alert-warning">  
				<h4>Warning!</h4>
				This user's account is configured to receive quarantine reports but no report is scheduled for midnight. It is very important you generate a report
				at midnight. Failure to schedule such report can leave a gap in the reports data. <a href="http://xeams.com/qr-midnight.htm" target="_blank">Click here</a>
				for details.
			</div>
			<%
		}
		%>
	
	
		<form action="<%= request.getAttribute("appPath") %>" method="post">

		<%
			if(user != null && user.isFromAD()){
				%>
				<tr><td colspan="2">
				<b>Note: </b> This user is authenticated via Active Directory
				
				<input type="hidden" name="txtPwd" value="<%=user.getPassword() %>" />
				<input type="hidden" name="txtPwd1" value="<%=user.getPassword() %>" />
				<input type="hidden" name="txtFromAd" value="true" />
				</td></tr>
				
				<%
			}
		%>

		<br style="clear:both;">
		<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('emailLogin')"><b>?</b></div>
		<span class="form-control form-middle form-text pull-left wth-4 required">Email / Login ID</span>
		<input class="form-control form-right pull-left wth-5" type="text" placeholder="Email / Login ID" name="txtEmail" <%
				if(user != null){
					out.write("value='" + ResourceBean.encodeParam(user.getEmail()) + "'");
					if(user.isFromAD()){
						out.write(" readonly ");
					}else{
						out.write(" required ");
					}
				}
				%>  <%= emailIsReadonly %>>

		<br style="clear:both;">
		<div class="alert alert-info more_info" id="emailLogin">
			This email address is used for the following purposes:
			<ul>
				<li>Identify the user account for Admin console</li>
				<li>Serves as a login id for POP3, IMAP and SMTP servers</li>
			</ul>
		</div>

		<%	
		if(user == null || !user.isFromAD()){
		%>
		<br style="clear:both;">
		<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('userPwd')"><b>?</b></div>
		<span class="form-control form-middle form-text pull-left wth-4 required">Password</span>
		<input class="form-control form-right pull-left wth-5" type="password" placeholder="Password" name="txtPwd" <%if(user != null) out.write("value='" + UserBean.NO_CHANGE_PWD + "'"); %> required >

		<br style="clear:both;">
		<div class="alert alert-info more_info" id="userPwd">
			This password is used for the following purposes:
			<ul>
				<li>Identify the user account for Admin console</li>
				<li>Serves as a login id for POP3, IMAP and SMTP servers</li>
			</ul>
		</div>
		
		<br style="clear:both;">
		<div class="btn btn-info form-control pull-left form-left wth-1" disabled><b>?</b></div>
		<span class="form-control form-middle form-text pull-left wth-4 required">Confirm Password</span>
		<input class="form-control form-right pull-left wth-5" type="password" placeholder="Confirm Password" name="txtPwd1" <%if(user != null) out.write("value='" + UserBean.NO_CHANGE_PWD + "'"); %> required>
		<br style="clear:both;">
		<%
		}
		%>

		<br style="clear:both;">
		<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('activeUser')"><b>?</b></div>
		<span class="form-control form-middle form-text pull-left wth-8">Activate User</span>
		<span class="chkbox-cust form-control form-right pull-left wth-1">
			<input id="chk-activate" type="checkbox" name="chkActivate" <%=activated%>>
			<label for="chk-activate"></label>
		</span>

		<br style="clear:both;">
		<div class="alert alert-info more_info" id="activeUser">
			Activated users are able to log in to Admin Console to check and mark messages. Inactive users won't be able to log in to Admin console
			but will be able to connect using an IMAP or POP3 client.
		</div>



		<!-- Force users to change password when they first log in -->
		<br style="clear:both;">
		<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('forcePwdChange')"><b>?</b></div>
		<span class="form-control form-middle form-text pull-left wth-8">Force users to change password</span>
		<span class="chkbox-cust form-control form-right pull-left wth-1">
			<input id="chkForcePwdChange" type="checkbox" name="chkForcePwdChange" <%= forcePwdChange %>>
			<label for="chkForcePwdChange"></label>
		</span>

		<br style="clear:both;">
		<div class="alert alert-info more_info" id="forcePwdChange">
			If checked, system will force users to change their password when they log in the first time.
		</div>

		
		
		<br style="clear:both;">
		<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('crEnabled')"><b>?</b></div>
		<span class="form-control form-middle form-text pull-left wth-8">Challenge-Response</span>
		<span class="chkbox-cust form-control form-right pull-left wth-1">
			<input id="chk-crEnabled" type="checkbox" name="crEnabled" <%=crEnabled%>>
			<label for="chk-crEnabled"></label>
		</span>

		<br style="clear:both;">
		<div class="alert alert-info more_info" id="crEnabled">
			Enables challenge-response for this user. In this case, inbound emails are only accepted after the original sender verifies a challenge, indicating 
			they are real humans and not a bot.
		</div>
		 
		<br style="clear:both;">
		<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('restrictInbound')"><b>?</b></div>
		<span class="form-control form-middle form-text pull-left wth-8">Restrict inbound emails to buddy list</span>
		<span class="chkbox-cust form-control form-right pull-left wth-1">
			<input id="chk-restrict" type="checkbox" name="chkRestrictToBuddy" <%=restrictToBuddy%>>
			<label for="chk-restrict"></label>
		</span>

		<br style="clear:both;">
		<div class="alert alert-info more_info" id="restrictInbound">
			Every in-bound message will be marked as junk unless the sender's email address is present in the buddy list. 
			<br><br>There are three ways to add emails to buddy list:
			<ol>
				<li>The users logs in to admin console using his/her credentials and adds an email</li>
				<li>The users moves an email from junk folder to good folder using an IMAP client such as MS Outlook. This option
				is NOT available when running in <b>firewall</b> mode.</li>
				<li>The box displayed below is checked and the user sends an out-bound email to a recipient on the Internet</li> 
			</ol>
		</div>

		<br style="clear:both;">
		<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('outboundRecip')"><b>?</b></div>
		<span class="form-control form-middle form-text pull-left wth-8">Add outbound recipients to buddy list</span>
		<span class="chkbox-cust form-control form-right pull-left wth-1">
			<input id="chk-outBL" type="checkbox" name="chkAddOutboundRecipientsToWhiteList" <%=addOutboundRecipientsToWhiteList%>>
			<label for="chk-outBL"></label>
		</span>

		<br style="clear:both;">
		<div class="alert alert-info more_info" id="outboundRecip">
			When a user sends an out-bound message, the system automatically adds receipient's email address 
			to the buddy list. <br><br><b>IMPORTANT: </b>This setting is only applicable if you restrict in-bound emails to buddy list.
		</div>

		<br style="clear:both;">
		<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('allowAssociate')"><b>?</b></div>
		<span class="form-control form-middle form-text pull-left wth-8">Allow user to associate other addresses</span>
		<span class="chkbox-cust form-control form-right pull-left wth-1">
			<input id="chk-assoc" type="checkbox" name="allowUserToAssociate" <%=allowUserToAssociate%>>
			<label for="chk-assoc"></label>
		</span>

		<br style="clear:both;">
		<div class="alert alert-info more_info" id="allowAssociate">
			When checked, user will be able to associate other email accounts to his/her account. We recommend you only
			enable this feature for trusted users.
		</div>
		
		
		<%
		if(request.getAttribute("isHybrid") != null && request.getAttribute("isHybrid").equals("true")){
		%> 
		<br style="clear:both;">
		<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('rdbLocalOnly')"><b>?</b></div>
		<span class="form-control form-middle form-text pull-left wth-8">Strict Local</span>
		<span class="chkbox-cust form-control form-right pull-left wth-1">
			<input id="chk-strictLocal" type="checkbox" name="strictLocal" <%=strictLocal%>>
			<label for="chk-strictLocal"></label>
		</span>

		<br style="clear:both;">
		<div class="alert alert-info more_info" id="rdbLocalOnly">
			When checked, emails for this user will NOT be forwarded to the downstream server. This option is meaningful when running Xeams in Hybrid mode.
		</div>
		<%}%>
		

		<%
		if(user == null){
			//For new users I ask for associations. There is no need to ask this question for existing users.
		%>
		<br style="clear:both;">
		<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('createAssoc')"><b>?</b></div>
		<span class="form-control form-middle form-text pull-left wth-8">Create associations</span>
		<span class="chkbox-cust form-control form-right pull-left wth-1">
			<input id="chk-creatAssoc" type="checkbox" name="chkCreateAssociations" value="true">
			<label for="chk-creatAssoc"></label>
		</span>

		<br style="clear:both;">
		<div class="alert alert-info more_info" id="createAssoc">
			If checked, the new account will automatically be associated with every domain name that is local to this 
			server. Consider the following scenario:<br><br>
			
			Assume following domains are local to your server:
			<ul>
				<li>DomainOne.com</li>
				<li>DomainTwo.com</li>
				<li>DomainThree.com</li>
			</ul>
			You add a new user using <b>John@DomainOne.com</b> as the Email/Login ID. The server will automatically associate
			<b>John@DomainTwo.com</b> and <b>John@DomainThree.com</b> to John's user account.
		</div>
		<%
		}
		%>




		<br style="clear:both;">
		<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('serverHostname')"><b>?</b></div>
		<span class="form-control form-middle form-text pull-left wth-4">Server's hostname</span>
		<input class="form-control form-right pull-left wth-5 text-center" type="text" name="chkServerHost" value="<%=serverHost%>">

		<br style="clear:both;">
		<div class="alert alert-info more_info" id="serverHostname">
			This is the hostname of the server where <%= productName %> is running with respect to the end-user.
			Note that due to NAT the IP address of the machine might be different than the actual address from
			the user's perspective.
			
			<br><br>
			Consider the following scenario. Assume the machine's IP address where <%= productName %> is running is
			<b>192.168.1.5</b>, which is the inside IP address of your network. If a user is connecting over the Internet
			this IP address won't be valid anymore. In that case you might want to specify the outside (Internet)
			IP address of your network.
		</div>
		
		
		<br style="clear:both;">
		<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('reportReceiver')"><b>?</b></div>
		<span class="form-control form-middle form-text pull-left wth-4">Report Receiver</span>
		<input class="form-control form-right pull-left wth-5 text-center" type="email" name="chkReportReceiver" value="<%=reportReceiver%>">

		<br style="clear:both;">
		<div class="alert alert-info more_info" id="reportReceiver">
			If specified, quarantine report will be sent to this email address. Consider a scenario where you want quarantine reports for <code>ceo@yourcompany.com</code>
			to go to <code>secretary@yourcompany.com</code>.
		</div>
		
		
		
		<%
		if(ResourceBean.isStandaloneOrHybrid()){
		%>
		<br style="clear:both;">
		<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('dquota')"><b>?</b></div>
		<span class="form-control form-middle form-text pull-left wth-4">Disk Quota</span>
		<input class="form-control form-right pull-left wth-5 text-center" type="text" name="quota" value="<%= (user == null) ? "-1" : user.getDiskQuota() %>">

		<br style="clear:both;">
		<div class="alert alert-info more_info" id="dquota">
			Disk quota for local user repository. For example, 1GB, 5GB. Emails will be rejected once the disk usage for this user go beyond the configured
			quota. A -1 means no quota.
		</div>
		<%
		}
		%>
		

		<br style="clear:both;">
		<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('notifyMsg')"><b>?</b></div>
		<span class="form-control form-middle form-text pull-left wth-8">Send Quarantine Report</span>
		<span class="chkbox-cust form-control form-right pull-left wth-1">
			<input id="chk-notMsg" type="checkbox" name="chkNotify" <%=notify%>>
			<label for="chk-notMsg"></label>
		</span>

		<br style="clear:both;">
		<div class="alert alert-info more_info" id="notifyMsg">
			If checked, a summary of every email that was blocked by the server will be sent to the user around midnight every day.
			User will have the ability to restore any incorrectly blocked message using this report.
		</div>

		<h3 class="text-center">Notification times:</h3>
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('notifyTime')"><b>?</b></div>
			<div class="form-control form-right pull-left wth-9">
			<%
			if(user == null){
				out.println(ResourceBean.generateHTMLSelectOptionsForReportTimes("reportTime_", false));
			}else{
				out.println(user.generateHTMLSelectOptionsForReportTimes("reportTime_", false));
			}

			%>
			</div>
		
		<br style="clear:both;">
		<div class="alert alert-info more_info" id="notifyTime">
			Time of the day when email notifications are sent. These timings have no affect if <b>Send notification messages</b> is not 
			checked.<br><br>
			
			Reports generated at midnight will contain data for the previous day. Reports for any other time will contain data since midnight
			for the current day.
		</div>
		
		
		
		
		
		<br style="clear:both;"><br>
		<%
		if(user == null){
		%>
		<button class="btn btn-sm btn-submit pull-left" type="submit" name="SaveAndAdd"><span class="glyphicon glyphicon-plus"></span> Add More</button>
		<%
		}
		%>
		<button class="btn btn-sm btn-submit pull-right" type="submit" name="SaveAndClose">Save</button>
		<input type="hidden" name="operation" value="504">

		<%

		if(user != null){
			out.write("<input type='hidden' name='edit' value='" + ResourceBean.encodeParam(user.getEmail()) + "'>");
			//out.write("<input type='hidden' name='txtEmailWS' value='" + user.getEmailWebSafe() + "'>");
		}
		%>

		</form>
	</div>
</div>
	
<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
