<h1>Frequently asked questions about Clustering in <%= productName %></h1>


<a href="#WhatIsIt">What is clustering?</a><br>
<a href="#KeyConcepts">What are the key concepts?</a><br>
<a href="#SetupCluster">How do I setup clustering?</a><br>
<a href="#Requirement">What are the requirements for the clustering?</a><br>
<a href="#MasterGoesDown">What happens if the master server goes down?</a><br>
<a href="#SlaveGoesDown">What happens if one of the slaves go down?</a><br>
<a href="#SlaveGoesDown">Where are the quarantined emails stored?</a><br>
<a href="#WhichMachines">Which machine do I connect to access the Admin Console</a><br>


<a name="WhatIsIt" ></a>
<h2>What is clustering?</h2>

Clustering in <%= productName %> provides scalability and high availability by utilizing more than one physical machines
that act as one. This type of configuration is suitable for large enterprises and ISPs getting millions of messages
on daily basis. Refer to the picture below.<br>
<img alt="<%= productName %> Clustering" src="<%= imagePath %>Cluster.gif">

<p>

In this example four machines accept incoming emails for the enterprise. Although emails are filtered at four different
locations, all of them can be administered through one central management console that runs on the "Master" server.

<a name="KeyConcepts" ></a>
<h2>Key Concepts</h2>
<p>
<table cellspacing="1" bgcolor="Black">
	<tr>
        <td valign="top" bgcolor="#EDECE3" width="200"><b>Cluster - Master</b></td>
        <td valign="top" bgcolor="White">One of the machine in the cluster must run as a Master. This is the machine that
        administrators and users connect to through <%= productName %> Admin Console. You can check the staus
        of every other machine within the cluster from this machine. If you change a rule in the Master that
        change is pushed to every slave server automatically. <p>Besides keeping track of activities
        on other slave server, a master server can also accept and send emails to the Internet.</td>
	</tr>

    <tr>
        <td valign="top" bgcolor="#EDECE3"><b>Cluster - Slave</b></td>
        <td valign="top" bgcolor="White">Slave server process inbound and outbound messages and send statistics to the master
        server. Typically, you don't connect to a Slave servers Admin Console as every thing is done through the
        master.

        <p>
            When a slave server comes up, it pulls the rules from the master server and starts accepting inbound emails.
            The actual processing of the message is done at the slave server. All quarantined email messages are also
            saved on slave's hard disk. However, the file names are sent to the master server, which get displayed through
            View Messages on the master.
        </p>
        </td>
	</tr>

</table>
</p>

<p>
<a name="SetupCluster" ></a>
<h2>How do I setup Clustering</h2>
    Follow the steps below to setup clustering
    <ol>
        <li>Install <%= productName %> on ALL the machines that will take part in the cluster</li>
        <li>Designate one machine as master and the rest as slaves</li>
        <li>Log into Admin Console and click on "Cluster Mgmt"</li>
        <li>Select <b>"Enabled - Master"</b> on the master machine and <b>"Enabled - Slave"</b></li>
        <li>In case of Master, the phrase "Bind IP" refers to the IP address which will be used by slave machines to connect to</li>
        <li>In case of Slave, provide the IP address of the master server</li>
        <li>Once done, click the "Switch Configuration" button</li>
    </ol>

</p>


<p>
<a name="Requirement" ></a>
<h2>What are the requirements for the clustering</h2>
<ul>
    <li>High speed network between the cluster machines. We recommend at least 10 mbs</li>
    <li>Minimum 512 Ram on the master, 2 GB recommended.</li>
    <li>Any operating system including Windows, Linux, Solaris, Max OS X, FreeBSD and others.</li>
</ul>
</p>

<p>
<a name="MasterGoesDown" ></a>
<h2>What happens if the master server goes down?</h2>
If the master server goes down for any reason slaves stay up and keep processing emails normally. However,
every slave sends data to the master for reporting purposes. This data will sit in a queue until the master
comes back up. Slaves will automatically detect the master when it comes back up and will flush its queue.
</p>


<p>
<a name="SlaveGoesDown" ></a>
<h2>What happens if one of the slaves go down?</h2>
In this case the master server simply unregisters the dead slave and continues working with other slave machines
in the cluster. The dead slave will automatically connect back to the master once it comes back up.
</p>

<p>
<a name="SlaveGoesDown" ></a>
<h2>Where are the quarantined emails stored?</h2>
Every message regardless of its category are stored on the individual slave machines. However, the file names are
sent to the master server. Messages are fetched on demand by the master when a user wants to look at its contents.
</p>


<p>
<a name="WhichMachines" ></a>
<h2>Which machine do I connect to access the Admin Console?</h2>
There are different type of configuration in <%= productName %>. Refer to the table below to see how these settings are changed.

<table cellspacing="1" bgcolor="#CCCCCC">
	<tr>
        <td class="title" width="20%">Configuration Type</td>
        <td class="title" width="20%">Location</td>
        <td class="title" width="60%">Explanation</td>
	</tr>

    <tr bgcolor="White">
        <td valign="top">Server configuration</td>
        <td valign="top" >Individual Servers</td>
        <td valign="top">Every configuration parameter that is accessible via "Modify Configuration" menu is a server wide
        configuration. This is where you define IP address and ports for your corporate email server and other settings.
        The reason why these settings are not handled by clustering is to allow you to configure each individual
        slave differently, which gives a lot more flexibility than configuring every machine identically.</td>
	</tr>


    <tr bgcolor="#EDECE3">
        <td valign="top">Rules modification</td>
        <td valign="top">Master only</td>
        <td valign="top">Any settings that is accessible through "Modify Filters" screen should only be accesses
        through the master server. When any rule is modified, the master synchronizes these rules with every slave
        server running within the cluster. You should never modify rules on a slave server.</td>
	</tr>

    <tr bgcolor="White">
        <td valign="top">View/Restore Messages</td>
        <td valign="top">Master only</td>
        <td valign="top">Regardless of which slave server the original email is sent, master server will
        always know about it. Therefore, you should always connect to the master server to view messages.</td>
	</tr>

    <tr bgcolor="#EDECE3">
        <td valign="top">Run Reports</td>
        <td valign="top">Master only</td>
        <td valign="top">Similar to view/restore messages, all report data is collected by the master server.
        Therefore, you should run reports only on the master server. Running reports on a slave may not return
        correct data.</td>
	</tr>

    <!--
    <tr bgcolor="">
        <td valign="top"></td>
        <td valign="top"></td>
        <td valign="top"></td>
	</tr>
    -->

</table>
</p>


<p>
<a name="NewTag" ></a>
<h2></h2>
</p>

