<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Dynamic Recipient Verification</h1>

<%
String message = (String) request.getAttribute("msg");
if(message != null){
	%>
	<div class="alert alert-success">
		<%= message %>
	</div>
	
	<%
}
%>

<div class="well">
Dynamic Recipient Verification (DRV) is a mechanism used in <%=productName %> to validate the recipient of an incoming email with another SMTP server. This mechanism is 
applicable when receiving in-bound emails using the regular SMTP server. It does not apply when using SMTP Proxy Server. <a href="http://www.xeams.com/drv.htm" target="_blank">Click here</a>
for details.
	<br><br>
	
	<form action="<%= request.getAttribute("appPath") %>" method="post">
	<div class="row">
		<div class="col-md-6">
			
			
			
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('chkEnableDRV_Info')"><b>?</b></div>
			<span class="form-control form-text form-middle pull-left wth-8">Enable DRV</span>
			<span class="chkbox-cust form-control form-right pull-left wth-1">
				<input id="INPUT_ID" type="checkbox" name="chkDrvEnabled" <%= request.getAttribute("ed") %>>
				<label for="INPUT_ID"></label>
			</span>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="chkEnableDRV_Info">
				DRV will get enabled if checked
			</div>
	
			
			
		</div>
		<div class="col-md-2">
			<button class="btn btn-submit pull-right" type="submit">Save</button>
		</div>
		<div class="col-md-4"></div>
	</div>
	
	<input type="hidden" name="operation" value="226">
	<input type="hidden" name="ed" value="1">
	</form>
	<%
	if(!request.getAttribute("rejectEmailsForInvalidUsers").equals("true")){
		
		%><br><br>
		<b>IMPORTANT NOTE: </b>Settings on this page will have no effect unless emails for invalid users are rejected on <a href="<%=response.encodeURL("FrontController?operation=533&tname=relay") %>">this page</a>.</b>
		
		<%
	}
	%>
</div>


<h2>SMTP Servers for DRV</h2>
In most cases, the next SMTP server that receives email after Xeams will be the one that validates incoming recipient. One exception to this rule is when the next SMTP
Server is MS Exchange 2013 or 2016. In this case the "Default Hub Transport" listens on port 2525 instead of 25. Using this screen you can configure the SMTP host and port
for the server that can validate incoming recipients.

<br><br>
Use the following form to add an SMTP server for your domain. 
<br><br>
<form class="form-inline"  action="<%= request.getAttribute("appPath") %>" method="post">
  <div class="form-group">
    <input type="text" class="form-control" id="txtDomain" placeholder="Domain Name" name="txtDomain" required >
  </div>
  <div class="form-group">
    <input type="text" class="form-control" id="txtHost" placeholder="SMTP Server" name="txtHost" required >
  </div>
  <div class="form-group">
    <input type="number" class="form-control" id="txtPort" placeholder="TCP/IP Port" name="txtPort" required >
  </div>
  <div class="form-group">
  	<button type="submit" class="btn btn-submit">Add Server</button>
  </div>
  <input type="hidden" name="operation" value="226">
</form>






<%
List<DelegatedSmtpConfigHolder> holders = (List<DelegatedSmtpConfigHolder>) request.getAttribute("holders");
		
if(holders != null && holders.size() > 0){
	
	%>
	<h2>Existing Servers for DRV</h2>
	<table class="table table-condensed table-bordered table-hover">
		<tr>
			<th>Domain Name</th>
			<th>Smtp Server Host/IP</th>
			<th>Port</th>
			<th>Action</th>
			
		</tr>
		
		<%
		for(DelegatedSmtpConfigHolder holder : holders){
			%>
			<tr>
				<td><%= holder.getDomainName() %></td>
				<td><%= holder.getHostName() %></td>
				<td><%= holder.getPort() %></td>
				<td><a href="<%=response.encodeURL("FrontController?operation=226&rd=" + holder.getDomainName()) %>" title="Remove <%= holder.getDomainName()%>">Remove</a></td>
				
			</tr>
			<%
		}
		%>
	</table>

	<%
}
%>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
