<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%

List sideButtons = new ArrayList(5);
sideButtons.add(new UrlAnchorHolder("Admin Home", "FrontController?operation=60", false));
sideButtons.add(new UrlAnchorHolder("Memory Managment", "MemoryManagement.jsp", false));


//Variables for FAQ
boolean showFAQ = true;
List faqLinks = new ArrayList(3);
FAQHandler.getInstance().displayFAQ(faqLinks, "DiagnosticResults");
%>

<%@ include file="NewPageHeader.jsp" %>




<table width="100%" border="0" cellpadding="0" cellspacing="0">
<tr align="left" valign="top">



<td>

<%

String openRelayResult;
String mxRecordResult;
String mxResultDomain = (String)request.getAttribute("mxResultDomain");
String outboundQueueLength;
String serverConnectionResult;
String activeDirectoryResult = (String)request.getAttribute("activeDirectoryResult");
String activeDirectoryImage;
String httpConnectionResult;
String tlsSmtp;


String passed = "<img src=\"" + imagePath + "passed.gif\">";
String failed = "<img src=\"" + imagePath + "failed.gif\">";
String warning = "<img src=\"" + imagePath + "warning.gif\">";
String error = "<img src=\"" + imagePath + "error.gif\">";
String skipped = "<img src=\"" + imagePath + "skipped.gif\">";

if(request.getAttribute("openRelayResult") == null){
    openRelayResult = error;
}else if(request.getAttribute("openRelayResult").toString().equals("0")){  //In case of open relay a 1 means that this is an open relay
    openRelayResult = passed;
}else{
    openRelayResult = failed;
}

if(request.getAttribute("tls_smtp") == null){
	tlsSmtp = error;
}else if(request.getAttribute("tls_smtp").equals("1")){
	tlsSmtp = passed;
}else{
	tlsSmtp = failed;
}

if(activeDirectoryResult == null){
    activeDirectoryImage = skipped;
}else if(activeDirectoryResult.endsWith("success")){
    activeDirectoryImage = passed;
}else{
    activeDirectoryImage = failed;
}

if(request.getAttribute("serverConnectionResult").toString().equals("1")){
    serverConnectionResult = passed;
}else{
    serverConnectionResult = failed;
}


if(request.getAttribute("httpConnection").toString().equals("1")){
	httpConnectionResult = passed;
}else{
	httpConnectionResult = failed;
}

if(request.getAttribute("mxRecordResult").toString().equals("1")){
    mxRecordResult = passed;
}else{
    mxRecordResult = failed;
}

if(request.getAttribute("outboundQueueLength").toString().equals("0")){
    outboundQueueLength = passed;
}else{
    outboundQueueLength = warning;
}


/*
request.setAttribute("openRelayResult", openRelayResult ? "1" : "0");
        request.setAttribute("mxRecordResult", mxRecordResult ? "1" : "0");
        request.setAttribute("mxResultDomain", mxResultDomain.toString());
*/
%>
<h1>Diagnostic Results</h1>

<table class="table table-striped table-bordered well-info-wrap">
<tr class="well-info-header">
<td>Test Name</td>
<td>Result</td>
<td>Description</td>
</tr>



<!-- Connection with email server -->
<tr>
<td>Server Communication</td>
<td><%=serverConnectionResult%></td>
<td>
<%

if(serverConnectionResult.equals(passed)){
%>
<%= productName %> was able to successfully connect to your corporate email server at
<%=AppConfig.getInstance().getTargetSmtpHost()%>
<%
}else{
%>
<%= productName %> could not connect to your corporate SMTP server.

<h3>Severity Level - <font color="Black">High</font></h3>

<h3>Consequences</h3>
No emails will be received by <%= productName %>.

<h3>How to fix it</h3>
Make sure that
<ul>
<li>the IP/host (<%=AppConfig.getInstance().getTargetSmtpHost()%>) is correct.
<li>You can successfully ping the server.
<li>It is listening on the correct port, which is currently set to <%=AppConfig.getInstance().getTargetSmtpPort()%>
</ul>


<%
}
%>

</td>
</tr>


<!-- HTTP Connection -->
<tr>
	<td>HTTP Connection </td>
	<td><%=httpConnectionResult%></td>
	<td>
	
		<%
		if(httpConnectionResult.equals(passed)){
		%>
			Your server is able to connect to <%=productName %> other HTTP servers on the Internet.
		<%
		}else if(httpConnectionResult.equals(failed)){
		%>
			Your installation of <%=productName %> is not able to communicate with other HTTP servers on the Internet. 
			
			<p>Most common reason for such failure is use of a Proxy server in your network. Companies often block out-bound
			HTTP traffic from individual machines and require their users to go through an HTTP proxy server. 
			
			<h3>Severity Level - <font color="Black">High</font></h3>
			
			<h3>Consequences</h3>
			Your server won't be able to download important files and data from the Internet. For example, every two hours your server needs
			to check for new spam filtering rules. It won't be able to do that if out-bound HTTP traffic is blocked
	
			<h3>How to fix it</h3>
			There are two ways to fix this problem.
			
			<ol>
				<li><b>Unblock out-bound HTTP traffic</b> (Recommended)</li>
				<li><b>Configure a <a href="<%=response.encodeURL("FrontController?operation=158#tab4") %>">proxy server</a></b></li>
			</ol>
		<%
		}
		%>
	</td>
</tr>



<!-- OPEN RELAY -->
<tr>
<td>Open Relay </td>
<td><%=openRelayResult%></td>
<td>
	<%
	if(openRelayResult.equals(passed)){
	%>
		Your server does not accept email messages for other domains without proper authentication and is not an open relay.
	<%
	}else if(openRelayResult.equals(failed)){
	%>
	Your server is an open relay, which means that any person from the Internet will be able to use your
	server to send an email to a third party recipient.

	<p>
	Most common reason for this failure is that you have configured your email server to accept relay from the
	machine where <%= productName %> is running. Since <%= productName %> acts as a proxy server, every email that
	comes in from the Internet goes via <%= productName %> and your server thinks that emails are coming in from
	a machine that is within your network rather than the Internet.
	
	<h3>Severity Level - <font color="Black">High</font></h3>
	
	<h3>Consequences</h3>
	Spammers can use you server to send out spam messages to recipients on the Internet.
	
	
	<h3>How to fix it</h3>
	Configure your email server so that it does not accept relay from the machine where <%= productName %> is running.
	
	<%
	}else if(openRelayResult.equals(error)){
	out.println("This test was not run due to an error. This test always results in an error if the \"Server Communication\" test fails");
	}
	%>

</td>
</tr>


<!-- DNS LOOKUP RESULT -->
<tr>
<td>DNS lookup for local domains</td>
<td><%=mxRecordResult%></td>
<td>
<%

if(mxRecordResult.equals(passed)){
%>
<%= productName %> was able to successfully resolve the IP address(es) of your domains.
<%
}else{
%>
<%= productName %> was unable to find an MX record for the following domain(s). <p>
<%=mxResultDomain%>
<p>
It seems that the DNS server used by <%= productName %> does not have an MX record entry for the above domains. You
will not be able to restore emails

<h3>Severity Level - <font color="Black">High</font></h3>
<h3>Consequences</h3>
You will not be able to restore messages or use the Challenge/Response feature in <%= productName %>.
Out bound emails for these domains will sit in the OutboundMailQueue folder.

<h3>How to fix it</h3>
There are multiple ways to fix this problem:
<ul>
<li>Add an MX record in the DNS that is used by <%= productName %>.
<li>Use a DNS other than the default DNS.
<li>Create a hosts.txt file in the config directory.

</ul>


<%
}
%>

</td>
</tr>


<%
if(activeDirectoryResult != null){

%>
<!-- Active Direcotry lookup-->
<tr>
<td>Active Directory Lookup</td>
<td><%=activeDirectoryImage%></td>
<td>
<%

if(activeDirectoryImage.equals(passed)){
%>
A user was successfully verified by Microsoft Active Directory
<%
}else{
%>
<%= productName %> was unable to connect to Microsoft Active Directory. The exact message is<p>
<%=activeDirectoryResult%>
<p>

<h3>Severity Level - <font color="Black">Low</font></h3>
<h3>Consequences</h3>
The recipients for inbound emails will not be checked by <%= productName %>. Although <%= productName %> can still
successfully filter emails, fixing this problem will make the filters better.

<h3>How to fix it</h3>
Make sure that:
<ul>
<li>Active Directory Domain Controller host is correct in <%= productName %> Configuration.
<li>Active Directory Domain Name is correct.
<li>User ID and password for the admin account is correct
</ul>


<%
}
%>

</td>
</tr>
<%
}
%>

<!-- IRC - InvalidRecipientCheck  -->
<tr>
	<td>Invalid Recipient Check</td>
	<td><%
	
		//0 means skipped, 1 means success, 2 means warning, 3 means error 
		if(request.getAttribute("ircResult") != null){
			if(request.getAttribute("ircResult").equals("1")){
				out.println(passed);
			}else if(request.getAttribute("ircResult").equals("2")){
				out.println(warning);
			}else if(request.getAttribute("ircResult").equals("3")){
				out.println(error);
				
			}else{
				out.println(skipped);
			}
		}
	%></td>
	<td><%= request.getAttribute("ircReason") %>
	
		<%
		if(request.getAttribute("ircResult") != null && request.getAttribute("ircResult").equals("3")){
			%>
			
			<h3>Severity Level - <font color="Black">High</font></h3>

			<h3>Consequences</h3>
			There are two problems when Xeams accepts emails for invalid users:
			<ul>
				<li>High traffic from the Internet</li>
				<li>The <b>Active User Count</b> for licensing will show a higher number
			</ul>
			
			<h3>How to fix it</h3>
			Follow instructions on <a href="http://www.xeams.com/fix-incorrect-user.htm">this page</a> to solve this issue. 
			
			
			<%
		}
		%>
	
	
	</td>
</tr>



<!-- STARTTLS for SMTP -->
<tr>
<td>Inbound Encryption</td>
<td><%=tlsSmtp%></td>
<td>
<%

if(tlsSmtp.equals(passed)){
%>
	Inbound emails will use encryption.
<%
}else{
%>
	Encryption is not enabled for inbound emails. Using encryption is not only secure, some 
	servers on the Internet may decide not to deliver messages if your server does not support it. 
	<a href="https://www.xeams.com/usingssl.htm" target="_blank">Visit this page</a> for instructions.

<%
}
%>

</td>
</tr>






<!-- OUTBOUND QUEUE LENGHT -->
<tr>
<td>Outbound Queue</td>
<td><%=outboundQueueLength%></td>
<td>
<%

if(outboundQueueLength.equals(passed)){
%>
There are no messages in the Outbound queue.
<%
}else{
%>
There are <%=request.getAttribute("outboundQueueLength").toString()%> message(s) in the outbound
queue.<p><%= productName %> flushes its outbound queue every 10 minutes. Too many messages in this
queue may indicate a problem. <%= productName %> puts messages in outbound queue when:

<ul>
<li>a quarantined message is restored
<li>Challenge/Response is enabled
</ul>


<h3>Severity Level - <font color="Black">Medium</font></h3>

<h3>Consequences</h3>
Outbound messages won't get sent to recipient.

<h3>How to fix it</h3>
Most common reason for this warning is that <%= productName %> cannot resolve the domain name of the
recipients in the emails.
<ul>
<li>Make sure that DNS is configured correctly and the DNS test above passed.
<li>Make sure that outbound traffic on port 25 is NOT blocked by your firewall.
</ul>


<%
}
%>

</td>
</tr>




<!-- 
<tr>
<td> </td>
<td> </td>
<td> </td>
</tr>
 -->

</table>



</td>


<%@ include file="InnerRightGrey.jsp" %>
</tr>
</table>

<div class="well-info-wrap">
	<div class="well-info-header">Additional Checks</div>
	<div class="well-info-body">
		Runs diagnostic checks on user email repository. Corruption in user repository will cause errors through a POP3 or IMAP client such as Microsoft Outlook or Thunderbird
		<br><br>
		<a href="<%=response.encodeURL("FrontController?operation=164") %>"><button class="btn btn-sm btn-menu">Check User Repository</button></a>
	</div>
</div>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
