<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Summarized Disk Usage</h1>



<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-info text-center"><%=infoMsg %></div>
	<%
}


String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}

%>

<%
DiskUsageMgrBean dumb = (DiskUsageMgrBean) request.getSession().getAttribute("disk.usage.mgr");
if(dumb != null){
	
	if(request.getParameter("dp") == null){
		
		//Top-Level
		%>
		<div class="table-responsive">
		<table class="table table-bordered table-hover table-condensed">
		<tr><th>Name</th><th>Path</th><th>Files</th><th>Folders</th><th>Disk Usage</th></tr>
		
		
		<%
		boolean stillProcessing = false;
		
		int total = dumb.getTotalTlf();
		for(int i = 0; i < total; i++){
			
			if(dumb.getTotalDiskUsage(dumb.getStartingFolder(i)).startsWith("Process")){
				stillProcessing = true;
			}
			%>
			<tr>
			<td><%= dumb.getFriendlyName(i) %></td>
			<td><%= dumb.getStartingFolder(i).getAbsolutePath() %></td>
			<td><%= dumb.getTotalFileCount(dumb.getStartingFolder(i)) %></td>
			<td><%= dumb.getTotalFolderCount(dumb.getStartingFolder(i)) %></td>
			<td><%= dumb.getTotalDiskUsage(dumb.getStartingFolder(i)) %> <span class="pull-right"><a href="<%=response.encodeURL("FrontController?operation=mngdu&i=" + i + "&dp=") %>"><i class="fa fa-zoom"></i> Details</a></span></td>
			
			</tr>
			<%
		}
		
		if(stillProcessing){
			%>
			<script>
			setTimeout(function(){
				   window.location.reload(1);
				}, 3000);
			</script>
			<%
		}
		%>
		</table>
		</div>
		<%
	}else{
		//Deeper path.
		%>
		
		<div class="table-responsive">
		<table  class="table table-bordered table-hover table-condensed">
		<tr>
			<th>Path</th><th>Files</th><th>Folders</th><th>Disk Usage</th></tr>
		</tr>
		
		<%
		String dp = request.getParameter("dp");
		String i = request.getParameter("i");
		
		List<String[]> deeperFolders = dumb.getDiskUsageForDeeper(Integer.parseInt(i), dp);
		for(String[] folderMeta : deeperFolders){
			%>
			<tr>
				<td><%= folderMeta[0] %></td>
				<td><%= folderMeta[1] %></td>
				<td><%= folderMeta[2] %></td>
				<td><%= folderMeta[3] %></td>
				
			</tr>
			<%
		}
		%>
		</table></div>
		<%
	}
}else{
	%>
	<h2>Error</h2>
	<p>Object not found in session. Please refresh the page.</p>
	<%
}
%>



<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
