<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->


<a href="<%=response.encodeURL("FrontController?operation=60") %>">Home</a> &raquo;
DKIM Configuration

<h1>DKIM <small>DomainKeys Identified Mail</small></h1>
<br>

<%
String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger">
		<%= errorMsg %>
	</div>
	
	<%
}
%>

<!-- ******* Divide Page into Two Columns, Total Widths must Equal 12 (or less) ******* -->
<div class="row">
	<div class="col-md-6">
		<h2>Score for Incoming Messages</h2>
		
		Specify a score greater than 0 to enable DKIM check for incoming emails. Incoming emails will be assigned this score if a DKIM check fails.
		
		<form action="<%= request.getAttribute("appPath") %>" method="post">
		
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('txtScore')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">When DKIM fails</span>
			<input class="form-control form-right pull-left wth-5" type="number" name="txtScore" value="<%= request.getAttribute("txtScore") %>" required >
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="txtScore">
				Score assigned to emails that fail DKIM authentication
			</div>
			
			
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('txtMissing')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">When DKIM is missing</span>
			<input class="form-control form-right pull-left wth-5" type="number" name="missing" value="<%= request.getAttribute("missing") %>" required >
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="txtMissing">
				Score assigned to emails that are missing a DKIM signature
			</div>
			
			
			
			<!-- ******* Save Button | default is pulled right ******* -->
			<button class="btn btn-submit pull-right" type="submit">Save</button>
		
			<input type="hidden" name="st" value="cs">
			<input type="hidden" name="operation" value="221">
		
		</form>
		
		
	</div>
	
	<div class="col-md-6">
	
	
		<%
		if(authorizationLevel >= ResourceBean.AL_ADMIN_USER){ //for admin menu links
		%>										
		
	
		<h2>Domains for Outgoing Messages</h2>
		
		
		
		<%
		List<DKIMBean> domainList = (List<DKIMBean>) request.getAttribute("domainList");
		boolean inactiveRecordFound = false;
		if(domainList != null && domainList.size() > 0){
			%>
			
			<table class="table table-condensed table-bordered table-hover">
				<tr><th>Domain Name</th><th>Selector</th><th>Active</th><th>Action</th></tr>
				<%
				for(DKIMBean oneDomain : domainList){
					if(!oneDomain.isActive()){
						inactiveRecordFound = true;
					}
					%>
					<tr>
						<td><%=oneDomain.getDomainName() %></td>
						<td><%=oneDomain.getSelector() %></td>
						<td><%= oneDomain.isActive() ? "<i class='glyphicon glyphicon-thumbs-up'></i> Yes" : "<i class='glyphicon glyphicon-thumbs-down'></i> No" %>
						<td>
							<a href="<%=response.encodeURL("FrontController?operation=221&st=vd&dn=" + oneDomain.getDomainName()) %>"><i class="glyphicon glyphicon-search"></i> View Details</a> 
							<span class="pull-right"><a href="<%=response.encodeURL("FrontController?operation=221&st=rd&dn=" + oneDomain.getDomainName()) %>"><i class="glyphicon glyphicon-trash"></i> Remove</a></span>
						</td>
					</tr>
					
					<%
				}
				%>
			</table>
			
			<%
			
			if(inactiveRecordFound){
				%>
				<i class="glyphicon glyphicon-warning-sign"></i> <b>Note:</b> - You see inactive record(s) above if a TXT record for that domain does not exist in DNS.
				<%
			}
		}
		%>
		
		<h2>Add a New Record</h2>
		<form action="<%= request.getAttribute("appPath") %>" method="post">
		
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('txtDomain')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">New Domain</span>
			<input class="form-control form-right pull-left wth-5" type="text" name="txtDomain"  style="text-transform:lowercase" required>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="txtDomain">
				Add a domain name
			</div>
			
			
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('txtSelector')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">Selector</span>
			<input class="form-control form-right pull-left wth-5" type="text" name="txtSelector" placeholder="For Eg. <%= request.getAttribute("suggestedSelector") %>" required>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="txtSelector">
				Selector is an arbitrary one-word value of your choice.
			</div>
			
			
			<!-- ******* Save Button | default is pulled right ******* -->
			<button class="btn btn-submit pull-right" type="submit">Add</button>
		
			<input type="hidden" name="st" value="ad">
			<input type="hidden" name="operation" value="221">
		</form>

		<%
		}
		%>
	</div>
</div>











<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
