<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>


<style>
.dont-break-out {

  /* These are technically the same, but use both */
  overflow-wrap: break-word;
  word-wrap: break-word;

  -ms-word-break: break-all;
  /* This is the dangerous one in WebKit, as it breaks things wherever */
  word-break: break-all;
  /* Instead use this non-standard one: */
  word-break: break-word;

  /* Adds a hyphen where the word breaks, if supported (No Blink) */
  -ms-hyphens: auto;
  -moz-hyphens: auto;
  -webkit-hyphens: auto;
  hyphens: auto;

}
</style>

<a href="<%=response.encodeURL("FrontController?operation=60") %>">Home</a> &raquo;
<a href="<%=response.encodeURL("FrontController?operation=221") %>">DKIM Configuration</a> &raquo;
DKIM Details



<h1>DKIM Details <small><%= request.getAttribute("domainName") %></small></h1>
<br>

Outgoing emails for <b><%= request.getAttribute("domainName") %></b> will automatically be signed by Xeams once the following TXT record is entered in the DNS 
server for this domain. Domains that do not have a record in DNS will be marked <b>Inactive</b> until a record is found.


<br><br>

<div class="row">
	<div class="col-md-6">
		<h4>TXT Record Hostname</h4>
		<code><%= request.getAttribute("recName") %></code>
	</div>
	<div class="col-md-6">
		<span class="pull-right">
			<%= new DnsSubmitter().cpBtn4(request, request.getAttribute("recName").toString(), request.getAttribute("recValue").toString(), "txt", true) %>
		</span>
	</div>
</div>

<h4>TXT Record Value</h4>
<div class="well dont-break-out">
<%= request.getAttribute("recValue") %>
</div>
	
	
	
<div class="row">
	<div class="col-md-3"></div>
	<div class="col-md-6">
		<div class="alert alert-success">
			<h4>Note:</h4>
			It takes about 10 minutes for Xeams to activate DKIM for a domain after a DNS entry has been added
		</div>
	</div>
	<div class="col-md-3"></div>
</div>



<div class="panel panel-default">
  <div class="panel-heading">Size limit on TXT records in a DNS server</div>
  <div class="panel-body">
		By default, a TXT record cannot be more than 512 characters. Depending upon the interface used by your DNS server, you may have to break the signature into
		multiple chunks in order to enter the complete string you see above. 
		<br><br>
		If your DNS provider, such as GoDaddy, use a web interface to manage DNS entries you may be able to enter the entire string in one attempt.
		<br><br>
		However, if you are using your own DNS server, refer the documentation provided by the vendor to see how to accomplish this goal. 
		<a href="http://xeams.com/ms-dns.htm" target="_blank">Click here</a> to see how to enter a longer TXT record if you're using Microsoft DNS Server.
	</div>
</div>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
