<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>DMARC Configuration and Reports</h1>
<br>

<%
String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><h2>Error</h2><%= errorMsg %></div>
	<%
}
%>

<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-success"><%= infoMsg %></div>
	<%
}
%>



<%
	DmarcBean theBean = (DmarcBean) request.getAttribute("theBean");
	boolean suLoggedIn = (authorizationLevel >= ResourceBean.AL_SUPER_USER);
%>

<form action="<%= request.getAttribute("appPath") %>" method="post">
<div class="row">
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Inbound Scoring</div>
			<div class="well-info-body">
			
				<!-- ******* Create Checkbox Input Field ******* -->
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblEnabled')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">DMARC Enabled</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="enabled" type="checkbox" name="dmarcEnabled" <%= theBean.isEnabled() ? " checked " : "" %>>
					<label for="enabled"></label>
				</span>
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="lblEnabled">
					DMARC is enabled when this box is checked
				</div>
			
			
				<!-- ******* Create Text Input Field ******* -->
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('scoreNone')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Score None</span>
				<input class="form-control form-right pull-left wth-5" type="number" name="scoreNone" value="<%= theBean.getScoreNone() %>">
			
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="scoreNone">
					Score assigned when sender is not aligned and DMARC policy is set to none
				</div>
				
				
				<!-- ******* Create Text Input Field ******* -->
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('scoreQuarantine')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Score Quarantine</span>
				<input class="form-control form-right pull-left wth-5" type="number" name="scoreQuarantine" value="<%= theBean.getScoreQuarantine() %>">
			
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="scoreQuarantine">
					Score assigned when sender is not aligned and DMARC policy is set to quarantine
				</div>
				
				
				
				<!-- ******* Create Text Input Field ******* -->
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('scoreReject')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Score Reject</span>
				<input class="form-control form-right pull-left wth-5" type="number" name="scoreReject" value="<%= theBean.getScoreReject() %>">
			
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="scoreReject">
					Score assigned when sender is not aligned and DMARC policy is set to reject
				</div>
				
			</div>
		</div>
		
	</div>
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Outbound Reporting</div>
			<div class="well-info-body">
				<!-- ******* Create Checkbox Input Field ******* -->
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblReportingEnabled')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Reporting Enabled</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="reportingEnabled" type="checkbox" name="reportingEnabled" <%= theBean.isEnableReporting() ? " checked " : "" %>  <%= suLoggedIn ? "" : " readonly='true'"  %> >
					<label for="reportingEnabled"></label>
				</span>
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="lblReportingEnabled">
					Outbound reporting is enabled when this box is checked.
				</div>
			
			
				<!-- ******* Create Text Input Field ******* -->
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('rua')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">User for Aggregate Feedback</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="rua" value="<%= theBean.getRua() %>" <%= suLoggedIn ? "" : " readonly='true'"  %>>
			
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="rua">
					User name part of an email address where in-bound emails will be received for aggregate feedback
				</div>
				
				
				<!-- ******* Create Text Input Field ******* -->
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('ruf')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">User for Forensic Feedback</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="ruf" value="<%= theBean.getRuf() %>" <%= suLoggedIn ? "" : " readonly='true'"  %>>
			
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="ruf">
					User name part of an email address where in-bound emails will be received for forensic feedback
				</div>
				
				
				<!-- ******* Create Text Input Field ******* -->
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('obEmail')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Out-bound Email Sender</span>
				<input class="form-control form-right pull-left wth-5" type="email" name="obEmail" value="<%= theBean.getObEmail() %>" <%= suLoggedIn ? "" : " readonly='true'"  %> required placeholder="Eg. no-reply@yourdomain.com">
			
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="obEmail">
					An email address used for out-bound emails. This is a mandatory field.
				</div>
				
				
				
			</div>
		</div>
	</div>
</div>

<br style="clear:both;">

<div>
	<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
</div>

<input type="hidden" name="operation" value="235" />
<input type="hidden" name="save" value="true" />

</form>


<% 

List<String> repDomains = (List<String>) request.getAttribute("repDomains");
							
							
if(suLoggedIn && repDomains != null && repDomains.size() > 0){

	
	%>
	
<h2>Reports</h2>	


<div class="row">
	<div class="col-md-5">
		<form class="form-inline" action="<%= request.getAttribute("appPath") %>" method="post">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('repDomain')"><b>?</b></div>
			<span class="form-control pull-left form-middle form-text wth-5">Domain name for reports</span>
			<select class="form-control pull-left wth-4" name="repDomain">		
				<%
				String curRepDomain = (String) request.getAttribute("curRepDomain");
				for(int i = 0; i < repDomains.size(); i++){
					String oneDomain = repDomains.get(i);
					String selected = oneDomain.equals(curRepDomain) ? " selected " : "";
						
					
					%>
					<option value="<%= i%>" <%= selected %>><%=oneDomain %></option>
					<%
				}
				%>
			</select>
			<button type="submit" class="btn btn-submit pull-right">Change</button>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="repDomain">
				Select the desired domain name to display data for it.
			</div>
		 
		<input type="hidden" name="operation" value="235">
			
		</form>
	</div>
	<div class="col-md-7"></div>
</div>


<%



DmarcSummaryBean summary = (DmarcSummaryBean) request.getAttribute("repSummary");
						
						
String titleWith = "Detail along with hostnames. This may take a long time.";
String titleWithout = "Detail without resolving IP addresses. This is faster.";
String withHost = " with FQDN";
String withoutHost = " without FQDN";
if(summary != null){
	%>
	
	<h2>DMARC Aggregate Report Summary <small>Displaying data for the last <%= summary.getNumDaysForReports() %> days</small></h2>
	
	<div class="row">
		<div class="col-md-7">
			
			<table class="table table-bordered">
				<tr>
					<th>Message Type</th><th>Count</th><th>Action</th>			
				</tr>
				
				<tr>
					<td><i class="glyphicon glyphicon-ok"></i> Compliant Message Count:</td><td><%= summary.getFullyCompliant() %></td><td>Details
						<a href="<%=response.encodeURL("FrontController?operation=236&dt=fc&wh=1") %>" title="<%=titleWith %>" ><%=withHost %></a> | 
						<a href="<%=response.encodeURL("FrontController?operation=236&dt=fc") %>" title="<%=titleWithout%>"><%=withoutHost %> </a></td>
				</tr>
				<tr>
					<td><i class="glyphicon glyphicon-exclamation-sign"></i> Quarantined Message Count:</td><td><%= summary.getQuarantineCount() %></td><td>Details
						<a href="<%=response.encodeURL("FrontController?operation=236&dt=qc&wh=1") %>" title="<%=titleWith %>" ><%=withHost %></a> |
						<a href="<%=response.encodeURL("FrontController?operation=236&dt=qc") %>" title="<%=titleWithout%>"><%=withoutHost %></a></td>
				</tr>
				<tr>
					<td><i class="glyphicon glyphicon-remove"></i> Rejected Message Count:</td><td><%= summary.getRejectedCount() %></td><td>Details
						<a href="<%=response.encodeURL("FrontController?operation=236&dt=rc&wh=1") %> title="<%=titleWith %>" ><%=withHost %></a> |
						<a href="<%=response.encodeURL("FrontController?operation=236&dt=rc") %>" title="<%=titleWithout%>"><%=withoutHost %></a></td>
				</tr>
				
				<tr>
					<td><i class="glyphicon glyphicon-thumbs-up"></i> SPF Passed:</td><td><%= summary.getSpfPassed() %></td><td>Details
						<a href="<%=response.encodeURL("FrontController?operation=236&dt=sp&wh=1") %>" title="<%=titleWith %>" ><%=withHost %></a> |
						<a href="<%=response.encodeURL("FrontController?operation=236&dt=sp") %>" title="<%=titleWithout%>"><%=withoutHost %></a></td>
				</tr>
				<tr>
					<td><i class="glyphicon glyphicon-thumbs-down"></i> SPF Failed:</td><td><%= summary.getSpfFailed() %></td><td>Details
					<a href="<%=response.encodeURL("FrontController?operation=236&dt=sf&wh=1") %> title="<%=titleWith %>" ><%=withHost %></a> |
					<a href="<%=response.encodeURL("FrontController?operation=236&dt=sf") %>" title="<%=titleWithout%>"><%=withoutHost %></a></td>
				</tr>
				
				<tr>
					<td><i class="glyphicon glyphicon-thumbs-up"></i> DKIM Passed:</td><td><%= summary.getDkimPassed() %></td><td>Details
						<a href="<%=response.encodeURL("FrontController?operation=236&dt=dp&wh=1") %>" title="<%=titleWith %>" ><%=withHost %></a> |
						<a href="<%=response.encodeURL("FrontController?operation=236&dt=dp") %>" title="<%=titleWithout%>"><%=withoutHost %></a></td>
				</tr>
				<tr>
					<td><i class="glyphicon glyphicon-thumbs-down"></i> DKIM Failed:</td><td><%= summary.getDkimFailed() %></td><td>Details
						<a href="<%=response.encodeURL("FrontController?operation=236&dt=df&wh=1") %>" title="<%=titleWith %>" ><%=withHost %></a> |
						<a href="<%=response.encodeURL("FrontController?operation=236&dt=df") %>" title="<%=titleWithout%>"><%=withoutHost %></a></td>
				</tr>
				
				<tr>
					<td><i class="glyphicon glyphicon-user"></i> Total Reporters:</td><td><%= summary.getReporterSet().size() %></td><td><a href="<%=response.encodeURL("FrontController?operation=236&dt=rs") %>">View Details</a></td>
				</tr>
				
				<tr>
					<td><i class="glyphicon glyphicon-th-list"></i> Total Reports:</td><td><%= summary.getReports().size() %></td><td><a href="<%=response.encodeURL("FrontController?operation=236&dt=tf") %>">View Details</a></td>
				</tr>
			</table>
		</div>
		<div class="col-md-5">
		
			<div>
				<canvas id="dmarcChart"></canvas>
			</div>
		
			<script>
			var dmarcChartVar = document.getElementById("dmarcChart").getContext('2d');
			var myDomainChart = new Chart(dmarcChartVar, {
			    type: 'pie',
			    data: {
			        labels: ['Compliant', 'Quarantine', 'Rejected'],
			        datasets: [{
			            label: 'Top Domains',
			            data: [<%= summary.getFullyCompliant() %>, <%= summary.getQuarantineCount() %>, <%= summary.getRejectedCount() %>],
			            backgroundColor: [<%= ResourceBean.getRgbColors(3)%>],
			            borderWidth: 1
			        }]
			    }
			});
		</script>
		
		</div>
	</div>
	
	
	<%
	
}else{
	
	//DMARC for the domain is missing. Recommend adding TXT records.
	%>
	
	<h2>DMARC Record missing</h2>
	<p>
	<code><%= curRepDomain %></code> does not have a TXT record in the DNS server.
	Consider setting the value for policy mode to <code>p=none</code> when creating a DMARC record initially.
	This will allow 
	you to view DMARC reports on this page and confirm if your outbound emails are being received correctly by other servers on the Internet. Once you don't
	see any unexpected problems in the report, switch to this
	parameter to <code>p=quarantine</code>.
	
	</p>
	
	<h4>Suggested DMARC records</h4>
	
	<div class="row">
		
		<div class="col-md-10">
			<pre><%= request.getAttribute("sd4none") %></pre>
		</div>
		<div class="col-md-2">
			<%= new DnsSubmitter().cpBtn4(request, "_dmarc." + curRepDomain, request.getAttribute("sd4none").toString(), "txt", false) %>
		</div>
		
	</div>
	
	<br>OR</br></br>
	
	
	<div class="row">
		
		<div class="col-md-10">
			<pre><%= request.getAttribute("sd4quar") %></pre>
		</div>
		<div class="col-md-2">
			<%= new DnsSubmitter().cpBtn4(request, "_dmarc." + curRepDomain, request.getAttribute("sd4quar").toString(), "txt", false) %>
		</div>
		
	</div>
	
	
	
	<%
}
%>


	
	<%
}
%>




<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
