<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.bean.rua.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Dmarc Reports</h1>
<a href="<%=response.encodeURL("FrontController?operation=235") %>"><i class="glyphicon glyphicon-chevron-left"></i> Back to DMARC</a>
<br><br>


<div class="row">
	<div class="col-md-3"></div>
	<div class="col-md-6">
		<div class="alert alert-success">
		<%
		if(request.getParameter("dt").equals("fc")){
		%>
		This report contains IP addresses that sent out-bound emails for <code><%= request.getAttribute("curRepDomain") %></code>. You should see your public
		IP address in this list. Occasionally, you may see IP addresses that do not belong to you, which happens when emails are forwarded to a different domain.
		<%
		}else if(request.getParameter("dt").equals("qc")){
			%>
		This report contains IP address that sent out-bound emails for <code><%= request.getAttribute("curRepDomain") %></code> but were considered forged and were subject to 
		further filtering. You should not see any IP address belonging to your network in this list.  
			<%	
		}else if(request.getParameter("dt").equals("rc")){
			%>
		This report contains IP address that sent out-bound emails for <code><%= request.getAttribute("curRepDomain") %></code> and were rejected by the receiving server
		because they were considered to be forged. You should not see any IP address belonging to your network in this list.  
			<%
		}else if(request.getParameter("dt").equals("sp")){
			%>
		This report contains a list of IP addresses that sent out-bound email for <code><%= request.getAttribute("curRepDomain") %></code> and SPF check passed.
			<%
		}else if(request.getParameter("dt").equals("sf")){
			%>
		This report contains a list of IP addresses that sent out-bound email for <code><%= request.getAttribute("curRepDomain") %></code> and SPF check failed. This is usually considered
		a forgery and most likely the receiving server will reject any email coming from these IP. You should NOT see any IP address belonging to your network in this list.
			<%
		}else if(request.getParameter("dt").equals("dp")){
			%>
		This report contains a list of IP addresses that sent out-bound email for <code><%= request.getAttribute("curRepDomain") %></code> and the messages were correctly signed using DKIM.
			<%
		}else if(request.getParameter("dt").equals("df")){
			%>
		This report contains a list of IP addresses that sent out-bound email for <code><%= request.getAttribute("curRepDomain") %></code> and DKIM signature check failed or DKIM signature
		was missing. You should NOT see any IP address belonging to your network in this list.
			<%
		}
		%>
		
		</div>
	</div>
	<div class="col-md-3"></div>
</div>

<%

Hashtable<String, Integer> theHash = (Hashtable<String, Integer>) request.getAttribute("theHash");
%>


<table class="table table-condensed table-bordered table-striped">
	<tr>
		<th>IP Address</th>
		
		<% if(request.getParameter("wh") != null){ %>
		<th>Hostname</th>
		<%} %>
		<th>Total Emails</th>
	
	</tr>
	
	<%

	List<String> keys = new ArrayList<String>();
	keys.addAll(theHash.keySet());
	Collections.sort(keys);
	
	
	for(String oneIP : keys){
		Integer theInt = theHash.get(oneIP);
		if(theInt == null || theInt.intValue() == 0){
			continue;
		}
		%>
	<tr>
		<td><%= oneIP%></td>
		<% if(request.getParameter("wh") != null){ %>
		<td><%= ResourceBean.getReverseIP(oneIP) %></td>
		<%} %>
		
		<td><%= theInt %></td>
	</tr>
		
		<%
	}
	%>
</table>


<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
