<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>DNS API Integration</h1>



<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-info text-center"><%=infoMsg %></div>
	<%
}


String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}

%>
<br>


<div class="row">
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">What is DNS API Integration</div>
			<div class="well-info-body">
			
				<p>
				Many DNS providers publish an API allowing third-party software, like Xeams, to modify records programmatically. 
				Many features in Xeams require changing TXT records in a DNS server. You can easily modify TXT records in a DNS server using this feature.
				</p>
				
				<p>
				<center>
				<a href="https://youtu.be/DUBP55ZIkgs" target="_blank" class="btn btn-warning">Video</a><br>
				<small>Watch a short video on this topic.</small>
				</center>
				</p>
			</div>
		</div>
	
	</div>
	
	<div class="col-md-6">
		
		
		
		<form class="form-inline"  action="<%= request.getAttribute("appPath") %>" method="post">
		<%
		List<String> providers = (List<String>) request.getAttribute("ap");
		%>
		
		
		<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('repDomain')"><b>?</b></div>
			<span class="form-control pull-left form-middle form-text wth-5">Available Providers</span>
			<select class="form-control pull-left wth-4" name="pn">	
				<%
				for(String provider : providers){
					
					%>
					<option value="<%= provider%>" ><%=provider %></option>
					<%
				}
				%>
			</select>&nbsp;
			<button type="submit" class="btn btn-default">Add Integration</button>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="repDomain">
				Select the desired provider and click the Add button
			</div>
			<input type="hidden" name="operation" value="dnsapi">
			<input type="hidden" name="st" value="add">
			
			
		</form>	
		
	</div>
</div>

<%

List<DnsApiProvBean> provs = (List<DnsApiProvBean>) request.getAttribute("provs");
if(provs.size() > 0){
	%>
	<h2>Existing Providers</h2>
	<table class="table table-bordered table-hover">
		<tr>
			<th>Friendly Name</th>
			<th>Provider Name</th>
			<th>Login ID</th>
			<th>Domains</th>
			<th>Status</th>
			<th>Action</th>
		</tr>
		
		<%
		
		int index = 0;
		for(DnsApiProvBean bean : provs){
			index++;
			
			%>
			<tr>
			<td><%= bean.getFriendlyName() %></td>
			<td><%= bean.getProviderName() %></td>
			<td><span id="lf_<%=index%>"><%= bean.getIdentifyingFieldValueMasked() %></span> <span id="uml_<%=index %>" class="pull-right"><a  onclick="unmask(<%= index %>, '<%= bean.getIdentifyingFieldValue() %>');">(Unmask)</a></span></td>
			<td><%= bean.getAssociatedDomains().size() %>
			<span class="pull-right"><a href="<%=response.encodeURL("FrontController?operation=dnsapi&st=rfd&pk=" + bean.getPk()) %>" title="Refresh domain list"><i class="glyphicon glyphicon-refresh"></i></a></span>
			</td>
			<td><%= bean.isUpAndRunning() ? "<i class='glyphicon glyphicon-thumbs-up'></i> Success" : ("<i class='glyphicon glyphicon-thumbs-down'></i> " + bean.getErrorMsg() ) %></td>
			<td>
				<a href="<%=response.encodeURL("FrontController?operation=dnsapi&st=m&pk=" + bean.getPk()) %>" title="Modify Parameters"><i class="glyphicon glyphicon-pencil"></i> Edit</a> |
				<a href="<%=response.encodeURL("FrontController?operation=dnsapi&st=dp&pk=" + bean.getPk()) %>" title="Permanantly remove the provider"><i class="glyphicon glyphicon-pencil"></i> Delete</a> 
				
			</td>
		</tr>
			<%
		}
		%>
	</table>
	<%
}
%>

<script>
function unmask(index, value){
	let span = document.getElementById("lf_" + index);
	span.textContent = value;
	
	document.getElementById("uml_" + index).style.display = "none";
}
</script>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
