<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->


<%
boolean success = request.getAttribute("success").equals("true");
%>
<h1><%= success ? "Success" : "Unable to update DNS" %></h1>



<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-info text-center"><%=infoMsg %></div>
	<%
}


String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}

%>


<%
if(success){
	%>
	<p>DNS server has been updated successfully. DNS propagation usually takes some time, even when the value for TTL is very small. Therefore, wait some time
	before running the following commands to confirm new values are in affect.
	</p>
	
	<h2>Steps to confirm</h2>
	<ul>
		<li>Open a Command Prompt (or a Terminal on Linux) and type the following command:
				<pre>nslookup -q=<%= request.getAttribute("rType") %> <%= request.getAttribute("fn") %></pre>
		</li>
		<li>You should see the following results:
			<pre><%= request.getAttribute("value") %></pre>
		</li>
		
	</ul>

	
	<%
}else{
	%>
	Unable to update DNS server. Error: <%= request.getAttribute("failureMsg") %>
	<%
}
%>


<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
