<!-- ******** NEW_SKIN_2015 ******** -->

<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>

<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>


<%
String friendlyName = (String)request.getAttribute("friendlyName");
String profileId = (String)request.getAttribute("profileId");
String profileIndex = (String)request.getAttribute("profileIndex");
String recipient = (String)request.getAttribute("recipient");
String sender = (String)request.getAttribute("sender");
String loginName = (String)request.getAttribute("loginName");
String password = (String)request.getAttribute("password");

if(friendlyName == null) friendlyName = "";
if(profileId == null) profileId = "";
if(recipient == null) recipient = "";
if(sender == null) sender = "";
if(profileIndex == null) profileIndex = "";
if(loginName == null) loginName = "";
if(password == null) password = "";

%>

<h1><%= productName %> Profile Editor</h1>

<br>
<div class="col-md-6">
	<form action="<%= request.getAttribute("appPath") %>" method="post">
	
	<br style="clear:both;">
	<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('friendlyName')"><b>?</b></div>
	<span class="form-control form-middle form-text pull-left wth-4">Friendly Name</span>
	<input class="form-control form-right pull-left wth-5" type="text" name="friendlyName" value="<%=friendlyName%>">

	<br style="clear:both;">
	<div class="alert alert-info more_info" id="friendlyName">
		This is a name given to this profile. <%= productName %> will use this name
		to refer to it in all reports and in the Admin Console.
	</div>
	
	
	<br style="clear:both;">
	<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('loginName')"><b>?</b></div>
	<span class="form-control form-middle form-text pull-left wth-4">Login ID</span>
	<input class="form-control form-right pull-left wth-5" type="text" name="loginName" value="<%=loginName%>">

	<br style="clear:both;">
	<div class="alert alert-info more_info" id="loginName">
		You can delegate filter management tasks of a single domain to someone else. This is the login id and 
		password for <%= productName %> Admin Console, which will be
		used to manage this domain. <br><br>When someone logs in using these credentials he/she can only modify email filtering
		rules that apply only that his/her domain. This person won't be able to change any global setting that apply to the server.
	</div>
	
	
	<br style="clear:both;">
	<div class="btn btn-info form-control pull-left form-left wth-1" disabled><b>?</b></div>
	<span class="form-control form-middle form-text pull-left wth-4">Password</span>
	<input class="form-control form-right pull-left wth-5" type="password" name="password" value="<%=password%>">
	
	
	<br style="clear:both;"><br>
	<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('senderString')"><b>?</b></div>
	<span class="form-control form-middle form-text pull-left wth-4">Sender String</span>
	<input class="form-control form-right pull-left wth-5" type="text" name="sender" value="<%=sender%>">

	<br style="clear:both;">
	<div class="alert alert-info more_info" id="senderString">
		<%= productName %> will try to match the FROM address with
		this string. Rules for this profile will apply if a matching string is found in the FROM field. If you wish to handle multiple domain
		with the same profile, you can enter a regular expression like:
		<br><br>
		<div style="overflow-x:scroll;">
		<span style="font-family:courier;">(@domainOne.com|@domainTwo.com|onlyOneUser@domainThree.com)</span>
		</div>
	</div>
	
	
	<br style="clear:both;">
	<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('recipient')"><b>?</b></div>
	<span class="form-control form-middle form-text pull-left wth-4">Recipient String</span>
	<input class="form-control form-right pull-left wth-5" type="text" name="recipient" value="<%=recipient%>">

	<br style="clear:both;">
	<div class="alert alert-info more_info" id="recipient">
		This string is compared to the TO/CC/BCC address in an email. Rules for this profile will apply if a matching 
		string is found in any of these fields. If you wish to handle multiple domain
		with the same profile, you can enter a regular expression like:
		<br><br>
		<div style="overflow-x:scroll;">
		<span style="font-family:courier;">(@domainOne.com|@domainTwo.com|onlyOneUser@domainThree.com)</span>
		</div>
	</div>
	
	
	<br style="clear:both;">
	<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('allowViewing')"><b>?</b></div>
	<span class="form-control form-text form-middle pull-left wth-8">Allow Viewing Emails</span>
	<span class="chkbox-cust form-control form-right pull-left wth-1"><input id="chk-email" type="checkbox" name="allowViewing" 
		<%=request.getAttribute("allowViewing") %> value="1"><label for="chk-email"></label></span>

	<br style="clear:both;">
	<div class="alert alert-info more_info" id="allowViewing">
		If checked, the admin will be able to view emails belonging to every user.
	</div>
	
	
	<%
	String allowCreatingNonInheritedProfiles = System.getProperty("allow.creating.non.inherited.profiles", "false").equals("true") ? "" : " onclick='return false;'";
	%>
	<br style="clear:both;">
	<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('inherited')"><b>?</b></div>
	<span class="form-control form-text form-middle pull-left wth-8">Inherited</span>
	<span class="chkbox-cust form-control form-right pull-left wth-1"><input id="chk-inherited" type="checkbox" name="inherited" 
		<%=request.getAttribute("inherited") %> value="1"  <%=allowCreatingNonInheritedProfiles %>><label for="chk-inherited"></label></span>

	<br style="clear:both;">
	<div class="alert alert-info more_info" id="inherited">
		Indicates if profile is inherited. This is a read-only field.
	</div>
	
	
	

	<br style="clear:both;">
	<input class="btn btn-md btn-submit pull-right" type="submit" value="Submit" />

	<input type="hidden" name="operation" value="62">
	<input type="hidden" name="profileId" value="<%=profileId%>">
	<input type="hidden" name="profileIndex" value="<%=profileIndex%>">
	</form>
	
	<br style="clear:both;"><br>
</div>

<br>
<div class="col-md-6">
	<div class="well-info-green">
		<div class="text-center well-info-header">Usage Example</div>
		
		<div class="well-info-body">
			<p>Let's say you create two profiles with the following settings:</p>
			<div class="table-responsive">
				<table class="table table-bordered">
				<tr>
				<td><b><u>Friendly Name</u></b></td><td>Profile A</td> <td>Profile B</td>
				</tr>
				<tr>
				<td><b>Sender</b></td><td>@comanyA.com</td> <td>&lt;Blank&gt;</td>
				</tr>
				<tr>
				<td><b>Recipient</b></td><td>@comanyB.com</td> <td>@companyC.com</td>
				</tr>
				</table>
			</div>
			
			<br>
			<p>Assuming the above scenario following email will be handled by <b>Profile A</b></p>
			<div class="well" style="font-family:courier;">
			From: someone@companyA.com<br>
			To: someone@somewhere.com<br>
			Subject: Hello<br><br>
			Hello there!
			</div>


			<br>
			<p>Assuming the above scenario following email will be handled by <b>Profile B</b></p>
			<div class="well" style="font-family:courier;">
			From: someone@somewhere.com<br>
			To: someone@companyC.com<br>
			Subject: Hello<br><br>
			Hello there!
			</div>

			<br>
			<p>Assuming the above scenario following email will be handled by the <b>default profile</b></p>
			<div class="well" style="font-family:courier;">
			From: someone@somewhere.com<br>
			To: someone@someOtherCompany.com<br>
			Subject: Hello<br><br>
			Hello there!
			</div>
		</div>
	</div>
</div>

<%@ include file="InnerRightGrey.jsp" %>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
