<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>End-To-End Encryption <small>Recipients</small></h1>



		End-To-End encryption allow you to send encrypted emails to recipients that can only be viewed
		if they know the decryption password. There are two ways to send encrypted emails:
		<br><br>
		<div class="row">
			<div class="col-md-5">
			
				<div class="panel panel-default">
				    <div class="panel-heading">Method 1</div>
				    <div class="panel-body">Compose an email ending with <code><%= request.getAttribute("subjectSuffix") %>(aPassword)</code> in the subject line. Replace <code>aPassword</code>
				    with a desirable value. Recipient will need this password to view the message.
					<br><br>
					Your message will be rejected if it contains 
					<acronym title="Pre-defined words specified by the administrator that are considered sensitive for your company">sensitive data</acronym> 
					but is not encrypted, forcing you to encrypt your message.
					</div>
				</div>
			
			
			</div>
			<div class="col-md-5">
				<div class="panel panel-default">
				  <div class="panel-heading">Method 2</div>
				  <div class="panel-body">Associate a password with recipients below. For example, if you need to send an encrypted email
				  to <code>your.patient@gmail.com</code>, specify a password below. <br><br>Then:
				  	<ul>
				  		<li>Compose an email containing <acronym title="Pre-defined words specified by the administrator that are considered sensitive for your company">sensitive data</acronym>  without any suffix</li>
				  		<li>If no sensitive data is present, simply put <code><%= request.getAttribute("subjectSuffix") %></code> at the end of the subject
				  		without password.
				  	</ul>
				  </div>
				</div>
			</div>
			
			<div class="col-md-2">
				<center>
					

					
					<button type="button" class="btn btn-info btn-lg" data-toggle="modal" data-target="#myModal"
					title="Click to watch a short video on this topic"
					>Watch Tutorial
					</button>
					
					
					
					
					<div class="modal" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="false">
					  <div class="modal-dialog modal-lg" role="document">
					    <div class="modal-content">
					      <div class="modal-header">
					        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					        <h4 class="modal-title" id="myModalLabel">End-To-End Encryption</h4>
					      </div>
					      <div class="modal-body">
					        <div align="center" class="embed-responsive embed-responsive-16by9">
							 <video controls>
							  <source src="https://www.xeams.com/files/e2ee-user.mp4" type="video/mp4">
							
							Your browser does not support the video tag.
							</video> 
							</div>
					      </div>
					      <div class="modal-footer">
					        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					      </div>
					    </div>
					  </div>
					</div>
					
					
					
					
				</center>
			</div>
		</div>
		

<div class="row">
	
	<div class="col-md-10">
		<form action="<%= request.getAttribute("appPath") %>" method="post">
			<table class="table table-condensed">
			<caption><h3>Associate password with a recipient</h3></caption>
				<tr>
					<td>
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblEmail')"><b>?</b></div>
						<span class="form-control form-middle form-text pull-left wth-4">Email</span>
						<input class="form-control form-right pull-left wth-5" type="email" name="email"  style="text-transform:lowercase"
						title="Specify email address of a recipient" required>
					
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="lblEmail">
							Email address of the recipient
						</div>
					</td>
					<td>
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblPwd')"><b>?</b></div>
						<span class="form-control form-middle form-text pull-left wth-4">Password</span>
						<input class="form-control form-right pull-left wth-5" type="password" name="pwd" title="This value will be used to encrypt messages"  required>
					
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="lblPwd">
							This value will be used to encrypt messages sent to this recipient
						</div>
					</td>
					<td>
					<button class="btn btn-sm btn-submit pull-right" type="submit">Add</button>
					</td>
				</tr>
			
			</table>
			<input type="hidden" name="operation" value="e2eenc">
		</form>
	</div>
</div>

<%
List<String> recipients = (List<String>) request.getAttribute("recipients");
if(recipients != null && recipients.size() > 0){
	%>
	<h2>Existing Records</h2>
	
	<div class="row">
		<div class="col-md-8">
			<table class="table table-condensed table-bordered table-hover">
				<thead style="background-color:black;color:white">
					<tr><th>Recipient's Email</th><th>Action</th></tr>
				</thead>
				<%
				for(String oneEmail : recipients){
					%>
					<tr><td><%= oneEmail %></td><td><a href="<%=response.encodeURL("FrontController?operation=e2eenc&reme=" + oneEmail) %>" title="Remove this recipient">Remove</a></td></tr>
					<%
				}
				%>
			</table>
		</div>
		<div class="col-md-4">
			<div class="alert alert-success"><h4><i class="glyphicon glyphicon-pushpin"></i> Usage Tip:</h4>Re-enter an existing recipient's email address to reset the password</div>
		</div>
	</div>
	
	<%
}
%>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
