<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Pre-Approval Emails</h1>


<%
String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><h4>Error</h4><%=errorMsg %></div>
	<%
}
%>
<div class="row">
	<div class="col-md-6">
		<div class="well">
			<h2>What is it?</h2>
			<p>
			Occasionally, you may need a moderator to look at an incoming email before delivering it to the intended 
			recipient.
			</p>
			
			<p>Incoming emails that match the criteria you specify on right will be sent to the moderator. Who must decide
			to either <b>Approve</b> or <b>Reject</b> the email. An alert is sent to the administrator every 24 hours till
			a decision is made.			
			</p>

		</div>
	</div>
	
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Add New Rule</div>
			<div class="well-info-body">
				<form action="<%= request.getAttribute("appPath") %>" method="post">

					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblforwardTo')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Moderator</span>
					<input class="form-control form-right pull-left wth-5" type="text" name="forwardTo" value="" required>
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblforwardTo">
						Email address for the moderator, the person who will approve/reject the message. Multiple addresses can be separated by a comma.
					</div>
				
				
				
				
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblSender')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Sender</span>
					<input class="form-control form-right pull-left wth-5" type="text" name="sender" value="" required>
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblSender">
						Email address for the sender. This could be:
						<ul>
							<li>A valid email address</li>
							<li>A domain name, which MUST start with '@'</li>
							<li><code>ANY</code> - any sender</li>
							<li><code>LOCAL</code> - any sender on a local domain</li>
							<li><code>FOREIGN</code> - any sender on a foreign domain</li>
						</ul>
					</div>
				
				
				
				
				
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblRecipient')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Recipient</span>
					<input class="form-control form-right pull-left wth-5" type="text" name="recipient" value="" required>
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblRecipient">
						Email address for the recipient. This could be:
						<ul>
							<li>A valid email address</li>
							<li>A domain name, which MUST start with '@'</li>
							<li><code>ANY</code> - which means any recipient</li>
							<li><code>LOCAL</code> - any recipient on a local domain</li>
							<li><code>FOREIGN</code> - any recipient on a foreign domain</li>
						</ul>
					</div>
					
					
					
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblSubject')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Subject</span>
					<input class="form-control form-right pull-left wth-5" type="text" name="subject" value="" required>
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblSubject">
						Subject of an incoming message to fetch. Use the word <code>ANY</code> if you want match any value for subject.
					</div>
					
					
					
					
					
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblSubjectIsRegex')"><b>?</b></div>
					<span class="form-control form-text form-middle pull-left wth-8">Subject is Regex</span>
					<span class="chkbox-cust form-control form-right pull-left wth-1">
						<input id="subjectIsRegex" name="subjectIsRegex" type="checkbox" >
						<label for="subjectIsRegex"></label>
					</span>
	
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblSubjectIsRegex">
						If checked, the value for <b>Subject</b> is treated as a regular expressions. For example, consider adding the 
						following regular expression for subject if you expect two variations in the subject.
						<pre>(New Invoice)|New Quote)</pre> 
						In this above example, emails containing following subjects will be processed:<br><br>
						<ul>
							<li>Your new invoice is attached</li>
							<li>A new quote for storage</li>
						</ul>
						
					</div>
				
				
				
				
				
				
				
					<!-- ******* Save Button | default is pulled right ******* -->
					<br style="clear:both;">
					<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
					<br><br>
					
					<input type="hidden" name="operation" value="268">
					<input type="hidden" name="a" value="a">
				</form>
				
				
			</div>
		</div>
	</div>
</div>



<%
List<ApprovalDataBean> holders = (List<ApprovalDataBean>) request.getAttribute("holders");
if(holders.size() > 0){
	%>
	<h2>Existing Pre-Approval Rules</h2>
	
	<table class="table table-condensed table-hover table-bordered">
		<thead>
			<tr class="active">
				<th>Sender</th>
				<th>Recipient</th>
				<th>Subject</th>
				<th>Moderator</th>
				<th>Action</th>
			</tr>
		</thead>
		
		
		<%
		for(ApprovalDataBean holder : holders){
			%>
			<tr>
				<td><%= holder.getSender() %></td>
				<td><%= holder.getOriginalRecipient() %></td>
				<td><%= holder.getSubject() %> 
				<%
					if(holder.isSubjectIsRegex()){
						%><span class="label label-warning pull-right">regex</span><%
					}
				%></td>
				<td><%= holder.getForwardTo()%></td>
				<td><a href="<%= response.encodeURL("FrontController?operation=268&a=r&id=" + holder.getId()) %>">Remove</a></td>
				
			</tr>
			<%
		}
		%>
	</table>
	
	
	<%
}
%>








<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
