<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Prevent Employee Name Forgery</h1>
<br>

<div class="row">
	<div class="col-md-5">
		Enter employee names as they appear on your public website. Refer to 
		<a href="http://www.xeams.com/emp-name-spoofing.htm" target="_blank">this page</a> for details.
		<form action="<%= request.getAttribute("appPath") %>" method="post">

			<!-- ******* Create Text Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('empName')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">Employee Name</span>
			<input class="form-control form-right pull-left wth-5" type="text" name="empName" style="text-transform: lowercase;">
		
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="empName">
				Enter an employee name as it appears on your public website
			</div>
		
			<!-- ******* Save Button | default is pulled right ******* -->
			<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
		
			<input type="hidden" name="operation" value="257">
		</form>
	</div>
	<div class="col-md-7">
		<%
		List<String> data = (List<String>) request.getAttribute("data");
		if(data != null && data.size() > 0){
			%>
			
			<!-- ******* Create Window Panel ******* -->
			<div class="well-info-wrap">
				<div class="well-info-header">Existing Employees</div>
				<div class="well-info-body">
					<table class="table table-condensed table-bordered table-hover">
						<thead>
							<tr><th>Employee Name</th><th>Action</th></tr>
						</thead>
						
						<%
						for(String oneEmployee : data){
							%>
							<tr>
								<td><i class="glyphicon glyphicon-user"></i> <%= oneEmployee %></td>
								<td><a href="<%= response.encodeURL("FrontController?operation=257&remp=" + oneEmployee) %>" title="Remove <%= oneEmployee%>">Remove</a></td>
							</tr>
							<%
						}
						%>
					</table>
				</div>
			</div>
			
			<%
		}
		%>
	</div>
</div>











<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
