<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>End-To-End Encryption</h1>
<br>


		<%
		String infoMsg = (String) request.getAttribute("infoMsg");
		if(infoMsg != null){
			%>
			<br><br><div class="alert alert-success"><%=infoMsg %></div>
			<%
		}
		
		String errorMsg = (String) request.getAttribute("errorMsg");
		if(errorMsg != null){
			%>
			<br><br><div class="alert alert-success"><%=errorMsg %></div>
			<%
		}
		%>


<div class="row">


	<div class="col-md-6">
		<!-- ******* Create Window Panel ******* -->
		<div class="well-info-wrap">
			<div class="well-info-header">E2E Encryption Settings</div>
			<div class="well-info-body">
			
				<form action="<%= request.getAttribute("appPath") %>" method="post">
				
				
					<!-- ******* Enable Tracking ******* -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('e2eEnabled')"><b>?</b></div>
					<span class="form-control form-text form-middle pull-left wth-8">Enabled</span>
					<span class="chkbox-cust form-control form-right pull-left wth-1">
						<input id="enabled" type="checkbox" name="enabled" <%= request.getAttribute("enabled") %>>
						<label for="enabled"></label>
					</span>
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="e2eEnabled">
						If checked, E2E Encryption will be enabled
					</div>
					
					
					
					<!-- Subject Suffix-->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('subjectSuffix')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-6">Trigger Word in Subject:</span>
					<input class="form-control form-right pull-left wth-3" type="text" value="<%= request.getAttribute("subjectSuffix") %>" name="subjectSuffix" required >
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="subjectSuffix">
						<p>The word in the subject that will trigger end-to-end encryption. Users can optionally specify the 
						encryption password enclosed by a pair of parentheses.</p>
						
						<p>This field accepts a regular expression, allowing you to specify multiple words. For example:
							<pre>confidential|classified</pre>
							In this case, both words will trigger an end-to-end encryption.
						</p>
					</div>
					
					
					
					
					<!-- ******* Use web-based E2E ******* -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('uwe2e')"><b>?</b></div>
					<span class="form-control form-text form-middle pull-left wth-8">Use web-based messaging</span>
					<span class="chkbox-cust form-control form-right pull-left wth-1">
						<input id="uwe2e_enabled" type="checkbox" name="uwe2e" <%= request.getAttribute("uwe2e") %>>
						<label for="uwe2e_enabled"></label>
					</span>
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="uwe2e">
						<p>If checked, the recipient of the message will have to view the encrypted email on
						your public-facing Xeams web interface. An encrypted PDF will not be generated.
					</div>
					
					
					<!-- Subject Suffix-->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('retDays')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-6">Retention Days:</span>
					<input class="form-control form-right pull-left wth-3" type="number" value="<%= request.getAttribute("retdays") %>" name="retdays" required >
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="retDays">
						Number of days to retain messages on your server. Recipients will not be able to view their emails once this many days have elapsed.
					</div>
					
					
					
					<%
					if(System.getProperty("allow.disabling.pwd.prompt.4.e2e") != null){
					%>
						<!-- ******* Prompt user for password (pufp) ******* -->
						<br style="clear:both;">
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('pufp')"><b>?</b></div>
						<span class="form-control form-text form-middle pull-left wth-8">Prompt Recipient To Create Password</span>
						<span class="chkbox-cust form-control form-right pull-left wth-1">
							<input id="pufp_enabled" type="checkbox" name="pufp" <%= request.getAttribute("pufp") %>>
							<label for="pufp_enabled"></label>
						</span>
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="pufp">
							<p>If checked, the recipient will have to create a password on your Xeams. Here is how it works.</p>
							<p>
							<ul>
								<li>An outbound email is to sent to, for example: <code>someone@gmail.com</code></li>
								<li>Xeams will encrypt this message and send an invitation to <code>someone@gmail.com</code> to create a password for end-to-end encryption.</li>
								<li>Once the recipient (<code>someone@gmail.com</code>) creates a password, the original email will be encryted using that password.</li>
								<li>Future emails will be encrypted using the same password.</li>
							</ul>
							</p>
							<p>The sender will receive an error if this box is not checked and email needs to be encrypted.</p>
						</div>
					<%
					}else{
						%>
						<input type="hidden" name="pufp" value="1">
						<%
					}
					%>
					
					
					
					
					
					<!-- ******* Require Encryption ******* -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('requireE2E')"><b>?</b></div>
					<span class="form-control form-text form-middle pull-left wth-8">Require encryption for sensitive content</span>
					<span class="chkbox-cust form-control form-right pull-left wth-1">
						<input id="mandatory" type="checkbox" name="mandatory" <%= request.getAttribute("mandatory") %> >
						<label for="mandatory"></label>
					</span>
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="requireE2E">
						If checked, encryption will be mandatory sensitive words are found in the content.
					</div>
					
					
					
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('sensitiveWords')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Sensitive Words:</span>
					
					<textarea class="form-control form-right pull-left wth-5" rows="6" cols="15" name="words"><%= request.getAttribute("words") %></textarea>
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="sensitiveWords">
						Incoming messages will be rejected if any content matches with any of the following words but user did not encrypt
						the message.<br>Following templates exist for you to use.
						<br><br>
						<ul>
						<%
						Properties props = (Properties) request.getAttribute("sensitiveWords");
						if(props != null){
							Enumeration words = props.keys();
							while(words.hasMoreElements()){
								String oneWord = words.nextElement().toString();
								out.println("<li>" + oneWord + "</li>");
							}
						}
						%>
						</ul>
					</div>
					
					
					
					
					<!-- Subject -->
					<!-- 
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblSubject')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Subject Contains:</span>
					<input class="form-control form-right pull-left wth-5" type="text" name="subject" required>
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblSubject">
						Subject of the outbound emails. Xeams will search for this string in every outbound email.
					</div>
					-->
			
					
					
					
					
					
					
					
		
				
					<br style="clear:both;">
					<br style="clear:both;">
					<!-- ******* Save Button | default is pulled right ******* -->
					<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
					
					<br style="clear:both;">
				
					<input type="hidden" name="save" value="1">
					<input type="hidden" name="operation" value="253">
				</form>
			</div>
		</div>
		
	</div>
	
	
	<div class="col-md-6">
	
		<!-- 
		End-to-end email encryption ensures no one can view outbound email but the intended recipient. When enabled, Xeams will take the following steps:
			<br>
			<ul>
				<li>Encrypts the message right after receiving it</li>
				<li>Emails are converted to password protected PDF attachment using strong 256 AES encryption</li>
				<li>Message can only be opened if the recipient knows the password</li>
				<li>Even administrators will not be able to open/view the message</li>
			</ul>
		<h2>How it works</h2>
		Assume a user need to send an email with sensitive contents to a client. Following steps 
		demonstrate how to do that.
		<br><br>
		<ul>
			<li>Enable this plugin</li>
			<li>Ask the sender to append the subject of the email with the <b>Subject Suffix</b> value you on the right, along with a
			password. For example:<p>
				<table class="table table-condensed table-bordered table-hover">
					<tr><th>Intended Subject</th><td><code>Your tax returns for 2018</code></td></tr>
					<tr><th>Actual Subject</th><td><code>Your tax returns for 2018 <%= request.getAttribute("subjectSuffix") %>(topSecret)</code></td></tr>
				</table>
				</p>
				<p>
				In this example, <code>topSecret</code> is the password that will be used to decrypt the message. </p>
			</li>
			
			<li>Xeams will convert this email into an encrypted PDF file that will be attached to a new email, which is then sent to the end-user</li>
			<li>The recipient will need a password to decrypt the PDF file. </li>
			
		</ul> 
		
		 -->
		
		<h2>Managing Passwords</h2>
		<div class="row">
			<div class="col-md-8">
				<p>There are multiple ways to specify a password for encryption:</p>
					<ul>
						<li>Specify it on the subject line.</li>
						<li>Prompt the recipient to create a password.</li>
						<li>The administrator <a href="<%=response.encodeURL("FrontController?operation=mnge2ep") %>">assign passwords manually.</a></li>
						<li>A local user assigns password</li>
					</ul>
			</div>
			<div class="col-md-4">
				<a href="<%=response.encodeURL("FrontController?operation=mnge2ep") %>" class="btn btn-warning"><i class="glyphicon glyphicon-lock"></i> Passwords</a>
			</div>
			
		</div>
		
		<p>&nbsp;</p>
		<p>&nbsp;</p>
		
		<h2>Usage Instructions</h2>
		<p>Watch short videos explaining how to use and configure this feature.</p>
		<div class="row">
			<div class="col-md-6">
				<center>
				<a href="https://xeams.com/e2e-user.htm" target="_blank">
					<button class="btn btn-info" title="Video explaining how to use this feature"><i class="glyphicon glyphicon-film"></i> Using Encryption</button></a>
				<br>Created for end-users.
				</center>
				
			</div>
			
			<div class="col-md-6">
				<center><a href="https://www.xeams.com/configuring-end-to-end-encryption.htm" target="_blank">
					<button class="btn btn-info" title="Video explaining how to config this feature as an administrator"><i class="glyphicon glyphicon-film"></i> Configuration</button></a>
				<br>Created for administrators.
				</center>
			</div>
		</div>
		
	</div>
	
	
	
	
	
	
</div>



<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
