<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Preparing Xeams Cloud</h1>




<!-- ******* Divide Page into Two Columns, Total Widths must Equal 12 (or less) ******* -->
<div class="row">
	<div class="col-md-6 col-md-offset-3">
		<!-- ******* Create Window Panel ******* -->
		<div class="well-info-wrap">
			<div class="well-info-header">Download Configuration</div>
			<div class="well-info-body">
				<p>You are just a few steps away from using Xeams Cloud. 
					Click the button you see below. Then, upload this downloaded file to Xeams Cloud.
				</p>
				
				<p>
					The downloaded file will contain the following information
				</p>
				<ul>
					<li>Configured domains on your on-premise Xeams</li>
					<li>Local users</li>
					<li>Rules for junk filtering</li>
				
				</ul>
				
				
				<form action="<%= request.getAttribute("appPath") %>" method="post" class="form">
					<%
					List<NameIntegerPair> pairs = (List<NameIntegerPair>) request.getAttribute("pairs");
					if(pairs != null && pairs.size() > 0){
						%>
						<p><b>Note:</b><br>You can only export data for a single profile to an account on Xeams Cloud. Please select a desired profile
						from the list below.</p>
						
						
						<div class="row">
							<div class="col-md-5">
								<div class="form-group">
								<select  class="form-control" name="p">
									<% 
									for(NameIntegerPair pair : pairs){
										%>
										<option value="<%= pair.getIntValue() %>"><%= pair.getName() %></option>
										<%
									}
									%>
								</select>
								</div>
							</div>
						</div>
						<%
					}
					%>
					
					<br><br>
					<center>
						<button class="btn btn-warning" >Download Configuration</button>
					</center>
					
					<input type="hidden" name="exp" value="1" />
					<input type="hidden" name="operation" value="export2cloud" />
					
				</form>
				
			</div>
		</div>
	
	
	</div>
	
	
</div>

	







<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
