<%@ page import="com.synametrics.xeams.bean.*" %>
<%@ page import="java.util.*" %>
<%

List sideButtons = new ArrayList(5);
sideButtons.add(new UrlAnchorHolder("Honey Pot IP", "current", true));


//Variables for FAQ
boolean showFAQ = true;
List faqLinks = new ArrayList(3);
FAQHandler.getInstance().displayFAQ(faqLinks, "MainMenu");
%>

<%@ include file="CommonButtons.jsp" %>
<%@ include file="NewPageHeader.jsp" %>

<%@ include file="CurrentProfileName.jsp" %>
<%@ include file="LicenseWarning.jsp" %>

<h1>Honey Pot IP Addresses</h1>

<br style="clear:both;">
<div class="row">
	<div class="col-md-12">
		<div class="well">
		This page displays a collection of IP addresses gathered by <%=productName %> as part of the honey pot mechanism.
		When a message gets trapped into the honey pot, the sender's IP address is added to this list. Every time an email
		comes in from a particular IP it's score gets added by 40.
		</div>
		
		<div class="well-info-wrap">
			<div class="well-info-header">Collected IP Addresses</div>
			<div class="well-info-body no-padding">
				<div class="well-info-additional">IMPORTANT: These IP address are managed by <%=productName %>.</div>
				<div class="table-responsive">
					<table class="table table-hover table-bordered table-striped">
						<tr>
							<th>IP Address</th>
							<th>Last Updated</th>
							<th>Current Score</th>
							<th class="text-center">Action</th>
						</tr>

						<%

						List<HoneyPotBean> beans = (List<HoneyPotBean>) request.getAttribute("beans");

						for(HoneyPotBean oneBean : beans){
						%>

						<tr>
							<td><%= oneBean.getIpAddress() %></td>
							<td><%= oneBean.getLastUpdated() %></td>
							<td><%= oneBean.getScore() %></td>
							<td><a href="<%=response.encodeURL("FrontController?operation=136") %>&hip=<%= oneBean.getHip()%>"><span class="glyphicon glyphicon-trash"></span></a></td>
						</tr>

						<%
						
						}
						%>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
