<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="com.synametrics.xeams.config.MultipleAdManager"%>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Create Multiple Domains</h1>
<br>



<div class="row">
	<div class="col-md-5">
		<!-- ******* Create Window Panel ******* -->
		<div class="well-info-wrap">
			<div class="well-info-header">Add Domains</div>
			<div class="well-info-body">
									
				<form action="<%= request.getAttribute("appPath") %>" method="post">
				
					<div class="form-group">
					    <label for="domainnames">Domains:</label>
					    <textarea rows="10" class="form-control" id="domainnames" name="domainnames" placeholder="Domain Names, one per line"  style="text-transform:lowercase"></textarea>
					</div>
			  
			  		
					    
			    	<%
					if(AppConfig.getInstance().getServerType() != AppConfig.ST_STAND_ALONE){
					%>
					
					<div class="form-group">
					    <label for="forwardto">Forward To:</label>
					    <input type="text" class="form-control" name="forwardto" placeholder="IP Address/Hostname" id="forwardto" required>
					</div>
					<%	
					}
					%>
					
					
					<%
						if(MultipleAdManager.getInstance().getCount() == 0){
							%>Not Available<%
						}else{
							%>
							<div class="form-group">
							<label for="madpk">Active Directory:</label>
							<select class="form-control" name="madpk" id="madpk">
								<%
								for(AdParams oneParam : MultipleAdManager.getInstance().getAdList()){
									%>
									<option value="<%= oneParam.getPk()%>"><%= oneParam.getFriendlyName() %></option>
									<%
								}
								%>
							
							</select>
							</div>
							<%
						}
					%>
					
						<button class="btn btn-sm btn-submit" type="submit">Add Domain</button>
						
						
					<input type="hidden" name="operation" value="256">
					</form>
			</div>
		</div>
	</div>
	
	<div class="col-md-5">
		<h3>Instructions</h3>
		<ul>
			<li>Paste domains, one per line to add them in bulk</li>
			<%
			if(AppConfig.getInstance().getServerType() != AppConfig.ST_STAND_ALONE){
			%>
			<li>Every newly added domain will get its values for <b>Forward To</b> and <b>Active Directory</b> from what you specify here.</b>
			<%	
			}else{
			%>
			<li>Every newly added domain will get its value <b>Active Directory</b> from what you specify here.</b>
			<%
			}
			%>
					
		</ul>
	</div>

</div>





<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
