<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Import Sender Filters</h1>



<%
String error = (String) request.getAttribute("errorMsg");
String infoMsg = (String) request.getAttribute("infoMsg");
if(error != null){
	%>
	<div class="alert alert-danger"><%= error %></div>
	<%
}

if(infoMsg != null){
	%>
	<div class="alert alert-info"><%= infoMsg %></div>
	<%
}



%>



<br>
Using this wizard you can import sender filters into Xeams using following guidelines.

<ul>
	<li>You must have a text file in on the machine where <%= productName %> is running.</li>
	<li>This file must have either one or two fields, separated by a comma (CSV). For example:
<pre>someuser@gmail.com,inhouseUser@yourcompany.com
anotheruser@hotmail.com</pre>
	</li>
	<li>Each record must be on a separate line. If there is only one field, the filter will be added at the global level. A two field record is considered to be specific to the
	user defined in the second field. This must be a valid local user in <%= productName %></li>
	<li>Specify a default values for these sender filters below.</li>
</ul>









<br class="hide_lg" style="clear:both;"><br>
<div class="row">
	<div class="col-md-1"></div>
	<div class="col-md-8">
		<div class="well-info-wrap">
			<div class="well-info-header">Filter Parameters</div>
			<form action="<%= request.getAttribute("appPath") %>" method="post">
			<div class="well-info-body">
				

				

				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('score')"><b>?</b></div>
				<span class="form-control pull-left form-middle form-text wth-5">File Name:</span>
				<input class="form-control pull-left form-right wth-4" type="text" name="txtFileName" value="<%= request.getParameter("txtFileName") == null ? "" : request.getParameter("txtFileName") %>" required>
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="score">
					Enter the absolute path for the CSV file.
				</div>

				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('weight')"><b>?</b></div>
				<span class="form-control pull-left form-middle form-text wth-5">Weight</span>
				<input class="form-control pull-left form-right wth-4" type="number" name="txtWeight" value="<%= request.getParameter("txtWeight") == null ? "" : request.getParameter("txtWeight") %>" required>
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="weight">
					Enter a positive score for blacklisted entries and a negative score for white listed senders
				</div>
				
						

				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('matchCase')"><b>?</b></div>
				<span class="form-control pull-left form-middle form-text wth-8">Match Cases</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="chk-match" type="checkbox" name="chkMatchCase" value="1" >
					<label for="chk-match"></label>
				</span>
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="matchCase">
					If this is checked, search will be case-sensitive.
				</div>

			

				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('expire')"><b>?</b></div>
				<span class="form-control pull-left form-middle form-text wth-5">Expires after</span>
				<select class="form-control pull-left wth-4" name="expirationDate">
				
				<option value="0">Never</option>
				<option value="1">1 Day</option>
				<option value="2">2 Days</option>
				<option value="3">3 Days</option>
				<option value="4">4 Days</option>
				<option value="5">5 Days</option>
				<option value="6">6 Days</option>
				<option value="7">7 Days</option>
				<option value="10">10 Days</option>
				<option value="15">15 Days</option>
				<option value="20">20 Days</option>
				<option value="30">1 Month</option>
				<option value="60">2 Months</option>
				<option value="90">3 Months</option>
				<option value="120">4 Months</option>
				<option value="150">5 Months</option>
				<option value="180">6 Months</option>
				<option value="365">1 Year</option>
				</select></span>
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="expire">
					You can optionally associate an expiration date with a filter. Expiration date is useful if you are getting
					hammered by any particular email, which has very innocent content. You can temporarily add a rule that will
					expire after some time.
				</div>
				
				<br style="clear:both;">
				<!--  <button class="btn btn-sm btn-submit  wth-4" style="margin-left:5%;" type="submit">Import</button> -->
				<button class="btn btn-sm btn-menu pull-right wth-4"  type="submit"><span class="glyphicon glyphicon-plus"></span> Import</button>
				
				
				<input type="hidden" name="operation" value="227">
				
				
				</form>
				<br style="clear:both;">
			</div>
		</div>
	</div>
</div> 













<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
