<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<style>
input[type=checkbox]{
	visibility:visible;
}
</style>

<h1>Importing users</h1>

<div class="row">
	<div class="col-md-6">
	
	<div class="well">
This page can be used to import users into <%= productName %> by importing values from a text file. Following rules apply when importing.<br><br>

<b>First: </b> The text file must be on the same machine where <%= productName %> is installed.<br><br>
<b>Second: </b> The text file must contain one email address per line. Optionally, it can have a password for that user preceded by a | character. For example, 
both of the following entries are correct.<br><br>
					
<pre>bob.smith@xyz.com
jane.smith@xyz.com|secret007</pre>
	If password field is missing in the text file, its value will be assigned from the password field on the right.
	</div>
	
	</div>
	<div class="col-md-6">		
		<div class="well-info-wrap">
			<div class="well-info-header">Input Parameters</div>
			<div class="well-info-body no-padding">
				<form action="<%= request.getAttribute("appPath") %>" method="post">
				
				<div style="padding:10px;">
					<%
					
					String serverHost = ResourceBean.getFirstIP(); //This will find out what is the IP address of the server machine
					if(request.getAttribute("serverHost") != null){
						serverHost = (String) request.getAttribute("serverHost");
					}
					%>
					
				
						<br style="clear:both;">
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('wizFile')"><b>?</b></div>
						<span class="form-control form-middle form-text pull-left wth-4">File name</span>
						<input class="form-control form-right pull-left wth-5" type="text" name="txtFileName" value="" placeholder="For example: C:\data\userList.txt">
	
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="wizFile">
							Text file name. This file name must be saved on the computer where <%= productName %> is installed.
						</div>
						
						<br style="clear:both;">
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('wizPwd')"><b>?</b></div>
						<span class="form-control form-middle form-text pull-left wth-4">Password</span>
						<input class="form-control form-right pull-left wth-5" type="text" name="txtPassword" value="">
	
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="wizPwd">
							Default password for every account.
						</div>
						
						
						<br style="clear:both;">
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('wizSrvHost')"><b>?</b></div>
						<span class="form-control form-middle form-text pull-left wth-4">Server Hostname</span>
						<input class="form-control form-right pull-left wth-5" type="text" name="txtServerHost" value="<%=serverHost%>">
	
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="wizSrvHost">
							This is the hostname of the server where
							<%= productName %> is running with respect to the end-user. Note that due to NAT the IP
							address of the machine might be different than the actual address from the user's
							perspective.
						</div>
						
						
						<br style="clear:both;">
						<div class="title+++++ btn btn-info form-control form-left pull-left wth-1" disabled><b>?</b></div>
						<span class="form-control form-text form-middle pull-left wth-8">Notification Emails</span>
						<span class="chkbox-cust form-control form-right pull-left wth-1">
							<input id="chk-notifyEmail" type="checkbox" name="chkNotify" checked>
							<label for="chk-notifyEmail"></label>
						</span>
						<br style="clear:both;">
						
						<input type="hidden" name="operation" value="213" />
					
				</div>
				
				<br style="clear:both;">
				
				
				<div style="padding:10px;">
					<button class="btn btn-sm btn-submit pull-right" type="submit">Create</button>
					<br style="clear:both;">
				</div>
				</form>
				
			</div>
		</div>
	</div>
</div>




<h1>Importing Associated Emails</h1>

<div class="row">
	<div class="col-md-6">
	
	<div class="well">
		You can import associated email addresses from a file. The input file must have 1 record per line and each record must have
		two tokens separated by a | character:
		<br><br>
		<ul>
			<li><b>Token 1</b> - must be a valid user login ID in Xeams</li>
			<li><b>Token 2</b> - must be a valid email address. This address will be associated with the user specified in token 1.</li>
		</ul>
		
		<br><br>
		For Example:
		<pre>john.doe@yourcompany.com|johnny@yourcompany.com
jane.doe@yourcompany.com|jenny@yourcompany.com</pre>
	</div>
	
	</div>
	<div class="col-md-6">		
		<div class="well-info-wrap">
			<div class="well-info-header">Input Parameters</div>
			<div class="well-info-body no-padding">
				
				<form action="<%= request.getAttribute("appPath") %>" method="post">
				<div style="padding:10px;">
					
					
						<!-- ******* Create Text Input Field ******* -->
						<br style="clear:both;">
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('fname')"><b>?</b></div>
						<span class="form-control form-middle form-text pull-left wth-4">Input File</span>
						<input class="form-control form-right pull-left wth-5" type="text" name="fname" title="Absolute path to a CSV file on the machine where Xeams is running">
					
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="fname">
							Absolute path of the file containing a CSV file.
						</div>
					
					
					
						<input type="hidden" name="operation" value="229">
					
				</div>
				
				<br style="clear:both;">
				
				
				<div style="padding:10px;">
					<button class="btn btn-sm btn-submit pull-right" type="submit">Import</button>
					<br style="clear:both;">
				</div>
				</form>
			</div>
		</div>
	</div>
</div>






<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
