
<%@ page import="com.synametrics.xeams.bean.*" %>
<%@ page import="java.util.*" %>
<%

List sideButtons = new ArrayList(5);
sideButtons.add(new UrlAnchorHolder("Intrusion Detection", "current", true));


//Variables for FAQ
boolean showFAQ = true;
List faqLinks = new ArrayList(3);
FAQHandler.getInstance().displayFAQ(faqLinks, "MainMenu");
%>

<%@ include file="CommonButtons.jsp" %>
<%@ include file="NewPageHeader.jsp" %>

<!-- INTRUSION DETECTION STARTS HERE -->

<h1>Intrusion Detection</h1>
<br>
<div class="well text-center">
<%= productName %> provides a pro-active approach to detect intrusions by malicious users.
</div>

<div class="row">
	<div class="col-md-5">
		<div class="well-info-wrap">
			<div class="well-info-header">Intrusion Detection</div>
			<div class="well-info-body">
				Most companies allow SMTP traffic pass through their firewall,
				which makes SMTP vulnerable to attacks from intruders. However, before any attack occurs
				a malicious user would try to find out as much information as he/she can by
				sending messages to your SMTP server. These users usually do not send any e-mails but
				connect to your server in order to collect information such as:

				<ul>
				<li>What type of server you are running
				<li>How does your server behave when an invalid command is sent by the client
				<li>Who are the users on your server and what are their passwords
				<li>Is your server an open relay
				</ul>

				Therefore, it is important to keep an eye on network connections to your SMTP server that
				do not send any e-mails. For more information please refer to a
				<a href="<%=ResourceBean.getResourceURL()%>IntrusionDetection.htm">white paper</a> on <%= productName %>'s
				web site.

				The following table
				shows a summary of connections that terminated without sending an actual email.
			</div>
		</div>
		
		<br>
		<div class="alert alert-danger">
			<font color="CC0000"><b>IMPORTANT</b></font> - 
			The intrusion logs are reset every time the Rules Engine starts. If you need these
			logs for future reference, you must copy the files in the $<%= productName.replace(' ','_').toUpperCase() %>/logs directory to a different location,
			where $<%= productName.replace(' ','_').toUpperCase() %> is the directory where <%= productName %> is installed.
		</div>
	</div>
	
	<div class="col-md-7">
		<br class="hide_lg">
		<table class="table table-striped table-bordered table-hover">
			<tr class="well-info-header">
			<th>Type of termination</th>
			<th>Number of occurrences</th>
			<th>Action</th>
			</tr>

			<tr>
			<td valign="top"><b>Terminated after creation:</b></td>
			<td valign="top"><%= request.getAttribute("afterCreation")  %></td>
			<td><a href="<%=response.encodeURL("FrontController?operation=39") %>&type=<%=IDStatus.SOCKETCONN%>&maxRecords=250"><button class="btn btn-sm btn-menu">Log Summary</button></a></td>
			</tr>

			<tr bgcolor="#EDECE3">
			<td valign="top"><b>Terminated after Hello:</b></td>
			<td valign="top"><%= request.getAttribute("afterHelo") %></td>
			<td><a href="<%=response.encodeURL("FrontController?operation=39") %>&type=<%=IDStatus.HELLO%>&maxRecords=250"><button class="btn btn-sm btn-menu">Log Summary</button></a></td>
			</tr>

			<tr>
			<td valign="top"><b>Terminated after providing recipient:</b></td>
			<td valign="top"><%= request.getAttribute("afterRecipient") %></td>
			<td><a href="<%=response.encodeURL("FrontController?operation=39") %>&type=<%=IDStatus.RCPT_TO%>&maxRecords=250"><button class="btn btn-sm btn-menu">Log Summary</button></a></td>
			</tr>

			<tr bgcolor="#EDECE3">
			<td valign="top"><b>Terminated after authentication:</b></td>
			<td valign="top"><%= request.getAttribute("afterAuth") %></td>
			<td><a href="<%=response.encodeURL("FrontController?operation=39") %>&type=<%=IDStatus.AUTH%>&maxRecords=250"><button class="btn btn-sm btn-menu">Log Summary</button></a></td>
			</tr>
			<!--
			<tr>
			<td valign="top"><b>Normal termination:</b></td>
			<td valign="top"><%= request.getAttribute("afterData") %></td>
			<td><a href="<%=response.encodeURL("FrontController?operation=39") %>&type=<%=IDStatus.DATA%>&maxRecords=250"><button class="btn btn-sm btn-menu">Log Summary</button></a></td>
			</tr>
			-->
			<tr>
			<td valign="top"><b>Terminated due to timeout:</b></td>
			<td valign="top"><%= request.getAttribute("timeout") %></td>
			<td><a href="<%=response.encodeURL("FrontController?operation=39") %>&type=<%=IDStatus.TIMEOUT%>&maxRecords=250"><button class="btn btn-sm btn-menu">Log Summary</button></a></td>
			</tr>

			<tr bgcolor="#EDECE3">
			<td valign="top"><b>Total Errors:</b></td>
			<td valign="top"><%= request.getAttribute("error") %></td>
			<td><a href="<%=response.encodeURL("FrontController?operation=39") %>&type=<%=IDStatus.ERROR%>&maxRecords=250"><button class="btn btn-sm btn-menu">Log Summary</button></a></td>
			</tr>
		</table>
	</div>
</div>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
