<%@ page import="com.synametrics.xeams.bean.*"%>
<%@ page import="java.util.*" %>

<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<h1>Intrusion Report</h1>
<br>
<div class="row">
	<div class="col-md-12">
		<div class="well-info-wrap">
<%

String recommendedMsg = "Click the <b> <i class=\"glyphicon glyphicon-remove-circle\"> </i></b> icon next to the IP address to block it. These IP addresses will remain blocked until Xeams is restarted.";
int type;

    try{
        type = Integer.parseInt((String)request.getAttribute("type"));
    }catch(Exception e){
        out.println("Invalid type specified");
        return;
    }


    if(type == IDStatus.SOCKETCONN){
%>
			<div class="well-info-header">Connections Terminated Immediately</div>
			<div class="well-info-body">
				<h3>Description</h3>
				Before two machines can talk to each other, a TCP/IP socket needs to be opened.
				
				<br><br>
				<h3>Vulnerabilities</h3>
				If you see too many connections being terminated from a single IP address it means
				that you can potentially be a victim of a "Denial of service attack", which occurs when a malicious user opens too
				many TCP/IP connections on your machine but does not use them. Number of TCP/IP connections on a machine cannot
				be more than 65536. Once all connections are used your server cannot accept any more emails.
				<hr>
				
				<h3>Recommended Action</h3>
				<div class="alert alert-success">
					<%= recommendedMsg %>
				</div>
				
				<h3>Caution</h3>
				<div class="alert alert-danger">
				A problem in either your or the client's network could result in such termination.
				Therefore, do not block any IP if the number of terminations is not high.
				</div>
				<%
					}else if(type == IDStatus.HELLO){
				%>

			<div class="well-info-header">Connections terminated after Hello</div>
			<div class="well-info-body">
				<h3>Description</h3>
				Hello is the first command sent by any client trying to send an email. In response, the server usually
				sends a set of SMTP verbs that it supports.
				
				<br><br>
				<h3>Vulnerabilities</h3>
				If you see too many connections being terminated from a single IP address it means
				that some malicious user is trying to find out what SMTP server you are using and if it that server
				is prone to some known vulnerabilities that can be exploited.
				
				<hr>
				<h3>Recommended Action</h3>
				<div class="alert alert-success">
					<%= recommendedMsg %>
				</div>
				
				<h3>Caution</h3>
				<div class="alert alert-danger">
				A problem in either your or the client's network could result in such termination. Therefore, do not block
				any IP if the number of terminations is not high.
				</div>
				<%

					}else if(type == IDStatus.AUTH){
				%>
			<div class="well-info-header">Connections terminated after authentication</div>
			<div class="well-info-body">
				<h3>Description</h3>
				Most SMTP server requires user authentication before allowing relay. If a connection terminates after
				authentication information is passed it means that a user who is trying to send an email could not
				provide a valid user id and password.
				
				<br><br>
				<h3>Vulnerabilities</h3>
				If you see too many connections being terminated from a single IP address it means
				that some malicious user is trying to guess a user id and password on your email server. Once a
				user id/password pair is compromised, anyone can send thousands of spam messages via your server.

				<hr>
				<h3>Recommended Action</h3>
				<div class="alert alert-success">
				Block this IP address in <%= productName %>.<br>
				Make it a policy to have your users change their passwords frequently.
				</div>
				
				<h3>Caution</h3>
				<div class="alert alert-danger">
				A problem in either your or the client's network could result in such termination.
				It could also mean that a legitimate user within your company
				forgot his/her password and is retrying. Therefore, do not block
				any IP if the number of terminations is not high.
				</div>
				<%

					}else if(type == IDStatus.MAIL_FROM){
				%>

				<%

					}else if(type == IDStatus.RCPT_TO){
				%>
			<div class="well-info-header">Connections terminated after recipients list was provided</div>
			<div class="well-info-body">
				<h3>Description</h3>
				A client sends a list of recipients before sending the actual message. The server then determines
				if it can accept an email for the recipients passed by the client.

				<br><br>
				<h3>Vulnerabilities</h3>
				If you see too many connections being terminated from a single IP address it means
				that can potentially be a victim of a "Dictionary attack", which occurs when a malicious user sends emails to thousands
				of users hoping that a small percentage will get through.<br>
				Another possibility is that someone is trying to find out if you server is an open relay.

				<hr>
				<h3>Recommended Action</h3>
				<div class="alert alert-success">
				Block this IP address in <%= productName %>.
				</div>
				
				<h3>Caution</h3>
				<div class="alert alert-danger">
				Incorrect email addresses in either TO, CC, or BCC can result in such termination.
				A problem in either your or the client's network could also result in such termination.
				Therefore, do not block any IP if the number of terminations is not high.
				</div>
				<%
					}else if(type == IDStatus.TIMEOUT){

				%>
			<div class="well-info-header">Connections terminated immediately</div>
			<div class="well-info-body">
				 <h3>Description</h3>
				Such termination occurs when the client does not send any data for a long time.

				<br><br>
				<h3>Vulnerabilities</h3>
				If you see too many connections being terminated from a single IP address it means
				that you can potentially be a victim of a "Denial of service attack", which occurs when a malicious user opens too
				many TCP/IP connections on your machine but does not disconnect. Number of TCP/IP connections on a machine cannot
				be more than 65536. Once all connections are used you server cannot accept any more emails.

				<hr>
				<h3>Recommended Action</h3>
				<div class="alert alert-success">
					<%= recommendedMsg %>
				</div>
				
				<h3>Caution</h3>
				<div class="alert alert-danger">
				A problem in either your or the client's network could result in such termination.
				Therefore, do not block any IP if the number of terminations is not high.
				</div>
				<%
					}
				%>
			</div>
		</div>
	</div>
	
	<div class="col-md-6">
		<br style="clear:both;">
		<div class="well-info-wrap">
			<div class="well-info-header">Summarized Report</div>
			<div class="well-info-body no-padding">
				<div class="well-info-additional">TOP 50 IP addresses from where connections were terminated<br></div>
				<table class="table table-striped table-bordered table-hover">
					<tr>
					<th>IP Address</th>
					<th>Number of terminations</th>
					<th>Country of origin</th>
					</tr>

					<%
					   List summaryArray = (java.util.List)request.getAttribute("summaryList");
					   int total = 0;
					   for(int i = summaryArray.size() - 1; i >= 0; i--, total++){

						   if(total > 50) break;
						   NameIntegerPair onePair = (NameIntegerPair)summaryArray.get(i);
						   String countryName = ResourceBean.getCountryNameFromIP(onePair.getName());
						   
						   String blUrl = "FrontController?operation=39&bip=" + onePair.getName() + "&type=" + request.getParameter("type") + 
				   					"&maxRecords=" + request.getParameter("maxRecords") +
									"";
						   
						   String logUrl = "FrontController?operation=39&logf=" + onePair.getName() + 
								   "&type=" + request.getParameter("type") + 
				   					"&maxRecords=" + request.getParameter("maxRecords") +
									"";
						   
						   blUrl = response.encodeURL(blUrl);
						   
						   out.println("<tr><td><a href=\"FrontController?operation=38&ip=" + onePair.getName() +
										"\" target=_blank>" + onePair.getName() + "</a> <span class='pull-right'>" + 
						   				"<a href='" + logUrl + "' title='View SMTPConversation.log for this IP'><i style='color: #000099;' class='glyphicon glyphicon-align-left'></i></a> &nbsp; " +
						   				(onePair.getFlag() == 0 ? ("<a href='" + blUrl + "' title='Click to block this IP from connecting' ><i style='color:#990000;' class='glyphicon glyphicon-remove-circle'></i>") : 
						   					"<i style='color:#DDDDDD;' class='glyphicon glyphicon-remove-circle' title='IP is blocked'></i>") +
						   				"</span></td><td>" + onePair.getValue() + "</td><td>" +
										countryName +  "</td></tr>");
					   }
					%>
				</table>
			</div>
		</div>
	</div>
	
	<div class="col-md-6">
		<br style="clear:both;">
		<div class="well-info-wrap">
			<div class="well-info-header">Detailed Report Log</div>
			<div class="well-info-body no-padding">
				<div class="well-info-additional">Last 250 connection attempts by IP address</div>
				<table class="table table-striped table-bordered table-hover">
					<tr>
					<th>IP Address</th>
					<th>Time stamp</th>
					</tr>
					<%
					   List logArray = (java.util.List)request.getAttribute("logArray");
					   for(int i = 0; i < logArray.size(); i++){
						   String oneLine = (String)logArray.get(i);
						   out.println(ResourceBean.formatLineToTableRow4ID(oneLine));
					   }
					%>
				</table>
			</div>
		</div>
	</div>
</div>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
