<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Language Filters</h1>



<div class="row">

	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Add New Filter</div>
			<div class="well-info-body">
				<form action="<%= request.getAttribute("appPath") %>" method="post">
				
				
				
					<br style="clear:both;"><br>
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lbllang')"><b>?</b></div>
						<span class="form-control form-middle form-text pull-left wth-5">Language</span>
						<select class="form-control pull-left wth-4" name="lang">
						
							<%
							List<String> langs = (List<String>) request.getAttribute("langs");
							for(String aLang : langs){
								%>
								<option value="<%= aLang %>"><%= aLang %></option>
								<%
							}
							%>
							
						</select>
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="lbllang">
							Select a language
						</div>
					
					
					<!-- ******* Create Text Input Field ******* -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblPercent')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Percentage</span>
					<input class="form-control form-right pull-left wth-5" type="number" name="percent" required="required">
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblPercent">
						A score will only be assigned the percentage of foreign characters are more than this value. For example, an
						email may contain both English and Chinese characters. If you specify 20 for this value, a score will
						only apply if the number of Chinese characters are more than 20% of the entire message.
					</div>
				
					
					<!-- ******* Create Text Input Field ******* -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblScore')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Score</span>
					<input class="form-control form-right pull-left wth-5" type="number" name="score" required="required">
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblScore">
						The score value if foreign characters are found.
					</div>
				
					
				
					<!-- ******* Save Button | default is pulled right ******* -->
					<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
				
					<br><br><br>
					<input type="hidden" name="operation" value="255">
				</form>
				
				
				<%
				List<LanguageFilterBean> langlist = (List<LanguageFilterBean>) request.getAttribute("langlist");
				if(langlist.size() > 0){
					
					%>
					<h3>Existing Filters</h3>
					<table class="table table-condensed table-bordered">
					<tr>
						<th>Language</th>
						<th>Percentage</th>
						<th>Score</th>
						<th>Action</th>
					</tr>
					<%
					for(int i = 0; i < langlist.size(); i++){
						LanguageFilterBean aBean = langlist.get(i);
						%>
						<tr>
						<td><%= aBean.getLanguage() %></td>
						<td><%= aBean.getPercentage() %>%</td>
						<td><%= aBean.getScore() %></td>
						<td><a href="<%=response.encodeURL("FrontController?operation=255&idx=" + i) %>">Remove</a></td>
					</tr>
						<% 
					}
					%>
					</table>
					<%
				}
				%>
				
				
			</div>
			
			
		</div>
	</div>
	
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Description</div>
			<div class="well-info-body">
				Assign score based on the language of an email. For example, you can assign a score if more than 20% message
				contains Chinese characters.
				<br><br>
				Languages are grouped in categories. Many languages share characters. For example, Latin characters are shared between
				English, French, Spanish, Germany, etc...
				<br><br>
				Following Languages are supported:
				<table class="table table-condensed table-hover table-bordered">
					<thead>
						<tr><th>Category</th><th>Languages</th></tr>
					</thead>
					<tr><td><%= LanguageDetectorBean.ARABIC  %></td><td>Arabic, Persian, Urdu</td></tr>
					<tr><td><%= LanguageDetectorBean.CHINESE %></td><td>Chinese, Japanese, Korean</td></tr>
					<tr><td><%= LanguageDetectorBean.ETHIOPIAN %></td><td>Ethiopian</td></tr>
					<tr><td><%= LanguageDetectorBean.GREEK %></td><td>Greek</td></tr>
					<tr><td><%= LanguageDetectorBean.HEBREW %></td><td>Hebrew</td></tr>
					<tr><td><%= LanguageDetectorBean.INDIAN %></td><td>Hindi, Telugu, Tamil, Bengali, Gujrati, Punjabi and other Indian languages.</td></tr>
					<tr><td><%= LanguageDetectorBean.BASIC_LATIN %></td><td>US/British English</td></tr>
					<tr><td><%= LanguageDetectorBean.EXTENDED_LATIN %></td><td>English characters with Umlaut, such as   </td></tr>
					<tr><td><%= LanguageDetectorBean.RUSSIAN %></td><td>Russian</td></tr>
					<tr><td><%= LanguageDetectorBean.THAI %></td><td>Thai</td></tr>
					
				</table>
			</div>
		</div>
	</div>
</div>







<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
