<!--NEWSKIN2015JP-->
<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<h1>Active Directory Integration</h1>
<%
String infoMessage = (String) request.getAttribute("infoMessage");
if(infoMessage != null){
	%>
	<div class="alert alert-info">
		<%=infoMessage %>
	</div>
	<%
}
%>


<br style="clear:both;">

<form action="<%= request.getAttribute("appPath") %>" method="post">


		

		
			<div class="well-info-wrap">
				<div class="well-info-header">AD Configuration</div>
				<div class="well-info-body no-padding">
					<div class="well-info-additional"><a href="http://www.xeams.com/ActiveDirectory.htm" target="_blank">Click here</a> to read more about Active Directory and how it is used in Xeams.</div>
					
					
					<div class="row">
	
					<div class="col-md-6">
					
						<div style="padding:10px;">
							<br style="clear:both;">
								<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('enableAD')"><b>?</b></div>
								<span class="form-control pull-left form-middle form-text wth-8">Enable AD Integration</span>
								<span class="chkbox-cust form-control form-right pull-left wth-1">
									<input id="chk-ADInt" type="checkbox" name="ldapLookupRequired" <%=request.getAttribute("ldapLookupRequired")%> value="1">
									<label for="chk-ADInt"></label>
								</span>
								
								<br style="clear:both;">
								<div class="alert alert-info more_info" id="enableAD">
									If this box is not checked, every parameter below will be ignored. 			
								</div>
								
							<br style="clear:both;"><br>
								<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('replaceExistingLocalUserWhenAddingAdUser')"><b>?</b></div>
								<span class="form-control pull-left form-middle form-text wth-8">Inherit from local user</span>
								<span class="chkbox-cust form-control form-right pull-left wth-1">
									<input id="chk-inherit" type="checkbox" name="replaceExistingLocalUserWhenAddingAdUser" <%=request.getAttribute("replaceExistingLocalUserWhenAddingAdUser")%> value="1">
									<label for="chk-inherit"></label>
								</span>
								
								<br style="clear:both;">
								<div class="alert alert-info more_info" id="replaceExistingLocalUserWhenAddingAdUser">
									If checked, white/black list will be copied from local user to the newly created AD user. The local user will be removed. Consider the following example:<br><br>
									Assume <b>john.smith@xyz.com</b> is a local user on your system. John has an account on your AD and his login is <b>johns</b>. 
									<br><br>
									After you enable AD in Xeams, you
									want John to use his AD credentials rather than Xeams. When he logs in the first time, Xeams will create another account that will be identified by <b>johns</b>
									and will copy the White/Black list values from his previous account to the new account. The older account (<b>john.smith@xyz.com</b>) will be deleted.
								</div>
								
								
							<br style="clear:both;"><br>
								<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('ldapUsers')"><b>?</b></div>
								<span class="form-control pull-left form-middle form-text wth-8">Integrate Users</span>
								<span class="chkbox-cust form-control form-right pull-left wth-1">
									<input id="chk-intUser" type="checkbox" name="ldapUserIntegration" <%=request.getAttribute("ldapUserIntegration")%> value="1">
									<label for="chk-intUser"></label>
								</span>
								
								<br style="clear:both;">
								<div class="alert alert-info more_info" id="ldapUsers">
									If checked, users in Xeams will be integrated with Active Directory. They can use their normal AD user id and password to login
									to the web interface.
								</div>
								
							</div> <!-- style padding10 -->
						</div>
						<div class="col-md-6">
						
							<div style="padding:10px;">
								<br style="clear:both;">
								<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('rejectInvalid')"><b>?</b></div>
								<span class="form-control pull-left form-middle form-text wth-8">Reject Invalid Users</span>
								<span class="chkbox-cust form-control form-right pull-left wth-1">
									<input id="chk-reject" type="checkbox" name="ldapUseInSmtpRcptTo" <%=request.getAttribute("ldapUseInSmtpRcptTo")%> value="1">
									<label for="chk-reject"></label>
								</span>
								
								<br style="clear:both;">
								<div class="alert alert-info more_info" id="rejectInvalid">
									Before accepting incoming emails from the Internet Xeams will check if the recipient exists in the this AD if this option is checked.
									If you are using the SMTP Proxy Server, you will have to check <b>Use Active Directory</b> option under <b>Server Configuration</b>/
									<b>Smtp Proxy Configuration</b>
								</div>
								
								
								<br style="clear:both;"><br>
								<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('autoSyncAssociatedEmailsFromAD')"><b>?</b></div>
								<span class="form-control pull-left form-middle form-text wth-8">Auto-Sync associated emails</span>
								<span class="chkbox-cust form-control form-right pull-left wth-1">
									<input id="chk-autoSyncAssociatedEmailsFromAD" type="checkbox" name="autoSyncAssociatedEmailsFromAD" <%=request.getAttribute("autoSyncAssociatedEmailsFromAD")%> value="1">
									<label for="chk-autoSyncAssociatedEmailsFromAD"></label>
								</span>
								
								<br style="clear:both;">
								<div class="alert alert-info more_info" id="autoSyncAssociatedEmailsFromAD">
									Check this option if you want Xeams to automatically update associated email addresses for users pulled from AD.
								</div>
							
							
								<br style="clear:both;">
								<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
							</div>
							
						</div>
						
					</div>
				</div>
			</div>
		
	

	
	<input type="hidden" name="operation" value="191">
	<input type="hidden" name="st" value="save">

</form>

<br style="clear:both;"><br>
<!-- 

<a href="<%=response.encodeURL("FrontController?operation=191a") %>" title="Click here to add parameters for your Active Directory"><button class="btn btn-sm btn-menu"><span class="glyphicon glyphicon-plus"></span> &nbsp; Add Active Directory</button></a>
-->


<div class="alert alert-success">
	<form action="<%= request.getAttribute("appPath") %>" method="post" class="form-inline" >
	
		<select class="form-control" name="ldapType">
		  <option value="ltExchange">Active Directory</option>
		  <option value="ltZimbra">Zimbra</option>
		  <option value="ltGeneric">Generic</option>
		</select>
	
		&nbsp;&nbsp;&nbsp;&nbsp;
		<button class="btn btn-sm btn-menu" type="submit"><span class="glyphicon glyphicon-plus"></span> &nbsp;Add Directory</button>
		<input type="hidden" name="operation" value="191a">
	</form>
</div>	
	
	
			
<%
boolean pullUsers = request.getAttribute("ldapLookupRequired") != null && request.getAttribute("ldapLookupRequired").toString().trim().length() > 2;

if(MultipleAdManager.getInstance().getCount() > 0){
	
	List<AdParams> adList = MultipleAdManager.getInstance().getAdList();
	%>
	<h2>Existing Directories</h2>

	<table class="table table-condensed table-bordered table-stripped">
	<tr><th>Friendly Name</th><th>Hostname</th><th>AD Domain</th><th>Base DN</th><th>Login</th><th>Action</th></tr>
	<%
	for(AdParams oneAd : adList){
		%>
		<tr>
			<td><%= oneAd.getFriendlyName()%></td>
			<td><%= oneAd.getLdapServer()%></td>
			<td><%= oneAd.getLdapRootName()%></td>
			<td><%= oneAd.getLdapBaseDN() %></td>
			<td><%= oneAd.getLdapUser()%></td>
			<td>
			<%
				if(pullUsers){
					%>
					<a href="<%=response.encodeURL("FrontController?operation=203&madpk=" + oneAd.getPk()) %>" title="Pull Users from AD to Xeams"><i class="fas fa-user"></i></a>&nbsp;&nbsp;
					<a href="<%=response.encodeURL("FrontController?operation=203g&madpk=" + oneAd.getPk()) %>" title="Pull Distribution list from AD to Xeams"><i class="fas fa-users"></i></a>&nbsp;&nbsp;
					<%
				}
			%>
			<a href="<%=response.encodeURL("FrontController?operation=191m&madpk=" + oneAd.getPk()) %>" title="Modify"><i class="fas fa-pen"></i></a>
			
			
			<%
			if(oneAd.getDomainCount() == 0 && oneAd.getUserCount() == 0){
			%>
				<span class="pull-right">
				<a href="<%=response.encodeURL("FrontController?operation=191r&madpk=" + oneAd.getPk()) %>" title="Remove"><i class="glyphicon glyphicon-trash"></i></a>
				</span>
			<%
			}else{
				%>
				<span class="pull-right">
					<i class="glyphicon glyphicon-trash" style="color:#dddddd" title="In-use. Cannot remove this entry."></i>
				</span>
				<%
			}
			%>
			</td>
		</tr>
		
		<%
		
	}
	%>
	</table>
	
	
	<%
	
}
		%>




<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
