<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Integrating Xeams with Let's Encrypt <small>DNS Entries</small></h1>

<%

if(request.getAttribute("errorMsg") != null){
	%>
	<div class="alert alert-danger"><h4>Error</h4><%= (String) request.getAttribute("errorMsg") %></div>
	<%
}


if(request.getAttribute("infoMsg") != null){
	%>
	<div class="alert alert-info"><%= (String) request.getAttribute("infoMsg") %></div>
	<%
}
%>


<div class="row">
	<div class="col-md-6 col-md-offset-3">
	
	Create the following TXT record in your DNS server. Confirm these values can be fetched from a machine on the 
	Internet and then click proceed below.
	
	
	<%
	List<NameValuePair> hosts = (List<NameValuePair>) request.getAttribute("hosts");
	
	for(NameValuePair host : hosts){
		%>
		<p>
		<table class="table table-bordered table-hover">
			<tr><th>DNS Host:</th><td><%= host.getName() %></td></tr>
			<tr><th>Value:</th><td><%= host.getValue() %></td></tr>
			<tr><th>TTL:</th><td>Use the smallest value allowed by your DNS provider.</td></tr>
		</table>
		</p>
		
		<p>
		<%= new DnsSubmitter().cpBtn4(request, host.getName(), host.getValue(), "txt", true) %>
		</p>
		
		<%
	}
	%>
	

	<br><br>
	<h4>Usage Tip</h4>
	Use the following command from on any computer to confirm the newly added values are available.
	
	<%
	for(NameValuePair host : hosts){
		%>
		
		<p>
		<pre>nslookup -q=txt <%= host.getName() %></pre>
		The above command should return:
		<pre><%= host.getValue() %></pre>
		</p>
		<hr>
		<%
	}
	%>
	
	
	<form action="<%= request.getAttribute("appPath") %>" method="post" name="theForm">	
		<br style="clear:both;">
		<!-- ******* Save Button | default is pulled right ******* -->
		<button class="btn btn-sm btn-submit pull-right" type="submit">Proceed</button>
		
		
		<input type="hidden" name="operation" value="259">
		<input type="hidden" name="st" value="dnsAdded">
		
	</form>
				
	</div>
</div>
<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
