<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Integrating Xeams with Let's Encrypt</h1>
<br>


<script type="text/javascript">




function contractall(){
	if (document.getElementById){
		
		document.getElementById("xeams80").style.display="none";
		document.getElementById("other80").style.display="none";
		document.getElementById("dnsLookup").style.display="none";
	}
}

function expandone(){
	if (document.getElementById){
		var selectedItem = document.leOptionTypeForm.challengeType.selectedIndex;
		contractall();
		
		if(selectedItem == 1){
			document.getElementById("other80").style.display="block";
		}else if(selectedItem == 2){
			document.getElementById("dnsLookup").style.display="block";
		}else{
			document.getElementById("xeams80").style.display="block";
		}
		
		
	}
}

if (window.addEventListener)
	window.addEventListener("load", expandone, false)
else if (window.attachEvent)
	window.attachEvent("onload", expandone)

</script>


<%
String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger">
		<h4>Error</h4>
		<%= errorMsg %>
	</div>
	<%
}



if(request.getAttribute("infoMsg") != null){
	%>
	<div class="alert alert-info"><%= (String) request.getAttribute("infoMsg") %></div>
	<%
}
%>

<div class="row">
	<div class="col-md-7">
		<!-- ******* Create Window Panel ******* -->
		<div class="well-info-wrap">
			<div class="well-info-header">What Is Let's Encrypt</div>
			<div class="well-info-body">
				Let's Encrypt is a free SSL certificate authorization that is increasingly becoming popular and accepted by most modern browsers.
				These certificates are valid for 90 days and must be renewed periodically.
				
				<h2>How It Works</h2>
				Let's Encrypt needs to confirm your server's identify before issuing a certificate. This step is called challenge. 
				You have one of two options:<br><br>
				
				<div class="alert alert-success">
					<h4>Option 1 - HTTP <small>Recommended</small></h4>
					This option requires you have a web server running on port 80. This can either be Xeams or any 
					other server, such as IIS or Apache.
					
					<%
					if(System.getProperty("http.successfully.listening.on.port.80") != null){
						%>
						<div class="well"><b>NOTE: </b> Xeams is already configured to listen on port 80, which is going to make this process easy.</div>
						<%
					}else{%>
						<div class="well"><b>TIP: </b> If you're planning to configure Xeams to listen on port 80, 
						<a href="<%=response.encodeURL("FrontController?operation=158") %>"></a>configure that prior to configuring the SSL certificate.</div>
					<%}
					%>
				</div>
				
				<div class="alert alert-success">
					<h4>Option 2 - DNS</h4>
					This option requires you to add a TXT record in your DNS server. This TXT record must be modified once every 90 days 
					with the new certificate. Since this method requires updating DNS periodically, <b>Option 1</b> is preferred.
				</div>
				
		
				
				
			</div>
		</div>
		
	</div>
	
	<div class="col-md-5">
		<form action="<%= request.getAttribute("appPath") %>" method="post" name="leOptionTypeForm">	
				<%
				PublicIPHostBean ipInfo = new PublicIPHostBean();
				String fqdnIfMissing = ipInfo.isPublicHostAvailable() ? ipInfo.getFQDN() : "mail.yourhostname.com";
				String defaultHostName = ipInfo.isPublicHostAvailable() ? ipInfo.getFQDN() : "mail.yourhostname.com";
				String hostNameForCert = (String) request.getAttribute("hnfc");
				if(hostNameForCert != null){
					defaultHostName = hostNameForCert;
				}
				%>
				
				
				<%
				if(request.getParameter("sann") != null){
					%>
					<div class="alert alert-info">
					<h4>Note</h4> The system will automatically add the hostname for <code><%= request.getParameter("sann") %></code>. 
					Do not add that host on this screen.
					
					<h4>Important</h4> Create SSL certificate for every hostname together. For example, if you're adding
					MTA-STS for 3 domains, perform this step just once for every domain.
					</div>
					
					<%
				}
				%>
			
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('hostName')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Hostname</span>
				<input class="form-control form-right pull-left wth-5" type="text" value="<%= defaultHostName%>" placeholder="Eg. mail.yourFQDN.com" name="hostName" required>
			
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="hostName">
					SSL certificates are tied to hostnames. Specify the hostname that will be used to issue the certificate.
				</div>
	
	
				
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('staging')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Test Certificate</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1"><input id="chk-srv" type="checkbox" value="1" name="staging" ><label for="chk-srv"></label></span>
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="staging">
					Check this box if you have never issued a certificate before. When this is checked, Xeams will perform every 
					task required to issue the certificate but the certificate won't be trusted.<br><br>
					Refer to 
					<code>https://letsencrypt.org/docs/staging-environment/</code> for details.
				</div>
	
				<br style="clear:both;">
				
					<span class="form-control form-left form-text pull-left wth-5">Challenge Type</span>
					<select class="form-control form-right pull-left wth-5" name="challengeType" onChange="expandone()">
					
						<%
						String ctXeams = (request.getAttribute("challengeType") == null || request.getAttribute("challengeType").equals("xeams")) ? " selected " : "";
						String ctOther = (request.getAttribute("challengeType") != null && request.getAttribute("challengeType").equals("other")) ? " selected " : "";
						String ctDns = (request.getAttribute("challengeType") != null && request.getAttribute("challengeType").equals("dns")) ? " selected " : "";
						
						%>
						<option value="xeams" <%= ctXeams %> >HTTP - Using Xeams</option>
						<option value="other" <%= ctOther %> >HTTP - Other</option>
						<option value="dns" <%= ctDns %> >DNS</option>
					</select>
					
					<div id="xeams80" class="dropcontent"> 
						<% 
						
						int port80Status = ResourceBean.getStatusForPort80();
							
						if(port80Status == 2){
						%>
							Xeams is listening on port 80. It is recommended you select this option. Let's Encrypt will send an HTTP request to 
							<code>http://<%=fqdnIfMissing %>/</code> to validate this server belongs to you and Xeams will answer this request
							automatically.
						<%
						}else if(port80Status == 1){
							%>
							Although Xeams is configured to listen on port 80, the server is not listening. Make sure to restart Xeams after changing to 
							port. Additionally, ensure no other process is listening on this port.
							
							<br><br><b>Come back this page once
							Xeams is successfully listening on port 80.</b>
							<%
						}else{
							%>
							<a href="<%=response.encodeURL("FrontController?operation=158") %>">Click here</a> to configure Xeams so it listens on port 80.
							
							<br><br><b>Come back this page once
							Xeams is successfully listening on port 80.</b>
							<%	
						}
						%>
					</div>

					<div id="other80" class="dropcontent">
						Xeams will have to copy necessary files to the root of this server. Specify the path referring to the root folder of that
						server. 
						<br><br>
						Let's Encrypt will send an HTTP request to 
							<code>http://<%=fqdnIfMissing %>/</code> to validate this server belongs to you. Xeams will copy necessary files to the 
							location specified below so the response to Let's Encrypt challenge is successful.<br>
							<a href="http://www.xeams.com/letsenc-with-iis.htm" target="_blank">Read this</a> if you're using an IIS server. 
						
						<br style="clear:both;">
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('copyPath')"><b>?</b></div>
						<span class="form-control form-middle form-text pull-left wth-4">Root Path</span>
						<input class="form-control form-right pull-left wth-5" type="text" value="" name="copyPath">
					
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="copyPath">
							Path referring to the root directory of the web server.
						</div>
				
				
						
					</div>

					<div id="dnsLookup" class="dropcontent">
						You will have to periodically update the DNS server in order for the certificate to work. You will see the actual value for the TXT record
						on the following screens.
					</div>
			
				
					<br style="clear:both;">
					<!-- ******* Save Button | default is pulled right ******* -->
					<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
					
					
					<input type="hidden" name="operation" value="259">
					<input type="hidden" name="st" value="verifyInput">
					
				</form>
	</div>
</div>

<br><br>
<div class="row">
	<div class="col-md-8 col-md-offset-2">
		<div class="alert alert-warning">
		<h4>Note</h4>
		Xeams running on your end will contact Let's Encrypt as well as Synametrics' web server during the creation
		of this certificate. Synametrics' 
		web server is used to confirm HTTP communication from the Internet to your network on port 80.
		</div>
	</div>
</div>
<!-- 

<form action="<%= request.getAttribute("appPath") %>" method="post">


	<br style="clear:both;">
	<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('ID_OF_INFO_BOX')"><b>?</b></div>
	<span class="form-control form-middle form-text pull-left wth-4">Input Title</span>
	<input class="form-control form-right pull-left wth-5" type="" name="">

	<br style="clear:both;">
	<div class="alert alert-info more_info" id="ID_OF_INFO_BOX">
		Description Here
	</div>

	<br style="clear:both;">
	<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('ID_OF_INFO_BOX')"><b>?</b></div>
	<span class="form-control form-text form-middle pull-left wth-8">Input Title</span>
	<span class="chkbox-cust form-control form-right pull-left wth-1">
		<input id="INPUT_ID" type="" name="">
		<label for="INPUT_ID"></label>
	</span>

	<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>


</form>

-->

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
