<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Integrating Xeams with Let's Encrypt <small>Status</small></h1>


<%
if(request.getAttribute("sslNotEnabled") != null){
	%>
	<div class="alert alert-warning">
		<h4>Warning</h4>
		Although you have a valid SSL certificate, you have not configured Xeams to listen on HTTPS. 
		<a href="<%=response.encodeURL("FrontController?operation=158") %>">Click here</a>
		to configure it.
	</div>
	<%
}
%>


<div class="row">
	<div class="col-md-6 col-md-offset-3">
	
	<div class="well">
	Let's Encrypt certificate has been configured and you should be able to access the web interface
	using <code>https://<%= request.getAttribute("hostName") %></code>. Your current certificate is valid until
	<b><%= request.getAttribute("expDate") %></b><br><br>
	
	
	<table class="table table-condensed table-bordered table-hover">
	<tr>
		<th>Test Certificate:</th><td><%= request.getAttribute("staging").equals("true") ? "Yes - Creating a new production certificate is recommended" : "No - It's for production use"%></td>
	</tr>
	<tr>
		<th>Challenge Type:</th><td><%= request.getAttribute("challengeType") %>
		<%
		if(request.getAttribute("challengeType") != null && request.getAttribute("challengeType").equals("dns")){
			%>
			You will have to manually renew this certificate before it expires by updating the TXT record in your DNS server.
			<%
		}
		%>
		
		</td>
	</tr>
	<%
		if(request.getAttribute("challengeType") != null && request.getAttribute("challengeType").equals("other")){
			%>
			<tr>
				<th>Web Root Path:</th><td><%= request.getAttribute("webRootPath") %></td>
			</tr>
		
			<%
		}
	%>
	</table>
	

	
	<h2>Renewal</h2>
	
	<%
	boolean isDNS = request.getAttribute("challengeType").equals("dns");
	
	if(isDNS){
		%>
		Certificates signed by Let's Encrypt must be renewed every 90 days. You must perform this operation
		again around <b><%= request.getAttribute("renewalDate") %></b>, a few days before it expires to avoid problems. 
		<%
	}else{
		%>
		Certificates signed by Let's Encrypt must be renewed every 90 days. Xeams will automatically renew the certificate
		around <b><%= request.getAttribute("renewalDate") %></b>.  
		Ensure port inbound TCP/IP port 80 stays available for Let's Encrypt to confirm the challenge.
		<%
	}
	%>
	
	<br><br>
	<a href="<%=response.encodeURL("FrontController?operation=259&rekey=true") %>">Click here</a> if you need to renew the certificate now.
	
	</div>
</div>



<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
