<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Integrating Xeams with Let's Encrypt <small>That's it!</small></h1>

<%
if(request.getAttribute("sslNotEnabled") != null){
	%>
	<div class="alert alert-warning">
		<h4>Warning</h4>
		Although you have a valid SSL certificate, you have not configured Xeams to listen on HTTPS. 
		<a href="<%=response.encodeURL("FrontController?operation=158") %>">Click here</a>
		to configure it.
	</div>
	<%
}
%>


<%
if(request.getAttribute("staging") != null && request.getAttribute("staging").equals("true")){
	%>
	<div class="alert alert-warning">
	<h4>Important</h4>
	Your current certificate was created using the staging environment for Let's Encrypt, which is for testing purposes only. 
	
	<a href="<%=response.encodeURL("FrontController?operation=259&rekey=true") %>">Click here</a> to recreate the certificate for production environment. 
	Ensure not to check the <b>Test Certificate</b> box.
	</div>
	<%
}
%>
<div class="row">
	<div class="col-md-6 col-md-offset-3">
	Congratulations. You have successfully created an SSL certificate authorized by Let's Encrypt. 
	<b>Please restart Xeams for this new certificate to take affect</b>. Once done, you should be able to bring up
	Xeams web interface using <code>https://<%= request.getAttribute("hostname") %></code>
	
	<br><br>
	<center>
		<a href="<%=response.encodeURL("FrontController?operation=70") %>" 
			title="Restart Xeams for the certificate to take affect"><button class="btn btn-sm btn-submit">Restart Xeams</button></a>
	</center>
	<h2>Renewal</h2>
	
	<%
	boolean isDNS = request.getAttribute("isDNS") != null && request.getAttribute("isDNS").equals("true");
	
	if(isDNS){
		%>
		Certificates signed by Let's Encrypt must be renewed every 90 days. You must perform this operation
		again around <%= request.getAttribute("renewalDate") %>. Xeams will send a reminder email a few days before
		the certificate expires. 
		<%
	}else{
		%>
		Certificates signed by Let's Encrypt must be renewed every 90 days. Xeams will automatically renew the certificate
		around <%= request.getAttribute("renewalDate") %>.  
		Ensure port 80 stays available for Let's Encrypt to confirm the challenge.
		<%
	}
	%>
	
	<h2>Important</h2>
	Several important files were creating during this process. It is strongly recommend you backup these files.
	These files are stored in <%= request.getAttribute("workDir") %>
	
	<br><br>
	<table class="table table-bordered">
		<thead>
		<tr><th>File name</th><th>Description</th></tr>
		</thead>
		<tr><td>domain.key</td><td>Private key for your domain</td></tr>
		<tr><td>user.key</td><td>Private key for your user account. You will need this if you need to contact Let's Encrypt</td></tr>
		<tr><td>domain-chain.crt</td><td>Your signed certificate in PEM format.</td></tr>
	</table>
	</div>
</div>



<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
