<%@ page import="com.synametrics.xeams.bean.*" %>
<%@ page import="java.util.*" %>
<%

List sideButtons = new ArrayList(5);
sideButtons.add(new UrlAnchorHolder("Logging Configuration", "current", true));


//Variables for FAQ
boolean showFAQ = true;
List faqLinks = new ArrayList(3);
FAQHandler.getInstance().displayFAQ(faqLinks, "MainMenu");
%>

<%@ include file="CommonButtons.jsp" %>
<%@ include file="NewPageHeader.jsp" %>

<%
String proxy = (String)request.getAttribute("proxy");
String staging = (String)request.getAttribute("staging");
String outbound = (String)request.getAttribute("outbound");
String performance = (String)request.getAttribute("performance");
String challengeResponse = (String)request.getAttribute("challengeResponse");
String restore = (String)request.getAttribute("restore");
String smtpQueue = (String)request.getAttribute("smtpQueue");
String successTrail = (String)request.getAttribute("successTrail");
String failureTrail = (String)request.getAttribute("failureTrail");
String proxyTrail = (String)request.getAttribute("proxyTrail");
String ndrLog = (String)request.getAttribute("ndrLog");
String userFilters = (String)request.getAttribute("userFilters");
String imapLogging = (String)request.getAttribute("imapLogging");
String pop3Logging = (String)request.getAttribute("pop3Logging");
String confirmation = (String)request.getAttribute("confirmation");
String mailingList = (String)request.getAttribute("mailingList");
String smartHost = (String)request.getAttribute("smartHost");

if(confirmation != null){
%>
<div class="alert alert-info text-center"><b>Settings Successfully Saved</b></div>
<%
}
%>

<h1>Logging Configuration</h1>

<div class="row">
	<div class="col-md-6">
		<div class="well">
			<%= productName %> uses a sophisticated mechanism to log different events within the Rules Engine.
			You can modify what gets logged to a certain extent. The table below shows a list of logs that
			are available. You can enable or disable them depending upon your need.
		</div>
	</div>
	
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">How does logging work?</div>
			<div class="well-info-body">
				When enabled <%= productName %> will log data to individual files corresponding to each type. Data will get appended to the
				file until the file size reaches 5 MB. At that point a backup copy will get created and logs will be sent to a new file.
				Therefore, for every log that you enable <%= productName %> will use up to 10MB of hard drive space.<br>
				There is no significant performance degradation when logging is turned on.
			</div>
		</div>
	</div>
</div>

<br style="clear:both;">
<form action="<%= request.getAttribute("appPath") %>" method="post">
<div class="well-info-wrap table-responsive">
	<table class="table table-striped table-bordered">
		<tr class="well-info-header text-center">
			<td><b>Log Name</b></td>
			<td><b>Action</b></td>
			<td><b>Description</b></td>
		</tr>


		<tr>
			<td>SMTP Proxy Logging</td>
			<td>
				<span class="chkbox-cust form-control pull-left">
					<input type="checkbox" id="chk-proxy" name="chkProxy" <%=proxy%> />
					<label for="chk-proxy"></label>
				</span>
			</td>
			<td>This logs SMTP communication between sender's SMTP and <%= productName %> for every e-mail
				that gets processed through the proxy server.
				<p>The log gets saved to logs/SMTPProxyConversation.log file</p>
			</td>
		</tr>


		<tr>
			<td>SMTP Staging Logging</td>
			<td>
				<span class="chkbox-cust form-control pull-left">
					<input id="chk-smtpconv" type="checkbox" name="chkStaging" <%=staging%> />
					<label for="chk-smtpconv"></label>
				</span>
			</td>
			<td>This logs SMTP communication between sender's SMTP and <%= productName %> for every e-mail
				that gets processed through the staging server.
				<p>The log gets saved to logs/SMTPConversation.log file</p>
				</td>
		</tr>


		<tr>
			<td>Outbound SMTP Logging</td>
			<td>
				<span class="chkbox-cust form-control pull-left">
					<input id="chk-outbound" type="checkbox" name="chkOutbound" <%=outbound%> />
					<label for="chk-outbound"></label>
				</span>
			</td>
			<td>This logs SMTP communication when <%= productName %> sends out messages to other SMTP
			servers, which is applies when:

			<ul>
				<li>staging server sends message to the final destination</li>
				<li>An email gets restored</li>
				<li>A challenge/response is generated</li>
			</ul>
				<p>The log gets saved to logs/SMTPOutboundConversation.log file</p>

			</td>
		</tr>

		<tr>
			<td>Performance logging</td>
			<td>
				<span class="chkbox-cust form-control pull-left">
					<input id="chk-perform" type="checkbox" name="chkPerformance" <%=performance%> />
					<label for="chk-perform"></label>
				</span>
			</td>
			<td>This logs performance metrics for any email that takes longer than 30 seconds
			to process. This information is useful in troubleshooting performance problems.
				<p>The log gets saved to logs/Performance.log file</p>
				</td>
		</tr>

		<tr>
			<td>Challenge/Response</td>
			<td>
				<span class="chkbox-cust form-control pull-left">
					<input id="chk-chalResp" type="checkbox" name="chkChallengeResponse" <%=challengeResponse%> />
					<label for="chk-chalResp"></label>
				</span>
			</td>
			<td>This logs messages that were processed by the challenge/response system. It won't
			have any data if Challenge/Response is not enabled.
				<p>The log gets saved to logs/ChallengeResponse.log file</p>
				</td>
		</tr>

		<tr>
			<td>Restoration log</td>
			<td>
				<span class="chkbox-cust form-control pull-left">
					<input id="chk-restore" type="checkbox" name="chkRestore" <%=restore%> />
					<label for="chk-restore"></label>
				</span>
			</td>
			<td>This logs the file name, subject, to, and from of messages that were quarantined by <%= productName %>
				and later restored by any user.
				<p>The log gets saved to logs/EmailRestoration.log file</p>
				</td>
		</tr>

		<tr>
			<td>SMTP Queue</td>
			<td>
				<span class="chkbox-cust form-control pull-left">
					<input id="chk-queue" type="checkbox" name="chkSmtpQueue" <%=smtpQueue%> />
					<label for="chk-queue"></label>
				</span>
			</td>
			<td>This logs information messages generated by Smtp Queue and might have
				some usefull messages if Outbound message queue gets filled up
				<p>The log gets saved to logs/SmtpQueue.log file</p>
				</td>
		</tr>


		<tr>
			<td>Audit Trail - Successful</td>
			<td>
				<span class="chkbox-cust form-control pull-left">
					<input id="chk-successTrail" type="checkbox" name="chkSuccessTrail" <%=successTrail%> />
					<label for="chk-successTrail"></label>
				</span>
			</td>
			<td>This log records the ipAddress of the receiving server, to, from, message length in bytes and subject of
				every email that goes out through the staging server. If you see a message in this log it means
				that it has been delivered to the target server. If a user claims that he/she did not get it, the
				problem is definitely on the receiving end.
				<p>The log gets saved to logs/OutboundAuditTrailSuccess.log file</p>
				</td>
		</tr>

		<tr>
			<td>Audit Trail - Failure</td>
			<td>
				<span class="chkbox-cust form-control pull-left">
					<input id="chk-failTrail" type="checkbox" name="chkFailureTrail" <%=failureTrail%> />
					<label for="chk-failTrail"></label>
				</span>
			</td>
			<td>This log records the ipAddress of the receiving server, to, from, subject and reason of
				every email that could not be delivered. Check the reason to find out why it failed.
				<p>The log gets saved to logs/OutboundAuditTrailFailure.log file</p>
				</td>
		</tr>

		<tr>
			<td>Audit Trail - Proxy</td>
			<td>
				<span class="chkbox-cust form-control pull-left">
					<input id="chk-proxyTrail" type="checkbox" name="chkProxyTrail" <%=proxyTrail%> />
					<label for="chk-proxyTrail"></label>
				</span>
			</td>
			<td>This log records the ipAddress of the receiving server, to, from, message length in bytes and subject of
				every email that goes out through the proxy server. If you see a message in this log it means
				that it has been delivered to the target server. If a user claims that he/she did not get it, the
				problem is definitely on the receiving end.
				<p>The log gets saved to logs/ProxyAuditTrail.log file</p>
				</td>
		</tr>


		<tr>
			<td>NDR Log</td>
			<td>
				<span class="chkbox-cust form-control pull-left">
					<input id="chk-NDR" type="checkbox" name="chkNDRLog" <%=ndrLog%> />
					<label for="chk-NDR"></label>
				</span>
			</td>
			<td>This logs contains a non-delivery report. First column contains TO and the second column contains
				the original recipient. The third column contains the orginal subject. Note, second and third column may not
				contain correct data.
				<p>The log gets saved to logs/ndr.log file</p>
				</td>
		</tr>

		<tr>
			<td>User Filters</td>
			<td>
				<span class="chkbox-cust form-control pull-left">
					<input id="chk-userFilter" type="checkbox" name="chkUserFilters" <%=userFilters%> />
					<label for="chk-userFilter"></label>
				</span>
			</td>
			<td>This log contains entry for user filters. When a user filter matches an incoming email, a record is entered 
			in this log file.
				<p>The log gets saved to logs/userFilters.log file</p>
				</td>
		</tr>


		<tr>
			<td>IMAP Logging</td>
			<td>
				<span class="chkbox-cust form-control pull-left">
					<input id="chk-imap" type="checkbox" name="chkImapLogging" <%=imapLogging%> />
					<label for="chk-imap"></label>
				</span>
			</td>
			<td>This logs contains IMAP communication from different clients.
				<p>The log gets saved to logs/imapConversation.log file</p>
				</td>
		</tr>
		
		<tr>
			<td>POP3 Logging</td>
			<td>
				<span class="chkbox-cust form-control pull-left">
					<input id="chk-pop" type="checkbox" name="chkPop3Logging" <%=pop3Logging%> />
					<label for="chk-pop"></label>
				</span>
			</td>
			<td>This logs contains POP3 communication from different clients.
				<p>The log gets saved to logs/pop3Conversation.log file</p>
				</td>
		</tr>
		
		
		<tr>
			<td>Mailing List Logging</td>
			<td>
				<span class="chkbox-cust form-control pull-left">
					<input id="chk-mailList" type="checkbox" name="chkMailingList" <%=mailingList%> />
					<label for="chk-mailList"></label>
				</span>
			</td>
			<td>This logs requests for subscription, removal and messages sent to mailing lists.
				</td>
		</tr>
		
		
		<tr>
			<td>Smart Host</td>
			<td>
				<span class="chkbox-cust form-control pull-left">
					<input id="chk-smartHost" type="checkbox" name="chkSmartHost" <%=smartHost%> />
					<label for="chk-smartHost"></label>
				</span>
			</td>
			<td>Logs a line for either SUCCESS or FAILURE when smart host is used.
				</td>
		</tr>
	</table>
</div>

<br style="clear:both;">
<div class="text-center">
<input class="btn btn-md btn-submit pull-right" type="submit" value="Save">
</div>

<input type="hidden" name="operation" value="118" />
</form>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
