<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->


<script>
window.onload = function() {
  document.getElementById("twofacode").focus();
};
</script>


<h1>Two-Factor Authentication</h1>


<%
String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%><br><br>
	<div class="alert alert-danger"><h4>Error</h4><%=errorMsg %></div>
	<%
}

String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%><br><br>
	<div class="alert alert-info"><%=infoMsg %></div>
	<%
}
%>


<div class="row">
	<div class="col-md-6 col-md-offset-3">
		<div class="well-info-wrap">
			<div class="well-info-header">Enter Code</div>
			<div class="well-info-body">
				<form action="<%= request.getAttribute("appPath") %>" method="post">
					<%
					String autoComplete = System.getProperty("set.login.autocomplete", "off").equals("off") ? "autocomplete=\"off\"" : "";
					
					if(request.getAttribute("tfaRecordType") != null && request.getAttribute("tfaRecordType").equals("email")){
						%>
						<h2>Two-Factor Authentication <small>via email</small></h2>
						<p>Your account has been setup for 2-Factor authentication. An email has been sent to <b><%= request.getAttribute("tfaRecordData")%></b> containing a 6 digit code. Enter that code below.</p>
						<%
					}else if(request.getAttribute("tfaRecordType") != null && request.getAttribute("tfaRecordType").equals("totp")){
						%>
						<h2>Two-Factor Authentication <small>using TOTP</small></h2>
						<p>Your account has been setup for 2-Factor authentication. Verify your identity with an authenticator app running on your phone or tablet.</p>
						<%
					}
					%>
				
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('2faText')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">2FA Code</span>
					<input class="form-control form-right pull-left wth-5" type="number" id="twofacode" name="twofacode" <%= autoComplete %>>
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="2faText">
						Enter the code
					</div>
					
					<br style="clear:both;">
					<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
					
					<input type="hidden" name="operation" value="1" />
				
					<%
					if(request.getParameter("autoLogin") != null){
						%>
						<input type="hidden" name="autoLogin" value="1">
						<%
					}
					%>
				
				</form>
				<br><br><br><br>
			
			</div>
		</div>
		
	</div>
</div>







<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
